/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.CurFetchToken;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.SrvCurDeclareToken;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvCurFetchToken
extends CurFetchToken
implements Dumpable {
    int _curlen = 0;
    public int _curId = 0;
    int _nameLen = 0;
    String _cursorName = null;
    int _type = 0;
    int _rows = 0;

    public SrvCurFetchToken(TdsInputStream tdsInputStream) throws IOException {
        this._curlen = tdsInputStream.readShort();
        this._curId = tdsInputStream.readInt();
        if (this._curId == 0) {
            this._nameLen = tdsInputStream.readUnsignedByte();
            this._cursorName = tdsInputStream.readString(this._nameLen);
        }
        this._type = tdsInputStream.readUnsignedByte();
        switch (this._type) {
            case 5: 
            case 6: {
                this._rows = tdsInputStream.readInt();
            }
        }
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        Object[] objectArray = new Object[]{"CURFETCH", new Integer(130), new Integer(2), new Integer(this._curlen), new Integer(this._curId), new Integer(this._nameLen), this._cursorName, null, null};
        DumpInfo dumpInfo = SrvCurDeclareToken.preDump(dumpFilter, objectArray);
        if (dumpFilter.includesToken(130) && (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(9))) {
            String[] stringArray = new String[]{"<unrecognized>", "CUR_NEXT", "CUR_PREV", "CUR_FIRST", "CUR_LAST", "CUR_ABS", "CUR_REL"};
            dumpInfo.addField("Type", 1, this._type, stringArray);
            dumpInfo.addInt("No. of Rows", 4, this._rows);
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 130;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CurFetchToken: ");
        stringBuffer.append(this._curId == 0 ? "curId= " + this._curId : "name= " + this._cursorName);
        stringBuffer.append(", type = " + this._type);
        stringBuffer.append(", row# = " + this._rows);
        return stringBuffer.toString();
    }

    public String getFetchCurCommand() {
        String string = "fetch ";
        switch (this._type) {
            case 1: {
                string = string + "next ";
                break;
            }
            case 2: {
                string = string + "prior ";
                break;
            }
            case 3: {
                string = string + "first ";
                break;
            }
            case 4: {
                string = string + "last ";
                break;
            }
            case 5: {
                string = string + "absolute " + this._rows;
                break;
            }
            case 6: {
                string = string + "relative " + this._rows;
            }
        }
        string = this._curId == 0 ? string + "from " + this._cursorName : string + "from cursor [ID: " + HexConverts.hexConvert((int)this._curId, (int)4) + "]";
        return string;
    }

    public String getCursorName() {
        return this._cursorName;
    }

    public int getCursorId() {
        return this._curId;
    }
}

