/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.CurOpenToken;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.SrvCurDeclareToken;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvCurOpenToken
extends CurOpenToken
implements Dumpable {
    int _curlen = 0;
    int _curId = 0;
    int _nameLen = 0;
    String _cursorName = null;
    int _status = 0;

    public SrvCurOpenToken(TdsInputStream tdsInputStream) throws IOException {
        this._curlen = tdsInputStream.readShort();
        this._curId = tdsInputStream.readInt();
        if (this._curId == 0) {
            this._nameLen = tdsInputStream.readUnsignedByte();
            this._cursorName = tdsInputStream.readString(this._nameLen);
        }
        this._status = tdsInputStream.readUnsignedByte();
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        Object[] objectArray = new Object[]{"CUROPEN", new Integer(132), new Integer(2), new Integer(this._curlen), new Integer(this._curId), new Integer(this._nameLen), this._cursorName, null, new Integer(this._status)};
        DumpInfo dumpInfo = SrvCurDeclareToken.preDump(dumpFilter, objectArray);
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 132;
    }

    public boolean hasParams() {
        return this._status == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CurOpenToken: ");
        stringBuffer.append(this._curId == 0 ? "curId= " + this._curId : "name= " + this._cursorName);
        stringBuffer.append(", status= " + this._status);
        return stringBuffer.toString();
    }

    public String getOpenCurCommand() {
        String string = this._curId == 0 ? "open " + this._cursorName + "\n" : "open cursor [ID: " + HexConverts.hexConvert((int)this._curId, (int)4) + "]\n";
        return string;
    }

    public String getCursorName() {
        return this._cursorName;
    }

    public int getCursorId() {
        return this._curId;
    }
}

