/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.SrvBulkException;
import com.sybase.jdbc42.tds.SrvPdu;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.utils.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;

public class SrvDataInputStream
extends TdsInputStream {
    private SrvPdu _pdu = new SrvPdu();
    private byte[] _packet = null;
    private CharsetDecoder _btcc = null;

    public SrvDataInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this._btcc = Charset.forName(this._pdu._charset).newDecoder();
        this.setPacketSize(this._pdu._packetSize);
    }

    public void setEncoding(String string) throws IOException {
        this._pdu._charset = string;
        this._btcc = Charset.forName(this._pdu._charset).newDecoder();
    }

    public String getCharset() {
        return this._pdu._charset;
    }

    public void setPacketSize(int n) {
        Debug.asrt((this._last < 0 || this._last == this._next ? 1 : 0) != 0, (String)"TDS input buffer in use, cannot reset packetsize");
        this._pdu._packetSize = n;
        this._packet = new byte[this._pdu._packetSize];
    }

    public int read() throws IOException {
        if (this._next >= this._last) {
            if (this._pdu._inBulk && (this._pdu._msgStatus & 1) != 0) {
                return -1;
            }
            this.fill();
        }
        return this._packet[this._next++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 == 0 ? -1 : n4;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)n < l) {
            if (this.read() == -1) {
                throw new EOFException("TDS data input stream lost connection");
            }
            ++n;
        }
        return n;
    }

    private void fill() throws IOException {
        int n = 0;
        while (this._last <= this._next) {
            int n2;
            n = this.in.read(this._packet, 0, SrvPdu.size());
            if (n < 0) {
                throw new EOFException("TDS data input stream lost connection");
            }
            this._pdu.setpdu(this._packet);
            for (n2 = 0; n2 < this._pdu.dataLength(); n2 += n) {
                n = this.in.read(this._packet, SrvPdu.size() + n2, this._pdu.dataLength() - n2);
                if (n >= 0) continue;
                throw new EOFException("TDS data input stream lost connection");
            }
            this._next = SrvPdu.size();
            this._last = n2 + this._next;
            if (!this._pdu.bulkOccurred()) continue;
            throw new SrvBulkException();
        }
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public final String readString(int n) throws IOException {
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        while (n > 0) {
            int n2 = this.read(byArray, byArray.length - n, n);
            if (n2 == -1) {
                throw new IOException("Unexpected end of data from client");
            }
            n -= n2;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        String string = null;
        try {
            string = new String(this._btcc.decode(byteBuffer).array());
        }
        catch (MalformedInputException malformedInputException) {
            string = "\"\n\n>>>> " + malformedInputException + ": Error while decoding char data in " + this._pdu._charset;
        }
        return string;
    }

    public final String readUnicodeString(int n) throws IOException {
        int n2;
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = n; i > 0; i -= n2) {
            n2 = this.read(byArray, n - i, i);
            if (n2 != -1) continue;
            throw new IOException("Unexpected end of data from client");
        }
        return this.convertUnicodeBytesToString(byArray);
    }

    public final String convertUnicodeBytesToString(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n == 0) {
            return null;
        }
        String string = null;
        String string2 = null;
        string2 = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
        try {
            string = new String(byArray, 0, n, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public final String convertBytesToString(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        String string = null;
        try {
            string = new String(this._btcc.decode(byteBuffer).array());
        }
        catch (MalformedInputException malformedInputException) {
            string = "\"\n\n>>>> " + malformedInputException + ": Error while decoding char data in " + this._pdu._charset;
        }
        return string;
    }

    protected void bulkDone() {
        this._pdu._inBulk = false;
    }

    public int getCurrentPDUType() {
        return this._pdu._msgType;
    }

    public int getCurrentPDULength() {
        return this._pdu._length;
    }

    public int getCurrentPDUStatus() {
        return this._pdu._msgStatus;
    }
}

