/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.charset.CharsetUtil;
import com.sybase.jdbc42.tds.SrvPdu;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.utils.Debug;
import com.sybase.jdbcx.CharsetConverter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;

public class SrvDataOutputStream
extends TdsOutputStream {
    private SrvPdu _pdu = new SrvPdu();
    private boolean _bufstatEvent = false;
    CharsetConverter _ctbc = null;
    protected int _last = 7;
    private byte[] _buf;

    public SrvDataOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this._buf = new byte[this._pdu._packetSize];
    }

    public void setEncoding(String string) {
        this._pdu._charset = string;
    }

    public void setPacketSize(int n) {
        Debug.asrt((this._last == 7 ? 1 : 0) != 0, (String)"Buffer in use, cannot reset packetsize");
        this._pdu._packetSize = n;
        this._buf = new byte[this._pdu._packetSize];
    }

    public void setAttention() {
        this._pdu._msgStatus |= 2;
    }

    public void setNotify() {
        this._bufstatEvent = true;
    }

    public void write(int n) throws IOException {
        if (this._last == this._buf.length - 1) {
            this.flush(false);
        }
        this._buf[++this._last] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n2 > 0) {
            int n4;
            if (this._last >= this._buf.length - 1) {
                this.flush(false);
            }
            int n5 = (n4 = this._buf.length - this._last - 1) < n2 - n ? n4 : n2 - n;
            System.arraycopy(byArray, n3, this._buf, this._last + 1, n5);
            this._last += n5;
            n2 -= n5;
            n3 += n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean bl) throws IOException {
        if (this._bufstatEvent) {
            this._pdu._msgStatus |= 8;
            this._pdu.setpdu(this._buf, bl, this._last + 1, 16);
        } else {
            this._pdu.setpdu(this._buf, bl, this._last + 1, 15);
        }
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(this._buf, 0, this._pdu._length);
            this.out.flush();
        }
        this._pdu.setpdu();
        this._last = 7;
    }

    public String getCharset() {
        return this._pdu._charset;
    }

    public int getPacketSize() {
        return this._pdu._packetSize;
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        try {
            if (this._pdu._charset == null) {
                throw new CharConversionException("no charset defined");
            }
            if (this._pdu._charset.equals("x-SybUTF8")) {
                return CharsetUtil.fromSybUTF8((String)string);
            }
            return string.getBytes(CharsetUtil.getCharset((String)this._pdu._charset));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new CharConversionException(unsupportedCharsetException.toString());
        }
    }
}

