/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.tds.Token;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvErrorToken
extends Token
implements Dumpable {
    protected int _totalLen;
    protected int _msgNumber;
    protected int _state;
    protected int _class;
    protected int _msgLen;
    protected String _msg;
    protected int _serverNameLen;
    protected String _serverName;
    protected int _procNameLen;
    protected String _procName;
    protected int _lineNum;

    public SrvErrorToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLen = tdsInputStream.readShort();
        this._msgNumber = tdsInputStream.readInt();
        this._state = tdsInputStream.readUnsignedByte();
        this._class = tdsInputStream.readUnsignedByte();
        this._msgLen = tdsInputStream.readShort();
        this._msg = tdsInputStream.readString(this._msgLen);
        this._serverNameLen = tdsInputStream.readUnsignedByte();
        this._serverName = tdsInputStream.readString(this._serverNameLen);
        this._procNameLen = tdsInputStream.readUnsignedByte();
        this._procName = tdsInputStream.readString(this._procNameLen);
        this._lineNum = tdsInputStream.readShort();
    }

    public SrvErrorToken(int n, int n2, int n3, String string, String string2, String string3, int n4) {
        this._msgNumber = n;
        this._state = n2;
        this._class = n3;
        this._msg = string == null ? new String() : string;
        this._msgLen = this._msg.length();
        this._serverName = string2 == null ? new String() : string2;
        this._serverNameLen = this._serverName.length();
        this._procName = string3 == null ? new String() : string3;
        this._procNameLen = this._procName.length();
        this._lineNum = n4;
        this._totalLen = 8 + this._msgLen + 1 + this._serverNameLen + 1 + this._procNameLen + 2;
    }

    public SrvErrorToken(int n, String string, String string2, String string3, int n2) {
        this(n, 0, 11, string, string2, string3, n2);
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(170);
        byte[] byArray = tdsOutputStream.stringToByte(this._msg);
        byte[] byArray2 = tdsOutputStream.stringToByte(this._serverName);
        byte[] byArray3 = tdsOutputStream.stringToByte(this._procName);
        tdsOutputStream.writeShort(this._totalLen);
        tdsOutputStream.writeInt(this._msgNumber);
        tdsOutputStream.writeByte(this._state);
        tdsOutputStream.writeByte(this._class);
        tdsOutputStream.writeShort(byArray.length);
        tdsOutputStream.write(byArray);
        if (byArray2.length == 0) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray2.length);
            tdsOutputStream.write(byArray2);
        }
        if (byArray3.length == 0) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray3.length);
            tdsOutputStream.write(byArray3);
        }
        tdsOutputStream.writeShort(this._lineNum);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(": ");
        stringBuffer.append(this._msgNumber);
        return stringBuffer.toString();
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(170)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ERROR Token (0x" + HexConverts.hexConvert((int)170, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ERROR Token");
            }
            dumpInfo.addInfo(this.dumpDetails(dumpFilter));
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 170;
    }

    public int getErrId() {
        return this._msgNumber;
    }

    public String getMessageText() {
        return this._msg;
    }

    public int getErrClass() {
        return this._class;
    }

    public int getErrState() {
        return this._state;
    }

    protected DumpInfo dumpDetails(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesDetail(1)) {
            dumpInfo = dumpFilter.getDumpInfo();
            dumpInfo.addInt("Length", 2, this._totalLen);
        }
        if (dumpFilter.includesDetail(3)) {
            dumpInfo = dumpFilter.getDumpInfo();
            dumpInfo.addInt("Message Number", 4, this._msgNumber);
            dumpInfo.addInt("Message State", 1, this._state);
            dumpInfo.addInt("Message Class", 1, this._class);
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Message Length", 2, this._msgLen);
            }
            dumpInfo.addText("Message Text", this._msgLen, this._msg);
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Server Name Length", 1, this._serverNameLen);
            }
            if (this._serverNameLen > 0) {
                dumpInfo.addText("Server Name", this._serverNameLen, this._serverName);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Stored Proc. Name Length", 1, this._procNameLen);
            }
            if (this._procNameLen > 0) {
                dumpInfo.addText("Stored Proc. Name", this._procNameLen, this._procName);
            }
            dumpInfo.addInt("Line Number", 2, this._lineNum);
        }
        return dumpInfo;
    }
}

