/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.Convert;
import com.sybase.jdbc42.jdbc.DateObject;
import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.tds.BlobOutputStream;
import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.SrvBlobInputStream;
import com.sybase.jdbc42.tds.SrvCapabilityToken;
import com.sybase.jdbc42.tds.SrvDataFormat;
import com.sybase.jdbc42.tds.SrvDataToken;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.SrvKeyToken;
import com.sybase.jdbc42.tds.SrvParamDataFormat2;
import com.sybase.jdbc42.tds.SrvParamFormat2Token;
import com.sybase.jdbc42.tds.SrvRowDataFormat2;
import com.sybase.jdbc42.tds.SrvRowFormat2Token;
import com.sybase.jdbc42.tds.SrvTextImageData;
import com.sybase.jdbc42.tds.SrvTypeException;
import com.sybase.jdbc42.tds.SrvTypeFormatter;
import com.sybase.jdbc42.tds.SrvVarCharData;
import com.sybase.jdbc42.tds.SybBigDecimal;
import com.sybase.jdbc42.tds.TdsDateTime;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsNumeric;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.tds.Token;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class SrvJavaTypeFormatter
extends SrvTypeFormatter {
    private static final int BUF_SIZE = 2048;
    protected static final int COLSTATUS_NOT_SET = 9999;
    protected static final int SERIALIZATION_TYPE_NOT_SET = 9999;
    protected static final int LENGTH_NOT_SET = -999;
    protected Object[] _data = null;
    private int[] _dataLengths = null;
    private int[] _colStatus = null;
    private int[] _serializationTypes = null;
    private long[] _lobLengths = null;
    private int[] _locatorLengths = null;
    private Object[] _locators = null;
    private int _columnNo = 0;
    private int _lastColumnIndex = 0;
    private boolean _mustConvertChars = true;

    public SrvJavaTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        this(srvFormatToken, srvCapabilityToken, true);
    }

    public SrvJavaTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken, boolean bl) {
        super(srvFormatToken, srvCapabilityToken);
        this._mustConvertChars = bl;
    }

    public void addFormat(Object object, String string, int n, int n2) throws IOException, SrvTypeException {
        this.addFormat(object, string, n, n2, null);
    }

    public void addFormat(Object object, String string, int n, int n2, String string2) throws IOException, SrvTypeException {
        this.addFormat(object, null, null, null, null, string, n, n2);
    }

    public void addFormat(Object object, String string, String string2, String string3, String string4, String string5, int n, int n2) throws IOException, SrvTypeException {
        int n3 = 0;
        if (object == null) {
            object = new Object();
        }
        if (object instanceof String) {
            if (n2 > 0 && n2 <= 255) {
                n3 = 47;
            } else if (n2 > 255) {
                n3 = 175;
            } else {
                n2 = 255;
                n3 = 39;
            }
        } else if (object instanceof Boolean) {
            n3 = 50;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 255) {
                n2 = Integer.MAX_VALUE;
                n3 = 225;
            } else {
                n3 = 37;
                n2 = 255;
            }
        } else if (object instanceof Byte) {
            n3 = 38;
            n2 = 1;
        } else if (object instanceof Short) {
            n3 = 38;
            n2 = 2;
        } else if (object instanceof Integer) {
            n3 = 38;
            n2 = 4;
        } else if (object instanceof Long) {
            n3 = 38;
            n2 = 8;
        } else if (object instanceof Float) {
            n3 = 59;
        } else if (object instanceof Double) {
            n3 = 62;
        } else if (object instanceof Date) {
            if (this._cap.handlesDataType(49)) {
                n3 = 123;
                n2 = 4;
            } else {
                n3 = 111;
                n2 = 8;
            }
        } else if (object instanceof Time) {
            if (this._cap.handlesDataType(51)) {
                n3 = 147;
                n2 = 4;
            } else {
                n3 = 111;
                n2 = 8;
            }
        } else if (object instanceof java.util.Date || object instanceof Calendar) {
            n3 = 111;
            n2 = 8;
        } else if (object instanceof InputStream) {
            n3 = 9220;
            n2 = -1;
        } else if (object instanceof Reader) {
            n3 = 9219;
            n2 = -1;
        } else if (object instanceof SrvTextImageData) {
            n3 = 34;
            n2 = Integer.MAX_VALUE;
        } else {
            n3 = 9217;
            n2 = -1;
        }
        if (this._format instanceof SrvParamFormat2Token) {
            ((SrvParamFormat2Token)this._format).addFormat(new SrvParamDataFormat2(string5, n3, n, n2, object));
        } else if (this._format instanceof SrvRowFormat2Token) {
            ((SrvRowFormat2Token)this._format).addFormat((DataFormat)new SrvRowDataFormat2(string, string2, string3, string4, string5, n3, n, n2, 0, 0, object));
        } else {
            this._format.addFormat(new SrvDataFormat(string5, n3, n, n2, object));
        }
    }

    public void addFormat(DataFormat dataFormat) throws IOException, SrvTypeException {
        this._format.addFormat(dataFormat);
    }

    public void convertData(Token token, Object[] objectArray) throws IOException {
        this.setFormatter(token, this);
        this._data = objectArray;
    }

    @Override
    public void sendDataStream(TdsOutputStream tdsOutputStream) throws IOException {
        if (this._data.length != this._format.getFormatCount()) {
            throw new SrvTypeException("Format to data item count is off, " + this._data.length + " data items and " + this._format.getFormatCount() + " formats");
        }
        for (int i = 0; i < this._data.length; ++i) {
            this.sendData(tdsOutputStream, this._data[i], this._format.formatAt(i));
        }
    }

    protected void sendData(TdsOutputStream tdsOutputStream, Object object, DataFormat dataFormat) throws IOException, SrvTypeException {
        if (object == null) {
            // empty if block
        }
        block8 : switch (dataFormat._datatype) {
            case 50: {
                if (((Boolean)object).booleanValue()) {
                    tdsOutputStream.writeByte(1);
                    break;
                }
                tdsOutputStream.writeByte(0);
                break;
            }
            case 37: 
            case 45: 
            case 225: {
                if (object == null) {
                    if (dataFormat._datatype == 225) {
                        tdsOutputStream.writeInt(0);
                        break;
                    }
                    tdsOutputStream.writeByte(0);
                    break;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (dataFormat._datatype == 225) {
                        tdsOutputStream.writeInt(byArray.length);
                    } else {
                        tdsOutputStream.writeByte(byArray.length);
                    }
                    tdsOutputStream.write(byArray);
                    break;
                }
                if (object instanceof Byte) {
                    tdsOutputStream.writeByte(1);
                    tdsOutputStream.writeByte((int)((Byte)object).byteValue());
                    break;
                }
                throw new SrvTypeException("Expected Byte or Byte[], got " + object.getClass().getName());
            }
            case 39: 
            case 47: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                byte[] byArray = tdsOutputStream.stringToByte((String)object);
                tdsOutputStream.writeByte(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 175: {
                if (object == null) {
                    tdsOutputStream.writeInt(0);
                    break;
                }
                byte[] byArray = tdsOutputStream.stringToByte((String)object);
                tdsOutputStream.writeInt(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 48: {
                tdsOutputStream.writeByte(((Number)object).intValue());
                break;
            }
            case 52: {
                tdsOutputStream.writeShort(((Number)object).intValue());
                break;
            }
            case 56: {
                tdsOutputStream.writeInt(((Number)object).intValue());
                break;
            }
            case 191: {
                tdsOutputStream.writeLong(((Number)object).longValue());
                break;
            }
            case 59: {
                tdsOutputStream.writeFloat(((Number)object).floatValue());
                break;
            }
            case 62: {
                tdsOutputStream.writeDouble(((Number)object).doubleValue());
                break;
            }
            case 109: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(dataFormat._length);
                switch (dataFormat._length) {
                    case 4: {
                        tdsOutputStream.writeFloat(((Number)object).floatValue());
                        break;
                    }
                    case 8: {
                        tdsOutputStream.writeDouble(((Number)object).doubleValue());
                    }
                }
                break;
            }
            case 38: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(dataFormat._length);
                try {
                    switch (dataFormat._length) {
                        case 1: {
                            tdsOutputStream.writeByte((int)((Number)object).byteValue());
                            break;
                        }
                        case 2: {
                            tdsOutputStream.writeShort((int)((Number)object).shortValue());
                            break;
                        }
                        case 4: {
                            tdsOutputStream.writeInt(((Number)object).intValue());
                            break;
                        }
                        case 8: {
                            tdsOutputStream.writeLong(((Number)object).longValue());
                        }
                    }
                    break;
                }
                catch (ClassCastException classCastException) {
                    throw new SrvTypeException("Object does not match data format requested");
                }
            }
            case 187: 
            case 188: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject((Object)object, null, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_BIGDATIMEN or TDS_BIGTIMEM: " + sQLException);
                }
                long l = TdsDateTime.tdsDateTime((DateObject)dateObject, (int)dataFormat._datatype);
                tdsOutputStream.writeByte(8);
                tdsOutputStream.writeLong(l);
                break;
            }
            case 61: {
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject((Object)object, null, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_DATIMN: " + sQLException);
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeInt(nArray[0]);
                tdsOutputStream.writeInt(nArray[1]);
                break;
            }
            case 111: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject((Object)object, null, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_DATIMN: " + sQLException);
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeByte(8);
                tdsOutputStream.writeInt(nArray[0]);
                tdsOutputStream.writeInt(nArray[1]);
                break;
            }
            case 123: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject((Object)object, null, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_DATEN: " + sQLException);
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeByte(4);
                tdsOutputStream.writeInt(nArray[0]);
                break;
            }
            case 147: {
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                DateObject dateObject = null;
                try {
                    dateObject = Convert.objectToDateObject((Object)object, null, null);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Cannot cast " + object.getClass().getName() + " to a TDS_TIMEN: " + sQLException);
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeByte(4);
                tdsOutputStream.writeInt(nArray[1]);
                break;
            }
            case 36: {
                switch (dataFormat._blobType) {
                    case 1: {
                        tdsOutputStream.writeByte(1);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            break block8;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)blobOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        break block8;
                    }
                    case 4: {
                        int n;
                        tdsOutputStream.writeByte(0);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            break block8;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                        InputStream inputStream = (InputStream)object;
                        byte[] byArray = new byte[2048];
                        while ((n = inputStream.read(byArray)) >= 0) {
                            blobOutputStream.write(byArray, 0, n);
                        }
                        blobOutputStream.close();
                        break block8;
                    }
                    case 3: {
                        int n;
                        tdsOutputStream.writeByte(0);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            break block8;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, tdsOutputStream.getCharset());
                        char[] cArray = new char[2048];
                        Reader reader = (Reader)object;
                        while ((n = reader.read(cArray)) >= 0) {
                            outputStreamWriter.write(cArray, 0, n);
                        }
                        outputStreamWriter.flush();
                        blobOutputStream.close();
                        break block8;
                    }
                    case 5: {
                        tdsOutputStream.writeByte(0);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            break block8;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                        if (object instanceof InputStream) {
                            int n;
                            InputStream inputStream = (InputStream)object;
                            byte[] byArray = new byte[2048];
                            while ((n = inputStream.read(byArray)) >= 0) {
                                if (n % 2 != 0) {
                                    int n2 = inputStream.read();
                                    if (n2 == -1) break;
                                    byArray[n++] = (byte)n2;
                                }
                                blobOutputStream.write(byArray, 0, n);
                            }
                            blobOutputStream.close();
                            break block8;
                        }
                        if (object instanceof Reader) {
                            int n;
                            Reader reader = (Reader)object;
                            char[] cArray = new char[2048];
                            OutputStreamWriter outputStreamWriter = null;
                            outputStreamWriter = !tdsOutputStream.getBigEndian() ? new OutputStreamWriter((OutputStream)blobOutputStream, "UnicodeLittleUnmarked") : new OutputStreamWriter((OutputStream)blobOutputStream, "UnicodeBigUnmarked");
                            while ((n = reader.read(cArray)) >= 0) {
                                outputStreamWriter.write(cArray, 0, n);
                            }
                            outputStreamWriter.flush();
                            blobOutputStream.close();
                            break block8;
                        }
                        throw new SrvTypeException("Need an InputStream or Reader when sending BLOB_UTF16 data. Passed-in value was " + object.getClass().getName());
                    }
                }
                break;
            }
            case 106: 
            case 108: {
                SybBigDecimal sybBigDecimal;
                if (object == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                try {
                    sybBigDecimal = new SybBigDecimal((BigDecimal)object, dataFormat._precision, dataFormat._scale);
                }
                catch (SQLException sQLException) {
                    throw new SrvTypeException("Unable to convert object to decimal: " + object.getClass().getName());
                }
                int[] nArray = new int[4];
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)sybBigDecimal, (int)dataFormat._scale, (int[])nArray, (boolean)false);
                tdsOutputStream.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                tdsOutputStream.write(byArray);
                break;
            }
            case 34: 
            case 35: 
            case 174: {
                if (object == null || object instanceof SrvTextImageData && ((SrvTextImageData)object).isNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                if (!(object instanceof SrvTextImageData)) {
                    throw new SrvTypeException("Unmappable IMAGE, TEXT or UNITEXT data type: " + object.getClass().getName());
                }
                SrvTextImageData srvTextImageData = (SrvTextImageData)object;
                tdsOutputStream.writeByte(srvTextImageData.getTextPtrLength());
                tdsOutputStream.write(srvTextImageData.getTextPtr());
                tdsOutputStream.writeLong(srvTextImageData.getTimeStamp());
                if (srvTextImageData._bytes != null) {
                    tdsOutputStream.writeInt(srvTextImageData.getLength());
                    tdsOutputStream.write(srvTextImageData._bytes);
                    break;
                }
                if (srvTextImageData._byteStream != null) {
                    tdsOutputStream.writeInt(srvTextImageData.getLength());
                    try {
                        int n = srvTextImageData._byteStream.read();
                        while (n != -1) {
                            tdsOutputStream.write(n);
                            n = srvTextImageData._byteStream.read();
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SrvTypeException("Problem reading SrvTextImageData InputStream:" + iOException);
                    }
                }
                throw new SrvTypeException("Invalid construction of SrvTextImageData: no data!!!");
            }
            default: {
                throw new SrvTypeException("Unmappable java data type: " + object.getClass().getName());
            }
        }
    }

    public Object[] convertData(Token token) throws IOException {
        Object[] objectArray = new Object[this._format.getFormatCount()];
        this._dataLengths = new int[this._format.getFormatCount()];
        this._colStatus = new int[this._format.getFormatCount()];
        this._serializationTypes = new int[this._format.getFormatCount()];
        this._lobLengths = new long[this._format.getFormatCount()];
        this._locatorLengths = new int[this._format.getFormatCount()];
        this._locators = new Object[this._format.getFormatCount()];
        for (int i = 0; i < this._serializationTypes.length; ++i) {
            this._serializationTypes[i] = 9999;
            this._lobLengths[i] = -999L;
            this._locatorLengths[i] = -999;
            this._locators[i] = -999;
        }
        TdsInputStream tdsInputStream = null;
        this._lastColumnIndex = objectArray.length - 1;
        int n = 0;
        while (n < objectArray.length) {
            if (token instanceof SrvDataToken) {
                tdsInputStream = ((SrvDataToken)token).getStream();
            }
            if (!(token instanceof SrvKeyToken) || token instanceof SrvKeyToken && (this._format.formatAt((int)n)._status & 6) != 0) {
                objectArray[n] = this.receiveData(tdsInputStream, this._format.formatAt(n));
            }
            ++n;
            ++this._columnNo;
        }
        return objectArray;
    }

    public int[] getDataLengths() {
        return this._dataLengths;
    }

    public int[] getColumnStatusBytes() {
        return this._colStatus;
    }

    public int[] getSerializationTypes() {
        return this._serializationTypes;
    }

    public SrvFormatToken getDataFormats() {
        return this._format;
    }

    public int[] getLengthSizes() {
        int n = this._format.getFormatCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            DataFormat dataFormat = this._format.formatAt(i);
            nArray[i] = DataFormat.lengthSize((int)dataFormat._datatype);
        }
        return nArray;
    }

    protected Object receiveData(TdsInputStream tdsInputStream, DataFormat dataFormat) throws IOException, SrvTypeException {
        int n;
        boolean bl = false;
        if (dataFormat._colStatusBytePresent) {
            n = tdsInputStream.readByte();
            this._colStatus[this._columnNo] = n;
            if ((n & 1) != 0) {
                this._dataLengths[this._columnNo] = 0;
                return null;
            }
            if (n == 0) {
                bl = true;
            }
        } else {
            this._colStatus[this._columnNo] = 9999;
        }
        switch (dataFormat._datatype) {
            case 50: {
                this._dataLengths[this._columnNo] = 1;
                return new Boolean(tdsInputStream.readByte() == 0);
            }
            case 37: 
            case 45: 
            case 225: {
                int n2;
                this._dataLengths[this._columnNo] = n;
                if (n == 0) {
                    if (!bl) {
                        return null;
                    }
                    return new byte[0];
                }
                if (dataFormat.isUnitype()) {
                    return tdsInputStream.readUnicodeString(n);
                }
                byte[] byArray = new byte[n];
                for (n = dataFormat._datatype == 225 ? tdsInputStream.readInt() : tdsInputStream.readUnsignedByte(); n > 0; n -= n2) {
                    n2 = tdsInputStream.read(byArray, byArray.length - n, n);
                    if (n2 != -1) continue;
                    throw new IOException("Unexpected end of data from client");
                }
                return byArray;
            }
            case 47: {
                int n3;
                this._dataLengths[this._columnNo] = n3 = tdsInputStream.readUnsignedByte();
                if (n3 == 0) {
                    return null;
                }
                if (this._mustConvertChars) {
                    return tdsInputStream.readString(n3);
                }
                byte[] byArray = new byte[n3];
                tdsInputStream.read(byArray);
                return new SrvVarCharData(byArray, tdsInputStream.getCharset());
            }
            case 39: 
            case 103: 
            case 104: {
                int n4;
                this._dataLengths[this._columnNo] = n4 = tdsInputStream.readUnsignedByte();
                if (n4 == 0) {
                    if (bl) {
                        return "";
                    }
                    return null;
                }
                if (this._mustConvertChars) {
                    return tdsInputStream.readString(n4);
                }
                byte[] byArray = new byte[n4];
                tdsInputStream.read(byArray);
                return new SrvVarCharData(byArray, tdsInputStream.getCharset());
            }
            case 175: {
                int n5;
                this._dataLengths[this._columnNo] = n5 = tdsInputStream.readInt();
                if (n5 == 0 && bl) {
                    return "";
                }
                return tdsInputStream.readString(n5);
            }
            case 48: {
                this._dataLengths[this._columnNo] = 1;
                return new Byte(tdsInputStream.readByte());
            }
            case 52: {
                this._dataLengths[this._columnNo] = 2;
                return new Short(tdsInputStream.readShort());
            }
            case 65: {
                this._dataLengths[this._columnNo] = 4;
                return new Integer(tdsInputStream.readUnsignedShortAsInt());
            }
            case 56: {
                this._dataLengths[this._columnNo] = 4;
                return new Integer(tdsInputStream.readInt());
            }
            case 66: {
                this._dataLengths[this._columnNo] = 8;
                return new Long(tdsInputStream.readUnsignedIntAsLong());
            }
            case 191: {
                this._dataLengths[this._columnNo] = 8;
                return new Long(tdsInputStream.readLong());
            }
            case 67: {
                this._dataLengths[this._columnNo] = 8;
                return tdsInputStream.readUnsignedLongAsBigDecimal();
            }
            case 68: {
                int n6;
                this._dataLengths[this._columnNo] = n6 = tdsInputStream.readUnsignedByte();
                if (n6 == 0) {
                    return null;
                }
                switch (n6) {
                    case 1: {
                        return new Byte(tdsInputStream.readByte());
                    }
                    case 2: {
                        return new Integer(tdsInputStream.readUnsignedShortAsInt());
                    }
                    case 4: {
                        return new Long(tdsInputStream.readUnsignedIntAsLong());
                    }
                    case 8: {
                        return tdsInputStream.readUnsignedLongAsBigDecimal();
                    }
                }
                throw new SrvTypeException("Unmappable TDS data UINTN type received: length " + n6);
            }
            case 38: {
                int n7;
                this._dataLengths[this._columnNo] = n7 = tdsInputStream.readUnsignedByte();
                if (n7 == 0) {
                    return null;
                }
                switch (n7) {
                    case 1: {
                        return new Byte(tdsInputStream.readByte());
                    }
                    case 2: {
                        return new Short(tdsInputStream.readShort());
                    }
                    case 4: {
                        return new Integer(tdsInputStream.readInt());
                    }
                    case 8: {
                        return new Long(tdsInputStream.readLong());
                    }
                }
                throw new SrvTypeException("Unmappable TDS data INTN type received: length " + n7);
            }
            case 59: {
                this._dataLengths[this._columnNo] = 4;
                return this.readFLTN(tdsInputStream, 4);
            }
            case 62: {
                this._dataLengths[this._columnNo] = 8;
                return this.readFLTN(tdsInputStream, 8);
            }
            case 109: {
                int n8;
                this._dataLengths[this._columnNo] = n8 = tdsInputStream.readUnsignedByte();
                return this.readFLTN(tdsInputStream, n8);
            }
            case 106: 
            case 108: {
                int n9;
                this._dataLengths[this._columnNo] = n9 = tdsInputStream.readUnsignedByte();
                if (n9 == 0) {
                    return null;
                }
                byte[] byArray = new byte[n9];
                tdsInputStream.read(byArray);
                dataFormat._precision = TdsNumeric.NUME_MAXPREC;
                return TdsNumeric.numericValue((byte[])byArray, (int)dataFormat._precision, (int)dataFormat._scale);
            }
            case 58: 
            case 61: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readDATETIMN(tdsInputStream, dataFormat._length);
            }
            case 187: 
            case 188: {
                int n10;
                this._dataLengths[this._columnNo] = n10 = tdsInputStream.readUnsignedByte();
                return this.readBIGDATETIMN(tdsInputStream, n10, dataFormat._datatype);
            }
            case 111: {
                int n11;
                this._dataLengths[this._columnNo] = n11 = tdsInputStream.readUnsignedByte();
                return this.readDATETIMN(tdsInputStream, n11);
            }
            case 49: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readDATEN(tdsInputStream, dataFormat._length);
            }
            case 123: {
                int n12;
                this._dataLengths[this._columnNo] = n12 = tdsInputStream.readUnsignedByte();
                return this.readDATEN(tdsInputStream, n12);
            }
            case 51: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readTIMEN(tdsInputStream, dataFormat._length);
            }
            case 147: {
                int n13;
                this._dataLengths[this._columnNo] = n13 = tdsInputStream.readUnsignedByte();
                return this.readTIMEN(tdsInputStream, n13);
            }
            case 36: {
                return this.readBLOB(tdsInputStream, dataFormat._blobType);
            }
            case 35: 
            case 174: {
                int n14 = tdsInputStream.readUnsignedByte();
                if (n14 == 0) {
                    return null;
                }
                byte[] byArray = new byte[n14 + 8];
                tdsInputStream.read(byArray, 0, n14 + 8);
                int n15 = tdsInputStream.readInt();
                if (n15 == 0) {
                    return null;
                }
                this._dataLengths[this._columnNo] = n15;
                String string = null;
                string = dataFormat._datatype == 35 ? tdsInputStream.readString(n15) : tdsInputStream.readUnicodeString(n15);
                return string;
            }
            case 34: {
                int n16;
                int n17;
                int n18 = tdsInputStream.readUnsignedByte();
                if (n18 == 0) {
                    return null;
                }
                byte[] byArray = new byte[n18 + 8];
                tdsInputStream.read(byArray, 0, n18 + 8);
                if (n17 == 0) {
                    return null;
                }
                this._dataLengths[this._columnNo] = n17;
                byte[] byArray2 = new byte[n17];
                for (n17 = tdsInputStream.readInt(); n17 > 0; n17 -= n16) {
                    n16 = tdsInputStream.read(byArray2, byArray2.length - n17, n17);
                    if (n16 != -1) continue;
                    throw new IOException("Unexpected end of data from client");
                }
                return byArray2;
            }
            case 60: 
            case 122: {
                this._dataLengths[this._columnNo] = dataFormat._length;
                return this.readMONEYN(tdsInputStream, dataFormat._length);
            }
            case 110: {
                int n19;
                this._dataLengths[this._columnNo] = n19 = tdsInputStream.readUnsignedByte();
                return this.readMONEYN(tdsInputStream, n19);
            }
        }
        throw new SrvTypeException("Unmappable TDS data type received: 0x" + Integer.toHexString(dataFormat._datatype));
    }

    protected String unicodeArrayToString(TdsInputStream tdsInputStream, byte[] byArray) throws IOException {
        return tdsInputStream.convertUnicodeBytesToString(byArray);
    }

    private TdsDateTime readBIGDATETIMN(TdsInputStream tdsInputStream, int n, int n2) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 8: {
                BigDecimal bigDecimal = tdsInputStream.readUnsignedLongAsBigDecimal();
                if (n2 == 187) {
                    n2 = 5;
                } else if (n2 == 188) {
                    n2 = 6;
                }
                return new TdsDateTime(bigDecimal, n2);
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    private TdsDateTime readDATETIMN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readUnsignedShort();
                int n3 = tdsInputStream.readUnsignedShort();
                return new TdsDateTime(n2, n3, 2);
            }
            case 8: {
                int n4 = tdsInputStream.readInt();
                int n5 = tdsInputStream.readInt();
                return new TdsDateTime(n4, n5, 1);
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    private TdsDateTime readDATEN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readInt();
                return new TdsDateTime(n2, 0, 3);
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    private TdsDateTime readTIMEN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readInt();
                return new TdsDateTime(0, n2, 4);
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    private BigDecimal readMONEYN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = tdsInputStream.readInt();
                return new BigDecimal(BigInteger.valueOf(n2), 4);
            }
            case 8: {
                long l = tdsInputStream.readLong();
                return new BigDecimal(BigInteger.valueOf(l), 4);
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    private Number readFLTN(TdsInputStream tdsInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Float(tdsInputStream.readFloat());
            }
            case 8: {
                return new Double(tdsInputStream.readDouble());
            }
        }
        ErrorMessage.raiseIOException((String)"JZ0P4");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readBLOB(TdsInputStream tdsInputStream, int n) throws IOException, SrvTypeException {
        int n2;
        Object object = null;
        this._serializationTypes[this._columnNo] = n2 = tdsInputStream.readUnsignedByte();
        short s = tdsInputStream.readShort();
        this._dataLengths[this._columnNo] = 0;
        switch (n) {
            case 1: {
                Object object2;
                if (s > 0) {
                    object2 = tdsInputStream.readString((int)s);
                }
                object2 = new SrvBlobInputStream((DataInput)tdsInputStream);
                try {
                    try (ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object2);){
                        object = objectInputStream.readObject();
                    }
                    this._dataLengths[this._columnNo] = object == null ? 0 : object.toString().length();
                    break;
                }
                catch (EOFException eOFException) {
                    break;
                }
                finally {
                    ((SrvBlobInputStream)object2).close();
                }
            }
            case 3: {
                if (s > 0) {
                    tdsInputStream.skip((long)s);
                }
                SrvBlobInputStream srvBlobInputStream = new SrvBlobInputStream((DataInput)tdsInputStream);
                InputStreamReader inputStreamReader = null;
                inputStreamReader = this._columnNo < this._lastColumnIndex ? new InputStreamReader(this.cacheBlob(srvBlobInputStream), tdsInputStream.getCharset()) : new InputStreamReader((InputStream)srvBlobInputStream, tdsInputStream.getCharset());
                object = inputStreamReader;
                break;
            }
            case 5: {
                if (s > 0) {
                    tdsInputStream.skip((long)s);
                }
                SrvBlobInputStream srvBlobInputStream = new SrvBlobInputStream((DataInput)tdsInputStream);
                InputStreamReader inputStreamReader = null;
                String string = null;
                string = !tdsInputStream.getBigEndian() ? "UnicodeLittleUnmarked" : "UnicodeBigUnmarked";
                inputStreamReader = this._columnNo < this._lastColumnIndex ? new InputStreamReader(this.cacheBlob(srvBlobInputStream), string) : new InputStreamReader((InputStream)srvBlobInputStream, string);
                object = inputStreamReader;
                break;
            }
            case 4: {
                if (s > 0) {
                    tdsInputStream.skip((long)s);
                }
                if (this._columnNo < this._lastColumnIndex) {
                    object = this.cacheBlob(new SrvBlobInputStream((DataInput)tdsInputStream));
                    break;
                }
                object = new SrvBlobInputStream((DataInput)tdsInputStream);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (s > 0) {
                    tdsInputStream.skip((long)s);
                }
                this._lobLengths[this._columnNo] = tdsInputStream.readLong();
                this._locatorLengths[this._columnNo] = tdsInputStream.readShort();
                byte[] byArray = new byte[this._locatorLengths[this._columnNo]];
                tdsInputStream.read(byArray, 0, this._locatorLengths[this._columnNo]);
                this._locators[this._columnNo] = byArray;
                if (this._columnNo < this._lastColumnIndex) {
                    object = this.cacheBlob(new SrvBlobInputStream((DataInput)tdsInputStream));
                    break;
                }
                object = new SrvBlobInputStream((DataInput)tdsInputStream);
                break;
            }
        }
        return object;
    }

    private InputStream cacheBlob(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public long[] getLobLengths() {
        return this._lobLengths;
    }

    public int[] getLocatorLengths() {
        return this._locatorLengths;
    }

    public Object[] getLocators() {
        return this._locators;
    }
}

