/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.LoginAckToken;
import com.sybase.jdbc42.tds.LoginToken;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvLoginToken
extends LoginToken
implements Dumpable {
    protected int _hostNameLen;
    protected int _userLen;
    protected int _passwordLen;
    protected int _hostProcLen;
    protected int _ldate;
    protected int _lusedb;
    protected int _linterfacespare;
    protected int _ltype;
    protected byte[] _spare;
    protected int _appNameLen;
    protected int _serviceNameLen;
    protected int _remPwLen;
    protected byte[] _tdsversion;
    protected int _progNameLen;
    protected int _lnoshort;
    protected int _ldate4;
    protected int _languageLen;
    protected int _lsetlang;
    protected byte[] _oldsecure;
    protected int _lseclogin;
    protected int _lsecbulk;
    protected byte[] _secspare;
    protected int _charsetLen;
    protected int _lsetcharset;
    protected int _lchar;
    protected int _ldmpld;
    int _tdsPacketSize = 0;
    private byte _packetSizeLength = (byte)3;
    private String _progName = new String();

    public String getHost() {
        return this._hostName;
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._cred;
    }

    public String getApplicationName() {
        return this._appName;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String getProgramName() {
        return this._progName;
    }

    public String getCharset() {
        return this._charset;
    }

    public String getLocale() {
        return this._language;
    }

    public int getPacketSize() {
        return this._tdsPacketSize;
    }

    public int getHALogin() {
        return this._lhalogin;
    }

    public byte[] getHASessionID() {
        return this._lhasessionid;
    }

    public boolean getBigEndian() throws IOException {
        if (this._lint2 == 2 && this._lint4 == 0 && this._lflt == 4 && this._lflt4 == 12) {
            return true;
        }
        if (this._lint2 == 3 && this._lint4 == 1 && this._lflt == 10 && this._lflt4 == 13) {
            return false;
        }
        throw new IOException("Cannot handle TDS endian order requested by client:" + this._lint2 + "," + this._lint4 + "," + this._lflt + "," + this._lflt4);
    }

    public SrvLoginToken(TdsInputStream tdsInputStream) throws IOException {
        this._lint2 = -1;
        this._lint4 = -1;
        this._lflt = -1;
        this._lflt4 = -1;
        this._hostName = tdsInputStream.readString(30);
        this._hostNameLen = tdsInputStream.readUnsignedByte();
        this._hostName = this._hostName.substring(0, this._hostNameLen);
        this._user = tdsInputStream.readString(30);
        this._userLen = tdsInputStream.readUnsignedByte();
        this._user = this._user.substring(0, this._userLen);
        this._cred = tdsInputStream.readString(30);
        this._passwordLen = tdsInputStream.readUnsignedByte();
        this._cred = this._cred.substring(0, this._passwordLen);
        this._hostProc = tdsInputStream.readString(30);
        this._hostProcLen = tdsInputStream.readUnsignedByte();
        this._hostProc = this._hostProc.substring(0, this._hostProcLen);
        this._lint2 = tdsInputStream.readUnsignedByte();
        this._lint4 = tdsInputStream.readUnsignedByte();
        this._lchar = tdsInputStream.readUnsignedByte();
        this._lflt = tdsInputStream.readUnsignedByte();
        this._ldate = tdsInputStream.readUnsignedByte();
        this._lusedb = tdsInputStream.readUnsignedByte();
        this._ldmpld = tdsInputStream.readUnsignedByte();
        this._linterfacespare = tdsInputStream.readUnsignedByte();
        this._ltype = tdsInputStream.readUnsignedByte();
        this._bufSize = tdsInputStream.readInt();
        this._spare = new byte[SPARE.length];
        tdsInputStream.read(this._spare);
        this._appName = tdsInputStream.readString(30);
        this._appNameLen = tdsInputStream.readUnsignedByte();
        this._appName = this._appName.substring(0, this._appNameLen);
        this._serviceName = tdsInputStream.readString(30);
        this._serviceNameLen = tdsInputStream.readUnsignedByte();
        this._serviceName = this._serviceName.substring(0, this._serviceNameLen);
        byte[] byArray = new byte[255];
        tdsInputStream.read(byArray);
        this._remPw = new String(byArray);
        this._remPwLen = tdsInputStream.readUnsignedByte();
        this._tdsversion = new byte[LoginToken.TDSVERSION.length];
        tdsInputStream.read(this._tdsversion);
        if (this._tdsversion[0] < 5) {
            throw new IOException("TDS versions prior to 5.0 are not supported.");
        }
        this._progName = tdsInputStream.readString(10);
        this._progNameLen = tdsInputStream.readUnsignedByte();
        this._progName = this._progName.substring(0, this._progNameLen);
        tdsInputStream.read(this._progVers);
        this._lnoshort = tdsInputStream.readUnsignedByte();
        this._lflt4 = tdsInputStream.readUnsignedByte();
        this._ldate4 = tdsInputStream.readUnsignedByte();
        this._language = tdsInputStream.readString(30);
        this._languageLen = tdsInputStream.readUnsignedByte();
        this._language = this._language.substring(0, this._languageLen);
        this._lsetlang = tdsInputStream.readUnsignedByte();
        this._oldsecure = new byte[OLDSECURE.length];
        tdsInputStream.read(this._oldsecure);
        this._lseclogin = tdsInputStream.readUnsignedByte();
        this._lsecbulk = tdsInputStream.readUnsignedByte();
        this._lhalogin = tdsInputStream.readUnsignedByte();
        tdsInputStream.read(this._lhasessionid);
        this._secspare = new byte[SECSPARE.length];
        tdsInputStream.read(this._secspare);
        this._charset = tdsInputStream.readString(30);
        this._charsetLen = tdsInputStream.readUnsignedByte();
        this._charset = this._charset.substring(0, this._charsetLen);
        this._lsetcharset = tdsInputStream.readUnsignedByte();
        byte[] byArray2 = new byte[6];
        tdsInputStream.read(byArray2);
        this._packetSizeLength = (byte)tdsInputStream.readUnsignedByte();
        this._tdsPacketSize = new Integer(new String(byArray2, 0, (int)this._packetSizeLength));
        byte[] byArray3 = new byte[DUMMY.length];
        tdsInputStream.read(byArray3);
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(258)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "Login Record; fixed length.");
            } else {
                dumpInfo.addInfo("Token", 1, "Login Record");
            }
            if (dumpFilter.includesDetail(3)) {
                String[] stringArray;
                dumpInfo.addText("Host Name", 30, this._hostName.substring(0, this._hostNameLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Host Name Length", 1, this._hostNameLen);
                }
                dumpInfo.addText("User Name", 30, this._user.substring(0, this._userLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("User Name Length", 1, this._userLen);
                }
                if (dumpFilter.includesDetail(5)) {
                    dumpInfo.addText("Password", 30, "<masked>");
                    if (dumpFilter.includesDetail(1)) {
                        stringArray = new String[]{"<masked>"};
                        dumpInfo.addField("Password Length", 1, 0, stringArray);
                    }
                } else {
                    dumpInfo.addText("Password", 30, "<masked>");
                    if (dumpFilter.includesDetail(1)) {
                        stringArray = new String[]{"<masked>"};
                        dumpInfo.addField("Password Length", 1, 0, stringArray);
                    }
                }
                dumpInfo.addText("Host Process", 30, this._hostProc.substring(0, this._hostProcLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Host Process Length", 1, this._hostProcLen);
                }
                dumpInfo.addInt("Byte Ordering - int2", 1, this._lint2);
                dumpInfo.addInt("Byte Ordering - int4", 1, this._lint4);
                dumpInfo.addInt("Character Encoding", 1, this._lchar);
                dumpInfo.addInt("Float Format", 1, this._lflt);
                dumpInfo.addInt("Date Format", 1, this._ldate);
                dumpInfo.addHex("lusedb", 1, this._lusedb);
                dumpInfo.addInt("ldmpld", 1, this._ldmpld);
                dumpInfo.addHex("linterfacespare", 1, this._linterfacespare);
                dumpInfo.addInt("Dialog Type", 1, this._ltype);
                dumpInfo.addInt("lbufsize", 1, this._bufSize);
                dumpInfo.addHex("spare", 3, this._spare);
                dumpInfo.addText("Application Name", 30, this._appName.substring(0, this._appNameLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Application Name Length", 1, this._appNameLen);
                }
                dumpInfo.addText("Service Name", 30, this._serviceName.substring(0, this._serviceNameLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Service Name Length", 1, this._serviceNameLen);
                }
                dumpInfo.addText("Remote Passwords", 255, "<masked>");
                if (dumpFilter.includesDetail(1)) {
                    stringArray = new String[]{"<masked>"};
                    dumpInfo.addField("Password Length", 1, 0, stringArray);
                }
                dumpInfo.addInfo("TDS Version", 4, LoginAckToken.makeVersionString((byte[])this._tdsversion));
                dumpInfo.addText("Prog Name", 10, this._progName.substring(0, this._progNameLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Prog Name Length", 1, this._progNameLen);
                }
                dumpInfo.addInfo("Prog Version", 4, LoginAckToken.makeVersionString((byte[])this._progVers));
                dumpInfo.addInt("Convert Shorts", 1, this._lnoshort);
                dumpInfo.addInt("4-byte Float Format", 1, this._lflt4);
                dumpInfo.addInt("4-byte Date Format", 1, this._ldate4);
                dumpInfo.addText("Language", 30, this._language.substring(0, this._languageLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Language Length", 1, this._languageLen);
                }
                dumpInfo.addInt("Notify when Changed", 1, this._lsetlang);
                dumpInfo.addHex("Old Secure Info", OLDSECURE.length, this._oldsecure);
                stringArray = new String[]{"UNUSED", "SEC_LOG_ENCRYPT", "SEC_LOG_CHALLENGE", "SEC_LOG_LABELS", "SEC_LOG_APPDEFINED", "SEC_LOG_SECSESSION", "SEC_LOG_ENCRYPT2", "NEG_LOG_LOGPARAMS", "SEC_LOG_ENCRYPT3"};
                dumpInfo.addBitfield("Secure Login Flags", 1, this._lseclogin, stringArray);
                dumpInfo.addInt("Bulk Copy", 1, this._lsecbulk);
                dumpInfo.addHex("HA Login Flags", 1, this._lhalogin);
                dumpInfo.addHex("HA Session ID", 6, this._lhasessionid);
                dumpInfo.addHex("Spare", SECSPARE.length, this._secspare);
                dumpInfo.addText("Character Set", 30, this._charset.substring(0, this._charsetLen));
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Character Set Length", 1, this._charsetLen);
                }
                dumpInfo.addInt("Notify when Changed", 1, this._lsetcharset);
                dumpInfo.addInt("Packet Size", 6, this._tdsPacketSize);
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Packet Size Length", 1, this._packetSizeLength);
                }
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 258;
    }

    protected static String getPasswordsString(String string, int n) {
        byte[] byArray = string.getBytes();
        String string2 = new String();
        int n2 = 0;
        while (n2 < n) {
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            try {
                byte by = byArray[n2];
                ++n2;
                if (by == 0) {
                    string2 = string2 + "<universal>";
                } else {
                    string2 = string2 + "\"" + string.substring(n2, n2 + by) + "\"";
                    n2 += by;
                }
                string2 = string2 + "/";
                by = byArray[n2];
                ++n2;
                if (by == 0) {
                    string2 = string2 + "<null>";
                    continue;
                }
                string2 = string2 + "\"" + string.substring(n2, n2 + by) + "\"";
                n2 += by;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string2 = new String("<unrecognized> ");
                string2 = string2 + HexConverts.hexConvert((byte[])string.getBytes());
                break;
            }
        }
        return string2;
    }
}

