/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.OptionCmdToken;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvOptionCmdToken
extends OptionCmdToken
implements Dumpable {
    private static final int TDS_CMD_SET = 1;
    private static final int TDS_OPT_UNUSED = 0;
    private static final int TDS_OPT_DATEFIRST = 1;
    private static final int TDS_OPT_TEXTSIZE = 2;
    private static final int TDS_OPT_STAT_TIME = 3;
    private static final int TDS_OPT_STAT_IO = 4;
    private static final int TDS_OPT_ROWCOUNT = 5;
    private static final int TDS_OPT_NATLANG = 6;
    private static final int TDS_OPT_DATEFORMAT = 7;
    private static final int TDS_OPT_ISOLATION = 8;
    private static final int TDS_OPT_AUTHON = 9;
    private static final int TDS_OPT_CHARSET = 10;
    private static final int TDS_OPT_PLAN = 11;
    private static final int TDS_OPT_ERRLVL = 12;
    private static final int TDS_OPT_SHOWPLAN = 13;
    private static final int TDS_OPT_NOEXEC = 14;
    private static final int TDS_OPT_ARITHIGNOREON = 15;
    private static final int TDS_OPT_ARITHABORTON = 17;
    private static final int TDS_OPT_PARSEONLY = 18;
    private static final int TDS_OPT_ESTIMATE = 19;
    private static final int TDS_OPT_GETDATA = 20;
    private static final int TDS_OPT_NOCOUNT = 21;
    private static final int TDS_OPT_FORCEPLAN = 23;
    private static final int TDS_OPT_FORMATONLY = 24;
    private static final int TDS_OPT_CHAINXACTS = 25;
    private static final int TDS_OPT_CURCLOSEONXACT = 26;
    private static final int TDS_OPT_FIPSFLAG = 27;
    private static final int TDS_OPT_RESTREES = 28;
    private static final int TDS_OPT_IDENTITYON = 29;
    private static final int TDS_OPT_CURREAD = 30;
    private static final int TDS_OPT_CURWRITE = 31;
    private static final int TDS_OPT_IDENTITYOFF = 32;
    private static final int TDS_OPT_AUTHOFF = 33;
    private static final int TDS_OPT_ANSINULL = 34;
    private static final int TDS_OPT_QUOTED_IDENT = 35;
    private static final int TDS_OPT_ARITHIGNOREOFF = 36;
    private static final int TDS_OPT_ARITHABORTOFF = 37;
    private static final int TDS_OPT_TRUNCABORT = 38;
    private static final int TDS_OPT_JTC = 39;
    private static final int TDS_OPT_CLIENTREALNAME = 40;
    private static final int TDS_OPT_CLIENTHOSTNAME = 41;
    private static final int TDS_OPT_CLIENTAPPLNAME = 42;
    private static final int TDS_OPT_IDENTITYUPD_ON = 43;
    private static final int TDS_OPT_IDENTITYUPD_OFF = 44;
    private static final int TDS_OPT_NODATA = 45;
    private static final int TDS_OPT_CIPHERTEXT = 46;
    private static final int TDS_OPT_SHOW_FI = 47;
    private static final int TDS_OPT_HIDE_VCC = 48;
    private static final int TDS_OPT_LOB_LOCATOR = 49;
    private static final int TDS_OPT_LOB_LOCATORFETCHSIZE = 50;
    private static final int TDS_OPT_SERVERENCRYPT = 51;
    private static final int TDS_OPT_ISOLATION_MODE = 52;
    private int _length;
    private int _command;
    private int _option;
    private int _argLength;
    private int _intArg;
    private String _stringArg;

    public SrvOptionCmdToken(TdsInputStream tdsInputStream) throws IOException {
        this._length = tdsInputStream.readShort();
        this._command = tdsInputStream.readUnsignedByte();
        this._option = tdsInputStream.readUnsignedByte();
        this._argLength = tdsInputStream.readUnsignedByte();
        this.readOptionArg(tdsInputStream);
        this.setOption(this._option, this._intArg);
    }

    private void readOptionArg(TdsInputStream tdsInputStream) throws IOException {
        switch (this._option) {
            case 1: 
            case 7: 
            case 8: 
            case 52: {
                if (!this.tokenHasArg(1, tdsInputStream)) break;
                this._intArg = tdsInputStream.readUnsignedByte();
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                if (!this.tokenHasArg(1, tdsInputStream)) break;
                this._intArg = tdsInputStream.readUnsignedByte();
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 36: 
            case 37: 
            case 50: {
                if (!this.tokenHasArg(4, tdsInputStream)) break;
                this._intArg = tdsInputStream.readInt();
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (!this.tokenHasArg(this._argLength, tdsInputStream)) break;
                this._stringArg = tdsInputStream.readString(this._argLength);
                break;
            }
        }
    }

    public int getOption() {
        return this._option;
    }

    public int getOptionVal() {
        return this._intArg;
    }

    private boolean tokenHasArg(int n, TdsInputStream tdsInputStream) throws IOException {
        int n2 = this._length - 3;
        if (n2 < n) {
            for (int i = 0; i < n2; ++i) {
                tdsInputStream.read();
            }
            return false;
        }
        return true;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(166)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "OPTIONCMD Token (0x" + HexConverts.hexConvert((int)166, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "OPTIONCMD Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._length);
            }
            if (dumpFilter.includesDetail(3)) {
                String[] stringArray = new String[]{"<unrecognized>", "TDS_OPT_SET", "TDS_OPT_DEFAULT", "TDS_OPT_LIST", "TDS_OPT_INFO"};
                dumpInfo.addField("Command", 1, this._command, stringArray);
                String[] stringArray2 = new String[]{"TDS_OPT_UNUSED", "TDS_OPT_DATEFIRST", "TDS_OPT_TEXTSIZE", "TDS_OPT_STAT_TIME", "TDS_OPT_STAT_IO", "TDS_OPT_ROWCOUNT", "TDS_OPT_NATLANG", "TDS_OPT_DATEFORMAT", "TDS_OPT_ISOLATION", "TDS_OPT_AUTHON", "TDS_OPT_CHARSET", "TDS_OPT_PLAN", "TDS_OPT_ERRLVL", "TDS_OPT_SHOWPLAN", "TDS_OPT_NOEXEC", "TDS_OPT_ARITHIGNOREON", "<unrecognized>", "TDS_OPT_ARITHABORTON", "TDS_OPT_PARSEONLY", "TDS_OPT_ESTIMATE", "TDS_OPT_GETDATA", "TDS_OPT_NOCOUNT", "<unrecognized>", "TDS_OPT_FORCEPLAN", "TDS_OPT_FORMATONLY", "TDS_OPT_CHAINXACTS", "TDS_OPT_CURCLOSEONXACT", "TDS_OPT_FIPSFLAG", "TDS_OPT_RESTREES", "TDS_OPT_IDENTITYON", "TDS_OPT_CURREAD", "TDS_OPT_CURWRITE", "TDS_OPT_IDENTITYOF", "TDS_OPT_AUTHOFF", "TDS_OPT_ANSINULL", "TDS_OPT_QUOTED_IDENT", "TDS_OPT_ARITHIGNOREOFF", "TDS_OPT_ARITHABORTOFF", "TDS_OPT_TRUNCABORT", "TDS_OPT_JTC", "TDS_OPT_CLIENTREALNAME", "TDS_OPT_CLIENTHOSTNAME:", "TDS_OPT_CLIENTAPPLNAME:", "TDS_OPT_IDENTITYUPD_ON", "TDS_OPT_IDENTITYUPD_OFF", "TDS_OPT_NODATA", "TDS_OPT_CIPHERTEXT", "TDS_OPT_SHOW_FI", "TDS_OPT_HIDE_VCC", "TDS_OPT_LOB_LOCATOR", "TDS_OPT_LOBLOCATORFETCHSIZE", "TDS_OPT_SERVERENCRYPT", "TDS_OPT_ISOLATION_MODE"};
                dumpInfo.addField("Option", 1, this._option, stringArray2);
                dumpInfo.addInt("Arg Length", 1, this._argLength);
                this.dumpOptionArg(dumpInfo);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 166;
    }

    private void dumpOptionArg(DumpInfo dumpInfo) {
        switch (this._option) {
            case 1: {
                String[] stringArray = new String[]{"<unrecognized>", "TDS_OPT_MONDAY", "TDS_OPT_TUESDAY", "TDS_OPT_WEDNESDAY", "TDS_OPT_THURSDAY", "TDS_OPT_FRIDAY", "TDS_OPT_SATURDAY", "TDS_OPT_SUNDAY"};
                dumpInfo.addField("Option Arg", 1, this._intArg, stringArray);
                break;
            }
            case 7: {
                String[] stringArray = new String[]{"<unrecognized>", "TDS_OPT_FMTMDY", "TDS_OPT_FMTDMY", "TDS_OPT_FMTYMD", "TDS_OPT_FMTYDM", "TDS_OPT_FMTMYD", "TDS_OPT_FMTDYM"};
                dumpInfo.addField("Option Arg", 1, this._intArg, stringArray);
                break;
            }
            case 8: 
            case 52: {
                dumpInfo.addInt("Option Arg", 1, this._intArg);
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                if (this._intArg == 1) {
                    dumpInfo.addText("Option Arg", 4, "true");
                    break;
                }
                dumpInfo.addText("Option Arg", 5, "false");
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 50: {
                dumpInfo.addInt("Option Arg", 4, this._intArg);
                break;
            }
            case 15: 
            case 17: 
            case 36: 
            case 37: {
                String[] stringArray = new String[]{"<unrecognized>", "TDS_OPT_ARITHOVERFLOW", "TDS_OPT_NUMERICTRUNC"};
                dumpInfo.addField("Option Arg", 4, this._intArg, stringArray);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: {
                if (this._stringArg != null) {
                    dumpInfo.addText("Option Arg", this._stringArg.length(), this._stringArg);
                    break;
                }
                dumpInfo.addText("Option Arg", 4, "null");
                break;
            }
        }
    }
}

