/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.ParamFormatToken;
import com.sybase.jdbc42.tds.SrvDataFormat;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;
import java.util.Vector;

public class SrvParamFormatToken
extends ParamFormatToken
implements SrvFormatToken,
Dumpable {
    protected Vector<DataFormat> _dataformats = new Vector();
    private long _len;
    protected int _numParams;

    public SrvParamFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this._len = this.readLength(tdsInputStream);
        this._numParams = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numParams);
    }

    public SrvParamFormatToken() {
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
        }
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvDataFormat(tdsInputStream);
    }

    public long getLength() {
        int n = 2;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            n += srvDataFormat.length();
        }
        return n;
    }

    @Override
    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    @Override
    public int getFormatCount() {
        return this._dataformats.size();
    }

    @Override
    public DataFormat formatAt(int n) {
        return (SrvDataFormat)this._dataformats.elementAt(n);
    }

    @Override
    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            srvDataFormat.send(tdsOutputStream);
        }
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return SrvDataFormat.lengthSize((int)dataFormat._datatype);
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(236)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "PARAMFMT Token (0x" + HexConverts.hexConvert((int)236, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "PARAMFMT Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._len);
            }
            dumpInfo.addInt("Number of Params", 2, this._numParams);
            for (int i = 0; i < this.getFormatCount(); ++i) {
                dumpInfo.addInfo("TDSFmt", 0, "Param " + (i + 1));
                DataFormat dataFormat = this.formatAt(i);
                ((SrvDataFormat)dataFormat).setParentTokenType(this.getTokenType());
                dumpInfo.addInfo(((SrvDataFormat)dataFormat).dump(dumpFilter));
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 236;
    }
}

