/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.ParamsToken;
import com.sybase.jdbc42.tds.SrvDataToken;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc42.tds.SrvTypeFormatter;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.tds.Token;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;

public class SrvParamsToken
extends ParamsToken
implements SrvDataToken,
Dumpable {
    SrvTypeFormatter _formatter = null;
    TdsInputStream _in = null;
    Object[] data;

    public SrvParamsToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
        this._in = tdsInputStream;
    }

    public SrvParamsToken() {
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(215);
        this._formatter.sendDataStream(tdsOutputStream);
    }

    @Override
    public TdsInputStream getStream() {
        return this._in;
    }

    @Override
    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
        this._formatter = srvTypeFormatter;
    }

    public SrvTypeFormatter getFormatter() {
        return this._formatter;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        if (this._formatter == null) {
            throw new Error("Ya godda have a formatter to dump params.");
        }
        DumpInfo dumpInfo = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = (SrvJavaTypeFormatter)this._formatter;
        this.data = srvJavaTypeFormatter.convertData((Token)this);
        if (dumpFilter.includesToken(215)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "PARAMS Token (0x" + HexConverts.hexConvert((int)215, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "PARAMS Token");
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                int[] nArray = srvJavaTypeFormatter.getColumnStatusBytes();
                int[] nArray2 = srvJavaTypeFormatter.getSerializationTypes();
                int[] nArray3 = srvJavaTypeFormatter.getDataLengths();
                int[] nArray4 = srvJavaTypeFormatter.getLengthSizes();
                SrvFormatToken srvFormatToken = srvJavaTypeFormatter.getDataFormats();
                long[] lArray = srvJavaTypeFormatter.getLobLengths();
                int[] nArray5 = srvJavaTypeFormatter.getLocatorLengths();
                Object[] objectArray = srvJavaTypeFormatter.getLocators();
                String[] stringArray = new String[]{"DATA_NORMAL", "DATA_NULL", "DATA_ZERO_LENGTH_TEXT_IMAGE", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>"};
                for (int i = 0; i < this.data.length; ++i) {
                    dumpInfo.addInfo("TDSFmt", 0, "Param " + (i + 1));
                    DataFormat dataFormat = srvFormatToken.formatAt(i);
                    String string = null;
                    if (dataFormat.isUnitype()) {
                        string = this.getStream().getBigEndian() ? "UnicodeBigUnmarked" : "UnicodeLittleUnmarked";
                    }
                    if (dumpFilter.includesDetail(1)) {
                        if (nArray[i] != 9999) {
                            byte by = (byte)nArray[i];
                            dumpInfo.addBitfield("Column Status", 1, by, stringArray);
                            if ((by & 1) != 0) {
                                dumpInfo.addValue("Param data", nArray3[i], this.data[i], string);
                                continue;
                            }
                        }
                        dumpInfo.addInt("Length", nArray4[i], nArray3[i]);
                    }
                    if (nArray2[i] != 9999) {
                        dumpInfo.addInt("Blob Serialization Type", 1, nArray2[i]);
                    }
                    if (lArray[i] != -999L) {
                        dumpInfo.addInt("Lob Length", 8, lArray[i]);
                    }
                    if (nArray5[i] != -999) {
                        dumpInfo.addInt("Locator Length", 2, nArray5[i]);
                    }
                    if (objectArray[i] instanceof byte[]) {
                        byte[] byArray = (byte[])objectArray[i];
                        dumpInfo.addHex("Locator", byArray.length, byArray);
                    }
                    dumpInfo.addValue("Param data", nArray3[i], this.data[i], string);
                }
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 215;
    }

    public Object[] getData() {
        return this.data;
    }
}

