/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.RowFormat2Token;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.SrvRowDataFormat2;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.utils.DumpFilter;
import com.sybase.jdbc42.utils.DumpInfo;
import com.sybase.jdbc42.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class SrvRowFormat2Token
extends RowFormat2Token
implements SrvFormatToken,
Dumpable {
    protected Vector<DataFormat> _dataformats = new Vector();
    protected long _len;

    public SrvRowFormat2Token(TdsInputStream tdsInputStream) throws IOException, SQLException {
        this._len = this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public SrvRowFormat2Token() throws SQLException {
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(97);
        tdsOutputStream.writeLongAsUnsignedInt(this.getLength());
        tdsOutputStream.writeShort(this._dataformats.size());
        for (int i = 0; i < this._dataformats.size(); ++i) {
            DataFormat dataFormat = this._dataformats.elementAt(i);
            dataFormat.send(tdsOutputStream);
        }
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
        }
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvRowDataFormat2(tdsInputStream);
    }

    public long getLength() {
        long l = 2L;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            DataFormat dataFormat = this._dataformats.elementAt(i);
            l += (long)dataFormat.length();
        }
        return l;
    }

    @Override
    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    @Override
    public int getFormatCount() {
        return this._dataformats.size();
    }

    @Override
    public DataFormat formatAt(int n) {
        return this.getDataFormat(n);
    }

    protected DataFormat getDataFormat(int n) {
        return this._dataformats.elementAt(n);
    }

    @Override
    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        for (int i = 0; i < this._dataformats.size(); ++i) {
            DataFormat dataFormat = this._dataformats.elementAt(i);
            dataFormat.send(tdsOutputStream);
        }
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return SrvRowDataFormat2.lengthSize((int)dataFormat._datatype);
    }

    public boolean hasKeyColumns() {
        boolean bl = false;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvRowDataFormat2 srvRowDataFormat2 = (SrvRowDataFormat2)this._dataformats.elementAt(i);
            if ((srvRowDataFormat2._status & 2) == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(97)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROWFMT2 Token (0x" + HexConverts.hexConvert((int)97, (int)1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "ROWFMT2 Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._len);
            }
            dumpInfo.addInt("Number of Columns", 2, this._numColumns);
            for (int i = 0; i < this.getFormatCount(); ++i) {
                dumpInfo.addInfo("TDSFmt", 0, "Column " + (i + 1));
                DataFormat dataFormat = this.formatAt(i);
                dumpInfo.addInfo(((SrvRowDataFormat2)dataFormat).dump(dumpFilter));
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 97;
    }
}

