/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.DateObject;
import com.sybase.jdbc42.tds.BlobOutputStream;
import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.SrvCapabilityToken;
import com.sybase.jdbc42.tds.SrvDataFormat;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.SrvTypeException;
import com.sybase.jdbc42.tds.SrvTypeFormatter;
import com.sybase.jdbc42.tds.SybBigDecimal;
import com.sybase.jdbc42.tds.TdsDateTime;
import com.sybase.jdbc42.tds.TdsNumeric;
import com.sybase.jdbc42.tds.TdsOutputStream;
import com.sybase.jdbc42.tds.Token;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class SrvSQLTypeFormatter
extends SrvTypeFormatter {
    ResultSet _rs = null;
    static Hashtable<Integer, int[]> _formatmap = new Hashtable();

    public SrvSQLTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        super(srvFormatToken, srvCapabilityToken);
    }

    public void addFormat(DataFormat dataFormat) {
        this._format.addFormat(dataFormat);
    }

    public DataFormat[] buildDataFormat(ResultSet resultSet) throws IOException {
        DataFormat[] dataFormatArray = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n == 0) {
                throw new SrvTypeException("Cannot format result set with  0 columns");
            }
            dataFormatArray = new SrvDataFormat[n];
            for (int i = 1; i <= n; ++i) {
                int n2;
                int[] nArray = _formatmap.get(new Integer(resultSetMetaData.getColumnType(i)));
                if (nArray == null) {
                    throw new SrvTypeException("Cannot map JDBC type " + resultSetMetaData.getColumnTypeName(i) + " to TDS type");
                }
                int[] nArray2 = nArray;
                if (this._cap.handlesDataType(nArray2[1])) {
                    n2 = 0;
                    if (resultSetMetaData.isNullable(i) == 1) {
                        n2 |= 0x20;
                    }
                    if (resultSetMetaData.isWritable(i)) {
                        n2 |= 0x10;
                    }
                } else {
                    throw new SrvTypeException("Not handling client literal  conversion for JDBC types " + resultSetMetaData.getColumnTypeName(i));
                }
                dataFormatArray[i - 1] = new SrvDataFormat(resultSetMetaData.getColumnName(i), nArray2[1], n2, nArray2[2], resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i), null);
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL to TDS conversion error: " + sQLException);
        }
        return dataFormatArray;
    }

    public void convertData(Token token, ResultSet resultSet) throws IOException {
        this._rs = resultSet;
        this.setFormatter(token, this);
    }

    @Override
    public void sendDataStream(TdsOutputStream tdsOutputStream) throws IOException {
        try {
            if (this._rs.getMetaData().getColumnCount() != this._format.getFormatCount()) {
                throw new SrvTypeException("Format column count(" + this._format.getFormatCount() + ") does not match row column count (" + this._rs.getMetaData().getColumnCount() + ")");
            }
            for (int i = 1; i <= this._format.getFormatCount(); ++i) {
                DataFormat dataFormat = this._format.formatAt(i - 1);
                this.sendDataStream(tdsOutputStream, i, dataFormat);
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL error on type conversion: " + sQLException);
        }
    }

    protected void sendDataStream(TdsOutputStream tdsOutputStream, int n, DataFormat dataFormat) throws SQLException, IOException {
        block0 : switch (dataFormat._datatype) {
            case 50: {
                if (this._rs.getBoolean(n)) {
                    tdsOutputStream.writeByte(1);
                    break;
                }
                tdsOutputStream.writeByte(0);
                break;
            }
            case 39: 
            case 47: {
                byte[] byArray = tdsOutputStream.stringToByte(this._rs.getString(n));
                if (byArray == null) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 175: {
                byte[] byArray = tdsOutputStream.stringToByte(this._rs.getString(n));
                if (byArray == null) {
                    tdsOutputStream.writeInt(0);
                    break;
                }
                tdsOutputStream.writeInt(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 225: {
                byte[] byArray = this._rs.getBytes(n);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeInt(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 48: {
                tdsOutputStream.writeByte((int)this._rs.getByte(n));
                break;
            }
            case 52: {
                tdsOutputStream.writeShort((int)this._rs.getShort(n));
                break;
            }
            case 56: {
                tdsOutputStream.writeInt(this._rs.getInt(n));
                break;
            }
            case 191: {
                tdsOutputStream.writeLong(this._rs.getLong(n));
                break;
            }
            case 38: {
                int n2 = this._rs.getInt(n);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(dataFormat._length);
                switch (dataFormat._length) {
                    case 1: {
                        tdsOutputStream.writeByte((int)((byte)n2));
                        break;
                    }
                    case 2: {
                        tdsOutputStream.writeShort((int)((short)n2));
                        break;
                    }
                    case 4: {
                        tdsOutputStream.writeInt(n2);
                        break;
                    }
                    case 8: {
                        tdsOutputStream.writeLong((long)n2);
                    }
                }
                break;
            }
            case 59: {
                tdsOutputStream.writeFloat(this._rs.getFloat(n));
                break;
            }
            case 62: {
                tdsOutputStream.writeDouble(this._rs.getDouble(n));
                break;
            }
            case 109: {
                float f = 0.0f;
                double d = 0.0;
                switch (dataFormat._length) {
                    case 4: {
                        f = this._rs.getFloat(n);
                        break;
                    }
                    case 8: {
                        d = this._rs.getDouble(n);
                    }
                }
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(dataFormat._length);
                switch (dataFormat._length) {
                    case 4: {
                        tdsOutputStream.writeFloat(f);
                        break;
                    }
                    case 8: {
                        tdsOutputStream.writeDouble(d);
                    }
                }
                break;
            }
            case 37: {
                byte[] byArray = this._rs.getBytes(n);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                tdsOutputStream.writeByte(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 106: 
            case 108: {
                BigDecimal bigDecimal = this._rs.getBigDecimal(n);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                bigDecimal = new SybBigDecimal(bigDecimal, dataFormat._precision, dataFormat._scale);
                int[] nArray = new int[4];
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)bigDecimal, (int)dataFormat._scale, (int[])nArray, (boolean)false);
                tdsOutputStream.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                tdsOutputStream.write(byArray);
                break;
            }
            case 111: {
                DateObject dateObject = null;
                switch (this._rs.getMetaData().getColumnType(n)) {
                    case 92: {
                        dateObject = new DateObject((Object)this._rs.getTime(n), 92);
                        break;
                    }
                    case 91: {
                        dateObject = new DateObject((Object)this._rs.getDate(n), 91);
                        break;
                    }
                    case 93: {
                        dateObject = new DateObject((Object)this._rs.getTimestamp(n), 93);
                    }
                }
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                int[] nArray = TdsDateTime.tdsDateTime(dateObject);
                tdsOutputStream.writeByte(8);
                tdsOutputStream.writeInt(nArray[0]);
                tdsOutputStream.writeInt(nArray[1]);
                break;
            }
            case 49: 
            case 123: {
                DateObject dateObject = null;
                dateObject = new DateObject((Object)this._rs.getDate(n), 91);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeByte(4);
                tdsOutputStream.writeInt(nArray[0]);
                break;
            }
            case 51: 
            case 147: {
                DateObject dateObject = null;
                dateObject = new DateObject((Object)this._rs.getTime(n), 92);
                if (this._rs.wasNull()) {
                    tdsOutputStream.writeByte(0);
                    break;
                }
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)dateObject);
                tdsOutputStream.writeByte(4);
                tdsOutputStream.writeInt(nArray[1]);
                break;
            }
            case 36: {
                switch (dataFormat._blobType) {
                    case 1: {
                        Object object = this._rs.getObject(n);
                        tdsOutputStream.writeByte(1);
                        tdsOutputStream.writeShort(0);
                        if (object == null) {
                            tdsOutputStream.writeInt(0);
                            break block0;
                        }
                        BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)blobOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        break block0;
                    }
                }
                throw new SrvTypeException("Unmappable blob data type: " + this._rs.getMetaData().getColumnType(n));
            }
            default: {
                throw new SrvTypeException("Unmappable java data type: " + this._rs.getMetaData().getColumnType(n));
            }
        }
    }

    static {
        int[][] nArrayArray = new int[][]{{-7, 50, 0, 0, 0}, {-6, 38, 1, 48, 0}, {5, 38, 2, 52, 0}, {4, 38, 4, 56, 0}, {-5, 38, 8, 0, 0}, {7, 109, 4, 0, 0}, {6, 109, 8, 0, 0}, {8, 109, 8, 0, 0}, {2, 108, 33, 0, 0}, {3, 106, 33, 0, 0}, {1, 39, 255, 0, 0}, {12, 39, 255, 0, 0}, {-1, 175, 16384, 0, 0}, {-4, 225, 16384, 0, 0}, {91, 123, 4, 0, 0}, {92, 147, 4, 0, 0}, {93, 111, 8, 0, 0}, {-2, 37, 255, 0, 0}, {-3, 37, 255, 0, 0}, {2000, 9217, 0, 0, 0}};
        for (int i = 0; i < nArrayArray.length; ++i) {
            _formatmap.put(new Integer(nArrayArray[i][0]), nArrayArray[i]);
        }
    }
}

