/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.Dumpable;
import com.sybase.jdbc42.tds.RowFormatToken;
import com.sybase.jdbc42.tds.SrvAcceptor;
import com.sybase.jdbc42.tds.SrvCapabilityToken;
import com.sybase.jdbc42.tds.SrvCursor;
import com.sybase.jdbc42.tds.SrvCursorMemResultSet;
import com.sybase.jdbc42.tds.SrvDataInputStream;
import com.sybase.jdbc42.tds.SrvDbrpcToken;
import com.sybase.jdbc42.tds.SrvEedToken;
import com.sybase.jdbc42.tds.SrvEnvChangeToken;
import com.sybase.jdbc42.tds.SrvFormatToken;
import com.sybase.jdbc42.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc42.tds.SrvLoginToken;
import com.sybase.jdbc42.tds.SrvLogoutToken;
import com.sybase.jdbc42.tds.SrvOptionCmdToken;
import com.sybase.jdbc42.tds.SrvReceiver;
import com.sybase.jdbc42.tds.SrvRowDataFormat2;
import com.sybase.jdbc42.tds.SrvRowFormat2Token;
import com.sybase.jdbc42.tds.SrvRowFormatToken;
import com.sybase.jdbc42.tds.SrvSession;
import com.sybase.jdbc42.tds.SrvTextImageData;
import com.sybase.jdbc42.tds.SrvTypeException;
import com.sybase.jdbc42.tds.Token;
import com.sybase.jdbc42.utils.Debug;
import com.sybase.jdbc42.utils.SybVersion;
import foo.bar.TestObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx.AlongPackage;

public class SrvTest
extends SrvReceiver {
    private int _port = 10000;
    private int _sslPort = 20000;
    private boolean _idebug = false;
    private boolean _odebug = false;
    private String _remoteURL = null;
    private String _debugClasses = null;
    private ServerSocket _srvSock = null;
    private ServerSocket _sslServerSocket = null;
    private Connection _remoteServer = null;
    private String _serverProgName = "jTDS";
    private static final int BUF_SIZE = 2048;

    public SrvTest(String[] stringArray) {
        super("SrvTest");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-p")) {
                try {
                    this._port = Integer.parseInt(stringArray[++i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this._port = 10000;
                }
            }
            if (stringArray[i].equals("-s")) {
                try {
                    this._sslPort = Integer.parseInt(stringArray[++i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this._sslPort = 20000;
                }
                continue;
            }
            if (stringArray[i].equals("-i")) {
                this._idebug = true;
                continue;
            }
            if (stringArray[i].equals("-n")) {
                this._serverProgName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-o")) {
                this._odebug = true;
                continue;
            }
            if (stringArray[i].equals("-D")) {
                try {
                    this._debugClasses = stringArray[++i];
                    Debug.debug((boolean)true, (String)this._debugClasses, (PrintStream)System.out);
                }
                catch (IOException iOException) {}
                continue;
            }
            if (stringArray[i].equals("-v")) {
                Debug.println((String)this.getJConnectVersion().replace(SybVersion.PRODUCT_NAME, "jTDS"));
                continue;
            }
            if (stringArray[i].equals("-R")) {
                this._remoteURL = stringArray[++i];
                this.openRemoteConnection();
                continue;
            }
            if (stringArray[i].equals("-E")) {
                this._encryptionProvider = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-help") && !stringArray[i].equals("-h") && !stringArray[i].equals("-?") && !stringArray[i].equals("-usage")) continue;
            Debug.println((String)"usage:  $ java com.sybase.tds.SrvTest  $ java com.sybase.jdbc42.tds.SrvTest  or $ java com.sybase.tds.jtds  [-p <port number>][-s <SSL port>][-i][-o] [-v]\n [-n <server Program Name>\n [-D <debug classes>]\n [-R <remote server URL>\n [-E <encryption provider>\n [-v \n default port is 10000, default SSL port is 20000");
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        SrvTest srvTest = new SrvTest(stringArray);
        srvTest.run();
    }

    @Override
    public void run() {
        Object object;
        Object object2;
        try {
            object2 = new String[]{"SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
            this._srvSock = new ServerSocket(this._port);
            object = SSLServerSocketFactory.getDefault();
            this._sslServerSocket = ((ServerSocketFactory)object).createServerSocket(this._sslPort);
            ((SSLServerSocket)this._sslServerSocket).setEnabledCipherSuites((String[])object2);
        }
        catch (IOException iOException) {
            System.exit(1);
        }
        object2 = new SrvAcceptor(this._srvSock, this, this._idebug, this._odebug);
        object = new SrvAcceptor(this._sslServerSocket, this, this._idebug, this._odebug);
        ((Thread)object2).start();
        ((Thread)object).start();
        super.run();
    }

    @Override
    public void handleLogin(SrvSession srvSession, String string, String string2, String string3, String string4, int n) {
        block24: {
            try {
                if (string.equals("baduser")) {
                    this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", false, n);
                    break block24;
                }
                if (string.equals("noObjectCaps")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.clear(54);
                    srvCapabilityToken._respCaps.set(36);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                    break block24;
                }
                if (string.equals("noLongBinCaps")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.clear(29);
                    srvCapabilityToken._respCaps.set(23);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                    break block24;
                }
                if (string.equals("noStreamTypes")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.clear(55);
                    srvCapabilityToken._reqCaps.clear(57);
                    srvCapabilityToken._respCaps.set(37);
                    srvCapabilityToken._respCaps.set(39);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                    break block24;
                }
                if (string.equals("noWideTable")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.clear(59);
                    srvCapabilityToken._respCaps.set(45);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                    break block24;
                }
                if (string.equals("emulateScrollable")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.set(6);
                    srvCapabilityToken._reqCaps.set(74);
                    srvCapabilityToken._reqCaps.set(76);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                    break block24;
                }
                if (string.equals("timeout")) {
                    int n2 = 1000;
                    try {
                        n2 = Integer.parseInt(string2);
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", true, n);
                    break block24;
                }
                if (string.equals("187494")) {
                    SrvEedToken srvEedToken = new SrvEedToken(5555, 0, 0, null, 0, "Empty SQLState message", "Test Server", null, 0);
                    srvSession.send((Token)srvEedToken);
                    this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", true, n);
                } else if (string.equals("kill_server_during_login_ack")) {
                    srvSession.close();
                } else if (string.equals("CR278769") || string.equals("CR278769-2")) {
                    srvSession._encodingChanged = false;
                    this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", true, n);
                } else if (string.equals("CR329421")) {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.clear(15);
                    srvCapabilityToken._reqCaps.clear(14);
                    this.sendLogin(srvSession, srvCapabilityToken, "RAI", true, n);
                } else if (string.equals("odbc_enc_pw_test")) {
                    if (string2.compareTo("secret") == 0) {
                        this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", true, n);
                    } else {
                        SrvEedToken srvEedToken = new SrvEedToken(4002, 1, 14, "ZZZZZ", 1, "Login failed", "SrvTest", null, 0);
                        this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", false, n, srvEedToken);
                        srvSession.close();
                        this.removeSession(srvSession);
                    }
                } else {
                    SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
                    srvCapabilityToken._reqCaps.set(95);
                    srvCapabilityToken._respCaps.set(95);
                    this.sendLogin(srvSession, srvSession.getClientCapability(), "RAI", true, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleOptionCmdToken(SrvSession srvSession, SrvOptionCmdToken srvOptionCmdToken) {
        try {
            if (srvSession.getLogin().getUser().equals("CR293312") && srvOptionCmdToken.getOption() == 25 && srvOptionCmdToken.getOptionVal() == 1) {
                SrvEedToken srvEedToken = new SrvEedToken(474747, 1, 10, "ZZZZZ", 1, "Ding dong the witch is dead!", "Unknown", null, 1);
                srvSession.send((Token)srvEedToken, true);
            } else {
                srvSession.sendDone(0, false, true, false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void handleLanguage(SrvSession srvSession, String string, Object[] objectArray) {
        block53: {
            String string2 = string.trim();
            string = string.toLowerCase().trim();
            try {
                if (string.startsWith("use")) {
                    this.sendDone(srvSession, 0, true, true, false);
                    break block53;
                }
                if (string.equals("kill me")) {
                    this.sendDone(srvSession, 0, true, true, false);
                    srvSession.close();
                    this.removeSession(srvSession);
                    break block53;
                }
                if (string.equals("simple")) {
                    Object[][] objectArray2 = new Object[][]{{new String("first row, col1"), new String("first row, col2")}, {new String("second row, col1"), new String("second row, col2")}};
                    int n = this.sendResults(srvSession, (String[])null, objectArray2);
                    this.sendDone(srvSession, n, false, true, false);
                    break block53;
                }
                if (string.equals("header")) {
                    String[] stringArray = new String[]{"string1", "string2"};
                    Object[][] objectArray3 = new Object[][]{{"value1", "value2"}, {"value1", "value2"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, stringArray, objectArray3), false, true, false);
                    break block53;
                }
                if (string.equals("help") || string.equals("?")) {
                    Object[][] objectArray4 = new Object[][]{{"\nLanguage commands:"}, {"help or ?"}, {"simple - just some simple strings"}, {"header - header test"}, {"types1 - bunch of numeric types"}, {"types2 - other types"}, {"big - lots of string"}, {"object - return java-object data"}, {"cap - dump of client TDS capability set"}, {"kill me - kills the current session"}, {"set server_prog_name <name> -  sets the server's program name to be returned in the TDS_LOGIN_ACK token"}, {"\nProcedure emulations:"}, {"sp_mda/dba.sp_mda <int>, <int> - return results set"}, {"sp_dummy (int, varchar) returns result set and status"}, {"exec server.port.user.password <string> - remote procedure exec"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray4), false, true, false);
                    break block53;
                }
                if (string.equals("big")) {
                    String string3 = new String("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567");
                    Object[][] objectArray5 = new Object[15][1];
                    for (int i = 0; i < objectArray5.length; ++i) {
                        objectArray5[i][0] = string3;
                    }
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray5), false, true, false);
                    break block53;
                }
                if (string.equals("long header")) {
                    String[] stringArray = new String[]{"string12345678901234567890123456789012345678901234567890012345678901234567890112345678901234567890123456789012345678901234567890", "string2"};
                    Object[][] objectArray6 = new Object[][]{{"value1", "value2"}, {"value1", "value2"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, stringArray, objectArray6), false, true, false);
                    break block53;
                }
                if (string.equals("object1")) {
                    Object[][] objectArray7 = new Object[1][1];
                    TestObject testObject = new TestObject();
                    testObject._i = 47;
                    objectArray7[0][0] = testObject;
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray7), false, true, false);
                    break block53;
                }
                if (string.equals("223702")) {
                    Object[][] objectArray8 = new Object[1][1];
                    AlongPackage alongPackage = new AlongPackage();
                    objectArray8[0][0] = alongPackage;
                    String[] stringArray = new String[]{"siamese/CAT"};
                    this.sendDone(srvSession, this.sendResults(srvSession, null, objectArray8, stringArray), false, true, false);
                    break block53;
                }
                if (string.equals("badclass")) {
                    Object[][] objectArray9 = new Object[1][1];
                    try {
                        objectArray9[0][0] = Class.forName("unknown.Class").newInstance();
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                    }
                    catch (LinkageError linkageError) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray9), false, true, false);
                    break block53;
                }
                if (string.equals("object32")) {
                    Object[][] objectArray10 = new Object[2][3];
                    for (int i = 0; i < 2; ++i) {
                        TestObject testObject = new TestObject();
                        testObject._i = i;
                        objectArray10[i][0] = testObject;
                        Integer n = new Integer(i);
                        objectArray10[i][1] = n;
                        TestObject testObject2 = new TestObject();
                        testObject2._i = i * 10000;
                        objectArray10[i][2] = testObject2;
                    }
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray10), false, true, false);
                    break block53;
                }
                if (string.startsWith("echo3")) {
                    Object[] objectArray11 = new Object[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray11[i] = objectArray[i] instanceof Reader ? this.cloneReader((Reader)objectArray[i]) : (objectArray[i] instanceof InputStream ? this.cloneInputStream((InputStream)objectArray[i]) : objectArray[i]);
                    }
                    Object[][] objectArray12 = new Object[3][];
                    for (int i = 0; i < 3; ++i) {
                        objectArray12[i] = new Object[objectArray.length];
                        for (int j = 0; j < objectArray.length; ++j) {
                            Closeable closeable;
                            if (objectArray11[j] instanceof CharArrayReader) {
                                closeable = (CharArrayReader)objectArray11[j];
                                objectArray12[i][j] = this.cloneReader((Reader)closeable);
                                ((CharArrayReader)closeable).reset();
                                continue;
                            }
                            if (objectArray11[j] instanceof ByteArrayInputStream) {
                                closeable = (ByteArrayInputStream)objectArray11[j];
                                objectArray12[i][j] = this.cloneInputStream((InputStream)closeable);
                                ((ByteArrayInputStream)closeable).reset();
                                continue;
                            }
                            objectArray12[i][j] = objectArray11[j];
                        }
                    }
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray12), false, true, false);
                    break block53;
                }
                if (string.startsWith("echo")) {
                    Object[][] objectArray13 = new Object[][]{objectArray};
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray13), false, true, false);
                    break block53;
                }
                if (string.startsWith("set server_prog_name")) {
                    this._serverProgName = (String)objectArray[0];
                    this.sendDone(srvSession, 0, true, true, false);
                    break block53;
                }
                if (string.startsWith("sendbacksecond")) {
                    try {
                        this.sendDone(srvSession, 0, false, false, true);
                        Object[] objectArray14 = new Object[]{objectArray[1]};
                        this.sendRPCParams(srvSession, 0, null, objectArray14, true);
                    }
                    catch (IOException iOException) {}
                    break block53;
                }
                if (string.equals("types1")) {
                    String[] stringArray = new String[]{"string", "boolean", "byte", "short", "integer", "float", "double"};
                    Object[][] objectArray15 = new Object[][]{{new String("min"), new Boolean(false), new Byte(-128), new Short(Short.MIN_VALUE), new Integer(Integer.MIN_VALUE), new Float(1.234E-38f), new Double(3.9876E-300)}, {new String("mid negative"), new Boolean(true), new Byte(-3), new Short(-10), new Integer(-10), new Float(3.3456E-5f), new Double(3.3456E-5)}, {new String("mid positive"), new Boolean(false), new Byte(3), new Short(10), new Integer(10), new Float(334560.0f), new Double(334560.0)}, {new String("max"), new Boolean(true), new Byte(127), new Short(Short.MAX_VALUE), new Integer(Integer.MAX_VALUE), new Float(Float.MAX_VALUE), new Double(Double.MAX_VALUE)}};
                    this.sendDone(srvSession, this.sendResults(srvSession, stringArray, objectArray15), false, true, false);
                    break block53;
                }
                if (string.equals("types2")) {
                    String[] stringArray = new String[]{"date", "calendar", "bytes/binary"};
                    byte[] byArray = new byte[]{3, -127};
                    Object[][] objectArray16 = new Object[][]{{new java.util.Date(), Calendar.getInstance(), byArray}, {new java.util.Date(5L), Calendar.getInstance(), byArray}};
                    this.sendDone(srvSession, this.sendResults(srvSession, stringArray, objectArray16), false, true, false);
                    break block53;
                }
                if (string.startsWith("cap")) {
                    this.capabilities(srvSession);
                    break block53;
                }
                if (string.equals("exec 188941")) {
                    Object[][] objectArray17 = new Object[][]{{new Integer(1)}};
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray17), false, true, false);
                    break block53;
                }
                if (string2.equals("select au_fname as 'FIRST NAME' from dbo.authors")) {
                    SrvRowFormat2Token srvRowFormat2Token = new SrvRowFormat2Token();
                    SrvRowDataFormat2 srvRowDataFormat2 = new SrvRowDataFormat2("FIRST NAME", "pubs2", "dbo", "authors", "au_fname", 39, 48, 40, 0, 0, null);
                    srvRowFormat2Token.addFormat((DataFormat)srvRowDataFormat2);
                    Object[][] objectArray18 = new Object[][]{{"Mickey Mouse"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, srvRowFormat2Token, objectArray18), false, true, false);
                    break block53;
                }
                if (string2.equals("select mouse_name as 'MOUSE NAME' from dbo.mice")) {
                    SrvRowDataFormat2[] srvRowDataFormat2Array = new SrvRowDataFormat2[]{new SrvRowDataFormat2("MOUSE NAME", "pubs2", "dbo", "mice", "mouse_name", 39, 48, 40, 0, 0, null)};
                    Object[][] objectArray19 = new Object[][]{{"Mickey Mouse"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, (DataFormat[])srvRowDataFormat2Array, objectArray19), false, true, false);
                    break block53;
                }
                if (string2.equals("select date_col as 'DATE' from dbo.date_table")) {
                    SrvRowFormat2Token srvRowFormat2Token = new SrvRowFormat2Token();
                    SrvRowDataFormat2 srvRowDataFormat2 = new SrvRowDataFormat2("DATE", "jdbc_test_bacardi", "dbo", "date_table", "date_col", 123, 48, 4, 0, 0, null);
                    srvRowFormat2Token.addFormat((DataFormat)srvRowDataFormat2);
                    Object[][] objectArray20 = new Object[][]{{Date.valueOf("1492-10-11")}};
                    this.sendDone(srvSession, this.sendResults(srvSession, srvRowFormat2Token, objectArray20), false, true, false);
                    break block53;
                }
                if (string2.equals("select time_col as 'TIME' from dbo.time_table")) {
                    SrvRowFormat2Token srvRowFormat2Token = new SrvRowFormat2Token();
                    SrvRowDataFormat2 srvRowDataFormat2 = new SrvRowDataFormat2("TIME", "jdbc_test_bacardi", "dbo", "time_table", "time_col", 147, 48, 4, 0, 0, null);
                    srvRowFormat2Token.addFormat((DataFormat)srvRowDataFormat2);
                    Time time = Time.valueOf("16:54:20");
                    time.setTime(time.getTime() + 630L);
                    Object[][] objectArray21 = new Object[][]{{time}};
                    this.sendDone(srvSession, this.sendResults(srvSession, srvRowFormat2Token, objectArray21), false, true, false);
                    break block53;
                }
                if (string.startsWith("writetext")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    try {
                        String string4 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ".");
                        String string5 = stringTokenizer2.nextToken();
                        srvSession.setSessionData("Writetext.table", string5);
                        String string6 = stringTokenizer2.nextToken();
                        srvSession.setSessionData("Writetext.column", string6);
                        string4 = stringTokenizer.nextToken();
                        srvSession.setSessionData("Writetext.textptr", string4);
                        string4 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        srvSession.setSessionData("Writetext.timestamp", string4);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    this.sendDone(srvSession, 0, false, true, false);
                    break block53;
                }
                if (string.equalsIgnoreCase("SELECT textColumn, ImageColumn FROM TITable")) {
                    SrvRowFormatToken srvRowFormatToken = new SrvRowFormatToken();
                    SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvRowFormatToken, srvSession.getClientCapability());
                    byte[] byArray = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        byArray[i] = 0;
                    }
                    Object[] objectArray22 = new Object[2];
                    byte[] byArray2 = new byte[]{0};
                    SrvTextImageData srvTextImageData = new SrvTextImageData(byArray, System.currentTimeMillis(), byArray2);
                    srvTextImageData.setTableName("TITable");
                    srvJavaTypeFormatter.addFormat(srvTextImageData, "textColumn", null, null, "TITable", "textColumn", 48, 0);
                    objectArray22[0] = srvTextImageData;
                    byArray[15] = 1;
                    srvTextImageData = new SrvTextImageData(byArray, System.currentTimeMillis(), byArray2);
                    srvTextImageData.setTableName("TITable");
                    srvJavaTypeFormatter.addFormat(srvTextImageData, "imageColumn", null, null, "TITable", "imageColumn", 48, 0);
                    objectArray22[1] = srvTextImageData;
                    Object[][] objectArray23 = new Object[][]{objectArray22};
                    this.sendDone(srvSession, this.sendResults(srvSession, srvRowFormatToken, objectArray23), false, true, false);
                } else if (string.startsWith("emulate_shutdown")) {
                    SrvEedToken srvEedToken = new SrvEedToken(6006, 1, 10, "ZZZZZ", 1, "Server SHUTDOWN by request.", "Unknown", null, 1);
                    srvSession.send((Token)srvEedToken, false);
                    SrvEedToken srvEedToken2 = new SrvEedToken(5702, 1, 10, "ZZZZZ", 1, "The SQL Server is terminating this process.", "Unknown", null, 1);
                    srvSession.send((Token)srvEedToken2, true);
                } else if (string.compareTo("shutdown with nowait") == 0) {
                    SrvEedToken srvEedToken = new SrvEedToken(6006, 1, 10, "ZZZZZ", 1, "Server SHUTDOWN by request.", "Unknown", null, 1);
                    srvSession.send((Token)srvEedToken, false);
                    SrvEedToken srvEedToken3 = new SrvEedToken(5702, 1, 10, "ZZZZZ", 1, "The SQL Server is terminating this process.", "Unknown", null, 1);
                    srvSession.send((Token)srvEedToken3, true);
                    System.exit(0);
                } else if (string.startsWith("set chained on") && srvSession.getLogin().getUser().equals("CR293312")) {
                    SrvEedToken srvEedToken = new SrvEedToken(474747, 1, 10, "ZZZZZ", 1, "Ding dong the witch is dead!", "Unknown", null, 1);
                    srvSession.send((Token)srvEedToken, true);
                } else {
                    this.rExec(srvSession, string);
                }
            }
            catch (IOException iOException) {
            }
            catch (SQLException sQLException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean handleCursorDeclare(SrvSession srvSession, SrvCursor srvCursor) {
        return true;
    }

    @Override
    public void buildCursorResultSet(SrvSession srvSession, SrvCursor srvCursor, Object[] objectArray) {
        Dumpable dumpable = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        try {
            if (srvCapabilityToken._reqCaps.get(59)) {
                dumpable = new SrvRowFormat2Token();
                srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)dumpable), srvCapabilityToken);
            } else {
                dumpable = new SrvRowFormatToken();
                srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvRowFormatToken)dumpable, srvCapabilityToken);
            }
            if (srvCursor.getStatement().equalsIgnoreCase("select au_fname as 'FIRST NAME', id as 'ID' from dbo.authors")) {
                int n = 20;
                srvCursor.setTotalNumRows(n);
                srvJavaTypeFormatter.addFormat(new String("foo"), "FIRST NAME", "pubs2", "dbo", "authors", "au_fname", 48, 0);
                srvJavaTypeFormatter.addFormat(new Integer(47), "ID", "pubs2", "dbo", "authors", "id", 48, 4);
                srvCursor.setRowFormat((RowFormatToken)dumpable);
                srvCursor.setFormatter(srvJavaTypeFormatter);
                Object[][] objectArray2 = new Object[n][2];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        if (j % 2 == 0) {
                            String string = "firstname" + (i + 1);
                            objectArray2[i][j] = string;
                            continue;
                        }
                        objectArray2[i][j] = new Integer(i + 1);
                    }
                }
                SrvCursorMemResultSet srvCursorMemResultSet = new SrvCursorMemResultSet();
                srvCursorMemResultSet.setRowValues(objectArray2);
                srvCursor.setCursorResultSet(srvCursorMemResultSet);
            } else if (srvCursor.getStatement().equalsIgnoreCase("select au_fname as 'FIRST NAME', id as 'ID' from dbo.longauthors")) {
                int n = 10000;
                srvCursor.setTotalNumRows(n);
                srvJavaTypeFormatter.addFormat(new String("foo"), "FIRST NAME", "pubs2", "dbo", "longauthors", "au_fname", 48, 0);
                srvJavaTypeFormatter.addFormat(new Integer(47), "ID", "pubs2", "dbo", "longauthors", "id", 48, 4);
                srvCursor.setRowFormat((RowFormatToken)dumpable);
                srvCursor.setFormatter(srvJavaTypeFormatter);
                Object[][] objectArray3 = new Object[n][2];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        if (j % 2 == 0) {
                            String string = "firstname" + (i + 1);
                            objectArray3[i][j] = string;
                            continue;
                        }
                        objectArray3[i][j] = new Integer(i + 1);
                    }
                }
                SrvCursorMemResultSet srvCursorMemResultSet = new SrvCursorMemResultSet();
                srvCursorMemResultSet.setRowValues(objectArray3);
                srvCursor.setCursorResultSet(srvCursorMemResultSet);
            } else if (srvCursor.getStatement().equalsIgnoreCase("select au_fname as 'FIRST NAME', id as 'ID' from dbo.emptyauthors")) {
                int n = 0;
                srvCursor.setTotalNumRows(n);
                srvJavaTypeFormatter.addFormat(new String("foo"), "FIRST NAME", "pubs2", "dbo", "longauthors", "au_fname", 48, 0);
                srvJavaTypeFormatter.addFormat(new Integer(47), "ID", "pubs2", "dbo", "longauthors", "id", 48, 4);
                srvCursor.setRowFormat((RowFormatToken)dumpable);
                srvCursor.setFormatter(srvJavaTypeFormatter);
                Object[][] objectArray4 = new Object[n][2];
                SrvCursorMemResultSet srvCursorMemResultSet = new SrvCursorMemResultSet();
                srvCursorMemResultSet.setRowValues(objectArray4);
                srvCursor.setCursorResultSet(srvCursorMemResultSet);
            }
        }
        catch (SrvTypeException srvTypeException) {
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void handleBulk(SrvSession srvSession, SrvDataInputStream srvDataInputStream) {
        try {
            String string = (String)srvSession.getSessionData("Writetext.column");
            if (string.indexOf("image") != -1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(srvDataInputStream.available());
                byte[] byArray = new byte[1024];
                int n = 1;
                while (n > 0) {
                    n = srvDataInputStream.read(byArray);
                    if (n <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            } else {
                CharArrayWriter charArrayWriter = new CharArrayWriter(srvDataInputStream.available());
                char[] cArray = new char[1024];
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)((Object)srvDataInputStream), srvDataInputStream.getCharset());
                int n = 1;
                while (n > 0) {
                    n = inputStreamReader.read(cArray, 0, 1024);
                    if (n <= 0) continue;
                    charArrayWriter.write(cArray, 0, n);
                }
            }
            this.sendDone(srvSession, -1, false, true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleDisconnect(SrvSession srvSession, SrvLogoutToken srvLogoutToken) {
    }

    @Override
    public void handleRPC(SrvSession srvSession, SrvDbrpcToken srvDbrpcToken, Object[] objectArray) {
        block80: {
            String string = srvDbrpcToken.getName();
            if (string.equalsIgnoreCase("sp_mda") || string.equalsIgnoreCase("dba.sp_mda")) {
                SrvLoginToken srvLoginToken = srvSession.getLogin();
                if (srvLoginToken.getUser().equals("nomda") || srvLoginToken.getUser().equals("CR278769")) {
                    try {
                        this.sendMessage(srvSession, 32000, "Unknown procedure", string, 1);
                        this.sendDone(srvSession, -1, true, true, true);
                    }
                    catch (IOException iOException) {}
                } else if (srvLoginToken.getUser().equals("CR275103")) {
                    int n = 1000;
                    try {
                        n = Integer.parseInt(srvLoginToken.getPassword());
                        Thread.sleep(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    try {
                        if (this._remoteServer != null) {
                            if (srvLoginToken.getUser().equals("CR270704")) {
                                SrvEnvChangeToken srvEnvChangeToken = new SrvEnvChangeToken();
                                srvEnvChangeToken.addVariable(3, "", "roman8");
                                srvSession.send((Token)srvEnvChangeToken);
                                Object[][] objectArray2 = new Object[][]{{"TYPEINFO", new Integer(1), "sp_jdbcfunction_escapes"}, {"MDAVERSION", new Integer(5), "6"}, {"PREPEND_DB_NAME", new Integer(5), "1"}};
                                this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray2), false, true, false);
                            } else {
                                this.rCall(srvSession, "{call " + string + "(?,?)}", objectArray);
                            }
                            break block80;
                        }
                        Object[][] objectArray3 = new Object[][]{{"TYPEINFO", new Integer(1), "sp_jdbcfunction_escapes"}, {"TYPEINFO", new Integer(1), "sp_jdbcfunction_escapes"}};
                        this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray3), false, true, false);
                    }
                    catch (IOException iOException) {
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (string.equals("sp_dummy")) {
                try {
                    Object[][] objectArray4 = new Object[][]{{new Integer(42), "Thanks for all the fish"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray4), false, false, true);
                    this.sendRPCParams(srvSession, 0, null, objectArray4[0], true);
                }
                catch (IOException iOException) {
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("objproc")) {
                for (int i = 0; i < objectArray.length; ++i) {
                }
                try {
                    Object[][] objectArray5 = new Object[][]{{new Integer(42), "Thanks for all the fish"}};
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray5), false, false, true);
                    TestObject testObject = (TestObject)objectArray[0];
                    testObject._i = 4321;
                    this.sendRPCParams(srvSession, 0, null, objectArray, true);
                }
                catch (IOException iOException) {
                }
                catch (SQLException sQLException) {}
            } else if (string.startsWith("echo")) {
                try {
                    this.sendDone(srvSession, 0, false, false, true);
                    this.sendRPCParams(srvSession, 0, null, objectArray, true);
                }
                catch (IOException iOException) {}
            } else if (string.equals("sendbacksecond")) {
                try {
                    this.sendDone(srvSession, 0, false, false, true);
                    Object[] objectArray6 = new Object[]{objectArray[1]};
                    this.sendRPCParams(srvSession, 0, null, objectArray6, true);
                }
                catch (IOException iOException) {}
            } else if (string.equals("jos_regrun")) {
                String string2 = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                int n2 = (Integer)objectArray[2];
                int n3 = (Integer)objectArray[3];
                SrvRegRunner srvRegRunner = new SrvRegRunner(this, string2, n, n2, n3);
                srvRegRunner.start();
                try {
                    this.sendRPCParams(srvSession, 0, null, null, true);
                }
                catch (IOException iOException) {}
            } else if (string.startsWith("jos_") || string.startsWith("reg")) {
                try {
                    this.sendRPCParams(srvSession, 0, null, null, true);
                }
                catch (IOException iOException) {}
            } else if (string.equals("sp_default_charset")) {
                try {
                    this.rCall(srvSession, "{call " + string + "}", objectArray);
                }
                catch (IOException iOException) {
                }
                catch (SQLException sQLException) {}
            } else if (string.startsWith("testParamFmt2")) {
                if (!srvDbrpcToken.includesWidetableParams()) {
                    try {
                        String string3 = "jConnect did not properly create the TDS to create the requested stored procedure. Specifically, jConnect did not create a PARAMFMT2 token.";
                        this.sendMessage(srvSession, 32000, string3, string, 1);
                        this.sendDone(srvSession, -1, true, true, true);
                    }
                    catch (IOException iOException) {}
                } else {
                    int n = (Integer)objectArray[0];
                    int n4 = (Integer)objectArray[46];
                    int n5 = (Integer)objectArray[481];
                    if (n != 47 || n4 != 47 || n5 != 47) {
                        try {
                            String string4 = "jConnect sent the wrong parameter value following a PARAMFTM2 token. Expected 47, 47, 47 for three checks of parameters, but got " + n + ", " + n4 + ", " + n5 + ".";
                            this.sendMessage(srvSession, 32000, string4, string, 1);
                            this.sendDone(srvSession, -1, true, true, true);
                        }
                        catch (IOException iOException) {}
                    } else {
                        try {
                            this.sendDone(srvSession, -1, false, true, false);
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (string.startsWith("noParamFmt2")) {
                if (srvDbrpcToken.includesWidetableParams()) {
                    try {
                        String string5 = "jConnect did not properly create the TDS to create the requested stored procedure. Specifically, jConnect sent a PARAMFMT2 token when it should have sent a PARAMFMT.";
                        this.sendMessage(srvSession, 32000, string5, string, 1);
                        this.sendDone(srvSession, -1, true, true, true);
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        this.sendDone(srvSession, -1, false, true, false);
                    }
                    catch (IOException iOException) {}
                }
            } else if (string.startsWith("frodo")) {
                Object[] objectArray7 = new Object[]{objectArray[0]};
                try {
                    this.sendDone(srvSession, 0, false, false, true);
                    this.sendRPCParams(srvSession, 0, null, objectArray7, true);
                }
                catch (IOException iOException) {}
            } else if (string.startsWith("t329421")) {
                Object[][] objectArray8 = new Object[1][1];
                objectArray8[0][0] = new Integer(1);
                try {
                    this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray8), false, true, false);
                }
                catch (IOException iOException) {
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    this.sendMessage(srvSession, 32000, "Unknown procedure", string, 1);
                    this.sendDone(srvSession, -1, true, true, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void capabilities(SrvSession srvSession) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(srvSession.getClientCapability().toString()));
        try {
            String string;
            Vector<String> vector = new Vector<String>();
            while ((string = bufferedReader.readLine()) != null) {
                vector.addElement(string);
            }
            Object[][] objectArray = new Object[vector.size()][1];
            for (int i = 0; i < vector.size(); ++i) {
                objectArray[i][0] = vector.elementAt(i);
            }
            this.sendDone(srvSession, this.sendResults(srvSession, (String[])null, objectArray), false, true, false);
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rExec(SrvSession srvSession, String string) throws IOException, SQLException {
        this.openRemoteConnection();
        if (this._remoteServer == null) {
            srvSession.send(this.createMessage(srvSession, 10000, "Unknown command entered and no passthru server", "SrvTest", string, 1));
            this.sendDone(srvSession, -1, true, true, false);
            return;
        }
        try (Statement statement = null;){
            statement = this._remoteServer.createStatement();
            this.passthruResults(srvSession, statement, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rCall(SrvSession srvSession, String string, Object[] objectArray) throws IOException, SQLException {
        this.openRemoteConnection();
        if (this._remoteServer == null) {
            srvSession.send(this.createMessage(srvSession, 10000, "Unknown rpc entered and no passthru server", "SrvTest", string, 1));
            this.sendDone(srvSession, -1, true, true, false);
            return;
        }
        try (CallableStatement callableStatement = null;){
            callableStatement = this._remoteServer.prepareCall(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    callableStatement.setObject(i + 1, objectArray[i]);
                }
            }
            this.passthruResults(srvSession, callableStatement, null);
        }
    }

    @Override
    public void handleAttention(SrvSession srvSession) {
        try {
            srvSession.sendAttention();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void handleError(SrvSession srvSession, IOException iOException) {
        if (iOException instanceof EOFException || iOException instanceof SSLException) {
            srvSession.close();
            this.removeSession(srvSession);
        }
    }

    public static boolean printSQLWarnings(SQLWarning sQLWarning) throws SQLException {
        boolean bl = false;
        if (sQLWarning != null) {
            bl = true;
            while (sQLWarning != null) {
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
        return bl;
    }

    public static boolean printSQLExceptions(SQLException sQLException) {
        boolean bl = false;
        if (sQLException != null) {
            bl = true;
            while (sQLException != null) {
                sQLException = sQLException.getNextException();
            }
        }
        return bl;
    }

    private Reader cloneReader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter(2048);
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) != -1) {
            charArrayWriter.write(cArray, 0, n);
        }
        return new CharArrayReader(charArrayWriter.toCharArray());
    }

    private InputStream cloneInputStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private void openRemoteConnection() {
        if (this._remoteURL == null) {
            return;
        }
        if (this._remoteServer != null) {
            try {
                if (!this._remoteServer.isClosed()) {
                    return;
                }
                this._remoteServer.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Properties properties = new Properties();
        try {
            Class.forName("com.sybase.jdbc42.jdbc.SybDriver");
            this._remoteServer = DriverManager.getConnection(this._remoteURL, properties);
        }
        catch (SQLException sQLException) {
            this._remoteServer = null;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this._remoteServer = null;
        }
        catch (LinkageError linkageError) {
            this._remoteServer = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._remoteServer = null;
        }
    }

    private String getJConnectVersion() {
        String string = null;
        try {
            Driver driver = (Driver)Class.forName("com.sybase.jdbc42.jdbc.SybDriver").newInstance();
            DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo("jdbc:sybase:Tds:host:1234", new Properties());
            for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
                if (!driverPropertyInfoArray[i].name.equals("VERSIONSTRING")) continue;
                string = driverPropertyInfoArray[i].value;
                break;
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SQLException sQLException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return string;
    }

    private class SrvRegRunner
    extends Thread {
        String _regProc;
        int _initialWait;
        int _iterations;
        int _waitBetweenIterations;
        SrvReceiver _sr;

        SrvRegRunner(SrvReceiver srvReceiver, String string, int n, int n2, int n3) {
            this._sr = srvReceiver;
            this._regProc = string;
            this._initialWait = n;
            this._iterations = n2;
            this._waitBetweenIterations = n3;
        }

        @Override
        public void run() {
            try {
                this.setPriority(this.getPriority() + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object[] objectArray = new Object[]{"Hello there smeggy eyes", new Integer(47)};
            try {
                Thread.sleep(this._initialWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i = 0; i < this._iterations; ++i) {
                this._sr.notifyRegprocListener(this._regProc, objectArray);
                try {
                    Thread.sleep(this._waitBetweenIterations);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

