/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.tds.SrvDataInputStream;
import com.sybase.jdbc42.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc42.tds.SrvParamFormatToken;
import com.sybase.jdbc42.tds.SrvParamsToken;
import com.sybase.jdbc42.tds.SrvSession;
import com.sybase.jdbc42.tds.Token;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class SrvTextImageData {
    private String _writetext = null;
    private static final int DEFTXTPTRSIZE = 8;
    protected byte[] _textptr = null;
    protected long _time = 0L;
    protected byte[] _bytes = new byte[0];
    protected int _length = 0;
    protected InputStream _byteStream = null;
    protected String _tableName = null;

    public SrvTextImageData() {
        this._textptr = new byte[8];
        for (int i = 0; i < this._textptr.length; ++i) {
            this._textptr[i] = 0;
        }
        this._time = 0L;
    }

    public SrvTextImageData(String string) {
        this._writetext = string;
        this._textptr = new byte[8];
        for (int i = 0; i < this._textptr.length; ++i) {
            this._textptr[i] = 0;
        }
        this._time = System.currentTimeMillis();
    }

    public SrvTextImageData(byte[] byArray) {
        this._textptr = new byte[8];
        for (int i = 0; i < this._textptr.length; ++i) {
            this._textptr[i] = 0;
        }
        this._time = System.currentTimeMillis();
        if (byArray != null) {
            this._bytes = byArray;
        }
    }

    public SrvTextImageData(byte[] byArray, long l, byte[] byArray2) {
        this._textptr = byArray;
        if (byArray2 != null) {
            this._bytes = byArray2;
        }
        this._time = l;
    }

    public SrvTextImageData(byte[] byArray, long l, int n, InputStream inputStream) {
        this._textptr = byArray;
        if (inputStream != null) {
            this._byteStream = inputStream;
        }
        this._time = l;
    }

    public int getLength() {
        if (this._bytes != null && this._bytes.length != 0) {
            return this._bytes.length;
        }
        return this._length;
    }

    public int getTextPtrLength() {
        return this._textptr.length;
    }

    public byte[] getTextPtr() {
        return this._textptr;
    }

    public void setTextPtr(byte[] byArray) {
        this._textptr = byArray;
    }

    public long getTimeStamp() {
        return this._time;
    }

    public void setTextPtr(String string) {
        this._textptr = string.getBytes();
    }

    public boolean isNull() {
        return this._bytes == null && this._bytes.length == 0 && this._length == 0;
    }

    public void readBytes(SrvDataInputStream srvDataInputStream) throws IOException {
        this._bytes = new byte[srvDataInputStream.readInt()];
        srvDataInputStream.read(this._bytes);
    }

    public void sendWritetextResult(SrvSession srvSession) throws IOException {
        SrvParamFormatToken srvParamFormatToken = new SrvParamFormatToken();
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvParamFormatToken, srvSession.getClientCapability());
        Date date = new Date();
        srvJavaTypeFormatter.addFormat(date, "pic", 1, 0);
        srvSession.send((Token)srvParamFormatToken);
        SrvParamsToken srvParamsToken = new SrvParamsToken();
        Object[] objectArray = new Object[]{date};
        srvJavaTypeFormatter.convertData((Token)srvParamsToken, objectArray);
        srvSession.send((Token)srvParamsToken);
        srvSession.sendDone(1, false, true, false);
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public String getTableName() {
        return this._tableName == null ? "" : this._tableName;
    }
}

