/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.charset;

import com.sybase.jdbc42.charset.SybUTF8Charset;
import java.io.CharConversionException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.ConcurrentHashMap;

public class CharsetUtil {
    private static ThreadLocal<CharsetEncoder> charsetEncoder = new ThreadLocal();
    private static ThreadLocal<CharsetDecoder> charsetDecoder = new ThreadLocal();
    private static ConcurrentHashMap<String, Charset> CHARSET_CACHE = new ConcurrentHashMap();

    public static Charset getCharset(String string) {
        Charset charset = CHARSET_CACHE.get(string);
        if (charset == null) {
            charset = Charset.forName(string);
            CHARSET_CACHE.put(string, charset);
        }
        return charset;
    }

    public static byte[] fromSybUTF8(String string) throws CharConversionException {
        return CharsetUtil.fromUnicode(string, "x-SybUTF8", SybUTF8Charset.getInstance());
    }

    public static byte[] fromUnicode(String string, String string2, Charset charset) throws CharConversionException {
        if (string2 == null) {
            return string.getBytes();
        }
        byte[] byArray = null;
        CharsetEncoder charsetEncoder = CharsetUtil.charsetEncoder.get();
        if (charsetEncoder == null) {
            try {
                charsetEncoder = charset.newEncoder();
                CharsetUtil.charsetEncoder.set(charsetEncoder);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
        }
        catch (CharacterCodingException characterCodingException) {
            CharConversionException charConversionException = new CharConversionException(characterCodingException.toString());
            charConversionException.initCause(characterCodingException);
            throw charConversionException;
        }
        catch (IllegalStateException illegalStateException) {
            throw new CharConversionException(illegalStateException.toString());
        }
        return byArray;
    }

    public static String toSybUTF8(byte[] byArray) throws CharConversionException {
        return CharsetUtil.toUnicode(byArray, "x-SybUTF8", SybUTF8Charset.getInstance());
    }

    public static String toUnicode(byte[] byArray, String string, Charset charset) throws CharConversionException {
        if (string == null) {
            return new String(byArray);
        }
        String string2 = null;
        CharsetDecoder charsetDecoder = CharsetUtil.charsetDecoder.get();
        if (charsetDecoder == null) {
            charsetDecoder = charset.newDecoder();
            CharsetUtil.charsetDecoder.set(charsetDecoder);
        }
        try {
            string2 = charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            CharConversionException charConversionException = new CharConversionException(characterCodingException.toString());
            charConversionException.initCause(characterCodingException);
            throw charConversionException;
        }
        catch (IllegalStateException illegalStateException) {
            throw new CharConversionException(illegalStateException.toString());
        }
        return string2;
    }
}

