/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.charset;

import com.sybase.jdbc42.charset.CharsetUtil;
import com.sybase.jdbc42.charset.SybUTF8Charset;
import com.sybase.jdbcx.CharsetConverter;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class NioConverter
implements CharsetConverter {
    private String _encoding = null;
    private Charset _charset;

    @Override
    public void setEncoding(String string) throws UnsupportedCharsetException, IllegalCharsetNameException {
        this._encoding = string;
        if (this._encoding.equals("x-SybUTF8")) {
            this._charset = SybUTF8Charset.getInstance();
            return;
        }
        this._charset = Charset.forName(string);
    }

    @Override
    public byte[] fromUnicode(String string) throws CharConversionException {
        return CharsetUtil.fromUnicode(string, this._encoding, this._charset);
    }

    @Override
    public String toUnicode(byte[] byArray) throws CharConversionException {
        return CharsetUtil.toUnicode(byArray, this._encoding, this._charset);
    }
}

