/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.SybConnection;
import com.sybase.jdbc42.tds.SecLoginContext;
import com.sybase.jdbc42.utils.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;

public class PduOutputFormatter
extends FilterOutputStream {
    private int _packetSize;
    private byte[] _netBuf;
    private int _nextOut;
    private int _pduType;
    private int _pduStatus;
    private byte[] _ivBuff;
    private SybConnection _conn;

    public PduOutputFormatter(OutputStream outputStream, int n, SybConnection sybConnection) throws SQLException {
        super(outputStream);
        this.setNetBufSize(n);
        this._nextOut = 8;
        this._pduType = 15;
        this._pduStatus = 0;
        this._conn = sybConnection;
    }

    public void setNetBufSize(int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < this._nextOut; ++n2) {
            byArray[n2] = this._netBuf[n2];
        }
        for (n2 = this._nextOut; n2 < n; ++n2) {
            byArray[n2] = 0;
        }
        this._netBuf = byArray;
        this._packetSize = n;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.isEncryptionEnabled()) {
            this.writeEncryptedData(n);
        } else {
            if (this._nextOut >= this._packetSize) {
                this.doFlush(true);
            }
            this._netBuf[this._nextOut++] = (byte)n;
        }
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    private void writeEncryptedData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.getRequiredEncryptedPacketSize();
        int n4 = n;
        boolean bl = true;
        while (n2 > 0) {
            int n5;
            if (this._nextOut >= n3) {
                this.doEncryptedFlush(true, bl);
                bl = false;
            }
            int n6 = (n5 = n3 - this._nextOut) < n2 - n ? n5 : n2 - n;
            System.arraycopy(byArray, n4, this._netBuf, this._nextOut, n6);
            this._nextOut += n6;
            n2 -= n6;
            n4 += n6;
        }
        if (!bl) {
            this.doEncryptedFlush(false, bl);
        }
    }

    private int getRequiredEncryptedPacketSize() {
        return this._packetSize - 16 - 16 - 1;
    }

    private void writeEncryptedData(int n) throws IOException {
        int n2 = this.getRequiredEncryptedPacketSize();
        if (this._nextOut >= n2) {
            this.doEncryptedFlush(true, true);
        }
        this._netBuf[this._nextOut++] = (byte)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEncryptedFlush(boolean bl, boolean bl2) throws IOException {
        try {
            int n = 0;
            byte[] byArray = null;
            SecLoginContext secLoginContext = this._conn.getSecLoginContext();
            try {
                byte[] byArray2 = Arrays.copyOfRange(this._netBuf, 8, this._nextOut);
                byArray = bl2 ? secLoginContext.encryptData(byArray2) : secLoginContext.encryptData(byArray2, this._ivBuff);
                this._ivBuff = Arrays.copyOfRange(byArray, byArray.length - 16, byArray.length);
                n = byArray.length;
                System.arraycopy(byArray, 0, this._netBuf, 0, n);
                this._netBuf[0] = (byte)this._pduType;
                this._netBuf[1] = bl ? (byte)(this._pduStatus | 0x40) : (byte)(this._pduStatus | 1 | 0x40);
                this._netBuf[2] = (byte)((n & 0xFF00) >> 8);
                this._netBuf[3] = (byte)(n & 0xFF);
                this.out.write(this._netBuf, 0, n);
                if (!bl) {
                    this.out.flush();
                    if (secLoginContext != null && secLoginContext.isSymmetricKeyGenerated()) {
                        secLoginContext.setSymmetricKeyStateSENT();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            this._conn.markDeadTryHA();
        }
        finally {
            this._nextOut = 8;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isEncryptionEnabled()) {
            this.writeEncryptedData(byArray, n, n2);
        } else {
            Debug.asrt(this, n2 + n <= byArray.length, "Offset/Length values are incorrect");
            int n3 = n;
            while (n2 > 0) {
                int n4;
                if (this._nextOut >= this._packetSize) {
                    this.doFlush(true);
                }
                int n5 = (n4 = this._packetSize - this._nextOut) < n2 - n ? n4 : n2 - n;
                System.arraycopy(byArray, n3, this._netBuf, this._nextOut, n5);
                this._nextOut += n5;
                n2 -= n5;
                n3 += n5;
            }
        }
    }

    public void setPDUHeader(int n, int n2) {
        this._pduType = n;
        this._pduStatus = n2;
    }

    @Override
    public void flush() throws IOException {
        if (this.isEncryptionEnabled()) {
            this.doEncryptedFlush(false, true);
        } else {
            this.doFlush(false);
        }
    }

    private boolean isEncryptionEnabled() {
        boolean bl = false;
        SecLoginContext secLoginContext = this._conn.getSecLoginContext();
        try {
            bl = Boolean.parseBoolean(this._conn.getClientInfo("ENCRYPT_COMMAND"));
            bl = bl && secLoginContext.isSymmetricKeySent();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    public void flushBCP(boolean bl) throws IOException {
        if (bl) {
            if (this.isEncryptionEnabled()) {
                this.doEncryptedFlush(false, true);
            } else {
                this.doFlush(false);
            }
        } else {
            try {
                this._netBuf[0] = (byte)this._pduType;
                int n = this._nextOut;
                this._netBuf[1] = (byte)this._pduStatus;
                this._netBuf[2] = (byte)((n & 0xFF00) >> 8);
                this._netBuf[3] = (byte)(n & 0xFF);
                this.out.write(this._netBuf, 0, n);
                this.out.write(new byte[]{6, 1, 0, 8, 0, 0, 0, 0});
            }
            catch (IOException iOException) {
                this._conn.markDeadTryHA();
            }
            finally {
                this._nextOut = 8;
            }
        }
    }

    protected void changeOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(boolean bl) throws IOException {
        try {
            this._netBuf[0] = (byte)this._pduType;
            int n = this._packetSize;
            if (bl) {
                this._netBuf[1] = (byte)this._pduStatus;
            } else {
                this._netBuf[1] = (byte)(this._pduStatus | 1);
                n = this._nextOut;
            }
            this._netBuf[2] = (byte)((n & 0xFF00) >> 8);
            this._netBuf[3] = (byte)(n & 0xFF);
            this.out.write(this._netBuf, 0, n);
            if (!bl) {
                this.out.flush();
                SecLoginContext secLoginContext = this._conn.getSecLoginContext();
                if (secLoginContext != null && secLoginContext.isSymmetricKeyGenerated()) {
                    secLoginContext.setSymmetricKeyStateSENT();
                }
            }
        }
        catch (IOException iOException) {
            this._conn.markDeadTryHA();
        }
        finally {
            this._nextOut = 8;
        }
    }
}

