/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.Convert;
import com.sybase.jdbc42.jdbc.DateObject;
import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.JdbcDataObject;
import com.sybase.jdbc42.jdbc.SybLob;
import com.sybase.jdbc42.jdbc.TextPointer;
import com.sybase.jdbc42.tds.TdsDataOutputStream;
import com.sybase.jdbc42.tds.TdsParam;
import com.sybase.jdbc42.utils.CacheManager;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Calendar;

public class TdsUpdateParam
extends TdsParam
implements JdbcDataObject {
    public TdsUpdateParam(TdsDataOutputStream tdsDataOutputStream, CacheManager cacheManager) {
        super(tdsDataOutputStream);
    }

    @Override
    public boolean isNull() throws SQLException {
        if (this._sqlType == -999 || this._sqlType == -998) {
            ErrorMessage.raiseError("JZ0TC");
        }
        return this._sqlType == 0;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToReader(this._inValue);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.checkStream(false);
        return Convert.objectToBytes(this._inValue);
    }

    @Override
    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        this.checkStream(false);
        return Convert.objectToDateObject(this._inValue, this._sqlTypeName, calendar);
    }

    @Override
    public TextPointer getTextPtr() throws SQLException {
        ErrorMessage.raiseError("JZ0R4");
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkStream(false);
        BigDecimal bigDecimal = Convert.objectToBigDecimal(this._inValue);
        return Convert.setScale(bigDecimal, n);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.checkStream(true);
        return Convert.objectToBoolean(this._inValue);
    }

    @Override
    public byte getByte() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkByteOflo(l);
        return (byte)l;
    }

    @Override
    public double getDouble() throws SQLException {
        this.checkStream(true);
        return Convert.objectToDoubleValue(this._inValue);
    }

    @Override
    public float getFloat() throws SQLException {
        this.checkStream(true);
        return (float)Convert.objectToDoubleValue(this._inValue);
    }

    @Override
    public int getInt() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkIntOflo(l);
        return (int)l;
    }

    @Override
    public long getLong() throws SQLException {
        this.checkStream(true);
        return Convert.objectToLongValue(this._inValue);
    }

    @Override
    public Object getObject() throws SQLException {
        this.checkStream(false);
        return this._inValue;
    }

    @Override
    public short getShort() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkShortOflo(l);
        return (short)l;
    }

    @Override
    public String getString() throws SQLException {
        this.checkStream(false);
        return Convert.objectToString(this._inValue);
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.checkStream(false);
        return (Blob)((Object)Convert.objectToLob(this._inValue, SybLob.LOB_TYPE.IMAGE));
    }

    @Override
    public Clob getClob() throws SQLException {
        this.checkStream(false);
        return (Clob)((Object)Convert.objectToLob(this._inValue, SybLob.LOB_TYPE.TEXT));
    }

    @Override
    public NClob getNClob() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob()");
        return null;
    }

    private void checkStream(boolean bl) throws SQLException {
        if (this._inValue == null) {
            if (bl) {
                ErrorMessage.raiseError("JZ0TC");
            }
        } else if (this._inValue instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
    }

    @Override
    public Clob getInitializedClob() {
        return null;
    }

    @Override
    public Blob getInitializedBlob() {
        return null;
    }

    @Override
    public NClob getInitializedNClob() {
        return null;
    }

    @Override
    public SQLWarning getWarning() throws SQLException {
        return null;
    }

    @Override
    public void clearWarning() throws SQLException {
    }
}

