/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.util;

import java.io.ByteArrayOutputStream;

public final class Strings {
    public static String fromUTF8ByteArray(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            ++n2;
            if ((byArray[n] & 0xF0) == 240) {
                ++n2;
                n += 4;
                continue;
            }
            if ((byArray[n] & 0xE0) == 224) {
                n += 3;
                continue;
            }
            if ((byArray[n] & 0xC0) == 192) {
                n += 2;
                continue;
            }
            ++n;
        }
        char[] cArray = new char[n2];
        n = 0;
        n2 = 0;
        while (n < byArray.length) {
            char c;
            if ((byArray[n] & 0xF0) == 240) {
                int n3 = (byArray[n] & 0xF) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
                int n4 = n3 - 65536;
                char c2 = (char)(0xD800 | n4 >> 10);
                char c3 = (char)(0xDC00 | n4 & 0x3FF);
                cArray[n2++] = c2;
                c = c3;
                n += 4;
            } else if ((byArray[n] & 0xE0) == 224) {
                c = (char)((byArray[n] & 0x1F) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F);
                n += 3;
            } else if ((byArray[n] & 0xC0) == 192) {
                c = (char)((byArray[n] & 0x3F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else {
                c = (char)(byArray[n] & 0xFF);
                ++n;
            }
            cArray[n2++] = c;
        }
        return new String(cArray);
    }

    public static byte[] toUTF8ByteArray(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byteArrayOutputStream.write(c);
                continue;
            }
            if (c < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c >> 6);
                byteArrayOutputStream.write(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                if (i + 1 >= cArray.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char c2 = c;
                char c3 = c = cArray[++i];
                if (c2 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int n = ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                byteArrayOutputStream.write(0xF0 | n >> 18);
                byteArrayOutputStream.write(0x80 | n >> 12 & 0x3F);
                byteArrayOutputStream.write(0x80 | n >> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | n & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c >> 12);
            byteArrayOutputStream.write(0x80 | c >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c & 0x3F);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toUpperCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            char c = cArray[i];
            if ('a' > c || 'z' < c) continue;
            bl = true;
            cArray[i] = (char)(c - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            char c = cArray[i];
            if ('A' > c || 'Z' < c) continue;
            bl = true;
            cArray[i] = (char)(c - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }
}

