@echo off
setlocal

set title=SEK-EMDB-Admin-console
title %title%

set APPL_NAME=EmdbAdmin

set JAVA_MAIN_CLASS=se.sek.emdb.admin.EmdbAdmin


rem ------------------------------------------------------------------------
rem --- set EMDB_ADMIN_HOME to current directory if NOT already set
rem ------------------------------------------------------------------------
IF "%EMDB_ADMIN_HOME%"=="" set EMDB_ADMIN_HOME=%~dp0

rem --- IF "%SYBASE%"=="" set SYBASE=c:\sybase



rem ------------------------------------------------------------------------
rem --- remove last '\' char from: EMDB_ADMIN_HOME and SYBASE
rem --- EMDB_ADMIN_HOME exists every time, while SYBASE is NOT mandatory
rem --- Also for SYBASE
rem ---    Trim begin/end Quote (") character from the SYBASE environment variable 
rem ---    The FOR command can be used to safely remove quotes surrounding a string. 
rem ---    If SYBASE does not have quotes then it will remain unchanged.
rem ---    If SYBASE is not set, it will still NOT be set after this
rem --- Tested the below with SYBASE set to:
rem --- set SYBASE=
rem --- set SYBASE=c:\Program Files\sybase
rem --- set SYBASE=c:\Program Files\sybase\
rem --- set SYBASE="c:\Program Files\sybase"
rem --- set SYBASE="c:\Program Files\sybase\"
rem --- set SYBASE=c:\sybase
rem ------------------------------------------------------------------------
IF %EMDB_ADMIN_HOME:~-1%==\ SET EMDB_ADMIN_HOME=%EMDB_ADMIN_HOME:~0,-1%

IF NOT DEFINED SYBASE goto afterStripSybase
for /f "useback tokens=*" %%a in ('%SYBASE%') do set SYBASE=%%~a
IF %SYBASE:~-1%==\ SET SYBASE=%SYBASE:~0,-1%
:afterStripSybase



rem ------------------------------------------------------------------------
rem --- set some CONSOLE windows and buffer size
rem ------------------------------------------------------------------------
rem ---set /a "winsize=(64 << 16) + 80"
rem ---set /a "bufsize=(3000 << 16) + 800"
rem --->nul reg add "hkcu\console\%title%" /v WindowSize /t REG_DWORD /d "%winsize%" /f
rem --->nul reg add "hkcu\console\%title%" /v ScreenBufferSize /t REG_DWORD /d "%bufsize%" /f



rem ------------------------------------------------------------------------
rem --- set some default environment variables
rem ------------------------------------------------------------------------
set APPL_HOME=%EMDB_ADMIN_HOME%
set EMDB_ADMIN_SAVE_DIR=%EMDB_ADMIN_HOME%\data

rem set JAVA_HOME=%SYBASE_JRE%
rem set JAVA_HOME=%SYBASE%\shared-1_0\JRE-1_4
rem set JAVA_HOME=C:\Program Files\Java\jdk1.6.0_07



rem ------------------------------------------------------------------------
rem --- set JVM parameters   and   DEBUG stuff
rem ------------------------------------------------------------------------
set JVM_PARAMS=-Xmx700m
rem --- set JVM_PARAMS=%JVM_PARAMS% -Dhttp.proxyHost=www-proxy.ericsson.se -Dhttp.proxyPort=8080
rem --- set JVM_PARAMS=%JVM_PARAMS% -Dcom.sun.management.jmxremote
rem --- set JVM_PARAMS=%JVM_PARAMS% -Djava.net.useSystemProxies=true

set EXTRA=%NOGUI%
rem --- set DEBUG_OPTIONS=-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=2323,server=y,suspend=n
rem --- set DEBUG_OPTIONS=-agentlib:hprof=cpu=samples,interval=20,depth=50
rem --- set DEBUG_OPTIONS=-agentlib:hprof=cpu=times
set DEBUG_OPTIONS=

set SPLASH=-splash:lib/emdb_admin_splash.jpg



rem ------------------------------------------------------------------------
rem --- if environment is not properly set, do something about it
rem --- this might mean goto an exit point
rem ------------------------------------------------------------------------
IF NOT DEFINED EMDB_ADMIN_HOME GOTO no_apphome
rem IF NOT DEFINED JAVA_HOME GOTO no_javahome



rem ------------------------------------------------------------------------
rem --- setup the CLASSPATH
rem ------------------------------------------------------------------------
set classpath=%EMDB_ADMIN_HOME%\bin
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\emdb_admin.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\jconn4.jar
rem --- set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\ojdbc6.jar
rem --- set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\ngdbc.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\sqljdbc41.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\log4j-1.2.17.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\miglayout-swing-4.2.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\miglayout-core-4.2.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\swingx-all-1.6.5-1.jar
rem set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\swingx-all-1.6.4.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\commons-cli-1.2.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\rsyntaxtextarea.jar
set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\gson-2.8.0.jar
rem set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\autocomplete.jar
rem set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\rstaui.jar
rem set classpath=%classpath%;%EMDB_ADMIN_HOME%\lib\jcommon-1.0.21.jar

set classpath=%classpath%;%USERPROFILE%\.dbmtk\jdbc_drivers\*
set classpath=%classpath%;%EXTRA_JDBC_DRIVERS%


rem ------------------------------------------------------------------------
rem --- set PATH, just add JAVA_HOME at the start
rem ------------------------------------------------------------------------
set PATH=%EMDB_ADMIN_JAVA_HOME%\bin;%JAVA_HOME%\bin;%PATH% 	


rem ------------------------------------------------------------------------
rem --- Just for informational purposes, print out the Java Version we are using
rem ------------------------------------------------------------------------
java -version



rem ------------------------------------------------------------------------
rem --- CHECK current Java Version
rem ------------------------------------------------------------------------
java se.sek.emdb.admin.utils.JavaVersion 7
IF %ERRORLEVEL% NEQ 0 GOTO to_low_java_version


rem ------------------------------------------------------------------------
rem --- SET memory parameters, if 64 bit java: add more memory
rem ------------------------------------------------------------------------
java se.sek.emdb.admin.utils.JavaBitness
set JavaBitness=%ERRORLEVEL%
rem ---echo Java Bitness: %JavaBitness%


rem ------------------------------------------------------------------------
rem --- Include 32/64-bit MS SQL-Server Windows Authentication Login DLL in the PATH
rem ------------------------------------------------------------------------
set MSSQL_AUTH_PATH=
if %JavaBitness% == 64 (
	set MSSQL_AUTH_PATH=%EMDB_ADMIN_HOME%\lib\sqlserver_auth\x64
) else (
	set MSSQL_AUTH_PATH=%EMDB_ADMIN_HOME%\lib\sqlserver_auth\x86
)
set PATH=%MSSQL_AUTH_PATH%;%PATH%



rem ------------------------------------------------------------------------
rem --- START: just call java, it should have been added to the path priviously
rem --- pushd \\192.168.0.130\xxx\yyy     if it's a UNC path like the example, pushd will map a network drive, which will be unmounted at popd
rem ------------------------------------------------------------------------
pushd %EMDB_ADMIN_HOME%
REM echo %CLASSPATH%

rem set START_CMD=start /min
%START_CMD% java %JVM_PARAMS% -DAPPL_NAME="%APPL_NAME%" -Dsybase.home="%SYBASE%" -DSYBASE="%SYBASE%" -DAPPL_HOME="%EMDB_ADMIN_HOME%" -DEMDB_ADMIN_HOME="%EMDB_ADMIN_HOME%" -DEMDB_ADMIN_SAVE_DIR="%EMDB_ADMIN_SAVE_DIR%" %EXTRA% %DEBUG_OPTIONS% %SPLASH% %JAVA_MAIN_CLASS% %*

IF %ERRORLEVEL% NEQ 0 GOTO unexpected_error
goto exit_batfile



rem ------------------------------------------------------------------------
rem --- Various exit points
rem ------------------------------------------------------------------------

:no_apphome
echo -----------------------------------------------------------------------
echo Error: no EMDB_ADMIN_HOME environment variable.
echo -----------------------------------------------------------------------
echo Must set the EMDB_ADMIN_HOME variable to the place where you installed it.
echo -----------------------------------------------------------------------
pause
goto exit_batfile

:no_javahome
echo -----------------------------------------------------------------------
echo Error: no JAVA_HOME environment variable.
echo -----------------------------------------------------------------------
echo Must set the JAVA_HOME variable to the place where JDK or JRE is installed.
echo -----------------------------------------------------------------------
pause
goto exit_batfile

:to_low_java_version
echo -----------------------------------------------------------------------
echo Error: Use a higher java version.
echo -----------------------------------------------------------------------
echo The java installation can be pointed out using the variable JAVA_HOME
echo Current EMDB_ADMIN_JAVA_HOME    variable is set to %EMDB_ADMIN_JAVA_HOME%
echo Current JAVA_HOME         variable is set to %JAVA_HOME%
echo -----------------------------------------------------------------------
pause
goto exit_batfile

:unexpected_error
echo .
echo -----------------------------------------------------------------------
echo Unexpected Error: Return code from java was NOT 0
echo -----------------------------------------------------------------------
echo If you have problems to start the tool, please email me the above output
echo And I will make sure to solve the issue for you!
echo -----------------------------------------------------------------------
echo Mail to: goran.schwarz@sek.se
echo Subject: EMDB Admin starting problem
echo -----------------------------------------------------------------------
echo .
pause
goto exit_batfile

:exit_batfile
popd

rem pause
pause
endlocal
