--create database gorans_v2
--use gorans_v2
--use master
--create database Birds
-- sp_who 
/*
select * from dbo.tblFamily
select * from dbo.tblLocation
select * from dbo.tblObservation
select * from dbo.tblObserver
select * from dbo.tblSpecies
exec sp_spaceused 'MUREXDB.ACCOUNT#APR2005#ACC_DT1_DBF', 1
exec sp_spaceused 'MUREXDB.ACCOUNT#', 1
*/
-- select * from sysprocesses where sid > 0x01
go
----------------------------------------------------------------------------------
-- 
----------------------------------------------------------------------------------
--select * from SystemVariables
----select * from SystemAllocations
--select * from SystemToGrid
--select * from Systems
--go
--select * from Resources_AppServer
--select * from Resources_Grid
--select * from Resources_Dbms
--go
--select * from AllocationTypes
--select * from Versions
--go
--
----select * from AllocationTypes
----select * from SystemAllocations     where systemName = 'prod'
--select * from SystemToGrid  where systemName = 'prod'
--select * from Resources_Grid        where resourceName like 'grid%'
go


----------------------------------------------------------------------------------
-- drop tables
----------------------------------------------------------------------------------
drop table SystemVariables
go
--drop table SystemAllocations
go
drop table SystemToGrid
go
drop table SystemToGridProps
go
drop table Systems
go

drop table Resources_AppServer
go
drop table Resources_Grid
go
drop table Resources_Dbms
go

--drop table AllocationTypes
go
drop table Versions -- or SystemVersions
go

--------------------------------------------------------------------------
-- drop functions
--------------------------------------------------------------------------
drop function getActiveVersion
go

--------------------------------------------------------------------------
-- drop procedures
--------------------------------------------------------------------------
drop procedure closeActiveVersion
go
drop procedure setActiveVersion
go
drop procedure deleteVersion
go
drop procedure newVersion
go

-- Check if we have dropped all objects
select type_desc, count(*)
from sys.objects
where type_desc not in ('SYSTEM_TABLE', 'INTERNAL_TABLE', 'SERVICE_QUEUE')
  and not (type_desc = 'USER_TABLE' and name like 'sys%')
  and not (type_desc = 'SQL_STORED_PROCEDURE' and name like 'sp_%')
  and not (type_desc = 'SQL_SCALAR_FUNCTION'  and name in ('fn_diagramobjects'))
  and not (parent_object_id = object_id('sysdiagrams'))
group by type_desc
--select * from sys.objects where type_desc not in ('SYSTEM_TABLE', 'INTERNAL_TABLE', 'SERVICE_QUEUE')
go


/*========================================================================
** This is GLOBAL, meaning it's not version handled
*/
--create table AllocationTypes
--(
--	resourceType    varchar(30)   not null,  -- type of resouce we references to
--	minEntries      int           not null,  -- 
--	maxEntries      int           not null,  -- 
--	resourceTable   varchar(30)       null,  -- name of the table where you find the resource specification
--	propsTable      varchar(30)       null,  -- name of the table if there are specific properties that is stored for a Allocation
--
--	primary key(resourceType),
--)
go

/*========================================================================
** This is GLOBAL, meaning it's not version handled
** Probably not used, since we use DBMS roles authorizations instead...
*/
--create table UserRoles
--(
--	userName        varchar(30)   not null,  -- ...
--	roleName        varchar(30)   not null,  -- ...
--	xxx             varchar(30)       null,  -- ...
--)
go




/*========================================================================
**
*/
create table Versions -- or SystemVersions
(
	versionId    int           not null,  -- PK

	name         varchar(60)   not null,  -- Name tag.
	status       char(1)       not null,  -- Planed, Active, History   (note only 1 should be in 'ACTIVE'... lifetime is: Planed -> Active -> History)  if we a in Planing and does Delete: no-history-is-traced(just do delete)
	responible   varchar(30)   not null,  -- Name of the person responsible for this Version.
	crDate       datetime      not null,  -- When this version was created
	releaseDate  datetime          null,  -- When this version was released
	historyDate  datetime          null,  -- When this version was changed from ACTIVE to HISTORY

	primary key(versionId),
	constraint statusChk check (status in('P','A','H')),
)
go




/*========================================================================
**
*/
create table Resources_AppServer
(
	versionId       int           not null,
	resourceName    varchar(64)   not null,  -- PK

	hostname        varchar(64)   not null,  -- name of the host (Linux: getconf HOST_NAME_MAX)
--	cpuSize         int           not null,  -- is this needed or not...

	primary key(versionId, resourceName),
	constraint fk_Resources_AppServer_ver foreign key(versionId) references Versions(versionId),
)
go

/*========================================================================
**
*/
create table Resources_Grid
(
	versionId       int           not null,
	resourceName    varchar(64)   not null,  -- PK

	hostname        varchar(64)   not null,  -- name of the host (Linux: getconf HOST_NAME_MAX)
--	cpuSize         int           not null,  -- How many CPU  slots can this GRID resource accept
--	coreSize        int           not null,  -- How many CORE slots can this GRID resource accept
	cpuType1Size    int           not null,  -- How many CPU  slots can this GRID resource accept
	cpuType2Size    int           not null,  -- How many CPU  slots can this GRID resource accept
	gpuSize         int           not null,  -- How many GPU  slots can this GRID resource accept

	primary key(versionId, resourceName),
	constraint fk_Resources_Grid_ver foreign key(versionId) references Versions(versionId),
)
go

/*========================================================================
**
*/
create table Resources_Dbms
(
	versionId       int           not null,
	resourceName    varchar(64)   not null,  -- PK

	vendor          varchar(64)   not null,  -- 
	version         varchar(64)   not null,  -- 
	hostname        varchar(64)   not null,  -- name of the host (Linux: getconf HOST_NAME_MAX)
	portNum         int           not null,  -- 
--	xxx             int           not null,  -- 
--	yyy             int           not null,  -- 

	primary key(versionId, resourceName),
	constraint fk_Resources_Dbms_ver foreign key(versionId) references Versions(versionId),
)
go

/*========================================================================
**
*/
create table Systems
(
	versionId         int           not null,
	systemName        varchar(30)   not null,  -- PK

	validFromDate     datetime          null,
	validToDate       datetime          null,
	projectName       varchar(30)   not null,  -- This system is used by the project (could be a pointer to it's own table with project information)
	contactPerson     varchar(30)   not null,  -- Responsible contact person (could be a pointer to it's own table with contact information)
	comment           varchar(255)      null,  -- 
--	xxxxxxxx          xxxxxxxx      not null,

--	parentVersionId   int               null,
--	parentSystemName  varchar(30)       null,

	resourceAppServer varchar(64)       null,
	resourceDbms      varchar(64)       null,
--	resourceGrid      varchar(64)       null, -- you can have several GRID's connected to one system so this is handled by the "connecting" Table: 

	primary key(versionId, systemName),
	constraint fk_Systems_ver  foreign key(versionId)         references Versions(versionId),
	constraint fk_AppServer    foreign key(versionId, resourceAppServer) references Resources_AppServer(versionId, resourceName),
	constraint fk_Dbms         foreign key(versionId, resourceDbms)      references Resources_Dbms     (versionId, resourceName),
--	constraint fk_SystemParent foreign key(parentVersionId, parentSystemName) references Systems(versionId, systemName),
)
go


/*========================================================================
**
*/
create table SystemVariables
(
	versionId       int           not null,
	systemName      varchar(30)   not null,

	varName         varchar(30)   not null,  --- PK
	intValue        int               null,
	strValue        varchar(255)      null,

	primary key(versionId, systemName, varName),
	constraint fk_SystemVariables_system foreign key(versionId, systemName) references Systems(versionId, systemName),
)
go




/*========================================================================
**
*/
--create table SystemAllocations
--(
--	versionId       int           not null,
--	systemName      varchar(30)   not null,
--	resourceType    varchar(30)   not null,
--	resourceName    varchar(64)   not null,  -- PK
--
----	validFromDate   datetime          null,  -- if a "lease" period starts after the SYSTEM validFromDate, I don't think this will be used... "lease" should only be at "system" level
----	validToDate     datetime          null,  -- if a "lease" period ends before the SYSTEM validToDate, I don't think this will be used... "lease" should only be at "system" level
--
--	primary key(versionId, systemName, resourceType, resourceName),
--	constraint fk_SystemAllocations_system  foreign key(versionId, systemName) references Systems(versionId, systemName),
--	constraint fk_SystemAllocations_resType foreign key(resourceType) references AllocationTypes(resourceType),
--)
go

--create table AllocationProps_Grid
--(
--	versionId       int           not null,
--	systemName      varchar(30)   not null,
--	resourceName    varchar(64)   not null,  -- PK
--
--	subType         varchar(30)   not null,  -- CPU, CORE, GPU
--	subId           int               null,  -- if type=GPU, then this is the ID (GPU_#)
--	size            int           not null,
--
----	primary key(subType, gpuId, resourceName, systemName, versionId),
--)
go
--create index AllocationProps_Grid_ix1 on AllocationProps_Grid(versionId, systemName, resourceName, subType)
go


/*========================================================================
**
*/
create table SystemToGridProps
(
	subType      varchar(30)   not null,

	primary key(subType),
)
go
insert into SystemToGridProps values('CPU_T1')
insert into SystemToGridProps values('CPU_T2')
insert into SystemToGridProps values('GPU_0')
insert into SystemToGridProps values('GPU_1')
insert into SystemToGridProps values('GPU_2')
insert into SystemToGridProps values('GPU_3')
go


create table SystemToGrid
(
	versionId       int           not null,
	systemName      varchar(30)   not null,
	resourceName    varchar(64)   not null,  -- PK

	subType         varchar(30)   not null,  -- CPU_T1, CPU_T2, GPU
--	gpuId           int               null,  -- if type=GPU, then this is the ID (GPU_#)
	size            int           not null,

	primary key(versionId, systemName, resourceName, subType),
	constraint fk_ToSystem  foreign key(versionId, systemName)   references Systems       (versionId, systemName),
	constraint fk_ToGridRes foreign key(versionId, resourceName) references Resources_Grid(versionId, resourceName),
	constraint fk_ToProp    foreign key(subType)                 references SystemToGridProps(subType),
)
go



---ok, lets throw in some test data and see if it holds...

--delete from AllocationTypes
delete from Versions
go

--    -----------------------------
--    --- Static
--    -----------------------------
--    --insert into AllocationTypes(resourceType, minEntries, maxEntries, resourceTable, propsTable)  values('APP',  1, 1,     'Resources_AppServer', null)
--    --insert into AllocationTypes(resourceType, minEntries, maxEntries, resourceTable, propsTable)  values('DBMS', 1, 1,     'Resources_Dbms',      null)
--    --insert into AllocationTypes(resourceType, minEntries, maxEntries, resourceTable, propsTable)  values('GRID', 1, 99999, 'Resources_Grid',      'AllocationProps_Grid')
--    go
--    insert into Versions(versionId, status, responible, crDate, releaseDate, historyDate) values(0, 'A', suser_name(), getdate(), getdate(), null)
--    --insert into Versions(versionId, status, responible, crDate, releaseDate, historyDate) values(0, 'A', 'gosc', getdate(), getdate(), null)
--    go
--    
--    -----------------------------
--    --- RESOURCES
--    -----------------------------
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'appmx3cl2', 'appmx3cl2.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test0',     'srv-mxgtest0.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test1',     'srv-mxgtest1.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test14',    'sek-mxgtest14.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test25',    'sek-mxgtest25.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test32',    'sek-mxgtest32.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test33',    'sek-mxgtest33.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test35',    'sek-mxgtest35.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test38',    'sek-mxgtest38.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test45',    'sek-mxgtest45.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test47',    'sek-mxgtest47.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test48',    'sek-mxgtest48.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test51',    'sek-mxgtest51.sek.se')
--    insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test52',    'sek-mxgtest52.sek.se')
--    go
--    
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid1',   'srv-mxgrid1.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid2',   'srv-mxgrid2.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid3',   'srv-mxgrid3.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid4',   'srv-mxgrid4.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid5',   'srv-mxgrid5.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid6',   'srv-mxgrid6.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid7',   'srv-mxgrid7.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid8',   'srv-mxgrid8.sek.se',    10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt1',  'srv-mxgridt1.sek.se',   10, 10, 1)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt2',  'srv-mxgridt2.sek.se',   10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt3',  'srv-mxgridt3.sek.se',   10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt4',  'srv-mxgridt4.sek.se',   15, 15, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt5',  'srv-mxgridt5.sek.se',   15, 15, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt6',  'srv-mxgridt6.sek.se',   15, 15, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt7',  'srv-mxgridt7.sek.se',   10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt8',  'srv-mxgridt8.sek.se',   10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt9',  'srv-mxgridt9.sek.se',   10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt10', 'srv-mxgridt10.sek.se',  10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt11', 'srv-mxgridt11.sek.se',  10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt12', 'srv-mxgridt12.sek.se',  10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt13', 'srv-mxgridt13.sek.se',  10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt14', 'srv-mxgridt14.sek.se',  10, 10, 4)
--    insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt15', 'srv-mxgridt15.sek.se',  10, 10, 4)
--    go
--    
--    insert into Resources_Dbms(versionId, resourceName, vendor, version, hostname, portNum) values(0, 'SYB_SEK_MXGT38', 'Sybase', '15.7 SP64', 'sek-sybtest38.sek.se', 7038)
--    go
--    
--    -- ====================================================
--    -- Allocations
--    -- ====================================================
--    
--    
--    --------------------------------
--    -- Production Env
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'prod', null, null, 'x', 'x', 'Production Env', 'appmx3cl2', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'APP',  'appmx3cl2')
--    ----insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'DBMS', 'xxxxxxxxx')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'GRID', 'grid1')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'GRID', 'grid2')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'GRID', 'grid3')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'prod', 'GRID', 'grid4')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid1', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid2', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid3', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'prod', 'grid4', 'GPU',    3, 1)
--    go
--    
--    --------------------------------
--    -- Acc Env
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv0', null, null, 'x', 'x', 'Preprod', 'test0', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv0', 'APP',  'test0')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv0', 'GRID', 'gridt6')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv0', 'GRID', 'gridt14')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt6', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv0', 'gridt14', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- Perf Env
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'test1', null, null, 'x', 'x', 'Perf Env', 'test1', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'APP',  'test1')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt2')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt3')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt7')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt8')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt10')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt11')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt12')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'test1', 'GRID', 'gridt13')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt2', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt3', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt7', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt8', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt10', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt11', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt12', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'test1', 'gridt13', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv14
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv14', null, null, 'x', 'x', 'TEST2', 'test14', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv14', 'APP',  'test14')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv14', 'GRID', 'grid5')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv14', 'grid5', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv14', 'grid5', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv14', 'grid5', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv14', 'grid5', 'GPU',    1, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv25
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv25', null, null, 'x', 'x', 'TEST1', 'test25', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv25', 'APP',  'test25')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv25', 'GRID', 'gridt5')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv25', 'GRID', 'gridt15')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt5', 'GPU',    3, 1)
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv25', 'gridt15', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- Gorans Dummy Test 1	
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'Gorans DT 1', null, null, 'x', 'x', 'tech utv', 'test38', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'Gorans DT 1', 'APP',  'test38')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'Gorans DT 1', 'GRID', 'gridt1')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'Gorans DT 1', 'gridt1', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'Gorans DT 1', 'gridt1', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'Gorans DT 1', 'gridt1', 'GPU',    0, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv32
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv32', null, null, 'x', 'x', 'DEV03', 'test32', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv32', 'APP',  'test32')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv32', 'GRID', 'gridt9')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv32', 'gridt9', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv32', 'gridt9', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv32', 'gridt9', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv32', 'gridt9', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv33
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv33', null, null, 'x', 'x', 'DEV1', 'test33', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv33', 'APP',  'test33')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv33', 'GRID', 'grid8')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv33', 'grid8', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv33', 'grid8', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv33', 'grid8', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv33', 'grid8', 'GPU',    1, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv35
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv35', null, null, 'x', 'x', '', 'test35', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv35', 'APP',  'test35')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv35', 'GRID', 'grid8')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv35', 'grid8', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv35', 'grid8', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv35', 'grid8', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv35', 'grid8', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv45
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv45', null, null, 'x', 'x', '', 'test45', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv45', 'APP',  'test45')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv45', 'GRID', 'grid7')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv45', 'grid7', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv47
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv47', null, null, 'x', 'x', 'path3', 'test47', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv47', 'APP',  'test47')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv47', 'GRID', 'gridt9')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv47', 'gridt9', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv47', 'gridt9', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv47', 'gridt9', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv47', 'gridt9', 'GPU',    1, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv48
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv48', null, null, 'x', 'x', '', 'test48', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv48', 'APP',  'test48')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv48', 'GRID', 'gridt6')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'CPU_T2', 2, 10)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'GPU',    0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'GPU',    1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv48', 'gridt6', 'GPU',    3, 1)
--    go   
--    
--    
--    --------------------------------
--    -- utv51
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv51', null, null, 'x', 'x', 'path3', 'test51', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv51', 'APP',  'test51')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv51', 'GRID', 'grid5')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv51', 'grid5', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv51', 'grid5', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv51', 'grid5', 'GPU',    2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv51', 'grid5', 'GPU',    3, 1)
--    go
--    
--    
--    --------------------------------
--    -- utv52
--    --------------------------------
--    insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) 
--    values(0, 'utv52', null, null, 'x', 'x', '', 'test52', null)
--    go
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv52', 'APP',  'test52')
--    --insert into SystemAllocations(versionId, systemName, resourceType, resourceName) values(0, 'utv52', 'GRID', 'gridt4')
--    go
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'CPU_T1', 1, 2)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'CPU_T2', 2, 5)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'GPU', 0, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'GPU', 1, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'GPU', 2, 1)
--    insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(0, 'utv52', 'gridt4', 'GPU', 3, 1)
--    go
go


--------------------------------------------------------------------------------------------------
-- Below SQL was generated at: 2017-04-20 00:00:00
--------------------------------------------------------------------------------------------------
-- JSON Source: http://sek-syslog/cmdb/getGridCfg.php
-- JSON Deployment date: 2017-01-30
-- JSON Deployment version: 1.4
--------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------
-- Version Information
---------------------------------------------------------------------------
insert into Versions(versionId, name, status, responible, crDate, releaseDate, historyDate) values(0, 'from old system', 'A', suser_name(), getdate(), getdate(), null)
go


---------------------------------------------------------------------------
-- Resources
---------------------------------------------------------------------------
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'appmx3cl2', 'appmx3cl2.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test0', 'srv-mxgtest0.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test1', 'srv-mxgtest1.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test2', 'srv-mxgtest2.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test4', 'srv-mxgtest4.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test14', 'sek-mxgtest14.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test25', 'sek-mxgtest25.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test32', 'sek-mxgtest32.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test33', 'sek-mxgtest33.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test35', 'sek-mxgtest35.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test38', 'sek-mxgtest38.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test45', 'sek-mxgtest45.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test47', 'sek-mxgtest47.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test48', 'sek-mxgtest48.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test51', 'sek-mxgtest51.sek.se')
insert into Resources_AppServer(versionId, resourceName, hostname) values(0, 'test52', 'sek-mxgtest52.sek.se')
go

insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid1', 'srv-mxgrid1.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid2', 'srv-mxgrid2.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid3', 'srv-mxgrid3.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid4', 'srv-mxgrid4.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid5', 'srv-mxgrid5.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid6', 'srv-mxgrid6.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid7', 'srv-mxgrid7.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'grid8', 'srv-mxgrid8.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt1', 'srv-mxgridt1.sek.se', 10, 0, 1)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt2', 'srv-mxgridt2.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt3', 'srv-mxgridt3.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt4', 'srv-mxgridt4.sek.se', 15, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt5', 'srv-mxgridt5.sek.se', 15, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt6', 'srv-mxgridt6.sek.se', 15, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt7', 'srv-mxgridt7.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt8', 'srv-mxgridt8.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt9', 'srv-mxgridt9.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt10', 'srv-mxgridt10.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt11', 'srv-mxgridt11.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt12', 'srv-mxgridt12.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt13', 'srv-mxgridt13.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt14', 'srv-mxgridt14.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt15', 'srv-mxgridt15.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt16', 'srv-mxgridt16.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt17', 'srv-mxgridt17.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt18', 'srv-mxgridt18.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt19', 'srv-mxgridt19.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt20', 'srv-mxgridt20.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt21', 'srv-mxgridt21.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt22', 'srv-mxgridt22.sek.se', 10, 0, 4)
insert into Resources_Grid (versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(0, 'gridt23', 'srv-mxgridt23.sek.se', 10, 0, 4)
go

insert into Resources_Dbms(versionId, resourceName, vendor, version, hostname, portNum) values(0, 'SYB_SEK_MXGT38', 'Sybase', '15.7 SP64', 'sek-sybtest38.sek.se', 7038)
go


--#########################################################################
-- Allocations
--#########################################################################

---------------------------------------------------------------------------
-- prod
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'prod', null, null, 'unknown', 'unknown', 'Production Env', 'appmx3cl2', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid1', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid2', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid3', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid4', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid5', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid6', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid7', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'prod', 'grid8', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv0
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv0', null, null, 'unknown', 'unknown', 'Preprod', 'test0', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt6', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv0', 'gridt14', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- mxtest1
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'mxtest1', null, null, 'unknown', 'unknown', 'Perf Env 1', 'test1', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'CPU_T1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt2', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt3', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt3', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt3', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt3', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt7', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt7', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt7', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt7', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt8', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt8', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt8', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt8', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt10', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt10', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt10', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt10', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt11', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt11', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt11', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt11', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt12', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt12', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt12', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt12', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt13', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt13', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt13', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest1', 'gridt13', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- mxtest2
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'mxtest2', null, null, 'unknown', 'unknown', 'Perf Env 2', 'test2', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt21', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt22', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt22', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt22', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt22', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt23', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt23', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt23', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest2', 'gridt23', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- mxtest4
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'mxtest4', null, null, 'unknown', 'unknown', 'Perf Env light', 'test4', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'mxtest4', 'gridt20', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv14
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv14', null, null, 'unknown', 'unknown', 'TEST2', 'test14', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv14', 'gridt16', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv14', 'gridt16', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv14', 'gridt16', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv14', 'gridt16', 'GPU_1', 1)
go



---------------------------------------------------------------------------
-- utv25
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv25', null, null, 'unknown', 'unknown', '', 'test25', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'CPU_T2', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt5', 'GPU_3', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv25', 'gridt15', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- Gorans Dummy Test 1
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'Gorans Dummy Test 1', null, null, 'unknown', 'unknown', '', 'test38', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'Gorans Dummy Test 1', 'gridt1', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'Gorans Dummy Test 1', 'gridt1', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'Gorans Dummy Test 1', 'gridt1', 'GPU_0', 1)
go



---------------------------------------------------------------------------
-- utv32
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv32', null, null, 'unknown', 'unknown', 'DEV03', 'test32', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv32', 'gridt9', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv32', 'gridt9', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv32', 'gridt9', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv32', 'gridt9', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv33
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv33', null, null, 'unknown', 'unknown', 'DEV1', 'test33', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv33', 'gridt19', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv33', 'gridt19', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv33', 'gridt19', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv33', 'gridt19', 'GPU_1', 1)
go



---------------------------------------------------------------------------
-- utv35
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv35', null, null, 'unknown', 'unknown', '', 'test35', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv35', 'gridt19', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv35', 'gridt19', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv35', 'gridt19', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv35', 'gridt19', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv45
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv45', null, null, 'unknown', 'unknown', '', 'test45', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv45', 'gridt18', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv47
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv47', null, null, 'unknown', 'unknown', 'patch3', 'test47', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv47', 'gridt9', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv47', 'gridt9', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv47', 'gridt9', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv47', 'gridt9', 'GPU_1', 1)
go



---------------------------------------------------------------------------
-- utv48
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv48', null, null, 'unknown', 'unknown', '', 'test48', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv48', 'gridt17', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv51
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv51', null, null, 'unknown', 'unknown', 'patch3', 'test51', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv51', 'gridt16', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv51', 'gridt16', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv51', 'gridt16', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv51', 'gridt16', 'GPU_3', 1)
go



---------------------------------------------------------------------------
-- utv52
---------------------------------------------------------------------------
insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms)
values(0, 'utv52', null, null, 'unknown', 'unknown', '', 'test52', null)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'CPU_T1', 0)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'CPU_T2', 0)
go

insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'GPU_0', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'GPU_1', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'GPU_2', 1)
insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(0, 'utv52', 'gridt4', 'GPU_3', 1)
go



--------------------------------------------------------------------------------------------------
-- END
--------------------------------------------------------------------------------------------------






--------------------------------
--------------------------------
--------------------------------
-- Create triggers for some tables
--------------------------------
--------------------------------
--------------------------------

--------------------------------
-- Triggers for: Versions
--------------------------------
create or alter trigger Versions_i_tr
on Versions
for insert
as
begin
	-- only 1 active
	if exists (select 1 from inserted i where i.status != 'P')
	begin
		raiserror ('Sorry only records with the status PLANED is allowed to be inserted.', 16, 1)
		rollback transaction
	end
end
go

create or alter trigger Versions_u_tr
on Versions
for update
as
begin
	-- only 1 active
	if exists (select 1 from inserted i where i.status = 'A')
	begin
		if ( (select count(*) from Versions v where v.status = 'A') > 1 )
		begin
			raiserror ('Sorry you can only have ONE version in the ACTIVE status.', 16, 1)
			rollback transaction
		end
	end

	-- you can NOT update from History to Active or Planed
	if exists (select 1 from deleted d where d.status = 'H') 
	begin
		raiserror ('Sorry you can NOT update a version from HISTORY to Active or Planed.', 16, 1)
		rollback transaction
	end

select tab='deleted', * from deleted
select tab='inserted', * from inserted

	-- you can NOT update the entry expept if it's in PLANED
	if exists (select 1 from deleted d where d.status != 'P') 
	begin
		if    exists (select 1 from deleted  d where d.status = 'A') 
		  and exists (select 1 from inserted i where i.status = 'H')
		begin
			declare @okFromActiveToHistory int
		end
		else
		begin
			raiserror ('Sorry you can NOT update a version that is not in status Planed.', 16, 1)
			rollback transaction
		end
	end
end
go

create or alter trigger Versions_d_tr
on Versions
for delete
as
begin
	if exists (select 1 from deleted i where i.status != 'P')
	begin
		raiserror ('Sorry you can only delete versions that are in the PLANED status.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
--------------------------------
--------------------------------
-- Create triggers for all tables that are version protected
--------------------------------
--------------------------------
--------------------------------

--------------------------------
-- Triggers for: Resources_AppServer
--------------------------------
create or alter trigger Resources_AppServer_i_tr
on Resources_AppServer
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_AppServer_u_tr
on Resources_AppServer
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_AppServer_d_tr
on Resources_AppServer
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
-- Triggers for: Resources_Grid
--------------------------------
create or alter trigger Resources_Grid_i_tr
on Resources_Grid
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_Grid_u_tr
on Resources_Grid
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_Grid_d_tr
on Resources_Grid
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
-- Triggers for: Resources_Dbms
--------------------------------
create or alter trigger Resources_Dbms_i_tr
on Resources_Dbms
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_Dbms_u_tr
on Resources_Dbms
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Resources_Dbms_d_tr
on Resources_Dbms
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
-- Triggers for: Systems
--------------------------------
create or alter trigger Systems_i_tr
on Systems
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Systems_u_tr
on Systems
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger Systems_d_tr
on Systems
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
-- Triggers for: SystemVariables
--------------------------------
create or alter trigger SystemVariables_i_tr
on SystemVariables
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger SystemVariables_u_tr
on SystemVariables
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger SystemVariables_d_tr
on SystemVariables
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go

--------------------------------
-- Triggers for: SystemAllocations
--------------------------------
--create or alter trigger SystemAllocations_i_tr
--on SystemAllocations
--for insert
--as
--begin
--	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
--	begin
--		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
--		rollback transaction
--	end
--end
--go
--create or alter trigger SystemAllocations_u_tr
--on SystemAllocations
--for update
--as
--begin
--	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
--	begin
--		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
--		rollback transaction
--	end
--end
--go
--create or alter trigger SystemAllocations_d_tr
--on SystemAllocations
--for delete
--as
--begin
--	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
--	begin
--		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
--		rollback transaction
--	end
--end
go

--------------------------------
-- Triggers for: SystemToGrid
--------------------------------
create or alter trigger SystemToGrid_i_tr
on SystemToGrid
for insert
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger SystemToGrid_u_tr
on SystemToGrid
for update
as
begin
	if exists (select 1 from inserted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go
create or alter trigger SystemToGrid_d_tr
on SystemToGrid
for delete
as
begin
	if exists (select 1 from deleted x join Versions v on x.versionId = v.versionId and v.status != 'P')
	begin
		raiserror ('The status must be in ''planed'' to change a record.', 16, 1)
		rollback transaction
	end
end
go



/*========================================================================
** VIEWS: 
*/
----------------------------------------------------------------
drop view v_Resources_AppServer
go
drop view v_Resources_Grid
go
drop view v_Resources_Dbms
go
drop view v_Systems
go
drop view v_SystemVariables
go
drop view v_SystemToGrid
go

----------------------------------------------------------------
create view v_Resources_AppServer
as
select 
      [resourceName]  -- varchar(64)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [hostname]      -- varchar(64)         : NOT NULL
from [dbo].[Resources_AppServer]  -- pk='[versionId, resourceName]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go

  
----------------------------------------------------------------
create view v_Resources_Grid
as
select 
      [resourceName]  -- varchar(64)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [hostname]      -- varchar(64)         : NOT NULL
    , [cpuType1Size]  -- int                 : NOT NULL
    , [cpuType2Size]  -- int                 : NOT NULL
    , [gpuSize]       -- int                 : NOT NULL
from [dbo].[Resources_Grid]  -- pk='[versionId, resourceName]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go


----------------------------------------------------------------
create view v_Resources_Dbms
as
select 
      [resourceName]  -- varchar(64)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [vendor]        -- varchar(64)         : NOT NULL
    , [version]       -- varchar(64)         : NOT NULL
    , [hostname]      -- varchar(64)         : NOT NULL
    , [portNum]       -- int                 : NOT NULL
from [dbo].[Resources_Dbms]  -- pk='[versionId, resourceName]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go


----------------------------------------------------------------
create view v_Systems
as
select 
      [systemName]         -- varchar(30)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [validFromDate]      -- datetime            : Allow NULL
    , [validToDate]        -- datetime            : Allow NULL
    , [projectName]        -- varchar(30)         : NOT NULL
    , [contactPerson]      -- varchar(30)         : NOT NULL
    , [comment]            -- varchar(255)        : Allow NULL
    , [resourceAppServer]  -- varchar(64)         : Allow NULL
    , [resourceDbms]       -- varchar(64)         : Allow NULL
from [dbo].[Systems]  -- pk='[versionId, systemName]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go


----------------------------------------------------------------
create view v_SystemVariables
as
select 
      [systemName]  -- varchar(30)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [varName]     -- varchar(30)         : NOT NULL, Part Of: PrimaryKey or first unique index
    , [intValue]    -- int                 : Allow NULL
    , [strValue]    -- varchar(255)        : Allow NULL
from [dbo].[SystemVariables]  -- pk='[versionId, systemName, varName]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go


----------------------------------------------------------------
create view v_SystemToGrid
as
select 
      [systemName]    -- varchar(30)         : NOT NULL
    , [resourceName]  -- varchar(64)         : NOT NULL
    , [subType]       -- varchar(30)         : NOT NULL
--    , [gpuId]         -- int                 : Allow NULL
    , [size]          -- int                 : NOT NULL
from [dbo].[SystemToGrid]  -- pk='[]'
where [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go



/*========================================================================
** FUNACTION: 
*/
create or alter function dbo.getActiveVersion()
returns int
--with execute as caller
as
begin
	declare @activeVersion int

	select @activeVersion = versionId
	from Versions
	where status = 'A'

	return @activeVersion
end
go
grant exec on getActiveVersion to public
go


/*========================================================================
** FUNACTION: 
*/
create or alter function dbo.getLastUserPlanedVersion(@responible varchar(30) = null)
returns int
--with execute as caller
as
begin
	declare @planedVersion int

	if (@responible is null)
		set @responible = suser_name()

	select @planedVersion = versionId
	from Versions
	where status = 'P'
	  and responible = @responible

	return @planedVersion
end
go
grant exec on getLastUserPlanedVersion to public
go


/*========================================================================
** PROC: 
** set a version that will be used when selectiong values from the v_xxxxxx views
*/
create or alter procedure setViewVersion
(
	@version         int        = null,
	@status          varchar(1) = null,
	@selectedVersion int        = null OUT
)
as
begin
	declare @msg varchar(255)

	if (@status is not null)
	begin
		if (@status in('a', 'A'))
		begin
			set @version = dbo.getActiveVersion()
		end
		else if (@status in('p', 'P'))
		begin
			set @version = dbo.getLastUserPlanedVersion(default)
		end
		else
		begin
			set @msg = 'ERROR: the specified status '''+@status+''' is unknown, please use ''A'' for Active Version, ''P'' for your last Planed Version.'
			raiserror(@msg, 16, 1)
	
			return 1
		end
	end

	-- If the version didn't exist... simply write a warning message
	if (@version is null)
	begin
		set @msg = 'ERROR: You can not set the version to NULL.'
		raiserror(@msg, 16, 1)

		return 1
	end

	if not exists (select * from dbo.Versions where versionId = @version)
	begin
		set @msg = 'WARNING: The version ' + convert(varchar(10), @version) + ' did not exists in the Versions table. view selection will fail to return any rows.'
		raiserror(@msg, 16, 1)
	end

	-- Set a "global context variable" that is used by views to get data for the current selected version
	EXEC sys.sp_set_session_context @key = 'versionId', @value = @version

	set @selectedVersion = @version
end
go


/*========================================================================
** PROC: 
** set a version that will be used when selectiong values from the v_xxxxxx views
*/
create or alter procedure getViewVersion
(
	@selectedVersion int        = null OUT
)
as
begin
	declare @version int

	select @version = isnull(convert(int, SESSION_CONTEXT(N'versionId')), -1)

	set @selectedVersion = @version
end
go


/*========================================================================
** PROC: 
** Create a new version in status PLANED
** It will take a specific version as a TEMPLATE
** - Create a new Version entry (in PLANED)
** - Copy all entries (for all relevant tables) into the new Version
*/
create or alter procedure newVersion
(
	@name            varchar(60) = '',
	@templateVersion int         = null,              -- DEFAULT: null = Take a copy of "ACTIVE" 
	@responsible     varchar(30) = null               -- DEFAULT: current username
)
as
begin
	declare @newVersion int

	-- assign a responsible if none was given
	if (@responsible is null)
	begin
		set @responsible = suser_name()
	end

	-- get latest ACTIVE release if no template version was specified
	if (@templateVersion is null)
	begin
		select @templateVersion = dbo.getActiveVersion()
	end
	
	-- Get a new versionId (note: this wont work in "high concurrent env", we will get duplicates on @newVersion)
	select @newVersion = isnull(max(versionId),0) + 1
	from Versions
	
	begin tran
		-- ADD a new version 
		insert into Versions(versionId, name, status, responible, crDate, releaseDate, historyDate)
		values(@newVersion, @name, 'P', @responsible, getdate(), null, null)
		
		
		/*
		** Copy all tables into the new version
		** Do this in a 3 step approach (using temp tables so we do not have to specify all column names in case of future changes)
		**  1: Copy a specific version into tmp tables
		**  2: Set the new version
		**  3: Insert the records from temp tables into the destination tables
		** This couls also have been done with: insert into destTable (select @newVersion, c1, c2, c3... from destTable where versionId = @templateVersion)
		** but that would have required more maintenance...
		*/ 
		if (@templateVersion is not null)
		begin
			select * into #tmp_Resources_AppServer  from Resources_AppServer  where versionId = @templateVersion
			select * into #tmp_Resources_Grid       from Resources_Grid       where versionId = @templateVersion
			select * into #tmp_Resources_Dbms       from Resources_Dbms       where versionId = @templateVersion
			select * into #tmp_Systems              from Systems              where versionId = @templateVersion
			select * into #tmp_SystemVariables      from SystemVariables      where versionId = @templateVersion
	--		select * into #tmp_SystemAllocations    from SystemAllocations    where versionId = @templateVersion
			select * into #tmp_SystemToGrid from SystemToGrid where versionId = @templateVersion
			
			update #tmp_Resources_AppServer  set versionId = @newVersion 
			update #tmp_Resources_Grid       set versionId = @newVersion 
			update #tmp_Resources_Dbms       set versionId = @newVersion 
			update #tmp_Systems              set versionId = @newVersion 
			update #tmp_SystemVariables      set versionId = @newVersion 
	--		update #tmp_SystemAllocations    set versionId = @newVersion 
			update #tmp_SystemToGrid set versionId = @newVersion 

			insert into Resources_AppServer  select * from #tmp_Resources_AppServer 
			insert into Resources_Grid       select * from #tmp_Resources_Grid      
			insert into Resources_Dbms       select * from #tmp_Resources_Dbms      
			insert into Systems              select * from #tmp_Systems             
			insert into SystemVariables      select * from #tmp_SystemVariables     
	--		insert into SystemAllocations    select * from #tmp_SystemAllocations   
			insert into SystemToGrid select * from #tmp_SystemToGrid

			drop table #tmp_Resources_AppServer  
			drop table #tmp_Resources_Grid       
			drop table #tmp_Resources_Dbms       
			drop table #tmp_Systems              
			drop table #tmp_SystemVariables      
	--		drop table #tmp_SystemAllocations    
			drop table #tmp_SystemToGrid 
		end
	commit tran
end
go
grant exec on newVersion to public
go


/*========================================================================
** PROC: 
** Close the ACTIVE and put into into HISTORY status
*/
create or alter procedure closeActiveVersion
as
begin
	declare @activeVersion int

	-- Get ACTIVE version
	select @activeVersion = dbo.getActiveVersion()

	if (@activeVersion is NULL)
	begin
		raiserror('Could NOT find any version in the status ''ACTIVE''.', 16, 1)
	end

	-- Set the status to HISTORY
	update Versions
	   set status = 'H'
	     , historyDate = getdate()
	 where versionId = @activeVersion
end
go
grant exec on closeActiveVersion to public
go

/*========================================================================
** PROC: 
** Set active version for a specific version
*/
create or alter procedure setActiveVersion
(
	@versionId int
)
as
begin
	declare @versionStatus char(1)

	-- Get STATUS for version
	select @versionStatus = status
	from Versions
	where versionId = @versionId

	if (@versionStatus is NULL)
	begin
		raiserror('Could NOT find any version with the ID %d', 16, 1, @versionId)
		return 1
	end

	if (@versionStatus != 'P')
	begin
		raiserror('The versionId %d is in status ''%s'', Only version with status ''P'' is accepted.', 16, 1, @versionId, @versionStatus)
		return 1
	end

	begin tran
		-- Set the CURRENT ACTIVE to HISTORY
		update Versions
		   set status      = 'H'
		     , historyDate = getdate()
		 where versionId = dbo.getActiveVersion()

		-- Set the status to ACTIVE
		update Versions
		   set status      = 'A'
		     , releaseDate = getdate()
		 where versionId = @versionId
	commit tran
end
go
grant exec on setActiveVersion to public
go



/*========================================================================
** PROC: 
** Set active version for a specific version
*/
create or alter procedure deleteVersion
(
	@versionId int
)
as
begin
	declare @versionStatus char(1)

	-- Get STATUS for version
	select @versionStatus = status
	from Versions
	where versionId = @versionId

	if (@versionStatus is NULL)
	begin
		raiserror('Could NOT find any version with the ID %d', 16, 1, @versionId)
		return 1
	end

	if (@versionStatus != 'P')
	begin
		raiserror('The versionId %d is in status ''%s'', Only version with status ''P'' is accepted.', 16, 1, @versionId, @versionStatus)
		return 1
	end

	/*
	** delete in "reversed order", otherwise Referential Integrity will be broken
	** TODO: Maybe move this into a trigger that cascade deletes the records... or declaring all FK as 'on delete cascade'
	*/
	begin tran
		-- Extra properties
		delete from SystemToGrid where versionId = @versionId

		-- Allocations to a system
--		delete from SystemAllocations    where versionId = @versionId
		delete from SystemVariables      where versionId = @versionId
		delete from Systems              where versionId = @versionId

		-- Resources
		delete from Resources_AppServer  where versionId = @versionId
		delete from Resources_Grid       where versionId = @versionId
		delete from Resources_Dbms       where versionId = @versionId

		-- And the version itself
		delete from Versions             where versionId = @versionId
	commit tran

end
go
grant exec on deleteVersion to public
go




/*-----------------------------------------------------------------
** Get the GRID description as a JSON String
**
** This is SQL-Server 2016 (annd above specific)
** And it uses: FOR JSON PATH
**
** Parameters:
*/
create or alter procedure getGridCfgAsJson
(
	@inStatus varchar(10) = null, --- default would be 'A' - Active
	@version  int         = null  --- default would be latest Active version
)
as
begin

	/*
	** Check input
	*/
	if (@inStatus is null)
	begin
		set @inStatus = 'A'
	end

	if (@inStatus = 'A')
	begin
		set @version = dbo.getActiveVersion()
	end
	else if (@inStatus = 'P')
	begin
		if (@version is null)
		begin
			set @version = dbo.getLastUserPlanedVersion(default)
			print 'Looking at a PLANED description, no version was passed. So I will use the latest PLANED version, which is ' + convert(varchar(10), @version)
		end
	end
	else if (@inStatus = 'H')
	begin
		if (@version is null)
		begin
			raiserror('If you want to look at a HISTORICAL description, please specify a version.', 16, 1);

			select * 
			from dbo.Versions v
			where v.status = 'H'
			order by v.versionId

			return 1
		end
	end
	else
	begin
		print 'Usage: @inStatus={A|P|H} [, @version=##]'
		print '       if status is ''A'' - Latest version will used, @version will be ignored'
		print '       if status is ''P'' - Latest planed version will used, but you can specify @version if you have several in status PLANED.'
		print '       if status is ''H'' - You will need to specify @version.'

		return 1
	end


	/*
	** Produce the JSON via SQL-Server 'FOR JSON', which is new in SQL-Server 2016
	*/
	select

	--######################################################
	-- HEAD
	--######################################################
	JSON_QUERY((
		select
			v.versionId   as [version],
			v.releaseDate as [date],
			v.responible  as [responible],
			CASE WHEN v.status = 'A' THEN 'Active' 
			     WHEN v.status = 'P' THEN 'Planed' 
			     WHEN v.status = 'H' THEN 'Historical' 
			     ELSE 'UNKNOWN' 
			END  as [status]
		from dbo.Versions v 
		where versionId = @version
		FOR JSON PATH
			--, ROOT('head')
			, WITHOUT_ARRAY_WRAPPER
	)) as head

	--######################################################
	-- Resources
	--######################################################
	,JSON_QUERY((
		select 
		(
			-- APP
			select 
				'normal'   as [type],
				a.resourceName as [resourceName],
				a.hostname     as [appHostname]
			from dbo.Resources_AppServer a 
			where versionId = @version
			FOR JSON PATH
		) as appServers
		,(
			-- GRID
			select 
				'grid'         as [type],
				a.resourceName as [resourceName],
				a.hostname     as [gridHostname],
				a.gpuSize      as [gpuSize],
				a.cpuType1Size as [cpuType1Size],
				a.cpuType2Size as [cpuType2Size]
			from dbo.Resources_Grid a 
			where versionId = @version
			FOR JSON PATH
		) as gridServers
		,(
			-- DBMS
			select 
				'dbms'         as [type],
				a.resourceName as [resourceName],
				a.hostname     as [appHostname],
				a.portNum      as [port]
			from dbo.Resources_Dbms a
			where versionId = @version
			FOR JSON PATH
		) as dbmsServers
		FOR JSON PATH
			--, ROOT('resources')
			, WITHOUT_ARRAY_WRAPPER
	)) as resources
	
	--######################################################
	-- Allocations
	--######################################################
	,(
		select 
			s.systemName  as [name]
			,'grid'       as [type]
			,(select app .hostname from dbo.Resources_AppServer app  where app .resourceName = s.resourceAppServer and app .versionId = s.versionId) as [appHostname]
			,(select dbms.hostname from dbo.Resources_Dbms      dbms where dbms.resourceName = s.resourceDbms      and dbms.versionId = s.versionId) as [dbmsHostname]
			,s.validFromDate
			,s.validToDate
			,s.projectName
			,s.contactPerson
			,s.comment
			,( -- CPU_TYPE_1
				select 
					 CPU_T1.subType
					,CPU_T1.resourceName as [resourceName]
					,(select grid.hostname from dbo.Resources_Grid grid where grid.resourceName = CPU_T1.resourceName and grid.versionId = CPU_T1.versionId) as [gridHostname]
					,CPU_T1.size         as [size]
				from SystemToGrid CPU_T1 
				where CPU_T1.systemName = s.systemName
				  and CPU_T1.versionId  = s.versionId
				  and CPU_T1.subType    = 'CPU_T1'
			    FOR JSON PATH
			) as CPU_T1
			,( -- CPU_TYPE_2
				select 
					 CPU_T2.subType
					,CPU_T2.resourceName as [resourceName]
					,(select grid.hostname from dbo.Resources_Grid grid where grid.resourceName = CPU_T2.resourceName and grid.versionId = CPU_T2.versionId) as [gridHostname]
					,CPU_T2.size         as [size]
				from SystemToGrid CPU_T2 
				where CPU_T2.systemName = s.systemName
				  and CPU_T2.versionId  = s.versionId
				  and CPU_T2.subType    = 'CPU_T2'
			    FOR JSON PATH
			) as CPU_T2
			,( -- GPU
				select 
					 'GPU' as subType --GPU.subType
					,GPU.resourceName as [resourceName]
					,(select grid.hostname from dbo.Resources_Grid grid where grid.resourceName = GPU.resourceName and grid.versionId = GPU.versionId) as [gridHostname]
--					,GPU.gpuId        as [gpuId]
					,convert(int, substring(subType, 5, 1)) as [gpuId]
					,GPU.size         as [size]
				from SystemToGrid GPU
				where GPU.systemName = s.systemName
				  and GPU.versionId  = s.versionId
				  and GPU.subType    like 'GPU_%'
			    FOR JSON PATH
			) as GPU
		from dbo.Systems s 
		where 1=1
		  and s.versionId = @version
		FOR JSON PATH
	) as allocations
	FOR JSON PATH
		, WITHOUT_ARRAY_WRAPPER
end
grant exec on getGridCfgAsJson to public
go



exit
-------------------------------------------------------------------------------
-- some testing
-------------------------------------------------------------------------------

select * from dbo.Versions
go
select * from dbo.
go
exec newVersion
go
select * from dbo.Versions
go
exec setActiveVersion 1
go
select * from Versions

exec dbo.deleteVersion 1
go

declare @ver int
select @ver=dbo.getLastUserPlanedVersion(default)
select LastPlanedVersion = @ver
exec dbo.deleteVersion @ver





use tempdb
go
drop table t1
go
create table t1 (id int)
go
create trigger xxx on t1 for insert as begin
	raiserror('dummy rollback....... in trigger.....', 16, 1)
	rollback tran
end
go

insert into t1 values(1)
go
begin tran
insert into t1 values(2)
insert into t1 values(3)
commit tran
go
select * from t1
go


getGridCfgAsJson

http://sek-emdb.sek.se/EmdbWeb/api/gridConfig
http://sek-syslog/cmdb/verifyGridCfg_gorans.php

select @@version
select 'xxx'



DECLARE @ID INT = 255
EXEC sys.sp_set_session_context @key = N'ID', @value = @ID
go
declare @versionId int = 255
SELECT @versionId=convert(int, SESSION_CONTEXT(N'ID'))
select @versionId
go


declare @versionId int = 0
EXEC sys.sp_set_session_context @key = 'versionId', @value = @versionId
go
declare @versionId int = 255
SELECT @versionId=convert(int, SESSION_CONTEXT(N'versionId'))
select @versionId
go
drop view dummyView
create view dummyView
as
select 
      [versionId]  -- int                 : NOT NULL, Part Of: PrimaryKey or first unique index
    , [status]     -- char(1)             : NOT NULL
    , [responible]  -- varchar(30)         : NOT NULL
    , [crDate]     -- datetime            : NOT NULL
    , [releaseDate]  -- datetime            : Allow NULL
    , [historyDate]  -- datetime            : Allow NULL
from [dbo].[Versions]  -- pk='[versionId]'
where 1 = 1 
  and [versionId] = isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')
go
select * from dummyView 
select isnull(convert(int, SESSION_CONTEXT(N'versionId')), 'ERROR: A Valid version has not yet been set')


declare @versionId int = 99
EXEC sys.sp_set_session_context @key = 'versionId', @value = @versionId

select * from v_Resources_AppServer
select * from v_Resources_Grid
select * from v_Resources_Dbms
select * from v_Systems
select * from v_SystemVariables
select * from v_SystemToGrid

setViewVersion 0
