package se.sek.emdb.admin;

import java.awt.Window;
import java.sql.Types;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeAppHost
extends AddOrChangeAbstract
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "Application Server Resource";

	private String     _resourceName       = null;
	private JLabel     _resourceName_lbl   = new JLabel("Resource Name");
	private JTextField _resourceName_txt   = new JTextField(64);
	
	private JLabel     _hostname_lbl       = new JLabel("Host Name");
	private JTextField _hostname_txt       = new JTextField(64);
	
	public AddOrChangeAppHost(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() )
		{
			_resourceName_txt.setEnabled(false);
		}

		if ( isDelete())
		{
			_resourceName_txt.setEnabled(false);
			_hostname_txt    .setEnabled(false);
		}

		panel.add(_resourceName_lbl, "");
		panel.add(_resourceName_txt, "growx, pushx, wrap 20");

		panel.add(_hostname_lbl, "");
		panel.add(_hostname_txt, "growx, pushx, wrap");

		return panel;
	}

	@Override
	public void setFields(GTable table, int vrow)
	{
		_resourceName       = table.getValueAsString(vrow, "resourceName", false);
		_resourceName_txt   .setText(""+_resourceName);

		_hostname_txt .setText(table.getValueAsString(vrow, "hostname", false));
	}

//	public String getStoreId()    { return _resourceName_txt  .getText(); }

	public String getResourceName()  { return getStringValue(_resourceName_txt); }
	public String gethostName()      { return getStringValue(_hostname_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "insert into Resources_AppServer(versionId, resourceName, hostname) values(?, ?, ?)");

		stmnt.addParam( SqlStatementParam.createInParam("versionId",    Types.INTEGER, EmdbAdmin.getCurrentViewVersion()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()      ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "update v_Resources_AppServer set hostname = ? where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "delete from v_Resources_AppServer where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}
}
