package se.sek.emdb.admin;

import java.awt.Window;
import java.sql.Types;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.AddOrChangeAbstract.OpType;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeDbmsHost
extends AddOrChangeAbstract
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "DBMS Resource";

	private String     _resourceName      = null;
	private JLabel     _resourceName_lbl  = new JLabel("Resource Name");
	private JTextField _resourceName_txt  = new JTextField(64);
	
	private JLabel     _hostname_lbl      = new JLabel("Host Name");
	private JTextField _hostname_txt      = new JTextField(64);
	
	private JLabel     _portNum_lbl       = new JLabel("Port Number");
	private JTextField _portNum_txt       = new JTextField(5);
	
	private JLabel     _vendor_lbl        = new JLabel("Vendor");
	private JTextField _vendor_txt        = new JTextField(64);
	
	private JLabel     _version_lbl       = new JLabel("Version");
	private JTextField _version_txt       = new JTextField(64);
	
	public AddOrChangeDbmsHost(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() )
		{
			_resourceName_txt.setEnabled(false);
		}

		if ( isDelete())
		{
			_resourceName_txt.setEnabled(false);
			_vendor_txt      .setEnabled(false);
			_version_txt     .setEnabled(false);
			_hostname_txt    .setEnabled(false);
			_portNum_txt     .setEnabled(false);
		}

		panel.add(_resourceName_lbl, "");
		panel.add(_resourceName_txt, "growx, pushx, wrap 20");

		panel.add(_hostname_lbl, "");
		panel.add(_hostname_txt, "growx, pushx, wrap");

		panel.add(_portNum_lbl, "");
		panel.add(_portNum_txt, "growx, pushx, wrap");

		panel.add(_vendor_lbl, "");
		panel.add(_vendor_txt, "growx, pushx, wrap");

		panel.add(_version_lbl, "");
		panel.add(_version_txt, "growx, pushx, wrap");

		return panel;
	}

	@Override
	public void setFields(GTable table, int vrow)
	{
		_resourceName       = table.getValueAsString(vrow, "resourceName", false);
		_resourceName_txt   .setText(""+_resourceName);

		_hostname_txt       .setText(table.getValueAsString(vrow, "hostname", false));
		_portNum_txt        .setText(table.getValueAsString(vrow, "portNum",  false));
		_vendor_txt         .setText(table.getValueAsString(vrow, "vendor",   false));
		_version_txt        .setText(table.getValueAsString(vrow, "version",  false));
	}

	public String getResourceName() { return getStringValue (_resourceName_txt); }
	public String gethostName()     { return getStringValue (_hostname_txt); }
	public int    getPortNum()      { return getIntegerValue(_portNum_txt); }
	public String getVendor()       { return getStringValue (_vendor_txt); }
	public String getVersion()      { return getStringValue (_version_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "insert into Resources_Dbms(versionId, resourceName, vendor, version, hostname, portNum) values(?, ?, ?, ?, ?, ?)");
	    
		stmnt.addParam( SqlStatementParam.createInParam("versionId",    Types.INTEGER, EmdbAdmin.getCurrentViewVersion()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("vendor",       Types.VARCHAR, getVendor()        ) );
		stmnt.addParam( SqlStatementParam.createInParam("version",      Types.VARCHAR, getVersion()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()      ) );
		stmnt.addParam( SqlStatementParam.createInParam("portNum",      Types.VARCHAR, getPortNum()       ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"update v_Resources_Dbms \n"
				+ "  set vendor   = ? \n"
				+ "    , version  = ? \n"
				+ "    , hostname = ? \n"
				+ "    , portNum  = ? \n"
				+ "where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("vendor",       Types.VARCHAR, getVendor()        ) );
		stmnt.addParam( SqlStatementParam.createInParam("version",      Types.VARCHAR, getVersion()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()      ) );
		stmnt.addParam( SqlStatementParam.createInParam("portNum",      Types.VARCHAR, getPortNum()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "delete from v_Resources_Dbms where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}
}
