package se.sek.emdb.admin;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Types;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeGridHost
extends AddOrChangeAbstract
implements ActionListener, KeyListener, FocusListener
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "GRID Resource";

	private String     _resourceName      = null;
	private JLabel     _resourceName_lbl  = new JLabel("Resource Name");
	private JTextField _resourceName_txt  = new JTextField(64);
	
	private JLabel     _hostname_lbl      = new JLabel("Host Name");
	private JTextField _hostname_txt      = new JTextField(64);
	
	private JLabel     _cpuType1Size_lbl  = new JLabel("CPU Type 1 Size");
	private JTextField _cpuType1Size_txt  = new JTextField(64);
	
	private JLabel     _cpuType2Size_lbl  = new JLabel("CPU Type 2 Size");
	private JTextField _cpuType2Size_txt  = new JTextField(64);
	
	private JLabel     _gpuSize_lbl       = new JLabel("GPU Size");
	private JTextField _gpuSize_txt       = new JTextField(64);
	
	public AddOrChangeGridHost(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() )
		{
			_resourceName_txt.setEnabled(false);
		}

		if ( isDelete())
		{
			_resourceName_txt.setEnabled(false);
			_hostname_txt    .setEnabled(false);
			_cpuType1Size_txt.setEnabled(false);
			_cpuType2Size_txt.setEnabled(false);
			_gpuSize_txt     .setEnabled(false);
		}

		panel.add(_resourceName_lbl, "");
		panel.add(_resourceName_txt, "growx, pushx, wrap 20");

		panel.add(_hostname_lbl, "");
		panel.add(_hostname_txt, "growx, pushx, wrap");

		panel.add(_cpuType1Size_lbl, "");
		panel.add(_cpuType1Size_txt, "growx, pushx, wrap");

		panel.add(_cpuType2Size_lbl, "");
		panel.add(_cpuType2Size_txt, "growx, pushx, wrap");

		panel.add(_gpuSize_lbl, "");
		panel.add(_gpuSize_txt, "growx, pushx, wrap");


		_resourceName_txt.addKeyListener(this);
		_cpuType1Size_txt.addKeyListener(this);
		_cpuType2Size_txt.addKeyListener(this);
		_gpuSize_txt     .addKeyListener(this);

		_resourceName_txt.addFocusListener(this);
		_hostname_txt    .addFocusListener(this);
		_cpuType1Size_txt.addFocusListener(this);
		_cpuType2Size_txt.addFocusListener(this);
		_gpuSize_txt     .addFocusListener(this);
		
		return panel;
	}

	//-------------------------------------------------
	// BEGIN: Implementing: ActionListener
	//-------------------------------------------------
	@Override
	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		
		validateContent();
	}
	//-------------------------------------------------
	// END: Implementing: ActionListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: KeyListener
	//-------------------------------------------------
	@Override
	public void keyTyped(KeyEvent e)
	{
	}
	
	@Override
	public void keyReleased(KeyEvent e)
	{
		Object source = e.getSource();

		if ( _resourceName_txt.equals(source) )
		{
			_hostname_txt.setText("srv-mx" + _resourceName_txt.getText().trim() + ".sek.se");
		}

		validateContent();
	}
	
	@Override
	public void keyPressed(KeyEvent e)
	{
	}
	//-------------------------------------------------
	// END: Implementing: KeyListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: FocusListener
	//-------------------------------------------------
	@Override
	public void focusLost(FocusEvent e)
	{
//		if (_store_cbx.equals(e.getSource()))
//			_title_txt.requestFocus();

		validateContent();
	}
	
	@Override
	public void focusGained(FocusEvent e)
	{
		Object source = e.getSource();

		if (   _resourceName_txt.equals(source)
		    || _hostname_txt    .equals(source)
		    || _cpuType1Size_txt.equals(source)
		    || _cpuType2Size_txt.equals(source)
		    || _gpuSize_txt     .equals(source)
		   )
		{
			JTextField field = (JTextField)e.getSource();
			field.selectAll();
		}
	}
	//-------------------------------------------------
	// END: Implementing: FocusListener
	//-------------------------------------------------

	@Override
	public String getProblemText()
	{
		if ( isInsert() )
		{
			int len = 0;
			JTextField field = null;

			//----------------------------------
			field = _cpuType1Size_txt;
			len = field.getText().trim().length();
			if ( len > 0 )
			{
				try { new Integer(field.getText()); }
				catch(NumberFormatException nfe) { return "CPU-Type-1 Size must be a Integer"; }
			}

			//----------------------------------
			field = _cpuType2Size_txt;
			len = field.getText().trim().length();
			if ( len > 0 )
			{
				try { new Integer(field.getText()); }
				catch(NumberFormatException nfe) { return "CPU-Type-2 Size must be a Integer"; }
			}

			//----------------------------------
			field = _gpuSize_txt;
			len = field.getText().trim().length();
			if ( len > 0 )
			{
				try { new Integer(field.getText()); }
				catch(NumberFormatException nfe) { return "GPU Size must be a Integer"; }
			}
		}
		return null; 
	}

	
	@Override
	public void setFields(GTable table, int vrow)
	{
		_resourceName       = table.getValueAsString(vrow, "resourceName", false);
		_resourceName_txt   .setText(""+_resourceName);

		_hostname_txt       .setText(table.getValueAsString(vrow, "hostname",     false));
		_cpuType1Size_txt   .setText(table.getValueAsString(vrow, "cpuType1Size", false));
		_cpuType2Size_txt   .setText(table.getValueAsString(vrow, "cpuType2Size", false));
		_gpuSize_txt        .setText(table.getValueAsString(vrow, "gpuSize",      false));
	}

	public String getResourceName() { return getStringValue (_resourceName_txt); }
	public String gethostName()     { return getStringValue (_hostname_txt); }
	public int    getCpuType1Size() { return getIntegerValue(_cpuType1Size_txt); }
	public int    getCpuType2Size() { return getIntegerValue(_cpuType2Size_txt); }
	public int    getGpuSize()      { return getIntegerValue(_gpuSize_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "insert into Resources_Grid(versionId, resourceName, hostname, cpuType1Size, cpuType2Size, gpuSize) values(?, ?, ?, ?, ?, ?)");
	    
		stmnt.addParam( SqlStatementParam.createInParam("versionId",    Types.INTEGER, EmdbAdmin.getCurrentViewVersion()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()      ) );
		stmnt.addParam( SqlStatementParam.createInParam("cpuType1Size", Types.INTEGER, getCpuType1Size()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("cpuType2Size", Types.INTEGER, getCpuType2Size()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("gpuSize",      Types.INTEGER, getGpuSize()       ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"update v_Resources_Grid \n"
				+ "  set hostname     = ? \n"
				+ "    , cpuType1Size = ? \n"
				+ "    , cpuType2Size = ? \n"
				+ "    , gpuSize      = ? \n"
				+ "where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("hostname",     Types.VARCHAR, gethostName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("cpuType1Size", Types.INTEGER, getCpuType1Size()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("cpuType2Size", Types.INTEGER, getCpuType2Size()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("gpuSize",      Types.INTEGER, getGpuSize()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "delete from v_Resources_Grid where resourceName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, _resourceName  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}
}
