package se.sek.emdb.admin;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Timestamp;
import java.sql.Types;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.jdesktop.swingx.JXDatePicker;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeSystem
extends AddOrChangeAbstract
implements ActionListener, KeyListener, FocusListener
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "System";

	private String       _systemName            = null;
	private JLabel       _systemName_lbl        = new JLabel("System Name");
	private JTextField   _systemName_txt        = new JTextField(30);
	
	private JLabel       _validFromDate_lbl     = new JLabel("Valid From Date");
	private JXDatePicker _validFromDate_dtp     = new JXDatePicker(new java.util.Date(System.currentTimeMillis()));

	private JLabel       _validToDate_lbl       = new JLabel("Valid To Date");
	private JXDatePicker _validToDate_dtp       = new JXDatePicker(new java.util.Date(System.currentTimeMillis()));

	private JLabel       _projectName_lbl       = new JLabel("Project Name");
	private JTextField   _projectName_txt       = new JTextField(30);
	
	private JLabel       _contactPerson_lbl     = new JLabel("Contact Person");
	private JTextField   _contactPerson_txt     = new JTextField(30);
	
	private JLabel       _comment_lbl           = new JLabel("Comment");
	private JTextField   _comment_txt           = new JTextField(50);
	
	private JLabel       _resourceAppServer_lbl = new JLabel("Application Resource");
	private JTextField   _resourceAppServer_txt = new JTextField(50);
	private JButton      _resourceAppServer_but = new JButton("...");
	
	private JLabel       _resourceDbms_lbl      = new JLabel("DBMS Resource");
	private JTextField   _resourceDbms_txt      = new JTextField(50);
	private JButton      _resourceDbms_but      = new JButton("...");
	
	public AddOrChangeSystem(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() )
		{
			_systemName_txt.setEnabled(false);
		}

		if ( isDelete())
		{
			_systemName_txt       .setEnabled(false);
			_validFromDate_dtp    .setEnabled(false);
			_validToDate_dtp      .setEnabled(false);
			_projectName_txt      .setEnabled(false);
			_contactPerson_txt    .setEnabled(false);
			_comment_txt          .setEnabled(false);
			_resourceAppServer_txt.setEnabled(false);
			_resourceDbms_txt     .setEnabled(false);
		}

		panel.add(_systemName_lbl,         "");
		panel.add(_systemName_txt,         "growx, pushx, wrap 20");
                                           
		panel.add(_validFromDate_lbl,      "");
		panel.add(_validFromDate_dtp,      "growx, pushx, wrap");
                                           
		panel.add(_validToDate_lbl,        "");
		panel.add(_validToDate_dtp,        "growx, pushx, wrap");
                                           
		panel.add(_projectName_lbl,        "");
		panel.add(_projectName_txt,        "growx, pushx, wrap");
                                           
		panel.add(_contactPerson_lbl,      "");
		panel.add(_contactPerson_txt,      "growx, pushx, wrap");
                                           
		panel.add(_comment_lbl,            "");
		panel.add(_comment_txt,            "growx, pushx, wrap");

		panel.add(_resourceAppServer_lbl,  "");
		panel.add(_resourceAppServer_txt,  "growx, pushx");
		panel.add(_resourceAppServer_but,  "wrap");

		panel.add(_resourceDbms_lbl,       "");
		panel.add(_resourceDbms_txt,       "growx, pushx");
		panel.add(_resourceDbms_but,       "wrap");

		_resourceAppServer_txt .addActionListener(this);
		_resourceAppServer_but .addActionListener(this);
		_resourceDbms_txt      .addActionListener(this);
		_resourceDbms_but      .addActionListener(this);

		return panel;
	}

	//-------------------------------------------------
	// BEGIN: Implementing: ActionListener
	//-------------------------------------------------
	@Override
	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		
		if (_resourceAppServer_txt.equals(source) || _resourceAppServer_but.equals(source))
		{
			showAppServersPickTable();
		}

		if (_resourceDbms_txt.equals(source) || _resourceDbms_but.equals(source))
		{
			showDbmsServersPickTable();
		}

		validateContent();
	}
	//-------------------------------------------------
	// END: Implementing: ActionListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: KeyListener
	//-------------------------------------------------
	@Override
	public void keyTyped(KeyEvent e)
	{
	}
	
	@Override
	public void keyReleased(KeyEvent e)
	{
		validateContent();
	}
	
	@Override
	public void keyPressed(KeyEvent e)
	{
	}
	//-------------------------------------------------
	// END: Implementing: KeyListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: FocusListener
	//-------------------------------------------------
	@Override
	public void focusLost(FocusEvent e)
	{
//		if (_store_cbx.equals(e.getSource()))
//			_title_txt.requestFocus();

		validateContent();
	}
	
	@Override
	public void focusGained(FocusEvent e)
	{
		Object source = e.getSource();

//		if (   _store_txt   .equals(source)
//		    || _title_txt   .equals(source)
//		    || _isbn_txt    .equals(source)
//		    || _quantity_txt.equals(source)
//		    || _discount_txt.equals(source)
//		    || _store_txt   .equals(source)
//		   )
//		{
//			JTextField field = (JTextField)e.getSource();
//			field.selectAll();
//		}
	}
	//-------------------------------------------------
	// END: Implementing: FocusListener
	//-------------------------------------------------

	
	private void showAppServersPickTable()
	{
		// Get Order Details (if its Delete or Update)
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Resources_AppServer");

		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showAppServersPickTable", null);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			_resourceAppServer_txt.setText(pickList.getSelectedValuesAsString("resourceName"));
			
			// FOCUS: Next field 
			_resourceDbms_txt.requestFocus();
		}
	}

	private void showDbmsServersPickTable()
	{
		// Get Order Details (if its Delete or Update)
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Resources_Dbms");

		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showDbmsServersPickTable", null);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			_resourceDbms_txt.setText(pickList.getSelectedValuesAsString("resourceName"));
			
			// FOCUS: Next field 
			//_xxx_txt.requestFocus();
		}
	}

	@Override
	public void setFields(GTable table, int vrow)
	{
		_systemName           = table.getValueAsString(vrow, "systemName", false);
		_systemName_txt       .setText(""+_systemName);

		_validFromDate_dtp    .setDate(table.getValueAsTimestamp (vrow, "validFromDate",     false));
		_validToDate_dtp      .setDate(table.getValueAsTimestamp (vrow, "validToDate",       false));
		_projectName_txt      .setText(table.getValueAsString    (vrow, "projectName",       false));
		_contactPerson_txt    .setText(table.getValueAsString    (vrow, "contactPerson",     false));
		_comment_txt          .setText(table.getValueAsString    (vrow, "comment",           false));
		_resourceAppServer_txt.setText(table.getValueAsString    (vrow, "resourceAppServer", false));
		_resourceDbms_txt     .setText(table.getValueAsString    (vrow, "resourceDbms",      false));
	}

	public String    getSystemName()        { return getStringValue(_systemName_txt); }
	public Timestamp getValidFromDate()     { return                _validFromDate_dtp.getDate()==null ? null : new Timestamp(_validFromDate_dtp.getDate().getTime()); }
	public Timestamp getValidToDate()       { return                _validToDate_dtp  .getDate()==null ? null : new Timestamp(_validToDate_dtp  .getDate().getTime()); }
	public String    getProjectName()       { return getStringValue(_projectName_txt); }
	public String    getContactPerson()     { return getStringValue(_contactPerson_txt); }
	public String    getComments()          { return getStringValue(_comment_txt); }
	public String    getResourceAppServer() { return getStringValue(_resourceAppServer_txt); }
	public String    getResourceDbms()      { return getStringValue(_resourceDbms_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"insert into Systems(versionId, systemName, validFromDate, validToDate, projectName, contactPerson, comment, resourceAppServer, resourceDbms) \n"
				+ "values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
	    
		stmnt.addParam( SqlStatementParam.createInParam("versionId",         Types.INTEGER, EmdbAdmin.getCurrentViewVersion()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("systemName",        Types.VARCHAR, getSystemName()        ) );
		stmnt.addParam( SqlStatementParam.createInParam("validFromDate",     Types.VARCHAR, getValidFromDate()     ) );
		stmnt.addParam( SqlStatementParam.createInParam("validToDate",       Types.VARCHAR, getValidToDate()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("projectName",       Types.VARCHAR, getProjectName()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("contactPerson",     Types.VARCHAR, getContactPerson()     ) );
		stmnt.addParam( SqlStatementParam.createInParam("comment",           Types.VARCHAR, getComments()          ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceAppServer", Types.VARCHAR, getResourceAppServer() ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceDbms",      Types.VARCHAR, getResourceDbms()      ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"update v_Systems \n"
				+ "set validFromDate     = ? \n"
				+ "  , validToDate       = ? \n"
				+ "  , projectName       = ? \n"
				+ "  , contactPerson     = ? \n"
				+ "  , comment           = ? \n"
				+ "  , resourceAppServer = ? \n"
				+ "  , resourceDbms      = ? \n"
				+ "where systemName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("validFromDate",     Types.TIMESTAMP, getValidFromDate()     ) );
		stmnt.addParam( SqlStatementParam.createInParam("validToDate",       Types.TIMESTAMP, getValidToDate()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("projectName",       Types.VARCHAR,   getProjectName()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("contactPerson",     Types.VARCHAR,   getContactPerson()     ) );
		stmnt.addParam( SqlStatementParam.createInParam("comment",           Types.VARCHAR,   getComments()          ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceAppServer", Types.VARCHAR,   getResourceAppServer() ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceDbms",      Types.VARCHAR,   getResourceDbms()      ) );

		stmnt.addParam( SqlStatementParam.createInParam("systemName",        Types.VARCHAR,   getSystemName()        ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"delete from v_Systems where systemName = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("systemName",        Types.VARCHAR,   getSystemName()        ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}

//	public static HashMap<String, Integer> getStoresLookup(Window owner, ConnectionProvider connProvider)
//	{
//		LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
//		
////		String sql = "select store_name, store_id from stores \n";
//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_stores_lookup(?, ?)}");
//		stmnt.addParam( SqlStatementParam.createInParam("store_name", Types.VARCHAR, "") );
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
//
//		try
//		{
//			ResultSet rs = stmnt.executeQuery(connProvider);
//			int rowc = 0;
//			while(rs.next())
//			{
//				rowc++;
//				map.put(rs.getString(1), rs.getInt(2));
//			}
//			SqlTraceWindow.getInstance().addRowcount( rowc );
//
//			SqlStatement.putWarningMessages(connProvider, null, rs);
//			rs.close();
//		}
//		catch (SQLException e)
//		{
//			SqlStatement.showErrorMessage(e, stmnt, owner, "Getting Stores (name,id) <b>failed.</b>");
//		}
//		
//		return map;
//	}
}
