package se.sek.emdb.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeSystemGrid
extends AddOrChangeAbstract
implements ActionListener, KeyListener, FocusListener
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "System GRID Allocation";

	private JLabel     _systemName_lbl     = new JLabel("System Name");
	private JTextField _systemName_txt     = new JTextField(64);
	private JButton    _systemName_but     = new JButton("...");
	
	private JLabel     _resourceName_lbl   = new JLabel("Resource Name");
	private JTextField _resourceName_txt   = new JTextField(64);
	private JButton    _resourceName_but   = new JButton("...");
	
	private JLabel     _subType_lbl        = new JLabel("Type");
	private JTextField _subType_txt        = new JTextField(64);
	private JButton    _subType_but        = new JButton("...");
	
//	private JLabel     _gpuId_lbl          = new JLabel("GPU ID");
//	private JTextField _gpuId_txt          = new JTextField(4);
	
	private JLabel     _xSize_lbl          = new JLabel("Size");
	private JTextField _xSize_txt          = new JTextField(4);
	
	public AddOrChangeSystemGrid(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() )
		{
			_systemName_txt.setEnabled(false);

			_resourceName_txt.setEnabled(false);
			_subType_txt     .setEnabled(false);
		}

		if ( isDelete())
		{
			_systemName_txt.setEnabled(false);

			_resourceName_txt.setEnabled(false);
			_subType_txt     .setEnabled(false);
//			_gpuId_txt       .setEnabled(false);
			_xSize_txt       .setEnabled(false);
		}

		panel.add(_systemName_lbl, "");
		panel.add(_systemName_txt, "growx, pushx");
		panel.add(_systemName_but, "wrap 20");

		panel.add(_resourceName_lbl, "");
		panel.add(_resourceName_txt, "growx, pushx");
		panel.add(_resourceName_but, "wrap");

		panel.add(_subType_lbl, "");
		panel.add(_subType_txt, "growx, pushx");
		panel.add(_subType_but, "wrap");

//		panel.add(_gpuId_lbl, "");
//		panel.add(_gpuId_txt, "growx, pushx, wrap");

		panel.add(_xSize_lbl, "");
		panel.add(_xSize_txt, "growx, pushx, wrap");

		_systemName_txt  .addKeyListener(this);
		_resourceName_txt.addKeyListener(this);
		_subType_txt     .addKeyListener(this);
//		_gpuId_txt       .addKeyListener(this);
		_xSize_txt       .addKeyListener(this);

		_systemName_txt  .addFocusListener(this);
		_resourceName_txt.addFocusListener(this);
		_subType_txt     .addFocusListener(this);
//		_gpuId_txt       .addFocusListener(this);
		_xSize_txt       .addFocusListener(this);
		
		_systemName_but  .addActionListener(this);
		_systemName_txt  .addActionListener(this);
		_resourceName_but.addActionListener(this);
		_resourceName_txt.addActionListener(this);
		_subType_txt     .addActionListener(this);
		_subType_but     .addActionListener(this);

		return panel;
	}

	//-------------------------------------------------
	// BEGIN: Implementing: ActionListener
	//-------------------------------------------------
	@Override
	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		
		if (_systemName_txt.equals(source) || _systemName_but.equals(source))
		{
			showSystemsPickTable();
		}

		if (_resourceName_txt.equals(source) || _resourceName_but.equals(source))
		{
			showResourcesPickTable();
		}

		if (_subType_txt.equals(source) || _subType_but.equals(source))
		{
			showSubTypesPickTable();
		}

		validateContent();
	}
	//-------------------------------------------------
	// END: Implementing: ActionListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: KeyListener
	//-------------------------------------------------
	@Override
	public void keyTyped(KeyEvent e)
	{
	}
	
	@Override
	public void keyReleased(KeyEvent e)
	{
		Object source = e.getSource();

//		if ( _resourceName_txt.equals(source) )
//		{
//			_hostname_txt.setText("srv-mx" + _resourceName_txt.getText().trim() + ".sek.se");
//		}

		validateContent();
	}
	
	@Override
	public void keyPressed(KeyEvent e)
	{
	}
	//-------------------------------------------------
	// END: Implementing: KeyListener
	//-------------------------------------------------

	//-------------------------------------------------
	// BEGIN: Implementing: FocusListener
	//-------------------------------------------------
	@Override
	public void focusLost(FocusEvent e)
	{
//		if (_store_cbx.equals(e.getSource()))
//			_title_txt.requestFocus();

		validateContent();
	}
	
	@Override
	public void focusGained(FocusEvent e)
	{
		Object source = e.getSource();

		if (   _resourceName_txt.equals(source)
		    || _subType_but     .equals(source)
//		    || _gpuId_txt       .equals(source)
		    || _xSize_txt       .equals(source)
		   )
		{
			JTextField field = (JTextField)e.getSource();
			field.selectAll();
		}
	}
	//-------------------------------------------------
	// END: Implementing: FocusListener
	//-------------------------------------------------

	@Override
	public String getProblemText()
	{
		if ( isInsert() )
		{
			int len = 0;
			JTextField field = null;

//			//----------------------------------
//			field = _gpuId_txt;
//			len = field.getText().trim().length();
//			if ( len > 0 )
//			{
//				try { new Integer(field.getText()); }
//				catch(NumberFormatException nfe) { return "GPU ID must be a Integer"; }
//			}

			//----------------------------------
			field = _xSize_txt;
			len = field.getText().trim().length();
			if ( len > 0 )
			{
				try { new Integer(field.getText()); }
				catch(NumberFormatException nfe) { return "Size must be a Integer"; }
			}
		}
		return null; 
	}

	private void showSystemsPickTable()
	{
		// Get Order Details (if its Delete or Update)
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Systems");

		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showSystemsPickTable", null);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			_systemName_txt.setText(pickList.getSelectedValuesAsString("systemName"));
			
			// FOCUS: Next field 
			_resourceName_txt.requestFocus();
		}
	}
	
	private void showResourcesPickTable()
	{
		// Get Order Details (if its Delete or Update)
//		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Resources_Grid");
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, 
				"select \n"
				+ "       r.resourceName \n"
				+ "     , r.hostname \n"
				+ "     , r.cpuType1Size \n"
				+ "     , r.cpuType2Size \n"
				+ "     , r.gpuSize \n"
				+ "     , separator = '>>> usage >>>' \n"
				+ "     , free_GPU    = (select r.gpuSize      - isnull(count(*),0)      from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType like 'GPU_%') \n"
				+ "     , used_GPU    = (select                  isnull(count(*),0)      from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType like 'GPU_%') \n"
				+ "     , free_CPU_T1 = (select r.cpuType1Size - isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , used_CPU_T1 = (select                  isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , free_CPU_T2 = (select r.cpuType2Size - isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , used_CPU_T2 = (select                  isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , usedBySystems = STUFF((SELECT distinct ', ' + s2g.systemName FROM dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName FOR XML PATH('')),1,1,'') \n"
				+ "from dbo.v_Resources_Grid r \n"
				+ "");

		List<Highlighter> tableHighligterList = new ArrayList<>();

		tableHighligterList.add(new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				if ( adapter.column == adapter.getColumnIndex("separator") )
					return true;
				return false;
			}
		}, Color.LIGHT_GRAY, null));
		
		tableHighligterList.add(new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				if ( adapter.column == adapter.getColumnIndex("free_GPU") || adapter.column == adapter.getColumnIndex("free_CPU_T1") || adapter.column == adapter.getColumnIndex("free_CPU_T2"))
				{
					Object obj = adapter.getValue();
					if (obj instanceof Number)
					if ( ((Number)obj).intValue() < 0 )
						return true;
				}
				return false;
			}
		}, Color.RED, null));
		
		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showResourcesPickTable", tableHighligterList);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			_resourceName_txt.setText(pickList.getSelectedValuesAsString("resourceName"));
			
			// FOCUS: Next field 
			_subType_txt.requestFocus();
		}
	}
	
	private void showSubTypesPickTable()
	{
		// Get Order Details (if its Delete or Update)
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from SystemToGridProps");

		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showSubTypesPickTable", null);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			String selectedVal = pickList.getSelectedValuesAsString("subType");
			_subType_txt.setText(selectedVal);
			
//			// FOCUS: Next field 
//			if ("GPU".equals(setValues))
//				_gpuId_txt.requestFocus();
//			else
				_xSize_txt.requestFocus();
		}
	}

	
	@Override
	public void setFields(GTable table, int vrow)
	{
		_systemName_txt  .setText(table.getValueAsString(vrow, "systemName",   false));
		_resourceName_txt.setText(table.getValueAsString(vrow, "resourceName", false));
		_subType_txt     .setText(table.getValueAsString(vrow, "subType",      false));
//		_gpuId_txt       .setText(table.getValueAsString(vrow, "gpuId",        false));
		_xSize_txt       .setText(table.getValueAsString(vrow, "size",         false));
	}

//	public String getStoreId()    { return _resourceName_txt  .getText(); }

	public String  getSystemName()    { return getStringValue (_systemName_txt); }
	public String  getResourceName()  { return getStringValue (_resourceName_txt); }
	public String  getSubType()       { return getStringValue (_subType_txt); }
//	public Integer getGpuId()         { return getIntegerValue(_gpuId_txt); }
	public Integer getXSize()         { return getIntegerValue(_xSize_txt); }

	
	@Override
	public boolean doInsert()
	{
//		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "insert into SystemToGrid(versionId, systemName, resourceName, subType, gpuId, size) values(?, ?, ?, ?, ?, ?)");
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "insert into SystemToGrid(versionId, systemName, resourceName, subType, size) values(?, ?, ?, ?, ?)");

		stmnt.addParam( SqlStatementParam.createInParam("versionId",    Types.INTEGER, EmdbAdmin.getCurrentViewVersion()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("systemName",   Types.VARCHAR, getSystemName()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("subType",      Types.VARCHAR, getSubType()       ) );
//		stmnt.addParam( SqlStatementParam.createInParam("gpuId",        Types.INTEGER, getGpuId()         ) );
		stmnt.addParam( SqlStatementParam.createInParam("size",         Types.INTEGER, getXSize()         ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"update v_SystemToGrid \n"
				+ "set size = ? \n"
//				+ "set gpuId = ? \n"
//				+ "  , size  = ? \n"
				+ "where systemName   = ? \n"
				+ "  and resourceName = ? \n"
				+ "  and subType      = ? \n"
				+ "");
	    
//		stmnt.addParam( SqlStatementParam.createInParam("gpuId",        Types.INTEGER, getGpuId()         ) );
		stmnt.addParam( SqlStatementParam.createInParam("size",         Types.INTEGER, getXSize()         ) );

		stmnt.addParam( SqlStatementParam.createInParam("systemName",   Types.VARCHAR, getSystemName()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("subType",      Types.VARCHAR, getSubType()       ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, 
				"delete from v_SystemToGrid \n"
				+ "where systemName   = ? \n"
				+ "  and resourceName = ? \n"
				+ "  and subType      = ? \n"
				+ "");

		stmnt.addParam( SqlStatementParam.createInParam("systemName",   Types.VARCHAR, getSystemName()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("resourceName", Types.VARCHAR, getResourceName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("subType",      Types.VARCHAR, getSubType()       ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}
}
