package se.sek.emdb.admin;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Types;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;

public class AddOrChangeVersion
extends AddOrChangeAbstract
implements ActionListener
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "Version";

	private int        _version_id       = -1;
	private JLabel     _version_id_lbl   = new JLabel("Version");
	private JTextField _version_id_txt   = new JTextField(10);
	
	private JLabel     _version_name_lbl = new JLabel("Name");
	private JTextField _version_name_txt = new JTextField(50);

	
	private JLabel     _templateVersion_lbl = new JLabel("Copy Version");
	private JTextField _templateVersion_txt = new JTextField(10);
	private JButton    _templateVersion_but = new JButton("...");
	private JLabel     _templateVersion_hlp = new JLabel(
			  "<html>"
			+ "Copy Version"
			+ "<ul>"
			+ "  <li>Leave <i>blank</i> to copy the <b>Active</b> version</li>"
			+ "  <li>Use <i>a versionid</i> to copy <b>that</b> specific version</li>"
			+ "  <li>Use -1 to create an <b>empty</b> version</li>"
			+ "</ul>"
			+ "</html>");


	public AddOrChangeVersion(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() || isDelete() )
		{
			_version_id_txt.setEnabled(false);
			panel.add(_version_id_lbl, "");
			panel.add(_version_id_txt, "growx, pushx, wrap 20");
		}

		panel.add(_version_name_lbl, "");
		panel.add(_version_name_txt, "growx, pushx, wrap");

		if ( isInsert() )
		{
			panel.add(_templateVersion_lbl, "");
			panel.add(_templateVersion_txt, "growx, pushx");
			panel.add(_templateVersion_but, "wrap");
			panel.add(_templateVersion_hlp, "skip, wrap");
		}

		if ( isDelete())
		{
			_version_name_txt .setEnabled(false);
		}

		_templateVersion_but.addActionListener(this);
		_templateVersion_txt.addActionListener(this);

		return panel;
	}

	//-------------------------------------------------
	// BEGIN: Implementing: ActionListener
	//-------------------------------------------------
	@Override
	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		
		if (_templateVersion_txt.equals(source) || _templateVersion_but.equals(source))
		{
			showVersionsPickTable();
		}

		validateContent();
	}
	//-------------------------------------------------
	// END: Implementing: ActionListener
	//-------------------------------------------------


	private void showVersionsPickTable()
	{
		// Get Order Details (if its Delete or Update)
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from Versions");

		SqlPickList pickList = new SqlPickList(this, getConnectionProvider(), stmnt, "showVersionsPickTable", null);

		boolean setValues = false;
		if (pickList.getRowCount() == 1)
			setValues = true;
		else
		{
			pickList.setVisible(true);
			if (pickList.wasOkPressed())
				setValues = true;
		}
		if (setValues)
		{
			_templateVersion_txt.setText(pickList.getSelectedValuesAsString("versionId"));
			
			// FOCUS: Next field 
			//_resourceName_txt.requestFocus();
		}
	}
	

	@Override
	public void setFields(GTable table, int vrow)
	{
		_version_id       = table.getValueAsInteger(vrow, "versionId", false);
		_version_id_txt   .setText(""+_version_id);

		_version_name_txt .setText(table.getValueAsString(vrow, "name", false));
	}

//	public String getStoreId()    { return _version_id_txt  .getText(); }

	public String  getVersionName()      { return getStringValue(_version_name_txt); }
	public Integer getTemplateVersion()  { return getIntegerValue(_templateVersion_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call newVersion(?, ?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("name",            Types.VARCHAR, getVersionName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("templateVersion", Types.INTEGER, getTemplateVersion()  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.PREPARED, "update Versions set name = ? where versionId = ?");
	    
		stmnt.addParam( SqlStatementParam.createInParam("name",        Types.VARCHAR, getVersionName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("versionId",   Types.INTEGER, _version_id) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call deleteVersion(?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("versionId",   Types.INTEGER, _version_id) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}

//	public static HashMap<String, Integer> getStoresLookup(Window owner, ConnectionProvider connProvider)
//	{
//		LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
//		
////		String sql = "select store_name, store_id from stores \n";
//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_stores_lookup(?, ?)}");
//		stmnt.addParam( SqlStatementParam.createInParam("store_name", Types.VARCHAR, "") );
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
//
//		try
//		{
//			ResultSet rs = stmnt.executeQuery(connProvider);
//			int rowc = 0;
//			while(rs.next())
//			{
//				rowc++;
//				map.put(rs.getString(1), rs.getInt(2));
//			}
//			SqlTraceWindow.getInstance().addRowcount( rowc );
//
//			SqlStatement.putWarningMessages(connProvider, null, rs);
//			rs.close();
//		}
//		catch (SQLException e)
//		{
//			SqlStatement.showErrorMessage(e, stmnt, owner, "Getting Stores (name,id) <b>failed.</b>");
//		}
//		
//		return map;
//	}
}
