package se.sek.emdb.admin;

import java.awt.Color;
import java.awt.Component;

import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

import se.sek.emdb.admin.AddOrChangeAbstract.OpType;
import se.sek.emdb.admin.SqlStatement.Type;


public class DataPanelAppHosts 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "App Hosts";

	public DataPanelAppHosts(EmdbAdmin owner)
	{
		super(owner, NAME, true);
	}


	@Override public boolean showAddButton()    { return true; }
	@Override public boolean showChangeButton() { return true; }
	@Override public boolean showRemoveButton() { return true; }

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangeAppHost(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);
		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangeAppHost(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangeAppHost(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	
	@Override
	protected void init()
	{
		ResultSetTable rst = getTable();

		// GREEN = Active
		rst.addHighlighter( new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				if ( adapter.column == adapter.getColumnIndex("separator") )
					return true;
				return false;
			}
		}, Color.LIGHT_GRAY, null));
	}

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
//		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Resources_AppServer");
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, 
			  "select \n"
			+ "      r.resourceName \n"
			+ "    , r.hostname \n"
			+ "    , separator = '>>> usage >>>' \n"
			+ "    , usedBySystem  = s.systemName \n"
			+ "from dbo.v_Resources_AppServer r \n"
			+ "     left outer join dbo.v_Systems s on (r.resourceName = s.resourceAppServer) \n"
			+ "");

		return stmnt;
	}
	
//	@Override
//	public List<String> getHiddenColumns()
//	{
//		List<String> hiddenCols = new ArrayList<String>();
//		hiddenCols.add("store_id");
//		return hiddenCols;
//	}
}
