package se.sek.emdb.admin;

import java.awt.Color;
import java.awt.Component;

import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

import se.sek.emdb.admin.AddOrChangeAbstract.OpType;
import se.sek.emdb.admin.SqlStatement.Type;


public class DataPanelGridHosts 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Grid Hosts";

	public DataPanelGridHosts(EmdbAdmin owner)
	{
		super(owner, NAME, true);
	}


	@Override public boolean showAddButton()    { return true; }
	@Override public boolean showChangeButton() { return true; }
	@Override public boolean showRemoveButton() { return true; }

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangeGridHost(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);
		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangeGridHost(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangeGridHost(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	
	@Override
	protected void init()
	{
		ResultSetTable rst = getTable();

		// LIGHT_GRAY = separator column
		rst.addHighlighter( new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				if ( adapter.column == adapter.getColumnIndex("separator") )
					return true;
				return false;
			}
		}, Color.LIGHT_GRAY, null));

		// RED = FREE is below 0
		rst.addHighlighter(new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				if ( adapter.column == adapter.getColumnIndex("free_GPU") || adapter.column == adapter.getColumnIndex("free_CPU_T1") || adapter.column == adapter.getColumnIndex("free_CPU_T2"))
				{
					Object obj = adapter.getValue();
					if (obj instanceof Number)
					if ( ((Number)obj).intValue() < 0 )
						return true;
				}
				return false;
			}
		}, Color.RED, null));
	}

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
//		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select * from v_Resources_Grid");
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, 
				"select \n"
				+ "       r.resourceName \n"
				+ "     , r.hostname \n"
				+ "     , r.cpuType1Size \n"
				+ "     , r.cpuType2Size \n"
				+ "     , r.gpuSize \n"
				+ "     , separator = '>>> usage >>>' \n"
				+ "     , free_GPU    = (select r.gpuSize      - isnull(count(*),0)      from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType like 'GPU_%') \n"
				+ "     , used_GPU    = (select                  isnull(count(*),0)      from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType like 'GPU_%') \n"
				+ "     , free_CPU_T1 = (select r.cpuType1Size - isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , used_CPU_T1 = (select                  isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , free_CPU_T2 = (select r.cpuType2Size - isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , used_CPU_T2 = (select                  isnull(sum(s2g.size),0) from dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName and s2g.subType = 'CPU_T2') \n"
				+ "     , usedBySystems = STUFF((SELECT distinct ', ' + s2g.systemName FROM dbo.v_SystemToGrid s2g where s2g.resourceName = r.resourceName FOR XML PATH('')),1,1,'') \n"
				+ "from dbo.v_Resources_Grid r \n"
				+ "");

		return stmnt;
	}
	
//	@Override
//	public List<String> getHiddenColumns()
//	{
//		List<String> hiddenCols = new ArrayList<String>();
//		hiddenCols.add("store_id");
//		return hiddenCols;
//	}
}
