package se.sek.emdb.admin;

import java.sql.Types;
import java.util.List;

import javax.swing.table.TableModel;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.table.TableColumnExt;

import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.ResultSetTableModel;
import se.sek.emdb.admin.utils.JsonUtils;


public class DataPanelJson 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "JSON Output";

	public DataPanelJson(EmdbAdmin owner)
	{
		super(owner, NAME, true);
		
		localInit();
	}


	private RSyntaxTextArea _json_txt;
	private RTextScrollPane _json_scr;
	
	private void localInit()
	{
		_json_txt = new RSyntaxTextArea();
		_json_txt.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_JSON);
		_json_txt.setCodeFoldingEnabled(true);

		_json_scr = new RTextScrollPane(_json_txt);

		add(_json_scr, "grow, push");
	}


	@Override public boolean showAddButton()    { return false; }
	@Override public boolean showChangeButton() { return false; }
	@Override public boolean showRemoveButton() { return false; }

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
//		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "exec getGridCfgAsJson");
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call getGridCfgAsJson(?, ?)}");

		stmnt.addParam( SqlStatementParam.createInParam("inStatus",   Types.VARCHAR, "P") );
		stmnt.addParam( SqlStatementParam.createInParam("version",    Types.INTEGER, EmdbAdmin.getCurrentViewVersion() ) );

		return stmnt;
	}
	
	@Override
	public void actionRefresh()
	{
//		refreshTableData();
		final SqlStatement sqlStmnt = getTableDataSqlStatement();

		try
		{
			// Executed the SQL
//			sqlStmnt.execute( getConnectionProvider() );
			sqlStmnt.executeWithGuiProgress( getConnectionProvider(), getOwner() );
			
			if (sqlStmnt.getResultSetCount() == 0)
				throw new Exception("No ResultSet was produced by the SQL Statement.");

			// Get the ResultSet and set in in the TABLE
			ResultSetTableModel rstm = sqlStmnt.getResultSet(0);
			
			StringBuilder jsonContent = new StringBuilder();
			for (int r=0; r<rstm.getRowCount(); r++)
				jsonContent.append(rstm.getValueAt(r, 0));
			
			_json_txt.setText(JsonUtils.format(jsonContent.toString()));
			_json_txt.setCaretPosition(0);
			

			SqlStatement.showWarningMessages(getConnectionProvider(), getOwner(), "Warning messages from db for: "+getName());
		}
//		catch (SQLException ex)
		catch (Throwable ex)
		{
			SqlStatement.showErrorMessage(ex, sqlStmnt, _owner.getWindow(), "Getting "+getName()+" information <b>failed.</b>");
		}
	}

//	@Override
//	public void onTabSelected()
//	{
////		super.onTabSelected();
//
//		if ( ! getConnectionProvider().isConnected() )
//			return;
//
//		
//	}
}
