package se.sek.emdb.admin;

import se.sek.emdb.admin.AddOrChangeAbstract.OpType;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.ui.GTable;
import se.sek.emdb.admin.utils.StringUtil;


public class DataPanelSystemGrid 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Grid Allocations";
	
	private String[] _systemNames  = {};

	public DataPanelSystemGrid(EmdbAdmin owner)
	{
		super(owner, NAME, true);
	}

	@Override public boolean showAddButton()            { return true; }
	@Override public boolean showChangeButton()         { return true; }
	@Override public boolean showRemoveButton()         { return true; }
	@Override public boolean showTableToolTipCheckbox() { return true; }

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangeSystemGrid(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);

		int vrow = getTable().getSelectedRow();
		if (vrow >= 0)
			dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangeSystemGrid(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangeSystemGrid(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	
	@Override
	public void onParentTableSelection(DataPanelAbstract parent)
	{
		// Authors
		if (DataPanelSystems.NAME.equals(parent.getName()))
		{
			GTable tab = parent.getTable();
			
			int[] selectedRows = tab.getSelectedRows();
			
			// Allocate some strings for AU_ID
			_systemNames = new String[selectedRows.length];
			
			for (int r=0; r<selectedRows.length; r++)
			{
				String str = tab.getValueAsString(selectedRows[r], "systemName", false);
				if (str != null)
					_systemNames[r] = str;
			}
		}
		
		// Refresh the local table, which will call getTableDataSqlStatement() to get a SqlStatement to execute
		refreshTableData();
	}

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
		String where = "where 1=2 \n";
		if (_systemNames.length > 0)
			where = "where systemName in(" + StringUtil.toCommaStr(_systemNames, ", ", "'", "'") + ") \n";

		String au_id_values = null;
		if (_systemNames.length > 0)
			au_id_values = StringUtil.toCommaStr(_systemNames, ",");
		
		if (StringUtil.isNullOrBlank(au_id_values))
			au_id_values = "-1";

//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles(?, ?, ?, ?, ?)}");
//
//		stmnt.addParam( SqlStatementParam.createInParam("au_id_list",  Types.VARCHAR, au_id_values) );
//		stmnt.addParam( SqlStatementParam.createInParam("pub_id_list", Types.VARCHAR, null) );
//		stmnt.addParam( SqlStatementParam.createInParam("title_name",  Types.VARCHAR, null) );
//		stmnt.addParam( SqlStatementParam.createInParam("has_picture", Types.INTEGER, null) );
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );

		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, "select systemName, resourceName, subType, size from v_SystemToGrid "+where+" order by systemName, resourceName, subType");

		return stmnt;
	}

//	@Override
//	public List<String> getHiddenColumns()
//	{
//		List<String> hiddenCols = new ArrayList<String>();
//
////		hiddenCols.add("publisher_name");
//		hiddenCols.add("author_name");
//
//		hiddenCols.add("title_id");
//		hiddenCols.add("au_id");
//		hiddenCols.add("pub_id");
//		
//		return hiddenCols;
//	}

//	@Override
//	public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol)
//	{
//		if ( ! isTableToolTipEnabled() )
//			return null;
//		
//		return getTableToolTipTextWithPicture(rstm, mrow, mcol, "{call ${PKG:titles_pkg}get_title_picture(?,?)}", "title_id", AddOrChangeAuthor.NO_PICTURE, new Dimension(300, 400));
//	}
}
