package se.sek.emdb.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Types;

import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import org.apache.log4j.Logger;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.AddOrChangeAbstract.OpType;
import se.sek.emdb.admin.SqlStatement.Type;
import se.sek.emdb.admin.utils.SwingUtils;


public class DataPanelVersions 
extends DataPanelAbstract
{
	private static Logger _logger = Logger.getLogger(DataPanelVersions.class);
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Versions";

	private JButton _setVersion_but;
	private JButton _activateVersion_but;
	private EmdbAdmin _emdbAdmin;

	
	public DataPanelVersions(EmdbAdmin owner)
	{
		super(owner, NAME, true);
		_emdbAdmin = owner;
	}

	@Override
	public JPopupMenu createDataTablePopupMenu(final ResultSetTable tab)
	{
		JPopupMenu pm = super.createDataTablePopupMenu(tab);
		
		JMenuItem setViewVersion_mi = new JMenuItem("Set Working/view Version");

		pm.add(setViewVersion_mi);
		setViewVersion_mi.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				_setVersion_but.doClick();
			}
		});
		pm.add(setViewVersion_mi);
				
		return pm;
	}

	@Override
	public JPanel createUserDefinedButtonsPanel()
	{
		JPanel panel = new JPanel(new MigLayout("ins 0 0 0 0"));
		
		_activateVersion_but = new JButton("Activate a Planed Version");
		_activateVersion_but.setEnabled(false);

		_setVersion_but = new JButton("Set Working/view Version");
		_setVersion_but.setEnabled(false);

		panel.add(_activateVersion_but, "");
		panel.add(_setVersion_but,      "");
		
		_activateVersion_but.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				ResultSetTable rst = getTable();
				int selectedRow = rst.getSelectedRow();
				
				if (selectedRow < 0)
				{
					SwingUtils.showInfoMessage(getOwner(), "No row is selected", "Please select a version/row from the table.");
				}
				else
				{
					int version   = rst.getValueAsInteger(selectedRow, "versionId");
					String status = rst.getValueAsString (selectedRow, "status");
					String name   = rst.getValueAsString (selectedRow, "name");

					// If status is PLANED
					if ("P".equals(status))
					{
						int question = JOptionPane.showConfirmDialog (getOwner(), "Are you sure you want to change the status from PLANED to ACTIVE for version "+version+", with the name '"+name+"'.", "Question", JOptionPane.YES_NO_OPTION);
						if(question == JOptionPane.NO_OPTION)
						{
							// No change
							return;
						}

						try
						{
							SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call setActiveVersion(?)}");

							stmnt.addParam( SqlStatementParam.createInParam("versionId",   Types.INTEGER, version) );

							stmnt.execute(getConnectionProvider(), null);

							_emdbAdmin.setViewVersion(version);
						}
						catch(SQLException ex)
						{
							_logger.warn("Problems setActiveVersion. Caught: "+ex);
						}
					}
					else
					{
						SwingUtils.showErrorMessage(getOwner(), "Status not in PLANED", "The status must be in 'P' Planed to be activated.", null);
					}
					
					// Refresh the data table content
					fireRefresh();
				}
			}
		});
		
		_setVersion_but.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				ResultSetTable rst = getTable();
				int selectedRow = rst.getSelectedRow();
				
				if (selectedRow < 0)
				{
					SwingUtils.showInfoMessage(getOwner(), "No row is selected", "Please select a version/row from the table.");
				}
				else
				{
					int version = rst.getValueAsInteger(selectedRow, "versionId");
					
					System.out.println("set version to '"+version+"'.");
					_emdbAdmin.setViewVersion(version);
				}
			}
		});
		
		return panel;
	}

	@Override
	protected void init()
	{
		ResultSetTable rst = getTable();

		// GREEN = Active
		rst.addHighlighter( new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				String status = adapter.getString(adapter.getColumnIndex("status"));
				if ("A".equals(status))
					return true;
				return false;
			}
		}, Color.GREEN, null));

//		// BLUE = History
//		rst.addHighlighter( new ColorHighlighter(new HighlightPredicate()
//		{
//			@Override
//			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
//			{
//				String status = adapter.getString(adapter.getColumnIndex("status"));
//				if ("H".equals(status))
//					return true;
//				return false;
//			}
//		}, Color.BLUE, null));

		// YELLOW = Planed
		rst.addHighlighter( new ColorHighlighter(new HighlightPredicate()
		{
			@Override
			public boolean isHighlighted(Component renderer, ComponentAdapter adapter)
			{
				String status = adapter.getString(adapter.getColumnIndex("status"));
				if ("P".equals(status))
					return true;
				return false;
			}
		}, Color.YELLOW, null));
	}

	@Override
	public void onTableSelection()
	{
		boolean enable = getTable().getSelectedRowCount() == 1;
		_setVersion_but.setEnabled(enable);
		
		enable = false;
		if (getTable().getSelectedRowCount() == 1)
		{
    		int selectedRow = getTable().getSelectedRow();
   			String status = getTable().getValueAsString(selectedRow, "status");
   			if ("P".equals(status))
   				enable = true;
		}
		_activateVersion_but.setEnabled(enable);
	}

	@Override public boolean showAddButton()    { return true; }
	@Override public boolean showChangeButton() { return true; }
	@Override public boolean showRemoveButton() { return true; }

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangeVersion(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);
		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangeVersion(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangeVersion(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	
	@Override
	public SqlStatement getTableDataSqlStatement()
	{
		SqlStatement stmnt = new SqlStatement(Type.LANGUAGE, 
				  "select \n"
				+ "  versionId \n"
				+ " ,name \n"
				+ " ,status \n"
				+ " ,CASE WHEN status = 'A' THEN 'Active' \n"
				+ "       WHEN status = 'P' THEN 'Planed' \n"
				+ "       WHEN status = 'H' THEN 'Historical' \n"
				+ "       ELSE 'UNKNOWN' \n"
				+ "  END  as statusStr \n"
				+ " ,responible \n"
				+ " ,crDate \n"
				+ " ,releaseDate \n"
				+ " ,historyDate \n"
				+ "from Versions \n");

		return stmnt;
	}
	
//	@Override
//	public List<String> getHiddenColumns()
//	{
//		List<String> hiddenCols = new ArrayList<String>();
//		hiddenCols.add("store_id");
//		return hiddenCols;
//	}
}
