package se.sek.emdb.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

import net.miginfocom.swing.MigLayout;
import se.sek.emdb.admin.utils.Configuration;

public class SplitPanelAbstract
extends JPanel
{
	private static final long serialVersionUID = 1L;
	
	private   EmdbAdmin        _owner         = null;
	protected DataPanelAbstract _left          = null;
	protected DataPanelAbstract _right         = null;
	
	private   JSplitPane        _splitPane     = null;

	private   JLabel            _splitOrientation_lbl = new JLabel("Panel Orientation");
	private   String[]          _splitOrientation_val = {"Top to Bottom", "Side by Side"};  // JSplitPane.VERTICAL_SPLIT = 0, JSplitPane.HORIZONTAL_SPLIT = 1
	private   JComboBox         _splitOrientation_cbx = new JComboBox(_splitOrientation_val);


	public static final String PROPKEY_SPLITPANE_DIVIDER_LOCATION    = ".splitPane.dividerLocation";
	public static final String PROPKEY_SPLITPANE_DIVIDER_ORIENTATION = ".splitPane.dividerOrientation";

	public SplitPanelAbstract(EmdbAdmin owner, String name, DataPanelAbstract left, DataPanelAbstract right)
	{
		setName(name);

		_owner = owner;
		_left  = left;
		_right = right;

		// On left JTable selection: call onParentTableSelection(_left)
		_left.addChildTableSelectionListener(_right);

		init();
	}

	private void init()
	{
		setLayout( new MigLayout("insets 0 0 0 0") );

		// Set divider orientation
		String key = getName() + PROPKEY_SPLITPANE_DIVIDER_ORIENTATION;
		int val = Configuration.getCombinedConfiguration().getIntProperty(key, JSplitPane.HORIZONTAL_SPLIT);
		_splitPane = new JSplitPane(val, _left, _right);
		_splitOrientation_cbx.setSelectedIndex(val);
//System.out.println("_splitPane.dividerOrientation: restore(): key='"+key+"', val="+val);

		// Set divider location
		key = getName() + PROPKEY_SPLITPANE_DIVIDER_LOCATION;
		val = Configuration.getCombinedConfiguration().getIntProperty(key, -1);
//System.out.println("_splitPane.dividerLocation: restore(): key='"+key+"', divLoc="+val);
		if (val >= 0)
			_splitPane.setDividerLocation(val);


		// ADD layout
		add(_splitPane,            "grow, push, wrap");

		add(_splitOrientation_lbl, "gapleft 5, split");
		add(_splitOrientation_cbx, "wrap");


		
		// ActionListener: SplitOrientation
		_splitOrientation_cbx.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				int index = _splitOrientation_cbx.getSelectedIndex();
				
				Configuration conf = Configuration.getInstance(Configuration.USER_TEMP);
				if (conf != null)
				{
					String key = getName() + PROPKEY_SPLITPANE_DIVIDER_ORIENTATION;
					int    val = index;

					conf.setProperty(key, val);
					conf.save();
				}
				
				_splitPane.setOrientation(index);
			}
		});

		// Add Change listener for the SPLITPANE
		_splitPane.addPropertyChangeListener(JSplitPane.DIVIDER_LOCATION_PROPERTY, new PropertyChangeListener()
		{
			@Override
			public void propertyChange(PropertyChangeEvent evt)
			{
				Configuration conf = Configuration.getInstance(Configuration.USER_TEMP);
				if (conf != null)
				{
					String key = getName() + PROPKEY_SPLITPANE_DIVIDER_LOCATION;
					int    val = _splitPane.getDividerLocation();

					conf.setProperty(key, val);
					conf.save();
//System.out.println("_splitPane: propertyChange(): key='"+propKey+"', divLoc="+divLoc);
				}
			}
		});
	}

	public EmdbAdmin        getOwner()     { return _owner; }
	public DataPanelAbstract getLeftPane()  { return _left; }
	public DataPanelAbstract getRightPane() { return _right; }

//	public void              setLeftPane (DataPanelAbstract panel) { _left  = panel; _splitPane.setLeftComponent(panel);  }
//	public void              setRightPane(DataPanelAbstract panel) { _right = panel; _splitPane.setRightComponent(panel); }

	public void onConnect()
	{
		_left .onConnect();
		_right.onConnect();
	}

	public void onDisconnect()
	{
		_left .onDisconnect();
		_right.onDisconnect();
	}

	public void onTabSelected()
	{
		_left.onTabSelected();
	}
}
