/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AAxisTransformation;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import java.util.Iterator;

public class AxisLog10
extends AAxisTransformation {
    public AxisLog10() {
        super(new LabelFormatterSimple());
    }

    public AxisLog10(IAxisLabelFormatter formatter) {
        super(formatter);
    }

    protected double transform(double in) {
        double result;
        double toTransform = in;
        if (toTransform < 1.0) {
            if (this.m_accessor == null) {
                throw new IllegalStateException("Connect this axis (" + this.getAxisTitle().getTitle() + ") to a chart first before doing this operation.");
            }
            Iterator itTraces = this.m_accessor.getChart().getTraces().iterator();
            if (!itTraces.hasNext()) {
                toTransform = 1.0;
            } else {
                while (itTraces.hasNext()) {
                    ITrace2D trace = (ITrace2D)itTraces.next();
                    if (!trace.iterator().hasNext()) continue;
                    throw new IllegalArgumentException(this.getClass().getName() + " must not be used with values < 1!");
                }
                toTransform = 1.0;
            }
        }
        if (Double.isInfinite(result = Math.log(toTransform) / Math.log(10.0))) {
            result = Double.MAX_VALUE;
        }
        return result;
    }

    protected double untransform(double in) {
        return Math.pow(10.0, in);
    }
}

