/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.Token;
import java.io.IOException;

public class Slurp
extends Token {
    public Slurp(TdsInputStream tdsInputStream, int n2) throws IOException {
        try {
            int n3 = this.getLength(tdsInputStream, n2);
            tdsInputStream.skipBytes(n3);
        }
        catch (IOException iOException) {
            Slurp.readSQE(iOException);
        }
    }

    public Slurp() {
    }

    public int getLength(TdsInputStream tdsInputStream, int n2) throws IOException {
        int n3 = 0;
        try {
            if ((n2 & 0xE0) == 192) {
                n3 = 0;
            } else if ((n2 & 0x30) == 48) {
                switch (n2 & 0xC) {
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 4: {
                        n3 = 2;
                        break;
                    }
                    case 8: {
                        n3 = 4;
                        break;
                    }
                    case 12: {
                        n3 = 8;
                    }
                }
            } else {
                switch (n2 & 0xFC) {
                    case 36: 
                    case 40: 
                    case 100: 
                    case 104: {
                        n3 = tdsInputStream.readUnsignedByte();
                        break;
                    }
                    case 32: 
                    case 96: {
                        n3 = tdsInputStream.readInt();
                        break;
                    }
                    default: {
                        n3 = tdsInputStream.readUnsignedShort();
                    }
                }
            }
        }
        catch (IOException iOException) {
            Slurp.readSQE(iOException);
        }
        return n3;
    }
}

