/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.AseTraceFlagsDictionary;
import asemon.pcs.PersistWriterJdbc;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.AseSqlScript;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public abstract class AseConfigText {
    private static Logger _logger = Logger.getLogger(AseConfigText.class);
    private static Map<ConfigType, AseConfigText> _instances = new HashMap<ConfigType, AseConfigText>();
    private boolean _offline = false;
    private boolean _hasGui = false;
    private String _configStr = null;

    public static boolean hasInstance(ConfigType type) {
        return _instances.containsKey((Object)type);
    }

    public static AseConfigText getInstance(ConfigType type) {
        if (!AseConfigText.hasInstance(type)) {
            AseConfigText.createInstance(type);
        }
        return _instances.get((Object)type);
    }

    private static void createInstance(ConfigType type) {
        AseConfigText aseConfigText = null;
        switch (type) {
            case AseCacheConfig: {
                aseConfigText = new Cache();
                break;
            }
            case AseHelpDb: {
                aseConfigText = new HelpDb();
                break;
            }
            case AseHelpDevice: {
                aseConfigText = new HelpDevice();
                break;
            }
            case AseHelpServer: {
                aseConfigText = new HelpServer();
                break;
            }
            case AseTraceflags: {
                aseConfigText = new Traceflags();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type was passed when create instance. " + (Object)((Object)type));
            }
        }
        _instances.put(type, aseConfigText);
    }

    public abstract ConfigType getConfigType();

    protected abstract String getSqlCurrentConfig(int var1);

    protected String getSqlOffline(Timestamp ts) {
        String sql = "select \"configText\" \nfrom " + PersistWriterJdbc.getTableName(9, null, true) + " \n" + "where \"configName\"       = '" + this.getConfigType().toString() + "' \n" + "  and \"SessionStartTime\" = ";
        sql = ts == null ? sql + " (select max(\"SessionStartTime\")   from " + PersistWriterJdbc.getTableName(9, null, true) + " ) " : sql + "'" + ts + "'";
        return sql;
    }

    public String getConfig() {
        return this._configStr;
    }

    protected void setConfig(String str) {
        this._configStr = str;
    }

    public boolean isInitialized() {
        return this._configStr != null;
    }

    public void initialize(Connection conn, boolean hasGui, boolean offline, Timestamp ts) {
        this._hasGui = hasGui;
        this._offline = offline;
        this.refresh(conn, ts);
    }

    public static void initializeAll(Connection conn, boolean hasGui, boolean offline, Timestamp ts) {
        for (ConfigType t : ConfigType.values()) {
            AseConfigText aseConfigText = AseConfigText.getInstance(t);
            if (aseConfigText.isInitialized()) continue;
            aseConfigText.initialize(conn, hasGui, offline, ts);
        }
    }

    public static void reset() {
        _instances.clear();
    }

    public void refresh(Connection conn, Timestamp ts) {
        if (conn == null) {
            return;
        }
        this._configStr = null;
        if (!this._offline) {
            int aseVersion = AseConnectionUtils.getAseVersionNumber(conn);
            String sql = this.getSqlCurrentConfig(aseVersion);
            try {
                AseSqlScript script = new AseSqlScript(conn);
                this._configStr = script.executeSqlStr(sql);
            }
            catch (SQLException ex) {
                _logger.error((Object)("AseConfigText:initialize:sql='" + sql + "'"), (Throwable)ex);
                if (this._hasGui) {
                    SwingUtils.showErrorMessage("AseConfigText - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
                }
                this._configStr = null;
                return;
            }
        }
        String sql = this.getSqlOffline(ts);
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this._configStr = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            if (this._offline && ex.getMessage().contains("not found")) {
                _logger.warn((Object)("The saved value for '" + this.getConfigType().toString() + "' wasn't available in the offline database, sorry."));
                return;
            }
            _logger.error((Object)("AseConfigText:initialize:sql='" + sql + "'"), (Throwable)ex);
            if (this._hasGui) {
                SwingUtils.showErrorMessage("AseConfigText - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
            }
            this._configStr = null;
            return;
        }
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf2 = new Configuration("c:\\projects\\asemon\\asemon.properties");
        Configuration.setInstance("SYSTEM_CONF", conf2);
        try {
            System.out.println("Open the Dialog with a VALID connection.");
            Connection conn = AseConnectionFactory.getConnection("localhost", 5000, null, "sa", "", "test-AseConfigText", null);
            AseConfigText c = AseConfigText.getInstance(ConfigType.AseCacheConfig);
            c.initialize(conn, true, false, null);
            System.out.println("AseConfigText(AseCacheConfig).getConfig()=\n" + c.getConfig());
            c = AseConfigText.getInstance(ConfigType.AseHelpDb);
            c.initialize(conn, true, false, null);
            System.out.println("AseConfigText(AseHelpdb).getConfig()=\n" + c.getConfig());
            c = AseConfigText.getInstance(ConfigType.AseHelpDevice);
            c.initialize(conn, true, false, null);
            System.out.println("AseConfigText(AseHelpdevice).getConfig()=\n" + c.getConfig());
            c = AseConfigText.getInstance(ConfigType.AseHelpServer);
            c.initialize(conn, true, false, null);
            System.out.println("AseConfigText(AseHelpServer).getConfig()=\n" + c.getConfig());
            c = AseConfigText.getInstance(ConfigType.AseTraceflags);
            c.initialize(conn, true, false, null);
            System.out.println("AseConfigText(AseTraceflags).getConfig()=\n" + c.getConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Traceflags
    extends AseConfigText {
        @Override
        public ConfigType getConfigType() {
            return ConfigType.AseTraceflags;
        }

        @Override
        protected String getSqlCurrentConfig(int aseVersion) {
            if (aseVersion >= 15020 || aseVersion >= 12540 && aseVersion <= 15000) {
                return "show switch";
            }
            return "dbcc traceon(3604) dbcc traceflags dbcc traceoff(3604)";
        }

        @Override
        public void refresh(Connection conn, Timestamp ts) {
            String[] sa;
            super.refresh(conn, ts);
            String configStr = this.getConfig();
            if (configStr == null) {
                return;
            }
            if (!configStr.startsWith("Local switches")) {
                StringBuilder sb = new StringBuilder();
                boolean foundSomeRows = false;
                BufferedReader reader = new BufferedReader(new StringReader(configStr));
                try {
                    String inStr = null;
                    while ((inStr = reader.readLine()) != null) {
                        if (inStr.startsWith("DBCC execution completed.")) continue;
                        sb.append(inStr).append("\n");
                        if (inStr.length() <= 0) continue;
                        foundSomeRows = true;
                    }
                }
                catch (IOException e) {
                    sb = new StringBuilder(configStr);
                }
                if (!foundSomeRows && sb.length() < 9) {
                    sb = new StringBuilder("No traceflags was found.");
                }
                this.setConfig(sb.toString());
            }
            LinkedHashSet<Integer> flags = new LinkedHashSet<Integer>();
            configStr = this.getConfig();
            for (String str : sa = configStr.split("\\s")) {
                try {
                    int intTrace = Integer.parseInt(str.replace(",", ""));
                    flags.add(intTrace);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (flags.size() > 0) {
                StringBuilder sb = new StringBuilder(configStr);
                sb.append("\n\n");
                sb.append("===========================================================================\n");
                sb.append("Explanation of the trace flags\n");
                sb.append("---------------------------------------------------------------------------\n");
                AseTraceFlagsDictionary tfd = AseTraceFlagsDictionary.getInstance();
                for (Integer trace : flags) {
                    sb.append(tfd.getDescription(trace)).append("\n");
                }
                sb.append("---------------------------------------------------------------------------\n");
                this.setConfig(sb.toString());
            }
        }
    }

    public static class HelpServer
    extends AseConfigText {
        @Override
        public ConfigType getConfigType() {
            return ConfigType.AseHelpServer;
        }

        @Override
        protected String getSqlCurrentConfig(int aseVersion) {
            return "exec sp_helpserver";
        }
    }

    public static class HelpDevice
    extends AseConfigText {
        @Override
        public ConfigType getConfigType() {
            return ConfigType.AseHelpDevice;
        }

        @Override
        protected String getSqlCurrentConfig(int aseVersion) {
            return "exec sp_helpdevice";
        }
    }

    public static class HelpDb
    extends AseConfigText {
        @Override
        public ConfigType getConfigType() {
            return ConfigType.AseHelpDb;
        }

        @Override
        protected String getSqlCurrentConfig(int aseVersion) {
            return "exec sp_helpdb";
        }
    }

    public static class Cache
    extends AseConfigText {
        private static final String MB_AVAIL_FOR_RECONF_STR = "MB available for reconfiguration";
        private String _freeMemoryStr = null;
        private Double _freeMemory = null;

        public String getFreeMemoryStr() {
            return this._freeMemoryStr;
        }

        public Double getFreeMemory() {
            return this._freeMemory == null ? 0.0 : this._freeMemory;
        }

        @Override
        public void refresh(Connection conn, Timestamp ts) {
            super.refresh(conn, ts);
            String configStr = this.getConfig();
            if (configStr != null) {
                int stop;
                int start;
                for (start = stop = configStr.indexOf(MB_AVAIL_FOR_RECONF_STR) - 1; start > 0; --start) {
                    if (configStr.charAt(start) != '\n') continue;
                    ++start;
                    break;
                }
                this._freeMemory = null;
                if (stop > 0) {
                    String mb = configStr.substring(start, stop);
                    _logger.debug((Object)("parse Available Memory for reconfiguration: start=" + start + ", stop=" + stop + ", MB='" + mb + "'."));
                    try {
                        this._freeMemory = Double.parseDouble(mb);
                    }
                    catch (NumberFormatException e) {
                        _logger.warn((Object)("Can't parse the Free MB for reuse, MB='" + mb + "'. Caught=" + e));
                        this._freeMemory = null;
                    }
                }
                this._freeMemoryStr = (this._freeMemory == null ? "UNKNOWN" : this._freeMemory) + " " + MB_AVAIL_FOR_RECONF_STR;
            }
        }

        @Override
        public ConfigType getConfigType() {
            return ConfigType.AseCacheConfig;
        }

        @Override
        protected String getSqlCurrentConfig(int aseVersion) {
            return "select ConfigSnapshotAtDateTime = convert(varchar(30),getdate(),109) \nprint '' \nprint '######################################################################################' \nprint '## ASE Memory available for reconfiguration' \nprint '######################################################################################' \ndeclare @freeMb varchar(30) \n \nselect @freeMb = ltrim(str( ((max(b.value) - min(b.value)) / 512.0), 15,1 )) \nfrom master.dbo.sysconfigures a, master.dbo.syscurconfigs b \nwhere a.name in ('max memory', 'total logical memory') \n  and a.config = b.config \n \nprint '%1! MB available for reconfiguration.', @freeMb  \nprint '' \nprint '######################################################################################' \nprint '## sp_helpcache' \nprint '######################################################################################' \nexec sp_helpcache \nprint '' \nprint '######################################################################################' \nprint '## sp_cacheconfig' \nprint '######################################################################################' \nexec sp_cacheconfig \n\n";
        }
    }

    public static enum ConfigType {
        AseCacheConfig,
        AseHelpDb,
        AseHelpDevice,
        AseHelpServer,
        AseTraceflags;

    }
}

