/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.DebugOptions;
import asemon.GetCounters;
import asemon.GetCountersGui;
import asemon.GetCountersNoGui;
import asemon.NormalExitException;
import asemon.Version;
import asemon.check.CheckForUpdates;
import asemon.cm.CounterSetTemplates;
import asemon.gui.GuiLogAppender;
import asemon.gui.MainFrame;
import asemon.gui.SplashWindow;
import asemon.gui.swing.debug.EventDispatchThreadHangMonitor;
import asemon.utils.AseConnectionFactory;
import asemon.utils.Configuration;
import asemon.utils.Debug;
import asemon.utils.JavaVersion;
import asemon.utils.Logging;
import asemon.utils.StringUtil;
import asemon.utils.SwingExceptionHandler;
import asemon.utils.SwingUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class Asemon {
    private static Logger _logger = Logger.getLogger(Asemon.class);
    private static GetCounters getCnt = null;
    private static boolean _gui = true;
    private static boolean _hasDevVersionExpired = false;

    public Asemon(CommandLine cmd) throws Exception {
        this.init(cmd);
    }

    public static boolean hasDevVersionExpired() {
        return _hasDevVersionExpired;
    }

    public void init(CommandLine cmd) throws Exception {
        String cmdLineHostname;
        String[] sa;
        File asemonStoreDir = new File(Version.APP_STORE_DIR);
        if (!asemonStoreDir.exists() && asemonStoreDir.mkdir()) {
            System.out.println("Creating directory '" + asemonStoreDir + "' to hold various files for AseMon.");
        }
        String CONFIG_FILE_NAME = System.getProperty("CONFIG_FILE_NAME", "asemon.properties");
        String USER_CONFIG_FILE_NAME = System.getProperty("USER_CONFIG_FILE_NAME", "asemon.user.properties");
        String TMP_CONFIG_FILE_NAME = System.getProperty("TMP_CONFIG_FILE_NAME", "asemon.save.properties");
        String ASEMON_HOME = System.getProperty("ASEMON_HOME");
        String defaultPropsFile = ASEMON_HOME != null ? ASEMON_HOME + "/" + CONFIG_FILE_NAME : CONFIG_FILE_NAME;
        String defaultUserPropsFile = Version.APP_STORE_DIR != null ? Version.APP_STORE_DIR + "/" + USER_CONFIG_FILE_NAME : USER_CONFIG_FILE_NAME;
        String defaultTmpPropsFile = Version.APP_STORE_DIR != null ? Version.APP_STORE_DIR + "/" + TMP_CONFIG_FILE_NAME : TMP_CONFIG_FILE_NAME;
        String filename = Version.APP_STORE_DIR + "/" + CONFIG_FILE_NAME;
        if (new File(filename).exists()) {
            defaultPropsFile = filename;
        }
        String propFile = cmd.getOptionValue("config", defaultPropsFile);
        String userPropFile = cmd.getOptionValue("userConfig", defaultUserPropsFile);
        String tmpPropFile = cmd.getOptionValue("tmpConfig", defaultTmpPropsFile);
        String noGuiConfigFile = cmd.getOptionValue("noGui");
        if (!new File(propFile).exists()) {
            throw new FileNotFoundException("The configuration file '" + propFile + "' doesn't exists.");
        }
        _gui = true;
        if (cmd.hasOption("noGui")) {
            _gui = false;
        }
        System.setProperty("application.gui", Boolean.toString(_gui));
        int javaVersionInt = JavaVersion.getVersion();
        if (javaVersionInt != -1 && javaVersionInt < 160) {
            System.out.println("");
            System.out.println("===============================================================");
            System.out.println(" Asemon needs a runtime JVM 1.6 or higher.");
            System.out.println(" java.version = " + System.getProperty("java.version"));
            System.out.println(" which is parsed into the number: " + JavaVersion.getVersion());
            System.out.println("---------------------------------------------------------------");
            System.out.println("");
            throw new Exception("Asemon needs a runtime JVM 1.6 or higher.");
        }
        Configuration asemonSaveProps = new Configuration(tmpPropFile);
        Configuration.setInstance("USER_TEMP", asemonSaveProps);
        Configuration asemonUserProps = new Configuration(userPropFile);
        Configuration.setInstance("USER_CONF", asemonUserProps);
        Configuration asemonProps = new Configuration(propFile);
        Configuration.setInstance("SYSTEM_CONF", asemonProps);
        Configuration storeConfigProps = new Configuration();
        Configuration.setInstance("PCS", storeConfigProps);
        Configuration.setSearchOrder("USER_TEMP", "USER_CONF", "SYSTEM_CONF");
        if (cmd.hasOption('l')) {
            Map<String, String> shortToLongCmMap = CounterSetTemplates.getShortToLongMap();
            System.out.println();
            System.out.println("======================================================================");
            System.out.println("Here is a list of all available Performance Counters:");
            System.out.println("Short name           Long Name");
            System.out.println("-------------------- ------------------------------------------------------");
            for (Map.Entry<String, String> entry : shortToLongCmMap.entrySet()) {
                String shortName = entry.getKey();
                String longName = entry.getValue();
                System.out.println(StringUtil.left(shortName, 20) + " " + longName);
            }
            System.out.println();
            Asemon.printTemplate("small");
            Asemon.printTemplate("medium");
            Asemon.printTemplate("large");
            Asemon.printTemplate("all");
            throw new NormalExitException("Done after -l switch.");
        }
        DebugOptions.init();
        if (cmd.hasOption('x')) {
            String cmdLineDebug = cmd.getOptionValue('x');
            sa = cmdLineDebug.split(",");
            for (int i = 0; i < sa.length; ++i) {
                String str = sa[i].trim();
                if (str.equalsIgnoreCase("list")) {
                    System.out.println();
                    System.out.println(" Option          Description");
                    System.out.println(" --------------- -------------------------------------------------------------");
                    for (Map.Entry<String, String> entry : Debug.getKnownDebugs().entrySet()) {
                        String debugOption = entry.getKey();
                        String description = entry.getValue();
                        System.out.println(" " + StringUtil.left(debugOption, 15, true) + " " + description);
                    }
                    System.out.println();
                    throw new NormalExitException("List of debug options");
                }
                Debug.addDebug(str);
            }
        }
        if (_gui) {
            if (cmd.hasOption('U')) {
                asemonProps.setProperty("cmdLine.aseUsername", cmd.getOptionValue('U'));
            }
            if (cmd.hasOption('P')) {
                asemonProps.setProperty("cmdLine.asePassword", cmd.getOptionValue('P'));
            }
            if (cmd.hasOption('S')) {
                asemonProps.setProperty("cmdLine.aseServer", cmd.getOptionValue('S'));
            }
            if (cmd.hasOption('S')) {
                String cmdLineServer = cmd.getOptionValue('S');
                if (cmdLineServer.indexOf(":") >= 0) {
                    if (!AseConnectionFactory.isHostPortStrValid(cmdLineServer)) {
                        throw new Exception("Problems with command line parameter -S" + cmdLineServer + "; " + AseConnectionFactory.isHostPortStrValidReason(cmdLineServer));
                    }
                } else if (AseConnectionFactory.resolvInterfaceEntry(cmdLineServer) == null) {
                    throw new Exception("Server '" + cmdLineServer + "' is not found in the file '" + AseConnectionFactory.getIFileName() + "'.");
                }
            }
            if (cmd.hasOption('u')) {
                storeConfigProps.setProperty("cmdLine.sshUsername", cmd.getOptionValue('u'));
            }
            if (cmd.hasOption('p')) {
                storeConfigProps.setProperty("cmdLine.sshPassword", cmd.getOptionValue('p'));
            }
            if (cmd.hasOption('s')) {
                storeConfigProps.setProperty("cmdLine.sshHostname", cmd.getOptionValue('s'));
                storeConfigProps.setProperty("cmdLine.sshPort", 22);
                cmdLineHostname = cmd.getOptionValue('s');
                if (cmdLineHostname.indexOf(":") >= 0) {
                    sa = cmdLineHostname.split(":");
                    storeConfigProps.setProperty("cmdLine.sshHostname", sa[0]);
                    storeConfigProps.setProperty("cmdLine.sshPort", Integer.parseInt(sa[1]));
                }
            }
        } else {
            if (new File(noGuiConfigFile).exists()) {
                storeConfigProps.load(noGuiConfigFile);
            } else if (GetCountersNoGui.checkValidCmShortcuts(noGuiConfigFile)) {
                storeConfigProps.setProperty("cmdLine.cmOptions", noGuiConfigFile);
            } else {
                throw new FileNotFoundException("The noGuiConfig file '" + noGuiConfigFile + "' doesn't exists.");
            }
            if (cmd.hasOption('U')) {
                storeConfigProps.setProperty("conn.aseUsername", cmd.getOptionValue('U'));
            }
            if (cmd.hasOption('P')) {
                storeConfigProps.setProperty("conn.asePassword", cmd.getOptionValue('P'));
            }
            if (cmd.hasOption('S')) {
                storeConfigProps.setProperty("conn.aseName", cmd.getOptionValue('S'));
            }
            if (cmd.hasOption('u')) {
                storeConfigProps.setProperty("conn.sshUsername", cmd.getOptionValue('u'));
            }
            if (cmd.hasOption('p')) {
                storeConfigProps.setProperty("conn.sshPassword", cmd.getOptionValue('p'));
            }
            if (cmd.hasOption('s')) {
                storeConfigProps.setProperty("conn.sshHostname", cmd.getOptionValue('s'));
                storeConfigProps.setProperty("conn.sshPort", 22);
                cmdLineHostname = cmd.getOptionValue('s');
                if (cmdLineHostname.indexOf(":") >= 0) {
                    sa = cmdLineHostname.split(":");
                    storeConfigProps.setProperty("conn.sshHostname", sa[0]);
                    storeConfigProps.setProperty("conn.sshPort", Integer.parseInt(sa[1]));
                }
            }
            if (cmd.hasOption('r')) {
                storeConfigProps.setProperty("offline.configuration.fix", true);
            }
            if (cmd.hasOption('i')) {
                storeConfigProps.setProperty("offline.sampleTime", cmd.getOptionValue('i'));
            }
            if (cmd.hasOption('f')) {
                storeConfigProps.setProperty("offline.shutdownAfterXHours", cmd.getOptionValue('f'));
            }
            if (cmd.hasOption('D') && !cmd.hasOption('d')) {
                throw new Exception("If you use switch '-D|--dbtype' you must also use switch '-d|--dbname'.");
            }
            if (cmd.hasOption('d')) {
                String opt = cmd.getOptionValue('d');
                _logger.info((Object)("Command Line Option '-d|--dbname' was specified, dbname to use is '" + opt + "'."));
                String opt_D = "H2";
                if (cmd.hasOption('D')) {
                    opt_D = cmd.getOptionValue('D').toUpperCase();
                    _logger.info((Object)("Command Line Option '-D|--dbtype' was specified, type to use is '" + opt_D + "'."));
                } else {
                    opt_D = "H2";
                    _logger.info((Object)"Command Line Option '-D|--dbtype' was NOT specified, using the default 'H2'.");
                }
                if (opt_D.equals("H2")) {
                    String jdbcDriver = "org.h2.Driver";
                    String jdbcUrl = "jdbc:h2:file:" + opt;
                    String jdbcUser = "sa";
                    String jdbcPasswd = "";
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcDriver", jdbcDriver);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUrl", jdbcUrl);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUser", jdbcUser);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcPasswd", jdbcPasswd);
                    storeConfigProps.setProperty("PersistWriterJdbc.startH2NetworkServer", true);
                    storeConfigProps.setProperty("PersistentCounterHandler.WriterClass", "asemon.pcs.PersistWriterJdbc");
                    _logger.info((Object)("PCS: using jdbcDriver='" + jdbcDriver + "', jdbcUrl='" + jdbcUrl + "', jdbcUser='" + jdbcUser + "', jdbcPasswd='*secret*', startH2NetworkServer=true."));
                } else if (opt_D.equals("ASE")) {
                    String[] strArr = opt.split(":");
                    if (strArr.length != 5) {
                        throw new Exception("Wrong format of '-d|-dbname' for type 'ASE', this should look like 'hostname:port:dbname:user:passwd' ");
                    }
                    String aseHost = strArr[0];
                    String asePort = strArr[1];
                    String aseDbname = strArr[2];
                    String aseUser = strArr[3];
                    String asePasswd = strArr[4];
                    if (asePasswd.trim().equalsIgnoreCase("null")) {
                        asePasswd = "";
                    }
                    String urlOptions = "?APPLICATIONNAME=AseMon-Writer&HOSTNAME=2.1.0.4.dev&DYNAMIC_PREPARE=true&SQLINITSTRING=set statement_cache off";
                    String jdbcDriver = AseConnectionFactory.getDriver();
                    String jdbcUrl = "jdbc:sybase:Tds:" + aseHost + ":" + asePort + "/" + aseDbname + urlOptions;
                    String jdbcUser = aseUser;
                    String jdbcPasswd = asePasswd;
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcDriver", jdbcDriver);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUrl", jdbcUrl);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUser", jdbcUser);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcPasswd", jdbcPasswd);
                    storeConfigProps.setProperty("PersistentCounterHandler.WriterClass", "asemon.pcs.PersistWriterJdbc");
                    _logger.info((Object)("PCS: using jdbcDriver='" + jdbcDriver + "', jdbcUrl='" + jdbcUrl + "', jdbcUser='" + jdbcUser + "', jdbcPasswd='*secret*', dbname='" + aseDbname + "'."));
                } else if (opt_D.equals("ASA")) {
                    String asaPasswd;
                    String[] strArr = opt.split(":");
                    String asaHost = strArr.length >= 1 ? strArr[0] : "localhost";
                    String asaPort = strArr.length >= 2 ? strArr[1] : "2638";
                    String asaDbname = strArr.length >= 3 ? strArr[2] : "";
                    String asaUser = strArr.length >= 4 ? strArr[3] : "dba";
                    String string = asaPasswd = strArr.length >= 5 ? strArr[4] : "sql";
                    if (asaPasswd.trim().equalsIgnoreCase("null")) {
                        asaPasswd = "";
                    }
                    if (!asaDbname.equals("")) {
                        asaDbname = "/" + asaDbname;
                    }
                    String jdbcDriver = AseConnectionFactory.getDriver();
                    String jdbcUrl = "jdbc:sybase:Tds:" + asaHost + ":" + asaPort + asaDbname;
                    String jdbcUser = asaUser;
                    String jdbcPasswd = asaPasswd;
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcDriver", jdbcDriver);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUrl", jdbcUrl);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcUser", jdbcUser);
                    storeConfigProps.setProperty("PersistWriterJdbc.jdbcPasswd", jdbcPasswd);
                    storeConfigProps.setProperty("PersistentCounterHandler.WriterClass", "asemon.pcs.PersistWriterJdbc");
                    _logger.info((Object)("PCS: using jdbcDriver='" + jdbcDriver + "', jdbcUrl='" + jdbcUrl + "', jdbcUser='" + jdbcUser + "', jdbcPasswd='*secret*', dbname='" + asaDbname + "'."));
                } else {
                    throw new Exception("Unknown -D,--dbtype value of '" + opt + "' was specified, known values 'H2|ASE|ASA'.");
                }
            }
        }
        if (_gui) {
            SplashWindow.init(false, 33, 1000L);
            SplashWindow.drawTopRight("Version: " + Version.getVersionStr());
        } else {
            SplashWindow.close();
        }
        if (_gui) {
            Logging.init(null, propFile);
        } else {
            Logging.init("nogui.", propFile);
        }
        if (_gui && !SplashWindow.isOk()) {
            _logger.info((Object)"Splash screen could not be displayed.");
        }
        SplashWindow.drawProgress("Initializing.");
        System.setProperty("h2.lobInDatabase", "true");
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (httpProxyHost == null) {
            httpProxyHost = asemonSaveProps.getProperty("http.proxyHost");
        }
        if (httpProxyPort == null) {
            httpProxyPort = asemonSaveProps.getProperty("http.proxyPort");
        }
        if (httpProxyHost != null) {
            System.setProperty("http.proxyHost", httpProxyHost);
        }
        if (httpProxyPort != null) {
            System.setProperty("http.proxyPort", httpProxyPort);
        }
        _logger.debug((Object)("Using proxy settings: http.proxyHost='" + httpProxyHost + "', http.proxyPort='" + httpProxyPort + "'."));
        SplashWindow.drawProgress("Initializing..");
        CheckForUpdates.init();
        SplashWindow.drawProgress("Initializing...");
        if (_gui) {
            GuiLogAppender.getInstance();
            ToolTipManager.sharedInstance().setDismissDelay(120000);
        }
        SplashWindow.drawProgress("Starting " + Version.getAppName() + ", version " + Version.getVersionStr() + ", build " + Version.getBuildStr());
        _logger.info((Object)("Starting " + Version.getAppName() + ", version " + Version.getVersionStr() + ", build " + Version.getBuildStr()));
        _logger.info((Object)("GUI mode " + _gui));
        _logger.info((Object)("Debug Options enabled: " + Debug.getDebugsString()));
        _logger.info((Object)("Using Java Runtime Environment Version: " + System.getProperty("java.version")));
        _logger.info((Object)("Using Java VM Implementation  Version: " + System.getProperty("java.vm.version")));
        _logger.info((Object)("Using Java VM Implementation  Vendor:  " + System.getProperty("java.vm.vendor")));
        _logger.info((Object)("Using Java VM Implementation  Name:    " + System.getProperty("java.vm.name")));
        _logger.info((Object)("Using Java VM Home:    " + System.getProperty("java.home")));
        _logger.info((Object)("Java class format version number: " + System.getProperty("java.class.version")));
        _logger.info((Object)("Java class path: " + System.getProperty("java.class.path")));
        _logger.info((Object)("List of paths to search when loading libraries: " + System.getProperty("java.library.path")));
        _logger.info((Object)("Name of JIT compiler to use: " + System.getProperty("java.compiler")));
        _logger.info((Object)("Path of extension directory or directories: " + System.getProperty("java.ext.dirs")));
        _logger.info((Object)("Maximum memory is set to:  " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB. this could be changed with  -Xmx###m (where ### is number of MB)"));
        _logger.info((Object)("Running on Operating System Name:  " + System.getProperty("os.name")));
        _logger.info((Object)("Running on Operating System Version:  " + System.getProperty("os.version")));
        _logger.info((Object)("Running on Operating System Architecture:  " + System.getProperty("os.arch")));
        _logger.info((Object)("The application was started by the username:  " + System.getProperty("user.name")));
        _logger.info((Object)("The application was started in the directory:   " + System.getProperty("user.dir")));
        _logger.info((Object)("System configuration file is '" + propFile + "'."));
        _logger.info((Object)("User configuration file is '" + userPropFile + "'."));
        _logger.info((Object)("Storing temporary configurations in file '" + tmpPropFile + "'."));
        _logger.info((Object)("Combined Configuration Search Order '" + StringUtil.toCommaStr(Configuration.getSearchOrder()) + "'."));
        String needMemInMBStr = "32";
        int maxConfigMemInMB = (int)Runtime.getRuntime().maxMemory() / 1024 / 1024;
        int needMemInMB = Integer.parseInt(asemonProps.getProperty("minMemoryLimitInMB", needMemInMBStr));
        if (maxConfigMemInMB < needMemInMB) {
            String message = "I need at least " + needMemInMB + " MB to start this process. Maximum memory limit is now configured to " + maxConfigMemInMB + " MB. Specify this at the JVM startup using the -Xmx###m flag. ### is the upper limit (in MB) that this JVM could use.";
            _logger.error((Object)message);
            throw new Exception(message);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        _logger.info((Object)("This DEVELOPMENT VERSION will NOT work after '" + df.format(Version.DEV_VERSION_EXPIRE_DATE) + "', then you will have to download a later version.."));
        if (System.currentTimeMillis() > Version.DEV_VERSION_EXPIRE_DATE.getTime()) {
            _hasDevVersionExpired = true;
            String msg = "This DEVELOPMENT VERSION has expired. The \"time to live\" period ended at '" + df.format(Version.DEV_VERSION_EXPIRE_DATE) + "'. A new version can be downloaded here 'http://www.asemon.se'";
            _logger.error((Object)msg);
            Exception ex = new Exception(msg);
            if (_gui) {
                SwingUtils.showErrorMessage("AseMon - This DEVELOPMENT VERSION has expired", "This DEVELOPMENT VERSION has expired.\n\nThe \"time to live\" period ended at '" + df.format(Version.DEV_VERSION_EXPIRE_DATE) + "'. \n" + "A new version can be downloaded here 'http://www.asemon.se'\n" + "\n" + "The application will still start\n" + "But it can only read data from Persistent Counter Storage, also called 'offline databases'.\n" + "\n" + "But I strongly encourage you to download the latest release, " + "This 'start' option was implemented as a fail-safe mechanism, and " + "should only be used if the new AseMon version is not capable of reading the " + "old database. In 99.9% the new AseMon version will be able to read " + "Performance Counters stored by a earlier AseMon release.", ex);
            } else {
                throw ex;
            }
        }
        if (!_gui) {
            _logger.info((Object)"Starting asemon in NO-GUI mode, counters will be sampled into a database.");
            getCnt = new GetCountersNoGui();
            getCnt.init();
            getCnt.start();
            _logger.info((Object)"Checking for new release...");
            CheckForUpdates.noBlockCheck(null, false, false);
        } else {
            _logger.info((Object)"Starting asemon in GUI mode.");
            if (Debug.hasDebug(DebugOptions.EDT_HANG)) {
                _logger.info((Object)"Installing a Swing EDT (Event Dispatch Thread) - Hang Monitor, which will write information about long running EDT operations to the AseMon log.");
                EventDispatchThreadHangMonitor.initMonitoring();
            }
            Runnable runGui = new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        _logger.info((Object)("Using Look And Feel named '" + UIManager.getLookAndFeel().getName() + "', classname='" + UIManager.getLookAndFeel().getClass().getName() + "', toString='" + UIManager.getLookAndFeel() + "'."));
                    }
                    catch (Exception e) {
                        _logger.warn((Object)"Problem setting the Look And Feel to 'getSystemLookAndFeelClassName()'.", (Throwable)e);
                    }
                    SwingExceptionHandler.register();
                    SplashWindow.drawProgress("Loading: Main Frame...");
                    MainFrame frame = new MainFrame();
                    SplashWindow.drawProgress("Loading: Counter Models...");
                    try {
                        getCnt = new GetCountersGui();
                        getCnt.init();
                        getCnt.start();
                    }
                    catch (Exception e) {
                        _logger.error((Object)"Problems when initializing/starting the GetCounterGui thread.", (Throwable)e);
                        return;
                    }
                    frame.loadTabOrderAndVisibility();
                    SplashWindow.drawProgress("Checking for new release...");
                    _logger.info((Object)"Checking for new release...");
                    CheckForUpdates.noBlockCheck(frame, false, true);
                    SplashWindow.drawProgress("Loading Main Window...");
                    frame.setVisible(true);
                }
            };
            SplashWindow.drawProgress("Invoking Swing Event Dispatcher Thread...");
            SwingUtilities.invokeLater(runGui);
        }
    }

    public static GetCounters getCounterCollector() {
        if (getCnt == null) {
            throw new RuntimeException("No Counter Collector has not yet been assigned.");
        }
        return getCnt;
    }

    public static boolean hasGUI() {
        return _gui;
    }

    private static void printHelp(Options options, String errorStr) {
        PrintWriter pw = new PrintWriter(System.out);
        if (errorStr != null) {
            pw.println();
            pw.println(errorStr);
            pw.println();
        }
        pw.println("usage: asemon [-C <cfgFile>] [-c <cfgFile>] [-t <filename>] [-h] [-v] ");
        pw.println("              [-U <user>]   [-P <passwd>]    [-S <server>]");
        pw.println("              [-u <ssUser>] [-p <sshPasswd>] [-s <sshHostname>]");
        pw.println("              [-n <cfgFile|cmNames>] [-r] [-l] [-i <seconds>] [-f <hours>]");
        pw.println("              [-d <dbname>] [-D <H2|ASE|ASE>] ");
        pw.println("  ");
        pw.println("options:");
        pw.println("  -C,--config <cfgName>     System Config file");
        pw.println("  -c,--userConfig <cfgName> User Config file, overrides values in System cfg.");
        pw.println("  -t,--tmpConfig <filename> Config file where temporary stuff are stored.");
        pw.println("  -h,--help                 Usage information.");
        pw.println("  -v,--version              Display AseMon and JVM Version.");
        pw.println("  -x,--debug <dbg1,dbg2>    Debug options: a comma separated string");
        pw.println("                            To get available option, do -x list");
        pw.println("  ");
        pw.println("  -U,--user <user>          Username when connecting to server.");
        pw.println("  -P,--passwd <passwd>      Password when connecting to server. null=noPasswd");
        pw.println("  -S,--server <server>      Server to connect to.");
        pw.println("  ");
        pw.println("  -u,--sshUser <user>       SSH Username, used by Host Monitoring subsystem.");
        pw.println("  -p,--sshPasswd <passwd>   SSH Password, used by Host Monitoring subsystem.");
        pw.println("  -s,--sshServer <host>     SSH Hostname, used by Host Monitoring subsystem.");
        pw.println("  ");
        pw.println("  Switches for offline mode:");
        pw.println("  -n,--noGui <cfgFile|cmNames> Do not start with GUI.");
        pw.println("                            instead collect counters to a database.");
        pw.println("                            cfgFile = <a config file for offline sample>");
        pw.println("                                      which can be generated with the wizard.");
        pw.println("                            cmNames = <small|medium|large|all>.");
        pw.println("                                      or a comma separated list on CMNames.");
        pw.println("  -r,--reconfigure          If the monitored ASE is not properly configured,");
        pw.println("                            then try to configure it using predefined values.");
        pw.println("  -l,--listcm               List cm's that can be used in '-n' switch.");
        pw.println("  -i,--interval <seconds>   sample Interval, time between samples.");
        pw.println("  -f,--finish   <hours>     shutdown/stop the no-gui service after # hours.");
        pw.println("  -D,--dbtype <H2|ASE|ASE>  type of database to use as offline store.");
        pw.println("  -d,--dbname <connSpec>    Connection specification to store offline data.");
        pw.println("                            Depends on -D, see below for more info.");
        pw.println("");
        pw.println("If you specify '-D and -d':");
        pw.println("  -D H2  -d h2dbfile");
        pw.println("  -D ASE -d hostname:port:dbname:user:passwd");
        pw.println("  -D ASA -d hostname:port:dbname:user:passwd");
        pw.println("  Default connection specifications for different dbtypes:");
        pw.println("     H2:  'h2dbfile' file is mandatory");
        pw.println("     ASE: 'hostname:port:dbname:user:passwd' is all mandatory.");
        pw.println("     ASA: port=2638, dbname='', user='DBA', passwd='SQL'");
        pw.println("  If only '-d' is given, the default value for '-D' is 'H2'.");
        pw.println("");
        pw.flush();
    }

    private static synchronized Options buildCommandLineOptions() {
        Options options = new Options();
        options.addOption("C", "config", true, "The System Config file");
        options.addOption("c", "userConfig", true, "The User Config file where, overrides values in System Config.");
        options.addOption("t", "tmpConfig", true, "Config file where temporary stuff are stored.");
        options.addOption("h", "help", false, "Usage information.");
        options.addOption("v", "version", false, "Display AseMon and JVM Version.");
        options.addOption("x", "debug", true, "Debug options: a comma separated string dbg1,dbg2,dbg3");
        options.addOption("U", "user", true, "Username when connecting to server.");
        options.addOption("P", "passwd", true, "Password when connecting to server. (null=noPasswd)");
        options.addOption("S", "server", true, "Server to connect to.");
        options.addOption("u", "sshUser", true, "SSH Username when connecting to server for Host Monitoring.");
        options.addOption("p", "sshPasswd", true, "SSH Password when connecting to server for Host Monitoring.");
        options.addOption("s", "sshServer", true, "SSH Hostname to connect to.");
        options.addOption("n", "noGui", true, "Do not start with GUI, instead collect counters to a database <a config file for offline sample>.");
        options.addOption("r", "reconfigure", false, "Offline: if monitored ASE is not properly configured, try to configure it.");
        options.addOption("l", "listcm", false, "Offline: List cm's that can be used in '-n' switch.");
        options.addOption("i", "interval", true, "Offline: Sample Interval, time between samples.");
        options.addOption("D", "dbtype", true, "Offline: {H2|ASE|ASA} database type default is H2.");
        options.addOption("d", "dbname", true, "Offline: dbname/file to store offline samples.");
        options.addOption("f", "finish", true, "Offline: Shutdown the NO-GUI service after # hours");
        return options;
    }

    private static CommandLine parseCommandLine(String[] args, Options options) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (_logger.isDebugEnabled()) {
            for (Option opt : cmd) {
                _logger.debug((Object)("parseCommandLine: swith='" + opt.getOpt() + "', value='" + opt.getValue() + "'."));
            }
        }
        return cmd;
    }

    private static void printTemplate(String templateName) throws Exception {
        List<String> lst = CounterSetTemplates.getTemplateList(templateName);
        System.out.println("======================================================================");
        System.out.println("Template name '" + templateName + "', contains the following counters.");
        System.out.println("Short name           Postpone Long Name");
        System.out.println("-------------------- -------- ----------------------------------------------");
        Iterator<String> i$ = lst.iterator();
        while (i$.hasNext()) {
            String name;
            String cmNameStr;
            String cmName = cmNameStr = i$.next();
            int postponeTime = 0;
            String[] optStr = cmNameStr.split(":");
            if (optStr.length > 1) {
                try {
                    postponeTime = Integer.parseInt(optStr[1]);
                    cmName = optStr[0];
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            String shortName = (name = CounterSetTemplates.getShortName(cmName)) == null ? cmName : name;
            name = CounterSetTemplates.getLongName(cmName);
            String longName = name == null ? cmName : name;
            System.out.println(StringUtil.left(shortName, 20) + " " + StringUtil.left(postponeTime + "", 8) + " " + longName);
        }
        System.out.println();
    }

    public static void main(String[] args) {
        Options options = Asemon.buildCommandLineOptions();
        try {
            CommandLine cmd = Asemon.parseCommandLine(args, options);
            if (cmd.hasOption("help")) {
                Asemon.printHelp(options, "The option '--help' was passed.");
            } else if (cmd.hasOption("version")) {
                System.out.println();
                System.out.println(Version.getAppName() + " Version: " + Version.getVersionStr() + " JVM: " + System.getProperty("java.version"));
                System.out.println();
            } else if (cmd.getArgs() != null && cmd.getArgs().length > 0) {
                String error = "Unknown options: " + StringUtil.toCommaStr(cmd.getArgs());
                Asemon.printHelp(options, error);
            } else {
                new Asemon(cmd);
            }
        }
        catch (ParseException pe) {
            String error = "Error: " + pe.getMessage();
            Asemon.printHelp(options, error);
        }
        catch (NormalExitException e) {
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println("Printing a stacktrace, where the error occurred.");
            System.out.println("--------------------------------------------------------------------");
            e.printStackTrace();
            System.out.println("--------------------------------------------------------------------");
        }
    }
}

