/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.Asemon;
import asemon.MonTablesDictionary;
import asemon.TrendGraphDataPoint;
import asemon.Version;
import asemon.cm.CmSybMessageHandler;
import asemon.cm.CounterModelHostMonitor;
import asemon.cm.CounterTableModel;
import asemon.cm.CountersModel;
import asemon.cm.CountersModelAppend;
import asemon.cm.CountersModelUserDefined;
import asemon.cm.SamplingCnt;
import asemon.cm.sql.VersionInfo;
import asemon.gui.ChangeToJTabDialog;
import asemon.gui.MainFrame;
import asemon.gui.SplashWindow;
import asemon.gui.SummaryPanel;
import asemon.gui.TabularCntrPanel;
import asemon.gui.TrendGraph;
import asemon.hostmon.HostMonitor;
import asemon.hostmon.SshConnection;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;

public abstract class GetCounters
extends Thread {
    private static Logger _logger = Logger.getLogger(GetCounters.class);
    private static GetCounters _instance = null;
    protected Thread _thread = null;
    private static boolean _countersIsCreated = false;
    private static boolean _isInitialized = false;
    private static boolean _refreshIsEnabled = false;
    private static boolean _refreshingCounters = false;
    private static String _waitEvent = "";
    protected static List<CountersModel> _CMList = new ArrayList<CountersModel>();
    public static final String TRANLOG_DISK_IO_TOOLTIP = "Below is a table that describes how a fast or slow disk affects number of transactions per second.<br>The below description tries to exemplify number of transactions per seconds based on Disk IO responsiveness on the <b>LOG</b> Device.<br><TABLE ALIGN='left' BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH='100%'>   <TR ALIGN='left' VALIGN='left'> <TH>Device Type      </TH> <TH>Typical IOPS </TH> <TH>Typical ms/IO</TH> <TH>Xactn/Sec      </TH> </TR>   <!--                                    -----------------          -------------          -------------          --------------- -->  <TR ALIGN='left' VALIGN='left'> <TD>RAID 6           </TD> <TD>600          </TD> <TD>10-25        </TD> <TD>40-100         </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 5           </TD> <TD>800          </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 0 (RAID 10) </TD> <TD>1000         </TD> <TD>1-2          </TD> <TD>500-1000       </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>FC SCSI (tier 1) </TD> <TD>200-400      </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SAS SCSI (tier 2)</TD> <TD>150-200      </TD> <TD>4-8          </TD> <TD>125-250        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA (tier 3)    </TD> <TD>100-150      </TD> <TD>6-10         </TD> <TD>100-166        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA/SAS SSD     </TD> <TD>10000-20000  </TD> <TD>0.05-0.1     </TD> <TD>10,000-20,000  </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>PCIe SSD         </TD> <TD>100000-200000</TD> <TD>0.01-0.005   </TD> <TD>100,000-200,000</TD> </TR> </TABLE> The above table was found in the document: <br> http://www.sybase.com/detail?id=1091630<br>http://www.sybase.com/files/White_Papers/Managing-DBMS-Workloads-v1.0-WP.pdf<br>";
    private Connection _conn = null;
    private long _lastIsClosedCheck = 0L;
    private long _lastIsClosedRefreshTime = 1200L;
    private SshConnection _sshConn = null;
    private long _sshLastIsClosedCheck = 0L;
    private long _sshLastIsClosedRefreshTime = 1200L;

    public static List<CountersModel> getCmList() {
        return _CMList;
    }

    public static List<CountersModel> getCmListUdc() {
        ArrayList<CountersModel> cmList = new ArrayList<CountersModel>();
        for (CountersModel cm : _CMList) {
            if (cm.getName().startsWith("CM")) continue;
            cmList.add(cm);
        }
        return cmList;
    }

    public static List<CountersModel> getCmListSystem() {
        ArrayList<CountersModel> cmList = new ArrayList<CountersModel>();
        for (CountersModel cm : _CMList) {
            if (!cm.getName().startsWith("CM")) continue;
            cmList.add(cm);
        }
        return cmList;
    }

    public static CountersModel getCmByName(String name) {
        for (CountersModel cm : _CMList) {
            if (cm == null || !cm.getName().equalsIgnoreCase(name)) continue;
            return cm;
        }
        return null;
    }

    public static CountersModel getCmByDisplayName(String name) {
        for (CountersModel cm : _CMList) {
            if (cm == null || !cm.getDisplayName().equalsIgnoreCase(name)) continue;
            return cm;
        }
        return null;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static GetCounters getInstance() {
        if (_instance == null) {
            throw new RuntimeException("No GetCounters instance exists.");
        }
        return _instance;
    }

    public static void setInstance(GetCounters cnt) {
        _instance = cnt;
    }

    public abstract void init() throws Exception;

    @Override
    public abstract void run();

    public static void setWaitEvent(String str) {
        _waitEvent = str;
    }

    public static String getWaitEvent() {
        return _waitEvent;
    }

    public boolean isInitialized() {
        return _isInitialized;
    }

    public void initCounters(Connection conn, boolean hasGui, int aseVersion, boolean isClusterEnabled, int monTablesVersion) throws Exception {
        if (_isInitialized) {
            return;
        }
        if (!AseConnectionUtils.isConnectionOk(conn, hasGui, null)) {
            throw new Exception("Trying to initialize the counters with a connection this seems to be broken.");
        }
        if (!_countersIsCreated) {
            this.createCounters();
        }
        _logger.info((Object)("Initializing all CM objects, using ASE server version number " + aseVersion + ", isClusterEnabled=" + isClusterEnabled + " with monTables Install version " + monTablesVersion + "."));
        List<String> activeRoleList = AseConnectionUtils.getActiveRoles(conn);
        Map<String, Integer> monitorConfigMap = AseConnectionUtils.getMonitorConfigs(conn);
        if (aseVersion >= 15031) {
            AseConnectionUtils.setCompatibilityMode(conn, false);
        }
        for (CountersModel cm : _CMList) {
            if (cm == null) continue;
            _logger.debug((Object)("Initializing CM named '" + cm.getName() + "', display name '" + cm.getDisplayName() + "', using ASE server version number " + aseVersion + "."));
            cm.setServerVersion(aseVersion);
            cm.setClusterEnabled(isClusterEnabled);
            cm.setActiveRoles(activeRoleList);
            cm.setMonitorConfigs(monitorConfigMap);
            cm.setRuntimeInitialized(true);
            cm.initSql(conn);
            cm.init(conn);
        }
        if (isClusterEnabled) {
            int systemView = 0;
            if (Asemon.hasGUI()) {
                systemView = SummaryPanel.getInstance().getClusterView();
            } else {
                String clusterView = "cluster";
                Configuration conf = Configuration.getInstance("PCS");
                if (conf != null) {
                    clusterView = conf.getProperty("cluster.system_view", clusterView);
                }
                systemView = clusterView.equalsIgnoreCase("instance") ? 2 : 1;
            }
            AseConnectionUtils.setClusterEditionSystemView(conn, systemView);
        }
        _isInitialized = true;
    }

    public void checkForFullTransLogInMaster(Connection conn) {
        try {
            int aseVersion = 0;
            if (MonTablesDictionary.getInstance() != null) {
                aseVersion = MonTablesDictionary.getInstance().aseVersionNum;
            }
            if (aseVersion >= 15031 && aseVersion < 16000) {
                _logger.debug((Object)"Checking for full transaction log in the master database.");
                String sql = "select 'isLoggFull' = lct_admin('logfull', db_id('master')),       'spaceLeft'  = lct_admin('logsegment_freepages', db_id('master'))                     - lct_admin('reserve', 0)                     - lct_admin('reserved_for_rollbacks', db_id('master'), 0)                     - @@thresh_hysteresis";
                int isLogFull = 0;
                int spaceLeft = 0;
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    isLogFull = rs.getInt(1);
                    spaceLeft = rs.getInt(2);
                }
                rs.close();
                stmt.close();
                _logger.debug((Object)("Checking for full transaction log in the master database. Results: isLogFull='" + isLogFull + "', spaceLeft='" + spaceLeft + "'."));
                if (isLogFull > 0 || spaceLeft <= 20) {
                    _logger.warn((Object)("Truncating the transaction log in the master database. Issuing SQL 'dump tran master with truncate_only'. isLogFull='" + isLogFull + "', spaceLeft='" + spaceLeft + "'."));
                    stmt = conn.createStatement();
                    stmt.execute("dump tran master with truncate_only");
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            _logger.warn((Object)"When checking for a full transaction log in master, we got problem, but skipping this problem and continuing.", (Throwable)e);
        }
    }

    public void createCounters() {
        TabularCntrPanel tcp;
        String finalDisplayName;
        TrendGraph tg;
        TabularCntrPanel tcp2;
        if (_countersIsCreated) {
            return;
        }
        _logger.info((Object)"Creating ALL CM Objects.");
        String colorStr = null;
        Configuration conf = Configuration.getCombinedConfiguration();
        CountersModel tmp = null;
        int needVersion = 0;
        int needCeVersion = 0;
        String name = "CMsummary";
        String displayName = "Summary";
        String description = "Overview of how the system performs.";
        SplashWindow.drawProgress("Loading: Counter Model 'CMsummary'");
        needVersion = 0;
        needCeVersion = 0;
        String[] monTables = new String[]{"monState"};
        String[] needRole = new String[]{"mon_role"};
        String[] needConfig = new String[]{};
        String[] colsCalcDiff = new String[]{"LockWaits", "CheckPoints", "NumDeadlocks", "Connections", "Transactions", "cpu_busy", "cpu_io", "cpu_idle", "io_total_read", "io_total_write", "aaConnections", "distinctLogins", "pack_received", "pack_sent", "packet_errors", "total_errors"};
        String[] colsCalcPCT = new String[]{};
        LinkedList<String> pkList = new LinkedList<String>();
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -4476798027541082165L;

            @Override
            public boolean isRefreshable() {
                return true;
            }

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String nwAddrInfo = "'no sa_role'";
                if (this.isRoleActive("sa_role")) {
                    nwAddrInfo = "'" + AseConnectionUtils.getListeners(conn, false, true, MainFrame.getInstance()) + "'";
                }
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                cols1 = "*";
                if (this.isClusterEnabled()) {
                    cols1 = "";
                    cols1 = cols1 + "  LockWaitThreshold   = max(LockWaitThreshold) \n";
                    cols1 = cols1 + ", LockWaits           = sum(LockWaits) \n";
                    cols1 = cols1 + ", DaysRunning         = max(DaysRunning) \n";
                    cols1 = cols1 + ", CheckPoints         = sum(CheckPoints) \n";
                    cols1 = cols1 + ", NumDeadlocks        = sum(NumDeadlocks) \n";
                    cols1 = cols1 + ", DiagnosticDumps     = sum(DiagnosticDumps) \n";
                    cols1 = cols1 + ", Connections         = sum(Connections) \n";
                    cols1 = cols1 + ", MaxRecovery         = avg(MaxRecovery) \n";
                    cols1 = cols1 + ", Transactions        = sum(Transactions) \n";
                    cols1 = cols1 + ", StartDate           = min(StartDate) \n";
                    cols1 = cols1 + ", CountersCleared     = max(CountersCleared) \n";
                }
                cols2 = ", aseVersion         = @@version, atAtServerName     = @@servername, clusterInstanceId  = " + (this.isClusterEnabled() ? "convert(varchar(15),@@instanceid)" : "'Not Enabled'") + ", clusterCoordId     = " + (this.isClusterEnabled() ? "convert(varchar(3), @@clustercoordid)" : "'Not Enabled'") + ", timeIsNow          = getdate()" + ", NetworkAddressInfo = " + nwAddrInfo + ", bootcount          = @@bootcount" + ", recovery_state     = " + (aseVersion >= 12510 ? "@@recovery_state" : "'Introduced in ASE 12.5.1'") + ", cpu_busy           = @@cpu_busy" + ", cpu_io             = @@io_busy" + ", cpu_idle           = @@idle" + ", io_total_read      = @@total_read" + ", io_total_write     = @@total_write" + ", aaConnections      = @@connections" + ", distinctLogins     = (select count(distinct suid) from sysprocesses)" + ", fullTranslogCount  = (select sum(lct_admin('logfull', dbid)) from sysdatabases where (status & 32 != 32) and (status & 256 != 256))" + ", pack_received      = @@pack_received" + ", pack_sent          = @@pack_sent" + ", packet_errors      = @@packet_errors" + ", total_errors       = @@total_errors" + "";
                cols3 = "";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monState A \n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                Double[] arr;
                int aseVersion = this.getServerVersion();
                if ("aaCpuGraph".equals(tgdp.getName())) {
                    Double cpuUser = this.getDiffValueAsDouble(0, "cpu_busy");
                    Double cpuSystem = this.getDiffValueAsDouble(0, "cpu_io");
                    Double cpuIdle = this.getDiffValueAsDouble(0, "cpu_idle");
                    if (cpuUser != null && cpuSystem != null && cpuIdle != null) {
                        double CPUTime = cpuUser + cpuSystem + cpuIdle;
                        double CPUUser = cpuUser;
                        double CPUSystem = cpuSystem;
                        BigDecimal calcCPUTime = new BigDecimal(1.0 * (CPUUser + CPUSystem) / CPUTime * 100.0).setScale(1, 6);
                        BigDecimal calcUserCPUTime = new BigDecimal(1.0 * CPUUser / CPUTime * 100.0).setScale(1, 6);
                        BigDecimal calcSystemCPUTime = new BigDecimal(1.0 * CPUSystem / CPUTime * 100.0).setScale(1, 6);
                        Double[] arr2 = new Double[]{calcCPUTime.doubleValue(), calcSystemCPUTime.doubleValue(), calcUserCPUTime.doubleValue()};
                        _logger.debug((Object)("updateGraphData(aaCpuGraph): @@cpu_busy+@@cpu_io='" + arr2[0] + "', @@cpu_io='" + arr2[1] + "', @@cpu_busy='" + arr2[2] + "'."));
                        tgdp.setDate(this.getTimestamp());
                        tgdp.setData(arr2);
                    }
                }
                if ("TransGraph".equals(tgdp.getName())) {
                    if (aseVersion < 15033) {
                        JCheckBoxMenuItem menuItem;
                        TrendGraph tg = this.getTrendGraph("TransGraph");
                        if (tg != null && (menuItem = tg.getViewMenuItem()).isSelected()) {
                            menuItem.doClick();
                        }
                    } else {
                        arr = new Double[]{this.getRateValueSum("Transactions")};
                        _logger.debug((Object)("updateGraphData(TransGraph): Transactions='" + arr[0] + "'."));
                        tgdp.setDate(this.getTimestamp());
                        tgdp.setData(arr);
                    }
                }
                if ("ConnectionsGraph".equals(tgdp.getName())) {
                    arr = new Double[]{this.getAbsValueAsDouble(0, "Connections"), this.getAbsValueAsDouble(0, "distinctLogins"), this.getDiffValueAsDouble(0, "aaConnections")};
                    _logger.debug((Object)("updateGraphData(ConnectionsGraph): Connections='" + arr[0] + "', distinctLogins='" + arr[1] + "', aaConnections='" + arr[2] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
                if ("aaReadWriteGraph".equals(tgdp.getName())) {
                    arr = new Double[]{this.getRateValueAsDouble(0, "io_total_read"), this.getRateValueAsDouble(0, "io_total_write")};
                    _logger.debug((Object)("updateGraphData(aaReadWriteGraph): io_total_read='" + arr[0] + "', io_total_write='" + arr[1] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
                if ("aaPacketGraph".equals(tgdp.getName())) {
                    arr = new Double[]{this.getRateValueAsDouble(0, "pack_received"), this.getRateValueAsDouble(0, "pack_sent"), this.getRateValueAsDouble(0, "packet_errors")};
                    _logger.debug((Object)("updateGraphData(aaPacketGraph): packet_errors='" + arr[0] + "', total_errors='" + arr[1] + "', packet_errors='" + arr[2] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.setTabPanel(null);
        tmp.addTrendGraphData("aaCpuGraph", new TrendGraphDataPoint("aaCpuGraph", new String[]{"System+User CPU (@@cpu_busy + @@cpu_io)", "System CPU (@@cpu_io)", "User CPU (@@cpu_busy)"}));
        tmp.addTrendGraphData("TransGraph", new TrendGraphDataPoint("TransGraph", new String[]{"Transactions"}));
        tmp.addTrendGraphData("ConnectionsGraph", new TrendGraphDataPoint("ConnectionsGraph", new String[]{"UserConnections", "distinctLogins", "@@connections"}));
        tmp.addTrendGraphData("aaReadWriteGraph", new TrendGraphDataPoint("aaReadWriteGraph", new String[]{"@@total_read", "@@total_write"}));
        tmp.addTrendGraphData("aaPacketGraph", new TrendGraphDataPoint("aaPacketGraph", new String[]{"@@pack_received", "@@pack_sent", "@@packet_errors"}));
        if (Asemon.hasGUI()) {
            tmp.addTableModelListener(MainFrame.getSummaryPanel());
            TrendGraph tg2 = null;
            tg2 = new TrendGraph("aaCpuGraph", "CPU Summary, Global Variables", "CPU Summary for all Engines (using @@cpu_busy, @@cpu_io)", new String[]{"System+User CPU (@@cpu_busy + @@cpu_io)", "System CPU (@@cpu_io)", "User CPU (@@cpu_busy)"}, true, tmp, false, -1);
            tmp.addTrendGraph(tg2.getName(), tg2, true);
            tg2 = new TrendGraph("TransGraph", "Transaction per second", "Number of Transaction per Second (only in 15.0.3 esd#3 and later)", new String[]{"Transactions"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg2.getName(), tg2, true);
            tg2 = new TrendGraph("ConnectionsGraph", "Connections/Users in ASE", "Connections/Users connected to the ASE", new String[]{"UserConnections", "distinctLogins", "@@connections"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg2.getName(), tg2, true);
            tg2 = new TrendGraph("aaReadWriteGraph", "Disk read/write, Global Variables", "Disk read/write per second, using @@total_read, @@total_write", new String[]{"@@total_read", "@@total_write"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg2.getName(), tg2, true);
            tg2 = new TrendGraph("aaPacketGraph", "Network Packets received/sent, Global Variables", "Network Packets received/sent per second, using @@pack_received, @@pack_sent", new String[]{"@@pack_received", "@@pack_sent", "@@packet_errors"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg2.getName(), tg2, true);
        }
        _CMList.add(tmp);
        name = "CMobjActivity";
        displayName = "Objects";
        description = "Performance information about object/tables.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monOpenObjectActivity"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "object lockwait timing=1", "per object statistics active=1"};
        colsCalcDiff = new String[]{"LogicalReads", "PhysicalReads", "APFReads", "PagesRead", "PhysicalWrites", "PagesWritten", "UsedCount", "RowsInsUpdDel", "RowsInserted", "RowsDeleted", "RowsUpdated", "Operations", "LockRequests", "LockWaits", "HkgcRequests", "HkgcPending", "HkgcOverflows", "OptSelectCount", "PhysicalLocks", "PhysicalLocksRetained", "PhysicalLocksRetainWaited", "PhysicalLocksDeadlocks", "PhysicalLocksWaited", "PhysicalLocksPageTransfer", "TransferReqWaited", "TotalServiceRequests", "PhysicalLocksDowngraded", "PagesTransferred", "ClusterPageWrites"};
        colsCalcPCT = new String[]{"LockContPct"};
        pkList = new LinkedList();
        pkList.add("DBName");
        pkList.add("ObjectName");
        pkList.add("IndexID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 6315460036795875430L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monOpenObjectActivity", "LockContPct", "<html>How many Lock Requests in percent was Blocked by another concurrent SPID's due to incompatible locking issues.<br><b>Note</b>: Do also considder number of LockWaits and not only the percentage.<br><b>Formula</b>: LockWaits / LockRequests * 100.0<br></html>");
                    mtd.addColumn("monOpenObjectActivity", "TabRowCount", "<html>Table rowcount, using row_count(DBID, ObjectID) to get the count, so it can be a bit off from the actual number of rows.<br>Note: If this takes to much resources, it can be disable in any of the configuration files using <code>CMobjActivity.TabRowCount=false</code>.</html>");
                    mtd.addColumn("monOpenObjectActivity", "RowsInsUpdDel", "<html>RowsInsUpdDel = RowsInserted + RowsDeleted + RowsUpdated<br>So this is simply a summary of all DML changes on this table.</html>");
                    mtd.addColumn("monOpenObjectActivity", "PhysicalLocksRetained", "<html>Number of physical locks retained. <br>You can use this to identify the lock hit ratio for each object. <br>Good hit ratios imply balanced partitioning for this object.</html>");
                    mtd.addColumn("monOpenObjectActivity", "PhysicalLocksDeadlocks", "<html>Number of times a physical lock requested returned a deadlock. <br>The Cluster Physical Locks subsection of sp_sysmon uses this counter to report deadlocks while acquiring physical locks for each object.</html>");
                    mtd.addColumn("monOpenObjectActivity", "PhysicalLocksPageTransfer", "<html>Number of page transfers that occurred when an instance requests a physical lock. <br>The Cluster Physical Locks subsection of sp_sysmon uses this counter to report the node-to-node transfer and physical-lock acquisition as a node affinity ratio for this object.</html>");
                    mtd.addColumn("monOpenObjectActivity", "TransferReqWaited", "<html>Number of times physical lock requests waiting before receiving page transfers.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgPhysicalLockWaitTime", "<html>The average amount of time clients spend before the physical lock is granted.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgTransferReqWaitTime", "<html>The average amount of time physical lock requests wait before receiving page transfers.</html>");
                    mtd.addColumn("monOpenObjectActivity", "TotalServiceRequests", "<html>Number of physical lock requests serviced by the Cluster Cache Manager of an instance.</html>");
                    mtd.addColumn("monOpenObjectActivity", "PhysicalLocksDowngraded", "<html>Number of physical lock downgrade requests serviced by the Cluster Cache Manager of an instance.</html>");
                    mtd.addColumn("monOpenObjectActivity", "PagesTransferred", "<html>Number of pages transferred at an instance by the Cluster Cache Manager.</html>");
                    mtd.addColumn("monOpenObjectActivity", "ClusterPageWrites", "<html>Number of pages written to disk by the Cluster Cache Manager of an instance.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgServiceTime", "<html>The average amount of service time spent by the Cluster Cache Manager of an instance.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgTimeWaitedOnLocalUsers", "<html>The average amount of service time an instance\u2019s Cluster Cache Manager waits due to page use by users on this instance.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgTransferSendWaitTime", "<html>The average amount of service time an instance\u2019s Cluster Cache Manager spends for page transfer.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgIOServiceTime", "<html>The average amount of service time used by an instance\u2019s Cluster Cache Manager for page transfer.</html>");
                    mtd.addColumn("monOpenObjectActivity", "AvgDowngradeServiceTime", "<html>The average amount of service time the Cluster Cache Manager uses to downgrade physical locks.</html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                String tabRowCount = "";
                String dbNameCol = "DBName=db_name(A.DBID)";
                String objNameCol = "ObjectName=isnull(object_name(A.ObjectID, A.DBID), 'ObjId='+convert(varchar(30),A.ObjectID))";
                if (aseVersion >= 15000) {
                    tabRowCount = "TabRowCount = convert(bigint,row_count(A.DBID, A.ObjectID)), \n";
                    dbNameCol = "DBName";
                    objNameCol = "ObjectName";
                    objNameCol = "ObjectName=isnull(object_name(A.ObjectID, A.DBID), 'ObjId='+convert(varchar(30),A.ObjectID))";
                    Configuration conf = Configuration.getCombinedConfiguration();
                    if (conf.getBooleanProperty("CMobjActivity.ObjectName", false)) {
                        objNameCol = "ObjectName";
                        _logger.info((Object)("CMobjActivity.ObjectName=true, using the string '" + objNameCol + "' for ObjectName lookup."));
                    }
                    if (!conf.getBooleanProperty("CMobjActivity.TabRowCount", true)) {
                        tabRowCount = "";
                        _logger.info((Object)"CMobjActivity.TabRowCount=false, Disabling the column 'TabRowCount'.");
                    }
                }
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + dbNameCol + ", \n" + objNameCol + ", \n" + "A.IndexID, \n" + "LockScheme = lockscheme(A.ObjectID, A.DBID), \n" + "LockRequests=isnull(LockRequests,0), LockWaits=isnull(LockWaits,0), \n" + "LockContPct = CASE WHEN isnull(LockRequests,0) > 0 \n" + "                   THEN convert(numeric(10,1), ((LockWaits+0.0)/(LockRequests+0.0)) * 100.0) \n" + "                   ELSE convert(numeric(10,1), 0.0) \n" + "              END, \n" + "LogicalReads, PhysicalReads, APFReads, PagesRead, \n" + "PhysicalWrites, PagesWritten, UsedCount, Operations, \n" + tabRowCount + "RowsInsUpdDel=RowsInserted+RowsDeleted+RowsUpdated, \n" + "RowsInserted, RowsDeleted, RowsUpdated, OptSelectCount, \n";
                cols2 = cols2 + "";
                cols3 = cols3 + "LastOptSelectDate, LastUsedDate \n";
                if (aseVersion >= 15020) {
                    cols2 = cols2 + "HkgcRequests, HkgcPending, HkgcOverflows, \n";
                }
                if (aseVersion >= 15030 && this.isClusterEnabled()) {
                    cols2 = cols2 + "PhysicalLocks, PhysicalLocksRetained, PhysicalLocksRetainWaited, \n";
                    cols2 = cols2 + "PhysicalLocksDeadlocks, PhysicalLocksWaited, PhysicalLocksPageTransfer, \n";
                    cols2 = cols2 + "TransferReqWaited, \n";
                    cols2 = cols2 + "AvgPhysicalLockWaitTime, AvgTransferReqWaitTime, \n";
                    cols2 = cols2 + "TotalServiceRequests, \n";
                    cols2 = cols2 + "PhysicalLocksDowngraded, \n";
                    cols2 = cols2 + "PagesTransferred, \n";
                    cols2 = cols2 + "ClusterPageWrites, \n";
                    cols2 = cols2 + "AvgServiceTime, AvgTimeWaitedOnLocalUsers, AvgTransferSendWaitTime, \n";
                    cols2 = cols2 + "AvgIOServiceTime, AvgDowngradeServiceTime, \n";
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monOpenObjectActivity A \n" + "where UsedCount > 0 OR LockRequests > 0 OR LogicalReads > 100 \n" + (this.isClusterEnabled() ? "order by 2,3,4" : "order by 1,2,3") + "\n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int LockContPctId = -1;
                int LockRequestsId = -1;
                int LockWaitsId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("LockRequests")) {
                        LockRequestsId = colId;
                    } else if (colName.equals("LockWaits")) {
                        LockWaitsId = colId;
                    } else if (colName.equals("LockContPct")) {
                        LockContPctId = colId;
                    }
                    if (LockRequestsId >= 0 && LockWaitsId >= 0 && LockContPctId >= 0) break;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int LockRequests = ((Number)diffData.getValueAt(rowId, LockRequestsId)).intValue();
                    int LockWaits = ((Number)diffData.getValueAt(rowId, LockWaitsId)).intValue();
                    int colPos = LockContPctId;
                    if (LockRequests > 0) {
                        double calc = ((double)LockWaits + 0.0) / ((double)LockRequests + 0.0) * 100.0;
                        BigDecimal newVal = new BigDecimal(calc).setScale(2, 6);
                        diffData.setValueAt(newVal, rowId, colPos);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0).setScale(2, 6), rowId, colPos);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_object_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>ORANGE - An Index.</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.index");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number indexId = (Number)adapter.getValue(adapter.getColumnIndex((Object)"IndexID"));
                    return indexId != null && indexId.intValue() > 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.ORANGE), null));
        }
        _CMList.add(tmp);
        name = "CMprocActivity";
        displayName = "Processes";
        description = "<html><p>What SybasePIDs are doing what.</p>Tip:<br>sort by 'BatchIdDiff', will give you the one that executes the most SQL Batches.<br>Or check 'WaitEventDesc' to find out when the SPID is waiting for.</html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monProcessActivity", "monProcess", "sysprocesses", "monProcessNetIO"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "object lockwait timing=1", "wait event timing=1"};
        colsCalcDiff = new String[]{"BatchIdDiff", "cpu", "physical_io", "CPUTime", "WaitTime", "LogicalReads", "PhysicalReads", "PagesRead", "PhysicalWrites", "PagesWritten", "TableAccesses", "IndexAccesses", "TempDbObjects", "ULCBytesWritten", "ULCFlushes", "ULCFlushFull", "Transactions", "Commits", "Rollbacks", "PacketsSent", "PacketsReceived", "BytesSent", "BytesReceived", "WorkTables", "pssinfo_tempdb_pages"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("SPID");
        pkList.add("KPID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 161126670167334279L;
            private HashMap<Number, Object> _blockingSpids;
            {
                this._blockingSpids = new HashMap();
            }

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                String optGoalPlan = "";
                if (aseVersion >= 15020) {
                    optGoalPlan = "plan '(use optgoal allrows_dss)' \n";
                }
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "MP.InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + " MP.FamilyID, MP.SPID, MP.KPID, MP.NumChildren, \n  SP.status, MP.WaitEventID, \n  WaitClassDesc=convert(varchar(50),''),   WaitEventDesc=convert(varchar(50),''),   MP.SecondsWaiting, MP.BlockingSPID, MP.Command, \n  MP.BatchID, BatchIdDiff=convert(int,MP.BatchID), \n  procName = object_name(SP.id, SP.dbid), SP.stmtnum, SP.linenum, \n  MP.Application, SP.clientname, SP.clienthostname, SP.clientapplname,   SP.hostname, SP.ipaddr, SP.hostprocess, \n  MP.DBName, MP.Login, SP.suid, MP.SecondsConnected, \n  SP.tran_name, SP.cpu, SP.physical_io, \n  A.CPUTime, A.WaitTime, A.LogicalReads, \n  A.PhysicalReads, A.PagesRead, A.PhysicalWrites, A.PagesWritten, \n";
                cols2 = cols2 + "";
                if (aseVersion >= 12520) {
                    cols2 = cols2 + "  A.WorkTables,  \n";
                }
                if (aseVersion >= 15020 || aseVersion >= 12540 && aseVersion <= 15000) {
                    cols2 = cols2 + "  tempdb_name = db_name(tempdb_id(SP.spid)), pssinfo_tempdb_pages = convert(int, pssinfo(SP.spid, 'tempdb_pages')), \n";
                }
                if (aseVersion >= 15025) {
                    cols2 = cols2 + "  N.NetworkEngineNumber, MP.ServerUserID, \n";
                }
                cols3 = cols3 + " A.TableAccesses, A.IndexAccesses, A.TempDbObjects, \n  A.ULCBytesWritten, A.ULCFlushes, A.ULCFlushFull, \n  A.Transactions, A.Commits, A.Rollbacks, \n  MP.EngineNumber, MP.Priority, \n  N.PacketsSent, N.PacketsReceived, N.BytesSent, N.BytesReceived, \n  MP.ExecutionClass, MP.EngineGroupName";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcessActivity A, monProcess MP, sysprocesses SP, monProcessNetIO N \n" + "where MP.KPID = SP.kpid \n" + "  and MP.KPID = A.KPID \n" + "  and MP.KPID = N.KPID \n" + "  RUNTIME_REPLACE::SAMPLE_SYSTEM_THREADS \n";
                if (this.isClusterEnabled()) {
                    sql = sql + "  and MP.InstanceID = SP.instanceid \n  and MP.InstanceID = A.InstanceID \n  and MP.InstanceID = N.InstanceID \n";
                }
                sql = sql + "order by MP.SPID \n" + optGoalPlan;
                this.setSql(sql);
            }

            @Override
            public String getSql() {
                String sql = super.getSql();
                Configuration conf = Configuration.getCombinedConfiguration();
                boolean sampleSystemThreads_chk = conf == null ? true : conf.getBooleanProperty("CMprocActivity.sample.systemThreads", true);
                String sampleSystemThreadSql = "";
                if (!sampleSystemThreads_chk) {
                    sampleSystemThreadSql = "  and SP.suid > 0 ";
                }
                sql = sql.replace("RUNTIME_REPLACE::SAMPLE_SYSTEM_THREADS", sampleSystemThreadSql);
                return sql;
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                List<String> colNames;
                int pos_WaitEventID = -1;
                int pos_WaitEventDesc = -1;
                int pos_WaitClassDesc = -1;
                int pos_BlockingSPID = -1;
                int waitEventID = 0;
                String waitEventDesc = "";
                String waitClassDesc = "";
                SamplingCnt counters = diffData;
                MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                if (mtd == null) {
                    return;
                }
                if (counters == null) {
                    return;
                }
                this._blockingSpids.clear();
                if (this.getTabPanel() != null) {
                    this.getTabPanel().putTableClientProperty("blockingSpidMap", this._blockingSpids);
                }
                if ((colNames = counters.getColNames()) == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("WaitEventID")) {
                        pos_WaitEventID = colId;
                    } else if (colName.equals("WaitEventDesc")) {
                        pos_WaitEventDesc = colId;
                    } else if (colName.equals("WaitClassDesc")) {
                        pos_WaitClassDesc = colId;
                    } else if (colName.equals("BlockingSPID")) {
                        pos_BlockingSPID = colId;
                    }
                    if (pos_WaitEventID >= 0 && pos_WaitEventDesc >= 0 && pos_WaitClassDesc >= 0 && pos_BlockingSPID >= 0) break;
                }
                if (pos_WaitEventID < 0 || pos_WaitEventDesc < 0 || pos_WaitClassDesc < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('WaitEventID'=" + pos_WaitEventID + ", 'WaitEventDesc'=" + pos_WaitEventDesc + ", 'WaitClassDesc'=" + pos_WaitClassDesc + ")"));
                    return;
                }
                if (pos_BlockingSPID < 0) {
                    _logger.debug((Object)("Cant find the position for column ('BlockingSPID'=" + pos_BlockingSPID + ")"));
                    return;
                }
                for (int rowId = 0; rowId < counters.getRowCount(); ++rowId) {
                    Object o_waitEventId = counters.getValueAt(rowId, pos_WaitEventID);
                    Object o_blockingSpid = counters.getValueAt(rowId, pos_BlockingSPID);
                    if (o_waitEventId instanceof Number) {
                        waitEventID = ((Number)o_waitEventId).intValue();
                        if (mtd.hasWaitEventDescription(waitEventID)) {
                            waitEventDesc = mtd.getWaitEventDescription(waitEventID);
                            waitClassDesc = mtd.getWaitEventClassDescription(waitEventID);
                        } else {
                            waitEventDesc = "";
                            waitClassDesc = "";
                        }
                        counters.setValueAt(waitEventDesc, rowId, pos_WaitEventDesc);
                        counters.setValueAt(waitClassDesc, rowId, pos_WaitClassDesc);
                    }
                    if (!(o_blockingSpid instanceof Number) || o_blockingSpid == null || ((Number)o_blockingSpid).intValue() == 0) continue;
                    this._blockingSpids.put((Number)o_blockingSpid, null);
                }
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("ChkptHkGraph".equals(tgdp.getName())) {
                    int pos_Command = -1;
                    int pos_PhysicalWrites = -1;
                    CounterTableModel counters = this.getCounterData(3);
                    if (counters == null) {
                        return;
                    }
                    List<String> colNames = counters.getColNames();
                    if (colNames == null) {
                        return;
                    }
                    for (int colId = 0; colId < colNames.size(); ++colId) {
                        String colName = colNames.get(colId);
                        if (colName.equals("Command")) {
                            pos_Command = colId;
                        } else if (colName.equals("PhysicalWrites")) {
                            pos_PhysicalWrites = colId;
                        }
                        if (pos_Command >= 0 && pos_PhysicalWrites >= 0) break;
                    }
                    if (pos_Command < 0 || pos_PhysicalWrites < 0) {
                        _logger.debug((Object)("Cant find the position for column ('Command'=" + pos_Command + ", 'PhysicalWrites'=" + pos_PhysicalWrites + ")"));
                        return;
                    }
                    Object o_CheckpointWrite = null;
                    Object o_HkWashWrite = null;
                    Object o_HkGcWrite = null;
                    Object o_HkChoresWrite = null;
                    for (int rowId = 0; rowId < counters.getRowCount(); ++rowId) {
                        Object o_Command = counters.getValueAt(rowId, pos_Command);
                        if (o_Command instanceof String) {
                            String command = (String)o_Command;
                            if (command.startsWith("CHECKPOINT")) {
                                o_CheckpointWrite = counters.getValueAt(rowId, pos_PhysicalWrites);
                            }
                            if (command.startsWith("HK WASH")) {
                                o_HkWashWrite = counters.getValueAt(rowId, pos_PhysicalWrites);
                            }
                            if (command.startsWith("HK GC")) {
                                o_HkGcWrite = counters.getValueAt(rowId, pos_PhysicalWrites);
                            }
                            if (command.startsWith("HK CHORES")) {
                                o_HkChoresWrite = counters.getValueAt(rowId, pos_PhysicalWrites);
                            }
                        }
                        if (o_CheckpointWrite != null && o_HkWashWrite != null && o_HkGcWrite != null && o_HkChoresWrite != null) break;
                    }
                    Double[] arr = new Double[]{new Double(o_CheckpointWrite == null ? "0" : o_CheckpointWrite.toString()), new Double(o_HkWashWrite == null ? "0" : o_HkWashWrite.toString()), new Double(o_HkGcWrite == null ? "0" : o_HkGcWrite.toString()), new Double(o_HkChoresWrite == null ? "0" : o_HkChoresWrite.toString())};
                    _logger.debug((Object)("updateGraphData(ChkptHkGraph): o_CheckpointWrite='" + o_CheckpointWrite + "', o_HkWashWrite='" + o_HkWashWrite + "', o_HkGcWrite='" + o_HkGcWrite + "', o_HkChoresWrite='" + o_HkChoresWrite + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.setDiffDissColumns(new String[]{"WaitTime"});
        tmp.addTrendGraphData("ChkptHkGraph", new TrendGraphDataPoint("ChkptHkGraph", new String[]{"Checkpoint Writes", "HK Wash Writes", "HK GC Writes", "HK Chores Writes"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Local Options", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
                    Configuration conf = Configuration.getCombinedConfiguration();
                    JCheckBox sampleSystemThreads_chk = new JCheckBox("Show system processes", conf == null ? true : conf.getBooleanProperty("CMprocActivity.sample.systemThreads", true));
                    sampleSystemThreads_chk.setName("CMprocActivity.sample.systemThreads");
                    sampleSystemThreads_chk.setToolTipText("<html>Sample System SPID's that executes in the ASE Server.<br><b>Note</b>: This is not a filter, you will have to wait for next sample time for this option to take effect.</html>");
                    panel.add((Component)sampleSystemThreads_chk, "wrap");
                    sampleSystemThreads_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getInstance("USER_TEMP");
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMprocActivity.sample.systemThreads", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    return panel;
                }
            };
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_process_activity.png"));
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>YELLOW - SPID is a System Processes</li>    <li>GREEN  - SPID is Executing(running) or are in the Run Queue Awaiting a time slot to Execute (runnable)</li>    <li>PINK   - SPID is Blocked by some other SPID that holds a Lock on a database object Table, Page or Row. This is the Lock Victim.</li>    <li>RED    - SPID is Blocking other SPID's from running, this SPID is Responslibe or the Root Cause of a Blocking Lock.</li></ul></html>");
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("ChkptHkGraph", "Chekpoint and HK Writes", "Checkpoint and Housekeeper Writes Per Second", new String[]{"Checkpoint Writes", "HK Wash Writes", "HK GC Writes", "HK Chores Writes"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.system");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String login = (String)adapter.getValue(adapter.getColumnIndex((Object)"Login"));
                    return "".equals(login) || "probe".equals(login);
                }
            }, SwingUtils.parseColor(colorStr, Color.YELLOW), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.running");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String status = (String)adapter.getValue(adapter.getColumnIndex((Object)"status"));
                    return status != null && (status.startsWith("running") || status.startsWith("runnable"));
                }
            }, SwingUtils.parseColor(colorStr, Color.GREEN), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocked");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number blockingSpid = (Number)adapter.getValue(adapter.getColumnIndex((Object)"BlockingSPID"));
                    return blockingSpid != null && blockingSpid.intValue() != 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.PINK), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocking");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number blockingSpid;
                    boolean isBlocking = false;
                    Number thisSpid = (Number)adapter.getValue(adapter.getColumnIndex((Object)"SPID"));
                    HashMap blockingSpidMap = (HashMap)adapter.getComponent().getClientProperty("blockingSpidMap");
                    if (blockingSpidMap != null && thisSpid != null) {
                        isBlocking = blockingSpidMap.containsKey(thisSpid);
                    }
                    return isBlocking && (blockingSpid = (Number)adapter.getValue(adapter.getColumnIndex((Object)"BlockingSPID"))) != null && blockingSpid.intValue() == 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.RED), null));
        }
        _CMList.add(tmp);
        name = "CMdbActivity";
        displayName = "Databases";
        description = "Various information on a database level.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monOpenDatabases"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"AppendLogRequests", "AppendLogWaits"};
        colsCalcPCT = new String[]{"AppendLogContPct"};
        pkList = new LinkedList();
        pkList.add("DBName");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 5078336367667465709L;

            @Override
            public void initSql(Connection conn) {
                String cols;
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monOpenDatabases", "CeDbRecoveryStatus", "<html>1 = The database is currently undergoing <B>node-failure</B> recovery.<br> 0 = Normal, <B>not</B> in node-failure recovery.</html>");
                    mtd.addColumn("monOpenDatabases", "AppendLogContPct", "<html>Log Semaphore Contention in percent.<br> <b>Formula</b>: Pct = (AppendLogWaits / AppendLogRequests) * 100<br></html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                String ceDbRecoveryStatus = "";
                String QuiesceTag = "";
                String SuspendedProcesses = "";
                if (aseVersion >= 12510) {
                    QuiesceTag = "QuiesceTag, ";
                    SuspendedProcesses = "SuspendedProcesses, ";
                }
                if (this.isClusterEnabled()) {
                    ceDbRecoveryStatus = "CeDbRecoveryStatus = db_recovery_status(DBID), ";
                }
                cols1 = cols1 + "DBName, DBID, " + ceDbRecoveryStatus + "AppendLogRequests, AppendLogWaits, \n" + "AppendLogContPct = CASE \n" + "                      WHEN AppendLogRequests > 0 \n" + "                      THEN convert(numeric(10,2), ((AppendLogWaits+0.0)/AppendLogRequests)*100.0) \n" + "                      ELSE convert(numeric(10,2), 0.0) \n" + "                   END, \n" + "TransactionLogFull, " + SuspendedProcesses + "BackupInProgress, LastBackupFailed, BackupStartTime, ";
                cols2 = cols2 + "";
                cols3 = cols3 + QuiesceTag;
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                if (aseVersion >= 15025) {
                    cols2 = cols2 + "LastTranLogDumpTime, LastCheckpointTime, ";
                }
                if ((cols = cols1 + cols2 + cols3).endsWith(", ")) {
                    cols = cols.substring(0, cols.length() - 2);
                }
                String sql = "select " + cols + "\n" + "from monOpenDatabases \n" + "order by DBName \n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int AppendLogRequestsId = -1;
                int AppendLogWaitsId = -1;
                int AppendLogContPctId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("AppendLogContPct")) {
                        AppendLogContPctId = colId;
                        continue;
                    }
                    if (colName.equals("AppendLogRequests")) {
                        AppendLogRequestsId = colId;
                        continue;
                    }
                    if (!colName.equals("AppendLogWaits")) continue;
                    AppendLogWaitsId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int AppendLogRequests = ((Number)diffData.getValueAt(rowId, AppendLogRequestsId)).intValue();
                    int AppendLogWaits = ((Number)diffData.getValueAt(rowId, AppendLogWaitsId)).intValue();
                    if (AppendLogRequests > 0) {
                        double calcAppendLogContPct = ((double)AppendLogWaits + 0.0) / (double)AppendLogRequests * 100.0;
                        BigDecimal newVal = new BigDecimal(calcAppendLogContPct).setScale(2, 6);
                        diffData.setValueAt(newVal, rowId, AppendLogContPctId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0).setScale(2, 6), rowId, AppendLogContPctId);
                }
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("DbLogSemapContGraph".equals(tgdp.getName())) {
                    Double[] dArray = new Double[this.size()];
                    String[] lArray = new String[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        lArray[i] = this.getAbsString(i, "DBName");
                        dArray[i] = this.getDiffValueAsDouble(i, "AppendLogContPct");
                    }
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setLabel(lArray);
                    tgdp.setData(dArray);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("DbLogSemapContGraph", new TrendGraphDataPoint("DbLogSemapContGraph", new String[]{"runtime-replaced"}));
        if (Asemon.hasGUI()) {
            finalDisplayName = displayName;
            tcp = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Local Options", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
                    JButton resetMoveToTab_but = new JButton("Reset 'Move to Tab' settings.");
                    resetMoveToTab_but.setToolTipText("<html>Reset the option: To automatically switch to this tab when any Database(s) Transaction log is <b>full</b>.<br>Next time this happens, a popup will ask you what you want to do.</html>");
                    resetMoveToTab_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChangeToJTabDialog.resetSavedSettings(finalDisplayName);
                        }
                    });
                    panel.add((Component)resetMoveToTab_but, "wrap");
                    return panel;
                }
            };
            tcp.setToolTipText(description);
            tcp.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_db_activity.png"));
            tcp.setCm(tmp);
            MainFrame.addTcp(tcp);
            tmp.setTabPanel(tcp);
            TrendGraph tg3 = new TrendGraph("DbLogSemapContGraph", "DB Transaction Log Semaphore Contention", "DB Transaction Log Semaphore Contention in Percent", new String[]{"runtime-replaced"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg3.getName(), tg3, true);
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.fullTranslog");
            }
            tcp.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number isLogFull = (Number)adapter.getValue(adapter.getColumnIndex((Object)"TransactionLogFull"));
                    return isLogFull != null && isLogFull.intValue() > 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.RED), null));
        }
        _CMList.add(tmp);
        name = "CMTmpdbActivity";
        displayName = "Temp Db";
        description = "Provides statistics for all local temporary databases.";
        needVersion = 15500;
        needCeVersion = 15020;
        monTables = new String[]{"monTempdbActivity"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "object lockwait timing=1", "per object statistics active=1"};
        colsCalcDiff = new String[]{"AppendLogRequests", "AppendLogWaits", "LogicalReads", "PhysicalReads", "APFReads", "PagesRead", "PhysicalWrites", "PagesWritten", "LockRequests", "LockWaits", "CatLockRequests", "CatLockWaits", "AssignedCnt", "SharableTabCnt"};
        colsCalcPCT = new String[]{"AppendLogContPct"};
        pkList = new LinkedList();
        pkList.add("DBID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 5078336367667465709L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monTempdbActivity", "AppendLogContPct", "<html>Log Semaphore Contention in percent.<br> <b>Formula</b>: Pct = (AppendLogWaits / AppendLogRequests) * 100<br></html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "DBID, DBName, SharableTabCnt, AppendLogRequests, AppendLogWaits, AppendLogContPct = CASE WHEN AppendLogRequests > 0 THEN convert(numeric(10,2), ((AppendLogWaits+0.0)/AppendLogRequests)*100.0) ELSE convert(numeric(10,2), 0.0) END, LogicalReads, PhysicalReads, APFReads, PagesRead, PhysicalWrites, PagesWritten, LockRequests, LockWaits, CatLockRequests, CatLockWaits, AssignedCnt";
                cols2 = cols2 + "";
                cols3 = cols3 + "";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monTempdbActivity \n" + "order by DBName \n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int AppendLogRequestsId = -1;
                int AppendLogWaitsId = -1;
                int AppendLogContPctId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("AppendLogContPct")) {
                        AppendLogContPctId = colId;
                        continue;
                    }
                    if (colName.equals("AppendLogRequests")) {
                        AppendLogRequestsId = colId;
                        continue;
                    }
                    if (!colName.equals("AppendLogWaits")) continue;
                    AppendLogWaitsId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int AppendLogRequests = ((Number)diffData.getValueAt(rowId, AppendLogRequestsId)).intValue();
                    int AppendLogWaits = ((Number)diffData.getValueAt(rowId, AppendLogWaitsId)).intValue();
                    if (AppendLogRequests > 0) {
                        double calcAppendLogContPct = ((double)AppendLogWaits + 0.0) / (double)AppendLogRequests * 100.0;
                        BigDecimal newVal = new BigDecimal(calcAppendLogContPct).setScale(2, 6);
                        diffData.setValueAt(newVal, rowId, AppendLogContPctId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0).setScale(2, 6), rowId, AppendLogContPctId);
                }
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("TempDbLogSemapContGraph".equals(tgdp.getName())) {
                    Double[] dArray = new Double[this.size()];
                    String[] lArray = new String[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        lArray[i] = this.getAbsString(i, "DBName");
                        dArray[i] = this.getDiffValueAsDouble(i, "AppendLogContPct");
                    }
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setLabel(lArray);
                    tgdp.setData(dArray);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("TempDbLogSemapContGraph", new TrendGraphDataPoint("TempDbLogSemapContGraph", new String[]{"runtime-replaced"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_db_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("TempDbLogSemapContGraph", "TempDB Transaction Log Semaphore Contention", "TempDB Transaction Log Semaphore Contention in Percent", new String[]{"runtime-replaced"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMsysWaitActivity";
        displayName = "Waits";
        description = "What different resources are the ASE Server waiting for.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monSysWaits", "monWaitEventInfo", "monWaitClassInfo"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "wait event timing=1"};
        colsCalcDiff = new String[]{"WaitTime", "Waits"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("WaitEventID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = -945885495581439333L;

            @Override
            protected CmSybMessageHandler createSybMessageHandler() {
                CmSybMessageHandler msgHandler = super.createSybMessageHandler();
                msgHandler.addDiscardMsgStr("WaitClassID, WaitEventID");
                return msgHandler;
            }

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monSysWaits", "WaitTimePerWait", "<html>Wait time in seconds per wait. formula: diff.WaitTime / diff.Waits<br>Since WaitTime here is in seconds, this value will also be in seconds.</html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "Class=C.Description, Event=I.Description, W.WaitEventID, WaitTime, Waits \n";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                cols2 = cols2 + ", WaitTimePerWait = CASE WHEN Waits > 0 \n                         THEN convert(numeric(10,3), (WaitTime + 0.0) / Waits) \n                         ELSE convert(numeric(10,3), 0.0) \n                     END \n";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monSysWaits W, monWaitEventInfo I, monWaitClassInfo C \n" + "where W.WaitEventID=I.WaitEventID and I.WaitClassID=C.WaitClassID \n" + "order by " + (this.isClusterEnabled() ? "W.WaitEventID, InstanceID" : "W.WaitEventID") + "\n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int WaitTimeId = -1;
                int WaitsId = -1;
                int WaitTimePerWaitId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("WaitTimePerWait")) {
                        WaitTimePerWaitId = colId;
                        continue;
                    }
                    if (colName.equals("WaitTime")) {
                        WaitTimeId = colId;
                        continue;
                    }
                    if (!colName.equals("Waits")) continue;
                    WaitsId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int WaitTime = ((Number)diffData.getValueAt(rowId, WaitTimeId)).intValue();
                    int Waits = ((Number)diffData.getValueAt(rowId, WaitsId)).intValue();
                    if (Waits > 0) {
                        double calcWaitTimePerWait = (double)WaitTime / ((double)Waits * 1.0);
                        BigDecimal newVal = new BigDecimal(calcWaitTimePerWait).setScale(3, 6);
                        diffData.setValueAt(newVal, rowId, WaitTimePerWaitId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0), rowId, WaitTimePerWaitId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_wait_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMengineActivity";
        displayName = "Engines";
        description = "What ASE Server engine is working. In here we can also se what engines are doing/checking for IO's.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monEngine"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"CPUTime", "SystemCPUTime", "UserCPUTime", "IdleCPUTime", "IOCPUTime", "Yields", "DiskIOChecks", "DiskIOPolled", "DiskIOCompleted", "ContextSwitches", "HkgcPendingItems", "HkgcOverflows"};
        colsCalcPCT = new String[]{"CPUTime", "SystemCPUTime", "UserCPUTime", "IdleCPUTime", "IOCPUTime"};
        pkList = new LinkedList();
        pkList.add("EngineNumber");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 3975695722601723795L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "EngineNumber, CurrentKPID, PreviousKPID, CPUTime, SystemCPUTime, UserCPUTime, ";
                if (aseVersion >= 15500 || aseVersion >= 15030 && this.isClusterEnabled()) {
                    cols1 = cols1 + "IOCPUTime, ";
                }
                cols1 = cols1 + "IdleCPUTime, ContextSwitches, Connections, ";
                cols2 = cols2 + "";
                cols3 = cols3 + "ProcessesAffinitied, Status, StartTime, StopTime, AffinitiedToCPU, OSPID";
                if (aseVersion >= 12532) {
                    cols2 = cols2 + "Yields, DiskIOChecks, DiskIOPolled, DiskIOCompleted, ";
                }
                if (aseVersion >= 15025) {
                    cols2 = cols2 + "MaxOutstandingIOs, ";
                }
                if (aseVersion >= 15000) {
                    cols2 = cols2 + "HkgcMaxQSize, HkgcPendingItems, HkgcHWMItems, HkgcOverflows, ";
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monEngine \n" + "where Status = 'online' \n" + "order by 1,2\n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                int aseVersion = this.getServerVersion();
                if ("cpuSum".equals(tgdp.getName())) {
                    Double[] dataArray = new Double[3];
                    String[] labelArray = new String[3];
                    if (aseVersion >= 15500) {
                        dataArray = new Double[4];
                        labelArray = new String[4];
                    }
                    labelArray[0] = "System+User CPU";
                    labelArray[1] = "System CPU";
                    labelArray[2] = "User CPU";
                    dataArray[0] = this.getDiffValueAvg("CPUTime");
                    dataArray[1] = this.getDiffValueAvg("SystemCPUTime");
                    dataArray[2] = this.getDiffValueAvg("UserCPUTime");
                    if (aseVersion >= 15500) {
                        labelArray[0] = "System+User+IO CPU";
                        dataArray[3] = this.getDiffValueAvg("IOCPUTime");
                        labelArray[3] = "IO CPU";
                        _logger.debug((Object)("updateGraphData(cpuSum): CPUTime='" + dataArray[0] + "', SystemCPUTime='" + dataArray[1] + "', UserCPUTime='" + dataArray[2] + "', IoCPUTime='" + dataArray[3] + "'."));
                    } else {
                        _logger.debug((Object)("updateGraphData(cpuSum): CPUTime='" + dataArray[0] + "', SystemCPUTime='" + dataArray[1] + "', UserCPUTime='" + dataArray[2] + "'."));
                    }
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setLabel(labelArray);
                    tgdp.setData(dataArray);
                }
                if ("cpuEng".equals(tgdp.getName())) {
                    TrendGraph tg;
                    if (aseVersion >= 15500 && (tg = this.getTrendGraph(tgdp.getName())) != null) {
                        tg.setLabel("CPU Usage per Engine (System + User + IO)");
                    }
                    Double[] engCpuArray = new Double[this.size()];
                    String[] engNumArray = new String[engCpuArray.length];
                    for (int i = 0; i < engCpuArray.length; ++i) {
                        String instanceId = null;
                        if (this.isClusterEnabled()) {
                            instanceId = this.getAbsString(i, "InstanceID");
                        }
                        String engineNumber = this.getAbsString(i, "EngineNumber");
                        engCpuArray[i] = this.getDiffValueAsDouble(i, "CPUTime");
                        engNumArray[i] = instanceId == null ? "eng-" + engineNumber : "eng-" + instanceId + ":" + engineNumber;
                    }
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setLabel(engNumArray);
                    tgdp.setData(engCpuArray);
                }
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int aseVersion = this.getServerVersion();
                int CPUTimeId = -1;
                int SystemCPUTimeId = -1;
                int UserCPUTimeId = -1;
                int IOCPUTimeId = -1;
                int IdleCPUTimeId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("CPUTime")) {
                        CPUTimeId = colId;
                        continue;
                    }
                    if (colName.equals("SystemCPUTime")) {
                        SystemCPUTimeId = colId;
                        continue;
                    }
                    if (colName.equals("UserCPUTime")) {
                        UserCPUTimeId = colId;
                        continue;
                    }
                    if (colName.equals("IOCPUTime")) {
                        IOCPUTimeId = colId;
                        continue;
                    }
                    if (!colName.equals("IdleCPUTime")) continue;
                    IdleCPUTimeId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int CPUTime = ((Number)diffData.getValueAt(rowId, CPUTimeId)).intValue();
                    int SystemCPUTime = ((Number)diffData.getValueAt(rowId, SystemCPUTimeId)).intValue();
                    int UserCPUTime = ((Number)diffData.getValueAt(rowId, UserCPUTimeId)).intValue();
                    int IdleCPUTime = ((Number)diffData.getValueAt(rowId, IdleCPUTimeId)).intValue();
                    int IOCPUTime = 0;
                    if (aseVersion >= 15500) {
                        IOCPUTime = ((Number)diffData.getValueAt(rowId, IOCPUTimeId)).intValue();
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("----CPUTime = " + CPUTime + ", SystemCPUTime = " + SystemCPUTime + ", UserCPUTime = " + UserCPUTime + ", IOCPUTime = " + IOCPUTime + ", IdleCPUTime = " + IdleCPUTime));
                    }
                    BigDecimal calcCPUTime = null;
                    BigDecimal calcSystemCPUTime = null;
                    BigDecimal calcUserCPUTime = null;
                    BigDecimal calcIoCPUTime = null;
                    BigDecimal calcIdleCPUTime = null;
                    if (CPUTime == 0) {
                        calcCPUTime = new BigDecimal(0);
                        calcSystemCPUTime = new BigDecimal(0);
                        calcUserCPUTime = new BigDecimal(0);
                        calcIoCPUTime = new BigDecimal(0);
                        calcIdleCPUTime = new BigDecimal(0);
                    } else {
                        int sumSystemUserIo = SystemCPUTime + UserCPUTime + IOCPUTime;
                        calcCPUTime = new BigDecimal(1.0 * (double)sumSystemUserIo / (double)CPUTime * 100.0).setScale(1, 6);
                        calcSystemCPUTime = new BigDecimal(1.0 * (double)SystemCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
                        calcUserCPUTime = new BigDecimal(1.0 * (double)UserCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
                        calcIoCPUTime = new BigDecimal(1.0 * (double)IOCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
                        calcIdleCPUTime = new BigDecimal(1.0 * (double)IdleCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("++++CPUTime = " + calcCPUTime + ", SystemCPUTime = " + calcSystemCPUTime + ", UserCPUTime = " + calcUserCPUTime + ", IoCPUTime = " + calcIoCPUTime + ", IdleCPUTime = " + calcIdleCPUTime));
                    }
                    diffData.setValueAt(calcCPUTime, rowId, CPUTimeId);
                    diffData.setValueAt(calcSystemCPUTime, rowId, SystemCPUTimeId);
                    diffData.setValueAt(calcUserCPUTime, rowId, UserCPUTimeId);
                    diffData.setValueAt(calcIdleCPUTime, rowId, IdleCPUTimeId);
                    if (aseVersion < 15500) continue;
                    diffData.setValueAt(calcIoCPUTime, rowId, IOCPUTimeId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("cpuSum", new TrendGraphDataPoint("cpuSum", new String[]{"System+User CPU", "System CPU", "User CPU"}));
        tmp.addTrendGraphData("cpuEng", new TrendGraphDataPoint("cpuEng", new String[]{"eng-0"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_engine_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = null;
            tg = new TrendGraph("cpuSum", "CPU Summary", "CPU Summary for all Engines (using monEngine)", new String[]{"System+User CPU", "System CPU", "User CPU"}, true, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
            tg = new TrendGraph("cpuEng", "CPU per Engine", "CPU Usage per Engine (System + User)", new String[]{"eng-0"}, true, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMSysLoad";
        displayName = "System Load";
        description = "<html>The SYSTEM load.<br>Here you can see the balancing between engines<br>Check 'run queue length', which is almost the same as 'load average' on Unix systems.<br>Meaning: How many threads/SPIDs are currently waiting on the run queue before they could be scheduled for execution.</html>";
        needVersion = 15500;
        needCeVersion = 15020;
        monTables = new String[]{"monSysLoad"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{""};
        colsCalcDiff = new String[]{};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("StatisticID");
        pkList.add("EngineNumber");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -1842749890597642593L;

            @Override
            public void initSql(Connection conn) {
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                String sql = "select " + cols1 + "StatisticID, Statistic, EngineNumber, \n" + "       Sample, \n" + "       Avg_1min, Avg_5min, Avg_15min, " + "       SteadyState, \n" + "       Peak_Time, Peak, \n" + "       Max_1min_Time,  Max_1min, \n" + "       Max_5min_Time,  Max_5min, \n" + "       Max_15min_Time, Max_15min \n" + "from monSysLoad \n" + "order by StatisticID, EngineNumber" + (this.isClusterEnabled() ? ", InstanceID" : "");
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                int[] rqRows;
                JCheckBoxMenuItem menuItem;
                TrendGraph tg;
                int aseVersion = this.getServerVersion();
                if ("AvgRunQLengthGraph".equals(tgdp.getName())) {
                    if (aseVersion < 15500) {
                        tg = this.getTrendGraph("AvgRunQLengthGraph");
                        if (tg != null && (menuItem = tg.getViewMenuItem()).isSelected()) {
                            menuItem.doClick();
                        }
                    } else {
                        rqRows = this.getAbsRowIdsWhere("Statistic", "run queue length");
                        Double[] arr = new Double[]{this.getAbsValueAvg(rqRows, "Sample"), this.getAbsValueAvg(rqRows, "Avg_1min"), this.getAbsValueAvg(rqRows, "Avg_5min"), this.getAbsValueAvg(rqRows, "Max_1min"), this.getAbsValueAvg(rqRows, "Max_5min")};
                        _logger.debug((Object)("updateGraphData(AvgRunQLengthGraph): Sample='" + arr[0] + "', Avg_1min='" + arr[1] + "', Avg_5min='" + arr[2] + "', Max_1min='" + arr[3] + "', Max_5min='" + arr[4] + "'."));
                        tgdp.setDate(this.getTimestamp());
                        tgdp.setData(arr);
                    }
                }
                if ("EngineRunQLengthGraph".equals(tgdp.getName())) {
                    if (aseVersion < 15500) {
                        tg = this.getTrendGraph("EngineRunQLengthGraph");
                        if (tg != null && (menuItem = tg.getViewMenuItem()).isSelected()) {
                            menuItem.doClick();
                        }
                    } else {
                        rqRows = this.getAbsRowIdsWhere("Statistic", "run queue length");
                        Double[] data = new Double[rqRows.length];
                        String[] label = new String[rqRows.length];
                        for (int i = 0; i < rqRows.length; ++i) {
                            int rowId = rqRows[i];
                            String instanceId = null;
                            if (this.isClusterEnabled()) {
                                instanceId = this.getAbsString(rowId, "InstanceID");
                            }
                            String engineNumber = this.getAbsString(rowId, "EngineNumber");
                            label[i] = instanceId == null ? "eng-" + engineNumber : "eng-" + instanceId + ":" + engineNumber;
                            data[i] = this.getAbsValueAsDouble(rowId, "Avg_1min");
                        }
                        if (_logger.isDebugEnabled()) {
                            String debugStr = "";
                            for (int i = 0; i < data.length; ++i) {
                                debugStr = debugStr + label[i] + "='" + data[i] + "', ";
                            }
                            _logger.debug((Object)("updateGraphData(EngineRunQLengthGraph): " + debugStr));
                        }
                        tgdp.setDate(this.getTimestamp());
                        tgdp.setLabel(label);
                        tgdp.setData(data);
                    }
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("AvgRunQLengthGraph", new TrendGraphDataPoint("AvgRunQLengthGraph", new String[]{"Now", "Avg last 1 minute", "Avg last 5 minute", "Max last 1 minute", "Max last 5 minute"}));
        tmp.addTrendGraphData("EngineRunQLengthGraph", new TrendGraphDataPoint("EngineRunQLengthGraph", new String[]{"-runtime-replaced-"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_sysload_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("AvgRunQLengthGraph", "Run Queue Length, Server Wide", "Run Queue Length, Average for all instances (only in 15.5 and later)", new String[]{"Now", "Avg last 1 minute", "Avg last 5 minute", "Max last 1 minute", "Max last 5 minute"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
            tg = new TrendGraph("EngineRunQLengthGraph", "Run Queue Length, Per Engine", "Run Queue Length, Average over last minute, Per Engine (only in 15.5 and later)", new String[]{"-runtime-replaced-"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMcacheActivity";
        displayName = "Data Caches";
        description = "What (user defined) data caches have we got and how many 'chache misses' goes out to disk...";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monDataCache"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"CacheHitRate", "CacheSearches", "PhysicalReads", "LogicalReads", "PhysicalWrites", "Stalls"};
        colsCalcPCT = new String[]{"CacheHitRate"};
        pkList = new LinkedList();
        pkList.add("CacheName");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = -2185972180915326688L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monDataCache", "Stalls", "Number of times I/O operations were delayed because no clean buffers were available in the wash area");
                    mtd.addColumn("monDataCache", "CacheHitRate", "<html>Percent calculation of how many pages was fetched from the cache.<br><b>Note</b>: APF reads could already be in memory, counted as a 'cache hit', check also 'devices' and APFReads.<br><b>Formula</b>: 100 - (PhysicalReads/CacheSearches) * 100.0</html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "CacheName, CacheID, RelaxedReplacement, CachePartitions, BufferPools, CacheSearches, PhysicalReads, LogicalReads, PhysicalWrites, Stalls, CacheHitRate = convert(numeric(10,1), 100 - (PhysicalReads*1.0/(CacheSearches+1)) * 100.0)";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monDataCache \n" + "order by 1,2\n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("CacheGraph".equals(tgdp.getName())) {
                    Double[] arr = new Double[]{this.getRateValueSum("LogicalReads"), this.getRateValueSum("PhysicalReads"), this.getRateValueSum("PhysicalWrites")};
                    _logger.debug((Object)("updateGraphData(CacheGraph): LogicalReads='" + arr[0] + "', PhysicalReads='" + arr[1] + "', PhysicalWrites='" + arr[2] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int CacheSearchesId = -1;
                int PhysicalReadsId = -1;
                int CacheHitRateId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("CacheSearches")) {
                        CacheSearchesId = colId;
                        continue;
                    }
                    if (colName.equals("PhysicalReads")) {
                        PhysicalReadsId = colId;
                        continue;
                    }
                    if (!colName.equals("CacheHitRate")) continue;
                    CacheHitRateId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int CacheSearches = ((Number)diffData.getValueAt(rowId, CacheSearchesId)).intValue();
                    int PhysicalReads = ((Number)diffData.getValueAt(rowId, PhysicalReadsId)).intValue();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("----CacheSearches = " + CacheSearches + ", PhysicalReads = " + PhysicalReads));
                    }
                    BigDecimal calcCacheHitRate = null;
                    calcCacheHitRate = CacheSearches == 0 ? new BigDecimal(0) : new BigDecimal(100.0 - (double)PhysicalReads * 1.0 / (double)CacheSearches * 100.0).setScale(1, 6);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("++++CacheHitRate = " + calcCacheHitRate));
                    }
                    diffData.setValueAt(calcCacheHitRate, rowId, CacheHitRateId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("CacheGraph", new TrendGraphDataPoint("CacheGraph", new String[]{"Logical Reads", "Physical Reads", "Writes"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_cache_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("CacheGraph", "Data Caches Activity", "Activity for All Data Caches per Second", new String[]{"Logical Reads", "Physical Reads", "Writes"}, false, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMpoolActivity";
        displayName = "Pools";
        description = "The cahces has 2K or 16K pools, how are they behaving?";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monCachePool"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"PagesRead", "PhysicalReads", "Stalls", "PagesTouched", "BuffersToMRU", "BuffersToLRU"};
        colsCalcPCT = new String[]{"CacheUtilization", "CacheEfficiency"};
        pkList = new LinkedList();
        pkList.add("CacheName");
        pkList.add("IOBufferSize");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = -6929175820005726806L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monCachePool", "Stalls", "Number of times I/O operations were delayed because no clean buffers were available in the wash area");
                    mtd.addColumn("monCachePool", "SrvPageSize", "ASE Servers page size (@@maxpagesize)");
                    mtd.addColumn("monCachePool", "PagesPerIO", "This pools page size (1=SinglePage, 2=, 4=, 8=Extent IO)");
                    mtd.addColumn("monCachePool", "AllocatedPages", "Number of actual pages allocated to this pool. same as 'AllocatedKB' but in pages instead of KB.");
                    mtd.addColumn("monCachePool", "CacheUtilization", "<html>If not 100% the cache has to much memory allocated to it.<br><b>Formula</b>: abs.PagesTouched / abs.AllocatedPages * 100<br></html>");
                    mtd.addColumn("monCachePool", "CacheEfficiency", "<html>If less than 100, the cache is to small (pages has been flushed ou from the cache).<br> Pages are read in from the disk, could be by APF Reads (so cacheHitRate is high) but the pages still had to be read from disk.<br><b>Formula</b>: abs.AllocatedPages / diff.PagesRead * 100<br></html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "CacheName, CacheID \n, SrvPageSize = @@maxpagesize \n, IOBufferSize \n, PagesPerIO = IOBufferSize/@@maxpagesize \n, AllocatedKB \n, AllocatedPages = convert(int,AllocatedKB*(1024.0/@@maxpagesize)) \n, PagesRead, PhysicalReads, Stalls, PagesTouched, BuffersToMRU, BuffersToLRU \n, CacheUtilization = convert(numeric(12,1), PagesTouched / (AllocatedKB*(1024.0/@@maxpagesize)) * 100.0) \n, CacheEfficiency  = CASE WHEN PagesRead > 0 THEN convert(numeric(12,1), (AllocatedKB*(1024.0/@@maxpagesize)) / PagesRead    * 100.0) ELSE 0.0 END\n";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monCachePool \n" + "order by CacheName, IOBufferSize\n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int AllocatedKBId = -1;
                int PagesTouchedId = -1;
                int PagesReadId = -1;
                int SrvPageSizeId = -1;
                int CacheUtilizationId = -1;
                int CacheEfficiencyId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("AllocatedKB")) {
                        AllocatedKBId = colId;
                        continue;
                    }
                    if (colName.equals("PagesTouched")) {
                        PagesTouchedId = colId;
                        continue;
                    }
                    if (colName.equals("PagesRead")) {
                        PagesReadId = colId;
                        continue;
                    }
                    if (colName.equals("SrvPageSize")) {
                        SrvPageSizeId = colId;
                        continue;
                    }
                    if (colName.equals("CacheUtilization")) {
                        CacheUtilizationId = colId;
                        continue;
                    }
                    if (!colName.equals("CacheEfficiency")) continue;
                    CacheEfficiencyId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int AllocatedKB = ((Number)newSample.getValueAt(rowId, AllocatedKBId)).intValue();
                    int PagesTouched = ((Number)newSample.getValueAt(rowId, PagesTouchedId)).intValue();
                    int PagesRead = ((Number)diffData.getValueAt(rowId, PagesReadId)).intValue();
                    int SrvPageSize = ((Number)newSample.getValueAt(rowId, SrvPageSizeId)).intValue();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("----AllocatedKB = " + AllocatedKB + ", PagesTouched = " + PagesTouched + ", PagesRead = " + PagesRead + ", SrvPageSize = " + SrvPageSize));
                    }
                    BigDecimal calcCacheUtilization = null;
                    BigDecimal calcCacheEfficiency = null;
                    if (AllocatedKB == 0) {
                        calcCacheUtilization = new BigDecimal(0);
                        calcCacheEfficiency = new BigDecimal(0);
                    } else {
                        double dCacheUtilization = (double)PagesTouched / ((double)AllocatedKB * (1024.0 / (double)SrvPageSize)) * 100.0;
                        double dCacheEfficiency = (double)AllocatedKB * (1024.0 / (double)SrvPageSize) / (double)PagesRead * 100.0;
                        if (dCacheEfficiency > 100.0) {
                            dCacheEfficiency = 100.0;
                        }
                        calcCacheUtilization = new BigDecimal(dCacheUtilization).setScale(1, 6);
                        calcCacheEfficiency = new BigDecimal(dCacheEfficiency).setScale(1, 6);
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("++++calcCacheUtilization = " + calcCacheUtilization + ", calcCacheEfficiency = " + calcCacheEfficiency));
                    }
                    diffData.setValueAt(calcCacheUtilization, rowId, CacheUtilizationId);
                    diffData.setValueAt(calcCacheEfficiency, rowId, CacheEfficiencyId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_pool_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMdeviceActivity";
        displayName = "Devices";
        description = "<html><p>What devices are doing IO's and what's the approximare service time on the disk.</p>Do not trust the service time <b>too</b> much...<br><br>Below is a table that describes how a fast or slow disk affects number of transactions per second.<br>The below description tries to exemplify number of transactions per seconds based on Disk IO responsiveness on the <b>LOG</b> Device.<br><TABLE ALIGN='left' BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH='100%'>   <TR ALIGN='left' VALIGN='left'> <TH>Device Type      </TH> <TH>Typical IOPS </TH> <TH>Typical ms/IO</TH> <TH>Xactn/Sec      </TH> </TR>   <!--                                    -----------------          -------------          -------------          --------------- -->  <TR ALIGN='left' VALIGN='left'> <TD>RAID 6           </TD> <TD>600          </TD> <TD>10-25        </TD> <TD>40-100         </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 5           </TD> <TD>800          </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 0 (RAID 10) </TD> <TD>1000         </TD> <TD>1-2          </TD> <TD>500-1000       </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>FC SCSI (tier 1) </TD> <TD>200-400      </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SAS SCSI (tier 2)</TD> <TD>150-200      </TD> <TD>4-8          </TD> <TD>125-250        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA (tier 3)    </TD> <TD>100-150      </TD> <TD>6-10         </TD> <TD>100-166        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA/SAS SSD     </TD> <TD>10000-20000  </TD> <TD>0.05-0.1     </TD> <TD>10,000-20,000  </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>PCIe SSD         </TD> <TD>100000-200000</TD> <TD>0.01-0.005   </TD> <TD>100,000-200,000</TD> </TR> </TABLE> The above table was found in the document: <br> http://www.sybase.com/detail?id=1091630<br>http://www.sybase.com/files/White_Papers/Managing-DBMS-Workloads-v1.0-WP.pdf<br></html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monDeviceIO"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"TotalIOs", "Reads", "APFReads", "Writes", "DevSemaphoreRequests", "DevSemaphoreWaits", "IOTime"};
        colsCalcPCT = new String[]{"ReadsPct", "APFReadsPct", "WritesPct"};
        pkList = new LinkedList();
        pkList.add("LogicalName");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 688571813560006014L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monDeviceIO", "TotalIOs", "<html>Total number of IO's issued on this device.<br><b>Formula</b>: Reads + Writes<br></html>");
                    mtd.addColumn("monDeviceIO", "APFReadsPct", "<html>Of all the issued Reads, what's the Asynch Prefetch Reads percentage.<br><b>Formula</b>: APFReads / Reads * 100<br></html>");
                    mtd.addColumn("monDeviceIO", "WritesPct", "<html>Of all the issued IO's, what's the Write percentage.<br><b>Formula</b>: Writes / (Reads + Writes) * 100<br></html>");
                    mtd.addColumn("monDeviceIO", "AvgServ_ms", "<html>Service time on the disk.<br>This is basically the average time it took to make a disk IO on this device.<br>Warning: ASE isn't timing each IO individually, Instead it uses the 'click ticks' to do it... This might change in the future.<br><b>Formula</b>: IOTime / (Reads + Writes) <br><b>Note</b>: If there is few I/O's this value might be a bit off, this due to 'click ticks' is 100 ms by default.<br></html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                String TotalIOs = "TotalIOs = (Reads + Writes)";
                if (aseVersion > 15000) {
                    TotalIOs = "TotalIOs = convert(bigint,Reads) + convert(bigint,Writes)";
                }
                String DeviceType = "";
                if (aseVersion >= 15020) {
                    DeviceType = "DeviceType = CASE \n               WHEN getdevicetype(PhysicalName) = 1 THEN 'RAW Device  '\n               WHEN getdevicetype(PhysicalName) = 2 THEN 'BLOCK Device'\n               WHEN getdevicetype(PhysicalName) = 3 THEN 'File        '\n               ELSE '-unknown-'+convert(varchar(5), getdevicetype(PhysicalName))+'-'\n             END,\n";
                }
                cols1 = cols1 + "LogicalName, " + TotalIOs + ", \n" + "Reads, \n" + "ReadsPct = CASE WHEN Reads + Writes > 0 \n" + "                THEN convert(numeric(10,1), (Reads + 0.0) / (Reads + Writes + 0.0) * 100.0 ) \n" + "                ELSE convert(numeric(10,1), 0.0 ) \n" + "           END, \n" + "APFReads, \n" + "APFReadsPct = CASE WHEN Reads > 0 \n" + "                   THEN convert(numeric(10,1), (APFReads + 0.0) / (Reads + 0.0) * 100.0 ) \n" + "                   ELSE convert(numeric(10,1), 0.0 ) \n" + "              END, \n" + "Writes, \n" + "WritesPct = CASE WHEN Reads + Writes > 0 \n" + "                 THEN convert(numeric(10,1), (Writes + 0.0) / (Reads + Writes + 0.0) * 100.0 ) \n" + "                 ELSE convert(numeric(10,1), 0.0 ) \n" + "            END, \n" + "DevSemaphoreRequests, DevSemaphoreWaits, IOTime, \n";
                cols2 = cols2 + "AvgServ_ms = CASE \n               WHEN Reads+Writes>0 \n               THEN convert(numeric(10,1), IOTime / convert(numeric(10,0), Reads+Writes)) \n               ELSE convert(numeric(10,1), null) \n             END \n";
                cols3 = cols3 + ", " + DeviceType + " PhysicalName";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monDeviceIO\n" + "order by LogicalName" + (this.isClusterEnabled() ? ", InstanceID" : "") + "\n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int AvgServ_msId = -1;
                int ReadsPctId = -1;
                int APFReadsPctId = -1;
                int WritesPctId = -1;
                int ReadsId = -1;
                int APFReadsId = -1;
                int WritesId = -1;
                int IOTimeId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("Reads")) {
                        ReadsId = colId;
                        continue;
                    }
                    if (colName.equals("APFReads")) {
                        APFReadsId = colId;
                        continue;
                    }
                    if (colName.equals("Writes")) {
                        WritesId = colId;
                        continue;
                    }
                    if (colName.equals("IOTime")) {
                        IOTimeId = colId;
                        continue;
                    }
                    if (colName.equals("ReadsPct")) {
                        ReadsPctId = colId;
                        continue;
                    }
                    if (colName.equals("APFReadsPct")) {
                        APFReadsPctId = colId;
                        continue;
                    }
                    if (colName.equals("WritesPct")) {
                        WritesPctId = colId;
                        continue;
                    }
                    if (!colName.equals("AvgServ_ms")) continue;
                    AvgServ_msId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    BigDecimal newVal;
                    double calc;
                    int Reads = ((Number)diffData.getValueAt(rowId, ReadsId)).intValue();
                    int APFReads = ((Number)diffData.getValueAt(rowId, APFReadsId)).intValue();
                    int Writes = ((Number)diffData.getValueAt(rowId, WritesId)).intValue();
                    int IOTime = ((Number)diffData.getValueAt(rowId, IOTimeId)).intValue();
                    int totIo = Reads + Writes;
                    if (totIo != 0) {
                        calc = ((double)IOTime + 0.0) / (double)totIo;
                        newVal = new BigDecimal(calc).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, AvgServ_msId);
                    } else {
                        diffData.setValueAt(new BigDecimal(0), rowId, AvgServ_msId);
                    }
                    if (totIo > 0) {
                        calc = ((double)Reads + 0.0) / ((double)(Reads + Writes) + 0.0) * 100.0;
                        newVal = new BigDecimal(calc).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, ReadsPctId);
                    } else {
                        diffData.setValueAt(new BigDecimal(0), rowId, ReadsPctId);
                    }
                    if (Reads > 0) {
                        calc = ((double)APFReads + 0.0) / ((double)Reads + 0.0) * 100.0;
                        newVal = new BigDecimal(calc).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, APFReadsPctId);
                    } else {
                        diffData.setValueAt(new BigDecimal(0), rowId, APFReadsPctId);
                    }
                    if (totIo > 0) {
                        calc = ((double)Writes + 0.0) / ((double)(Reads + Writes) + 0.0) * 100.0;
                        newVal = new BigDecimal(calc).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, WritesPctId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0), rowId, WritesPctId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_device_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMioQueueSumAct";
        displayName = "IO Sum";
        description = "<html><p>A <b>Summary</b> of how many IO's have the ASE Server done on various segments (UserDb/Tempdb/System)</p>For ASE 15.0.2 or so, we will have 'System' segment covered aswell.<br>Do not trust the service time <b>too</b> much...<br><br>Below is a table that describes how a fast or slow disk affects number of transactions per second.<br>The below description tries to exemplify number of transactions per seconds based on Disk IO responsiveness on the <b>LOG</b> Device.<br><TABLE ALIGN='left' BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH='100%'>   <TR ALIGN='left' VALIGN='left'> <TH>Device Type      </TH> <TH>Typical IOPS </TH> <TH>Typical ms/IO</TH> <TH>Xactn/Sec      </TH> </TR>   <!--                                    -----------------          -------------          -------------          --------------- -->  <TR ALIGN='left' VALIGN='left'> <TD>RAID 6           </TD> <TD>600          </TD> <TD>10-25        </TD> <TD>40-100         </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 5           </TD> <TD>800          </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 0 (RAID 10) </TD> <TD>1000         </TD> <TD>1-2          </TD> <TD>500-1000       </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>FC SCSI (tier 1) </TD> <TD>200-400      </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SAS SCSI (tier 2)</TD> <TD>150-200      </TD> <TD>4-8          </TD> <TD>125-250        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA (tier 3)    </TD> <TD>100-150      </TD> <TD>6-10         </TD> <TD>100-166        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA/SAS SSD     </TD> <TD>10000-20000  </TD> <TD>0.05-0.1     </TD> <TD>10,000-20,000  </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>PCIe SSD         </TD> <TD>100000-200000</TD> <TD>0.01-0.005   </TD> <TD>100,000-200,000</TD> </TR> </TABLE> The above table was found in the document: <br> http://www.sybase.com/detail?id=1091630<br>http://www.sybase.com/files/White_Papers/Managing-DBMS-Workloads-v1.0-WP.pdf<br></html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monIOQueue"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"IOs", "IOTime"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("IOType");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = -8676587973889879799L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                cols1 = "IOType, IOs        = sum(convert(numeric(18,0), IOs)), IOTime     = sum(convert(numeric(18,0), IOTime)), AvgServ_ms = \ncase \n  when sum(convert(numeric(18,0), IOs)) > 0 then convert(numeric(18,1), sum(convert(numeric(18,0), IOTime))/sum(convert(numeric(18,0), IOs))) \n  else                                           convert(numeric(18,1), null) \nend";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monIOQueue \n" + "group by IOType \n" + "order by 1\n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("diskIo".equals(tgdp.getName())) {
                    Double[] arr = new Double[]{this.getRateValue("User Data", "IOs"), this.getRateValue("User Log", "IOs"), this.getRateValue("Tempdb Data", "IOs"), this.getRateValue("Tempdb Log", "IOs"), this.getRateValue("System", "IOs")};
                    _logger.debug((Object)("updateGraphData(diskIo): User Data='" + arr[0] + "', User Log='" + arr[1] + "', Tempdb Data='" + arr[2] + "', Tempdb Log='" + arr[3] + "', System='" + arr[4] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int IOsId = -1;
                int IOTimeId = -1;
                int AvgServ_msId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("IOs")) {
                        IOsId = colId;
                        continue;
                    }
                    if (colName.equals("IOTime")) {
                        IOTimeId = colId;
                        continue;
                    }
                    if (!colName.equals("AvgServ_ms")) continue;
                    AvgServ_msId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    long IOs = ((Number)diffData.getValueAt(rowId, IOsId)).longValue();
                    long IOTime = ((Number)diffData.getValueAt(rowId, IOTimeId)).longValue();
                    if (IOs != 0L) {
                        double AvgServ_ms = IOTime / IOs;
                        BigDecimal newVal = new BigDecimal(AvgServ_ms).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, AvgServ_msId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0), rowId, AvgServ_msId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("diskIo", new TrendGraphDataPoint("diskIo", new String[]{"User Data", "User Log", "Tempdb Data", "Tempdb Log", "System"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_io_queue_sum_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("diskIo", "Disk IO", "Number of Disk IO Operations per Second", new String[]{"User Data", "User Log", "Tempdb Data", "Tempdb Log", "System"}, false, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMioQueueActivity";
        displayName = "IO Queue";
        description = "<html><p>How many IO's have the ASE Server done on various segments (UserDb/Tempdb/System) on specific devices.</p>For ASE 15.0.2 or so, we will have 'System' segment covered aswell.<br>Do not trust the service time <b>too</b> much...<br><br>Below is a table that describes how a fast or slow disk affects number of transactions per second.<br>The below description tries to exemplify number of transactions per seconds based on Disk IO responsiveness on the <b>LOG</b> Device.<br><TABLE ALIGN='left' BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH='100%'>   <TR ALIGN='left' VALIGN='left'> <TH>Device Type      </TH> <TH>Typical IOPS </TH> <TH>Typical ms/IO</TH> <TH>Xactn/Sec      </TH> </TR>   <!--                                    -----------------          -------------          -------------          --------------- -->  <TR ALIGN='left' VALIGN='left'> <TD>RAID 6           </TD> <TD>600          </TD> <TD>10-25        </TD> <TD>40-100         </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 5           </TD> <TD>800          </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>RAID 0 (RAID 10) </TD> <TD>1000         </TD> <TD>1-2          </TD> <TD>500-1000       </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>FC SCSI (tier 1) </TD> <TD>200-400      </TD> <TD>2-6          </TD> <TD>166-500        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SAS SCSI (tier 2)</TD> <TD>150-200      </TD> <TD>4-8          </TD> <TD>125-250        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA (tier 3)    </TD> <TD>100-150      </TD> <TD>6-10         </TD> <TD>100-166        </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>SATA/SAS SSD     </TD> <TD>10000-20000  </TD> <TD>0.05-0.1     </TD> <TD>10,000-20,000  </TD> </TR>   <TR ALIGN='left' VALIGN='left'> <TD>PCIe SSD         </TD> <TD>100000-200000</TD> <TD>0.01-0.005   </TD> <TD>100,000-200,000</TD> </TR> </TABLE> The above table was found in the document: <br> http://www.sybase.com/detail?id=1091630<br>http://www.sybase.com/files/White_Papers/Managing-DBMS-Workloads-v1.0-WP.pdf<br></html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monIOQueue"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"IOs", "IOTime"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("LogicalName");
        pkList.add("IOType");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 989816816267986305L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "LogicalName, IOType, IOs, IOTime, \nAvgServ_ms = \ncase \n  when IOs > 0 then convert(numeric(10,1), IOTime/convert(numeric(10,0),IOs)) \n  else               convert(numeric(10,1), null) \nend";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monIOQueue \n" + "order by LogicalName, IOType" + (this.isClusterEnabled() ? ", InstanceID" : "") + "\n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("devSvcTime".equals(tgdp.getName())) {
                    Double[] arr = new Double[]{this.getDiffValueMax("AvgServ_ms"), this.getDiffValueAvgGtZero("AvgServ_ms")};
                    _logger.debug((Object)("devSvcTime: MaxServiceTime=" + arr[0] + ", AvgServiceTime=" + arr[1] + "."));
                    _logger.debug((Object)("updateGraphData(devSvcTime): MaxServiceTime='" + arr[0] + "', AvgServiceTime='" + arr[1] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int IOsId = -1;
                int IOTimeId = -1;
                int AvgServ_msId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("IOs")) {
                        IOsId = colId;
                        continue;
                    }
                    if (colName.equals("IOTime")) {
                        IOTimeId = colId;
                        continue;
                    }
                    if (!colName.equals("AvgServ_ms")) continue;
                    AvgServ_msId = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    long IOs = ((Number)diffData.getValueAt(rowId, IOsId)).longValue();
                    long IOTime = ((Number)diffData.getValueAt(rowId, IOTimeId)).longValue();
                    if (IOs != 0L) {
                        double AvgServ_ms = IOTime / IOs;
                        BigDecimal newVal = new BigDecimal(AvgServ_ms).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, AvgServ_msId);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0), rowId, AvgServ_msId);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("devSvcTime", new TrendGraphDataPoint("devSvcTime", new String[]{"Max", "Average"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_io_queue_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("devSvcTime", "Device IO Service Time", "Device IO Service Time in Milliseconds", new String[]{"Max", "Average"}, false, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMspinlockSum";
        displayName = "Spinlock Sum";
        description = "<html><p>What spinlocks do we have contention on.</p>This could be a bit heavy to use when there is a 'low' refresh interwall.<br>For the moment considder this as <b>experimental</b>.</html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"sysmonitors"};
        needRole = new String[]{"sa_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"grabs", "waits", "spins"};
        colsCalcPCT = new String[]{"contention"};
        pkList = new LinkedList();
        pkList.add("name");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true, 300){
            private static final long serialVersionUID = -925512251960490929L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                if (this.isClusterEnabled()) {
                    this.getPk().add("instanceid");
                }
                String optGoalPlan = "";
                String datatype = "int";
                if (aseVersion >= 15000) {
                    datatype = "bigint";
                }
                if (aseVersion >= 15020) {
                    optGoalPlan = "plan '(use optgoal allrows_dss)' \n";
                }
                String sqlCreateTmpTabCache = "\n create table #spin_names     \n (                            \n   spin_name  varchar(50),    \n   spin_type  varchar(20),    \n   spin_desc  varchar(100),   \n   start_id   int             \n )                            \n \n/*------ DATA CACHES -------*/ \ninsert into #spin_names(spin_name, spin_type, spin_desc, start_id) \nselect comment, 'CACHELET', 'Data cache, spinlock instance', 0 \n  from master..syscurconfigs \n where config=19 and value > 0 \n\n/*------ SPINLOCK INSTANCES -------*/ \ninsert into #spin_names(spin_name, spin_type, spin_desc, start_id) \nvalues ('Kernel->erunqspinlock', 'KERNEL-INST', 'Engine Runqueue, spinlock instance', 0)\n\n/*------ SET start_id -------*/ \nupdate #spin_names \n   set start_id = (select min(M.field_id) \n                   from master..sysmonitors M\n                   where #spin_names.spin_name = M.field_name) \n\n";
                String sqlDropTmpTabCache = "\n drop table #spin_names \n";
                String sqlSampleSpins = "DBCC monitor('sample', 'all',        'on') \nDBCC monitor('sample', 'spinlock_s', 'on') \n\nSELECT \n  type         = \n    CASE \n      WHEN P.field_name like 'Dbtable->%'  THEN convert(varchar(20), 'DBTABLE')  \n      WHEN P.field_name like 'Dbt->%'      THEN convert(varchar(20), 'DBTABLE')  \n      WHEN P.field_name like 'Dbtable.%'   THEN convert(varchar(20), 'DBTABLE')  \n      WHEN P.field_name like 'Resource->%' THEN convert(varchar(20), 'RESOURCE') \n      WHEN P.field_name like 'Kernel->%'   THEN convert(varchar(20), 'KERNEL')   \n      WHEN P.field_name in (select spin_name from #spin_names where spin_type = 'CACHELET')   \n                                           THEN convert(varchar(20), 'CACHE') \n      ELSE convert(varchar(20), 'OTHER')  \n    END, \n" + (this.isClusterEnabled() ? "P.instanceid, \n" : "") + "  name         = convert(varchar(50), P.field_name), \n" + "  instances    = count(P.field_id), \n" + "  grabs        = sum(convert(" + datatype + ",P.value)), \n" + "  waits        = sum(convert(" + datatype + ",W.value)), \n" + "  spins        = sum(convert(" + datatype + ",S.value)), \n" + "  contention   = convert(numeric(4,1), null), \n" + "  spinsPerWait = convert(numeric(9,1), null), \n" + "  description  = convert(varchar(100), '') \n" + "FROM master..sysmonitors P, master..sysmonitors W, master..sysmonitors S \n" + "WHERE P.group_name = 'spinlock_p_0' \n" + "  AND W.group_name = 'spinlock_w_0' \n" + "  AND S.group_name = 'spinlock_s_0' \n" + "  AND P.field_id = W.field_id \n" + "  AND P.field_id = S.field_id \n";
                sqlSampleSpins = this.isClusterEnabled() ? sqlSampleSpins + "  AND P.instanceid = W.instanceid \n  AND P.instanceid = S.instanceid \nGROUP BY P.instanceid, P.field_name \nORDER BY 3, 2 \n" + optGoalPlan : sqlSampleSpins + "GROUP BY P.field_name \nORDER BY 2 \n" + optGoalPlan;
                String sqlForCaches = "SELECT \n  type         = N.spin_type, \n" + (this.isClusterEnabled() ? "P.instanceid, \n" : "") + "  name         = convert(varchar(50), convert(varchar(40),P.field_name) + ' # ' + convert(varchar(5), P.field_id-N.start_id)), \n" + "  instances    = convert(int,1), \n" + "  grabs        = convert(" + datatype + ",P.value), \n" + "  waits        = convert(" + datatype + ",W.value), \n" + "  spins        = convert(" + datatype + ",S.value), \n" + "  contention   = convert(numeric(4,1), null), \n" + "  spinsPerWait = convert(numeric(9,1), null), \n" + "  description  = N.spin_desc \n" + "FROM master..sysmonitors P, master..sysmonitors W, master..sysmonitors S, #spin_names N \n" + "WHERE P.group_name = 'spinlock_p_0' \n" + "  AND W.group_name = 'spinlock_w_0' \n" + "  AND S.group_name = 'spinlock_s_0' \n" + "  AND P.field_id = W.field_id \n" + "  AND P.field_id = S.field_id \n" + "  AND P.field_name = N.spin_name \n";
                sqlForCaches = this.isClusterEnabled() ? sqlForCaches + "  AND P.instanceid = W.instanceid \n  AND P.instanceid = S.instanceid \nORDER BY 3, 2 \n" + optGoalPlan : sqlForCaches + "ORDER BY 2 \n" + optGoalPlan;
                this.setSql(sqlCreateTmpTabCache + sqlSampleSpins + sqlForCaches + sqlDropTmpTabCache);
                String sqlInit = "DBCC traceon(3604) \n";
                if (aseVersion < 12520) {
                    sqlInit = sqlInit + "DBCC traceon(8399) \n";
                }
                if (aseVersion >= 15020 || aseVersion >= 12541 && aseVersion <= 15000) {
                    sqlInit = "set switch on 3604 with no_info \n";
                }
                sqlInit = sqlInit + "DBCC monitor('select', 'all',        'on') \nDBCC monitor('select', 'spinlock_s', 'on') \n";
                this.setSqlInit(sqlInit);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                int grabsId = -1;
                int waitsId = -1;
                int spinsId = -1;
                int contentionId = -1;
                int spinsPerWaitId = -1;
                int pos_name = -1;
                int pos_desc = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("grabs")) {
                        grabsId = colId;
                        continue;
                    }
                    if (colName.equals("waits")) {
                        waitsId = colId;
                        continue;
                    }
                    if (colName.equals("spins")) {
                        spinsId = colId;
                        continue;
                    }
                    if (colName.equals("contention")) {
                        contentionId = colId;
                        continue;
                    }
                    if (colName.equals("spinsPerWait")) {
                        spinsPerWaitId = colId;
                        continue;
                    }
                    if (colName.equals("name")) {
                        pos_name = colId;
                        continue;
                    }
                    if (!colName.equals("description")) continue;
                    pos_desc = colId;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    String name;
                    String desc;
                    Object o;
                    long grabs = ((Number)diffData.getValueAt(rowId, grabsId)).longValue();
                    long waits = ((Number)diffData.getValueAt(rowId, waitsId)).longValue();
                    long spins = ((Number)diffData.getValueAt(rowId, spinsId)).longValue();
                    if (grabs > 0L) {
                        BigDecimal contention = new BigDecimal(1.0 * (double)waits / (double)grabs * 100.0).setScale(1, 6);
                        diffData.setValueAt(contention, rowId, contentionId);
                    } else {
                        diffData.setValueAt(new BigDecimal(0), rowId, contentionId);
                    }
                    if (waits > 0L) {
                        BigDecimal spinWarning = new BigDecimal(1.0 * (double)spins / (double)waits).setScale(1, 6);
                        diffData.setValueAt(spinWarning, rowId, spinsPerWaitId);
                    } else {
                        diffData.setValueAt(new BigDecimal(0), rowId, spinsPerWaitId);
                    }
                    if (mtd == null || pos_name < 0 || pos_desc < 0 || !((o = diffData.getValueAt(rowId, pos_name)) instanceof String) || (desc = mtd.getSpinlockDescription(name = (String)o)) == null) continue;
                    newSample.setValueAt(desc, rowId, pos_desc);
                    diffData.setValueAt(desc, rowId, pos_desc);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_spinlock_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMsysmon";
        displayName = "Sysmon Raw";
        description = "<html><p>Just grabs the raw counters used in sp_sysmon.</p>NOTE: reuses data from 'Spinlock Sum', so this needs to be running as well.<br>For the moment consider this as <b>very experimental</b>.</html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"sysmonitors"};
        needRole = new String[]{"sa_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"value"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("field_name");
        pkList.add("group_name");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true, 300){
            private static final long serialVersionUID = -925512251960490929L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                if (this.isClusterEnabled()) {
                    this.getPk().add("instanceid");
                }
                String optGoalPlan = "";
                if (aseVersion >= 15020) {
                    optGoalPlan = "plan '(use optgoal allrows_dss)' \n";
                }
                String sql = "SELECT \n" + (this.isClusterEnabled() ? "instanceid, \n" : "") + "  field_name = convert(varchar(100),field_name), \n" + "  group_name = convert(varchar(30),group_name), \n" + "  field_id, \n" + "  value, \n" + "  description  = convert(varchar(255), description) \n" + "FROM master..sysmonitors \n" + "WHERE group_name not in ('spinlock_p_0', 'spinlock_w_0', 'spinlock_s_0') \n" + "  AND value > 100 \n" + "ORDER BY group_name, field_name" + (this.isClusterEnabled() ? ", instanceid" : "") + "\n" + optGoalPlan;
                this.setSql(sql);
            }
        };
        tmp.addDependsOnCm("CMspinlockSum");
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_sysmon_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMrepAgent";
        displayName = "RepAgent";
        description = "<html><p>Grabs the raw counters for RepAgents from sysmonitors.</p>NOTE: reuses data from 'Spinlock Sum', so this needs to be running as well.<br>For the moment consider this as <b>very experimental</b>.</html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 12540;
        needCeVersion = 0;
        monTables = new String[]{"sysmonitors"};
        needRole = new String[]{"sa_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"value", "log_waits", "sum_log_wait", "longest_log_wait", "truncpt_moved", "truncpt_gotten", "rs_connect", "fail_rs_connect", "io_send", "sum_io_send_wait", "longest_io_send_wait", "io_recv", "sum_io_recv_wait", "longest_io_recv_wait", "packets_sent", "full_packets_sent", "sum_packet", "largest_packet", "log_records_scanned", "log_records_processed", "log_scans", "sum_log_scan", "longest_log_scan", "open_xact", "maintuser_xact", "commit_xact", "abort_xact", "prepare_xact", "xupdate_processed", "xinsert_processed", "xdelete_processed", "xexec_processed", "xcmdtext_processed", "xwrtext_processed", "xrowimage_processed", "xclr_processed", "xckpt_processed", "xckpt_genxactpurge", "sqldml_processed", "bckward_schema", "sum_bckward_wait", "longest_bckward_wait", "forward_schema", "sum_forward_wait", "longest_forward_wait", "delayed_commit_xact", "schema_reuse"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("dbname");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true, 300){
            private static final long serialVersionUID = -925512251960490929L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("sysmonitors", "value", "<html>The Counter value for this raw counter name.</html>");
                    mtd.addColumn("sysmonitors", "log_waits", "<html>Log Extension Wait:                Count</html>");
                    mtd.addColumn("sysmonitors", "sum_log_wait", "<html>Log Extension Wait:                Amount of time (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_log_wait", "<html>Log Extension Wait:                Longest Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "truncpt_moved", "<html>Truncation Point Movement:         Moved</html>");
                    mtd.addColumn("sysmonitors", "truncpt_gotten", "<html>Truncation Point Movement:         Gotten from RS</html>");
                    mtd.addColumn("sysmonitors", "rs_connect", "<html>Connections to Replication Server: Success</html>");
                    mtd.addColumn("sysmonitors", "fail_rs_connect", "<html>Connections to Replication Server: Failed</html>");
                    mtd.addColumn("sysmonitors", "io_send", "<html>I/O Wait from RS:                  Send, Count</html>");
                    mtd.addColumn("sysmonitors", "sum_io_send_wait", "<html>I/O Wait from RS:                  Send, Amount of Time (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_io_send_wait", "<html>I/O Wait from RS:                  Send, Longest Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "io_recv", "<html>I/O Wait from RS:                  Receive, Count</html>");
                    mtd.addColumn("sysmonitors", "sum_io_recv_wait", "<html>I/O Wait from RS:                  Receive, Amount of Time (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_io_recv_wait", "<html>I/O Wait from RS:                  Receive, Longest Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "packets_sent", "<html>Network Packet Information:        Packets Sent</html>");
                    mtd.addColumn("sysmonitors", "full_packets_sent", "<html>Network Packet Information:        Full Packets Sent</html>");
                    mtd.addColumn("sysmonitors", "sum_packet", "<html>Network Packet Information:        Amount of Bytes Sent</html>");
                    mtd.addColumn("sysmonitors", "largest_packet", "<html>Network Packet Information:        Largest Packet</html>");
                    mtd.addColumn("sysmonitors", "log_records_scanned", "<html>Log Scan Summary:                  Log Records Scanned</html>");
                    mtd.addColumn("sysmonitors", "log_records_processed", "<html>Log Scan Summary:                  Log Records Processed</html>");
                    mtd.addColumn("sysmonitors", "log_scans", "<html>Log Scan Summary:                  Number of Log Scans</html>");
                    mtd.addColumn("sysmonitors", "sum_log_scan", "<html>Log Scan Summary:                  Amount of Time for Log Scans (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_log_scan", "<html>Log Scan Summary:                  Longest Time for Log Scan (ms)</html>");
                    mtd.addColumn("sysmonitors", "open_xact", "<html>Transaction Activity:              Opened</html>");
                    mtd.addColumn("sysmonitors", "maintuser_xact", "<html>Transaction Activity:              Maintenance User</html>");
                    mtd.addColumn("sysmonitors", "commit_xact", "<html>Transaction Activity:              Commited</html>");
                    mtd.addColumn("sysmonitors", "abort_xact", "<html>Transaction Activity:              Aborted</html>");
                    mtd.addColumn("sysmonitors", "prepare_xact", "<html>Transaction Activity:              Prepared</html>");
                    mtd.addColumn("sysmonitors", "delayed_commit_xact", "<html>Transaction Activity:              Delayed Commit</html>");
                    mtd.addColumn("sysmonitors", "xupdate_processed", "<html>Log Scan Activity:                 Updates</html>");
                    mtd.addColumn("sysmonitors", "xinsert_processed", "<html>Log Scan Activity:                 Inserts</html>");
                    mtd.addColumn("sysmonitors", "xdelete_processed", "<html>Log Scan Activity:                 Deletes</html>");
                    mtd.addColumn("sysmonitors", "xexec_processed", "<html>Log Scan Activity:                 Store Procedures</html>");
                    mtd.addColumn("sysmonitors", "xcmdtext_processed", "<html>Log Scan Activity:                 DDL Log Records</html>");
                    mtd.addColumn("sysmonitors", "xwrtext_processed", "<html>Log Scan Activity:                 Writetext Log Records</html>");
                    mtd.addColumn("sysmonitors", "xrowimage_processed", "<html>Log Scan Activity:                 Text/Image Log Records</html>");
                    mtd.addColumn("sysmonitors", "xclr_processed", "<html>Log Scan Activity:                 CLRs</html>");
                    mtd.addColumn("sysmonitors", "xckpt_processed", "<html>Log Scan Activity:                 Checkpoints Processed</html>");
                    mtd.addColumn("sysmonitors", "xckpt_genxactpurge", "<html>Log Scan Activity:                 </html>");
                    mtd.addColumn("sysmonitors", "sqldml_processed", "<html>Log Scan Activity:                 SQL Statements Processed</html>");
                    mtd.addColumn("sysmonitors", "bckward_schema", "<html>Backward Schema Lookups:           Count</html>");
                    mtd.addColumn("sysmonitors", "sum_bckward_wait", "<html>Backward Schema Lookups:           Total Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_bckward_wait", "<html>Backward Schema Lookups:           Longest Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "forward_schema", "<html>Schema Cache:                      Count</html>");
                    mtd.addColumn("sysmonitors", "sum_forward_wait", "<html>Schema Cache:                      Total Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "longest_forward_wait", "<html>Schema Cache:                      Longest Wait (ms)</html>");
                    mtd.addColumn("sysmonitors", "schema_reuse", "<html>Schema Cache:                      Schemas reused</html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                String sql = "exec sp_asemon_ra_stats ";
                this.setSql(sql);
            }
        };
        tmp.addDependsOnStoredProc("sybsystemprocs", "sp_asemon_ra_stats", VersionInfo.SP_ASEMON_RA_STATS_CRDATE, VersionInfo.class, "sp_asemon_ra_stats.sql", "sa_role");
        tmp.addDependsOnCm("CMspinlockSum");
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_repagent_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMcachedProcs";
        displayName = "Cached Procedures";
        description = "What Objects is located in the 'procedure cache'.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monCachedProcedures"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"per object statistics active=1"};
        colsCalcDiff = new String[]{"RequestCnt", "TempdbRemapCnt"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("PlanID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 7929613701950650791L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "PlanID, DBName, ObjectName, ObjectType, MemUsageKB, CompileDate";
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                if (aseVersion >= 15500 || aseVersion >= 15030 && this.isClusterEnabled()) {
                    cols2 = cols2 + ", RequestCnt, TempdbRemapCnt, AvgTempdbRemapTime";
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monCachedProcedures \n" + "order by DBName, ObjectName, ObjectType\n";
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_cached_procedures_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("stored procedure")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_procedure.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("trigger")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_trigger.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("view")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_view.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("default value spec")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_default_value.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("rule")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_rule.png")));
        }
        _CMList.add(tmp);
        name = "CMprocCache";
        displayName = "Procedure Cache";
        description = "This is just a short one to see if we have 'stored procedure' swapping for some reason. The reason is for the moment not known.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monProcedureCache"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1"};
        colsCalcDiff = new String[]{"Requests", "Loads", "Writes", "Stalls"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = -6467250604457739178L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                cols2 = cols2 + "Requests, Loads, Writes, Stalls";
                if (this.isClusterEnabled()) {
                    cols1 = "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                if (aseVersion >= 15010 || aseVersion < 12540 || aseVersion <= 15000) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcedureCache \n";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("ProcCacheGraph".equals(tgdp.getName())) {
                    Double[] arr = new Double[]{this.getRateValueSum("Requests"), this.getRateValueSum("Loads")};
                    _logger.debug((Object)("updateGraphData(ProcCacheGraph): Requests='" + arr[0] + "', Loads='" + arr[1] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("ProcCacheGraph", new TrendGraphDataPoint("ProcCacheGraph", new String[]{"Requests", "Loads"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_procedure_cache_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("ProcCacheGraph", "Procedure Cache Requests", "Number of Procedure Requests per Second (procs,triggers,views)", new String[]{"Requests", "Loads"}, false, tmp, true, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMprocCallStack";
        displayName = "Procedure Call Stack";
        description = "Nesting levels of currenty executed procedures, this can be used as a light 'profiler'";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monProcessProcedures"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{};
        colsCalcPCT = new String[]{};
        pkList = null;
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 7929613701950650791L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                String InstanceID = "";
                String StatementNumber = "";
                String LineNumber = "";
                if (this.isClusterEnabled()) {
                    InstanceID = "InstanceID, ";
                }
                if (aseVersion >= 12530) {
                    LineNumber = "LineNumber, ";
                }
                if (aseVersion >= 15025) {
                    StatementNumber = "StatementNumber, ";
                }
                cols1 = cols1 + "SPID, " + InstanceID + "DBName, OwnerName, ObjectName, " + LineNumber + StatementNumber + "ContextID, ObjectType, " + "PlanID, MemUsageKB, CompileDate, KPID, DBID, OwnerUID, ObjectID, " + "MaxContextID = convert(int, -1)";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcessProcedures o\n" + "order by SPID, ContextID desc\n" + "";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                Object o_SPID;
                int rowId;
                int pos_SPID = -1;
                int pos_MaxContextID = -1;
                int pos_ContextID = -1;
                List<String> colNames = newSample.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("SPID")) {
                        pos_SPID = colId;
                    } else if (colName.equals("ContextID")) {
                        pos_ContextID = colId;
                    } else if (colName.equals("MaxContextID")) {
                        pos_MaxContextID = colId;
                    }
                    if (pos_SPID >= 0 && pos_ContextID >= 0 && pos_MaxContextID >= 0) break;
                }
                if (pos_SPID < 0 || pos_ContextID < 0 || pos_MaxContextID < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('SPID'" + pos_SPID + ", 'ContextID'=" + pos_ContextID + ", 'MaxContextID'=" + pos_MaxContextID + ")"));
                    return;
                }
                HashMap<Integer, Integer> _maxContextIdPerSpid = new HashMap<Integer, Integer>();
                for (rowId = 0; rowId < newSample.getRowCount(); ++rowId) {
                    o_SPID = newSample.getValueAt(rowId, pos_SPID);
                    Object o_ContextID = newSample.getValueAt(rowId, pos_ContextID);
                    if (!(o_SPID instanceof Number) || !(o_ContextID instanceof Number)) continue;
                    Integer spid = (Integer)o_SPID;
                    Integer contextId = (Integer)o_ContextID;
                    Integer maxContextId = (Integer)_maxContextIdPerSpid.get(spid);
                    if (maxContextId == null) {
                        maxContextId = 0;
                    }
                    _maxContextIdPerSpid.put(spid, Math.max(contextId, maxContextId));
                }
                for (rowId = 0; rowId < newSample.getRowCount(); ++rowId) {
                    o_SPID = newSample.getValueAt(rowId, pos_SPID);
                    if (!(o_SPID instanceof Number)) continue;
                    Integer spid = (Integer)o_SPID;
                    Integer maxContextId = (Integer)_maxContextIdPerSpid.get(spid);
                    newSample.setValueAt(maxContextId, rowId, pos_MaxContextID);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_procedure_call_stack_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>GREEN - Procedure/Trigger/View that is currently executing (end of the stack).</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.xxxxxxxxxx");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String maxContextID = adapter.getString(adapter.getColumnIndex((Object)"MaxContextID"));
                    String contextID = adapter.getString(adapter.getColumnIndex((Object)"ContextID"));
                    if (maxContextID != null) {
                        maxContextID = maxContextID.trim();
                    }
                    if (contextID != null) {
                        contextID = contextID.trim();
                    }
                    return maxContextID != null && contextID != null && maxContextID.equals(contextID);
                }
            }, SwingUtils.parseColor(colorStr, Color.GREEN), null));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("stored procedure")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_procedure.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("trigger")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_trigger.png")));
            tcp2.addHighlighter((Highlighter)new IconHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    int modelCol = adapter.getColumnIndex((Object)"ObjectType");
                    if (modelCol == adapter.convertColumnIndexToModel(adapter.column)) {
                        String objectType = adapter.getString(modelCol);
                        if (objectType != null) {
                            objectType = objectType.trim();
                        }
                        if (objectType.startsWith("view")) {
                            return true;
                        }
                    }
                    return false;
                }
            }, (Icon)SwingUtils.readImageIcon(Version.class, "images/highlighter_view.png")));
        }
        _CMList.add(tmp);
        name = "CMcachedObjects";
        displayName = "Cached Objects";
        description = "";
        description = "<html><p>What Tables is located in the 'data cache' and to what cache is it bound?</p><b>This could be a bit heavy to sample, so use with caution.</b><br>Tip:<br>- Use ABSolute counter values to check how many MB the table are using.- Use Diff or Rate to check if the memory print is increasing or decreasing.<br>- Use the checkpox 'Pause Data Polling' wait for a minute, then enable polling again, that will give you a longer sample period!</html>";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monCachedObject"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"CachedKB", "TotalSizeKB"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("DBID");
        pkList.add("ObjectID");
        pkList.add("IndexID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = 1725558024113511209L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                cols1 = cols1 + "DBID, ObjectID, IndexID, DBName,  ObjectName, ObjectType, ";
                cols2 = cols2 + "";
                cols3 = cols3 + "CachedKB, CacheName";
                if (aseVersion >= 15000) {
                    cols2 = cols2 + "PartitionID, PartitionName, TotalSizeKB, ";
                    this.getPk().add("PartitionID");
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monCachedObject \n" + "order by DBName,  ObjectName";
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (tmp.getPostponeTime() == 0) {
            tmp.setPostponeTime(600, false);
        }
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_objects_in_cache_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>ORANGE - An Index.</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.index");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number indexId = (Number)adapter.getValue(adapter.getColumnIndex((Object)"IndexID"));
                    return indexId != null && indexId.intValue() > 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.ORANGE), null));
        }
        _CMList.add(tmp);
        name = "CMerrolog";
        displayName = "Errorlog";
        description = "Look at the ASE Servers errorlog.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monErrorLog"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "errorlog pipe active=1", "errorlog pipe max=200"};
        tmp = new CountersModelAppend(name, null, monTables, needRole, needConfig, needVersion, needCeVersion, true){
            private static final long serialVersionUID = 1227895347277630659L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                String instanceId = "";
                if (this.isClusterEnabled()) {
                    instanceId = "InstanceID, ";
                }
                cols1 = "Time, " + instanceId + "SPID, KPID, FamilyID, EngineNumber, ErrorNumber, Severity, ";
                cols2 = "";
                cols3 = "ErrorMessage";
                if (aseVersion >= 12510) {
                    cols2 = "State, ";
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monErrorLog\n";
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_errorlog_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMdeadlock";
        displayName = "Deadlock";
        description = "Have we had any deadlocks in the system?";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monDeadLock"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "deadlock pipe active=1", "deadlock pipe max=500"};
        tmp = new CountersModelAppend(name, null, monTables, needRole, needConfig, needVersion, needCeVersion, true){
            private static final long serialVersionUID = -5448698796472216270L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                cols1 = "*";
                cols2 = "";
                cols3 = "";
                if (aseVersion >= 15020) {
                    // empty if block
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monDeadLock\n";
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_deadlock_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMpCacheModuleUsage";
        displayName = "Proc Cache Module Usage";
        description = "What module of the ASE Server is using the 'procedure cache' or 'dynamic memory pool'";
        needVersion = 15010;
        needCeVersion = 0;
        monTables = new String[]{"monProcedureCacheModuleUsage"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"ActiveDiff", "NumPagesReused"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("ModuleID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -2606894492200318775L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String instanceId = "";
                if (this.isClusterEnabled() && aseVersion >= 15500) {
                    instanceId = "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                String sql = "select " + instanceId + "ModuleName, ModuleID, Active, ActiveDiff = Active, HWM, NumPagesReused \n" + "from monProcedureCacheModuleUsage\n" + "order by ModuleID";
                this.setSql(sql);
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("ProcCacheModuleUsageGraph".equals(tgdp.getName())) {
                    Double[] dArray = new Double[this.size()];
                    String[] lArray = new String[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        lArray[i] = this.getAbsString(i, "ModuleName");
                        dArray[i] = this.getAbsValueAsDouble(i, "Active");
                    }
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setLabel(lArray);
                    tgdp.setData(dArray);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("ProcCacheModuleUsageGraph", new TrendGraphDataPoint("ProcCacheModuleUsageGraph", new String[]{"runtime-replaced"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_proc_cache_module_usage.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("ProcCacheModuleUsageGraph", "Procedure Cache Module Usage", "Procedure Cache Module Usage (in page count)", new String[]{"runtime-replaced"}, false, tmp, false, 300);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMpCacheMemoryUsage";
        displayName = "Proc Cache Memory Usage";
        description = "What module and what 'part' of the modules are using the 'procedure cache' or 'dynamic memory pool'.";
        needVersion = 15010;
        needCeVersion = 0;
        monTables = new String[]{"monProcedureCacheMemoryUsage", "monProcedureCacheModuleUsage"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{"ActiveDiff", "NumReuseCaused"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("AllocatorID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -5474676196893459453L;

            @Override
            public void initSql(Connection conn) {
                int aseVersion = this.getServerVersion();
                String optGoalPlan = "";
                if (aseVersion >= 15020) {
                    optGoalPlan = "plan '(use optgoal allrows_dss)' \n";
                }
                String instanceId = "";
                String instanceIdJoin = "";
                if (this.isClusterEnabled() && aseVersion >= 15500) {
                    instanceId = "C.InstanceID, ";
                    instanceIdJoin = "  and C.InstanceID = M.InstanceID \n";
                    this.getPk().add("InstanceID");
                }
                String sql = "select M.ModuleName, " + instanceId + "C.ModuleID, C.AllocatorName, C.AllocatorID, C.Active, ActiveDiff = C.Active, C.HWM, C.ChunkHWM, C.NumReuseCaused \n" + "from monProcedureCacheMemoryUsage C, monProcedureCacheModuleUsage M \n" + "where C.ModuleID = M.ModuleID \n" + instanceIdJoin + "order by C.ModuleID, C.AllocatorID \n" + optGoalPlan;
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_proc_cache_memory_usage.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMstatementCache";
        displayName = "Statement Cache";
        description = "FIXME";
        needVersion = 15020;
        needCeVersion = 0;
        monTables = new String[]{"monStatementCache"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "enable stmt cache monitoring=1", "statement cache size"};
        colsCalcDiff = new String[]{"NumStatementsDiff", "NumSearches", "HitCount", "NumInserts", "NumRemovals", "NumRecompilesSchemaChanges", "NumRecompilesPlanFlushes"};
        colsCalcPCT = new String[]{"CacheHitPct", "OveralAvgReusePct"};
        pkList = new LinkedList();
        pkList.add("TotalSizeKB");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -9084781196460687664L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monStatementCache", "UnusedSizeKB", "<html>Number of KB that is free for usage by any statement.<br><b>Formula</b>: abs.TotalSizeKB - abs.UsedSizeKB<br></html>");
                    mtd.addColumn("monStatementCache", "AvgStmntSizeInKB", "<html>Average KB that each compiled SQL Statement are using.<br><b>Formula</b>: abs.UsedSizeKB / abs.NumStatements<br></html>");
                    mtd.addColumn("monStatementCache", "NumStatementsDiff", "<html>Simply the difference count from previous sample of 'NumStatements'.<br><b>Formula</b>: this.NumStatements - previous.NumStatements<br></html>");
                    mtd.addColumn("monStatementCache", "CacheHitPct", "<html>Percent of Statements that already was in the Statement Cache<br><b>Formula</b>: diff.HitCount / diff.NumSearches * 100 <br></html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                if (this.isClusterEnabled()) {
                    this.getPk().add("InstanceID");
                }
                String sql = "SELECT \n" + (this.isClusterEnabled() ? "  InstanceID, \n" : "") + "  TotalSizeKB, \n" + "  UsedSizeKB, \n" + "  UnusedSizeKB      = TotalSizeKB - UsedSizeKB, \n" + "  AvgStmntSizeInKB  = UsedSizeKB / NumStatements, \n" + "  NumStatements, \n" + "  NumStatementsDiff = NumStatements, \n" + "  CacheHitPct       = CASE WHEN NumSearches  >0 THEN convert(numeric(10,1), ((HitCount+0.0)/(NumSearches+0.0))  *100.0 ) ELSE convert(numeric(10,1), 0) END, \n" + "  NumSearches, \n" + "  HitCount, \n" + "  NumInserts, \n" + "  NumRemovals, \n" + "  NumRecompilesSchemaChanges, \n" + "  NumRecompilesPlanFlushes \n" + "FROM monStatementCache \n";
                this.setSql(sql);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                int CacheHitPctId = -1;
                int OveralAvgReusePctId = -1;
                int HitCountId = -1;
                int NumSearchesId = -1;
                List<String> colNames = diffData.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("HitCount")) {
                        HitCountId = colId;
                    } else if (colName.equals("NumSearches")) {
                        NumSearchesId = colId;
                    } else if (colName.equals("CacheHitPct")) {
                        CacheHitPctId = colId;
                    } else if (colName.equals("OveralAvgReusePct")) {
                        OveralAvgReusePctId = colId;
                    }
                    if (HitCountId >= 0 && NumSearchesId >= 0 && CacheHitPctId >= 0 && OveralAvgReusePctId >= 0) break;
                }
                for (int rowId = 0; rowId < diffData.getRowCount(); ++rowId) {
                    int HitCount = ((Number)diffData.getValueAt(rowId, HitCountId)).intValue();
                    int NumSearches = ((Number)diffData.getValueAt(rowId, NumSearchesId)).intValue();
                    int colPos = CacheHitPctId;
                    if (NumSearches > 0) {
                        double calc = ((double)HitCount + 0.0) / ((double)NumSearches + 0.0) * 100.0;
                        BigDecimal newVal = new BigDecimal(calc).setScale(1, 6);
                        diffData.setValueAt(newVal, rowId, colPos);
                        continue;
                    }
                    diffData.setValueAt(new BigDecimal(0).setScale(1, 6), rowId, colPos);
                }
            }

            @Override
            public void updateGraphData(TrendGraphDataPoint tgdp) {
                if ("StatementCacheGraph".equals(tgdp.getName())) {
                    Double[] arr = new Double[4];
                    arr[0] = this.getRateValueSum("NumSearches");
                    arr[1] = this.getRateValueSum("HitCount");
                    arr[1] = this.getRateValueSum("NumInserts");
                    arr[1] = this.getRateValueSum("NumRemovals");
                    _logger.debug((Object)("updateGraphData(StatementCacheGraph): NumSearches='" + arr[0] + "', HitCount='" + arr[1] + "', NumInserts='" + arr[2] + "', NumRemovals='" + arr[3] + "'."));
                    tgdp.setDate(this.getTimestamp());
                    tgdp.setData(arr);
                }
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        tmp.addTrendGraphData("StatementCacheGraph", new TrendGraphDataPoint("StatementCacheGraph", new String[]{"NumSearches", "HitCount", "NumInserts", "NumRemovals"}));
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_statement_cache_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tg = new TrendGraph("StatementCacheGraph", "Statement Cache Requests", "Number of Requests from the Statement Cache, per Second", new String[]{"NumSearches", "HitCount", "NumInserts", "NumRemovals"}, false, tmp, false, -1);
            tmp.addTrendGraph(tg.getName(), tg, true);
        }
        _CMList.add(tmp);
        name = "CMstmntCacheDetails";
        displayName = "Statement Cache Details";
        description = "FIXME";
        needVersion = 15020;
        needCeVersion = 0;
        monTables = new String[]{"monCachedStatement"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "enable stmt cache monitoring=1", "statement cache size"};
        colsCalcDiff = new String[]{"UseCountDiff", "NumRecompilesPlanFlushes", "NumRecompilesSchemaChanges"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("SSQLID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -1842749890597642593L;

            @Override
            protected CmSybMessageHandler createSybMessageHandler() {
                CmSybMessageHandler msgHandler = super.createSybMessageHandler();
                msgHandler.addDiscardMsgNum(11096);
                return msgHandler;
            }

            @Override
            public void initSql(Connection conn) {
                try {
                    String showplanTooltip = "<html>The execution plan this SQL statement has.<br><b>Formula</b>: show_plan(-1,SSQLID,-1,-1)<br><b>Note</b>: It is possible for a single entry in the statement cache to be associated with multiple, and possibly different, SQL plans. <b>show_plan</b> displays only one of them.</html>";
                    String sqltextTooltip = "<html>SQL Statement that is assigned to the SSQLID.<br><b>Formula</b>: show_cached_text(SSQLID)<br></html>";
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monCachedStatement", "msgAsColValue", showplanTooltip);
                    mtd.addColumn("monCachedStatement", "HasShowplan", showplanTooltip);
                    mtd.addColumn("monCachedStatement", "sqltext", sqltextTooltip);
                    mtd.addColumn("monCachedStatement", "HasSqltext", sqltextTooltip);
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                if (this.isClusterEnabled()) {
                    this.getPk().add("InstanceID");
                }
                String sql = "SELECT \n" + (this.isClusterEnabled() ? " InstanceID, \n" : "") + " DBID, \n" + (aseVersion >= 15024 ? " DBName, \n" : "DBName = db_name(DBID), \n") + " UserID, SUserID, SUserName = suser_name(SUserID), \n" + " SSQLID, \n" + " Hashkey, \n" + " HasShowplan   = RUNTIME_REPLACE::HAS_SHOWPLAN, \n" + " HasSqltext    = RUNTIME_REPLACE::HAS_SQL_TEXT, \n" + " UseCount, \n" + " UseCountDiff = UseCount, \n" + " MetricsCount, \n" + " MaxElapsedTime, MinElapsedTime, AvgElapsedTime, \n" + " MaxLIO,         MinLIO,         AvgLIO, \n" + " MaxPIO,         MinPIO,         AvgPIO, \n" + " MaxCpuTime,     MinCpuTime,     AvgCpuTime, \n" + " LastUsedDate, \n" + " LastRecompiledDate, \n" + " CachedDate, \n" + " MinPlanSizeKB, \n" + " MaxPlanSizeKB, \n" + " CurrentUsageCount, \n" + " MaxUsageCount, \n" + " NumRecompilesSchemaChanges, \n" + " NumRecompilesPlanFlushes, \n" + " HasAutoParams       = convert(bit,HasAutoParams), " + " ParallelDegree, " + " QuotedIdentifier    = convert(bit,QuotedIdentifier), " + (aseVersion < 15026 ? " TableCount, " : "") + " TransactionIsolationLevel, " + " TransactionMode, " + " SAAuthorization     = convert(bit,SAAuthorization), " + " SystemCatalogUpdate = convert(bit,SystemCatalogUpdate), \n" + " StatementSize, \n" + " sqltext       = RUNTIME_REPLACE::DO_SQL_TEXT, \n" + " msgAsColValue = RUNTIME_REPLACE::DO_SHOWPLAN \n" + "FROM monCachedStatement \n";
                this.setSql(sql);
            }

            @Override
            public String getSql() {
                String sql = super.getSql();
                Configuration conf = Configuration.getCombinedConfiguration();
                boolean sampleSqlText_chk = conf == null ? true : conf.getBooleanProperty("CMstmntCacheDetails.sample.sqlText", true);
                boolean sampleShowplan_chk = conf == null ? true : conf.getBooleanProperty("CMstmntCacheDetails.sample.showplan", true);
                String hasSqlText = "convert(bit,1)";
                String doSqltext = "convert(text, show_cached_text(SSQLID))";
                if (!sampleSqlText_chk) {
                    hasSqlText = "convert(bit,0)";
                    doSqltext = "convert(text, 'CMstmntCacheDetails.sample.sqlText=false')";
                }
                sql = sql.replace("RUNTIME_REPLACE::HAS_SQL_TEXT", hasSqlText);
                sql = sql.replace("RUNTIME_REPLACE::DO_SQL_TEXT", doSqltext);
                String hasShowplan = "CASE WHEN show_plan(-1,SSQLID,-1,-1) < 0 THEN convert(bit,0) ELSE convert(bit,1) END";
                String doShowplan = "convert(text, '')";
                if (!sampleShowplan_chk) {
                    hasShowplan = "convert(bit,0)";
                    doShowplan = "convert(text, 'CMstmntCacheDetails.sample.showplan=false')";
                }
                sql = sql.replace("RUNTIME_REPLACE::HAS_SHOWPLAN", hasShowplan);
                sql = sql.replace("RUNTIME_REPLACE::DO_SHOWPLAN", doShowplan);
                return sql;
            }

            @Override
            public String getToolTipTextOnTableCell(MouseEvent e, String colName, Object cellValue, int modelRow, int modelCol) {
                int pos_sqltext;
                Object cellVal;
                int pos_showplanText;
                if (("HasShowplan".equals(colName) || "msgAsColValue".equals(colName)) && (pos_showplanText = this.findColumn("msgAsColValue")) > 0 && (cellVal = this.getValueAt(modelRow, pos_showplanText)) instanceof String) {
                    return this.toHtmlString((String)cellVal);
                }
                if (("HasSqltext".equals(colName) || "sqltext".equals(colName)) && (pos_sqltext = this.findColumn("sqltext")) > 0 && (cellVal = this.getValueAt(modelRow, pos_sqltext)) instanceof String) {
                    return this.toHtmlString((String)cellVal);
                }
                return super.getToolTipTextOnTableCell(e, colName, cellValue, modelRow, modelCol);
            }

            private String toHtmlString(String in) {
                String str = StringUtil.makeApproxLineBreak(in, 100, 5, "\n");
                str = str.replaceAll("\\n", "<br>");
                return "<html><pre>" + str + "</pre></html>";
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            final String localName = name;
            tcp = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Local Options", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
                    Configuration conf = Configuration.getCombinedConfiguration();
                    JCheckBox sampleSqlText_chk = new JCheckBox("Get SQL Text", conf == null ? true : conf.getBooleanProperty(localName + ".sample.sqlText", true));
                    sampleSqlText_chk.setName(localName + ".sample.sqlText");
                    sampleSqlText_chk.setToolTipText("<html>Get SQL Text assosiated with the Cached Statement.<br><b>Note</b>: This is not a filter, you will have to wait for next sample time for this option to take effect.</html>");
                    panel.add((Component)sampleSqlText_chk, "wrap");
                    sampleSqlText_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getInstance("USER_TEMP");
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty(localName + ".sample.sqlText", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    JCheckBox sampleShowplan_chk = new JCheckBox("Get Showplan", conf == null ? true : conf.getBooleanProperty(localName + ".sample.showplan", true));
                    sampleShowplan_chk.setName(localName + ".sample.showplan");
                    sampleShowplan_chk.setToolTipText("<html>Get Showplan assosiated with the Cached Statement.<br><b>Note</b>: This is not a filter, you will have to wait for next sample time for this option to take effect.</html>");
                    panel.add((Component)sampleShowplan_chk, "wrap");
                    sampleShowplan_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getInstance("USER_TEMP");
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty(localName + ".sample.showplan", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    return panel;
                }
            };
            tcp.setToolTipText(description);
            tcp.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_statement_cache_detail_activity.png"));
            tcp.setCm(tmp);
            MainFrame.addTcp(tcp);
            tmp.setTabPanel(tcp);
        }
        _CMList.add(tmp);
        name = "CMActiveObjects";
        displayName = "Active Objects";
        description = "Objects that are currently accessed by any active Statements in the ASE.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monProcessObject"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "per object statistics active=1"};
        colsCalcDiff = new String[]{"LogicalReads", "PhysicalReads", "PhysicalAPFReads"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("SPID");
        pkList.add("DBID");
        pkList.add("OwnerUserID");
        pkList.add("ObjectID");
        pkList.add("IndexID");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -1842749890866142593L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monProcessObject", "dupMergeCount", "<html>If more than <b>one</b> row was fetched for this \"Primary Key\".<br>Then this column will hold number of rows merged into this row. 0=No Merges(only one row for this PK), 1=One Merge accurred(two rows was seen for this PK), etc...<br>This means that the non-diff columns will be from the first row fetched,<br>then all columns which is marked for difference calculation will be a summary of all the rows (so it's basically a SQL SUM(colName) operation).</html>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                if (aseVersion >= 15000) {
                    cols1 = cols1 + "SPID, KPID, ObjectType, DBName, ObjectName, IndexID, PartitionName, PartitionSize, OwnerUserID, LogicalReads, PhysicalReads, PhysicalAPFReads, dupMergeCount=convert(int,0), DBID, ObjectID, PartitionID";
                    this.getPk().add("PartitionID");
                } else {
                    String TableSize = "";
                    if (aseVersion >= 12520) {
                        TableSize = "TableSize, ";
                    }
                    cols1 = cols1 + "SPID, KPID, ObjectType, DBName, ObjectName, IndexID, " + TableSize + "                 OwnerUserID, LogicalReads, PhysicalReads, PhysicalAPFReads, dupMergeCount=convert(int,0), DBID, ObjectID";
                }
                String whereSpidNotMe = "SPID != @@spid";
                if (aseVersion <= 15000) {
                    whereSpidNotMe = "SPID != convert(int,@@spid)";
                }
                String sql = "select " + cols1 + "\n" + "from monProcessObject\n" + "where " + whereSpidNotMe;
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_process_object_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>ORANGE - An Index.</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.index");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    Number indexId = (Number)adapter.getValue(adapter.getColumnIndex((Object)"IndexID"));
                    return indexId != null && indexId.intValue() > 0;
                }
            }, SwingUtils.parseColor(colorStr, Color.ORANGE), null));
        }
        _CMList.add(tmp);
        name = "CMActiveStatements";
        displayName = "Active Statements";
        description = "Statemenets that are currently executing in the ASE.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monProcessStatement", "monProcess"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "statement statistics active=1", "wait event timing=1"};
        colsCalcDiff = new String[]{"MemUsageKB", "PhysicalReads", "LogicalReads", "PagesModified", "PacketsSent", "PacketsReceived", "pssinfo_tempdb_pages"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("SPID");
        pkList.add("monSource");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 5078336367667465709L;

            @Override
            public void initSql(Connection conn) {
                try {
                    MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                    mtd.addColumn("monProcess", "BlockingOtherSpids", "This SPID is Blocking other SPID's from executing, because this SPID hold lock(s), that some other SPID wants to grab.");
                    mtd.addColumn("monProcess", "multiSampled", "<html>This indicates that the PrimaryKey (SPID, monSource[, InstanceID]) has been in this table for more than one sample.<br>Also 'StartTime' has to be the <b>same</b> as in the previous sample.<br>The StartTime is the columns, which tells the start time for current SQL statement, or the individual statement inside a Stored Procedure.</html>");
                    mtd.addColumn("monProcess", "HasMonSqlText", "Has values for: select SQLText from master..monProcessSQLText where SPID = <SPID>");
                    mtd.addColumn("monProcess", "MonSqlText", "select SQLText from master..monProcessSQLText where SPID = <SPID>");
                    mtd.addColumn("monProcess", "HasDbccSqlText", "Has values for: DBCC sqltext(<SPID>)");
                    mtd.addColumn("monProcess", "DbccSqlText", "DBCC sqltext(<SPID>)");
                    mtd.addColumn("monProcess", "HasShowPlan", "Has values for: sp_showplan <SPID>, null, null, null");
                    mtd.addColumn("monProcess", "ShowPlanText", "sp_showplan <SPID>, null, null, null");
                    mtd.addColumn("monProcess", "HasStacktrace", "Has values for: DBCC stacktrace(<SPID>)");
                    mtd.addColumn("monProcess", "DbccStacktrace", "DBCC stacktrace(<SPID>)");
                    mtd.addColumn("monProcess", "HasProcCallStack", "Has values for: select * from monProcessProcedures where SPID = <SPID>");
                    mtd.addColumn("monProcess", "ProcCallStack", "select * from monProcessProcedures where SPID = <SPID>");
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                int aseVersion = this.getServerVersion();
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                String optGoalPlan = "";
                if (aseVersion >= 15020) {
                    optGoalPlan = "plan '(use optgoal allrows_dss)' \n";
                }
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "S.InstanceID, ";
                    this.getPk().add("InstanceID");
                }
                String dbNameCol = "dbname=db_name(S.DBID)";
                if (aseVersion >= 15020) {
                    dbNameCol = "dbname=S.DBName";
                }
                cols1 = cols1 + "monSource=convert(varchar(10),'ACTIVE'), \nP.SPID, P.KPID, \nmultiSampled=convert(varchar(10),''), \nS.BatchID, S.LineNumber, \n" + dbNameCol + ", procname=isnull(object_name(S.ProcedureID,S.DBID),''), linenum=S.LineNumber, \n" + "P.Command, P.Application, \n" + "S.CpuTime, S.WaitTime, ExecTimeInMs=datediff(ms, S.StartTime, getdate()), \n" + "UsefullExecTime = (datediff(ms, S.StartTime, getdate()) - S.WaitTime), \n" + "BlockingOtherSpids=convert(varchar(255),''), P.BlockingSPID, \n" + "P.SecondsWaiting, P.WaitEventID, \n" + "WaitClassDesc=convert(varchar(50),''), \n" + "WaitEventDesc=convert(varchar(50),''), \n" + "HasMonSqlText=convert(bit,0), HasDbccSqlText=convert(bit,0), HasProcCallStack=convert(bit,0), HasShowPlan=convert(bit,0), HasStacktrace=convert(bit,0), \n" + "S.MemUsageKB, S.PhysicalReads, S.LogicalReads, \n";
                cols2 = cols2 + "";
                cols3 = cols3 + "S.PagesModified, S.PacketsSent, S.PacketsReceived, S.NetworkPacketSize, \nS.PlansAltered, S.StartTime, S.PlanID, S.DBID, S.ProcedureID, \nP.SecondsConnected, P.EngineNumber, P.NumChildren, \nMonSqlText=convert(text,null), \nDbccSqlText=convert(text,null), \nProcCallStack=convert(text,null), \nShowPlanText=convert(text,null), \nDbccStacktrace=convert(text,null) \n";
                if (aseVersion >= 15020 || aseVersion >= 12540 && aseVersion <= 15000) {
                    cols2 = cols2 + "S.RowsAffected, tempdb_name = db_name(tempdb_id(S.SPID)), pssinfo_tempdb_pages = convert(int, pssinfo(S.SPID, 'tempdb_pages')), \n";
                }
                String whereSpidNotMe = "S.SPID != @@spid";
                if (aseVersion <= 15000) {
                    whereSpidNotMe = "S.SPID != convert(int,@@spid)";
                }
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcessStatement S, monProcess P \n" + "where S.KPID = P.KPID \n" + (this.isClusterEnabled() ? "  and S.InstanceID = P.InstanceID \n" : "") + "  and " + whereSpidNotMe + "\n" + "order by S.LogicalReads desc \n" + optGoalPlan;
                cols3 = "";
                cols2 = "";
                cols1 = "";
                if (this.isClusterEnabled()) {
                    cols1 = cols1 + "P.InstanceID, ";
                }
                dbNameCol = "dbname=db_name(P.DBID)";
                if (aseVersion >= 15020) {
                    dbNameCol = "dbname=P.DBName";
                }
                cols1 = cols1 + "monSource=convert(varchar(10),'BLOCKER'), \nP.SPID, P.KPID, \nmultiSampled=convert(varchar(10),''), \nP.BatchID, P.LineNumber, \n" + dbNameCol + ", procname='', linenum=P.LineNumber, \n" + "P.Command, P.Application, \n" + "CpuTime=-1, WaitTime=-1, ExecTimeInMs=-1, \n" + "UsefullExecTime = -1, \n" + "BlockingOtherSpids=convert(varchar(255),''), P.BlockingSPID, \n" + "P.SecondsWaiting, P.WaitEventID, \n" + "WaitClassDesc=convert(varchar(50),''), \n" + "WaitEventDesc=convert(varchar(50),''), \n" + "HasMonSqlText=convert(bit,0), HasDbccSqlText=convert(bit,0), HasProcCallStack=convert(bit,0), HasShowPlan=convert(bit,0), HasStacktrace=convert(bit,0), \n" + "MemUsageKB=-1, PhysicalReads=-1, LogicalReads=-1, \n";
                cols2 = cols2 + "";
                cols3 = cols3 + "PagesModified=-1, PacketsSent=-1, PacketsReceived=-1, NetworkPacketSize=-1, \nPlansAltered=-1, StartTime=convert(datetime,NULL), PlanID=-1, P.DBID, ProcedureID=-1, \nP.SecondsConnected, P.EngineNumber, P.NumChildren, \nMonSqlText=convert(text,null), \nDbccSqlText=convert(text,null), \nProcCallStack=convert(text,null), \nShowPlanText=convert(text,null), \nDbccStacktrace=convert(text,null) \n";
                if (aseVersion >= 15020 || aseVersion >= 12540 && aseVersion <= 15000) {
                    cols2 = cols2 + "RowsAffected=-1, tempdb_name = db_name(tempdb_id(P.SPID)), pssinfo_tempdb_pages = convert(int, pssinfo(P.SPID, 'tempdb_pages')), \n";
                }
                String x_sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcess P \n" + "where P.SPID in (select blocked from sysprocesses where blocked > 0) \n" + optGoalPlan;
                this.setSql(sql + "\n\n" + "  /* UNION ALL */ \n\n" + x_sql);
            }

            @Override
            public String getToolTipTextOnTableCell(MouseEvent e, String colName, Object cellValue, int modelRow, int modelCol) {
                int pos_DbccStacktrace;
                int pos_ProcCallStack;
                int pos_DbccSqlText;
                int pos_MonSqlText;
                Object cellVal;
                int pos_ShowPlanText;
                if ("HasShowPlan".equals(colName) && (pos_ShowPlanText = this.findColumn("ShowPlanText")) > 0 && (cellVal = this.getValueAt(modelRow, pos_ShowPlanText)) instanceof String) {
                    return (String)cellVal;
                }
                if ("ShowPlanText".equals(colName)) {
                    return cellValue == null ? null : cellValue.toString();
                }
                if ("HasMonSqlText".equals(colName) && (pos_MonSqlText = this.findColumn("MonSqlText")) > 0 && (cellVal = this.getValueAt(modelRow, pos_MonSqlText)) instanceof String) {
                    return this.toHtmlString((String)cellVal);
                }
                if ("MonSqlText".equals(colName)) {
                    return cellValue == null ? null : cellValue.toString();
                }
                if ("HasDbccSqlText".equals(colName) && (pos_DbccSqlText = this.findColumn("DbccSqlText")) > 0 && (cellVal = this.getValueAt(modelRow, pos_DbccSqlText)) instanceof String) {
                    return this.toHtmlString((String)cellVal);
                }
                if ("DbccSqlText".equals(colName)) {
                    return cellValue == null ? null : cellValue.toString();
                }
                if ("HasProcCallStack".equals(colName) && (pos_ProcCallStack = this.findColumn("ProcCallStack")) > 0 && (cellVal = this.getValueAt(modelRow, pos_ProcCallStack)) instanceof String) {
                    return (String)cellVal;
                }
                if ("ProcCallStack".equals(colName)) {
                    return cellValue == null ? null : cellValue.toString();
                }
                if ("HasStacktrace".equals(colName) && (pos_DbccStacktrace = this.findColumn("DbccStacktrace")) > 0 && (cellVal = this.getValueAt(modelRow, pos_DbccStacktrace)) instanceof String) {
                    return (String)cellVal;
                }
                if ("DbccStacktrace".equals(colName)) {
                    return cellValue == null ? null : cellValue.toString();
                }
                return super.getToolTipTextOnTableCell(e, colName, cellValue, modelRow, modelCol);
            }

            private String toHtmlString(String in) {
                String str = StringUtil.makeApproxLineBreak(in, 150, 10, "\n");
                str = str.replaceAll("\\n", "<br>");
                if (in.indexOf("<html>") >= 0 || in.indexOf("<HTML>") >= 0) {
                    return str;
                }
                return "<html><pre>" + str + "</pre></html>";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                String colName = this.getColumnName(columnIndex);
                if ("HasShowPlan".equals(colName)) {
                    return Boolean.class;
                }
                if ("HasMonSqlText".equals(colName)) {
                    return Boolean.class;
                }
                if ("HasDbccSqlText".equals(colName)) {
                    return Boolean.class;
                }
                if ("HasProcCallStack".equals(colName)) {
                    return Boolean.class;
                }
                if ("HasStacktrace".equals(colName)) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
                Configuration conf = Configuration.getCombinedConfiguration();
                boolean getShowplan = conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.showplan", true);
                boolean getMonSqltext = conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.monSqltext", true);
                boolean getDbccSqltext = conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.dbccSqltext", true);
                boolean getProcCallStack = conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.procCallStack", true);
                boolean getDbccStacktrace = conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.dbccStacktrace", true);
                int pos_WaitEventID = -1;
                int pos_WaitEventDesc = -1;
                int pos_WaitClassDesc = -1;
                int pos_SPID = -1;
                int pos_HasShowPlan = -1;
                int pos_ShowPlanText = -1;
                int pos_HasMonSqlText = -1;
                int pos_MonSqlText = -1;
                int pos_HasDbccSqlText = -1;
                int pos_DbccSqlText = -1;
                int pos_HasProcCallStack = -1;
                int pos_ProcCallStack = -1;
                int pos_HasStacktrace = -1;
                int pos_DbccStacktrace = -1;
                int pos_BlockingOtherSpids = -1;
                int pos_BlockingSPID = -1;
                int pos_multiSampled = -1;
                int pos_StartTime = -1;
                int waitEventID = 0;
                String waitEventDesc = "";
                String waitClassDesc = "";
                SamplingCnt counters = diffData;
                MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                if (mtd == null) {
                    return;
                }
                if (counters == null) {
                    return;
                }
                List<String> colNames = counters.getColNames();
                if (colNames == null) {
                    return;
                }
                for (int colId = 0; colId < colNames.size(); ++colId) {
                    String colName = colNames.get(colId);
                    if (colName.equals("WaitEventID")) {
                        pos_WaitEventID = colId;
                    } else if (colName.equals("WaitEventDesc")) {
                        pos_WaitEventDesc = colId;
                    } else if (colName.equals("WaitClassDesc")) {
                        pos_WaitClassDesc = colId;
                    } else if (colName.equals("SPID")) {
                        pos_SPID = colId;
                    } else if (colName.equals("HasShowPlan")) {
                        pos_HasShowPlan = colId;
                    } else if (colName.equals("ShowPlanText")) {
                        pos_ShowPlanText = colId;
                    } else if (colName.equals("HasMonSqlText")) {
                        pos_HasMonSqlText = colId;
                    } else if (colName.equals("MonSqlText")) {
                        pos_MonSqlText = colId;
                    } else if (colName.equals("HasDbccSqlText")) {
                        pos_HasDbccSqlText = colId;
                    } else if (colName.equals("DbccSqlText")) {
                        pos_DbccSqlText = colId;
                    } else if (colName.equals("HasProcCallStack")) {
                        pos_HasProcCallStack = colId;
                    } else if (colName.equals("ProcCallStack")) {
                        pos_ProcCallStack = colId;
                    } else if (colName.equals("HasStacktrace")) {
                        pos_HasStacktrace = colId;
                    } else if (colName.equals("DbccStacktrace")) {
                        pos_DbccStacktrace = colId;
                    } else if (colName.equals("BlockingOtherSpids")) {
                        pos_BlockingOtherSpids = colId;
                    } else if (colName.equals("BlockingSPID")) {
                        pos_BlockingSPID = colId;
                    } else if (colName.equals("multiSampled")) {
                        pos_multiSampled = colId;
                    } else if (colName.equals("StartTime")) {
                        pos_StartTime = colId;
                    }
                    if (pos_WaitEventID >= 0 && pos_WaitEventDesc >= 0 && pos_WaitClassDesc >= 0 && pos_SPID >= 0 && pos_HasShowPlan >= 0 && pos_ShowPlanText >= 0 && pos_HasMonSqlText >= 0 && pos_MonSqlText >= 0 && pos_HasDbccSqlText >= 0 && pos_DbccSqlText >= 0 && pos_HasProcCallStack >= 0 && pos_ProcCallStack >= 0 && pos_HasStacktrace >= 0 && pos_DbccStacktrace >= 0 && pos_BlockingOtherSpids >= 0 && pos_BlockingSPID >= 0 && pos_multiSampled >= 0 && pos_StartTime >= 0) break;
                }
                if (pos_WaitEventID < 0 || pos_WaitEventDesc < 0 || pos_WaitClassDesc < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('WaitEventID'=" + pos_WaitEventID + ", 'WaitEventDesc'=" + pos_WaitEventDesc + ", 'WaitClassDesc'=" + pos_WaitClassDesc + ")"));
                    return;
                }
                if (pos_SPID < 0 || pos_HasShowPlan < 0 || pos_ShowPlanText < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('SPID'=" + pos_SPID + ", 'HasShowPlan'=" + pos_HasShowPlan + ", 'ShowPlanText'=" + pos_ShowPlanText + ")"));
                    return;
                }
                if (pos_HasDbccSqlText < 0 || pos_DbccSqlText < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('HasDbccSqlText'=" + pos_HasDbccSqlText + ", 'DbccSqlText'=" + pos_DbccSqlText + ")"));
                    return;
                }
                if (pos_HasProcCallStack < 0 || pos_ProcCallStack < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('HasProcCallStack'=" + pos_HasProcCallStack + ", 'ProcCallStack'=" + pos_ProcCallStack + ")"));
                    return;
                }
                if (pos_HasMonSqlText < 0 || pos_MonSqlText < 0) {
                    _logger.debug((Object)("Cant find the position for columns (''HasMonSqlText'=" + pos_HasMonSqlText + ", 'MonSqlText'=" + pos_MonSqlText + ")"));
                    return;
                }
                if (pos_HasStacktrace < 0 || pos_DbccStacktrace < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('HasShowplan'=" + pos_HasStacktrace + ", 'DbccStacktrace'=" + pos_DbccStacktrace + ")"));
                    return;
                }
                if (pos_BlockingOtherSpids < 0 || pos_BlockingSPID < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('BlockingOtherSpids'=" + pos_BlockingOtherSpids + ", 'BlockingSPID'=" + pos_BlockingSPID + ")"));
                    return;
                }
                if (pos_multiSampled < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('multiSampled'=" + pos_multiSampled + ")"));
                    return;
                }
                if (pos_StartTime < 0) {
                    _logger.debug((Object)("Cant find the position for columns ('StartTime'=" + pos_StartTime + ")"));
                    return;
                }
                for (int rowId = 0; rowId < counters.getRowCount(); ++rowId) {
                    String thisRowPk = counters.getPkValue(rowId);
                    int prevPkRowId = prevSample == null ? -1 : prevSample.getRowNumberForPkValue(thisRowPk);
                    boolean prevPkExists = prevPkRowId >= 0;
                    Object o_waitEventId = counters.getValueAt(rowId, pos_WaitEventID);
                    Object o_SPID = counters.getValueAt(rowId, pos_SPID);
                    if (prevPkExists) {
                        Object o_this_StartTime = counters.getValueAt(rowId, pos_StartTime);
                        Object o_prev_StartTime = prevSample.getValueAt(prevPkRowId, pos_StartTime);
                        if (o_this_StartTime instanceof Timestamp && o_prev_StartTime instanceof Timestamp && o_this_StartTime.equals(o_prev_StartTime)) {
                            counters.setValueAt("YES", rowId, pos_multiSampled);
                        }
                    }
                    if (o_waitEventId instanceof Number) {
                        waitEventID = ((Number)o_waitEventId).intValue();
                        if (mtd.hasWaitEventDescription(waitEventID)) {
                            waitEventDesc = mtd.getWaitEventDescription(waitEventID);
                            waitClassDesc = mtd.getWaitEventClassDescription(waitEventID);
                        } else {
                            waitEventDesc = "";
                            waitClassDesc = "";
                        }
                        counters.setValueAt(waitEventDesc, rowId, pos_WaitEventDesc);
                        counters.setValueAt(waitClassDesc, rowId, pos_WaitClassDesc);
                    }
                    if (!(o_SPID instanceof Number)) continue;
                    int spid = ((Number)o_SPID).intValue();
                    String monSqlText = "Not properly configured (need 'SQL batch capture' & 'max SQL text monitored').";
                    String dbccSqlText = "User does not have: sa_role";
                    String procCallStack = "User does not have: sa_role";
                    String showplan = "User does not have: sa_role";
                    String stacktrace = "User does not have: sa_role";
                    if (this.getMonitorConfig("SQL batch capture") > 0 && this.getMonitorConfig("max SQL text monitored") > 0 && (monSqlText = getMonSqltext ? AseConnectionUtils.monSqlText(GetCounters.this.getMonConnection(), spid, true) : "This was disabled") == null) {
                        monSqlText = "Not Available";
                    }
                    if (this.isRoleActive("sa_role")) {
                        dbccSqlText = getDbccSqltext ? AseConnectionUtils.dbccSqlText(GetCounters.this.getMonConnection(), spid, true) : "This was disabled";
                        if (dbccSqlText == null) {
                            dbccSqlText = "Not Available";
                        }
                        if ((procCallStack = getProcCallStack ? AseConnectionUtils.monProcCallStack(GetCounters.this.getMonConnection(), spid, true) : "This was disabled") == null) {
                            procCallStack = "Not Available";
                        }
                        if ((showplan = getShowplan ? AseConnectionUtils.getShowplan(GetCounters.this.getMonConnection(), spid, "Showplan:", true) : "This was disabled") == null) {
                            showplan = "Not Available";
                        }
                        if ((stacktrace = getDbccStacktrace ? AseConnectionUtils.dbccStacktrace(GetCounters.this.getMonConnection(), spid, true, waitEventID) : "This was disabled") == null) {
                            stacktrace = "Not Available";
                        }
                    }
                    boolean b = true;
                    b = !"This was disabled".equals(monSqlText) && !"Not Available".equals(monSqlText) && !monSqlText.startsWith("Not properly configured");
                    counters.setValueAt(new Boolean(b), rowId, pos_HasMonSqlText);
                    counters.setValueAt(monSqlText, rowId, pos_MonSqlText);
                    b = !"This was disabled".equals(dbccSqlText) && !"Not Available".equals(dbccSqlText) && !dbccSqlText.startsWith("User does not have");
                    counters.setValueAt(new Boolean(b), rowId, pos_HasDbccSqlText);
                    counters.setValueAt(dbccSqlText, rowId, pos_DbccSqlText);
                    b = !"This was disabled".equals(procCallStack) && !"Not Available".equals(procCallStack) && !procCallStack.startsWith("User does not have");
                    counters.setValueAt(new Boolean(b), rowId, pos_HasProcCallStack);
                    counters.setValueAt(procCallStack, rowId, pos_ProcCallStack);
                    b = !"This was disabled".equals(showplan) && !"Not Available".equals(showplan) && !showplan.startsWith("User does not have");
                    counters.setValueAt(new Boolean(b), rowId, pos_HasShowPlan);
                    counters.setValueAt(showplan, rowId, pos_ShowPlanText);
                    b = !"This was disabled".equals(stacktrace) && !"Not Available".equals(stacktrace) && !stacktrace.startsWith("User does not have");
                    counters.setValueAt(new Boolean(b), rowId, pos_HasStacktrace);
                    counters.setValueAt(stacktrace, rowId, pos_DbccStacktrace);
                    String blockingList = this.getBlockingListStr(counters, spid, pos_BlockingSPID, pos_SPID);
                    counters.setValueAt(blockingList, rowId, pos_BlockingOtherSpids);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            private String getBlockingListStr(SamplingCnt counters, int spid, int pos_BlockingSPID, int pos_SPID) {
                StringBuilder sb = new StringBuilder();
                int rows = counters.getRowCount();
                for (int rowId = 0; rowId < rows; ++rowId) {
                    Number thisRow;
                    Object o_BlockingSPID = counters.getValueAt(rowId, pos_BlockingSPID);
                    if (!(o_BlockingSPID instanceof Number) || (thisRow = (Number)o_BlockingSPID).intValue() != spid) continue;
                    Object o_SPID = counters.getValueAt(rowId, pos_SPID);
                    if (sb.length() == 0) {
                        sb.append(o_SPID);
                        continue;
                    }
                    sb.append(", ").append(o_SPID);
                }
                return sb.toString();
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Local Options", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
                    panel.setToolTipText("<html>All the options in this panel executes additional SQL lookups in the database <b>after</b> the result set has been delivered.<br>This means that we are doing 1 extra SQL lookup for every checkbox option per row on the result set table.<br><br>NOTE: So if you check all the options, the time to do refresh on this tab will <b>increase</b>.</html>");
                    Configuration conf = Configuration.getCombinedConfiguration();
                    JCheckBox sampleMonSqltext_chk = new JCheckBox("Get Monitored SQL Text", conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.monSqltext", true));
                    JCheckBox sampleDbccSqltext_chk = new JCheckBox("Get DBCC SQL Text", conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.dbccSqltext", true));
                    JCheckBox sampleProcCallStack_chk = new JCheckBox("Get Procedure Call Stack", conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.procCallStack", true));
                    JCheckBox sampleShowplan_chk = new JCheckBox("Get Showplan", conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.showplan", true));
                    JCheckBox sampleDbccStacktrace_chk = new JCheckBox("Get ASE Stacktrace", conf == null ? true : conf.getBooleanProperty("CMActiveStatements.sample.dbccStacktrace", true));
                    sampleMonSqltext_chk.setName("CMActiveStatements.sample.monSqltext");
                    sampleDbccSqltext_chk.setName("CMActiveStatements.sample.dbccSqltext");
                    sampleProcCallStack_chk.setName("CMActiveStatements.sample.procCallStack");
                    sampleShowplan_chk.setName("CMActiveStatements.sample.showplan");
                    sampleDbccStacktrace_chk.setName("CMActiveStatements.sample.dbccStacktrace");
                    sampleMonSqltext_chk.setToolTipText("<html>Do 'select SQLText from monProcessSQLText where SPID=spid' on every row in the table.<br>    This will help us to diagnose what SQL the client sent to the server.</html>");
                    sampleDbccSqltext_chk.setToolTipText("<html>Do 'dbcc sqltext(spid)' on every row in the table.<br>     This will help us to diagnose what SQL the client sent to the server.</html>");
                    sampleProcCallStack_chk.setToolTipText("<html>Do 'select * from monProcessProcedures where SPID=spid.<br>This will help us to diagnose what stored procedure called before we ended up here.</html>");
                    sampleShowplan_chk.setToolTipText("<html>Do 'sp_showplan spid' on every row in the table.<br>       This will help us to diagnose if the current SQL statement is doing something funky.</html>");
                    sampleDbccStacktrace_chk.setToolTipText("<html>do 'dbcc stacktrace(spid)' on every row in the table.<br>  This will help us to diagnose what peace of code the ASE Server is currently executing.</html>");
                    panel.add((Component)sampleMonSqltext_chk, "");
                    panel.add((Component)sampleProcCallStack_chk, "wrap");
                    panel.add((Component)sampleDbccSqltext_chk, "wrap");
                    panel.add((Component)sampleShowplan_chk, "wrap");
                    panel.add((Component)sampleDbccStacktrace_chk, "wrap");
                    sampleMonSqltext_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getCombinedConfiguration();
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMActiveStatements.sample.monSqltext", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    sampleDbccSqltext_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getCombinedConfiguration();
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMActiveStatements.sample.dbccSqltext", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    sampleProcCallStack_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getCombinedConfiguration();
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMActiveStatements.sample.procCallStack", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    sampleShowplan_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getCombinedConfiguration();
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMActiveStatements.sample.showplan", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    sampleDbccStacktrace_chk.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configuration conf = Configuration.getCombinedConfiguration();
                            if (conf == null) {
                                return;
                            }
                            conf.setProperty("CMActiveStatements.sample.dbccStacktrace", ((JCheckBox)e.getSource()).isSelected());
                            conf.save();
                        }
                    });
                    return panel;
                }
            };
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_active_statements_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
            tcp2.setTableToolTipText("<html>Background colors:<ul>    <li>ORANGE - SPID was visible in previous sample as well.</li>    <li>PINK   - SPID is Blocked by another SPID from running, this SPID is the Victim of a Blocking Lock, which is showned in RED.</li>    <li>RED    - SPID is Blocking other SPID's from running, this SPID is Responslibe or the Root Cause of a Blocking Lock.</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.multiSampled");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String multiSampled = adapter.getString(adapter.getColumnIndex((Object)"multiSampled"));
                    if (multiSampled != null) {
                        multiSampled = multiSampled.trim();
                    }
                    return !"".equals(multiSampled);
                }
            }, SwingUtils.parseColor(colorStr, Color.ORANGE), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocked");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String blockingSpid = adapter.getString(adapter.getColumnIndex((Object)"BlockingSPID"));
                    if (blockingSpid != null) {
                        blockingSpid = blockingSpid.trim();
                    }
                    return !"0".equals(blockingSpid);
                }
            }, SwingUtils.parseColor(colorStr, Color.PINK), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocking");
            }
            tcp2.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String listOfBlockedSpids = adapter.getString(adapter.getColumnIndex((Object)"BlockingOtherSpids"));
                    if (listOfBlockedSpids != null) {
                        listOfBlockedSpids = listOfBlockedSpids.trim();
                    }
                    return !"".equals(listOfBlockedSpids);
                }
            }, SwingUtils.parseColor(colorStr, Color.RED), null));
        }
        _CMList.add(tmp);
        name = "CMblocking";
        displayName = "Blocking";
        description = "Are there any SPIDS blocked/blocking for more than 'Lock wait threshold' in the system";
        needVersion = 15002;
        needCeVersion = 0;
        monTables = new String[]{"monLocks"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring=1", "wait event timing=1"};
        colsCalcDiff = new String[]{};
        colsCalcPCT = new String[]{};
        pkList = null;
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -5587478527730346195L;

            @Override
            public void initSql(Connection conn) {
                String cols3 = "";
                String cols2 = "";
                String cols1 = "";
                cols1 = "*";
                cols2 = ", ObjectName = isnull(object_name(ObjectID, DBID), 'ObjId='+convert(varchar(30),ObjectID))";
                cols3 = "";
                String whereArgs = "where BlockedState = 'Blocked' or BlockedState = 'Blocking'";
                String sql = "select " + cols1 + cols2 + cols3 + "\n" + "from monLocks\n" + whereArgs + "\n";
                this.setSql(sql);
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            finalDisplayName = displayName;
            tcp = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Local Options", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
                    JButton resetMoveToTab_but = new JButton("Reset 'Move to Tab' settings.");
                    resetMoveToTab_but.setToolTipText("<html>Reset the option: To automatically switch to this tab when you have <b>blocking locks</b>.<br>Next time this happens, a popup will ask you what you want to do.</html>");
                    resetMoveToTab_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChangeToJTabDialog.resetSavedSettings(finalDisplayName);
                        }
                    });
                    panel.add((Component)resetMoveToTab_but, "wrap");
                    return panel;
                }
            };
            tcp.setToolTipText(description);
            tcp.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_blocking_spid.png"));
            tcp.setCm(tmp);
            MainFrame.addTcp(tcp);
            tmp.setTabPanel(tcp);
            tcp.setTableToolTipText("<html>Background colors:<ul>    <li>PINK   - SPID is Blocked by some other SPID that holds a Lock on a database object Table, Page or Row. This is the Lock Victim.</li>    <li>RED    - SPID is Blocking other SPID's from running, this SPID is Responslibe or the Root Cause of a Blocking Lock.</li></ul></html>");
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocked");
            }
            tcp.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String blockedState = adapter.getString(adapter.getColumnIndex((Object)"BlockedState"));
                    return "Blocked".equals(blockedState);
                }
            }, SwingUtils.parseColor(colorStr, Color.PINK), null));
            if (conf != null) {
                colorStr = conf.getProperty(name + ".color.blocking");
            }
            tcp.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    String blockedState = adapter.getString(adapter.getColumnIndex((Object)"BlockedState"));
                    return "Blocking".equals(blockedState);
                }
            }, SwingUtils.parseColor(colorStr, Color.RED), null));
        }
        _CMList.add(tmp);
        name = "CMmissingStats";
        displayName = "Missing Statistics";
        description = "The optimizer executed queries where it didnt find statistics for this objects";
        needVersion = 15031;
        needCeVersion = 0;
        monTables = new String[]{"sysstatistics"};
        needRole = new String[]{};
        needConfig = new String[]{"capture missing statistics"};
        colsCalcDiff = new String[]{"miss_counter"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("DBName");
        pkList.add("ObjectName");
        pkList.add("colList");
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){
            private static final long serialVersionUID = -1842749890597642593L;

            @Override
            public void initSql(Connection conn) {
                String sql = "exec sp_missing_stats";
                this.setSql(sql);
            }
        };
        tmp.addDependsOnStoredProc("sybsystemprocs", "sp_missing_stats", VersionInfo.SP_MISSING_STATS_CRDATE, VersionInfo.class, "sp_missing_stats.sql", "sa_role");
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_missing_stats_activity.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMspMonitorConfig";
        displayName = "sp_monitorconfig";
        description = "Executes: sp_monitorconfig 'all'... <b>Note</b>: set postpone time to 10 minutes or so, we dont need to sample this that often.";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        needVersion = 0;
        needCeVersion = 0;
        monTables = new String[]{"monitorconfig"};
        needRole = new String[]{};
        needConfig = new String[]{};
        colsCalcDiff = new String[]{};
        colsCalcPCT = new String[]{};
        pkList = null;
        tmp = new CountersModel(name, null, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true, 600){
            private static final long serialVersionUID = -1842749890597642593L;

            @Override
            public void initSql(Connection conn) {
                String sql = "exec sp_monitorconfig 'all'";
                this.setSql(sql);
            }

            @Override
            protected CmSybMessageHandler createSybMessageHandler() {
                CmSybMessageHandler msgHandler = super.createSybMessageHandler();
                msgHandler.addDiscardMsgNum(0);
                return msgHandler;
            }
        };
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName());
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_sp_monitorconfig.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMosIostat";
        displayName = "OS Disk Stat";
        description = "Executes: 'iostat' on the Operating System";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        tmp = new CounterModelHostMonitor(name, 1, null, true);
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;
                JLabel l_hostmonThreadNotInit_lbl;
                JLabel l_hostmonThreadIsRunning_lbl;
                JLabel l_hostmonThreadIsStopped_lbl;
                JLabel l_hostmonHostname_lbl;
                JButton l_hostmonStart_but;
                JButton l_hostmonStop_but;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Host Monitor", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 5, gap 0", "", "0[0]0"));
                    panel.setToolTipText("<html>Use this panel to check or controll the underlying Host Monitoring Thread.<br>You can Start and/or Stop the hostmon thread.<br></html>");
                    this.l_hostmonThreadNotInit_lbl = new JLabel("<html><b>Not yet initialized</b></html>");
                    this.l_hostmonThreadIsRunning_lbl = new JLabel("<html>Is running</html>");
                    this.l_hostmonThreadIsStopped_lbl = new JLabel("<html><b>Is stopped</b></html>");
                    this.l_hostmonHostname_lbl = new JLabel();
                    this.l_hostmonStart_but = new JButton("Start");
                    this.l_hostmonStop_but = new JButton("Stop");
                    this.l_hostmonThreadNotInit_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread has not yet been initialized.</html>");
                    this.l_hostmonThreadIsRunning_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonThreadIsStopped_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonHostname_lbl.setToolTipText("<html>What hostname are we monitoring.</html>");
                    this.l_hostmonStart_but.setToolTipText("<html>Start the underlying Host Monitor Thread.</html>");
                    this.l_hostmonStop_but.setToolTipText("<html>Stop the underlying Host Monitor Thread.</html>");
                    this.l_hostmonThreadNotInit_lbl.setVisible(true);
                    this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                    this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                    this.l_hostmonStart_but.setVisible(false);
                    this.l_hostmonStop_but.setVisible(false);
                    panel.add((Component)this.l_hostmonThreadNotInit_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsRunning_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsStopped_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonHostname_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonStart_but, "hidemode 3, wrap");
                    panel.add((Component)this.l_hostmonStop_but, "hidemode 3, wrap");
                    this.l_hostmonStart_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                try {
                                    hostMonitor.setPaused(false);
                                    hostMonitor.start();
                                }
                                catch (Exception ex) {
                                    SwingUtils.showErrorMessage("Start", "Problems Starting the Host Monitoring Thread.", ex);
                                }
                            }
                        }
                    });
                    this.l_hostmonStop_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                hostMonitor.setPaused(true);
                                hostMonitor.shutdown();
                            }
                        }
                    });
                    return panel;
                }

                @Override
                public void checkLocalComponents() {
                    CountersModel cm = this.getCm();
                    if (cm != null) {
                        HostMonitor hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor");
                        if (hostMonitor != null) {
                            boolean isRunning = hostMonitor.isRunning();
                            boolean isPaused = hostMonitor.isPaused();
                            this.l_hostmonThreadIsRunning_lbl.setText("<html>Command: <b>" + hostMonitor.getCommand() + "</b></html>");
                            this.l_hostmonThreadNotInit_lbl.setVisible(false);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(isRunning);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(!isRunning);
                            this.l_hostmonHostname_lbl.setText("<html> Host: <b>" + hostMonitor.getHostname() + "</b></html>");
                            this.l_hostmonStart_but.setVisible(!isRunning);
                            this.l_hostmonStop_but.setVisible(isRunning);
                            if (isPaused) {
                                this.setWatermarkText("Warning: The host monitoring thread is Stopped/Paused!");
                            }
                        } else {
                            this.setWatermarkText("Host Monitoring is Disabled or Initializing at Next sample.");
                            this.l_hostmonThreadNotInit_lbl.setVisible(true);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                            this.l_hostmonStart_but.setVisible(false);
                            this.l_hostmonStop_but.setVisible(false);
                            if (cm.getSampleException() != null) {
                                this.setWatermarkText(cm.getSampleException().toString());
                            }
                        }
                    }
                }
            };
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_hostmon_iostat.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMosVmstat";
        displayName = "OS CPU(vmstat)";
        description = "Executes: 'vmstat' on the Operating System";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        tmp = new CounterModelHostMonitor(name, 2, null, true);
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;
                JLabel l_hostmonThreadNotInit_lbl;
                JLabel l_hostmonThreadIsRunning_lbl;
                JLabel l_hostmonThreadIsStopped_lbl;
                JLabel l_hostmonHostname_lbl;
                JButton l_hostmonStart_but;
                JButton l_hostmonStop_but;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Host Monitor", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 5, gap 0", "", "0[0]0"));
                    panel.setToolTipText("<html>Use this panel to check or controll the underlying Host Monitoring Thread.<br>You can Start and/or Stop the hostmon thread.<br></html>");
                    this.l_hostmonThreadNotInit_lbl = new JLabel("<html><b>Not yet initialized</b></html>");
                    this.l_hostmonThreadIsRunning_lbl = new JLabel("<html>Is running</html>");
                    this.l_hostmonThreadIsStopped_lbl = new JLabel("<html><b>Is stopped</b></html>");
                    this.l_hostmonHostname_lbl = new JLabel();
                    this.l_hostmonStart_but = new JButton("Start");
                    this.l_hostmonStop_but = new JButton("Stop");
                    this.l_hostmonThreadNotInit_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread has not yet been initialized.</html>");
                    this.l_hostmonThreadIsRunning_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonThreadIsStopped_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonHostname_lbl.setToolTipText("<html>What hostname are we monitoring.</html>");
                    this.l_hostmonStart_but.setToolTipText("<html>Start the underlying Host Monitor Thread.</html>");
                    this.l_hostmonStop_but.setToolTipText("<html>Stop the underlying Host Monitor Thread.</html>");
                    this.l_hostmonThreadNotInit_lbl.setVisible(true);
                    this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                    this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                    this.l_hostmonStart_but.setVisible(false);
                    this.l_hostmonStop_but.setVisible(false);
                    panel.add((Component)this.l_hostmonThreadNotInit_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsRunning_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsStopped_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonHostname_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonStart_but, "hidemode 3, wrap");
                    panel.add((Component)this.l_hostmonStop_but, "hidemode 3, wrap");
                    this.l_hostmonStart_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                try {
                                    hostMonitor.setPaused(false);
                                    hostMonitor.start();
                                }
                                catch (Exception ex) {
                                    SwingUtils.showErrorMessage("Start", "Problems Starting the Host Monitoring Thread.", ex);
                                }
                            }
                        }
                    });
                    this.l_hostmonStop_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                hostMonitor.setPaused(true);
                                hostMonitor.shutdown();
                            }
                        }
                    });
                    return panel;
                }

                @Override
                public void checkLocalComponents() {
                    CountersModel cm = this.getCm();
                    if (cm != null) {
                        HostMonitor hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor");
                        if (hostMonitor != null) {
                            boolean isRunning = hostMonitor.isRunning();
                            boolean isPaused = hostMonitor.isPaused();
                            this.l_hostmonThreadIsRunning_lbl.setText("<html>Command: <b>" + hostMonitor.getCommand() + "</b></html>");
                            this.l_hostmonThreadNotInit_lbl.setVisible(false);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(isRunning);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(!isRunning);
                            this.l_hostmonHostname_lbl.setText("<html> Host: <b>" + hostMonitor.getHostname() + "</b></html>");
                            this.l_hostmonStart_but.setVisible(!isRunning);
                            this.l_hostmonStop_but.setVisible(isRunning);
                            if (isPaused) {
                                this.setWatermarkText("Warning: The host monitoring thread is Stopped/Paused!");
                            }
                        } else {
                            this.setWatermarkText("Host Monitoring is Disabled or Initializing at Next sample.");
                            this.l_hostmonThreadNotInit_lbl.setVisible(true);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                            this.l_hostmonStart_but.setVisible(false);
                            this.l_hostmonStop_but.setVisible(false);
                            if (cm.getSampleException() != null) {
                                this.setWatermarkText(cm.getSampleException().toString());
                            }
                        }
                    }
                }
            };
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_hostmon_vmstat.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        name = "CMosMpstat";
        displayName = "OS CPU(mpstat)";
        description = "Executes: 'mpstat' on the Operating System";
        SplashWindow.drawProgress("Loading: Counter Model '" + name + "'");
        tmp = new CounterModelHostMonitor(name, 3, null, true);
        tmp.setDisplayName(displayName);
        tmp.setDescription(description);
        if (Asemon.hasGUI()) {
            tcp2 = new TabularCntrPanel(tmp.getDisplayName()){
                private static final long serialVersionUID = 1L;
                JLabel l_hostmonThreadNotInit_lbl;
                JLabel l_hostmonThreadIsRunning_lbl;
                JLabel l_hostmonThreadIsStopped_lbl;
                JLabel l_hostmonHostname_lbl;
                JButton l_hostmonStart_but;
                JButton l_hostmonStop_but;

                @Override
                protected JPanel createLocalOptionsPanel() {
                    JPanel panel = SwingUtils.createPanel("Host Monitor", true);
                    panel.setLayout((LayoutManager)new MigLayout("ins 5, gap 0", "", "0[0]0"));
                    panel.setToolTipText("<html>Use this panel to check or controll the underlying Host Monitoring Thread.<br>You can Start and/or Stop the hostmon thread.<br></html>");
                    this.l_hostmonThreadNotInit_lbl = new JLabel("<html><b>Not yet initialized</b></html>");
                    this.l_hostmonThreadIsRunning_lbl = new JLabel("<html>Is running</html>");
                    this.l_hostmonThreadIsStopped_lbl = new JLabel("<html><b>Is stopped</b></html>");
                    this.l_hostmonHostname_lbl = new JLabel();
                    this.l_hostmonStart_but = new JButton("Start");
                    this.l_hostmonStop_but = new JButton("Stop");
                    this.l_hostmonThreadNotInit_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread has not yet been initialized.</html>");
                    this.l_hostmonThreadIsRunning_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonThreadIsStopped_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                    this.l_hostmonHostname_lbl.setToolTipText("<html>What hostname are we monitoring.</html>");
                    this.l_hostmonStart_but.setToolTipText("<html>Start the underlying Host Monitor Thread.</html>");
                    this.l_hostmonStop_but.setToolTipText("<html>Stop the underlying Host Monitor Thread.</html>");
                    this.l_hostmonThreadNotInit_lbl.setVisible(true);
                    this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                    this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                    this.l_hostmonStart_but.setVisible(false);
                    this.l_hostmonStop_but.setVisible(false);
                    panel.add((Component)this.l_hostmonThreadNotInit_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsRunning_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonThreadIsStopped_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonHostname_lbl, "hidemode 3, wrap 10");
                    panel.add((Component)this.l_hostmonStart_but, "hidemode 3, wrap");
                    panel.add((Component)this.l_hostmonStop_but, "hidemode 3, wrap");
                    this.l_hostmonStart_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                try {
                                    hostMonitor.setPaused(false);
                                    hostMonitor.start();
                                }
                                catch (Exception ex) {
                                    SwingUtils.showErrorMessage("Start", "Problems Starting the Host Monitoring Thread.", ex);
                                }
                            }
                        }
                    });
                    this.l_hostmonStop_but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostMonitor hostMonitor;
                            CountersModel cm = this.getCm();
                            if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                hostMonitor.setPaused(true);
                                hostMonitor.shutdown();
                            }
                        }
                    });
                    return panel;
                }

                @Override
                public void checkLocalComponents() {
                    CountersModel cm = this.getCm();
                    if (cm != null) {
                        HostMonitor hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor");
                        if (hostMonitor != null) {
                            boolean isRunning = hostMonitor.isRunning();
                            boolean isPaused = hostMonitor.isPaused();
                            this.l_hostmonThreadIsRunning_lbl.setText("<html>Command: <b>" + hostMonitor.getCommand() + "</b></html>");
                            this.l_hostmonThreadNotInit_lbl.setVisible(false);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(isRunning);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(!isRunning);
                            this.l_hostmonHostname_lbl.setText("<html> Host: <b>" + hostMonitor.getHostname() + "</b></html>");
                            this.l_hostmonStart_but.setVisible(!isRunning);
                            this.l_hostmonStop_but.setVisible(isRunning);
                            if (isPaused) {
                                this.setWatermarkText("Warning: The host monitoring thread is Stopped/Paused!");
                            }
                        } else {
                            this.setWatermarkText("Host Monitoring is Disabled or Initializing at Next sample.");
                            this.l_hostmonThreadNotInit_lbl.setVisible(true);
                            this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                            this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                            this.l_hostmonStart_but.setVisible(false);
                            this.l_hostmonStop_but.setVisible(false);
                            if (cm.getSampleException() != null) {
                                this.setWatermarkText(cm.getSampleException().toString());
                            }
                        }
                    }
                }
            };
            tcp2.setToolTipText(description);
            tcp2.setIcon(SwingUtils.readImageIcon(Version.class, "images/cm_hostmon_mpstat.png"));
            tcp2.setCm(tmp);
            MainFrame.addTcp(tcp2);
            tmp.setTabPanel(tcp2);
        }
        _CMList.add(tmp);
        this.createUserDefinedCounterModels();
        this.createUserDefinedCounterModelHostMonitors();
        _countersIsCreated = true;
    }

    private void createUserDefinedCounterModels() {
        Configuration conf = null;
        conf = Asemon.hasGUI() ? Configuration.getCombinedConfiguration() : Configuration.getInstance("PCS");
        if (conf == null) {
            return;
        }
        GetCounters.createUserDefinedCounterModels(conf);
    }

    public static int createUserDefinedCounterModels(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("The passed Configuration can't be null");
        }
        int failCount = 0;
        String prefix = "udc.";
        for (String name : conf.getUniqueSubKeys(prefix, false)) {
            int i;
            SplashWindow.drawProgress("Loading: User Defined Counter Model '" + name + "'");
            String startKey = prefix + name + ".";
            HashMap<Integer, String> sqlVer = null;
            _logger.debug((Object)("STARTING TO Initializing User Defined Counter '" + name + "'."));
            String udcName = conf.getProperty(startKey + "name");
            String udcDisplayName = conf.getProperty(startKey + "displayName", udcName);
            String udcDescription = conf.getProperty(startKey + "description", "");
            String udcSqlInit = conf.getProperty(startKey + "sqlInit");
            String udcSqlClose = conf.getProperty(startKey + "sqlClose");
            String udcSql = conf.getProperty(startKey + "sql");
            String udcPk = conf.getProperty(startKey + "pk");
            String udcPkPos = conf.getProperty(startKey + "pkPos");
            String udcDiff = conf.getProperty(startKey + "diff");
            boolean udcNDCT0 = conf.getBooleanProperty(startKey + "negativeDiffCountersToZero", false);
            String udcNeedRole = conf.getProperty(startKey + "needRole");
            String udcNeedConfig = conf.getProperty(startKey + "needConfig");
            int udcNeedVersion = conf.getIntProperty(startKey + "needVersion", 0);
            int udcNeedCeVersion = conf.getIntProperty(startKey + "needCeVersion", 0);
            String udcTTMT = conf.getProperty(startKey + "toolTipMonTables");
            if (udcName == null) {
                _logger.error((Object)("Cant initialize User Defined Counter '" + name + "', no 'name' has been defined."));
                ++failCount;
                continue;
            }
            if (udcSql == null) {
                _logger.error((Object)("Cant initialize User Defined Counter '" + name + "', no 'sql' has been defined."));
                ++failCount;
                continue;
            }
            if (udcPkPos != null) {
                _logger.error((Object)("Cant initialize User Defined Counter '" + name + "', 'pkPos' are not longer supported, please use 'pk' instead."));
                ++failCount;
                continue;
            }
            if (udcPk == null) {
                _logger.error((Object)("Cant initialize User Defined Counter '" + name + "', no 'pk' has been defined."));
                ++failCount;
                continue;
            }
            String sqlVersionPrefix = startKey + "sql" + ".";
            for (String key : conf.getKeys(sqlVersionPrefix)) {
                String sqlVersionStr = key.substring(sqlVersionPrefix.length());
                int sqlVersionNumInKey = 0;
                try {
                    sqlVersionNumInKey = Integer.parseInt(sqlVersionStr);
                }
                catch (NumberFormatException ex) {
                    _logger.warn((Object)("Problems initialize User Defined Counter '" + name + "', a sql.##### where ##### should specify ASE server version if faulty in the string '" + sqlVersionStr + "'."));
                    ++failCount;
                    continue;
                }
                if (sqlVer == null) {
                    sqlVer = new HashMap<Integer, String>();
                }
                sqlVer.put(new Integer(sqlVersionNumInKey), conf.getProperty(sqlVersionPrefix + sqlVersionNumInKey));
            }
            LinkedList<String> udcPkList = new LinkedList<String>();
            String[] udcPkArray = new String[]{};
            String[] udcDiffArray = new String[]{};
            String[] udcTTMTArray = new String[]{};
            String[] udcNeedRoleArray = new String[]{};
            String[] udcNeedConfigArray = new String[]{};
            String[] udcPctArray = new String[]{};
            if (udcPk != null) {
                udcPkArray = udcPk.split(",");
            }
            if (udcDiff != null) {
                udcDiffArray = udcDiff.split(",");
            }
            if (udcTTMT != null) {
                udcTTMTArray = udcTTMT.split(",");
            }
            if (udcNeedRole != null) {
                udcNeedRoleArray = udcNeedRole.split(",");
            }
            if (udcNeedConfig != null) {
                udcNeedConfigArray = udcNeedConfig.split(",");
            }
            for (i = 0; i < udcPkArray.length; ++i) {
                udcPkArray[i] = udcPkArray[i].trim();
            }
            for (i = 0; i < udcDiffArray.length; ++i) {
                udcDiffArray[i] = udcDiffArray[i].trim();
            }
            for (i = 0; i < udcTTMTArray.length; ++i) {
                udcTTMTArray[i] = udcTTMTArray[i].trim();
            }
            for (i = 0; i < udcNeedRoleArray.length; ++i) {
                udcNeedRoleArray[i] = udcNeedRoleArray[i].trim();
            }
            for (i = 0; i < udcNeedConfigArray.length; ++i) {
                udcNeedConfigArray[i] = udcNeedConfigArray[i].trim();
            }
            for (i = 0; i < udcPkArray.length; ++i) {
                udcPkList.add(udcPkArray[i]);
            }
            _logger.info((Object)("Creating User Defined Counter '" + name + "' with sql '" + udcSql + "'."));
            CountersModelUserDefined cm = new CountersModelUserDefined(name, udcSql, sqlVer, udcPkList, udcDiffArray, udcPctArray, udcTTMTArray, udcNeedRoleArray, udcNeedConfigArray, udcNeedVersion, udcNeedCeVersion, udcNDCT0);
            TabularCntrPanel tcp = null;
            if (Asemon.hasGUI()) {
                tcp = new TabularCntrPanel(udcDisplayName);
                tcp.setToolTipText(udcDescription);
                tcp.setIcon(SwingUtils.readImageIcon(Version.class, "images/ud_counter_activity.png"));
                tcp.setCm(cm);
                MainFrame.addTcp(tcp);
            }
            cm.setTabPanel(tcp);
            cm.setSqlInit(udcSqlInit);
            cm.setSqlClose(udcSqlClose);
            cm.setDisplayName(udcDisplayName);
            cm.setDescription(udcDescription);
            GetCounters.addUdcGraph(cm, udcName, startKey, conf);
            _CMList.add(cm);
        }
        return failCount;
    }

    private static void addUdcGraph(CountersModel cm, String udcName, String startKey, Configuration conf) {
        int i;
        int udcGraphType = -1;
        boolean udcHasGraph = conf.getBooleanProperty(startKey + "graph", false);
        String udcGraphTypeStr = conf.getProperty(startKey + "graph.type", "byCol");
        String udcGraphName = conf.getProperty(startKey + "graph.name");
        String udcGraphLabel = conf.getProperty(startKey + "graph.label");
        String udcGraphMenuLabel = conf.getProperty(startKey + "graph.menuLabel");
        String udcGraphDataCols = conf.getProperty(startKey + "graph.data.cols");
        String udcGraphDataMethods = conf.getProperty(startKey + "graph.data.methods");
        String udcGraphDataLabels = conf.getProperty(startKey + "graph.data.labels");
        if (!udcHasGraph) {
            return;
        }
        String name = udcName;
        boolean addGraph = true;
        if (udcGraphName == null) {
            udcGraphName = udcName + "Graph";
        }
        if (udcGraphLabel == null) {
            udcGraphLabel = udcName + " Graph";
        }
        if (udcGraphMenuLabel == null) {
            udcGraphMenuLabel = udcGraphLabel;
        }
        if (udcGraphDataCols == null) {
            _logger.error((Object)("Cant add a graph to the User Defined Counter '" + name + "', no 'graph.data.cols' has been defined."));
            addGraph = false;
        }
        if (udcGraphDataMethods == null) {
            _logger.error((Object)("Cant add a graph to the User Defined Counter '" + name + "', no 'graph.data.methods' has been defined."));
            addGraph = false;
        }
        if (udcGraphDataLabels == null) {
            udcGraphDataLabels = udcGraphDataCols;
        }
        if (udcGraphTypeStr.equalsIgnoreCase("byCol")) {
            udcGraphType = 1;
        } else if (udcGraphTypeStr.equalsIgnoreCase("byRow")) {
            udcGraphType = 2;
        } else {
            _logger.error((Object)("Cant add a graph to the User Defined Counter '" + name + "', no 'graph.type' can only be 'byCol' or 'byRow'."));
            addGraph = false;
        }
        String[] udcGraphDataColsArr = new String[]{};
        String[] udcGraphDataMethodsArr = new String[]{};
        String[] udcGraphDataLabelsArr = new String[]{};
        if (udcGraphDataCols != null) {
            udcGraphDataColsArr = udcGraphDataCols.split(",");
        }
        if (udcGraphDataMethods != null) {
            udcGraphDataMethodsArr = udcGraphDataMethods.split(",");
        }
        if (udcGraphDataLabels != null) {
            udcGraphDataLabelsArr = udcGraphDataLabels.split(",");
        }
        for (i = 0; i < udcGraphDataColsArr.length; ++i) {
            udcGraphDataColsArr[i] = udcGraphDataColsArr[i].trim();
        }
        for (i = 0; i < udcGraphDataMethodsArr.length; ++i) {
            udcGraphDataMethodsArr[i] = udcGraphDataMethodsArr[i].trim();
        }
        for (i = 0; i < udcGraphDataLabelsArr.length; ++i) {
            udcGraphDataLabelsArr[i] = udcGraphDataLabelsArr[i].trim();
        }
        if (udcGraphDataColsArr.length != udcGraphDataMethodsArr.length) {
            _logger.error((Object)("Cant add a graph to the User Defined Counter '" + name + "'. 'graph.data.cols' has " + udcGraphDataColsArr.length + " entries while 'graph.data.methods' has " + udcGraphDataMethodsArr.length + " entries, they has to be equal."));
            addGraph = false;
        }
        if (udcGraphDataColsArr.length != udcGraphDataLabelsArr.length) {
            _logger.error((Object)("Cant add a graph to the User Defined Counter '" + name + "'. 'graph.data.cols' has " + udcGraphDataColsArr.length + " entries while 'graph.data.labels' has " + udcGraphDataLabelsArr.length + " entries, they has to be equal."));
            addGraph = false;
        }
        for (i = 0; i < udcGraphDataMethodsArr.length; ++i) {
            if (CountersModel.isValidGraphMethod(udcGraphDataMethodsArr[i], true)) continue;
            _logger.error((Object)("Can't add a graph to the User Defined Counter '" + name + "'. 'The graph method '" + udcGraphDataMethodsArr[i] + "' is unknown."));
            _logger.error((Object)("Valid method names is: " + CountersModel.getValidGraphMethodsString(true)));
            addGraph = false;
        }
        if (udcGraphType == 2 && udcGraphDataColsArr.length > 1) {
            _logger.warn((Object)("Add a graph using type 'byRow' to the User Defined Counter '" + name + "'. Only the first entry in 'graph.data.cols', 'graph.data.labels', 'graph.data.methods' will be used"));
        }
        if (addGraph) {
            if (Asemon.hasGUI()) {
                TrendGraph tg = new TrendGraph(udcGraphName, udcGraphMenuLabel, udcGraphLabel, udcGraphDataLabelsArr, false, cm, true, -1);
                tg.setGraphType(udcGraphType);
                tg.setGraphCalculations(udcGraphDataColsArr, udcGraphDataMethodsArr);
                cm.addTrendGraph(udcGraphName, tg, true);
            }
            cm.setGraphType(udcGraphType);
            cm.setGraphCalculations(udcGraphDataColsArr, udcGraphDataMethodsArr);
            cm.addTrendGraphData(udcGraphName, new TrendGraphDataPoint(udcGraphName, udcGraphDataLabelsArr));
        }
    }

    private void createUserDefinedCounterModelHostMonitors() {
        Configuration conf = null;
        conf = Asemon.hasGUI() ? Configuration.getCombinedConfiguration() : Configuration.getInstance("PCS");
        if (conf == null) {
            return;
        }
        GetCounters.createUserDefinedCounterModelHostMonitors(conf);
    }

    public static int createUserDefinedCounterModelHostMonitors(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("The passed Configuration can't be null");
        }
        int failCount = 0;
        String prefix = "hostmon.udc.";
        for (String name : conf.getUniqueSubKeys(prefix, false)) {
            SplashWindow.drawProgress("Loading: Host Monitor User Defined Counter '" + name + "'");
            String startKey = prefix + name + ".";
            _logger.debug((Object)("STARTING TO Initializing Host Monitor User Defined Counter '" + name + "'."));
            String udcDisplayName = conf.getProperty(startKey + "displayName", name);
            String udcDescription = conf.getProperty(startKey + "description", "");
            _logger.info((Object)("Creating User Defined Host Monitor Counter '" + name + "'."));
            CounterModelHostMonitor cm = new CounterModelHostMonitor(name, 4, name, false);
            TabularCntrPanel tcp = null;
            if (Asemon.hasGUI()) {
                tcp = new TabularCntrPanel(udcDisplayName){
                    private static final long serialVersionUID = 1L;
                    JLabel l_hostmonThreadNotInit_lbl;
                    JLabel l_hostmonThreadIsRunning_lbl;
                    JLabel l_hostmonThreadIsStopped_lbl;
                    JButton l_hostmonStart_but;
                    JButton l_hostmonStop_but;

                    @Override
                    protected JPanel createLocalOptionsPanel() {
                        JPanel panel = SwingUtils.createPanel("Host Monitor", true);
                        panel.setLayout((LayoutManager)new MigLayout("ins 5, gap 0", "", "0[0]0"));
                        panel.setToolTipText("<html>Use this panel to check or controll the underlying Host Monitoring Thread.<br>You can Start and/or Stop the hostmon thread.<br></html>");
                        this.l_hostmonThreadNotInit_lbl = new JLabel("<html><b>Not yet initialized</b></html>");
                        this.l_hostmonThreadIsRunning_lbl = new JLabel("<html>Is running</html>");
                        this.l_hostmonThreadIsStopped_lbl = new JLabel("<html><b>Is stopped</b></html>");
                        this.l_hostmonStart_but = new JButton("Start");
                        this.l_hostmonStop_but = new JButton("Stop");
                        this.l_hostmonThreadNotInit_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread has not yet been initialized.</html>");
                        this.l_hostmonThreadIsRunning_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                        this.l_hostmonThreadIsStopped_lbl.setToolTipText("<html>Indicates wheather the underlying Host Monitor Thread is running.</html>");
                        this.l_hostmonStart_but.setToolTipText("<html>Start the underlying Host Monitor Thread.</html>");
                        this.l_hostmonStop_but.setToolTipText("<html>Stop the underlying Host Monitor Thread.</html>");
                        this.l_hostmonThreadNotInit_lbl.setVisible(true);
                        this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                        this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                        this.l_hostmonStart_but.setVisible(false);
                        this.l_hostmonStop_but.setVisible(false);
                        panel.add((Component)this.l_hostmonThreadNotInit_lbl, "hidemode 3, wrap 10");
                        panel.add((Component)this.l_hostmonThreadIsRunning_lbl, "hidemode 3, wrap 10");
                        panel.add((Component)this.l_hostmonThreadIsStopped_lbl, "hidemode 3, wrap 10");
                        panel.add((Component)this.l_hostmonStart_but, "hidemode 3, wrap");
                        panel.add((Component)this.l_hostmonStop_but, "hidemode 3, wrap");
                        this.l_hostmonStart_but.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                HostMonitor hostMonitor;
                                CountersModel cm = this.getCm();
                                if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                    try {
                                        hostMonitor.setPaused(false);
                                        hostMonitor.start();
                                    }
                                    catch (Exception ex) {
                                        SwingUtils.showErrorMessage("Start", "Problems Starting the Host Monitoring Thread.", ex);
                                    }
                                }
                            }
                        });
                        this.l_hostmonStop_but.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                HostMonitor hostMonitor;
                                CountersModel cm = this.getCm();
                                if (cm != null && (hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor")) != null) {
                                    hostMonitor.setPaused(true);
                                    hostMonitor.shutdown();
                                }
                            }
                        });
                        return panel;
                    }

                    @Override
                    public void checkLocalComponents() {
                        CountersModel cm = this.getCm();
                        if (cm != null) {
                            HostMonitor hostMonitor = (HostMonitor)cm.getClientProperty("HostMonitor");
                            if (hostMonitor != null) {
                                boolean isRunning = hostMonitor.isRunning();
                                boolean isPaused = hostMonitor.isPaused();
                                this.l_hostmonThreadIsRunning_lbl.setText("<html>Command: <b>" + hostMonitor.getCommand() + "</b></html>");
                                this.l_hostmonThreadNotInit_lbl.setVisible(false);
                                if (hostMonitor.isOsCommandStreaming()) {
                                    this.l_hostmonThreadIsRunning_lbl.setVisible(isRunning);
                                    this.l_hostmonThreadIsStopped_lbl.setVisible(!isRunning);
                                    this.l_hostmonStart_but.setVisible(!isRunning);
                                    this.l_hostmonStop_but.setVisible(isRunning);
                                } else {
                                    this.l_hostmonThreadIsRunning_lbl.setVisible(true);
                                    this.l_hostmonThreadIsStopped_lbl.setText("<html>This module has <b>no</b> background thread.<br>And it's executed on every <b>refresh</b>.</html>");
                                    this.l_hostmonThreadIsStopped_lbl.setVisible(true);
                                    this.l_hostmonStart_but.setVisible(false);
                                    this.l_hostmonStop_but.setVisible(false);
                                }
                                if (isPaused) {
                                    this.setWatermarkText("Warning: The host monitoring thread is Stopped/Paused!");
                                }
                            } else {
                                this.setWatermarkText("Host Monitoring is Disabled or Initializing at Next sample.");
                                this.l_hostmonThreadNotInit_lbl.setVisible(true);
                                this.l_hostmonThreadIsRunning_lbl.setVisible(false);
                                this.l_hostmonThreadIsStopped_lbl.setVisible(false);
                                this.l_hostmonStart_but.setVisible(false);
                                this.l_hostmonStop_but.setVisible(false);
                                if (cm.getSampleException() != null) {
                                    this.setWatermarkText(cm.getSampleException().toString());
                                }
                            }
                        }
                    }
                };
                tcp.setToolTipText(udcDescription);
                tcp.setIcon(SwingUtils.readImageIcon(Version.class, "images/hostmon_ud_counter_activity.png"));
                tcp.setCm(cm);
                MainFrame.addTcp(tcp);
            }
            cm.setTabPanel(tcp);
            cm.setDisplayName(udcDisplayName);
            cm.setDescription(udcDescription);
            GetCounters.addUdcGraph(cm, name, startKey, conf);
            _CMList.add(cm);
        }
        return failCount;
    }

    public static void initExtraMonTablesDictionary() {
        try {
            MonTablesDictionary mtd = MonTablesDictionary.getInstance();
            if (mtd == null) {
                return;
            }
            String clientXxx = "<html>The clientname, clienthostname and clientapplname is assigned by client code with individual information.<br>This is useful for differentiating among clients in a system where many clients connect to Adaptive Server using the same name, host name, or application name.<br>It can also be used by the client as a trace to indicate what part of the client code that is executing.<br><br>Client code has probably executed:<br><code>set [clientname client_name | clienthostname host_name | clientapplname application_name] value</code></html>";
            mtd.addTable("sysprocesses", "Holds information about SybasePID or threads/users logged in to the ASE.");
            mtd.addColumn("sysprocesses", "kpid", "Kernel Process Identifier.");
            mtd.addColumn("sysprocesses", "fid", "SPID of the parent process, Family ID.");
            mtd.addColumn("sysprocesses", "spid", "Session Process Identifier.");
            mtd.addColumn("sysprocesses", "program_name", "Name of the client program, the client application has to set this to a value otherwise it will be empty.");
            mtd.addColumn("sysprocesses", "dbname", "Name of the database this user is currently using.");
            mtd.addColumn("sysprocesses", "login", "Username that is logged in.");
            mtd.addColumn("sysprocesses", "status", "Status that the SPID is currently in. \n'recv sleep'=waiting for incomming network trafic, \n'sleep'=various reasons but usually waiting for disk io, \n'running'=currently executing on a engine, \n'runnable'=waiting for an engine to execute its work, \n'lock sleep'=waiting for table/page/row locks, \n'sync sleep'=waiting for childs to finnish when parallel execution. \n'...'=and more statuses");
            mtd.addColumn("sysprocesses", "cmd", "What are we doing. \n'SELECT/INSERT/UPDATE/DELETE'=quite obvious, \n'LOG SUSP'=waiting for log space to be available, \n'COND'=On a IF or equivalent SQL statement, \n'...'=and more");
            mtd.addColumn("sysprocesses", "tran_name", "More info about what the ASE is doing. \nIf we are in CREATE INDEX it will tell you the index name. \nIf we are in BCP it will give you the tablename etc. \nThis is a good place to look at when you issue ASE administrational commands and want to know whet it really does.");
            mtd.addColumn("sysprocesses", "physical_io", "Total number of reads/writes, this is flushed in a strange way, so do not trust the Absolute value to much...");
            mtd.addColumn("sysprocesses", "procName", "If a procedure is executing, this will be the name of the proc. \nif you execute a sp_ proc, it could give you a procedure name that is uncorrect. \nThis due to the fact that I'm using object_name(id,dbid) and dbid is the database the SPID is currently in, while the procId is really reflecting the id of the sp_ proc which usually is located in sybsystemprocs.");
            mtd.addColumn("sysprocesses", "stmtnum", "Statement number of the SQL batch or the procedure that is currently executing. \nThis might be faulty but it's usually a good indicator.");
            mtd.addColumn("sysprocesses", "linenum", "Line number of the SQL batch or the procedure that is currently executing. \nThis might be faulty but it's usually a good indicator. \nIf this does NOT move between samples you may have a HEAVY SQL statement to optimize or you may waiting for a blocking lock.");
            mtd.addColumn("sysprocesses", "blocked", "0 is a good value, otherwise it will be the SPID that we are blocked by, meaning we are waiting for that SPID to release it's locks on some objetc.");
            mtd.addColumn("sysprocesses", "time_blocked", "Number of seconds we have been blocked by other SPID's. \nThis is not a summary, it shows you how many seconds we have been waiting since we started to wait for the other SPID to finnish.");
            mtd.addColumn("sysprocesses", "clientname", clientXxx);
            mtd.addColumn("sysprocesses", "clienthostname", clientXxx);
            mtd.addColumn("sysprocesses", "clientapplname", clientXxx);
            mtd.addColumn("sysprocesses", "tempdb_name", "What tempdb is this SPID using for temporary storage.");
            mtd.addColumn("sysprocesses", "pssinfo_tempdb_pages", "<html>Number of pages that this SPID is using in the tempdb.<br><b>NOTE:</b> When 'ordinary user' tables are shared between users in tempdb, this counter can be faulty,<br> this due to that all spids has a local counter (in the pss structure) which is NOT inc/decremented by other users working on the same 'global' temp table.</html>");
            mtd.addColumn("monProcess", "tempdb_name", "What tempdb is this SPID using for temporary storage.");
            mtd.addColumn("monProcess", "pssinfo_tempdb_pages", "<html>Number of pages that this SPID is using in the tempdb.<br><b>NOTE:</b> When 'ordinary user' tables are shared between users in tempdb, this counter can be faulty,<br> this due to that all spids has a local counter (in the pss structure) which is NOT inc/decremented by other users working on the same 'global' temp table.</html>");
            mtd.addColumn("monProcessStatement", "ExecTime", "The statement has been executing for ## seconds. Calculated value. <b>Formula</b>: ExecTime=datediff(ss, StartTime, getdate())");
            mtd.addColumn("monProcessStatement", "ExecTimeInMs", "The statement has been executing for ## milliseconds. Calculated value. <b>Formula</b>: ExecTimeInMs=datediff(ms, StartTime, getdate())");
            mtd.addTable("sysmonitors", "This is basically where sp_sysmon gets it's counters.");
            mtd.addColumn("sysmonitors", "name", "The internal name of the counter, this is strictly Sybase ASE INTERNAL name. If the description is NOT set it's probably an 'unknown' or not that important counter.");
            mtd.addColumn("sysmonitors", "instances", "How many instances of this spinslock actually exists. For examples for 'default data cache' it's the number of 'cache partitions' the cache has.");
            mtd.addColumn("sysmonitors", "grabs", "Spinlock grabs as in attempted grabs for the spinlock - includes waits");
            mtd.addColumn("sysmonitors", "waits", "Spinlock waits - usually a good sign of contention");
            mtd.addColumn("sysmonitors", "spins", "Spinlock spins - this is the CPU spins that drives up CPU utilization. The higher the spin count, the more CPU usage and the more serious the performance impact of the spinlock on other processes not waiting");
            mtd.addColumn("sysmonitors", "contention", "waits / grabs, but in the percentage form. If this goes beond 10-20% then try to add more spinlock instances.");
            mtd.addColumn("sysmonitors", "spinsPerWait", "spins / waits, so this is numer of times we had to 'spin' before cound grab the spinlock. If we had to 'spin/wait' for other engines that hold the spinlock. Then how many times did we wait/spin' for other engies to release the lock. If this is high (more than 100 or 200) we might have to lower the numer of engines.");
            mtd.addColumn("sysmonitors", "description", "If it's a known sppinlock, this field would have a valid description.");
            mtd.addColumn("sysmonitors", "id", "The internal ID of the spinlock, for most cases this would just be a 'number' that identifies the spinlock if the spinlock itself are 'partitioned', meaning the spinlocks itselv are partitioned using some kind of 'hash' algorithm or simular.");
            mtd.addSpinlockDescription("tablockspins", "xxxx: tablockspins,  'lock table spinlock ratio'");
            mtd.addSpinlockDescription("fglockspins", "xxxx: fglockspins,   'lock spinlock ratio'");
            mtd.addSpinlockDescription("addrlockspins", "xxxx: addrlockspins, 'lock address spinlock ratio'");
            mtd.addSpinlockDescription("Resource->rdesmgr_spin", "xxxx: Object Manager Spinlock Contention");
            mtd.addSpinlockDescription("Des Upd Spinlocks", "xxxx: Object Spinlock Contention");
            mtd.addSpinlockDescription("Ides Spinlocks", "xxxx: Index Spinlock Contention");
            mtd.addSpinlockDescription("Ides Chain Spinlocks", "xxxx: Index Hash Spinlock Contention");
            mtd.addSpinlockDescription("Pdes Spinlocks", "xxxx: Partition Spinlock Contention");
            mtd.addSpinlockDescription("Pdes Chain Spinlocks", "xxxx: Partition Hash Spinlock Contention");
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public void doInterrupt() {
        if (this._thread != null) {
            _logger.debug((Object)("Sending 'interrupt' to the thread '" + this._thread.getName() + "', this was done by thread '" + Thread.currentThread().getName() + "'."));
            this._thread.interrupt();
        }
    }

    public void enableRefresh() {
        _refreshIsEnabled = true;
        if (this._thread != null) {
            _logger.debug((Object)("Sending 'interrupt' to the thread '" + this._thread.getName() + "' if it was sleeping... This was done by thread '" + Thread.currentThread().getName() + "'."));
            this._thread.interrupt();
        }
    }

    public void disableRefresh() {
        _refreshIsEnabled = false;
    }

    public boolean isRefreshEnabled() {
        return _refreshIsEnabled;
    }

    public boolean isRefreshingCounters() {
        return _refreshingCounters;
    }

    public static void setRefreshingCounters(boolean s) {
        _refreshingCounters = s;
    }

    public void clearComponents() {
        if (!_isInitialized) {
            return;
        }
        if (!this.isRefreshingCounters()) {
            MainFrame.clearSummaryData();
            for (CountersModel cm : _CMList) {
                if (cm == null) continue;
                cm.clear();
            }
            SummaryPanel.getInstance().clearGraph();
        }
    }

    public boolean isMonConnected() {
        return this.isMonConnected(false, false);
    }

    public boolean isMonConnected(boolean forceConnectionCheck, boolean closeConnOnFailure) {
        long diff;
        if (this._conn == null) {
            return false;
        }
        if (!forceConnectionCheck && (diff = System.currentTimeMillis() - this._lastIsClosedCheck) < this._lastIsClosedRefreshTime) {
            return true;
        }
        try {
            if (this._conn.isClosed()) {
                if (closeConnOnFailure) {
                    this.closeMonConnection();
                }
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        this._lastIsClosedCheck = System.currentTimeMillis();
        return true;
    }

    public void setMonConnection(Connection conn) {
        this._conn = conn;
    }

    public Connection getMonConnection() {
        return this._conn;
    }

    public void closeMonConnection() {
        if (this._conn == null) {
            return;
        }
        try {
            if (!this._conn.isClosed()) {
                this._conn.close();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Connection closed");
                }
            }
        }
        catch (SQLException ev) {
            _logger.error((Object)"closeMonConnection", (Throwable)ev);
        }
        this._conn = null;
    }

    public boolean isHostMonConnected() {
        return this.isHostMonConnected(false, false);
    }

    public boolean isHostMonConnected(boolean forceConnectionCheck, boolean closeConnOnFailure) {
        long diff;
        if (this._sshConn == null) {
            return false;
        }
        if (!forceConnectionCheck && (diff = System.currentTimeMillis() - this._sshLastIsClosedCheck) < this._sshLastIsClosedRefreshTime) {
            return true;
        }
        try {
            if (this._sshConn.isClosed()) {
                if (closeConnOnFailure) {
                    this.closeHostMonConnection();
                }
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        this._sshLastIsClosedCheck = System.currentTimeMillis();
        return true;
    }

    public void setHostMonConnection(SshConnection sshConn) {
        this._sshConn = sshConn;
    }

    public SshConnection getHostMonConnection() {
        return this._sshConn;
    }

    public void closeHostMonConnection() {
        if (this._sshConn == null) {
            return;
        }
        try {
            if (!this._sshConn.isClosed()) {
                this._sshConn.close();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"SSH Connection closed");
                }
            }
        }
        catch (Exception ev) {
            _logger.error((Object)"closeHostMonConnection", (Throwable)ev);
        }
        this._conn = null;
    }
}

