/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.MainFrame;
import asemon.gui.TabularCntrPanel;
import asemon.pcs.InMemoryCounterHandler;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.Configuration;
import asemon.utils.Memory;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GetCountersGui
extends GetCounters {
    private static Logger _logger = Logger.getLogger(GetCountersGui.class);

    public GetCountersGui() {
        GetCounters.setInstance(this);
    }

    @Override
    public void init() throws Exception {
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        Configuration conf = Configuration.getCombinedConfiguration();
        this.createCounters();
        String cmdLineUsername = null;
        String cmdLinePassword = null;
        String cmdLineServer = null;
        cmdLineUsername = conf.getProperty("cmdLine.aseUsername");
        cmdLinePassword = conf.getProperty("cmdLine.asePassword");
        cmdLineServer = conf.getProperty("cmdLine.aseServer");
        if (cmdLineUsername != null || cmdLinePassword != null || cmdLineServer != null) {
            String ppeStr = "conn.onStartup={aseUsername=" + conf.getProperty("cmdLine.aseUsername") + ",asePassword=" + conf.getProperty("cmdLine.asePassword") + ",aseServer=" + conf.getProperty("cmdLine.aseServer") + ",sshUsername=" + conf.getProperty("cmdLine.sshUsername") + ",sshPassword=" + conf.getProperty("cmdLine.sshPassword") + ",sshHostname=" + conf.getProperty("cmdLine.sshHostname") + ",sshPort=" + conf.getProperty("cmdLine.sshPort") + "}";
            MainFrame mf = MainFrame.getInstance();
            if (mf != null) {
                mf.action_connect(new ActionEvent(this, 1, ppeStr));
            }
        } else if (tmpConf.getBooleanProperty("conn.onStartup", false)) {
            String host = tmpConf.getProperty("conn.hostname");
            String port = tmpConf.getProperty("conn.port");
            String user = tmpConf.getProperty("conn.username");
            String aseServer = AseConnectionFactory.getServer();
            _logger.info((Object)("Connecting ON-STARTUP to host='" + host + "', port='" + port + "', srvName='" + aseServer + "', user='" + user + "'. This by using a non visible ConnectionDialog."));
            MainFrame mf = MainFrame.getInstance();
            if (mf != null) {
                mf.action_connect(new ActionEvent(this, 1, "conn.onStartup"));
            }
        }
    }

    @Override
    public void setMonConnection(Connection conn) {
        super.setMonConnection(conn);
        MainFrame.setStatus(1);
    }

    @Override
    public void run() {
        boolean firstLoopAfterConnect = true;
        boolean canDoReconnect = false;
        int reconnectProblems = 0;
        boolean startNewPcsSession = false;
        this.setName("GetCountersGUI");
        this._thread = Thread.currentThread();
        int loopCounter = 0;
        InMemoryCounterHandler imch = null;
        try {
            imch = new InMemoryCounterHandler();
            imch.init(Configuration.getCombinedConfiguration());
            InMemoryCounterHandler.setInstance(imch);
            imch.addChangeListener(MainFrame.getInstance());
            imch.start();
        }
        catch (Exception e) {
            _logger.error((Object)"Problems initializing InMemoryCounterHandler,", (Throwable)e);
        }
        while (true) {
            MainFrame.setStatus(6);
            if (MainFrame.isOfflineConnected()) {
                MainFrame.setStatus(2);
                MainFrame.setStatus(4, "Offline read mode, use the offline window to navigate.");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            if (!this.isMonConnected()) {
                firstLoopAfterConnect = true;
                if (!canDoReconnect) {
                    startNewPcsSession = true;
                }
                MainFrame.setStatus(3);
                MainFrame.setStatus(4, "Not connected to any server. Please connect now!");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (!canDoReconnect) continue;
                Configuration tmpConf = Configuration.getCombinedConfiguration();
                Map<String, List<String>> aseHostPortMap = AseConnectionFactory.getHostPortMap();
                boolean optReconnectOnFailure = tmpConf.getBooleanProperty("conn.reconnectOnFailure", false);
                if (!optReconnectOnFailure || aseHostPortMap == null || reconnectProblems >= 100) continue;
                try {
                    Connection conn = AseConnectionFactory.getConnection("master", Version.getAppName(), Version.getVersionStr());
                    this.setMonConnection(conn);
                    String str = AseConnectionFactory.getServer() + " (" + AseConnectionFactory.getHostPortStr() + ")";
                    _logger.info((Object)("Re-connected to monitored server '" + str + "' after a 'lost connection'."));
                    reconnectProblems = 0;
                }
                catch (Exception e) {
                    ++reconnectProblems;
                    _logger.warn((Object)("Problem when re-connecting to monitored server. Caught: " + e));
                    _logger.debug((Object)("Problem when re-connecting to monitored server. Caught: " + e), (Throwable)e);
                    MainFrame.setStatus(4, "Re-connect FAILED, I will soon try again.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                continue;
            }
            if (this.isMonConnected()) {
                canDoReconnect = true;
            }
            ++loopCounter;
            if (Memory.checkMemoryUsage(10)) {
                ActionEvent doGcEvent = new ActionEvent(this, 0, "OUT_OF_MEMORY");
                MainFrame.getInstance().actionPerformed(doGcEvent);
            }
            try {
                if (!firstLoopAfterConnect) {
                    int sleepTime;
                    for (int i = sleepTime = MainFrame.getRefreshInterval(); i > 0; --i) {
                        if (MainFrame.getStatus(4).startsWith("Sleeping for ")) {
                            MainFrame.setStatus(4, "Sleeping for " + i + " seconds, waiting for " + GetCountersGui.getWaitEvent());
                        }
                        for (CountersModel cm : _CMList) {
                            TabularCntrPanel tcp;
                            if (cm == null || (tcp = cm.getTabPanel()) == null) continue;
                            tcp.setWatermark();
                            tcp.checkLocalComponents();
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ignore) {
                            break;
                        }
                    }
                }
                firstLoopAfterConnect = false;
                while (MainFrame.isSamplingPaused()) {
                    MainFrame.setStatus(4, "PAUSED the data sampling. Press |> to continue...");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                if (!this.isRefreshEnabled()) continue;
                if (!this.isInitialized()) {
                    MainFrame.setStatus(4, "Initializing all counters...");
                    this.initCounters(this.getMonConnection(), true, MonTablesDictionary.getInstance().aseVersionNum, MonTablesDictionary.getInstance().isClusterEnabled, MonTablesDictionary.getInstance().montablesVersionNum);
                    MainFrame.setStatus(1);
                }
                this.checkForFullTransLogInMaster(this.getMonConnection());
                GetCountersGui.setRefreshingCounters(true);
                MainFrame.setStatus(4, "Refreshing...");
                PersistentCounterHandler pcs = PersistentCounterHandler.getInstance();
                String aseServerName = null;
                String aseHostname = null;
                Timestamp mainSampleTime = null;
                Timestamp counterClearTime = null;
                Statement stmt = this.getMonConnection().createStatement();
                String sql = "select getdate(), @@servername, 'ONLY_ABOVE_ASE_1502', CountersCleared from master..monState";
                if (MonTablesDictionary.getInstance().aseVersionNum >= 15020) {
                    sql = "select getdate(), @@servername, asehostname(),         CountersCleared from master..monState";
                }
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    mainSampleTime = rs.getTimestamp(1);
                    aseServerName = rs.getString(2);
                    aseHostname = rs.getString(3);
                    counterClearTime = rs.getTimestamp(4);
                }
                rs.close();
                stmt.close();
                PersistContainer pc = null;
                if (pcs != null || imch != null) {
                    pc = new PersistContainer(mainSampleTime, aseServerName, aseHostname);
                    if (startNewPcsSession) {
                        pc.setStartNewSample(true);
                    }
                    startNewPcsSession = false;
                }
                for (CountersModel cm : _CMList) {
                    if (cm == null) {
                        _logger.info((Object)"CountersModel: IS NULL.");
                        continue;
                    }
                    if (cm.getTabPanel() != null) {
                        if (pcs == null) {
                            cm.getTabPanel().enableOptionPersistCounters(false);
                        } else {
                            cm.getTabPanel().enableOptionPersistCounters(true);
                        }
                    }
                    if (cm.isRefreshable()) {
                        cm.setServerName(aseServerName);
                        cm.setSampleTimeHead(mainSampleTime);
                        cm.setCounterClearTime(counterClearTime);
                        try {
                            MainFrame.setStatus(4, "Refreshing... " + cm.getDisplayName());
                            cm.setSampleException(null);
                            cm.refresh();
                            if (pc != null && cm.isPersistCountersEnabled() || imch != null) {
                                pc.add(cm);
                            }
                        }
                        catch (Exception ex) {
                            cm.setSampleException(ex);
                        }
                    }
                    cm.endOfRefresh();
                }
                if (pcs != null) {
                    pcs.add(pc);
                }
                if (imch != null) {
                    imch.add(pc);
                }
                MainFrame.setStatus(4, "Refreshing... Graphs...");
                _logger.debug((Object)"---- Refreshing... Graphs... ----");
                for (CountersModel cm : _CMList) {
                    if (cm == null || !cm.hasActiveGraphs()) continue;
                    final CountersModel fcm = cm;
                    Runnable doWork = new Runnable(){

                        @Override
                        public void run() {
                            fcm.updateGraphs();
                        }
                    };
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(doWork);
                        continue;
                    }
                    doWork.run();
                }
                GetCountersGui.setRefreshingCounters(false);
                GetCountersGui.setWaitEvent("next sample period...");
                MainFrame.setStatus(4, "Sleeping for " + MainFrame.getRefreshInterval() + " seconds.");
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)("asemon : error in GetCounters loop (" + e.getMessage() + ")."), (Throwable)e);
                GetCountersGui.setRefreshingCounters(false);
                continue;
            }
            break;
        }
    }
}

