/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.AseConfig;
import asemon.AseConfigText;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.Version;
import asemon.check.CheckForUpdates;
import asemon.cm.CounterModelHostMonitor;
import asemon.cm.CounterSetTemplates;
import asemon.cm.CountersModel;
import asemon.hostmon.SshConnection;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.MandatoryPropertyException;
import asemon.utils.Memory;
import asemon.utils.PropPropEntry;
import asemon.utils.StringUtil;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GetCountersNoGui
extends GetCounters {
    private static Logger _logger = Logger.getLogger(GetCountersNoGui.class);
    private int _sleepTime = 60;
    private int _shutdownAfterXHours = 0;
    private int _sleepOnFailedConnectTime = 60;
    private String _aseUsername = null;
    private String _asePassword = null;
    private String _aseServer = null;
    private String _aseHostPortStr = null;
    private String _sshUsername = null;
    private String _sshPassword = null;
    private String _sshHostname = null;
    private String _sshPortStr = null;
    private int _sshPort = 22;
    private Configuration _storeProps = null;
    private boolean _running = true;

    public GetCountersNoGui() {
        GetCounters.setInstance(this);
    }

    public static boolean checkValidCmShortcuts(String options) {
        if (!new File(options).exists()) {
            if (options.indexOf(44) >= 0) {
                return true;
            }
            if (options.equals("small") || options.equals("medium") || options.equals("large") || options.equals("all")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void init() throws Exception {
        char[] passwd;
        Console cons;
        String aseServerStr;
        String offlinePrefix = "offline.";
        String connPrefix = "conn.";
        this._storeProps = Configuration.getInstance("PCS");
        if (this._storeProps == null || this._storeProps != null && this._storeProps.size() == 0) {
            throw new Exception("No persistent storage configuration was found. Persistent storage are configured via Command Line Switch '-noGui'");
        }
        _logger.info((Object)("Initializing the NO-GUI sampler component. Using config file '" + this._storeProps.getFilename() + "'."));
        this._sleepTime = this._storeProps.getIntMandatoryProperty(offlinePrefix + "sampleTime");
        this._shutdownAfterXHours = this._storeProps.getIntProperty(offlinePrefix + "shutdownAfterXHours", this._shutdownAfterXHours);
        this._sleepOnFailedConnectTime = this._storeProps.getIntProperty(offlinePrefix + "sleepOnFailedConnectTime", this._sleepOnFailedConnectTime);
        this._aseUsername = this._storeProps.getProperty(connPrefix + "aseUsername");
        this._asePassword = this._storeProps.getProperty(connPrefix + "asePassword");
        this._aseServer = this._storeProps.getProperty(connPrefix + "aseName");
        String aseHosts = this._storeProps.getProperty(connPrefix + "aseHost");
        String asePorts = this._storeProps.getProperty(connPrefix + "asePort");
        this._aseHostPortStr = this._storeProps.getProperty(connPrefix + "aseHostPort");
        this._sshUsername = this._storeProps.getProperty(connPrefix + "sshUsername");
        this._sshPassword = this._storeProps.getProperty(connPrefix + "sshPassword");
        this._sshHostname = this._storeProps.getProperty(connPrefix + "sshHostname");
        this._sshPortStr = this._storeProps.getProperty(connPrefix + "sshPort");
        if (this._sshPortStr != null && !this._sshPortStr.equals("")) {
            this._sshPort = Integer.parseInt(this._sshPortStr);
        }
        if (this._aseUsername == null) {
            throw new Exception("No ASE User has been specified. Not by commandLine parameters '-U', or by property 'conn.aseUsername' in the file '" + this._storeProps.getFilename() + "'.");
        }
        if (this._aseServer == null) {
            throw new Exception("No ASE Server has been specified. Not by commandLine parameters '-S', or by property 'conn.aseName' in the file '" + this._storeProps.getFilename() + "'.");
        }
        if (this._aseHostPortStr == null && aseHosts != null && asePorts != null) {
            this._aseHostPortStr = AseConnectionFactory.toHostPortStr(aseHosts, asePorts);
        }
        if ((aseServerStr = this._aseServer).indexOf(":") == -1) {
            aseServerStr = AseConnectionFactory.getIHostPortStr(this._aseServer);
            if (aseServerStr == null) {
                _logger.info((Object)("Can't resolve or find ASE Server named '" + this._aseServer + "' in the interfaces/sql.ini file. Fallback on 'aseHostPort', which is '" + this._aseHostPortStr + "'."));
                throw new Exception("Can't resolve or find ASE Server named '" + this._aseServer + "' in the interfaces/sql.ini file. Fallback on 'aseHostPort', which is '" + this._aseHostPortStr + "'.");
            }
        } else if (this._aseHostPortStr != null) {
            aseServerStr = this._aseHostPortStr;
        }
        if (!AseConnectionFactory.isHostPortStrValid(aseServerStr)) {
            String error = AseConnectionFactory.isHostPortStrValidReason(aseServerStr);
            throw new Exception("The ASE Server connection specification '" + aseServerStr + "' is in a faulty format. The format should be 'hostname:port[,hostname2:port2[,hostnameN:portN]]', error='" + error + "'.");
        }
        this._aseHostPortStr = aseServerStr;
        if (this._aseHostPortStr == null && (aseHosts == null || asePorts == null)) {
            throw new MandatoryPropertyException("If the properties '" + connPrefix + "aseName' or '" + connPrefix + "aseHostPort' or cmdLine switch -S, is not specified. Then '" + connPrefix + "aseHost' and '" + connPrefix + "asePort' must be specified.");
        }
        if (this._asePassword == null && (cons = System.console()) != null) {
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("No password for ASE was specified use command line parameter -P or property '" + connPrefix + "asePassword' in the file '" + this._storeProps.getFilename() + "'.");
            System.out.println("Connecting to server '" + this._aseServer + "' at '" + this._aseHostPortStr + "' with the user name '" + this._aseUsername + "'.");
            System.out.println("-----------------------------------------------------------------------------");
            passwd = cons.readPassword("Password: ", new Object[0]);
            this._asePassword = new String(passwd);
        }
        if (this._asePassword.equalsIgnoreCase("null")) {
            this._asePassword = "";
        }
        if (this._sshHostname != null && this._sshPassword == null && (cons = System.console()) != null) {
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("No SSH password was specified use command line parameter -p or property '" + connPrefix + "sshPassword' in the file '" + this._storeProps.getFilename() + "'.");
            System.out.println("Connecting to host name '" + this._sshHostname + "' with the user name '" + this._sshUsername + "'.");
            System.out.println("-----------------------------------------------------------------------------");
            passwd = cons.readPassword("Password: ", new Object[0]);
            this._sshPassword = new String(passwd);
        }
        if (this._sshPassword != null && this._sshPassword.equalsIgnoreCase("null")) {
            this._sshPassword = "";
        }
        String configStr = "sleepTime='" + this._sleepTime + "', " + "shutdownAfterXHours='" + this._shutdownAfterXHours + "', " + "sleepOnFailedConnectTime='" + this._sleepOnFailedConnectTime + "', " + "_aseUsername='" + this._aseUsername + "', " + "_asePassword='*hidden*', " + "_aseServer='" + this._aseServer + "(" + this._aseHostPortStr + ")', " + "_sshUsername='" + this._sshUsername + "', " + "_sshPassword='*hidden*', " + "_sshHostname='" + this._sshHostname + "', " + "_sshPort='" + this._sshPort + "', " + ".";
        _logger.info((Object)("Configuration for NO-GUI sampler: " + configStr));
        this.createCounters();
        String cmOptions = this._storeProps.getProperty("cmdLine.cmOptions");
        if (cmOptions != null) {
            List<String> activeCmList = this.buildActiveCmList(cmOptions);
            for (CountersModel cm : _CMList) {
                cm.setActive(false, "Inactivated by offline config");
                cm.setPersistCounters(true, false);
                cm.setPostponeTime(0, false);
            }
            Iterator<Object> i$ = activeCmList.iterator();
            while (i$.hasNext()) {
                CountersModel cm;
                String cmNameStr;
                String cmName = cmNameStr = (String)i$.next();
                int postponeTime = 0;
                String[] optStr = cmNameStr.split(":");
                if (optStr.length > 1) {
                    try {
                        postponeTime = Integer.parseInt(optStr[1]);
                        cmName = optStr[0];
                    }
                    catch (NumberFormatException ignore) {
                        _logger.error((Object)("Can't read postpone time from the string '" + optStr[1] + "', since it's not a number. Full cmName/option was '" + optStr + "'."));
                    }
                }
                if ((cm = GetCountersNoGui.getCmByName(cmName)) == null) {
                    cm = GetCountersNoGui.getCmByDisplayName(cmName);
                }
                if (cm != null) {
                    cm.setActive(true, null);
                    cm.setPersistCounters(true, false);
                    cm.setPostponeTime(postponeTime, false);
                    continue;
                }
                _logger.warn((Object)("CM named '" + cmName + "' can't be found in the list of available CM's."));
            }
            int activeCount = 0;
            for (CountersModel cm : _CMList) {
                if (cm.isActive()) {
                    ++activeCount;
                    _logger.info((Object)(">Enabled  CM named " + StringUtil.left("'" + cm.getName() + "',", 23) + " postpone " + StringUtil.left("'" + cm.getPostponeTime() + "',", 8) + "Tab Name '" + cm.getDisplayName() + "'."));
                    continue;
                }
                _logger.info((Object)(" DISABLED CM named " + StringUtil.left("'" + cm.getName() + "',", 23) + " postpone " + StringUtil.left("'" + cm.getPostponeTime() + "',", 8) + "Tab Name '" + cm.getDisplayName() + "'."));
            }
            _logger.info((Object)("Setting " + activeCount + " CM's in active-sampling-state. The CMList contained " + _CMList.size() + " entries."));
            if (activeCount == 0) {
                throw new Exception("Can't find any CM's to sample. Check the command line option '-n cmNames'.");
            }
        } else {
            int activeCount = 0;
            for (CountersModel cm : _CMList) {
                String persistCountersKey = cm.getName() + "." + "persistCounters";
                if (cm == null) continue;
                if (!this._storeProps.getBooleanProperty(persistCountersKey, false)) {
                    cm.setActive(false, "Inactivated by offline config");
                    _logger.info((Object)(" DISABLED CM named " + StringUtil.left("'" + cm.getName() + "',", 23) + " postpone " + StringUtil.left("'" + cm.getPostponeTime() + "',", 8) + "Tab Name '" + cm.getDisplayName() + "'."));
                    continue;
                }
                ++activeCount;
                cm.setPersistCounters(true, false);
                _logger.info((Object)(">Enabled  CM named " + StringUtil.left("'" + cm.getName() + "',", 23) + " postpone " + StringUtil.left("'" + cm.getPostponeTime() + "',", 8) + "Tab Name '" + cm.getDisplayName() + "'."));
            }
            _logger.info((Object)("Setting " + activeCount + " CM's in active-sampling-state. The CMList contained " + _CMList.size() + " entries."));
            if (activeCount == 0) {
                throw new Exception("Can't find any CM's to sample. Check the file '" + this._storeProps.getFilename() + "', for the any keys ending with '.sample' and mark them as 'true'.");
            }
        }
        int activeCountHostMon = 0;
        for (CountersModel cm : _CMList) {
            if (!cm.isActive() || !(cm instanceof CounterModelHostMonitor)) continue;
            ++activeCountHostMon;
        }
        if (activeCountHostMon > 0 && (this._sshHostname == null || this._sshUsername == null || this._sshPassword == null)) {
            throw new Exception("There are " + activeCountHostMon + " active Performance Counters that are doing Host Monitoring, this is using SSH for communication, but no hostname/user/passwd is given. hostname='" + this._sshHostname + "', username='" + this._sshUsername + "', password='" + (this._sshPassword == null ? null : "*has*passwd*") + "'.");
        }
    }

    private List<String> buildActiveCmList(String cmOptions) {
        ArrayList<String> activeCmList = new ArrayList<String>();
        activeCmList.add("CMsummary");
        PropPropEntry ppe = null;
        if (cmOptions.equalsIgnoreCase("small")) {
            ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_SMALL;
        } else if (cmOptions.equalsIgnoreCase("medium")) {
            ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_MEDIUM;
        } else if (cmOptions.equalsIgnoreCase("large")) {
            ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_LARGE;
        } else if (cmOptions.equalsIgnoreCase("all")) {
            ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_ALL;
            for (CountersModel cm : _CMList) {
                if (cm == null || cm.isSystemCm()) continue;
                ppe.put(cm.getDisplayName(), "storePcs", "true");
                ppe.put(cm.getDisplayName(), "postpone", cm.getPostponeTime() + "");
            }
        }
        if (ppe != null) {
            for (String name : ppe.keySet()) {
                boolean storePcs = ppe.getBooleanProperty(name, "storePcs", false);
                int postpone = ppe.getIntProperty(name, "postpone", 0);
                if (!storePcs) continue;
                if (postpone <= 0) {
                    activeCmList.add(name);
                    continue;
                }
                activeCmList.add(name + ":" + postpone);
            }
            _logger.info((Object)("Found --noGui '" + cmOptions + "': enabling cm's named " + activeCmList));
        } else {
            String[] sa;
            for (String str : sa = cmOptions.split(",")) {
                activeCmList.add(str);
            }
            _logger.info((Object)("Found --noGui aListOfCmNames: enabling cm's named " + activeCmList));
        }
        return activeCmList;
    }

    @Override
    public void run() {
        this._thread = Thread.currentThread();
        this._thread.setName("GetCountersNoGui");
        boolean startNewPcsSession = false;
        int loopCounter = 0;
        MonTablesDictionary mtd = null;
        PersistentCounterHandler pch = null;
        try {
            pch = new PersistentCounterHandler();
            pch.init(this._storeProps);
            pch.start();
        }
        catch (Exception e) {
            _logger.error((Object)"Problems initializing PersistentCounterHandler,", (Throwable)e);
            return;
        }
        if (!pch.hasWriters()) {
            _logger.error((Object)"No writers installed to the PersistentCounterHandler, this is NO-GUI... So I do not see the need for me to start.");
            return;
        }
        long threadStartTime = System.currentTimeMillis();
        while (this._running) {
            long runningForXHours;
            if (!this.isMonConnected(true, true)) {
                AseConfig aseCfg;
                _logger.debug((Object)("Connecting to ASE server using. user='" + this._aseUsername + "', passwd='" + this._asePassword + "', hostPortStr='" + this._aseHostPortStr + "'. aseServer='" + this._aseServer + "'"));
                _logger.info((Object)("Connecting to ASE server using. user='" + this._aseUsername + "', passwd='" + "*hidden*" + "', hostPortStr='" + this._aseHostPortStr + "'. aseServer='" + this._aseServer + "'"));
                try {
                    this.setMonConnection(AseConnectionFactory.getConnection(this._aseHostPortStr, null, this._aseUsername, this._asePassword, Version.getAppName() + "-nogui", Version.getVersionStr(), (Properties)null, null));
                    AseConnectionFactory.setHostPort(this._aseHostPortStr);
                    if (!AseConnectionUtils.checkForMonitorOptions(this.getMonConnection(), this._aseUsername, false, null, new String[0])) {
                        AseConnectionUtils.setBasicAseMonitoring(this.getMonConnection());
                    }
                    if (!AseConnectionUtils.checkForMonitorOptions(this.getMonConnection(), this._aseUsername, false, null, new String[0])) {
                        _logger.error((Object)"Problems when checking the ASE Server for 'proper monitoring configuration'.");
                        this.closeMonConnection();
                        this._running = false;
                        continue;
                    }
                    CheckForUpdates.sendConnectInfoNoBlock();
                }
                catch (SQLException e) {
                    String msg = AseConnectionUtils.getMessageFromSQLException(e);
                    _logger.error((Object)("Problems when connecting to a ASE Server. " + msg));
                    if (e.getSQLState().equals("JZ00L")) {
                        this._running = false;
                        _logger.error((Object)("Faulty PASSWORD when connecting to the server '" + this._aseServer + "' at '" + this._aseHostPortStr + "', with user '" + this._aseUsername + "', I cant recover from this... exiting..."));
                        break;
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)("Problems when connecting to a ASE Server. " + e));
                }
                if (!this.isMonConnected(true, true)) {
                    _logger.error((Object)("Problems connecting to ASE server. sleeping for " + this._sleepOnFailedConnectTime + " seconds before retry..."));
                    try {
                        Thread.sleep(this._sleepTime * 1000);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                mtd = MonTablesDictionary.getInstance();
                if (!mtd.isInitialized()) {
                    mtd.initialize(this.getMonConnection(), false);
                    GetCounters.initExtraMonTablesDictionary();
                }
                if (!(aseCfg = AseConfig.getInstance()).isInitialized()) {
                    aseCfg.initialize(this.getMonConnection(), false, false, null);
                }
                AseConfigText.initializeAll(this.getMonConnection(), false, false, null);
            }
            if (!this.isHostMonConnected() && this._sshHostname != null && this._sshUsername != null && this._sshPassword != null) {
                _logger.info((Object)("Connecting to SSH server using. user='" + this._sshUsername + "', passwd='" + "*hidden*" + "', port='" + this._sshPort + "'. hostname='" + this._sshHostname + "'"));
                try {
                    SshConnection sshConn = new SshConnection(this._sshHostname, this._sshPort, this._sshUsername, this._sshPassword);
                    sshConn.connect();
                    this.setHostMonConnection(sshConn);
                }
                catch (IOException e) {
                    _logger.error((Object)("Host Monitoring: Failed to connect to SSH hostname='" + this._sshHostname + "', user='" + this._sshUsername + "'."), (Throwable)e);
                }
            }
            ++loopCounter;
            Memory.checkMemoryUsage(10);
            try {
                String aseServerName = null;
                String aseHostname = null;
                Timestamp mainSampleTime = null;
                Timestamp counterClearTime = null;
                Statement stmt = this.getMonConnection().createStatement();
                String sql = "select getdate(), @@servername, 'ONLY_ABOVE_ASE_1502', CountersCleared from master..monState";
                if (mtd.aseVersionNum >= 15020) {
                    sql = "select getdate(), @@servername, asehostname(),         CountersCleared from master..monState";
                }
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    mainSampleTime = rs.getTimestamp(1);
                    aseServerName = rs.getString(2);
                    aseHostname = rs.getString(3);
                    counterClearTime = rs.getTimestamp(4);
                }
                rs.close();
                stmt.close();
                if (!this.isInitialized()) {
                    this.initCounters(this.getMonConnection(), false, mtd.aseVersionNum, mtd.isClusterEnabled, mtd.montablesVersionNum);
                }
                if (_CMList == null || _CMList != null && _CMList.size() == 0) {
                    _logger.error((Object)"The list of known CM's is either null or empty, can't continue...");
                    continue;
                }
                this.checkForFullTransLogInMaster(this.getMonConnection());
                PersistContainer pc = new PersistContainer(mainSampleTime, aseServerName, aseHostname);
                if (startNewPcsSession) {
                    pc.setStartNewSample(true);
                }
                startNewPcsSession = false;
                for (CountersModel cm : _CMList) {
                    if (cm == null || !cm.isRefreshable()) continue;
                    cm.setServerName(aseServerName);
                    cm.setSampleTimeHead(mainSampleTime);
                    cm.setCounterClearTime(counterClearTime);
                    try {
                        cm.setSampleException(null);
                        cm.refresh();
                        pc.add(cm);
                    }
                    catch (Exception ex) {
                        if (ex instanceof SQLException) {
                            _logger.warn((Object)("Problem when refreshing cm '" + cm.getName() + "'. Caught: " + ex));
                        } else {
                            _logger.warn((Object)("Problem when refreshing cm '" + cm.getName() + "'. Caught: " + ex), (Throwable)ex);
                        }
                        cm.setSampleException(ex);
                    }
                    cm.endOfRefresh();
                }
                pch.add(pc);
            }
            catch (Throwable t) {
                _logger.error((Object)(Version.getAppName() + ": error in GetCounters loop."), t);
            }
            if (this._shutdownAfterXHours > 0 && (runningForXHours = (System.currentTimeMillis() - threadStartTime) / 1000L / 60L / 60L) >= (long)this._shutdownAfterXHours) {
                String startDateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(threadStartTime));
                _logger.info((Object)("Shutting down the 'no-gui' service after " + runningForXHours + " hours of service. It was started at '" + startDateStr + "'."));
                break;
            }
            if (_logger.isDebugEnabled()) {
                GetCountersNoGui.setWaitEvent("next sample period...");
                _logger.debug((Object)("Sleeping for " + this._sleepTime + " seconds. Waiting for " + GetCountersNoGui.getWaitEvent()));
            }
            try {
                Thread.sleep(this._sleepTime * 1000);
            }
            catch (InterruptedException ignore) {}
        }
        _logger.info((Object)("Thread '" + Thread.currentThread().getName() + "' ending..."));
        if (pch != null) {
            pch.stop();
        }
    }
}

