/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.Asemon;
import asemon.gui.MainFrame;
import asemon.pcs.PersistWriterBase;
import asemon.utils.AseConnectionUtils;
import asemon.utils.SwingUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MonTablesDictionary {
    private static Logger _logger = Logger.getLogger(MonTablesDictionary.class);
    private static MonTablesDictionary _instance = null;
    private boolean _hasGui = false;
    private HashMap<String, MonTableEntry> _monTables = null;
    public String aseVersionStr = "";
    public int aseVersionNum = 0;
    public boolean isClusterEnabled = false;
    public String montablesVersionStr = "";
    public int montablesVersionNum = 0;
    public String montablesStatus = "";
    public String installmasterVersionStr = "";
    public int installmasterVersionNum = 0;
    public String installmasterStatus = "";
    private Map<String, String> _sysMonitorsInfo = new HashMap<String, String>();
    private MonWaitClassInfoEntry[] _monWaitClassInfo = null;
    private MonWaitEventInfoEntry[] _monWaitEventInfo = null;
    private static String FROM_TAB_NAME = "?FROM_TAB_NAME?";
    private static String TAB_NAME = "?TAB_NAME?";
    private static String SQL_TABLES = "select \"TableID\", \"Columns\", \"Parameters\", \"Indicators\", \"Size\", \"TableName\", \"Description\" from " + FROM_TAB_NAME;
    private static String SQL_COLUMNS = "select \"TableID\", \"ColumnID\", \"TypeID\", \"Precision\", \"Scale\", \"Length\", \"Indicators\", \"TableName\", \"ColumnName\", \"TypeName\", \"Description\" from " + FROM_TAB_NAME + " where \"TableName\" = '" + TAB_NAME + "'";
    private static String SQL_MON_WAIT_CLASS_INFO_1 = "select max(WaitClassID) from monWaitClassInfo";
    private static String SQL_MON_WAIT_CLASS_INFO = "select WaitClassID, Description from monWaitClassInfo";
    private static String SQL_MON_WAIT_EVENT_INFO_1 = "select max(WaitEventID) from monWaitEventInfo";
    private static String SQL_MON_WAIT_EVENT_INFO = "select WaitEventID, WaitClassID, Description from monWaitEventInfo";
    private static String SQL_VERSION = "select @@version";
    private static String SQL_VERSION_NUM = "select @@version_number";
    private static String SQL_SP_VERSION = "sp_version";

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static MonTablesDictionary getInstance() {
        if (_instance == null) {
            _instance = new MonTablesDictionary();
        }
        return _instance;
    }

    public static void reset() {
        _instance = null;
    }

    public Map<String, MonTableEntry> getMonTablesDictionaryMap() {
        return this._monTables;
    }

    public boolean isInitialized() {
        return this._monTables != null;
    }

    public void initializeMonTabColHelper(Connection conn, boolean offline) {
        if (conn == null) {
            return;
        }
        this._monTables = new HashMap();
        String monTables = "monTables";
        String monTableColumns = "monTableColumns";
        if (offline) {
            monTables = PersistWriterBase.getTableName(6, null, true);
            monTableColumns = PersistWriterBase.getTableName(7, null, true);
        }
        String sql = null;
        try {
            Statement stmt = conn.createStatement();
            sql = SQL_TABLES.replace(FROM_TAB_NAME, monTables);
            if (!offline) {
                sql = sql.replace("\"", "");
            }
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MonTableEntry entry = new MonTableEntry();
                int pos = 1;
                entry._tableID = rs.getInt(pos++);
                entry._columns = rs.getInt(pos++);
                entry._parameters = rs.getInt(pos++);
                entry._indicators = rs.getInt(pos++);
                entry._size = rs.getInt(pos++);
                entry._tableName = rs.getString(pos++);
                entry._description = rs.getString(pos++);
                entry._monTableColumns = new HashMap();
                this._monTables.put(entry._tableName, entry);
            }
            rs.close();
        }
        catch (SQLException ex) {
            if (offline && ex.getMessage().contains("not found")) {
                _logger.warn((Object)"Tooltip on column headers wasn't available in the offline database. This simply means that tooltip wont be showed in various places.");
                return;
            }
            _logger.error((Object)("MonTablesDictionary:initialize:sql='" + sql + "'"), (Throwable)ex);
            this._monTables = null;
            return;
        }
        for (Map.Entry<String, MonTableEntry> mapEntry : this._monTables.entrySet()) {
            MonTableEntry monTableEntry = mapEntry.getValue();
            if (monTableEntry._monTableColumns == null) {
                monTableEntry._monTableColumns = new HashMap();
            } else {
                monTableEntry._monTableColumns.clear();
            }
            try {
                Statement stmt = conn.createStatement();
                sql = SQL_COLUMNS.replace(FROM_TAB_NAME, monTableColumns);
                sql = sql.replace(TAB_NAME, monTableEntry._tableName);
                if (!offline) {
                    sql = sql.replace("\"", "");
                }
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    MonTableColumnsEntry entry = new MonTableColumnsEntry();
                    int pos = 1;
                    entry._tableID = rs.getInt(pos++);
                    entry._columnID = rs.getInt(pos++);
                    entry._typeID = rs.getInt(pos++);
                    entry._precision = rs.getInt(pos++);
                    entry._scale = rs.getInt(pos++);
                    entry._length = rs.getInt(pos++);
                    entry._indicators = rs.getInt(pos++);
                    entry._tableName = rs.getString(pos++);
                    entry._columnName = rs.getString(pos++);
                    entry._typeName = rs.getString(pos++);
                    entry._description = rs.getString(pos++);
                    monTableEntry._monTableColumns.put(entry._columnName, entry);
                }
                rs.close();
            }
            catch (SQLException ex) {
                if (offline && ex.getMessage().contains("not found")) {
                    _logger.warn((Object)"Tooltip on column headers wasn't available in the offline database. This simply means that tooltip wont be showed in various places.");
                    return;
                }
                _logger.error((Object)("MonTablesDictionary:initialize:sql='" + sql + "'"), (Throwable)ex);
                this._monTables = null;
                return;
            }
        }
    }

    public void initialize(Connection conn, boolean hasGui) {
        String msg;
        int pos;
        Object entry;
        ResultSet rs;
        Statement stmt;
        if (conn == null) {
            return;
        }
        this._hasGui = hasGui;
        String sql = null;
        this.initializeMonTabColHelper(conn, false);
        try {
            sql = SQL_MON_WAIT_CLASS_INFO_1;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            int max_waitClassId = 0;
            while (rs.next()) {
                max_waitClassId = rs.getInt(1);
            }
            rs.close();
            this._monWaitClassInfo = new MonWaitClassInfoEntry[max_waitClassId + 1];
            rs = stmt.executeQuery(SQL_MON_WAIT_CLASS_INFO);
            while (rs.next()) {
                entry = new MonWaitClassInfoEntry();
                pos = 1;
                ((MonWaitClassInfoEntry)entry)._waitClassId = rs.getInt(pos++);
                ((MonWaitClassInfoEntry)entry)._description = rs.getString(pos++);
                _logger.debug((Object)("Adding WaitClassInfo: " + entry));
                this._monWaitClassInfo[((MonWaitClassInfoEntry)entry)._waitClassId] = entry;
            }
            rs.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"MonTablesDictionary:initialize, _monWaitClassInfo", (Throwable)ex);
            if (this._hasGui) {
                SwingUtils.showErrorMessage("MonTablesDictionary - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
            }
            this._monWaitClassInfo = null;
            return;
        }
        try {
            sql = SQL_MON_WAIT_EVENT_INFO_1;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            int max_waitEventId = 0;
            while (rs.next()) {
                max_waitEventId = rs.getInt(1);
            }
            rs.close();
            this._monWaitEventInfo = new MonWaitEventInfoEntry[max_waitEventId + 1];
            rs = stmt.executeQuery(SQL_MON_WAIT_EVENT_INFO);
            while (rs.next()) {
                entry = new MonWaitEventInfoEntry();
                pos = 1;
                ((MonWaitEventInfoEntry)entry)._waitEventId = rs.getInt(pos++);
                ((MonWaitEventInfoEntry)entry)._waitClassId = rs.getInt(pos++);
                ((MonWaitEventInfoEntry)entry)._description = rs.getString(pos++);
                _logger.debug((Object)("Adding WaitEventInfo: " + entry));
                this._monWaitEventInfo[((MonWaitEventInfoEntry)entry)._waitEventId] = entry;
            }
            rs.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"MonTablesDictionary:initialize, _monWaitEventInfo", (Throwable)ex);
            if (this._hasGui) {
                SwingUtils.showErrorMessage("MonTablesDictionary - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
            }
            this._monWaitEventInfo = null;
            return;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(SQL_VERSION_NUM);
            while (rs.next()) {
                this.aseVersionNum = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException ex) {
            _logger.debug((Object)"MonTablesDictionary:initialize, @@version_number, probably an early ASE version", (Throwable)ex);
        }
        try {
            sql = SQL_VERSION;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.aseVersionStr = rs.getString(1);
            }
            rs.close();
            int aseVersionNumFromVerStr = AseConnectionUtils.aseVersionStringToNumber(this.aseVersionStr);
            this.aseVersionNum = Math.max(this.aseVersionNum, aseVersionNumFromVerStr);
            if (AseConnectionUtils.isClusterEnabled(conn)) {
                this.isClusterEnabled = true;
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)"MonTablesDictionary:initialize, @@version", (Throwable)ex);
            if (this._hasGui) {
                SwingUtils.showErrorMessage("MonTablesDictionary - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
            }
            return;
        }
        if (this.aseVersionNum >= 12530) {
            try {
                sql = SQL_SP_VERSION;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String spVersion_scriptName = rs.getString(1);
                    String spVersion_versionStr = rs.getString(2);
                    String spVersion_status = rs.getString(3);
                    if (spVersion_scriptName.endsWith("montables")) {
                        this.montablesVersionStr = spVersion_versionStr;
                        this.montablesStatus = spVersion_status;
                        this.montablesVersionNum = AseConnectionUtils.aseVersionStringToNumber(this.montablesVersionStr);
                        if (!this.montablesStatus.equalsIgnoreCase("Complete")) {
                            this.montablesStatus = "incomplete";
                        }
                    }
                    if (!spVersion_scriptName.equals("installmaster")) continue;
                    this.installmasterVersionStr = spVersion_versionStr;
                    this.installmasterStatus = spVersion_status;
                    this.installmasterVersionNum = AseConnectionUtils.aseVersionStringToNumber(this.installmasterVersionStr);
                    if (this.installmasterStatus.equalsIgnoreCase("Complete")) continue;
                    this.installmasterStatus = "incomplete";
                }
                rs.close();
            }
            catch (SQLException ex) {
                _logger.warn((Object)("MonTablesDictionary:initialize, problems executing: " + SQL_SP_VERSION + ". Exception: " + ex.getMessage()));
                if (this._hasGui) {
                    SwingUtils.showErrorMessage("MonTablesDictionary - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
                }
                return;
            }
        }
        _logger.info((Object)("ASE 'montables'     for sp_version shows: Status='" + this.montablesStatus + "', VersionNum='" + this.montablesVersionNum + "', VersionStr='" + this.montablesVersionStr + "'."));
        _logger.info((Object)("ASE 'installmaster' for sp_version shows: Status='" + this.installmasterStatus + "', VersionNum='" + this.installmasterVersionNum + "', VersionStr='" + this.installmasterVersionStr + "'."));
        if (this.montablesStatus.equals("incomplete")) {
            msg = "ASE Monitoring tables has not been completely installed. Please check it's status with: sp_version";
            if (Asemon.hasGUI()) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, "asemon - connect check", 2);
            }
            _logger.warn((Object)msg);
        }
        if (this.montablesVersionNum > 0 && this.aseVersionNum / 10 != this.montablesVersionNum / 10) {
            msg = "ASE Monitoring tables may be of a faulty version. ASE Version is '" + this.aseVersionNum + "' while MonTables version is '" + this.montablesVersionNum + "'. Please check it's status with: sp_version";
            if (this._hasGui) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, "asemon - connect check", 2);
            }
            _logger.warn((Object)msg);
        }
        if (this.installmasterStatus.equals("incomplete")) {
            msg = "ASE 'installmaster' script has not been completely installed. Please check it's status with: sp_version";
            if (this._hasGui) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, "asemon - connect check", 0);
            }
            _logger.error((Object)msg);
        }
        if (this.installmasterVersionNum > 0 && this.aseVersionNum != this.installmasterVersionNum) {
            msg = "ASE 'installmaster' script may be of a faulty version. ASE Version is '" + this.aseVersionNum + "' while 'installmaster' version is '" + this.installmasterVersionNum + "'. Please apply '$SYBASE/$SYBASE_ASE/scripts/installmaster' and check it's status with: sp_version.";
            if (this._hasGui) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, "asemon - connect check", 0);
            }
            _logger.error((Object)msg);
        }
    }

    public void addTable(String tabName, String desc) {
        MonTableEntry entry = new MonTableEntry();
        entry._tableName = tabName;
        entry._description = desc;
        entry._monTableColumns = new HashMap();
        this._monTables.put(entry._tableName, entry);
    }

    public void addColumn(String tabName, String colName, String desc) throws NameNotFoundException {
        MonTableColumnsEntry entry;
        MonTableEntry monTableEntry = this._monTables.get(tabName);
        if (monTableEntry == null) {
            throw new NameNotFoundException("The table '" + tabName + "' was not found in the MonTables dictionary.");
        }
        if (monTableEntry._monTableColumns == null) {
            monTableEntry._monTableColumns = new HashMap();
        }
        if ((entry = monTableEntry._monTableColumns.get(colName)) == null) {
            entry = new MonTableColumnsEntry();
            entry._tableName = tabName;
            entry._columnName = colName;
            entry._description = desc;
            monTableEntry._monTableColumns.put(entry._columnName, entry);
        } else {
            String currentDesc = entry._description;
            if (!currentDesc.trim().endsWith(".")) {
                currentDesc = currentDesc.trim() + ".";
            }
            entry._description = currentDesc + " " + desc;
        }
    }

    public void setColumn(String tabName, String colName, String desc) throws NameNotFoundException {
        MonTableEntry monTableEntry = this._monTables.get(tabName);
        if (monTableEntry == null) {
            throw new NameNotFoundException("The table '" + tabName + "' was not found in the MonTables dictionary.");
        }
        if (monTableEntry._monTableColumns == null) {
            monTableEntry._monTableColumns = new HashMap();
        }
        MonTableColumnsEntry entry = new MonTableColumnsEntry();
        entry._tableName = tabName;
        entry._columnName = colName;
        entry._description = desc;
        monTableEntry._monTableColumns.put(entry._columnName, entry);
    }

    public String getDescription(String colName) {
        if (this._monTables == null) {
            return null;
        }
        for (String monTable : this._monTables.keySet()) {
            String desc = this.getDescription(monTable, colName);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public String getDescription(String[] tabNameArr, String colName) {
        if (tabNameArr == null) {
            return this.getDescription(colName);
        }
        for (int i = 0; i < tabNameArr.length; ++i) {
            String desc = this.getDescription(tabNameArr[i], colName);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public String getDescription(String tabName, String colName) {
        if (this._monTables == null) {
            return null;
        }
        MonTableEntry mte = this._monTables.get(tabName);
        if (mte == null) {
            return null;
        }
        if (mte._monTableColumns == null) {
            return null;
        }
        MonTableColumnsEntry mtce = mte._monTableColumns.get(colName);
        if (mtce == null) {
            return null;
        }
        String indicator = "";
        if (mtce._indicators > 0) {
            indicator = ". Indicator=" + mtce._indicators + " (";
            if ((mtce._indicators & 1) == 1) {
                indicator = mtce._indicators > 1 ? indicator + "Cumulative counter, " : indicator + "Cumulative counter";
            }
            if ((mtce._indicators & 2) == 2) {
                indicator = indicator + "Shared with sp_sysmon";
            }
            indicator = indicator + ")";
        }
        return mtce._description + indicator;
    }

    public void addSpinlockDescription(String spinName, String description) {
        this._sysMonitorsInfo.put(spinName, description);
    }

    public String getSpinlockDescription(String spinName) {
        String desc = this._sysMonitorsInfo.get(spinName);
        return desc;
    }

    public String getWaitEventDescription(int waitEventId) {
        if (this._monWaitEventInfo == null) {
            return null;
        }
        String desc = null;
        try {
            if (this._monWaitEventInfo[waitEventId] != null) {
                desc = this._monWaitEventInfo[waitEventId]._description;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (desc == null) {
            desc = "-unknown-waitEventId-" + waitEventId;
        }
        return desc;
    }

    public boolean hasWaitEventDescription(int waitEventId) {
        if (this._monWaitEventInfo == null) {
            return false;
        }
        try {
            if (this._monWaitEventInfo[waitEventId] != null && this._monWaitEventInfo[waitEventId]._description != null) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public String getWaitEventClassDescription(int waitEventId) {
        if (this._monWaitEventInfo == null) {
            return null;
        }
        String desc = null;
        try {
            if (this._monWaitEventInfo[waitEventId] != null) {
                int waitClassId = this._monWaitEventInfo[waitEventId]._waitClassId;
                if (this._monWaitClassInfo[waitClassId] != null) {
                    desc = this._monWaitClassInfo[waitClassId]._description;
                }
                if (desc == null) {
                    desc = "-unknown-waitClassId-" + waitClassId + "-for-known-waitEventId-" + waitEventId;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (desc == null) {
            desc = "-unknown-waitEventId-" + waitEventId;
        }
        return desc;
    }

    public String getWaitClassDescription(int waitClassId) {
        if (this._monWaitClassInfo == null) {
            return null;
        }
        String desc = null;
        try {
            if (this._monWaitClassInfo[waitClassId] != null) {
                desc = this._monWaitClassInfo[waitClassId]._description;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (desc == null) {
            desc = "-unknown-waitClassId-" + waitClassId;
        }
        return desc;
    }

    public boolean hasWaitClassDescription(int waitClassId) {
        if (this._monWaitClassInfo == null) {
            return false;
        }
        try {
            if (this._monWaitClassInfo[waitClassId] != null && this._monWaitClassInfo[waitClassId]._description != null) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public int getWaitClassId(int waitEventId) {
        if (this._monWaitEventInfo == null) {
            return -1;
        }
        int waitClassId = -1;
        try {
            if (this._monWaitEventInfo[waitEventId] != null) {
                waitClassId = this._monWaitEventInfo[waitEventId]._waitClassId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return waitClassId;
    }

    public void loadOfflineMonTablesDictionary(Connection conn) {
    }

    private class MonWaitEventInfoEntry {
        int _waitEventId = 0;
        int _waitClassId = 0;
        String _description = null;

        private MonWaitEventInfoEntry() {
        }

        public String toString() {
            return "MonWaitEventInfoEntry _waitEventId=" + this._waitEventId + ", _waitClassId=" + this._waitClassId + ", _description='" + this._description + "'.";
        }
    }

    private class MonWaitClassInfoEntry {
        int _waitClassId = 0;
        String _description = null;

        private MonWaitClassInfoEntry() {
        }

        public String toString() {
            return "MonWaitClassInfoEntry _waitClassId=" + this._waitClassId + ", _description='" + this._description + "'.";
        }
    }

    public class MonTableColumnsEntry {
        public int _tableID = 0;
        public int _columnID = 0;
        public int _typeID = 0;
        public int _precision = 0;
        public int _scale = 0;
        public int _length = 0;
        public int _indicators = 0;
        public String _tableName = null;
        public String _columnName = null;
        public String _typeName = null;
        public String _description = null;
    }

    public class MonTableEntry {
        public int _tableID = 0;
        public int _columns = 0;
        public int _parameters = 0;
        public int _indicators = 0;
        public int _size = 0;
        public String _tableName = null;
        public String _description = null;
        public HashMap<String, MonTableColumnsEntry> _monTableColumns = null;
    }
}

