/*
 * Decompiled with CFR 0.152.
 */
package asemon.check;

import asemon.Asemon;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.Version;
import asemon.check.CheckDialog;
import asemon.cm.CountersModel;
import asemon.utils.AseConnectionFactory;
import asemon.utils.Configuration;
import asemon.utils.PlatformUtils;
import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.util.Logger;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class CheckForUpdates {
    private static org.apache.log4j.Logger _logger = org.apache.log4j.Logger.getLogger(CheckForUpdates.class);
    protected static final String ASEMON_HOME_URL = "http://www.asemon.se";
    private static final String ASEMON_CHECK_UPDATE_URL = "http://www.asemon.se/check_for_update.php";
    private static final String ASEMON_CONNECT_INFO_URL = "http://www.asemon.se/connect_info.php";
    private static final String ASEMON_UDC_INFO_URL = "http://www.asemon.se/udc_info.php";
    private static final String ASEMON_COUNTER_USAGE_INFO_URL = "http://www.asemon.se/counter_usage_info.php";
    private static final String DEFAULT_DOWNLOAD_URL = "http://www.asemon.se/download.html";
    private static final String DEFAULT_WHATSNEW_URL = "http://www.asemon.se/history.html";
    private static boolean _sendConnectInfo = true;
    private static boolean _sendUdcInfo = true;
    private static boolean _sendCounterUsageInfo = true;
    private URL _url;
    private QueryString _query = new QueryString();
    private String _action = "";
    protected String _asemonVersion = "";
    protected String _downloadUrl = "";
    protected String _whatsNewUrl = "";
    protected boolean _hasUpgrade;
    protected boolean _checkSucceed;
    protected String _feedbackUrl = "";
    protected String _feedbackDateStr = "";
    protected java.util.Date _feedbackDate = null;
    private static boolean _initialized = false;
    private static int _checkId = -1;

    private void add(String name, String value) {
        if (value == null) {
            value = "";
        }
        value = value.replace('\\', '/');
        this._query.add(name, value);
    }

    private InputStream post() throws IOException {
        return this.post(3000);
    }

    private InputStream post(int timeoutInMs) throws IOException {
        URLConnection conn = this._url.openConnection();
        conn.setConnectTimeout(timeoutInMs);
        conn.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "ASCII");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("post() query: " + this._query.toString()));
        }
        out.write(this._query.toString());
        out.write("\r\n");
        out.flush();
        out.close();
        return conn.getInputStream();
    }

    public static void init() {
        if (_initialized) {
            return;
        }
        System.setProperty("java.net.useSystemProxies", "true");
        OnlyHttpProxySelector ps = new OnlyHttpProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault(ps);
        _initialized = true;
    }

    public static void noBlockCheck(final Component owner, final boolean showNoUpgrade, final boolean showFailure) {
        Runnable checkLater = new Runnable(){

            @Override
            public void run() {
                CheckForUpdates chk = new CheckForUpdates();
                chk.check();
                if (!chk.checkSucceed()) {
                    if (owner != null && showFailure) {
                        CheckDialog.showDialog(owner, chk);
                    }
                    _logger.info((Object)"Check for latest version failed.");
                    return;
                }
                if (chk.hasUpgrade()) {
                    if (owner != null) {
                        CheckDialog.showDialog(owner, chk);
                    }
                    _logger.info((Object)("New Upgrade is Available. New version is '" + chk.getNewAsemonVersionStr() + "' " + "and can be downloaded here '" + chk.getDownloadUrl() + "'."));
                } else {
                    if (showNoUpgrade && owner != null) {
                        CheckDialog.showDialog(owner, chk);
                    }
                    if (chk.hasFeedback() && owner != null) {
                        CheckDialog.showDialog(owner, chk);
                    }
                    _logger.info((Object)("You have got the latest release of '" + Version.getAppName() + "'."));
                }
            }
        };
        Thread checkThread = new Thread(checkLater);
        checkThread.setName("checkForUpdates");
        checkThread.setDaemon(true);
        checkThread.start();
    }

    public void check() {
        this._hasUpgrade = false;
        this._checkSucceed = false;
        try {
            this._url = new URL(ASEMON_CHECK_UPDATE_URL);
        }
        catch (MalformedURLException ex) {
            _logger.debug((Object)"When we checking for later version, we had problems", (Throwable)ex);
            return;
        }
        Date timeNow = new Date(System.currentTimeMillis());
        String clientTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timeNow);
        if (_logger.isDebugEnabled()) {
            this.add("debug", "true");
        }
        this.add("clientCheckTime", clientTime);
        this.add("clientSourceDate", Version.getSourceDate());
        this.add("clientSourceVersion", Version.getSourceRev());
        this.add("clientAsemonVersion", Version.getVersionStr());
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.add("clientHostName", addr.getHostName());
            this.add("clientHostAddress", addr.getHostAddress());
            this.add("clientCanonicalHostName", addr.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.add("user_name", System.getProperty("user.name"));
        this.add("user_dir", System.getProperty("user.dir"));
        this.add("propfile", Configuration.getInstance("SYSTEM_CONF").getFilename());
        this.add("userpropfile", Configuration.getInstance("USER_TEMP").getFilename());
        this.add("gui", Asemon.hasGUI() + "");
        this.add("java_version", System.getProperty("java.version"));
        this.add("java_vm_version", System.getProperty("java.vm.version"));
        this.add("java_vm_vendor", System.getProperty("java.vm.vendor"));
        this.add("java_home", System.getProperty("java.home"));
        this.add("java_class_path", System.getProperty("java.class.path"));
        this.add("memory", Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB");
        this.add("os_name", System.getProperty("os.name"));
        this.add("os_version", System.getProperty("os.version"));
        this.add("os_arch", System.getProperty("os.arch"));
        this.add("sun_desktop", System.getProperty("sun.desktop"));
        this.add("user_country", System.getProperty("user.country"));
        this.add("user_language", System.getProperty("user.language"));
        this.add("-end-", "-end-");
        try {
            String line;
            InputStream in = this.post();
            this._action = "";
            this._asemonVersion = "";
            this._downloadUrl = DEFAULT_DOWNLOAD_URL;
            this._whatsNewUrl = DEFAULT_WHATSNEW_URL;
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(in));
            String responseLines = "";
            boolean foundActionLine = false;
            while ((line = lr.readLine()) != null) {
                int i;
                _logger.debug((Object)("response line " + lr.getLineNumber() + ": " + line));
                responseLines = responseLines + line;
                if (line.startsWith("ACTION:")) {
                    foundActionLine = true;
                    String[] sa = line.split(":");
                    for (int i2 = 0; i2 < sa.length; ++i2) {
                        _logger.debug((Object)("   - STRING[" + i2 + "]='" + sa[i2] + "'."));
                        if (i2 == 1) {
                            this._action = sa[1];
                        }
                        if (i2 == 2) {
                            this._asemonVersion = sa[2];
                        }
                        if (i2 == 3) {
                            this._downloadUrl = sa[3];
                        }
                        if (i2 != 4) continue;
                        this._whatsNewUrl = sa[4];
                    }
                }
                if (line.startsWith("OPTIONS:")) {
                    String options = line.substring("OPTIONS:".length());
                    _logger.debug((Object)("Receiving Options from server '" + options + "'."));
                    String[] sa = options.split(",");
                    for (i = 0; i < sa.length; ++i) {
                        String[] keyVal = sa[i].split("=");
                        if (keyVal.length == 2) {
                            String key = keyVal[0].trim();
                            String val = keyVal[1].trim();
                            boolean bVal = val.equalsIgnoreCase("true");
                            if (key.equalsIgnoreCase("sendConnectInfo")) {
                                _sendConnectInfo = bVal;
                                _logger.debug((Object)("Setting option '" + key + "' to '" + bVal + "'."));
                                continue;
                            }
                            if (key.equalsIgnoreCase("sendUdcInfo")) {
                                _sendUdcInfo = bVal;
                                _logger.debug((Object)("Setting option '" + key + "' to '" + bVal + "'."));
                                continue;
                            }
                            if (key.equalsIgnoreCase("sendCounterUsageInfo")) {
                                _sendUdcInfo = bVal;
                                _logger.debug((Object)("Setting option '" + key + "' to '" + bVal + "'."));
                                continue;
                            }
                            _logger.debug((Object)("Unknown option '" + key + "' from server with value '" + val + "'."));
                            continue;
                        }
                        _logger.debug((Object)("Option '" + sa[i] + "' from server has strange key/valye."));
                    }
                }
                if (line.startsWith("FEEDBACK:")) {
                    String feedback = line.substring("FEEDBACK:".length()).trim();
                    _logger.debug((Object)("Receiving feedback from server '" + feedback + "'."));
                    if (!"".equals(feedback)) {
                        String[] sa = feedback.split(":");
                        for (i = 0; i < sa.length; ++i) {
                            if (i == 0) {
                                this._feedbackDateStr = sa[0];
                            }
                            if (i != 1) continue;
                            this._feedbackUrl = sa[1];
                        }
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            this._feedbackDate = sdf.parse(this._feedbackDateStr);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                }
                if (line.startsWith("ERROR:")) {
                    _logger.warn((Object)("When checking for new version, found an 'ERROR:' response row, which looked like '" + line + "'."));
                }
                if (!line.startsWith("CHECK_ID:")) continue;
                String actionResponse = line.substring("CHECK_ID:".length()).trim();
                try {
                    _checkId = Integer.parseInt(actionResponse);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                _logger.debug((Object)("Received check_id='" + _checkId + "' from update site."));
            }
            in.close();
            if (this._downloadUrl != null && !this._downloadUrl.trim().equals("") && !this._downloadUrl.startsWith("http://")) {
                this._downloadUrl = "http://" + this._downloadUrl;
            }
            if (this._whatsNewUrl != null && !this._whatsNewUrl.trim().equals("") && !this._whatsNewUrl.startsWith("http://")) {
                this._whatsNewUrl = "http://" + this._whatsNewUrl;
            }
            if (this._feedbackUrl != null && !this._feedbackUrl.trim().equals("") && !this._feedbackUrl.startsWith("http://")) {
                this._feedbackUrl = "http://" + this._feedbackUrl;
            }
            if (this._action.equals("UPGRADE")) {
                this._hasUpgrade = true;
                _logger.debug((Object)"-UPGRADE-");
                _logger.debug((Object)("-to:" + this._asemonVersion));
                _logger.debug((Object)("-at:" + this._downloadUrl));
                _logger.debug((Object)("-at:" + this._whatsNewUrl));
            } else {
                this._hasUpgrade = false;
                _logger.debug((Object)"-NO-UPGRADE-");
            }
            if (!foundActionLine) {
                _logger.warn((Object)("When checking for new version, no 'ACTION:' response was found. The responce rows was '" + responseLines + "'."));
            }
            this._checkSucceed = true;
        }
        catch (IOException ex) {
            _logger.debug((Object)"When we checking for later version, we had problems", (Throwable)ex);
        }
    }

    public boolean checkSucceed() {
        return this._checkSucceed;
    }

    public boolean hasUpgrade() {
        return this._hasUpgrade;
    }

    public String getNewAsemonVersionStr() {
        return this._asemonVersion;
    }

    public String getDownloadUrl() {
        if (this._downloadUrl == null || this._downloadUrl.trim().equals("")) {
            return DEFAULT_DOWNLOAD_URL;
        }
        return this._downloadUrl;
    }

    public String getWhatsNewUrl() {
        if (this._whatsNewUrl == null || this._whatsNewUrl.trim().equals("")) {
            return DEFAULT_WHATSNEW_URL;
        }
        return this._whatsNewUrl;
    }

    public String getFeedbackUrl() {
        if (this._feedbackUrl == null || this._feedbackUrl.trim().equals("")) {
            return null;
        }
        return this._feedbackUrl;
    }

    public boolean hasFeedback() {
        return this.getFeedbackUrl() != null;
    }

    public long getFeedbackTime() {
        if (this._feedbackDate == null) {
            return 0L;
        }
        return this._feedbackDate.getTime();
    }

    public URL getURL() {
        return this._url;
    }

    public static void sendConnectInfoNoBlock() {
        if (!_sendConnectInfo) {
            _logger.debug((Object)"Send 'Connect info' has been disabled.");
            return;
        }
        Runnable doLater = new Runnable(){

            @Override
            public void run() {
                CheckForUpdates connInfo = new CheckForUpdates();
                connInfo.sendConnectInfo();
                CheckForUpdates udcInfo = new CheckForUpdates();
                udcInfo.sendUdcInfo();
            }
        };
        Thread checkThread = new Thread(doLater);
        checkThread.setName("sendConnectInfo");
        checkThread.setDaemon(true);
        checkThread.start();
    }

    public void sendConnectInfo() {
        if (!_sendConnectInfo) {
            _logger.debug((Object)"Send 'Connect info' has been disabled.");
            return;
        }
        if (_checkId < 0) {
            _logger.debug((Object)"No checkId was disovered when trying to send connection info, skipping this.");
            return;
        }
        MonTablesDictionary mtd = MonTablesDictionary.getInstance();
        if (mtd == null) {
            _logger.debug((Object)"MonTablesDictionary was null when trying to send connection info, skipping this.");
            return;
        }
        try {
            this._url = new URL(ASEMON_CONNECT_INFO_URL);
        }
        catch (MalformedURLException ex) {
            _logger.debug((Object)"When sending connection info, we had problems", (Throwable)ex);
            return;
        }
        Date timeNow = new Date(System.currentTimeMillis());
        String checkId = _checkId + "";
        String clientTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timeNow);
        String srvVersion = mtd.aseVersionNum + "";
        String isClusterEnabled = mtd.isClusterEnabled + "";
        String srvName = AseConnectionFactory.getServer();
        String srvIpPort = AseConnectionFactory.getHostPortStr();
        String srvUser = AseConnectionFactory.getUser();
        String srvVersionStr = mtd.aseVersionStr;
        if (srvName != null) {
            srvName.trim();
        }
        if (srvIpPort != null) {
            srvIpPort.trim();
        }
        if (srvUser != null) {
            srvUser.trim();
        }
        if (srvVersionStr != null) {
            srvVersionStr.trim();
        }
        if (_logger.isDebugEnabled()) {
            this.add("debug", "true");
        }
        this.add("checkId", checkId);
        this.add("clientTime", clientTime);
        this.add("userName", System.getProperty("user.name"));
        this.add("srvVersion", srvVersion);
        this.add("isClusterEnabled", isClusterEnabled);
        this.add("srvName", srvName);
        this.add("srvIpPort", srvIpPort);
        this.add("srvUser", srvUser);
        this.add("srvVersionStr", srvVersionStr);
        try {
            String line;
            InputStream in = this.post();
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(in));
            String responseLines = "";
            while ((line = lr.readLine()) != null) {
                _logger.debug((Object)("response line " + lr.getLineNumber() + ": " + line));
                responseLines = responseLines + line;
                if (line.startsWith("ERROR:")) {
                    _logger.warn((Object)("When doing connection info 'ERROR:' response row, which looked like '" + line + "'."));
                }
                if (!line.startsWith("DONE:")) continue;
            }
            in.close();
        }
        catch (IOException ex) {
            _logger.debug((Object)"when trying to send connection info, we had problems", (Throwable)ex);
        }
    }

    public static void sendUdcInfoNoBlock() {
        if (!_sendUdcInfo) {
            _logger.debug((Object)"Send 'UDC info' has been disabled.");
            return;
        }
        Runnable doLater = new Runnable(){

            @Override
            public void run() {
                CheckForUpdates chk = new CheckForUpdates();
                chk.sendUdcInfo();
            }
        };
        Thread checkThread = new Thread(doLater);
        checkThread.setName("sendUdcInfo");
        checkThread.setDaemon(true);
        checkThread.start();
    }

    public void sendUdcInfo() {
        if (!_sendUdcInfo) {
            _logger.debug((Object)"Send 'UDC info' has been disabled.");
            return;
        }
        if (_checkId < 0) {
            _logger.debug((Object)"No checkId was disovered when trying to send UDC info, skipping this.");
            return;
        }
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.debug((Object)"Configuration was null when trying to send UDC info, skipping this.");
            return;
        }
        try {
            this._url = new URL(ASEMON_UDC_INFO_URL);
        }
        catch (MalformedURLException ex) {
            _logger.debug((Object)"When sending UDC info, we had problems", (Throwable)ex);
            return;
        }
        Date timeNow = new Date(System.currentTimeMillis());
        String checkId = _checkId + "";
        String clientTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timeNow);
        if (_logger.isDebugEnabled()) {
            this.add("debug", "true");
        }
        this.add("checkId", checkId);
        this.add("clientTime", clientTime);
        this.add("userName", System.getProperty("user.name"));
        Iterator<Object> it = conf.keySet().iterator();
        int udcRows = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = conf.getPropertyRaw(key);
            if (!key.startsWith("udc.") && !key.startsWith("hostmon.udc.")) continue;
            this.add(key, val);
            ++udcRows;
        }
        if (udcRows == 0) {
            _logger.debug((Object)"No 'udc.*' or 'hostmon.udc.*' was was found in Configuration, skipping this.");
            return;
        }
        try {
            String line;
            InputStream in = this.post();
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(in));
            String responseLines = "";
            while ((line = lr.readLine()) != null) {
                _logger.debug((Object)("response line " + lr.getLineNumber() + ": " + line));
                responseLines = responseLines + line;
                if (line.startsWith("ERROR:")) {
                    _logger.warn((Object)("When doing UDC info 'ERROR:' response row, which looked like '" + line + "'."));
                }
                if (!line.startsWith("DONE:")) continue;
            }
            in.close();
        }
        catch (IOException ex) {
            _logger.debug((Object)"when trying to send UDC info, we had problems", (Throwable)ex);
        }
    }

    public static void sendCounterUsageInfoNoBlock() {
        if (!_sendCounterUsageInfo) {
            _logger.debug((Object)"Send 'Counter Usage Info' has been disabled.");
            return;
        }
        CheckForUpdates chk = new CheckForUpdates();
        chk.sendCounterUsageInfo();
    }

    public void sendCounterUsageInfo() {
        if (!_sendCounterUsageInfo) {
            _logger.debug((Object)"Send 'Counter Usage Info' has been disabled.");
            return;
        }
        if (_checkId < 0) {
            _logger.debug((Object)"No checkId was disovered when trying to send 'Counter Usage' info, skipping this.");
            return;
        }
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.debug((Object)"Configuration was null when trying to send 'Counter Usage' info, skipping this.");
            return;
        }
        try {
            this._url = new URL(ASEMON_COUNTER_USAGE_INFO_URL);
        }
        catch (MalformedURLException ex) {
            _logger.debug((Object)"When sending 'Counter Usage' info, we had problems", (Throwable)ex);
            return;
        }
        Date timeNow = new Date(System.currentTimeMillis());
        String checkId = _checkId + "";
        String clientTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timeNow);
        if (_logger.isDebugEnabled()) {
            this.add("debug", "true");
        }
        this.add("checkId", checkId);
        this.add("clientTime", clientTime);
        this.add("userName", System.getProperty("user.name"));
        int rows = 0;
        for (CountersModel cm : GetCounters.getCmList()) {
            int minRefresh = 5;
            if (_logger.isDebugEnabled()) {
                minRefresh = 1;
            }
            if (cm.getRefreshCounter() < minRefresh) continue;
            this.add(cm.getName(), cm.getRefreshCounter() + "," + cm.getSumRowCount());
            ++rows;
        }
        if (rows == 0) {
            _logger.debug((Object)"No 'Counter Usage' was reported, skipping this.");
            return;
        }
        try {
            String line;
            InputStream in = this.post(1500);
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(in));
            String responseLines = "";
            while ((line = lr.readLine()) != null) {
                _logger.debug((Object)("response line " + lr.getLineNumber() + ": " + line));
                responseLines = responseLines + line;
                if (line.startsWith("ERROR:")) {
                    _logger.warn((Object)("When doing 'Counter Usage' info 'ERROR:' response row, which looked like '" + line + "'."));
                }
                if (!line.startsWith("DONE:")) continue;
            }
            in.close();
        }
        catch (IOException ex) {
            _logger.debug((Object)"when trying to send 'Counter Usage' info, we had problems", (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "TRACE, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf1 = new Configuration("c:\\projects\\asemon\\asemon.save.properties");
        Configuration.setInstance("USER_TEMP", conf1);
        Configuration conf2 = new Configuration("c:\\projects\\asemon\\asemon.properties");
        Configuration.setInstance("SYSTEM_CONF", conf2);
        System.setProperty("java.net.useSystemProxies", "true");
        CheckForUpdates check = new CheckForUpdates();
        System.out.println("-- DO CHECK");
        check.check();
        if (check.checkSucceed()) {
            if (check.hasUpgrade()) {
                System.out.println("-- HAS NEW UPGRADE");
                System.out.println("-- new version '" + check.getNewAsemonVersionStr() + "'.");
                System.out.println("-- download url '" + check.getDownloadUrl() + "'.");
            } else {
                System.out.println("-- NO NEED TO UPGRADE");
            }
            System.out.println("-- FEEDBACK_URL: '" + check.getFeedbackUrl() + "'.");
        } else {
            System.out.println("-- CHECK FAILED...");
        }
        CheckForUpdates udcCheck = new CheckForUpdates();
        udcCheck.sendUdcInfo();
    }

    static {
        CheckForUpdates.init();
    }

    private class QueryString {
        private StringBuffer query = new StringBuffer();

        public QueryString() {
        }

        public QueryString(String name, String value) {
            this.encode(name, value);
        }

        public synchronized void add(String name, String value) {
            this.query.append('&');
            this.encode(name, value);
        }

        private synchronized void encode(String name, String value) {
            try {
                this.query.append(URLEncoder.encode(name, "UTF-8"));
                this.query.append('=');
                this.query.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Broken VM does not support UTF-8");
            }
        }

        public String getQuery() {
            return this.query.toString();
        }

        public String toString() {
            return this.getQuery();
        }
    }

    private static class OnlyHttpProxySelector
    extends ProxySelector {
        ProxySelector _defsel = null;
        ProxySelector _proxyVole = null;

        public OnlyHttpProxySelector(ProxySelector def) {
            if (def == null) {
                throw new IllegalArgumentException("ProxySelector can't be null.");
            }
            this._defsel = def;
            _logger.debug((Object)("Installing a new ProxySelector, but I will save and use the default '" + this._defsel.getClass().getName() + "'."));
            Logger.setBackend((Logger.LogBackEnd)new Logger.LogBackEnd(){

                public boolean isLogginEnabled(Logger.LogLevel logLevel) {
                    if (logLevel.equals((Object)Logger.LogLevel.TRACE) && _logger.isTraceEnabled()) {
                        return true;
                    }
                    if (logLevel.equals((Object)Logger.LogLevel.DEBUG) && _logger.isDebugEnabled()) {
                        return true;
                    }
                    if (logLevel.equals((Object)Logger.LogLevel.INFO) && _logger.isInfoEnabled()) {
                        return true;
                    }
                    if (logLevel.equals((Object)Logger.LogLevel.WARNING) && _logger.isEnabledFor((Priority)Level.WARN)) {
                        return true;
                    }
                    return logLevel.equals((Object)Logger.LogLevel.ERROR) && _logger.isEnabledFor((Priority)Level.ERROR);
                }

                public void log(Class<?> clazz, Logger.LogLevel logLevel, String message, Object ... params) {
                    String msg = MessageFormat.format(message, params);
                    msg = clazz.getName() + ": " + msg;
                    if (logLevel.equals((Object)Logger.LogLevel.TRACE)) {
                        _logger.trace((Object)msg);
                    } else if (logLevel.equals((Object)Logger.LogLevel.DEBUG)) {
                        _logger.debug((Object)msg);
                    } else if (logLevel.equals((Object)Logger.LogLevel.INFO)) {
                        _logger.info((Object)msg);
                    } else if (logLevel.equals((Object)Logger.LogLevel.WARNING)) {
                        _logger.warn((Object)msg);
                    } else if (logLevel.equals((Object)Logger.LogLevel.ERROR)) {
                        _logger.error((Object)msg);
                    } else {
                        _logger.info((Object)("Unhandled loglevel(" + logLevel + "): " + msg));
                    }
                }
            });
            boolean useProxyVoleDefault = false;
            ProxySearch proxySearch = null;
            if (useProxyVoleDefault) {
                proxySearch = ProxySearch.getDefaultProxySearch();
            } else {
                proxySearch = new ProxySearch();
                boolean headless = GraphicsEnvironment.isHeadless();
                if (headless) {
                    proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
                    proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                    proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
                } else {
                    proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
                    if (PlatformUtils.getCurrentPlattform() == 0) {
                        proxySearch.addStrategy(ProxySearch.Strategy.IE);
                        proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
                    } else {
                        proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
                    }
                    proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                    proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
                }
                Logger.log(ProxySearch.class, (Logger.LogLevel)Logger.LogLevel.TRACE, (String)"Using SPECIALIZED search priority: {0}", (Object[])new Object[]{proxySearch});
            }
            try {
                this._proxyVole = proxySearch.getProxySelector();
                if (this._proxyVole == null) {
                    _logger.debug((Object)"PROXY-VOLE: Could not be used as a ProxySelector, getProxySelector() returned null.");
                }
            }
            catch (Throwable e) {
                System.out.println("When initializing 'proxy-vole' caught exception '" + e + "', but I will continue anyway. ");
                _logger.info((Object)("When initializing 'proxy-vole' caught exception '" + e + "', but I will continue anyway."));
            }
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            if (this._proxyVole != null) {
                this._proxyVole.connectFailed(uri, sa, ioe);
            }
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException("URI can't be null.");
            }
            String protocol = uri.getScheme();
            _logger.debug((Object)("called select(uri): protocoll '" + protocol + "' with uri='" + uri + "')"));
            if ("socket".equalsIgnoreCase(protocol)) {
                _logger.debug((Object)("Shortcircuting proxy resolving for the protocol '" + protocol + "'. No proxy server will be used."));
                ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
                proxyList.add(Proxy.NO_PROXY);
                return proxyList;
            }
            List<Proxy> proxyList = null;
            if (this._proxyVole != null) {
                _logger.debug((Object)("PROXY-VOLE: Trying to resolv a proxy server for the protocoll '" + protocol + "', using the ProxySelector '" + this._proxyVole.getClass().getName() + "', with uri='" + uri + "'.)"));
                proxyList = this._proxyVole.select(uri);
                if (proxyList != null && proxyList.size() > 0) {
                    for (int i = 0; i < proxyList.size(); ++i) {
                        _logger.debug((Object)("PROXY-VOLE: ProxyList[" + i + "]: " + proxyList.get(i)));
                    }
                    return proxyList;
                }
            }
            _logger.debug((Object)("FALLBACK: Trying to resolv a proxy server for the protocoll '" + protocol + "', using the ProxySelector '" + this._defsel.getClass().getName() + "', with uri='" + uri + "'.)"));
            proxyList = this._defsel.select(uri);
            for (int i = 0; i < proxyList.size(); ++i) {
                _logger.debug((Object)("FALLBACK: ProxyList[" + i + "]: " + proxyList.get(i)));
            }
            return proxyList;
        }
    }
}

