/*
 * Decompiled with CFR 0.152.
 */
package asemon.cm;

import asemon.cm.CountersModel;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class CmSybMessageHandler
implements SybMessageHandler {
    private static Logger _logger = Logger.getLogger(CmSybMessageHandler.class);
    private CountersModel _cm = null;
    private String _logPrefix = "";
    private List<Integer> _discardMsgNum = new LinkedList<Integer>();
    private List<String> _discardMsgStr = new LinkedList<String>();
    private boolean _discardMsgZero = true;
    private boolean _discardMsgZeroPrintInfo = true;
    private boolean _discardMsgLoadDb = true;
    private boolean _discardMsgLoadDbPrintInfo = true;

    public CmSybMessageHandler(CountersModel cm, boolean addSomeDefaultDiscards) {
        if (cm == null) {
            throw new IllegalArgumentException("CountersModel can't be null, for constructor.");
        }
        this._cm = cm;
        String cmName = this._cm.getName();
        Configuration conf = Configuration.getCombinedConfiguration();
        this._discardMsgZero = conf.getBooleanProperty(cmName + ".discardMsgZero", this._discardMsgZero);
        this._discardMsgZeroPrintInfo = conf.getBooleanProperty(cmName + ".discardMsgZeroPrintInfo", this._discardMsgZeroPrintInfo);
        _logger.debug((Object)("CmSybMessageHandler: Config for CM '" + cmName + "': discardMsgZero=" + this._discardMsgZero + ", discardMsgZeroPrintInfo=" + this._discardMsgZeroPrintInfo));
        this._discardMsgLoadDb = conf.getBooleanProperty(cmName + ".discardMsgLoadDb", this._discardMsgLoadDb);
        this._discardMsgLoadDbPrintInfo = conf.getBooleanProperty(cmName + ".discardMsgLoadDbPrintInfo", this._discardMsgLoadDbPrintInfo);
        _logger.debug((Object)("CmSybMessageHandler: Config for CM '" + cmName + "': discardMsgLoadDb=" + this._discardMsgLoadDb + ", discardMsgLoadDbPrintInfo=" + this._discardMsgLoadDbPrintInfo));
        this.setLogPrefix(cmName);
        this.addDiscardMsgNum(10351);
        this.addDiscardMsgNum(969);
        this.addDiscardMsgStr("Cluster wide monitor command succeeded.");
    }

    public void resetDiscardMsgNum() {
        this._discardMsgNum.clear();
    }

    public List<Integer> getDiscardMsgNum() {
        return this._discardMsgNum;
    }

    public void addDiscardMsgNum(int msgNum) {
        Integer msgNumInt = new Integer(msgNum);
        if (!this._discardMsgNum.contains(msgNumInt)) {
            this._discardMsgNum.add(msgNumInt);
        }
    }

    public void resetDiscardMsgStr() {
        this._discardMsgStr.clear();
    }

    public List<String> getDiscardMsgStr() {
        return this._discardMsgStr;
    }

    public void addDiscardMsgStr(String regexp) {
        if (!this._discardMsgStr.contains(regexp)) {
            this._discardMsgStr.add(regexp);
        }
    }

    public void setLogPrefix(String msgPrefix) {
        this._logPrefix = msgPrefix;
        if (this._logPrefix == null) {
            this._logPrefix = "";
        }
        if (!this._logPrefix.endsWith(": ")) {
            this._logPrefix = this._logPrefix + ": ";
        }
    }

    public String getLogPrefix() {
        return this._logPrefix;
    }

    public SQLException messageHandler(SQLException sqle) {
        String msg;
        int code = sqle.getErrorCode();
        Integer codeInt = new Integer(code);
        String msgStr = sqle.getMessage();
        StringBuilder sb = new StringBuilder();
        StringBuilder logMsg = new StringBuilder();
        StringBuilder isqlMsg = new StringBuilder();
        if (sqle instanceof EedInfo) {
            EedInfo m = (EedInfo)sqle;
            logMsg.append("Server='").append(m.getServerName()).append("', ");
            logMsg.append("MsgNum='").append(sqle.getErrorCode()).append("', ");
            logMsg.append("Severity='").append(m.getSeverity()).append("', ");
            logMsg.append("State='").append(m.getState()).append("', ");
            logMsg.append("Status='").append(m.getStatus()).append("', ");
            logMsg.append("Proc='").append(m.getProcedureName()).append("', ");
            logMsg.append("Line='").append(m.getLineNumber()).append("', ");
            logMsg.append("Msg: ").append(sqle.getMessage());
            if (logMsg.charAt(logMsg.length() - 1) == '\n') {
                logMsg.deleteCharAt(logMsg.length() - 1);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(this.getLogPrefix() + logMsg.toString()));
            }
            if (m.getSeverity() <= 10) {
                sb.append(sqle.getMessage());
                String str = sb.toString();
                if (str == null || str != null && str.trim().equals("")) {
                    return null;
                }
            } else {
                isqlMsg.append("Msg ").append(sqle.getErrorCode()).append(", Level ").append(m.getSeverity()).append(", State ").append(m.getState()).append(":\n");
                boolean addComma = false;
                String str = m.getServerName();
                if (str != null && !str.equals("")) {
                    addComma = true;
                    isqlMsg.append("Server '").append(str).append("'");
                }
                if ((str = m.getProcedureName()) != null && !str.equals("")) {
                    if (addComma) {
                        isqlMsg.append(", ");
                    }
                    addComma = true;
                    isqlMsg.append("Procedure '").append(str).append("'");
                }
                if ((str = m.getLineNumber() + "") != null && !str.equals("")) {
                    if (addComma) {
                        isqlMsg.append(", ");
                    }
                    addComma = true;
                    isqlMsg.append("Line ").append(str).append(":");
                    addComma = false;
                    isqlMsg.append("\n");
                }
                isqlMsg.append(sqle.getMessage());
            }
            if (isqlMsg.length() > 0 && isqlMsg.charAt(isqlMsg.length() - 1) == '\n') {
                isqlMsg.deleteCharAt(isqlMsg.length() - 1);
            }
        }
        if (code == 3604) {
            // empty if block
        }
        if (code == 921 || code == 950) {
            // empty if block
        }
        if (code == 1205) {
            // empty if block
        }
        if (code == 12205) {
            // empty if block
        }
        if (code == 208 || code == 504 || code == 2501 || code == 2812 || code == 9938 || code == 10303 || code == 10337 || code == 11901 || code == 11910 || code == 18826) {
            // empty if block
        }
        if (code == 0 && this._discardMsgZero) {
            if (this._discardMsgZeroPrintInfo) {
                msg = sqle.getMessage();
                if (msg != null && msg.endsWith("\n")) {
                    msg = msg.substring(0, msg.length() - 1);
                }
                _logger.info((Object)(this.getLogPrefix() + "Discarding Msg 0, Str '" + msg + "'."));
            }
            return null;
        }
        if (this._discardMsgLoadDb && AseConnectionUtils.isInLoadDbException(sqle)) {
            if (this._discardMsgLoadDbPrintInfo) {
                msg = sqle.getMessage();
                if (msg != null && msg.endsWith("\n")) {
                    msg = msg.substring(0, msg.length() - 1);
                }
                _logger.info((Object)(this.getLogPrefix() + "Discarding Msg " + code + ", Str '" + msg + "'."));
            }
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.getLogPrefix() + "INFO Discard message number list: " + this._discardMsgNum));
        }
        if (this._discardMsgNum.contains(codeInt)) {
            _logger.debug((Object)(this.getLogPrefix() + ">>>>> Discarding message: " + logMsg.toString()));
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.getLogPrefix() + "INFO Discard message text list: " + this._discardMsgStr));
        }
        for (String regexp : this._discardMsgStr) {
            if (msgStr.indexOf(regexp) < 0) continue;
            _logger.debug((Object)(this.getLogPrefix() + ">>>>> Discarding message: " + logMsg.toString()));
            return null;
        }
        return sqle;
    }
}

