/*
 * Decompiled with CFR 0.152.
 */
package asemon.cm;

import asemon.Asemon;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.MonWaitEventIdDictionary;
import asemon.TrendGraphDataPoint;
import asemon.cm.CmSybMessageHandler;
import asemon.cm.CounterTableModel;
import asemon.cm.DependsOnCmPostponeException;
import asemon.cm.SamplingCnt;
import asemon.gui.MainFrame;
import asemon.gui.SummaryPanel;
import asemon.gui.TabularCntrPanel;
import asemon.gui.TrendGraph;
import asemon.gui.swing.GTabbedPane;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionUtils;
import asemon.utils.AseSqlScript;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.TimeUtils;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class CountersModel
extends AbstractTableModel
implements Cloneable {
    private static final long serialVersionUID = -7486772146682031469L;
    private static Logger _logger = Logger.getLogger(CountersModel.class);
    public static final int DATA_ABS = 1;
    public static final int DATA_DIFF = 2;
    public static final int DATA_RATE = 3;
    private CmSybMessageHandler _sybMessageHandler = null;
    private boolean _negativeDiffCountersToZero = true;
    private Timer _refreshTimer = new Timer(200, new RefreshTimerAction());
    private String _name;
    private boolean _systemCm;
    private String _displayName = null;
    private String _description = "";
    private String _problemDesc = "";
    private Exception _sampleException = null;
    private String _serverName = "";
    private Timestamp _sampleTimeHead = null;
    private Timestamp _counterClearTime = null;
    private Timestamp _sampleTime = null;
    private long _sampleInterval = 0L;
    private long _sqlRefreshStartTime = 0L;
    private long _sqlRefreshTime = 0L;
    private long _guiRefreshStartTime = 0L;
    private long _guiRefreshTime = 0L;
    private long _lcRefreshStartTime = 0L;
    private long _lcRefreshTime = 0L;
    private boolean _isInitialized = false;
    private boolean _runtimeInitialized = false;
    private int _serverVersion = 0;
    private boolean _isClusterEnabled = false;
    private List<String> _activeRoleList = null;
    private Map<String, Integer> _monitorConfigsMap = null;
    private String _sqlInit = null;
    private String _sqlClose = null;
    private String _sqlRequest = null;
    private String _sqlWhere = "";
    private TabularCntrPanel tabPanel = null;
    private List<String> _pkCols = null;
    private List<String> _pkColsOrigin = null;
    private int _sqlQueryTimeout = 10;
    private String[] _monTablesInQuery = null;
    private List<String> _dependsOnCm = null;
    private String[] _dependsOnRole = null;
    private String[] _dependsOnConfig = null;
    private int _dependsOnVersion = 0;
    private int _dependsOnCeVersion = 0;
    private List<StoredProcCheck> _dependsOnStoredProc = null;
    private int _postponeTime = 0;
    private long _lastLocalRefreshTime = 0L;
    private ResultSetMetaData _rsmd;
    private String[] _diffColumns = null;
    private boolean[] _isDiffCol = null;
    private String[] _pctColumns = null;
    private boolean[] _isPctCol = null;
    private String[] _diffDissColumns = null;
    private boolean[] _isDiffDissCol = null;
    private int _refreshCounter = 0;
    private int _sumRowCount = 0;
    private boolean _hasValidSampleData = false;
    private boolean _isActive = true;
    private Map<String, TrendGraph> _trendGraphs = new LinkedHashMap<String, TrendGraph>();
    private Map<String, TrendGraphDataPoint> _trendGraphsData = new HashMap<String, TrendGraphDataPoint>();
    private boolean _filterAllZeroDiffCounters = false;
    private boolean _sampleDataIsPaused = false;
    private boolean _sampleDataInBackground = false;
    private boolean _persistCounters = false;
    private boolean _persistCountersAbs = true;
    private boolean _persistCountersDiff = true;
    private boolean _persistCountersRate = true;
    private int clearCmLevel;
    private SamplingCnt _prevSample = null;
    private SamplingCnt _newSample = null;
    private SamplingCnt _diffData = null;
    private SamplingCnt _rateData = null;
    private int _dataSource = 3;
    private boolean dataInitialized = false;
    private boolean firstTimeSample = true;
    private int maxRowSeen;
    public static final int GRAPH_TYPE_BY_COL = 1;
    public static final int GRAPH_TYPE_BY_ROW = 2;
    private static String[] _graphMethodsAbs = new String[]{"absVal", "absMax", "absMin", "absAvg", "absAvgGtZero", "absSum"};
    private static String[] _graphMethodsAll = new String[]{"absVal", "absMax", "absMin", "absAvg", "absAvgGtZero", "absSum", "diffVal", "diffMax", "diffMin", "diffAvg", "diffAvgGtZero", "diffSum", "rateVal", "rateMax", "rateMin", "rateAvg", "rateAvgGtZero", "rateSum"};
    private static String[] _graphMethodsByColAbs = new String[]{"absMax", "absMin", "absAvg", "absAvgGtZero", "absSum"};
    private static String[] _graphMethodsByColAll = new String[]{"absMax", "absMin", "absAvg", "absAvgGtZero", "absSum", "diffMax", "diffMin", "diffAvg", "diffAvgGtZero", "diffSum", "rateMax", "rateMin", "rateAvg", "rateAvgGtZero", "rateSum"};
    private static String[] _graphMethodsByRow = new String[]{"absVal", "diffVal", "rateVal"};
    private int _graphType = 1;
    private String[] _graphDataColNames = new String[0];
    private String[] _graphDataMethods = new String[0];
    private HashMap<String, Object> _clientProperty = new HashMap();
    private boolean _inLoadProps = false;
    public static final String PROP_queryTimeout = "queryTimeout";
    public static final String PROP_filterAllZeroDiffCounters = "filterAllZeroDiffCounters";
    public static final String PROP_sampleDataIsPaused = "sampleDataIsPaused";
    public static final String PROP_sampleDataInBackground = "sampleDataInBackground";
    public static final String PROP_negativeDiffCountersToZero = "negativeDiffCountersToZero";
    public static final String PROP_persistCounters = "persistCounters";
    public static final String PROP_persistCounters_abs = "persistCounters.abs";
    public static final String PROP_persistCounters_diff = "persistCounters.diff";
    public static final String PROP_persistCounters_rate = "persistCounters.rate";
    public static final String PROP_postponeTime = "postponeTime";

    public CountersModel() {
    }

    public CountersModel(String name, String sql, List<String> pkList, String[] diffColumns, String[] pctColumns, String[] monTables, String[] dependsOnRole, String[] dependsOnConfig, int dependsOnVersion, int dependsOnCeVersion, boolean negativeDiffCountersToZero, boolean systemCm) {
        this(name, sql, pkList, diffColumns, pctColumns, monTables, dependsOnRole, dependsOnConfig, dependsOnVersion, dependsOnCeVersion, negativeDiffCountersToZero, systemCm, 0);
    }

    public CountersModel(String name, String sql, List<String> pkList, String[] diffColumns, String[] pctColumns, String[] monTables, String[] dependsOnRole, String[] dependsOnConfig, int dependsOnVersion, int dependsOnCeVersion, boolean negativeDiffCountersToZero, boolean systemCm, int defaultPostponeTime) {
        this._name = name;
        this._systemCm = systemCm;
        this.checkInConstructor();
        this._sqlRequest = sql;
        this._sqlWhere = "";
        this._pkCols = pkList;
        this._pkColsOrigin = pkList == null ? null : new ArrayList<String>(pkList);
        this._diffColumns = diffColumns;
        this._pctColumns = pctColumns;
        this._monTablesInQuery = monTables;
        this._dependsOnRole = dependsOnRole;
        this._dependsOnConfig = dependsOnConfig;
        this._dependsOnVersion = dependsOnVersion;
        this._dependsOnCeVersion = dependsOnCeVersion;
        this._negativeDiffCountersToZero = negativeDiffCountersToZero;
        this._postponeTime = defaultPostponeTime;
        this._sybMessageHandler = this.createSybMessageHandler();
        this._prevSample = null;
        this._newSample = null;
        this._diffData = null;
        this.maxRowSeen = 0;
        String[] emptyArray = new String[]{};
        if (this._diffColumns == null) {
            this._diffColumns = emptyArray;
        }
        if (this._diffDissColumns == null) {
            this._diffDissColumns = emptyArray;
        }
        if (this._pctColumns == null) {
            this._pctColumns = emptyArray;
        }
        if (this._monTablesInQuery == null) {
            this._monTablesInQuery = emptyArray;
        }
        if (this._dependsOnRole == null) {
            this._dependsOnRole = emptyArray;
        }
        if (this._dependsOnConfig == null) {
            this._dependsOnConfig = emptyArray;
        }
        this.loadProps();
        this.setDataInitialized(false);
    }

    protected void checkInConstructor() {
        if (!CountersModel.isValidCmName(this.getName(), this.isSystemCm())) {
            String err = CountersModel.checkForValidCmName(this.getName());
            throw new RuntimeException("Problems when creating cm '" + this.getName() + "'. " + err);
        }
    }

    public CountersModel copyForOfflineRead() {
        CountersModel cm = this.copyForStorage();
        cm.clearForRead();
        return cm;
    }

    public CountersModel copyForStorage() {
        CountersModel c = null;
        try {
            c = (CountersModel)this.clone();
        }
        catch (CloneNotSupportedException e) {
            _logger.warn((Object)("In '" + this.getName() + "', caught: " + e), (Throwable)e);
            c = new CountersModel();
        }
        c._sybMessageHandler = this._sybMessageHandler;
        c._refreshTimer = null;
        c._negativeDiffCountersToZero = this._negativeDiffCountersToZero;
        c._name = this._name;
        c._systemCm = this._systemCm;
        c._displayName = this._displayName;
        c._description = this._description;
        c._problemDesc = this._problemDesc;
        c._serverName = this._serverName;
        c._sampleTimeHead = this._sampleTimeHead;
        c._counterClearTime = this._counterClearTime;
        c._sampleTime = this._sampleTime;
        c._sampleInterval = this._sampleInterval;
        c._sqlRefreshStartTime = this._sqlRefreshStartTime;
        c._sqlRefreshTime = this._sqlRefreshTime;
        c._guiRefreshStartTime = this._guiRefreshStartTime;
        c._guiRefreshTime = this._guiRefreshTime;
        c._lcRefreshStartTime = this._lcRefreshStartTime;
        c._lcRefreshTime = this._lcRefreshTime;
        c._isInitialized = this._isInitialized;
        c._runtimeInitialized = this._runtimeInitialized;
        c._serverVersion = this._serverVersion;
        c._isClusterEnabled = this._isClusterEnabled;
        c._activeRoleList = this._activeRoleList;
        c._monitorConfigsMap = this._monitorConfigsMap;
        c._sqlInit = this._sqlInit;
        c._sqlClose = this._sqlClose;
        c._sqlRequest = this._sqlRequest;
        c._sqlWhere = this._sqlWhere;
        c.tabPanel = this.tabPanel;
        c._pkCols = this._pkCols;
        c._pkColsOrigin = this._pkColsOrigin;
        c._monTablesInQuery = this._monTablesInQuery;
        c._dependsOnCm = this._dependsOnCm;
        c._dependsOnRole = this._dependsOnRole;
        c._dependsOnConfig = this._dependsOnConfig;
        c._dependsOnVersion = this._dependsOnVersion;
        c._dependsOnCeVersion = this._dependsOnCeVersion;
        c._dependsOnStoredProc = this._dependsOnStoredProc;
        c._postponeTime = this._postponeTime;
        c._lastLocalRefreshTime = this._lastLocalRefreshTime;
        c._rsmd = this._rsmd;
        c._diffColumns = this._diffColumns;
        c._isDiffCol = this._isDiffCol;
        c._pctColumns = this._pctColumns;
        c._isPctCol = this._isPctCol;
        c._diffDissColumns = this._diffDissColumns;
        c._isDiffDissCol = this._isDiffDissCol;
        c._hasValidSampleData = this._hasValidSampleData;
        c._isActive = this._isActive;
        c._trendGraphs = new LinkedHashMap<String, TrendGraph>(this._trendGraphs);
        c._trendGraphsData = new HashMap<String, TrendGraphDataPoint>(this._trendGraphsData);
        c._filterAllZeroDiffCounters = this._filterAllZeroDiffCounters;
        c._sampleDataIsPaused = this._sampleDataIsPaused;
        c._sampleDataInBackground = this._sampleDataInBackground;
        c._persistCounters = this._persistCounters;
        c._persistCountersAbs = this._persistCountersAbs;
        c._persistCountersDiff = this._persistCountersDiff;
        c._persistCountersRate = this._persistCountersRate;
        c._prevSample = this._prevSample;
        c._newSample = this._newSample;
        c._diffData = this._diffData;
        c._rateData = this._rateData;
        c._dataSource = this._dataSource;
        c.dataInitialized = this.dataInitialized;
        c.firstTimeSample = this.firstTimeSample;
        c.maxRowSeen = this.maxRowSeen;
        c._refreshCounter = this._refreshCounter;
        c._sumRowCount = this._sumRowCount;
        return c;
    }

    public void printTableModelListener() {
        TableModelListener[] tml = this.getTableModelListeners();
        for (int i = 0; i < tml.length; ++i) {
            if (tml[i] instanceof TabularCntrPanel) {
                System.out.println("TableModelListener[" + i + "] = " + ((TabularCntrPanel)tml[i]).getPanelName());
                continue;
            }
            System.out.println("TableModelListener[" + i + "] = " + tml[i]);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        super.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (!this.isDataInitialized()) {
            return null;
        }
        CounterTableModel data = this.getCounterData();
        if (data == null) {
            return Object.class;
        }
        return data.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        CounterTableModel data = this.getCounterData();
        int c = 0;
        if (this.isDataInitialized() && data != null) {
            c = data.getColumnCount();
        }
        return c;
    }

    @Override
    public String getColumnName(int col) {
        CounterTableModel data = this.getCounterData();
        String s = null;
        if (this.isDataInitialized() && data != null) {
            s = data.getColumnName(col);
        }
        return s;
    }

    @Override
    public int getRowCount() {
        int c = 0;
        CounterTableModel data = this.getCounterData();
        if (this.isDataInitialized() && data != null) {
            c = data.getRowCount();
        }
        return c;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.isDataInitialized()) {
            return null;
        }
        CounterTableModel data = this.getCounterData();
        if (data == null) {
            return null;
        }
        return data.getValueAt(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int findColumn(String colName) {
        CounterTableModel data = this.getCounterData();
        int pos = -1;
        if (this.isDataInitialized() && data != null) {
            pos = data.findColumn(colName);
        }
        return pos;
    }

    public void setValueAt(int type, Object value, int row, int col) {
        SamplingCnt data = null;
        if (type == 1) {
            data = this._newSample == null ? (this._newSample = new SamplingCnt("offline-abs", false, null)) : this._newSample;
        } else if (type == 2) {
            data = this._diffData == null ? (this._diffData = new SamplingCnt("offline-diff", false, null)) : this._diffData;
        } else if (type == 3) {
            data = this._rateData == null ? (this._rateData = new SamplingCnt("offline-rate", false, null)) : this._rateData;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        ((AbstractTableModel)data).setValueAt(value, row, col);
    }

    public void setColumnNames(int type, List<String> cols) {
        SamplingCnt data = null;
        if (type == 1) {
            data = this._newSample == null ? (this._newSample = new SamplingCnt("offline-abs", false, null)) : this._newSample;
        } else if (type == 2) {
            data = this._diffData == null ? (this._diffData = new SamplingCnt("offline-diff", false, null)) : this._diffData;
        } else if (type == 3) {
            data = this._rateData == null ? (this._rateData = new SamplingCnt("offline-rate", false, null)) : this._rateData;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        data.setColumnNames(cols);
        this.initColumnStuff(data);
    }

    public static boolean isValidCmName(String name) {
        return CountersModel.checkForValidCmName(name, false) == null;
    }

    private static boolean isValidCmName(String name, boolean systemCm) {
        return CountersModel.checkForValidCmName(name, systemCm) == null;
    }

    public static String checkForValidCmName(String name) {
        return CountersModel.checkForValidCmName(name, false);
    }

    private static String checkForValidCmName(String name, boolean systemCm) {
        if (name == null) {
            return "Name can't be a null pointer";
        }
        String lowerName = name.toLowerCase();
        if (name.length() == 0) {
            return "Name can't zero length";
        }
        if (name.length() > 20) {
            return "Name can't be more than 20 characters";
        }
        if (!systemCm && lowerName.startsWith("cm")) {
            return "Name can't start with 'CM', only system counters can do that.";
        }
        if (!name.matches("[a-zA-Z0-9]*")) {
            return "Name can only contain normal characters (a-Z, A-Z or 0-9)";
        }
        return null;
    }

    public String getServerName() {
        return this._serverName;
    }

    public Timestamp getSampleTimeHead() {
        return this._sampleTimeHead;
    }

    public Timestamp getCounterClearTime() {
        return this._counterClearTime;
    }

    public Timestamp getSampleTime() {
        return this._sampleTime;
    }

    public long getSampleInterval() {
        return this._sampleInterval;
    }

    public void setServerName(String name) {
        this._serverName = name;
    }

    public void setSampleTimeHead(Timestamp timeHead) {
        this._sampleTimeHead = timeHead;
    }

    public void setCounterClearTime(Timestamp clearTime) {
        this._counterClearTime = clearTime;
    }

    public void setSampleTime(Timestamp time) {
        this._sampleTime = time;
    }

    public void setSampleInterval(long interval) {
        this._sampleInterval = interval;
    }

    public void setTimeInfo(Timestamp timeHead, Timestamp clearTime, Timestamp sampleTime, long intervall) {
        this.setSampleTimeHead(timeHead);
        this.setCounterClearTime(clearTime);
        this.setSampleTime(sampleTime);
        this.setSampleInterval(intervall);
    }

    public long getSqlRefreshTime() {
        return this._sqlRefreshTime;
    }

    public void setSqlRefreshTime(int t) {
        this._sqlRefreshTime = t;
    }

    public void beginSqlRefresh() {
        this._sqlRefreshStartTime = System.currentTimeMillis();
    }

    public void endSqlRefresh() {
        this._sqlRefreshTime = System.currentTimeMillis() - this._sqlRefreshStartTime;
    }

    public long getGuiRefreshTime() {
        return this._guiRefreshTime;
    }

    public void setGuiRefreshTime(int t) {
        this._guiRefreshTime = t;
    }

    public void beginGuiRefresh() {
        this._guiRefreshStartTime = System.currentTimeMillis();
    }

    public void endGuiRefresh() {
        this._guiRefreshTime = System.currentTimeMillis() - this._guiRefreshStartTime;
    }

    public long getLcRefreshTime() {
        return this._lcRefreshTime;
    }

    public void setLcRefreshTime(int t) {
        this._lcRefreshTime = t;
    }

    public void beginLcRefresh() {
        this._lcRefreshStartTime = System.currentTimeMillis();
    }

    public void endLcRefresh() {
        this._lcRefreshTime = System.currentTimeMillis() - this._lcRefreshStartTime;
    }

    public int getQueryTimeout() {
        return this._sqlQueryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this._sqlQueryTimeout = queryTimeout;
    }

    public boolean isRefreshable() {
        if (Asemon.hasGUI()) {
            GTabbedPane gtp;
            JTabbedPane tp;
            if (!this.isActive()) {
                this.setValidSampleData(false);
                return false;
            }
            boolean refresh = false;
            if (this.equalsTabPanel(MainFrame.getActiveTab())) {
                refresh = true;
            }
            if (this.getTabPanel() != null && (tp = MainFrame.getTabbedPane()) instanceof GTabbedPane && (gtp = (GTabbedPane)tp).isTabUnDocked(this.getDisplayName())) {
                refresh = true;
            }
            if (this.hasActiveGraphs()) {
                refresh = true;
            }
            if (this.isBackgroundDataPollingEnabled()) {
                refresh = true;
            }
            if (this.isPersistCountersEnabled() && PersistentCounterHandler.getInstance() != null) {
                refresh = true;
            }
            if (this.isDataPollingPaused()) {
                refresh = false;
            }
            if (this.getTimeToNextPostponedRefresh() > 0L) {
                _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
                refresh = false;
            }
            if (refresh) {
                refresh = Asemon.getCounterCollector().isMonConnected(true, true);
            }
            if (!refresh) {
                this.setValidSampleData(false);
            }
            return refresh;
        }
        if (!this.isActive()) {
            return false;
        }
        boolean refresh = false;
        if (this.isPersistCountersEnabled()) {
            refresh = true;
        }
        if (this.getTimeToNextPostponedRefresh() > 0L) {
            _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
            refresh = false;
        }
        return refresh;
    }

    public boolean isDiffCalcEnabled() {
        return this._diffColumns != null && (this._diffColumns == null || this._diffColumns.length != 0);
    }

    public void setNegativeDiffCountersToZero(boolean b, boolean saveProps) {
        if (this.isNegativeDiffCountersToZero() == b) {
            return;
        }
        this._negativeDiffCountersToZero = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionNegativeDiffCntToZero(b);
        }
    }

    public boolean isNegativeDiffCountersToZero() {
        return this._negativeDiffCountersToZero;
    }

    public void setFilterAllZero(boolean b, boolean saveProps) {
        if (this.isFilterAllZero() == b) {
            return;
        }
        this._filterAllZeroDiffCounters = b;
        if (saveProps) {
            this.saveProps();
        }
    }

    public boolean isFilterAllZero() {
        return this._filterAllZeroDiffCounters;
    }

    public void setPauseDataPolling(boolean b, boolean saveProps) {
        if (this.isDataPollingPaused() == b) {
            return;
        }
        this._sampleDataIsPaused = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionPauseDataPolling(b);
        }
    }

    public boolean isDataPollingPaused() {
        return this._sampleDataIsPaused;
    }

    public void setBackgroundDataPollingEnabled(boolean b, boolean saveProps) {
        if (this.isBackgroundDataPollingEnabled() == b) {
            return;
        }
        this._sampleDataInBackground = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionEnableBgPolling(b);
        }
    }

    public boolean isBackgroundDataPollingEnabled() {
        return this._sampleDataInBackground;
    }

    public boolean isBackgroundDataPollingEditable() {
        return !this.hasActiveGraphs();
    }

    public void setPersistCounters(boolean b, boolean saveProps) {
        if (this.isPersistCountersEnabled() == b) {
            return;
        }
        this._persistCounters = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionPersistCounters(b);
        }
    }

    public boolean isPersistCountersEnabled() {
        return this._persistCounters;
    }

    public void setPersistCountersAbs(boolean b, boolean saveProps) {
        if (this.isPersistCountersAbsEnabled() == b) {
            return;
        }
        this._persistCountersAbs = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionPersistCountersAbs(b);
        }
    }

    public boolean isPersistCountersAbsEnabled() {
        return this._persistCountersAbs;
    }

    public boolean isPersistCountersAbsEditable() {
        return true;
    }

    public void setPersistCountersDiff(boolean b, boolean saveProps) {
        if (this.isPersistCountersDiffEnabled() == b) {
            return;
        }
        this._persistCountersDiff = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionPersistCountersDiff(b);
        }
    }

    public boolean isPersistCountersDiffEnabled() {
        return this._persistCountersAbs;
    }

    public boolean isPersistCountersDiffEditable() {
        return true;
    }

    public void setPersistCountersRate(boolean b, boolean saveProps) {
        if (this.isPersistCountersRateEnabled() == b) {
            return;
        }
        this._persistCountersRate = b;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setOptionPersistCountersRate(b);
        }
    }

    public boolean isPersistCountersRateEnabled() {
        return this._persistCountersAbs;
    }

    public boolean isPersistCountersRateEditable() {
        return true;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDisplayName(String str) {
        this._displayName = str;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDiffDissColumns(String[] cols) {
        this._diffDissColumns = cols;
    }

    public void setDiffColumns(String[] cols) {
        this._diffColumns = cols;
    }

    public void setPctColumns(String[] cols) {
        this._pctColumns = cols;
    }

    public String[] getDiffDissColumns() {
        return this._diffDissColumns;
    }

    public String[] getDiffColumns() {
        return this._diffColumns;
    }

    public String[] getPctColumns() {
        return this._pctColumns;
    }

    public boolean isDiffDissColumn(int col) {
        return this._isDiffDissCol == null ? false : this._isDiffDissCol[col];
    }

    public boolean isDiffColumn(int col) {
        return this._isDiffCol == null ? false : this._isDiffCol[col];
    }

    public boolean isPctColumn(int col) {
        return this._isPctCol == null ? false : this._isPctCol[col];
    }

    public boolean discardDiffPctHighlighterOnAbsTable() {
        return this._dataSource == 1;
    }

    public List<String> getPk() {
        return this._pkCols;
    }

    public List<List<Object>> getDataCollection(int whatData) {
        SamplingCnt data = null;
        if (whatData == 1) {
            data = this._newSample;
        } else if (whatData == 2) {
            data = this._diffData;
        } else if (whatData == 3) {
            data = this._rateData;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        return data.getDataCollection();
    }

    public synchronized List<String> getColNames(int whatData) {
        SamplingCnt data = null;
        if (whatData == 1) {
            data = this._newSample;
        } else if (whatData == 2) {
            data = this._diffData;
        } else if (whatData == 3) {
            data = this._rateData;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        return data.getColNames();
    }

    public TabularCntrPanel getTabPanel() {
        return this.tabPanel;
    }

    public void setTabPanel(TabularCntrPanel tp) {
        this.tabPanel = tp;
        if (this.tabPanel != null) {
            this.tabPanel.setCm(this);
        }
    }

    public void setClientProperty(String key, Object value) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("getName().setClientProperty(key='" + key + "', value='" + value + "') valueDataType='" + (value == null ? "null" : value.getClass().getName()) + "'."));
        }
        this._clientProperty.put(key, value);
    }

    public Object getClientProperty(String key) {
        Object obj = this._clientProperty.get(key);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("getName().getClientProperty(key='" + key + "') returns='" + obj + "', type='" + (obj == null ? "null" : obj.getClass().getName()) + "'."));
        }
        return obj;
    }

    public boolean isDependantDataCollector() {
        return false;
    }

    public String getToolTipTextOnTableColumn(String colName) {
        return MonTablesDictionary.getInstance().getDescription(this.getMonTablesInQuery(), colName);
    }

    public String getToolTipTextOnTableCell(MouseEvent e, String colName, Object cellValue, int modelRow, int modelCol) {
        int waitEventId;
        if ("WaitEventID".equals(colName) && cellValue instanceof Number && (waitEventId = ((Number)cellValue).intValue()) > 0) {
            return MonWaitEventIdDictionary.getInstance().getToolTipText(waitEventId);
        }
        if (cellValue != null) {
            String sql = MainFrame.getUserDefinedToolTip(this.getName(), colName);
            if (sql != null && !Asemon.getCounterCollector().isMonConnected()) {
                return "<html>No runtime tool tip available for '" + colName + "'. <br>" + "Not connected to the monitored server.<br>" + "</html>";
            }
            if (sql != null) {
                try {
                    int c;
                    Connection conn = Asemon.getCounterCollector().getMonConnection();
                    StringBuilder sb = new StringBuilder(300);
                    sb.append("<html>\n");
                    sb.append("<table border=1>\n");
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    stmt.setObject(1, cellValue);
                    ResultSet rs = stmt.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    sb.append("<tr>");
                    for (c = 1; c <= cols; ++c) {
                        sb.append("<td nowrap>").append(rsmd.getColumnName(c)).append("</td>");
                    }
                    sb.append("</tr>\n");
                    while (rs.next()) {
                        sb.append("<tr>");
                        for (c = 1; c <= cols; ++c) {
                            sb.append("<td nowrap>").append(rs.getObject(c)).append("</td>");
                        }
                        sb.append("</tr>\n");
                    }
                    sb.append("</table>\n");
                    sb.append("</html>\n");
                    for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                        if (sqlw.getMessage().startsWith("DBCC execution completed. If DBCC")) continue;
                        sb = sb.append(sqlw.getMessage()).append("<br>");
                    }
                    rs.close();
                    stmt.close();
                    return sb.toString();
                }
                catch (SQLException ex) {
                    _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
                    return "<html>Problems when executing sql: " + sql + "<br>" + ex.toString() + "</html>";
                }
            }
        }
        return null;
    }

    public boolean hasTrendGraph() {
        return this._trendGraphs.size() != 0;
    }

    public boolean hasActiveGraphs() {
        if (this._trendGraphs.size() == 0) {
            return false;
        }
        boolean active = false;
        for (String graphName : this._trendGraphs.keySet()) {
            TrendGraph tg = this.getTrendGraph(graphName);
            if (!tg.isGraphEnabled()) continue;
            active = true;
            break;
        }
        return active;
    }

    public void updateGraph(TrendGraph tg) {
        if (tg == null) {
            return;
        }
        TrendGraphDataPoint tgdp = this.getTrendGraphData(tg.getName());
        tg.addPoint(tgdp);
    }

    public void updateGraphs() {
        if (this._trendGraphs.size() == 0) {
            return;
        }
        for (String graphName : this._trendGraphs.keySet()) {
            TrendGraph tg = this.getTrendGraph(graphName);
            this.updateGraph(tg);
        }
    }

    public void addTrendGraph(String name, TrendGraph tg, boolean addToSummary) {
        this._trendGraphs.put(name, tg);
        tg.setCm(this);
        if (addToSummary) {
            MainFrame.addGraphViewMenu(tg.getViewMenuItem());
            SummaryPanel.getInstance().addTrendGraph(tg);
        }
    }

    public TrendGraph getTrendGraph(String name) {
        return this._trendGraphs.get(name);
    }

    public Map<String, TrendGraph> getTrendGraphs() {
        return this._trendGraphs;
    }

    public static String[] getValidGraphMethods(boolean allMethods) {
        return allMethods ? _graphMethodsAll : _graphMethodsAbs;
    }

    public static String[] getValidGraphMethods(String graphType, boolean allMethods) {
        if ("byCol".equals(graphType)) {
            return allMethods ? _graphMethodsByColAll : _graphMethodsByColAbs;
        }
        if ("byRow".equals(graphType)) {
            return _graphMethodsByRow;
        }
        return new String[0];
    }

    public static String getValidGraphMethodsString(boolean allMethods) {
        String ops = "";
        String[] sa = allMethods ? _graphMethodsAll : _graphMethodsAbs;
        for (int i = 0; i < sa.length; ++i) {
            ops = ops + "'" + sa[i] + "', ";
        }
        return ops;
    }

    public static boolean isValidGraphMethod(String op, boolean allMethods) {
        String[] sa = allMethods ? _graphMethodsAll : _graphMethodsAbs;
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].equals(op)) continue;
            return true;
        }
        return false;
    }

    public void setGraphCalculations(String[] dataCols, String[] dataOpers) {
        this._graphDataColNames = dataCols;
        this._graphDataMethods = dataOpers;
    }

    public int getGraphType() {
        return this._graphType;
    }

    public void setGraphType(int type) {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Graph type can only be 'TYPE_BY_COL/byCol' or 'TYPE_BY_ROW/byRow'.");
        }
        this._graphType = type;
    }

    private void updateUserDefinedGraphData(TrendGraphDataPoint tgdp) {
        if (tgdp == null) {
            return;
        }
        if (this._graphDataColNames.length == 0) {
            return;
        }
        String graphName = tgdp.getName();
        if (this._graphType == 1) {
            Double[] dataArray = new Double[this._graphDataColNames.length];
            for (int i = 0; i < this._graphDataColNames.length; ++i) {
                String colName = this._graphDataColNames[i];
                String op = this._graphDataMethods[i];
                Double data = null;
                if (op.equals("rateMax")) {
                    data = this.getRateValueMax(colName);
                } else if (op.equals("rateMin")) {
                    data = this.getRateValueMin(colName);
                } else if (op.equals("rateAvg")) {
                    data = this.getRateValueAvg(colName);
                } else if (op.equals("rateAvgGtZero")) {
                    data = this.getRateValueAvgGtZero(colName);
                } else if (op.equals("rateSum")) {
                    data = this.getRateValueSum(colName);
                } else if (op.equals("diffMax")) {
                    data = this.getDiffValueMax(colName);
                } else if (op.equals("diffMin")) {
                    data = this.getDiffValueMin(colName);
                } else if (op.equals("diffAvg")) {
                    data = this.getDiffValueAvg(colName);
                } else if (op.equals("diffAvgGtZero")) {
                    data = this.getDiffValueAvgGtZero(colName);
                } else if (op.equals("diffSum")) {
                    data = this.getDiffValueSum(colName);
                } else if (op.equals("absMax")) {
                    data = this.getAbsValueMax(colName);
                } else if (op.equals("absMin")) {
                    data = this.getAbsValueMin(colName);
                } else if (op.equals("absAvg")) {
                    data = this.getAbsValueAvg(colName);
                } else if (op.equals("absAvgGtZero")) {
                    data = this.getAbsValueAvgGtZero(colName);
                } else if (op.equals("absSum")) {
                    data = this.getAbsValueSum(colName);
                } else {
                    _logger.warn((Object)("Graph named '" + graphName + "' has unknown operator '" + op + "' for column '" + colName + "', cm='" + this.getName() + "'."));
                }
                dataArray[i] = data;
            }
            if (_logger.isDebugEnabled()) {
                String debugStr = "Graph named '" + graphName + "', cm='" + this.getName() + "', type 'byCol' add data: ";
                for (int i = 0; i < this._graphDataColNames.length; ++i) {
                    debugStr = debugStr + this._graphDataColNames[i] + "='" + dataArray[i] + "', ";
                }
                _logger.debug((Object)debugStr);
            }
            tgdp.setDate(this.getTimestamp());
            tgdp.setData(dataArray);
        } else if (this._graphType == 2) {
            int i;
            String[] labelArray = new String[this.getRowCount()];
            Double[] dataArray = new Double[this.getRowCount()];
            String[] strArr = tgdp.getLabel();
            int labelPos = -1;
            if (strArr != null && strArr.length >= 1) {
                labelPos = this.findColumn(strArr[0]);
            }
            for (i = 0; i < this.getRowCount(); ++i) {
                Object labelObj = null;
                String colName = this._graphDataColNames[0];
                String op = this._graphDataMethods[0];
                Double data = null;
                if (labelPos >= 0) {
                    labelObj = this.getValueAt(i, labelPos);
                } else if (op.equals("rateVal")) {
                    labelObj = this.getRatePkValue(i);
                } else if (op.equals("diffVal")) {
                    labelObj = this.getDiffPkValue(i);
                } else if (op.equals("absVal")) {
                    labelObj = this.getAbsPkValue(i);
                }
                if (labelObj == null) {
                    labelObj = "row-" + i;
                }
                if (op.equals("rateVal")) {
                    data = this.getRateValueAsDouble(i, colName);
                } else if (op.equals("diffVal")) {
                    data = this.getDiffValueAsDouble(i, colName);
                } else if (op.equals("absVal")) {
                    data = this.getAbsValueAsDouble(i, colName);
                } else {
                    _logger.warn((Object)("Graph named '" + graphName + "' has unknown operator '" + op + "' for column '" + colName + "', cm='" + this.getName() + "'."));
                }
                labelArray[i] = labelObj.toString();
                dataArray[i] = data;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Graph named '" + graphName + "', cm='" + this.getName() + "', type 'byRow' add data: "));
                for (i = 0; i < dataArray.length; ++i) {
                    _logger.debug((Object)(" :::: row=" + i + ", data='" + dataArray[i] + "', label='" + labelArray[i] + "'."));
                }
            }
            tgdp.setDate(this.getTimestamp());
            tgdp.setData(dataArray);
            tgdp.setLabel(labelArray);
        } else {
            _logger.warn((Object)("Unknown graph type(" + this._graphType + ")."));
        }
    }

    public void updateGraphData(TrendGraphDataPoint tgdp) {
        this.updateUserDefinedGraphData(tgdp);
    }

    public void updateGraphData() {
        if (this._trendGraphsData.size() == 0) {
            return;
        }
        for (Map.Entry<String, TrendGraphDataPoint> entry : this._trendGraphsData.entrySet()) {
            TrendGraphDataPoint tgdp = entry.getValue();
            this.updateGraphData(tgdp);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug((Object)("cm='" + StringUtil.left(this.getName(), 25) + "', _trendGraphData=" + tgdp));
        }
    }

    public TrendGraphDataPoint getTrendGraphData(String name) {
        return this._trendGraphsData.get(name);
    }

    public Map<String, TrendGraphDataPoint> getTrendGraphData() {
        return this._trendGraphsData;
    }

    public void addTrendGraphData(String name, TrendGraphDataPoint tgdp) {
        this._trendGraphsData.put(name, tgdp);
    }

    public void addTrendGraphData(String name) {
        TrendGraphDataPoint tgdp = new TrendGraphDataPoint(name);
        this.addTrendGraphData(name, tgdp);
    }

    public String[] getTrendGraphNames() {
        String[] names = new String[this._trendGraphsData.size()];
        if (this._trendGraphsData.size() == 0) {
            return names;
        }
        int i = 0;
        Iterator<String> it = this._trendGraphsData.keySet().iterator();
        while (it.hasNext()) {
            String graphName;
            names[i] = graphName = it.next();
            ++i;
        }
        return names;
    }

    public boolean equalsTabPanel(Component comp) {
        return comp.equals(this.tabPanel);
    }

    protected CmSybMessageHandler createSybMessageHandler() {
        return new CmSybMessageHandler(this, true);
    }

    public CmSybMessageHandler getSybMessageHandler() {
        return this._sybMessageHandler;
    }

    public void setSybMessageHandler(CmSybMessageHandler msgHandler) {
        this._sybMessageHandler = msgHandler;
    }

    public void setActiveRoles(List<String> activeRoleList) {
        this._activeRoleList = activeRoleList;
    }

    public boolean isRoleActive(String role) {
        if (!this.isRuntimeInitialized()) {
            throw new RuntimeException("This can't be called before the CM has been connected to any monitored server.");
        }
        if (this._activeRoleList == null) {
            return false;
        }
        return this._activeRoleList.contains(role);
    }

    public void setMonitorConfigs(Map<String, Integer> monitorConfigs) {
        this._monitorConfigsMap = monitorConfigs;
    }

    public int getMonitorConfig(String configName) {
        if (!this.isRuntimeInitialized()) {
            throw new RuntimeException("This can't be called before the CM has been connected to any monitored server.");
        }
        if (this._monitorConfigsMap == null) {
            return -1;
        }
        Integer config = this._monitorConfigsMap.get(configName);
        if (config != null) {
            return config;
        }
        return -1;
    }

    public void setServerVersion(int serverVersion) {
        this._serverVersion = serverVersion;
    }

    public int getServerVersion() {
        if (!this.isRuntimeInitialized()) {
            throw new RuntimeException("This can't be called before the CM has been connected to any monitored server.");
        }
        return this._serverVersion;
    }

    public void setClusterEnabled(boolean isClusterEnabled) {
        this._isClusterEnabled = isClusterEnabled;
    }

    public boolean isClusterEnabled() {
        if (!this.isRuntimeInitialized()) {
            throw new RuntimeException("This can't be called before the CM has been connected to any monitored server.");
        }
        return this._isClusterEnabled;
    }

    public String getServerVersionStr() {
        if (!this.isRuntimeInitialized()) {
            throw new RuntimeException("This can't be called before the CM has been connected to any monitored server.");
        }
        return AseConnectionUtils.versionIntToStr(this.getServerVersion());
    }

    public void initSql(Connection conn) {
    }

    public void init(Connection conn) throws Exception {
        if (this.checkDependsOnVersion() && this.checkDependsOnConfig(conn) && this.checkDependsOnRole(conn) && this.checkDependsOnStoredProc(conn)) {
            this.checkDependsOnOther(conn);
            if (this.getTabPanel() != null) {
                this.getTabPanel().onCmInit();
            }
        }
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void setInitialized(boolean init) {
        this._isInitialized = init;
    }

    public boolean isRuntimeInitialized() {
        return this._runtimeInitialized;
    }

    public void setRuntimeInitialized(boolean init) {
        this._runtimeInitialized = init;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean b, String problemDescription) {
        this._isActive = b;
        this._problemDesc = problemDescription;
        if (this._problemDesc == null) {
            this._problemDesc = "";
        }
        if (this.tabPanel != null) {
            this.tabPanel.setEnabled(b);
        }
    }

    public String getProblemDesc() {
        return this._problemDesc;
    }

    public String getSql() {
        return this._sqlRequest;
    }

    public void setSql(String sql) {
        this._sqlRequest = sql;
    }

    public String getSqlWhere() {
        return this._sqlWhere;
    }

    public void setSqlWhere(String extraWhere) {
        this._sqlWhere = " " + extraWhere;
    }

    public String getSqlInit() {
        return this._sqlInit;
    }

    public void setSqlInit(String sql) {
        this._sqlInit = sql;
    }

    public String getSqlClose() {
        return this._sqlClose;
    }

    public void setSqlClose(String sql) {
        this._sqlClose = sql;
    }

    public void doSqlClose() {
        this.doSqlClose(Asemon.getCounterCollector().getMonConnection());
    }

    public void doSqlClose(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("The passed conn is null.");
        }
        String sql = this.getSqlClose();
        if (sql != null && !sql.trim().equals("")) {
            try {
                Statement stmt = conn.createStatement();
                stmt.execute(sql);
                stmt.close();
            }
            catch (SQLException e) {
                _logger.warn((Object)"Problem when executing the 'close' SQL statement.", (Throwable)e);
            }
        }
    }

    public void close() {
        if (this.isInitialized() && Asemon.getCounterCollector().isMonConnected()) {
            this.doSqlClose();
        }
    }

    public String[] getMonTablesInQuery() {
        return this._monTablesInQuery;
    }

    public String[] getDependsOnRole() {
        return this._dependsOnRole;
    }

    public void setDependsOnRole(String[] dependsOnRole) {
        this._dependsOnRole = dependsOnRole;
        if (this._dependsOnRole == null) {
            String[] emptyArray = new String[]{};
            this._dependsOnRole = emptyArray;
        }
    }

    public boolean checkDependsOnRole(Connection conn) {
        Object[] dependsOnRole = this.getDependsOnRole();
        if (dependsOnRole == null) {
            return true;
        }
        boolean rc = true;
        String didNotHaveRoles = "";
        for (int i = 0; i < dependsOnRole.length; ++i) {
            String roleName;
            if (dependsOnRole[i] == null || dependsOnRole[i] != null && dependsOnRole[i].trim().equals("") || this.isRoleActive(roleName = dependsOnRole[i].trim())) continue;
            didNotHaveRoles = didNotHaveRoles + roleName + ", ";
            rc = false;
        }
        if (!rc) {
            if (didNotHaveRoles.endsWith(", ")) {
                didNotHaveRoles = didNotHaveRoles.substring(0, didNotHaveRoles.length() - 2);
            }
            _logger.debug((Object)(this.getName() + ": should be HIDDEN."));
            _logger.warn((Object)("When trying to initialize Counters Models (" + this.getName() + ") The following role(s) were needed '" + StringUtil.toCommaStr(dependsOnRole) + "', and you do not have the following role(s) '" + didNotHaveRoles + "'."));
            this.setActive(false, "This info is only available if you have '" + StringUtil.toCommaStr(dependsOnRole) + "' role(s) enabled.\nYou are missing the following role(s) '" + didNotHaveRoles + "'.");
            TabularCntrPanel tcp = this.getTabPanel();
            if (tcp != null) {
                tcp.setToolTipText("<html>This tab will only be visible if you have '" + StringUtil.toCommaStr(dependsOnRole) + "' role(s) enabled.<br>You are missing the following role(s) '" + didNotHaveRoles + "'.</html>");
            }
            return false;
        }
        return rc;
    }

    public String[] getDependsOnConfig() {
        return this._dependsOnConfig;
    }

    public void setDependsOnConfig(String[] dependsOnConfig) {
        this._dependsOnConfig = dependsOnConfig;
        if (this._dependsOnConfig == null) {
            String[] emptyArray = new String[]{};
            this._dependsOnConfig = emptyArray;
        }
    }

    public boolean checkDependsOnConfig(Connection conn, String configNameVal) {
        if (configNameVal == null || configNameVal != null && configNameVal.equals("")) {
            throw new IllegalArgumentException("checkDependsOnConfig(): configNameVal='" + configNameVal + "' must be a value.");
        }
        String[] configNameArr = configNameVal.split("=");
        String configName = configNameVal;
        String reConfigValue = null;
        if (configNameArr.length >= 1) {
            configName = configNameArr[0];
        }
        if (configNameArr.length >= 2) {
            reConfigValue = configNameArr[1];
        }
        int configHasValue = AseConnectionUtils.getAseConfigRunValueNoEx(conn, configName);
        _logger.debug((Object)("Checking for ASE Configuration '" + configName + "', which has value '" + configHasValue + "'. Option to re-configure to value '" + reConfigValue + "' if not set."));
        boolean doReconfigure = false;
        if (!Asemon.hasGUI()) {
            Configuration conf = Configuration.getInstance("PCS");
            doReconfigure = conf.getBooleanProperty("offline.configuration.fix", false);
        }
        if (reConfigValue == null) {
            doReconfigure = false;
        }
        if (configHasValue <= 0 && doReconfigure) {
            boolean hasSaRole = AseConnectionUtils.hasRole(conn, "sa_role");
            if (!hasSaRole) {
                _logger.warn((Object)("Can not adjust the configuration '" + configName + "' to value '" + reConfigValue + "'. To do that the connected user needs to have '" + "sa_role" + "'."));
            } else {
                _logger.info((Object)("ASE Configuration '" + configName + "' for Counters Model '" + this.getName() + "', named '" + this.getDisplayName() + "', will be reconfigured from value '" + configHasValue + "' to value '" + reConfigValue + "'."));
                try {
                    AseConnectionUtils.setAseConfigValue(conn, configName, reConfigValue);
                }
                catch (SQLException e) {
                    _logger.error((Object)("Problems setting ASE configuration '" + configName + "' to '" + reConfigValue + "'. Caught: " + AseConnectionUtils.sqlExceptionToString(e)));
                }
                configHasValue = AseConnectionUtils.getAseConfigRunValueNoEx(conn, configName);
                _logger.debug((Object)("After re-config, the ASE Configuration '" + configName + "', now has value '" + configHasValue + "'."));
            }
        }
        if (configHasValue > 0) {
            _logger.debug((Object)(this.getName() + ": should be VISABLE."));
            return true;
        }
        _logger.debug((Object)(this.getName() + ": should be HIDDEN."));
        String reconfigOptionStr = " or using the nogui mode: --reconfigure switch";
        if (reConfigValue == null) {
            reconfigOptionStr = "";
        }
        _logger.warn((Object)("When trying to initialize Counters Model '" + this.getName() + "', named '" + this.getDisplayName() + "' in ASE Version " + this.getServerVersion() + ", I found that '" + configName + "' wasn't configured (which is done with: sp_configure '" + configName + "'" + reconfigOptionStr + "), so monitoring information about '" + this.getDisplayName() + "' will NOT be enabled."));
        String problemDesc = this.getProblemDesc();
        if (problemDesc == null) {
            problemDesc = "";
        }
        problemDesc = problemDesc + "sp_configure '" + configName + "' has NOT been enabled.\n";
        this.setActive(false, problemDesc);
        TabularCntrPanel tcp = this.getTabPanel();
        if (tcp != null) {
            tcp.setToolTipText("This tab will only be visible if: sp_configure '" + configName + "' has been enabled.");
        }
        return false;
    }

    public boolean checkDependsOnConfig(Connection conn) {
        String[] dependsOnConfig = this.getDependsOnConfig();
        if (dependsOnConfig == null) {
            return true;
        }
        boolean rc = true;
        for (int i = 0; i < dependsOnConfig.length; ++i) {
            boolean b;
            if (dependsOnConfig[i] == null || dependsOnConfig[i] != null && dependsOnConfig[i].trim().equals("") || (b = this.checkDependsOnConfig(conn, dependsOnConfig[i].trim()))) continue;
            rc = false;
        }
        return rc;
    }

    public String getDependsOnVersionStr() {
        return AseConnectionUtils.versionIntToStr(this.getDependsOnVersion());
    }

    public int getDependsOnVersion() {
        return this._dependsOnVersion;
    }

    public void setDependsOnVersion(int version) {
        this._dependsOnVersion = version;
    }

    public String getDependsOnCeVersionStr() {
        return AseConnectionUtils.versionIntToStr(this.getDependsOnCeVersion());
    }

    public int getDependsOnCeVersion() {
        return this._dependsOnCeVersion;
    }

    public void setDependsOnCeVersion(int version) {
        this._dependsOnCeVersion = version;
    }

    public boolean checkDependsOnVersion() {
        if (this._dependsOnVersion == 0) {
            return true;
        }
        int needsVersion = this.getDependsOnVersion();
        int aseVersion = this.getServerVersion();
        if (this.isClusterEnabled() && this.getDependsOnCeVersion() > 0) {
            return this.checkDependsOnCeVersion();
        }
        if (aseVersion >= needsVersion) {
            return true;
        }
        _logger.debug((Object)(this.getName() + ": should be HIDDEN."));
        _logger.warn((Object)("When trying to initialize Counters Models (" + this.getName() + ") in ASE Version " + this.getServerVersionStr() + ", I need atleast ASE Version " + this.getDependsOnVersionStr() + " for that."));
        this.setActive(false, "This info is only available if ASE Server Version is above " + this.getDependsOnVersionStr());
        TabularCntrPanel tcp = this.getTabPanel();
        if (tcp != null) {
            tcp.setToolTipText("This tab will only be visible if ASE Server Version is over " + this.getDependsOnVersionStr());
        }
        return false;
    }

    public boolean checkDependsOnCeVersion() {
        if (this._dependsOnCeVersion == 0) {
            return true;
        }
        int needsCeVersion = this.getDependsOnCeVersion();
        int aseVersion = this.getServerVersion();
        if (aseVersion >= needsCeVersion) {
            return true;
        }
        _logger.debug((Object)(this.getName() + ": should be HIDDEN."));
        _logger.warn((Object)("When trying to initialize Counters Models (" + this.getName() + ") in ASE Cluster Edition Version " + this.getServerVersionStr() + ", I need atleast ASE Cluster Edition Version " + this.getDependsOnCeVersionStr() + " for that."));
        this.setActive(false, "This info is only available if ASE Cluster Edition Server Version is above " + this.getDependsOnCeVersionStr());
        TabularCntrPanel tcp = this.getTabPanel();
        if (tcp != null) {
            tcp.setToolTipText("This tab will only be visible if ASE Cluster Edition Server Version is over " + this.getDependsOnCeVersionStr());
        }
        return false;
    }

    public void addDependsOnStoredProc(String dbname, String procName, Date procDateThreshold, Class<?> scriptLocation, String scriptName, String needsRoleToRecreate) {
        if (dbname == null) {
            throw new IllegalArgumentException("addDependsOnStoredProc(): 'dbname' cant be null");
        }
        if (procName == null) {
            throw new IllegalArgumentException("addDependsOnStoredProc(): 'procName' cant be null");
        }
        if (procDateThreshold == null) {
            throw new IllegalArgumentException("addDependsOnStoredProc(): 'procDateThreshold' cant be null");
        }
        if (scriptLocation == null) {
            throw new IllegalArgumentException("addDependsOnStoredProc(): 'scriptLocation' cant be null");
        }
        if (scriptName == null) {
            throw new IllegalArgumentException("addDependsOnStoredProc(): 'scriptName' cant be null");
        }
        if (this._dependsOnStoredProc == null) {
            this._dependsOnStoredProc = new LinkedList<StoredProcCheck>();
        }
        StoredProcCheck spc = new StoredProcCheck(dbname, procName, procDateThreshold, scriptLocation, scriptName, needsRoleToRecreate);
        this._dependsOnStoredProc.add(spc);
    }

    public boolean checkDependsOnStoredProc(Connection conn, String dbname, String procName, Date procDateThreshold, Class<?> scriptLocation, String scriptName, String needsRoleToRecreate) {
        Date crDate = AseConnectionUtils.getObjectCreationDate(conn, dbname, procName);
        if (crDate == null || crDate != null && crDate.getTime() < procDateThreshold.getTime()) {
            if (crDate == null) {
                _logger.info((Object)("Checking for stored procedure '" + procName + "' in '" + dbname + "', which was NOT found."));
            } else {
                _logger.info((Object)("Checking for stored procedure '" + procName + "' in '" + dbname + "', which was to old, crdate was '" + crDate + "', re-creation threshold date is '" + procDateThreshold + "'."));
            }
            boolean hasProc = false;
            boolean hasRole = true;
            if (needsRoleToRecreate != null && !needsRoleToRecreate.equals("")) {
                hasRole = AseConnectionUtils.hasRole(conn, needsRoleToRecreate);
            }
            if (!hasRole) {
                _logger.warn((Object)("Can not (re)create procedure '" + procName + "' in '" + dbname + "', for doing that the connected user needs to have '" + needsRoleToRecreate + "'."));
            } else {
                AseSqlScript script = new AseSqlScript(conn);
                try {
                    _logger.info((Object)("Creating procedure '" + procName + "' in '" + dbname + "'."));
                    script.setMsgPrefix(scriptName + ": ");
                    script.execute(scriptLocation, scriptName);
                    hasProc = true;
                }
                catch (SQLException e) {
                    _logger.error((Object)("Problem loading the script '" + scriptName + "'."), (Throwable)e);
                }
                script.close();
            }
            if (!hasProc) {
                String msg = "Missing stored proc '" + procName + "' in database '" + dbname + "' please create it.";
                this.setActive(false, msg);
                _logger.debug((Object)(this.getName() + ": should be HIDDEN."));
                _logger.warn((Object)("When trying to initialize Counters Models (" + this.getName() + ") in ASE Version " + this.getServerVersion() + ", " + msg + " (connect with a user that has '" + needsRoleToRecreate + "' or load the proc from '$ASEMON_HOME/classes' under the class '" + scriptLocation.getClass().getName() + "' you will find the script '" + scriptName + "')."));
                TabularCntrPanel tcp = this.getTabPanel();
                if (tcp != null) {
                    tcp.setToolTipText("This tab will only be visible if the stored procedure '" + procName + "' exists in '" + dbname + "'.");
                }
            }
        } else {
            _logger.info((Object)("No Need to re-create procedure '" + procName + "' in '" + dbname + "', creation date was '" + crDate + "', re-creation threshold date is '" + procDateThreshold + "'."));
        }
        return true;
    }

    public boolean checkDependsOnStoredProc(Connection conn) {
        if (this._dependsOnStoredProc == null) {
            return true;
        }
        boolean rc = true;
        for (StoredProcCheck spc : this._dependsOnStoredProc) {
            boolean b = this.checkDependsOnStoredProc(conn, spc._dbname, spc._procName, spc._procDateThreshold, spc._scriptLocation, spc._scriptName, spc._needsRoleToRecreate);
            if (b) continue;
            rc = false;
        }
        return rc;
    }

    public boolean checkDependsOnOther(Connection conn) {
        return true;
    }

    protected void setSystemCm(boolean b) {
        this._systemCm = b;
    }

    public boolean isSystemCm() {
        return this._systemCm;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
    }

    public boolean isConnected() {
        return Asemon.getCounterCollector().isMonConnected();
    }

    public boolean isOfflineConnected() {
        return MainFrame.isOfflineConnected();
    }

    public void endOfRefresh() {
        if (this.getTabPanel() != null) {
            this.getTabPanel().setWatermark();
        }
    }

    private boolean doDiffCalc() {
        if (!this.isDiffCalcEnabled()) {
            return false;
        }
        return this._pkCols != null && (this._pkCols == null || this._pkCols.size() != 0) || this._diffColumns.length != 0;
    }

    public Exception getSampleException() {
        return this._sampleException;
    }

    public void setSampleException(Exception e) {
        this._sampleException = e;
        if (e != null) {
            if (e instanceof DependsOnCmPostponeException) {
                _logger.info((Object)e.toString());
            } else {
                _logger.info((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public long getLastLocalRefreshTime() {
        return this._lastLocalRefreshTime;
    }

    public int getPostponeTime() {
        return this._postponeTime;
    }

    public void setPostponeTime(int seconds, boolean saveProps) {
        if (this.getPostponeTime() == seconds) {
            return;
        }
        this._postponeTime = seconds;
        if (saveProps) {
            this.saveProps();
        }
        if (this.getTabPanel() != null) {
            this.getTabPanel().setPostponeTime(seconds);
        }
    }

    public CountersModel getDependantCmThatHasPostponeTime() {
        List<String> cmList = this.getDependsOnCm();
        if (cmList == null) {
            return null;
        }
        for (String cmName : cmList) {
            long postpone;
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm == null || (postpone = cm.getTimeToNextPostponedRefresh()) <= 0L) continue;
            return cm;
        }
        return null;
    }

    public long getTimeToNextPostponedRefresh() {
        if (this.getPostponeTime() == 0) {
            return 0L;
        }
        if (this.isDiffCalcEnabled() && !this.hasDiffData()) {
            return 0L;
        }
        long timeNow = System.currentTimeMillis();
        long msToNextRefresh = this.getLastLocalRefreshTime() + (long)(this.getPostponeTime() * 1000) - timeNow;
        if (msToNextRefresh < 0L) {
            return 0L;
        }
        return msToNextRefresh;
    }

    private void initColumnStuff(SamplingCnt cnt) {
        int j;
        boolean found;
        String colname;
        int i;
        List<String> colNames;
        if (this._isDiffDissCol == null && (colNames = cnt.getColNames()) != null) {
            this._isDiffDissCol = new boolean[colNames.size()];
            for (i = 0; i < this._isDiffDissCol.length; ++i) {
                colname = colNames.get(i);
                found = false;
                for (j = 0; j < this._diffDissColumns.length; ++j) {
                    if (!colname.equals(this._diffDissColumns[j])) continue;
                    found = true;
                }
                _logger.trace((Object)(this._name + " col[" + i + "]=" + found + ", colname=" + colname));
                this._isDiffDissCol[i] = found;
            }
        }
        if (this._isDiffCol == null && (colNames = cnt.getColNames()) != null) {
            this._isDiffCol = new boolean[colNames.size()];
            for (i = 0; i < this._isDiffCol.length; ++i) {
                colname = colNames.get(i);
                found = false;
                for (j = 0; j < this._diffColumns.length; ++j) {
                    if (!colname.equals(this._diffColumns[j])) continue;
                    found = true;
                }
                _logger.trace((Object)(this._name + " col[" + i + "]=" + found + ", colname=" + colname));
                this._isDiffCol[i] = found;
            }
        }
        if (this._isPctCol == null && (colNames = cnt.getColNames()) != null) {
            this._isPctCol = new boolean[colNames.size()];
            for (i = 0; i < this._isPctCol.length; ++i) {
                colname = colNames.get(i);
                found = false;
                for (j = 0; j < this._pctColumns.length; ++j) {
                    if (!colname.equals(this._pctColumns[j])) continue;
                    found = true;
                }
                _logger.trace((Object)(this._name + " col[" + i + "]=" + found + ", colname=" + colname));
                this._isPctCol[i] = found;
            }
        }
    }

    public void checkDependsOnOtherCm(CountersModel cm) throws Exception {
        long timeLimit;
        if (cm == null) {
            return;
        }
        long timeDiff = System.currentTimeMillis() - cm.getLastLocalRefreshTime();
        if (timeDiff > (timeLimit = 5000L)) {
            String msg = "The cm '" + this.getName() + "' depends on '" + cm.getName() + "', which last refresh time was '" + timeDiff + "' ms ago. " + "Next refresh time for '" + cm.getName() + "' is in " + TimeUtils.msToTimeStr("%HH:%MM:%SS", cm.getTimeToNextPostponedRefresh()) + ". " + "The limit has to be less than '" + timeLimit + "' ms.";
            throw new DependsOnCmPostponeException(msg);
        }
    }

    public void checkDependsOnOtherCm() throws Exception {
        List<String> cmList = this.getDependsOnCm();
        if (cmList == null) {
            return;
        }
        for (String cmName : cmList) {
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm == null) {
                String msg = "The cm '" + this.getName() + "' depends on '" + cmName + "', which can't be found.";
                throw new Exception(msg);
            }
            this.checkDependsOnOtherCm(cm);
        }
    }

    public void addDependsOnCm(String cmName) {
        if (this._dependsOnCm == null) {
            this._dependsOnCm = new LinkedList<String>();
        }
        this._dependsOnCm.add(cmName);
    }

    public List<String> getDependsOnCm() {
        return this._dependsOnCm;
    }

    public void incRefreshCounter() {
        ++this._refreshCounter;
    }

    public int getRefreshCounter() {
        return this._refreshCounter;
    }

    public int getSumRowCount() {
        return this._sumRowCount;
    }

    public void incSumRowCount(int inc) {
        this._sumRowCount += inc;
    }

    public final synchronized void refresh() throws Exception {
        this.refresh(Asemon.getCounterCollector().getMonConnection());
    }

    public final synchronized void refresh(Connection conn) throws Exception {
        try {
            this.checkDependsOnOtherCm();
        }
        catch (DependsOnCmPostponeException e) {
            this.setValidSampleData(false);
            return;
        }
        if (this.getTimeToNextPostponedRefresh() > 0L) {
            _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
            this.setValidSampleData(false);
            return;
        }
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler((SybMessageHandler)this.getSybMessageHandler());
        }
        int rowsFetched = 0;
        try {
            this.setSampleException(null);
            rowsFetched = this.refreshGetData(conn);
            this.setValidSampleData(rowsFetched > 0);
        }
        catch (Exception e) {
            this.setValidSampleData(false);
            this.setSampleException(e);
            throw e;
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        this.incRefreshCounter();
        this.incSumRowCount(rowsFetched);
        this.setInitialized(true);
        this._lastLocalRefreshTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int refreshGetData(Connection conn) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Entering refreshCM() method for " + this._name));
        }
        if (conn == null) {
            return -1;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Refreshing Counters for '" + this.getName() + "'."));
        }
        this._refreshTimer.start();
        if (this.firstTimeSample && this._sqlInit != null && !this._sqlInit.trim().equals("")) {
            try {
                Statement stmt = conn.createStatement();
                stmt.execute(this._sqlInit);
                stmt.close();
            }
            catch (SQLException e) {
                _logger.warn((Object)"Problem when executing the 'init' SQL statement.", (Throwable)e);
            }
        }
        if (this._sqlRequest == null) {
            this.initSql(conn);
        }
        SamplingCnt tmpDiffData = null;
        SamplingCnt tmpRateData = null;
        SamplingCnt tmpNewSample = new SamplingCnt(this._name, this._negativeDiffCountersToZero, this._diffColumns);
        try {
            this.setSampleException(null);
            this.beginSqlRefresh();
            tmpNewSample.getCnt(this, conn, this.getSql() + this.getSqlWhere(), this._pkCols);
        }
        catch (SQLException e) {
            if (this.tabPanel != null) {
                String msg = e.getMessage();
                this.setSampleException(e);
                this.tabPanel.setWatermarkText(msg);
            }
            this._newSample = null;
            this._diffData = null;
            this._rateData = null;
            int msg = -1;
            return msg;
        }
        finally {
            this._refreshTimer.stop();
            this.endSqlRefresh();
        }
        this.initColumnStuff(tmpNewSample);
        if (this.firstTimeSample) {
            // empty if block
        }
        ArrayList<Integer> deletedRows = new ArrayList<Integer>();
        if (!this.doDiffCalc()) {
            this.setSampleTime(tmpNewSample.samplingTime);
            this.setSampleInterval(0L);
            if (this._prevSample != null) {
                tmpNewSample.interval = tmpNewSample.samplingTime.getTime() - this._prevSample.samplingTime.getTime();
                this.setSampleInterval(tmpNewSample.interval);
            }
            tmpDiffData = tmpNewSample;
            tmpRateData = tmpNewSample;
            this.beginLcRefresh();
            this.localCalculation(this._prevSample, tmpNewSample, null);
            this.endLcRefresh();
            this.setDataInitialized(true);
        } else {
            if (this._prevSample != null) {
                tmpDiffData = SamplingCnt.computeDiffCnt(this._prevSample, tmpNewSample, deletedRows, this._pkCols, this._isDiffCol);
            }
            if (tmpDiffData == null) {
                this.setSampleTime(tmpNewSample.samplingTime);
                this.setSampleInterval(0L);
            } else {
                this.setSampleTime(tmpDiffData.samplingTime);
                this.setSampleInterval(tmpDiffData.interval);
                this.beginLcRefresh();
                this.localCalculation(this._prevSample, tmpNewSample, tmpDiffData);
                tmpRateData = SamplingCnt.computeRatePerSec(tmpDiffData, this._isDiffCol, this._isPctCol);
                this.endLcRefresh();
                this.setDataInitialized(true);
            }
        }
        if (!Asemon.hasGUI()) {
            this._prevSample = tmpNewSample;
            this._newSample = tmpNewSample;
            this._diffData = tmpDiffData;
            this._rateData = tmpRateData;
            if (this.firstTimeSample) {
                this.fireTableStructureChanged();
                this.firstTimeSample = false;
            }
            this.updateGraphData();
        } else {
            final SamplingCnt fTmpNewSample = tmpNewSample;
            final SamplingCnt fTmpDiffData = tmpDiffData;
            final SamplingCnt fTmpRateData = tmpRateData;
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    CountersModel.this._prevSample = fTmpNewSample;
                    CountersModel.this._newSample = fTmpNewSample;
                    CountersModel.this._diffData = fTmpDiffData;
                    CountersModel.this._rateData = fTmpRateData;
                    CountersModel.this.beginGuiRefresh();
                    MainFrame.setStatus(5, "GUI refresh of '" + CountersModel.this._displayName + "'");
                    if (CountersModel.this.getTabPanel() != null && !CountersModel.this.getTabPanel().isTableInitialized()) {
                        _logger.debug((Object)(CountersModel.this.getName() + ":------doFireTableStructureChanged------"));
                        CountersModel.this.fireTableStructureChanged();
                    } else if (CountersModel.this.firstTimeSample && CountersModel.this.isDataInitialized()) {
                        CountersModel.this.firstTimeSample = false;
                        _logger.debug((Object)(CountersModel.this.getName() + ":------doFireTableStructureChanged------"));
                        CountersModel.this.fireTableStructureChanged();
                    } else {
                        _logger.debug((Object)(CountersModel.this.getName() + ":-fireTableData-CHANGED-"));
                        CountersModel.this.fireTableDataChanged();
                    }
                    CountersModel.this.updateGraphData();
                    MainFrame.setStatus(5, "");
                    CountersModel.this.endGuiRefresh();
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(doWork);
            } else {
                doWork.run();
            }
        }
        return tmpNewSample != null ? tmpNewSample.getRowCount() : -1;
    }

    public void clearForRead() {
        if (this._prevSample != null) {
            this._prevSample.removeAllRows();
        }
        if (this._newSample != null) {
            this._newSample.removeAllRows();
        }
        if (this._diffData != null) {
            this._diffData.removeAllRows();
        }
        if (this._rateData != null) {
            this._rateData.removeAllRows();
        }
    }

    public void clear() {
        this.clear(100);
    }

    public synchronized void clear(int clearLevel) {
        this.clearCmLevel = clearLevel;
        this._prevSample = null;
        this._newSample = null;
        this._diffData = null;
        this._rateData = null;
        this.setValidSampleData(false);
        this.setDataInitialized(false);
        this.setTimeInfo(null, null, null, 0L);
        this.maxRowSeen = 0;
        if (this.clearCmLevel > 50) {
            this._dataSource = 3;
        }
        if (this.tabPanel != null) {
            this.tabPanel.reset();
        }
        this.fireTableStructureChanged();
    }

    public int getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(int dataSource) {
        if (dataSource != 1 && dataSource != 2 && dataSource != 3) {
            throw new RuntimeException("Unknown dataView was specified. you specified dataView=" + dataSource + ". known values: DATA_ABS=" + 1 + ", DATA_DIFF=" + 2 + ", DATA_RATE=" + 3 + ".");
        }
        this._dataSource = dataSource;
        if (this.getTabPanel() != null) {
            this.getTabPanel().sortDatatable();
        }
    }

    protected CounterTableModel getCounterDataAbs() {
        return this._newSample;
    }

    protected CounterTableModel getCounterDataDiff() {
        return this._diffData;
    }

    protected CounterTableModel getCounterDataRate() {
        return this._rateData;
    }

    private CounterTableModel getCounterData() {
        return this.getCounterData(this._dataSource);
    }

    protected CounterTableModel getCounterData(int whatData) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        return data;
    }

    protected String getWhatDataTranslationStr(int whatData) {
        if (whatData == 1) {
            return "DATA_ABS";
        }
        if (whatData == 2) {
            return "DATA_DIFF";
        }
        if (whatData == 3) {
            return "DATA_RATE";
        }
        return "UNKNOWN DATA TYPE OF '" + whatData + "'.";
    }

    public boolean hasAbsData() {
        return this.getCounterDataAbs() != null;
    }

    public boolean hasDiffData() {
        return this.getCounterDataDiff() != null;
    }

    public boolean hasRateData() {
        return this.getCounterDataRate() != null;
    }

    public boolean hasValidSampleData() {
        return this._hasValidSampleData;
    }

    public void setValidSampleData(boolean valid) {
        this._hasValidSampleData = valid;
    }

    public Timestamp getTimestamp() {
        if (this._diffData == null) {
            return null;
        }
        return this._diffData.samplingTime;
    }

    public int getLastSampleInterval() {
        if (this._diffData != null) {
            return (int)this._diffData.interval;
        }
        return 0;
    }

    public synchronized int size() {
        return this._diffData == null ? 0 : this._diffData.getRowCount();
    }

    private synchronized Double getValueAsDouble(int whatData, int rowId, String colname) {
        Object o = this.getValue(whatData, rowId, colname);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return new Double(Double.parseDouble(o.toString()));
    }

    private synchronized Object getValue(int whatData, int rowId, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getValue: Cant find the column '" + colname + "'."));
            return null;
        }
        if (data.getRowCount() <= rowId) {
            return null;
        }
        return data.getValueAt(rowId, idCol);
    }

    private synchronized Double getValue(int whatData, String pkStr, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            _logger.debug((Object)(this.getName() + "getValue(whatData=" + this.getWhatDataTranslationStr(whatData) + ", pkStr='" + pkStr + "', colname='" + colname + "'): data==null; return null"));
            return null;
        }
        int rowId = data.getRowNumberForPkValue(pkStr);
        if (rowId < 0) {
            _logger.debug((Object)(this.getName() + "getValue(whatData=" + this.getWhatDataTranslationStr(whatData) + ", pkStr='" + pkStr + "', colname='" + colname + "'): rowId=" + rowId + ": rowId < 0; return null"));
            return null;
        }
        Object o = this.getValue(whatData, rowId, colname);
        if (o == null) {
            _logger.debug((Object)(this.getName() + "getValue(whatData=" + this.getWhatDataTranslationStr(whatData) + ", pkStr='" + pkStr + "', colname='" + colname + "'): rowId=" + rowId + ": o==null; return null"));
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return new Double(o.toString());
    }

    private int[] getRowIdsWhere(int whatData, String colname, String colvalue) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getRowIdsWhere: Cant find the column '" + colname + "'."));
            return null;
        }
        if (data.getRowCount() == 0) {
            return null;
        }
        ArrayList<Integer> rowsList = new ArrayList<Integer>();
        for (int i = 0; i < data.getRowCount(); ++i) {
            Object o = data.getValueAt(i, idCol);
            if (o == null || !o.equals(colvalue)) continue;
            rowsList.add(i);
        }
        if (rowsList.isEmpty()) {
            return null;
        }
        int[] ia = new int[rowsList.size()];
        for (int i = 0; i < rowsList.size(); ++i) {
            ia[i] = (Integer)rowsList.get(i);
        }
        return ia;
    }

    private synchronized Double getMaxValue(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getMaxValue: Cant find the column '" + colname + "'."));
            return null;
        }
        if (data.getRowCount() == 0) {
            return null;
        }
        double maxResult = 0.0;
        double result = 0.0;
        int count = data.getRowCount();
        if (rowIds != null) {
            count = rowIds.length;
        }
        for (int i = 0; i < count; ++i) {
            Object o;
            int rowId = i;
            if (rowIds != null) {
                rowId = rowIds[i];
            }
            if ((o = data.getValueAt(rowId, idCol)) == null) continue;
            if (o instanceof Number) {
                _logger.debug((Object)("Colname='" + colname + "', Number: " + ((Number)o).doubleValue()));
                result = ((Number)o).doubleValue();
            } else {
                _logger.debug((Object)("Colname='" + colname + "', toString(): " + o.toString()));
                result = Double.parseDouble(o.toString());
            }
            if (!(result > maxResult)) continue;
            maxResult = result;
        }
        return new Double(maxResult);
    }

    private synchronized Double getMinValue(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getMinValue: Cant find the column '" + colname + "'."));
            return null;
        }
        if (data.getRowCount() == 0) {
            return null;
        }
        double minResult = 0.0;
        double result = 0.0;
        int count = data.getRowCount();
        if (rowIds != null) {
            count = rowIds.length;
        }
        for (int i = 0; i < count; ++i) {
            Object o;
            int rowId = i;
            if (rowIds != null) {
                rowId = rowIds[i];
            }
            if ((o = data.getValueAt(rowId, idCol)) == null) continue;
            if (o instanceof Number) {
                _logger.debug((Object)("Colname='" + colname + "', Number: " + ((Number)o).doubleValue()));
                result = ((Number)o).doubleValue();
            } else {
                _logger.debug((Object)("Colname='" + colname + "', toString(): " + o.toString()));
                result = Double.parseDouble(o.toString());
            }
            if (!(result < minResult)) continue;
            minResult = result;
        }
        return new Double(minResult);
    }

    private synchronized Double getSumValue(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getSumValuePCT: Cant find the column '" + colname + "'."));
            return null;
        }
        if (data.getRowCount() == 0) {
            return null;
        }
        double result = 0.0;
        int count = data.getRowCount();
        if (rowIds != null) {
            count = rowIds.length;
        }
        for (int i = 0; i < count; ++i) {
            Object o;
            int rowId = i;
            if (rowIds != null) {
                rowId = rowIds[i];
            }
            if ((o = data.getValueAt(rowId, idCol)) == null) continue;
            if (o instanceof Long) {
                _logger.debug((Object)("Colname='" + colname + "', Long: " + (Long)o));
                result += (double)((Long)o).longValue();
                continue;
            }
            if (o instanceof Double) {
                _logger.debug((Object)("Colname='" + colname + "', Double: " + (Double)o));
                result += ((Double)o).doubleValue();
                continue;
            }
            _logger.debug((Object)("Colname='" + colname + "', toString(): " + o.toString()));
            result += Double.parseDouble(o.toString());
        }
        return new Double(result);
    }

    private synchronized int getCountGtZero(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return 0;
        }
        int idCol = data.findColumn(colname);
        if (idCol == -1) {
            _logger.info((Object)("getSumValuePCT: Cant find the column '" + colname + "'."));
            return 0;
        }
        if (data.getRowCount() == 0) {
            return 0;
        }
        int counter = 0;
        int count = data.getRowCount();
        if (rowIds != null) {
            count = rowIds.length;
        }
        for (int i = 0; i < count; ++i) {
            Object o;
            int rowId = i;
            if (rowIds != null) {
                rowId = rowIds[i];
            }
            if ((o = data.getValueAt(rowId, idCol)) == null) continue;
            if (o instanceof Number) {
                if (!(((Number)o).doubleValue() > 0.0)) continue;
                ++counter;
                continue;
            }
            _logger.warn((Object)("NOT A INSTANCE OF NUMBER: Colname='" + colname + "', toString(): " + o.toString()));
        }
        return counter;
    }

    private synchronized Double getAvgValue(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        Double sum = this.getSumValue(whatData, rowIds, colname);
        if (sum == null) {
            return null;
        }
        int count = data.getRowCount();
        if (rowIds != null) {
            count = rowIds.length;
        }
        if (count == 0) {
            return new Double(0.0);
        }
        return new Double(sum / (double)count);
    }

    private synchronized Double getAvgValueGtZero(int whatData, int[] rowIds, String colname) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        Double sum = this.getSumValue(whatData, rowIds, colname);
        if (sum == null) {
            return null;
        }
        int count = this.getCountGtZero(whatData, rowIds, colname);
        if (count == 0) {
            return new Double(0.0);
        }
        return new Double(sum / (double)count);
    }

    private synchronized String getPkValue(int whatData, int rowId) {
        CounterTableModel data = null;
        if (whatData == 1) {
            data = this.getCounterDataAbs();
        } else if (whatData == 2) {
            data = this.getCounterDataDiff();
        } else if (whatData == 3) {
            data = this.getCounterDataRate();
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        return data.getPkValue(rowId);
    }

    public String getAbsString(int rowId, String colname) {
        Object o = this.getValue(1, rowId, colname);
        return o == null ? "" : o.toString();
    }

    public Object getAbsValue(int rowId, String colname) {
        return this.getValue(1, rowId, colname);
    }

    public Double getAbsValue(String pkStr, String colname) {
        return this.getValue(1, pkStr, colname);
    }

    public Double getAbsValueAsDouble(int rowId, String colname) {
        return this.getValueAsDouble(1, rowId, colname);
    }

    public Double getAbsValueMax(String colname) {
        return this.getMaxValue(1, null, colname);
    }

    public Double getAbsValueMin(String colname) {
        return this.getMinValue(1, null, colname);
    }

    public Double getAbsValueAvg(String colname) {
        return this.getAvgValue(1, null, colname);
    }

    public Double getAbsValueAvgGtZero(String colname) {
        return this.getAvgValueGtZero(1, null, colname);
    }

    public Double getAbsValueSum(String colname) {
        return this.getSumValue(1, null, colname);
    }

    public String getAbsPkValue(int rowId) {
        return this.getPkValue(1, rowId);
    }

    public int[] getAbsRowIdsWhere(String colname, String colval) {
        return this.getRowIdsWhere(1, colname, colval);
    }

    public Double getAbsValueMax(int[] rowIds, String colname) {
        return this.getMaxValue(1, rowIds, colname);
    }

    public Double getAbsValueMin(int[] rowIds, String colname) {
        return this.getMinValue(1, rowIds, colname);
    }

    public Double getAbsValueAvg(int[] rowIds, String colname) {
        return this.getAvgValue(1, rowIds, colname);
    }

    public Double getAbsValueAvgGtZero(int[] rowIds, String colname) {
        return this.getAvgValueGtZero(1, rowIds, colname);
    }

    public Double getAbsValueSum(int[] rowIds, String colname) {
        return this.getSumValue(1, rowIds, colname);
    }

    public String getDiffString(int rowId, String colname) {
        Object o = this.getValue(2, rowId, colname);
        return o == null ? "" : o.toString();
    }

    public Object getDiffValue(int rowId, String colname) {
        return this.getValue(2, rowId, colname);
    }

    public Double getDiffValue(String pkStr, String colname) {
        return this.getValue(2, pkStr, colname);
    }

    public Double getDiffValueAsDouble(int rowId, String colname) {
        return this.getValueAsDouble(2, rowId, colname);
    }

    public Double getDiffValueMax(String colname) {
        return this.getMaxValue(2, null, colname);
    }

    public Double getDiffValueMin(String colname) {
        return this.getMinValue(2, null, colname);
    }

    public Double getDiffValueAvg(String colname) {
        return this.getAvgValue(2, null, colname);
    }

    public Double getDiffValueAvgGtZero(String colname) {
        return this.getAvgValueGtZero(2, null, colname);
    }

    public Double getDiffValueSum(String colname) {
        return this.getSumValue(2, null, colname);
    }

    public String getDiffPkValue(int rowId) {
        return this.getPkValue(2, rowId);
    }

    public int[] getDiffRowIdsWhere(String colname, String colval) {
        return this.getRowIdsWhere(2, colname, colval);
    }

    public Double getDiffValueMax(int[] rowIds, String colname) {
        return this.getMaxValue(2, rowIds, colname);
    }

    public Double getDiffValueMin(int[] rowIds, String colname) {
        return this.getMinValue(2, rowIds, colname);
    }

    public Double getDiffValueAvg(int[] rowIds, String colname) {
        return this.getAvgValue(2, rowIds, colname);
    }

    public Double getDiffValueAvgGtZero(int[] rowIds, String colname) {
        return this.getAvgValueGtZero(2, rowIds, colname);
    }

    public Double getDiffValueSum(int[] rowIds, String colname) {
        return this.getSumValue(2, rowIds, colname);
    }

    public String getRateString(int rowId, String colname) {
        Object o = this.getValue(3, rowId, colname);
        return o == null ? "" : o.toString();
    }

    public Object getRateValue(int rowId, String colname) {
        return this.getValue(3, rowId, colname);
    }

    public Double getRateValue(String pkStr, String colname) {
        return this.getValue(3, pkStr, colname);
    }

    public Double getRateValueAsDouble(int rowId, String colname) {
        return this.getValueAsDouble(3, rowId, colname);
    }

    public Double getRateValueMax(String colname) {
        return this.getMaxValue(3, null, colname);
    }

    public Double getRateValueMin(String colname) {
        return this.getMinValue(3, null, colname);
    }

    public Double getRateValueAvg(String colname) {
        return this.getAvgValue(3, null, colname);
    }

    public Double getRateValueAvgGtZero(String colname) {
        return this.getAvgValueGtZero(3, null, colname);
    }

    public Double getRateValueSum(String colname) {
        return this.getSumValue(3, null, colname);
    }

    public String getRatePkValue(int rowId) {
        return this.getPkValue(3, rowId);
    }

    public int[] getRateRowIdsWhere(String colname, String colval) {
        return this.getRowIdsWhere(3, colname, colval);
    }

    public Double getRateValueMax(int[] rowIds, String colname) {
        return this.getMaxValue(3, rowIds, colname);
    }

    public Double getRateValueMin(int[] rowIds, String colname) {
        return this.getMinValue(3, rowIds, colname);
    }

    public Double getRateValueAvg(int[] rowIds, String colname) {
        return this.getAvgValue(3, rowIds, colname);
    }

    public Double getRateValueAvgGtZero(int[] rowIds, String colname) {
        return this.getAvgValueGtZero(3, rowIds, colname);
    }

    public Double getRateValueSum(int[] rowIds, String colname) {
        return this.getSumValue(3, rowIds, colname);
    }

    public void setDataInitialized(boolean b) {
        this.dataInitialized = b;
    }

    public boolean isDataInitialized() {
        return this.dataInitialized;
    }

    public boolean hasResultSetMetaData() {
        return this._rsmd != null;
    }

    public void setResultSetMetaData(ResultSetMetaData rsmd) {
        this._rsmd = rsmd;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this._rsmd;
    }

    protected void saveProps() {
        Configuration tempProps = Configuration.getInstance("USER_TEMP");
        String base = this.getName() + ".";
        if (this._inLoadProps) {
            return;
        }
        if (tempProps != null) {
            tempProps.setProperty(base + PROP_filterAllZeroDiffCounters, this.isFilterAllZero());
            tempProps.setProperty(base + PROP_sampleDataIsPaused, this.isDataPollingPaused());
            tempProps.setProperty(base + PROP_sampleDataInBackground, this.isBackgroundDataPollingEnabled());
            tempProps.setProperty(base + PROP_negativeDiffCountersToZero, this.isNegativeDiffCountersToZero());
            tempProps.setProperty(base + PROP_persistCounters, this.isPersistCountersEnabled());
            tempProps.setProperty(base + PROP_persistCounters_abs, this.isPersistCountersAbsEnabled());
            tempProps.setProperty(base + PROP_persistCounters_diff, this.isPersistCountersDiffEnabled());
            tempProps.setProperty(base + PROP_persistCounters_rate, this.isPersistCountersRateEnabled());
            tempProps.setProperty(base + PROP_postponeTime, this.getPostponeTime());
            tempProps.save();
        }
    }

    protected void loadProps() {
        Configuration tempProps = Configuration.getCombinedConfiguration();
        Configuration confProps = Configuration.getCombinedConfiguration();
        String base = this.getName() + ".";
        if (confProps != null) {
            this.setQueryTimeout(confProps.getIntProperty(PROP_queryTimeout, this.getQueryTimeout()));
            this.setQueryTimeout(confProps.getIntProperty(base + PROP_queryTimeout, this.getQueryTimeout()));
        }
        if (tempProps != null) {
            this._inLoadProps = true;
            this.setQueryTimeout(tempProps.getIntProperty(base + PROP_queryTimeout, this.getQueryTimeout()));
            this.setFilterAllZero(tempProps.getBooleanProperty(base + PROP_filterAllZeroDiffCounters, this.isFilterAllZero()), false);
            this.setPauseDataPolling(tempProps.getBooleanProperty(base + PROP_sampleDataIsPaused, this.isDataPollingPaused()), false);
            this.setBackgroundDataPollingEnabled(tempProps.getBooleanProperty(base + PROP_sampleDataInBackground, this.isBackgroundDataPollingEnabled()), false);
            this.setNegativeDiffCountersToZero(tempProps.getBooleanProperty(base + PROP_negativeDiffCountersToZero, this.isNegativeDiffCountersToZero()), false);
            this.setPersistCounters(tempProps.getBooleanProperty(base + PROP_persistCounters, this.isPersistCountersEnabled()), false);
            this.setPersistCountersAbs(tempProps.getBooleanProperty(base + PROP_persistCounters_abs, this.isPersistCountersAbsEnabled()), false);
            this.setPersistCountersDiff(tempProps.getBooleanProperty(base + PROP_persistCounters_diff, this.isPersistCountersDiffEnabled()), false);
            this.setPersistCountersRate(tempProps.getBooleanProperty(base + PROP_persistCounters_rate, this.isPersistCountersRateEnabled()), false);
            this.setPostponeTime(tempProps.getIntProperty(base + PROP_postponeTime, this.getPostponeTime()), false);
            this._inLoadProps = false;
        }
    }

    private class StoredProcCheck {
        String _dbname;
        String _procName;
        Date _procDateThreshold;
        Class<?> _scriptLocation;
        String _scriptName;
        String _needsRoleToRecreate;

        StoredProcCheck(String dbname, String procName, Date procDateThreshold, Class<?> scriptLocation, String scriptName, String needsRoleToRecreate) {
            this._dbname = dbname;
            this._procName = procName;
            this._procDateThreshold = procDateThreshold;
            this._scriptLocation = scriptLocation;
            this._scriptName = scriptName;
            this._needsRoleToRecreate = needsRoleToRecreate;
        }
    }

    private class RefreshTimerAction
    implements ActionListener {
        private RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            if (CountersModel.this.tabPanel != null) {
                CountersModel.this.tabPanel.setWatermarkText("Refreshing data...");
            }
        }
    }
}

