/*
 * Decompiled with CFR 0.152.
 */
package asemon.cm;

import asemon.Asemon;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.TabularCntrPanel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CountersModelAppend
extends CountersModel {
    private static Logger _logger = Logger.getLogger(CountersModelAppend.class);
    private static final long serialVersionUID = 1L;
    private List<List<Object>> _data = null;
    private List<String> _cols = null;
    private Timestamp _thisSamplingTime = null;
    private Timestamp _prevSamplingTime = null;
    private long _interval = 0L;
    private boolean _newRows = false;
    private boolean _initialized = false;
    private int _nbRows = 0;
    private int _nbCols = 0;

    public CountersModelAppend(String name, String sql, String[] monTables, String[] dependsOnRole, String[] dependsOnConfig, int dependsOnVersion, int dependsOnCeVersion, boolean systemCm) {
        super(name, sql, null, null, null, monTables, dependsOnRole, dependsOnConfig, dependsOnVersion, dependsOnCeVersion, true, systemCm);
        this.setDataSource(1);
    }

    @Override
    public boolean isDataInitialized() {
        return this._initialized;
    }

    public boolean saveSampleToFile() {
        return false;
    }

    @Override
    public List<List<Object>> getDataCollection(int whatData) {
        List<List<Object>> data = null;
        if (whatData == 1) {
            data = this._data;
        } else if (whatData == 2) {
            data = this._data;
        } else if (whatData == 3) {
            data = this._data;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        return data;
    }

    @Override
    public synchronized List<String> getColNames(int whatData) {
        List<String> data = null;
        if (whatData == 1) {
            data = this._cols;
        } else if (whatData == 2) {
            data = this._cols;
        } else if (whatData == 3) {
            data = this._cols;
        } else {
            throw new RuntimeException("Only ABS, DIFF, or RATE data is available.");
        }
        if (data == null) {
            return null;
        }
        return data;
    }

    @Override
    public int getColumnCount() {
        int c = 0;
        if (this.isDataInitialized() && this._cols != null) {
            c = this._cols.size();
        }
        return c;
    }

    @Override
    public String getColumnName(int col) {
        if (this.isDataInitialized() && this._cols != null) {
            return this._cols.get(col);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        int c = 0;
        if (this.isDataInitialized() && this._data != null) {
            c = this._data.size();
        }
        return c;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.isDataInitialized()) {
            return null;
        }
        List<Object> rowList = this._data.get(row);
        if (rowList == null) {
            return null;
        }
        return rowList.get(col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int findColumn(String colName) {
        if (this.isDataInitialized() && this._cols != null) {
            for (int i = 0; i < this._cols.size(); ++i) {
                if (!colName.equals(this.getColumnName(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean discardDiffPctHighlighterOnAbsTable() {
        return true;
    }

    @Override
    public boolean isDiffCalcEnabled() {
        return false;
    }

    @Override
    public boolean isDiffColumn(int index) {
        return false;
    }

    @Override
    public boolean isPctColumn(int index) {
        return false;
    }

    @Override
    public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
    }

    @Override
    public boolean hasAbsData() {
        return this._data != null;
    }

    @Override
    public boolean isPersistCountersAbsEnabled() {
        return true;
    }

    @Override
    public boolean isPersistCountersAbsEditable() {
        return false;
    }

    @Override
    public boolean isPersistCountersDiffEnabled() {
        return false;
    }

    @Override
    public boolean isPersistCountersDiffEditable() {
        return false;
    }

    @Override
    public boolean isPersistCountersRateEnabled() {
        return false;
    }

    @Override
    public boolean isPersistCountersRateEditable() {
        return false;
    }

    private void checkWarnings(Statement st) throws Exception {
        boolean hasWarning = false;
        try {
            for (SQLWarning w = st.getWarnings(); w != null; w = w.getNextWarning()) {
                hasWarning = true;
                _logger.warn((Object)("SamplingCnt. Warning : " + w));
            }
        }
        catch (Exception ex) {
            _logger.warn((Object)("SamplingCnt.getWarnings : " + ex));
            ex.printStackTrace();
        }
        if (hasWarning) {
            throw new Exception("SQL Warning");
        }
    }

    private int getCnt(Connection cnx, String sql) throws Exception {
        if (sql == null) {
            sql = this.getSql() + this.getSqlWhere();
        }
        Statement stmt = cnx.createStatement();
        ResultSet rs = stmt.executeQuery("select getdate() " + sql);
        this.checkWarnings(stmt);
        rs.next();
        if (this._thisSamplingTime != null) {
            this._prevSamplingTime = this._thisSamplingTime;
        }
        this._thisSamplingTime = rs.getTimestamp(1);
        if (this._prevSamplingTime != null && this._thisSamplingTime != null) {
            this._interval = this._thisSamplingTime.getTime() - this._prevSamplingTime.getTime();
        }
        rs.next();
        stmt.getMoreResults();
        this.checkWarnings(stmt);
        rs = stmt.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        if (this._cols == null) {
            this._cols = new ArrayList<String>();
            this._nbCols = rsmd.getColumnCount();
            for (int i = 1; i <= this._nbCols; ++i) {
                this._cols.add(rsmd.getColumnName(i));
            }
        }
        if (this._data == null) {
            this._nbRows = 0;
            this._data = new ArrayList<List<Object>>();
        }
        ArrayList<Object> row = null;
        _logger.debug((Object)"---");
        while (rs.next()) {
            this._newRows = true;
            row = new ArrayList<Object>();
            this._data.add(row);
            for (int i = 1; i <= this._nbCols; ++i) {
                Object val = rs.getObject(i);
                if (_logger.isDebugEnabled() && this._data.size() == 1) {
                    _logger.debug((Object)("READ_RESULTSET(row 0): col=" + i + ", colName=" + (this._cols.get(i - 1) + "                                   ").substring(0, 25) + ", ObjectType=" + (val == null ? "NULL-VALUE" : val.getClass().getName())));
                }
                row.add(val);
            }
            ++this._nbRows;
        }
        _logger.debug((Object)("Number of rows in '" + this.getName() + "': " + this._nbRows));
        if (row == null) {
            return -1;
        }
        return row.size();
    }

    @Override
    protected int refreshGetData(Connection conn) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Entering refresh() method for " + this.getName()));
        }
        if (conn == null) {
            return -1;
        }
        int rowsFetched = this.getCnt(conn, null);
        TabularCntrPanel tabPanel = this.getTabPanel();
        if (tabPanel != null) {
            tabPanel.setTimeInfo(null, this._thisSamplingTime, this._interval);
        }
        if (Asemon.hasGUI()) {
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    CountersModelAppend.this.beginGuiRefresh();
                    if (!CountersModelAppend.this._initialized) {
                        _logger.debug((Object)(CountersModelAppend.this.getName() + ":------doFireTableStructureChanged------"));
                        CountersModelAppend.this.fireTableStructureChanged();
                        CountersModelAppend.this._initialized = true;
                    }
                    if (CountersModelAppend.this.getTabPanel() != null && !CountersModelAppend.this.getTabPanel().isTableInitialized()) {
                        _logger.debug((Object)(CountersModelAppend.this.getName() + ":------doFireTableStructureChanged------"));
                        CountersModelAppend.this.fireTableStructureChanged();
                        CountersModelAppend.this.getTabPanel().adjustTableColumnWidth();
                    } else {
                        _logger.debug((Object)(CountersModelAppend.this.getName() + ":-fireTableDataChanged-"));
                        CountersModelAppend.this.fireTableDataChanged();
                    }
                    CountersModelAppend.this.endGuiRefresh();
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(doWork);
            } else {
                doWork.run();
            }
        }
        return rowsFetched;
    }

    @Override
    public void clearForRead() {
        this._nbRows = 0;
        this._data = new ArrayList<List<Object>>();
    }

    @Override
    public void clear() {
        this.clear(100);
    }

    @Override
    public synchronized void clear(int clearLevel) {
        this._initialized = false;
        this._thisSamplingTime = null;
        this._prevSamplingTime = null;
        this._interval = 0L;
        TabularCntrPanel tabPanel = this.getTabPanel();
        if (tabPanel != null) {
            tabPanel.reset();
        }
        this.fireTableStructureChanged();
    }

    @Override
    public synchronized Timestamp getTimestamp() {
        return this._thisSamplingTime;
    }
}

