/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.AseConfigText;
import asemon.gui.AseConfigPanel;
import asemon.gui.AseConfigTextPanel;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class AseConfigViewDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JLabel _freeMb = new JLabel();
    private AseConfigPanel _aseConfigPanel = new AseConfigPanel();
    private AseConfigTextPanel _aseConfigCachePanel = new AseConfigTextPanel(AseConfigText.ConfigType.AseCacheConfig);
    private AseConfigTextPanel _aseConfigHelpDbPanel = new AseConfigTextPanel(AseConfigText.ConfigType.AseHelpDb);
    private AseConfigTextPanel _aseConfigHelpDevicePanel = new AseConfigTextPanel(AseConfigText.ConfigType.AseHelpDevice);
    private AseConfigTextPanel _aseConfigHelpServerPanel = new AseConfigTextPanel(AseConfigText.ConfigType.AseHelpServer);
    private AseConfigTextPanel _aseConfigTraceflagsPanel = new AseConfigTextPanel(AseConfigText.ConfigType.AseTraceflags);

    private AseConfigViewDialog(Frame owner) {
        super(owner, "ASE Configuration", true);
        this.init(owner);
    }

    private AseConfigViewDialog(Dialog owner) {
        super(owner, "ASE Configuration", true);
        this.init(owner);
    }

    public static void showDialog(Frame owner) {
        AseConfigViewDialog dialog = new AseConfigViewDialog(owner);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Dialog owner) {
        AseConfigViewDialog dialog = new AseConfigViewDialog(owner);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Component owner) {
        AseConfigViewDialog dialog = null;
        dialog = owner instanceof Frame ? new AseConfigViewDialog((Frame)owner) : (owner instanceof Dialog ? new AseConfigViewDialog((Dialog)owner) : new AseConfigViewDialog((Dialog)null));
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void init(Window owner) {
        this.initComponents();
        this.setLocationRelativeTo(owner);
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0, wrap 1", "", ""));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add("ASE Config", this._aseConfigPanel);
        tabPane.add("Cache Config", this._aseConfigCachePanel);
        tabPane.add("sp_helpdb", this._aseConfigHelpDbPanel);
        tabPane.add("sp_helpdevice", this._aseConfigHelpDevicePanel);
        tabPane.add("sp_helpserver", this._aseConfigHelpServerPanel);
        tabPane.add("traceflags", this._aseConfigTraceflagsPanel);
        panel.add((Component)tabPane, "grow, height 100%, width 100%");
        panel.add((Component)this.createOkCancelPanel(), "grow, push, bottom");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AseConfigViewDialog.this.saveProps();
            }
        });
        this.loadProps();
        this.setContentPane(panel);
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.add((Component)this._freeMb, "left");
        panel.add((Component)this._ok, "push, tag ok");
        panel.add((Component)this._cancel, "tag cancel");
        this._freeMb.setToolTipText("How much memory is available for reconfiguration, same value as you can get from sp_configure 'memory'.");
        this._freeMb.setText(((AseConfigText.Cache)AseConfigText.getInstance(AseConfigText.ConfigType.AseCacheConfig)).getFreeMemoryStr());
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._cancel.equals(source)) {
            this.setVisible(false);
        }
        if (this._ok.equals(source)) {
            this.doApply();
            this.saveProps();
            this.setVisible(false);
        }
    }

    private void doApply() {
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        String base = "aseConfigViewDialog.";
        if (tmpConf != null) {
            tmpConf.setProperty(base + "window.width", this.getSize().width);
            tmpConf.setProperty(base + "window.height", this.getSize().height);
            tmpConf.setProperty(base + "window.pos.x", this.getLocationOnScreen().x);
            tmpConf.setProperty(base + "window.pos.y", this.getLocationOnScreen().y);
            tmpConf.save();
        }
    }

    private void loadProps() {
        int width = 950;
        int height = 700;
        int x = -1;
        int y = -1;
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        String base = "aseConfigViewDialog.";
        this.setSize(width, height);
        if (tmpConf == null) {
            return;
        }
        width = tmpConf.getIntProperty(base + "window.width", width);
        height = tmpConf.getIntProperty(base + "window.height", height);
        x = tmpConf.getIntProperty(base + "window.pos.x", -1);
        y = tmpConf.getIntProperty(base + "window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            SwingUtils.centerWindow(this);
        }
    }
}

