/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Version;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class AseMonitoringConfigDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7587303888489834272L;
    private static Logger _logger = Logger.getLogger(AseMonitoringConfigDialog.class);
    private static final String msgDialogTitle = "ASE monitor configuration";
    private static final String[] PDC_OPTIONS_STR = new String[]{"From ASE", "None", "Minimal", "Small", "Medium", "Large"};
    private static final int PDC_FROM_ASE = 0;
    private static final int PDC_NONE = 1;
    private static final int PDC_MINIMAL = 2;
    private static final int PDC_SMALL = 3;
    private static final int PDC_MEDIUM = 4;
    private static final int PDC_LARGE = 5;
    private static final String[] ON_EXIT_STR = new String[]{"none", "disable", "prompt"};
    private static final int ON_EXIT_NONE = 0;
    private static final int ON_EXIT_DISABLE = 1;
    private static final int ON_EXIT_PROMPT = 2;
    private static final String default_configurabelMemoryText = " MB available for reconfiguration.";
    private Connection _conn = null;
    private boolean _configErrors = false;
    private int _aseVersionNum = 0;
    private ToolTipStore _tts = new ToolTipStore();
    private JPanel _monitoringPanel = null;
    private JCheckBox _enableMonitoring_chk = new JCheckBox("Enable monitoring");
    private JCheckBox _perObjectStatisticsActive_chk = new JCheckBox("Per object statistics active");
    private JCheckBox _statementStatisticsActive_chk = new JCheckBox("Statement statistics active");
    private JCheckBox _statementCacheMonitoring_chk = new JCheckBox("Statement Cache Monitoring");
    private JCheckBox _objectLockwaitTiming_chk = new JCheckBox("Object lockwait timing");
    private JCheckBox _processWaitEvents_chk = new JCheckBox("Process wait events");
    private JCheckBox _sqlBatchCapture_chk = new JCheckBox("SQL batch capture");
    private JCheckBox _waitEventTiming_chk = new JCheckBox("Wait event timing");
    private JCheckBox _deadlockPipeActive_chk = new JCheckBox("Deadlock pipe active");
    private SpinnerNumberModel _deadlockPipeMaxMessages_spm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 500);
    private JSpinner _deadlockPipeMaxMessages_sp = new JSpinner(this._deadlockPipeMaxMessages_spm);
    private JCheckBox _errorlogPipeActive_chk = new JCheckBox("Errorlog pipe active");
    private SpinnerNumberModel _errorlogPipeMaxMessages_spm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 500);
    private JSpinner _errorlogPipeMaxMessages_sp = new JSpinner(this._errorlogPipeMaxMessages_spm);
    private JCheckBox _sqlTextPipeActive_chk = new JCheckBox("SQL text pipe active");
    private SpinnerNumberModel _sqlTextPipeMaxMessages_spm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1000);
    private JSpinner _sqlTextPipeMaxMessages_sp = new JSpinner(this._sqlTextPipeMaxMessages_spm);
    private JCheckBox _statementPipeActive_chk = new JCheckBox("Statement pipe active");
    private SpinnerNumberModel _statementPipeMaxMessages_spm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 2000);
    private JSpinner _statementPipeMaxMessages_sp = new JSpinner(this._statementPipeMaxMessages_spm);
    private JCheckBox _planTextPipeActive_chk = new JCheckBox("Plan text pipe active");
    private SpinnerNumberModel _planTextPipeMaxMessages_spm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 3000);
    private JSpinner _planTextPipeMaxMessages_sp = new JSpinner(this._planTextPipeMaxMessages_spm);
    private JLabel _maxSqlTextMonitored_lbl = new JLabel("max SQL text monitored");
    private SpinnerNumberModel _maxSqlTextMonitored_spm = new SpinnerNumberModel(0, 0, Short.MAX_VALUE, 512);
    private JSpinner _maxSqlTextMonitored_sp = new JSpinner(this._maxSqlTextMonitored_spm);
    private JLabel _predefinedConfigs_lbl = new JLabel("Use pre-defined configuration");
    private JComboBox _predefinedConfigs_cbx = new JComboBox<String>(PDC_OPTIONS_STR);
    private JLabel _configurabelMemory_lbl = new JLabel("# MB available for reconfiguration.");
    private JRadioButton _onExitDoNotDisable_rb = new JRadioButton("Do Not Disable", true);
    private JRadioButton _onExitAutoDisable_rb = new JRadioButton("Automatically");
    private JRadioButton _onExitAsk_rb = new JRadioButton("Prompt");
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");

    private AseMonitoringConfigDialog(Frame owner, Connection conn, int aseVersionNum, String title) {
        super(owner, title, true);
        this.init(owner, conn, aseVersionNum);
    }

    private AseMonitoringConfigDialog(Dialog owner, Connection conn, int aseVersionNum, String title) {
        super(owner, title, true);
        this.init(owner, conn, aseVersionNum);
    }

    private void init(Window owner, Connection conn, int aseVersionNum) {
        this._conn = conn;
        this.setAseVersion(aseVersionNum);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setFocus();
    }

    public static void showDialog(Frame owner, Connection conn, int aseVersionNum) {
        AseMonitoringConfigDialog dialog = new AseMonitoringConfigDialog(owner, conn, aseVersionNum, msgDialogTitle);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Dialog owner, Connection conn, int aseVersionNum) {
        AseMonitoringConfigDialog dialog = new AseMonitoringConfigDialog(owner, conn, aseVersionNum, msgDialogTitle);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Component owner, Connection conn, int aseVersionNum) {
        AseMonitoringConfigDialog dialog = null;
        dialog = owner instanceof Frame ? new AseMonitoringConfigDialog((Frame)owner, conn, aseVersionNum, msgDialogTitle) : (owner instanceof Dialog ? new AseMonitoringConfigDialog((Dialog)owner, conn, aseVersionNum, msgDialogTitle) : new AseMonitoringConfigDialog((Dialog)null, conn, aseVersionNum, msgDialogTitle));
        dialog.setVisible(true);
        dialog.dispose();
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("wrap 1", "grow", ""));
        this._monitoringPanel = this.createMonitoringPanel();
        panel.add((Component)this._monitoringPanel, "grow");
        panel.add((Component)this.createOnExitPanel(), "grow");
        panel.add((Component)this.createOkCancelPanel(), "bottom, right, push");
        this.loadProps();
        this.setContentPane(panel);
    }

    private JPanel createMonitoringPanel() {
        JPanel panel = SwingUtils.createPanel("sp_configure 'Monitoring'", true);
        panel.setLayout((LayoutManager)new MigLayout("gap 0", "", ""));
        this._enableMonitoring_chk.setToolTipText(this._tts.add(this._enableMonitoring_chk, "enable monitoring specifies whether the Adaptive Server will collect information for the Monitoring and Diagnostic System."));
        this._perObjectStatisticsActive_chk.setToolTipText(this._tts.add(this._perObjectStatisticsActive_chk, "per object statistics active determines whether the Adaptive Server will collect monitoring information on a per object basis."));
        this._statementStatisticsActive_chk.setToolTipText(this._tts.add(this._statementStatisticsActive_chk, "statement statistics active indicates whether ASE will collect ad-hoc statement monitoring information."));
        this._statementCacheMonitoring_chk.setToolTipText(this._tts.add(this._statementCacheMonitoring_chk, "Use 'enable stmt cache monitoring' to configure Adaptive Server to collect the monitoring information on the statement cache.."));
        this._objectLockwaitTiming_chk.setToolTipText(this._tts.add(this._objectLockwaitTiming_chk, "object lockwait timing specifies whether the Adaptive Server will collect timing data on lock requests."));
        this._processWaitEvents_chk.setToolTipText(this._tts.add(this._processWaitEvents_chk, "process event timing specifies whether the Adaptive Server will collect monitoring data on wait events for individual processes."));
        this._sqlBatchCapture_chk.setToolTipText(this._tts.add(this._sqlBatchCapture_chk, "SQL batch capture indicates whether the Adaptive Server will collect sql batch text for each process."));
        this._waitEventTiming_chk.setToolTipText(this._tts.add(this._waitEventTiming_chk, "wait event timing specifies whether the Adaptive Server will collect monitoring data for all wait events."));
        this._deadlockPipeActive_chk.setToolTipText(this._tts.add(this._deadlockPipeActive_chk, "deadlock pipe active indicates whether the Adaptive Server will collect historical deadlock monitoring information."));
        this._deadlockPipeMaxMessages_sp.setToolTipText(this._tts.add(this._deadlockPipeMaxMessages_sp, "deadlock pipe max messages specifies the maximum number of messages that can be stored for historical deadlock data."));
        this._errorlogPipeActive_chk.setToolTipText(this._tts.add(this._errorlogPipeActive_chk, "errorlog pipe active indicates whether the Adaptive Server will collect historical errorlog monitoring information."));
        this._errorlogPipeMaxMessages_sp.setToolTipText(this._tts.add(this._errorlogPipeMaxMessages_sp, "errorlog pipe max messages specifies the maximum number of messages that can be stored for historical errorlog text."));
        this._sqlTextPipeActive_chk.setToolTipText(this._tts.add(this._sqlTextPipeActive_chk, "sql text pipe active indicates whether the Adaptive Server will collect historical sql batch text information. (This may degrade performance up to 5%)"));
        this._sqlTextPipeMaxMessages_sp.setToolTipText(this._tts.add(this._sqlTextPipeMaxMessages_sp, "sql text pipe max messages specifies the maximum number of messages that can be stored for historical sql text. (This may degrade performance up to 5%)"));
        this._statementPipeActive_chk.setToolTipText(this._tts.add(this._statementPipeActive_chk, "statement pipe active indicates whether the Adaptive Server will collect historical statement level monitoring information. (This may degrade performance up to 10%)"));
        this._statementPipeMaxMessages_sp.setToolTipText(this._tts.add(this._statementPipeMaxMessages_sp, "statement pipe max messages specifies the maximum number of messages that can be stored for historical statement text. (This may degrade performance up to 10%)"));
        this._planTextPipeActive_chk.setToolTipText(this._tts.add(this._planTextPipeActive_chk, "plan text pipe active indicates whether the Adaptive Server will collect historical plan text monitoring information. (This may degrade performance up to 25%)"));
        this._planTextPipeMaxMessages_sp.setToolTipText(this._tts.add(this._planTextPipeMaxMessages_sp, "plan text pipe max messages specifies the maximum number of messages that can be stored for historical plan text. (This may degrade performance up to 25%)"));
        this._maxSqlTextMonitored_lbl.setToolTipText(this._tts.add(this._maxSqlTextMonitored_lbl, "Restart required: specifies the amount of memory allocated per user connection for saving SQL text to memory shared by Adaptive Server. The default value is 0."));
        this._maxSqlTextMonitored_sp.setToolTipText(this._tts.add(this._maxSqlTextMonitored_sp, "Restart required: specifies the amount of memory allocated per user connection for saving SQL text to memory shared by Adaptive Server. The default value is 0."));
        this._predefinedConfigs_lbl.setToolTipText(this._tts.add(this._predefinedConfigs_lbl, "A pre defined value set of the above configurations."));
        this._predefinedConfigs_cbx.setToolTipText(this._tts.add(this._predefinedConfigs_cbx, "A pre defined value set of the above configurations."));
        this._configurabelMemory_lbl.setToolTipText(this._tts.add(this._configurabelMemory_lbl, "Available memory to be used for additional configurations or 'data caches' etc. This memory is basically not used by the ASE, meaning it's \"waste\" and ready for usage by someone..."));
        panel.add((Component)this._enableMonitoring_chk, "wrap 15");
        panel.add((Component)this._perObjectStatisticsActive_chk, "wrap");
        panel.add((Component)this._statementStatisticsActive_chk, "wrap");
        panel.add((Component)this._statementCacheMonitoring_chk, "wrap");
        panel.add((Component)this._objectLockwaitTiming_chk, "wrap");
        panel.add((Component)this._processWaitEvents_chk, "wrap");
        panel.add((Component)this._sqlBatchCapture_chk, "wrap");
        panel.add((Component)this._waitEventTiming_chk, "wrap 15");
        panel.add((Component)this._deadlockPipeActive_chk, "");
        panel.add((Component)this._deadlockPipeMaxMessages_sp, "right, wrap");
        panel.add((Component)this._errorlogPipeActive_chk, "");
        panel.add((Component)this._errorlogPipeMaxMessages_sp, "right, wrap 10");
        panel.add((Component)this._sqlTextPipeActive_chk, "");
        panel.add((Component)this._sqlTextPipeMaxMessages_sp, "right, wrap");
        panel.add((Component)this._statementPipeActive_chk, "");
        panel.add((Component)this._statementPipeMaxMessages_sp, "right, wrap");
        panel.add((Component)this._planTextPipeActive_chk, "");
        panel.add((Component)this._planTextPipeMaxMessages_sp, "right, wrap 15");
        panel.add((Component)this._maxSqlTextMonitored_lbl, "");
        panel.add((Component)this._maxSqlTextMonitored_sp, "right, wrap 10");
        panel.add((Component)new JSeparator(), "span, grow, push, wrap 10");
        panel.add((Component)this._predefinedConfigs_lbl, "");
        panel.add((Component)this._predefinedConfigs_cbx, "right, wrap 10");
        panel.add((Component)this._configurabelMemory_lbl, "span, wrap");
        this._predefinedConfigs_cbx.addActionListener(this);
        return panel;
    }

    private JPanel createOnExitPanel() {
        JPanel panel = SwingUtils.createPanel("Disable Monitoring On Exit", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._onExitDoNotDisable_rb.setToolTipText("Monitoring is not disabled when sybmon is terminated.");
        this._onExitAutoDisable_rb.setToolTipText("If no other sybmon is running at the same time, the monitoring will be disabled and on next login it will be enabled again.");
        this._onExitAsk_rb.setToolTipText("A popup will ask you if you want to disable Monitoring everytime the 'AseMon' is terminated.");
        ButtonGroup group = new ButtonGroup();
        group.add(this._onExitDoNotDisable_rb);
        group.add(this._onExitAutoDisable_rb);
        group.add(this._onExitAsk_rb);
        panel.add((Component)this._onExitDoNotDisable_rb, "");
        panel.add((Component)this._onExitAutoDisable_rb, "");
        panel.add((Component)this._onExitAsk_rb, "");
        return panel;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.add((Component)this._ok, "tag ok, right");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._apply.setEnabled(false);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    @Override
    public void setVisible(boolean visible) {
        _logger.debug((Object)("AseMonitoringConfigDialog.setVisible(" + visible + ")"));
        if (!AseConnectionUtils.hasRole(this._conn, "sa_role")) {
            String msg = "Sorry, you need 'sa_role' to configure monitoring parameters. Ask you'r System Administrator to configure this.";
            SwingUtils.showErrorMessage(this, "Not authorized to do sp_configure", msg, null);
            return;
        }
        this._configErrors = false;
        if (visible) {
            if (!AseConnectionUtils.isConnectionOk(this._conn, true, this)) {
                return;
            }
            if (this._aseVersionNum <= 0) {
                this._aseVersionNum = AseConnectionUtils.getAseVersionNumber(this._conn);
                _logger.debug((Object)("setVisible(" + visible + ") Need to refresh the ASE Server version number, it is now '" + this._aseVersionNum + "'."));
            }
            this._predefinedConfigs_cbx.setSelectedIndex(0);
            this._monitoringPanel.setEnabled(true);
            for (int i = 0; i < this._monitoringPanel.getComponentCount(); ++i) {
                Component comp = this._monitoringPanel.getComponent(i);
                comp.setEnabled(false);
                if (comp.equals(this._statementCacheMonitoring_chk)) {
                    if (this._aseVersionNum < 15020) continue;
                    comp.setEnabled(true);
                    continue;
                }
                comp.setEnabled(true);
            }
        } else {
            this._predefinedConfigs_cbx.setSelectedIndex(1);
            this._monitoringPanel.setEnabled(false);
            for (int i = 0; i < this._monitoringPanel.getComponentCount(); ++i) {
                this._monitoringPanel.getComponent(i).setEnabled(false);
            }
        }
        if (visible) {
            this.loadProps();
        }
        super.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._predefinedConfigs_cbx.equals(source)) {
            String str = this._predefinedConfigs_cbx.getSelectedItem().toString();
            this.performPredefinedConfigsAction(str);
        }
        if (this._cancel.equals(source)) {
            this.setVisible(false);
        }
        if (this._ok.equals(source)) {
            this.storeInAse(this._conn);
            if (!this._configErrors) {
                this.setVisible(false);
            }
            this.saveProps();
        }
        if (this._apply.equals(source)) {
            this.storeInAse(this._conn);
            this.saveProps();
        }
    }

    public void setAseVersion(int versionNumber) {
        this._aseVersionNum = versionNumber;
    }

    public int getAseVersion() {
        return this._aseVersionNum;
    }

    private void setFocus() {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                AseMonitoringConfigDialog.this._ok.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    private void performPredefinedConfigsAction(String str) {
        if (str == null || str != null && str.trim().equals("")) {
            _logger.debug((Object)"performPredefinedConfigsAction() has empty or null string as input.");
            return;
        }
        if (str.equals(PDC_OPTIONS_STR[0])) {
            this.loadFromAse(this._conn);
            if (this._conn == null) {
                str = PDC_OPTIONS_STR[1];
            }
        }
        if (str.equals(PDC_OPTIONS_STR[1])) {
            this._enableMonitoring_chk.setSelected(false);
            this._perObjectStatisticsActive_chk.setSelected(false);
            this._statementStatisticsActive_chk.setSelected(false);
            this._statementCacheMonitoring_chk.setSelected(false);
            this._objectLockwaitTiming_chk.setSelected(false);
            this._processWaitEvents_chk.setSelected(false);
            this._sqlBatchCapture_chk.setSelected(false);
            this._waitEventTiming_chk.setSelected(false);
            this._deadlockPipeActive_chk.setSelected(false);
            this._errorlogPipeActive_chk.setSelected(false);
            this._sqlTextPipeActive_chk.setSelected(false);
            this._planTextPipeActive_chk.setSelected(false);
            this._statementPipeActive_chk.setSelected(false);
            this._deadlockPipeMaxMessages_spm.setValue(new Integer(0));
            this._errorlogPipeMaxMessages_spm.setValue(new Integer(0));
            this._sqlTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._statementPipeMaxMessages_spm.setValue(new Integer(0));
            this._planTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._maxSqlTextMonitored_spm.setValue(new Integer(0));
        }
        if (str.equals(PDC_OPTIONS_STR[2])) {
            this._enableMonitoring_chk.setSelected(true);
            this._perObjectStatisticsActive_chk.setSelected(true);
            this._statementStatisticsActive_chk.setSelected(false);
            this._statementCacheMonitoring_chk.setSelected(false);
            this._objectLockwaitTiming_chk.setSelected(false);
            this._processWaitEvents_chk.setSelected(false);
            this._sqlBatchCapture_chk.setSelected(false);
            this._waitEventTiming_chk.setSelected(true);
            this._deadlockPipeActive_chk.setSelected(false);
            this._errorlogPipeActive_chk.setSelected(false);
            this._sqlTextPipeActive_chk.setSelected(false);
            this._statementPipeActive_chk.setSelected(false);
            this._planTextPipeActive_chk.setSelected(false);
            this._deadlockPipeMaxMessages_spm.setValue(new Integer(0));
            this._errorlogPipeMaxMessages_spm.setValue(new Integer(0));
            this._sqlTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._statementPipeMaxMessages_spm.setValue(new Integer(0));
            this._planTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._maxSqlTextMonitored_spm.setValue(new Integer(0));
        }
        if (str.equals(PDC_OPTIONS_STR[3])) {
            this._enableMonitoring_chk.setSelected(true);
            this._perObjectStatisticsActive_chk.setSelected(true);
            this._statementStatisticsActive_chk.setSelected(true);
            this._statementCacheMonitoring_chk.setSelected(true);
            this._objectLockwaitTiming_chk.setSelected(true);
            this._processWaitEvents_chk.setSelected(true);
            this._sqlBatchCapture_chk.setSelected(false);
            this._waitEventTiming_chk.setSelected(true);
            this._deadlockPipeActive_chk.setSelected(false);
            this._errorlogPipeActive_chk.setSelected(false);
            this._sqlTextPipeActive_chk.setSelected(false);
            this._statementPipeActive_chk.setSelected(false);
            this._planTextPipeActive_chk.setSelected(false);
            this._deadlockPipeMaxMessages_spm.setValue(new Integer(0));
            this._errorlogPipeMaxMessages_spm.setValue(new Integer(0));
            this._sqlTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._statementPipeMaxMessages_spm.setValue(new Integer(0));
            this._planTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._maxSqlTextMonitored_spm.setValue(new Integer(0));
        }
        if (str.equals(PDC_OPTIONS_STR[4])) {
            this._enableMonitoring_chk.setSelected(true);
            this._perObjectStatisticsActive_chk.setSelected(true);
            this._statementStatisticsActive_chk.setSelected(true);
            this._statementCacheMonitoring_chk.setSelected(true);
            this._objectLockwaitTiming_chk.setSelected(true);
            this._processWaitEvents_chk.setSelected(true);
            this._sqlBatchCapture_chk.setSelected(true);
            this._waitEventTiming_chk.setSelected(true);
            this._deadlockPipeActive_chk.setSelected(true);
            this._errorlogPipeActive_chk.setSelected(true);
            this._sqlTextPipeActive_chk.setSelected(true);
            this._statementPipeActive_chk.setSelected(true);
            this._planTextPipeActive_chk.setSelected(false);
            this._deadlockPipeMaxMessages_spm.setValue(new Integer(500));
            this._errorlogPipeMaxMessages_spm.setValue(new Integer(200));
            this._sqlTextPipeMaxMessages_spm.setValue(new Integer(1000));
            this._statementPipeMaxMessages_spm.setValue(new Integer(5000));
            this._planTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._maxSqlTextMonitored_spm.setValue(new Integer(2048));
        }
        if (str.equals(PDC_OPTIONS_STR[5])) {
            this._enableMonitoring_chk.setSelected(true);
            this._perObjectStatisticsActive_chk.setSelected(true);
            this._statementStatisticsActive_chk.setSelected(true);
            this._statementCacheMonitoring_chk.setSelected(true);
            this._objectLockwaitTiming_chk.setSelected(true);
            this._processWaitEvents_chk.setSelected(true);
            this._sqlBatchCapture_chk.setSelected(true);
            this._waitEventTiming_chk.setSelected(true);
            this._deadlockPipeActive_chk.setSelected(true);
            this._errorlogPipeActive_chk.setSelected(true);
            this._sqlTextPipeActive_chk.setSelected(true);
            this._statementPipeActive_chk.setSelected(true);
            this._planTextPipeActive_chk.setSelected(false);
            this._deadlockPipeMaxMessages_spm.setValue(new Integer(1000));
            this._errorlogPipeMaxMessages_spm.setValue(new Integer(1000));
            this._sqlTextPipeMaxMessages_spm.setValue(new Integer(5000));
            this._statementPipeMaxMessages_spm.setValue(new Integer(50000));
            this._planTextPipeMaxMessages_spm.setValue(new Integer(0));
            this._maxSqlTextMonitored_spm.setValue(new Integer(4096));
        }
    }

    public void loadFromAse(Connection conn) {
        if (!AseConnectionUtils.isConnectionOk(conn, true, this)) {
            return;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("sp_configure 'Monitoring'");
            while (rs.next()) {
                String config = rs.getString(1).trim();
                int runVal = rs.getInt(5);
                int cfgVal = rs.getInt(4);
                if (config.equals("enable monitoring")) {
                    this._enableMonitoring_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("per object statistics active")) {
                    this._perObjectStatisticsActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("statement statistics active")) {
                    this._statementStatisticsActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("enable stmt cache monitoring")) {
                    this._statementCacheMonitoring_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("object lockwait timing")) {
                    this._objectLockwaitTiming_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("process wait events")) {
                    this._processWaitEvents_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("SQL batch capture")) {
                    this._sqlBatchCapture_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("wait event timing")) {
                    this._waitEventTiming_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("deadlock pipe active")) {
                    this._deadlockPipeActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("deadlock pipe max messages")) {
                    this._deadlockPipeMaxMessages_spm.setValue(new Integer(runVal));
                    continue;
                }
                if (config.equals("errorlog pipe active")) {
                    this._errorlogPipeActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("errorlog pipe max messages")) {
                    this._errorlogPipeMaxMessages_spm.setValue(new Integer(runVal));
                    continue;
                }
                if (config.equals("sql text pipe active")) {
                    this._sqlTextPipeActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("sql text pipe max messages")) {
                    this._sqlTextPipeMaxMessages_spm.setValue(new Integer(runVal));
                    continue;
                }
                if (config.equals("statement pipe active")) {
                    this._statementPipeActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("statement pipe max messages")) {
                    this._statementPipeMaxMessages_spm.setValue(new Integer(runVal));
                    continue;
                }
                if (config.equals("plan text pipe active")) {
                    this._planTextPipeActive_chk.setSelected(runVal == 1);
                    continue;
                }
                if (config.equals("plan text pipe max messages")) {
                    this._planTextPipeMaxMessages_spm.setValue(new Integer(runVal));
                    continue;
                }
                if (config.equals("max SQL text monitored")) {
                    if (cfgVal != runVal) {
                        _logger.debug((Object)("Config option(" + cfgVal + ") not same as run(" + runVal + ")"));
                        ((JSpinner.DefaultEditor)this._maxSqlTextMonitored_sp.getEditor()).getTextField().setForeground(Color.RED);
                        this._maxSqlTextMonitored_sp.setToolTipText("ASE server needs to be rebooted since this is a static configuration parameter. The run value is still " + runVal + ".");
                    } else {
                        this._maxSqlTextMonitored_sp.setToolTipText(this._tts.get(this._maxSqlTextMonitored_sp));
                        ((JSpinner.DefaultEditor)this._maxSqlTextMonitored_sp.getEditor()).getTextField().setForeground(Color.BLACK);
                    }
                    this._maxSqlTextMonitored_spm.setValue(new Integer(cfgVal));
                    continue;
                }
                if (config.equals("performance monitoring option")) {
                    _logger.debug((Object)"Skipping 'performance monitoring option'.");
                    continue;
                }
                _logger.info((Object)("UNKNOWN option '" + config + "' this is probably a new option after AseMon has been developed. executed command sp_configure 'Monitoring'."));
            }
            rs.close();
            rs = stmt.executeQuery("select additional_free_memory = str( ((max(b.value) - min(b.value)) / 512.0), 15,1 ) from master.dbo.sysconfigures a, master.dbo.syscurconfigs b where a.name in ('max memory', 'total logical memory')   and a.config = b.config");
            while (rs.next()) {
                String mb = rs.getString(1).trim();
                this._configurabelMemory_lbl.setText(mb + default_configurabelMemoryText);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            AseConnectionUtils.showSqlExceptionMessage(this, msgDialogTitle, "Error when executing the following SQL statement: sp_configure 'Monitoring'", e);
        }
        catch (Exception e) {
            SwingUtils.showErrorMessage(this, msgDialogTitle, "Error when executing the following SQL statement: sp_configure 'Monitoring'\n\n" + e.getMessage(), e);
        }
    }

    private boolean checkAndSetAseConfig(Connection conn, String config, JComponent comp) {
        block10: {
            comp.setToolTipText(this._tts.get(comp));
            try {
                if (!comp.isEnabled()) {
                    return false;
                }
                if (comp instanceof JCheckBox) {
                    JCheckBox chkbox = (JCheckBox)comp;
                    chkbox.setForeground(Color.BLACK);
                    boolean aseCfgBool = false;
                    boolean guiCfgBool = false;
                    aseCfgBool = AseConnectionUtils.getAseConfigConfigValue(conn, config) != 0;
                    guiCfgBool = chkbox.isSelected();
                    if (aseCfgBool != guiCfgBool) {
                        AseConnectionUtils.setAseConfigValue(conn, config, guiCfgBool);
                    }
                } else if (comp instanceof JSpinner) {
                    JSpinner spinner = (JSpinner)comp;
                    ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setForeground(Color.BLACK);
                    int aseCfgInt = 0;
                    int guiCfgInt = 0;
                    Object guiCfgObj = null;
                    aseCfgInt = AseConnectionUtils.getAseConfigConfigValue(conn, config);
                    guiCfgObj = spinner.getModel().getValue();
                    if (guiCfgObj instanceof Integer && aseCfgInt != (guiCfgInt = ((Integer)guiCfgObj).intValue())) {
                        AseConnectionUtils.setAseConfigValue(conn, config, guiCfgInt);
                    }
                }
            }
            catch (SQLException sqle) {
                String errStr = "";
                while (sqle != null) {
                    errStr = errStr + sqle.getMessage() + " ";
                    sqle = sqle.getNextException();
                }
                if (errStr.equals("")) break block10;
                this._configErrors = true;
                comp.setToolTipText(errStr);
                _logger.warn((Object)("checkAndSetAseConfig(): Problems when configuring '" + config + "', got error '" + errStr + "'."));
                if (comp instanceof JCheckBox) {
                    JCheckBox chkbox = (JCheckBox)comp;
                    chkbox.setForeground(Color.RED);
                }
                if (!(comp instanceof JSpinner)) break block10;
                JSpinner spinner = (JSpinner)comp;
                ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setForeground(Color.RED);
            }
        }
        return true;
    }

    public void storeInAse(Connection conn) {
        if (conn == null) {
            if (this._monitoringPanel.isEnabled()) {
                SwingUtils.showInfoMessage(this, msgDialogTitle, "Not connected to any ASE server.");
            }
            return;
        }
        this._configErrors = false;
        this.checkAndSetAseConfig(conn, "enable monitoring", this._enableMonitoring_chk);
        this.checkAndSetAseConfig(conn, "per object statistics active", this._perObjectStatisticsActive_chk);
        this.checkAndSetAseConfig(conn, "statement statistics active", this._statementStatisticsActive_chk);
        this.checkAndSetAseConfig(conn, "enable stmt cache monitoring", this._statementCacheMonitoring_chk);
        this.checkAndSetAseConfig(conn, "object lockwait timing", this._objectLockwaitTiming_chk);
        this.checkAndSetAseConfig(conn, "process wait events", this._processWaitEvents_chk);
        this.checkAndSetAseConfig(conn, "SQL batch capture", this._sqlBatchCapture_chk);
        this.checkAndSetAseConfig(conn, "wait event timing", this._waitEventTiming_chk);
        this.checkAndSetAseConfig(conn, "deadlock pipe active", this._deadlockPipeActive_chk);
        this.checkAndSetAseConfig(conn, "errorlog pipe active", this._errorlogPipeActive_chk);
        this.checkAndSetAseConfig(conn, "sql text pipe active", this._sqlTextPipeActive_chk);
        this.checkAndSetAseConfig(conn, "statement pipe active", this._statementPipeActive_chk);
        this.checkAndSetAseConfig(conn, "plan text pipe active", this._planTextPipeActive_chk);
        this.checkAndSetAseConfig(conn, "deadlock pipe max messages", this._deadlockPipeMaxMessages_sp);
        this.checkAndSetAseConfig(conn, "errorlog pipe max messages", this._errorlogPipeMaxMessages_sp);
        this.checkAndSetAseConfig(conn, "sql text pipe max messages", this._sqlTextPipeMaxMessages_sp);
        this.checkAndSetAseConfig(conn, "statement pipe max messages", this._statementPipeMaxMessages_sp);
        this.checkAndSetAseConfig(conn, "plan text pipe max messages", this._planTextPipeMaxMessages_sp);
        this.checkAndSetAseConfig(conn, "max SQL text monitored", this._maxSqlTextMonitored_sp);
        if (!this._configErrors) {
            this.loadFromAse(conn);
        }
    }

    public static int onExit(Component parent, Connection conn) {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return 0;
        }
        boolean onExitDoNotDisable = false;
        boolean onExitAutoDisable = false;
        boolean onExitPrompt = false;
        String str = conf.getProperty("config.on_exit", ON_EXIT_STR[0]);
        _logger.debug((Object)("loadProps: 'config.on_exit' = '" + str + "'"));
        if (str != null) {
            if (str.equals(ON_EXIT_STR[0])) {
                onExitDoNotDisable = true;
            }
            if (str.equals(ON_EXIT_STR[1])) {
                onExitAutoDisable = true;
            }
            if (str.equals(ON_EXIT_STR[2])) {
                onExitPrompt = true;
            }
        }
        if (onExitDoNotDisable) {
            return 0;
        }
        boolean disable = onExitAutoDisable;
        if (onExitPrompt) {
            str = "Do you want to disable ASE monitoring when exiting asemon.\n\nIf yes the following SQL statement will be sent to the ASE Server:\nexec sp_configure 'enable monitoring', 0\n\n";
            int answer = JOptionPane.showConfirmDialog(parent, str, "Disable Monitoring On Exit", 1, 3);
            _logger.debug((Object)("onExitPrompt: " + answer));
            if (answer == 0) {
                disable = true;
            }
            if (answer == 2) {
                disable = false;
                return answer;
            }
        }
        if (disable) {
            if (!AseConnectionUtils.isConnectionOk(conn, true, parent)) {
                return 0;
            }
            try {
                int otherAsemonCount = 0;
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select count(*)-1 from master..sysprocesses where program_name like '" + Version.getAppName() + "%'");
                while (rs.next()) {
                    otherAsemonCount = rs.getInt(1);
                }
                rs.close();
                stmt.close();
                if (otherAsemonCount > 0) {
                    JOptionPane.showMessageDialog(parent, "There are " + otherAsemonCount + " other '" + Version.getAppName() + "' applications connected to the ASE Server. I cant disable monitoring for the moment.", "Disable Monitoring On Exit", 1);
                } else {
                    AseConnectionUtils.setAseConfigValue(conn, "enable monitoring", false);
                }
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }

    private void saveProps() {
        String onExit = null;
        if (this._onExitDoNotDisable_rb.isSelected()) {
            onExit = ON_EXIT_STR[0];
        }
        if (this._onExitAutoDisable_rb.isSelected()) {
            onExit = ON_EXIT_STR[1];
        }
        if (this._onExitAsk_rb.isSelected()) {
            onExit = ON_EXIT_STR[2];
        }
        _logger.debug((Object)("saveProps: 'config.on_exit' = '" + onExit + "'"));
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        conf.setProperty("config.on_exit", onExit);
        conf.save();
    }

    private void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        String str = null;
        str = conf.getProperty("config.on_exit", ON_EXIT_STR[0]);
        _logger.debug((Object)("loadProps: 'config.on_exit' = '" + str + "'"));
        if (str != null) {
            if (str.equals(ON_EXIT_STR[0])) {
                this._onExitDoNotDisable_rb.setSelected(true);
            }
            if (str.equals(ON_EXIT_STR[1])) {
                this._onExitAutoDisable_rb.setSelected(true);
            }
            if (str.equals(ON_EXIT_STR[2])) {
                this._onExitAsk_rb.setSelected(true);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf1 = new Configuration("c:\\projects\\asemon\\asemon.save.properties");
        Configuration.setInstance("USER_TEMP", conf1);
        Configuration conf2 = new Configuration("c:\\projects\\asemon\\asemon.properties");
        Configuration.setInstance("SYSTEM_CONF", conf2);
        try {
            System.out.println("Open the Dialog with a VALID connection.");
            Connection conn = AseConnectionFactory.getConnection("goransxp", 5000, null, "sa", "", "test-AseMonitoringConfigDialog", null);
            AseMonitoringConfigDialog.showDialog((Frame)null, conn, 12510);
            System.out.println("Open the Dialog with a CLOSED connection.");
            conn.close();
            AseMonitoringConfigDialog.showDialog((Frame)null, conn, 12510);
            System.out.println("Open the Dialog with a NULL connection.");
            AseMonitoringConfigDialog.showDialog((Frame)null, null, 12510);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ToolTipStore {
        private Map<JComponent, String> _storage = new HashMap<JComponent, String>();

        private ToolTipStore() {
        }

        protected String add(JComponent comp, String toolTipText) {
            this._storage.put(comp, toolTipText);
            return toolTipText;
        }

        protected String get(JComponent comp) {
            return this._storage.get(comp);
        }
    }
}

