/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class ChangeToJTabDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 802663031446167220L;
    private static final String PROP_PREFIX = "ChangeToJTabDialog";
    private static final String PROP_ACTION_CHANGE = "CHANGE";
    private static final String PROP_ACTION_STAY = "STAY";
    private static final String PROP_NEXT_TIME_ALWAYS_REMEMBER = "ALWAYS_REMEMBER";
    private static final String PROP_NEXT_TIME_REMEMBER_SESSION = "REMEMBER_SESSION";
    private static final String PROP_NEXT_TIME_QUESTION = "ASK";
    private static HashMap<String, Boolean> _hasBeenVisible = new HashMap();
    private String _message = null;
    private String _toTabName = null;
    private JTabbedPane _tabPane = null;
    private JLabel _message_lbl = new JLabel("");
    private JRadioButton _action_change_rb = new JRadioButton("", true);
    private JRadioButton _action_stay_rb = new JRadioButton();
    private ButtonGroup _action_rbg = new ButtonGroup();
    private JRadioButton _next_alwaysRemember_rb = new JRadioButton();
    private JRadioButton _next_rememberSession_rb = new JRadioButton();
    private JRadioButton _next_alwaysAsk_rb = new JRadioButton("", true);
    private ButtonGroup _next_rbg = new ButtonGroup();
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");

    ChangeToJTabDialog(Frame owner, String message, JTabbedPane tabPane, String toTabName) {
        super(owner, "Found Blocking Locks", false);
        this._message = message;
        this._tabPane = tabPane;
        this._toTabName = toTabName;
        this.initComponents();
        this.loadProps();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected JPanel createActionPanel() {
        JPanel panel = SwingUtils.createPanel("Action", true);
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "", ""));
        this._action_change_rb.setToolTipText("Set the selected active tab to '" + this._toTabName + "' when this event happens.");
        this._action_stay_rb.setToolTipText("Do nothing when this event happens.");
        this._action_change_rb.setText("<html>Change focus to tab '<b>" + this._toTabName + "</b>'.</html>");
        this._action_stay_rb.setText("<html>Stay in <b>current</b> tab, or simply, do nothing.</html>");
        this._action_rbg.add(this._action_change_rb);
        this._action_rbg.add(this._action_stay_rb);
        panel.add((Component)this._action_change_rb, "wrap 0");
        panel.add((Component)this._action_stay_rb, "wrap 0");
        return panel;
    }

    protected JPanel createNextTimePanel() {
        JPanel panel = SwingUtils.createPanel("Next time this happens", true);
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "", ""));
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        String configFile = "asemon.save.properties";
        if (tmpConf != null) {
            configFile = tmpConf.getFilename();
        }
        this._next_alwaysRemember_rb.setToolTipText("<html>You will newer have to see this popup again when this event happens.<br>The selected action will always be executed without any popup question.<br><br>Note: To reset this option you will need to edit the file '" + configFile + "'<br>and remove all entries for '" + PROP_PREFIX + "." + this._toTabName + "'.</p>" + "</html>");
        this._next_rememberSession_rb.setToolTipText("So this popup wont be displayed until next time you start the application and the same event happens.");
        this._next_alwaysAsk_rb.setToolTipText("This popup will be shown every time this event happens.");
        this._next_alwaysRemember_rb.setText("Remember to Always make the above choice, newer ask me again.");
        this._next_rememberSession_rb.setText("Remember the above choise until the application restarts.");
        this._next_alwaysAsk_rb.setText("Always show this dialog when this happens.");
        this._next_rbg.add(this._next_alwaysRemember_rb);
        this._next_rbg.add(this._next_rememberSession_rb);
        this._next_rbg.add(this._next_alwaysAsk_rb);
        panel.add((Component)this._next_alwaysRemember_rb, "wrap 0");
        panel.add((Component)this._next_rememberSession_rb, "wrap 0");
        panel.add((Component)this._next_alwaysAsk_rb, "wrap 0");
        return panel;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 10 10", "", ""));
        this._message_lbl.setText("<html><h4>" + this._message + "</h4>" + "Choose an <b>Action</b> below that you find suitable." + "</html>");
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        panel.add((Component)new JLabel(icon), "gapx 10, gapy 10, split");
        panel.add((Component)this._message_lbl, "gapx 15, wrap 20");
        panel.add((Component)this.createActionPanel(), "push, grow, wrap");
        panel.add((Component)this.createNextTimePanel(), "push, grow, wrap");
        panel.add((Component)this._ok, "tag ok,     gap top 20, split, bottom, right, push");
        panel.add((Component)this._cancel, "tag cancel, split, bottom");
        this.setContentPane(panel);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
    }

    private void setFocus() {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                ChangeToJTabDialog.this._ok.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    @Override
    public void setVisible(boolean visible) {
        String currentSelectedTab;
        if (!visible) {
            super.setVisible(false);
            return;
        }
        if (this.isVisible()) {
            super.setVisible(true);
            return;
        }
        boolean firstTime = !_hasBeenVisible.containsKey(this._toTabName);
        _hasBeenVisible.put(this._toTabName, null);
        if (firstTime) {
            this.setFocus();
        }
        if (this._toTabName.equals(currentSelectedTab = this._tabPane.getTitleAt(this._tabPane.getSelectedIndex()))) {
            return;
        }
        if (this._next_alwaysAsk_rb.isSelected()) {
            super.setVisible(true);
            return;
        }
        if (this._next_alwaysRemember_rb.isSelected()) {
            if (this._action_stay_rb.isSelected()) {
                return;
            }
            if (this._action_change_rb.isSelected()) {
                this._tabPane.setSelectedIndex(this._tabPane.indexOfTab(this._toTabName));
            }
            return;
        }
        if (this._next_rememberSession_rb.isSelected()) {
            if (firstTime) {
                super.setVisible(true);
                return;
            }
            if (this._action_stay_rb.isSelected()) {
                return;
            }
            if (this._action_change_rb.isSelected()) {
                this._tabPane.setSelectedIndex(this._tabPane.indexOfTab(this._toTabName));
            }
            return;
        }
        super.setVisible(true);
    }

    private void loadProps() {
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        if (tmpConf == null) {
            return;
        }
        String propPrefix = "ChangeToJTabDialog." + this._toTabName + ".";
        String action = tmpConf.getProperty(propPrefix + "action", "DEFAULT");
        String nextTime = tmpConf.getProperty(propPrefix + "nextTime", "DEFAULT");
        if (action.equals(PROP_ACTION_CHANGE)) {
            this._action_change_rb.setSelected(true);
        } else if (action.equals(PROP_ACTION_STAY)) {
            this._action_stay_rb.setSelected(true);
        } else {
            this._action_change_rb.setSelected(true);
        }
        if (nextTime.equals(PROP_NEXT_TIME_ALWAYS_REMEMBER)) {
            this._next_alwaysRemember_rb.setSelected(true);
        } else if (nextTime.equals(PROP_NEXT_TIME_REMEMBER_SESSION)) {
            this._next_rememberSession_rb.setSelected(true);
        } else if (nextTime.equals(PROP_NEXT_TIME_QUESTION)) {
            this._next_alwaysAsk_rb.setSelected(true);
        } else {
            this._next_alwaysAsk_rb.setSelected(true);
        }
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        if (tmpConf == null) {
            return;
        }
        String propPrefix = "ChangeToJTabDialog." + this._toTabName + ".";
        String action = "DEFAULT";
        if (this._action_change_rb.isSelected()) {
            action = PROP_ACTION_CHANGE;
        }
        if (this._action_stay_rb.isSelected()) {
            action = PROP_ACTION_STAY;
        }
        String nextTime = "DEFAULT";
        if (this._next_alwaysRemember_rb.isSelected()) {
            nextTime = PROP_NEXT_TIME_ALWAYS_REMEMBER;
        }
        if (this._next_rememberSession_rb.isSelected()) {
            nextTime = PROP_NEXT_TIME_REMEMBER_SESSION;
        }
        if (this._next_alwaysAsk_rb.isSelected()) {
            nextTime = PROP_NEXT_TIME_QUESTION;
        }
        tmpConf.setProperty(propPrefix + "action", action);
        tmpConf.setProperty(propPrefix + "nextTime", nextTime);
        tmpConf.save();
    }

    private void apply() {
        if (this._action_change_rb.isSelected()) {
            this._tabPane.setSelectedIndex(this._tabPane.indexOfTab(this._toTabName));
        }
        this.saveProps();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._ok.equals(source)) {
            this.apply();
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this.setVisible(false);
        }
    }

    public static void resetSavedSettings(String toTabName) {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        conf.removeAll("ChangeToJTabDialog." + toTabName + ".");
        conf.save();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Configuration conf1 = new Configuration("c:\\projects\\asemon\\asemon.save.properties");
        Configuration.setInstance("USER_TEMP", conf1);
        JFrame frame = new JFrame("Test Frame"){
            private static final long serialVersionUID = 1L;
            ChangeToJTabDialog _toTab1 = null;
            ChangeToJTabDialog _toTab2 = null;
            ChangeToJTabDialog _toTab3 = null;
            ChangeToJTabDialog _toTab4 = null;
            JTabbedPane _tab = null;
            {
                this.setLayout(new BorderLayout());
                JPanel butPan = new JPanel((LayoutManager)new MigLayout());
                JButton but = new JButton("to-Tab-1");
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (_toTab1 == null) {
                            _toTab1 = new ChangeToJTabDialog(null, "Found Blocking Locks in the ASE Server", _tab, "tab1");
                        }
                        _toTab1.setVisible(true);
                    }
                });
                butPan.add(but);
                but = new JButton("to-Tab-2");
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (_toTab2 == null) {
                            _toTab2 = new ChangeToJTabDialog(null, "Found Blocking Locks in the ASE Server", _tab, "tab2");
                        }
                        _toTab2.setVisible(true);
                    }
                });
                butPan.add(but);
                but = new JButton("to-Tab-3");
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (_toTab3 == null) {
                            _toTab3 = new ChangeToJTabDialog(null, "Found Blocking Locks in the ASE Server", _tab, "tab3");
                        }
                        _toTab3.setVisible(true);
                    }
                });
                butPan.add(but);
                but = new JButton("to-Tab-4");
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (_toTab4 == null) {
                            _toTab4 = new ChangeToJTabDialog(null, "Found Blocking Locks in the ASE Server", _tab, "tab4");
                        }
                        _toTab4.setVisible(true);
                    }
                });
                butPan.add(but);
                this.add((Component)butPan, "North");
                this._tab = new JTabbedPane();
                this._tab.addTab("tab1", new JLabel("tab-1"));
                this._tab.addTab("tab2", new JLabel("tab-2"));
                this._tab.addTab("tab3", new JLabel("tab-3"));
                this._tab.addTab("tab4", new JLabel("tab-4"));
                this.add((Component)this._tab, "Center");
                this.setSize(300, 300);
                this.setDefaultCloseOperation(3);
            }
        };
        frame.setVisible(true);
    }
}

