/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Asemon;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.ConnectionProgressDialog;
import asemon.gui.JdbcOptionsDialog;
import asemon.gui.MainFrame;
import asemon.gui.swing.MultiLineLabel;
import asemon.hostmon.SshConnection;
import asemon.pcs.PersistReader;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.AseUrlHelper;
import asemon.utils.Configuration;
import asemon.utils.H2UrlHelper;
import asemon.utils.PlatformUtils;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.h2.tools.Server;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class ConnectionDialog
extends JDialog
implements ActionListener,
KeyListener,
TableModelListener,
ChangeListener {
    private static Logger _logger = Logger.getLogger(ConnectionDialog.class);
    private static final long serialVersionUID = -7782953767666701933L;
    public static final String CONF_OPTION_RECONNECT_ON_FAILURE = "conn.reconnectOnFailure";
    public static final String CONF_OPTION_CONNECT_ON_STARTUP = "conn.onStartup";
    public static final int CANCEL = 0;
    public static final int ASE_CONN = 1;
    public static final int OFFLINE_CONN = 2;
    private int _connectionType = 0;
    private Connection _aseConn = null;
    private SshConnection _sshConn = null;
    private Connection _offlineConn = null;
    private static final int TAB_POS_ASE = 0;
    private static final int TAB_POS_HOSTMON = 1;
    private static final int TAB_POS_PCS = 2;
    private static final int TAB_POS_OFFLINE = 3;
    public static final String ACTION_OK = "OK";
    public static final String ACTION_CANCEL = "CANCEL";
    private Frame _owner = null;
    private JTabbedPane _tab;
    private ImageIcon _aseLoginImageIcon = SwingUtils.readImageIcon(Version.class, "images/login_key.gif");
    private JLabel _aseLoginIcon = new JLabel(this._aseLoginImageIcon);
    private MultiLineLabel _aseLoginHelp = new MultiLineLabel("Identify yourself to the server with user name and password");
    private JLabel _aseUser_lbl = new JLabel("User name");
    private JTextField _aseUser_txt = new JTextField();
    private JLabel _asePasswd_lbl = new JLabel("Password");
    private JTextField _asePasswd_txt = null;
    private ImageIcon _aseServerImageIcon = SwingUtils.readImageIcon(Version.class, "images/ase32.gif");
    private JLabel _aseServerIcon = new JLabel(this._aseServerImageIcon);
    private MultiLineLabel _aseServerHelp = new MultiLineLabel("Select a server from the dropdown list, or enter host name and port number separeted by \":\" (For example \"" + StringUtil.getHostname() + ":5000\")");
    private JLabel _aseServerName_lbl = new JLabel();
    private JLabel _aseServer_lbl = new JLabel("Server name");
    private LocalSrvComboBox _aseServer_cbx = new LocalSrvComboBox();
    private JLabel _aseHost_lbl = new JLabel("Host name");
    private JTextField _aseHost_txt = new JTextField();
    private JLabel _asePort_lbl = new JLabel("Port number");
    private JTextField _asePort_txt = new JTextField();
    private JLabel _aseOptions_lbl = new JLabel("URL Options");
    private JTextField _aseOptions_txt = new JTextField();
    private JButton _aseOptions_but = new JButton("...");
    private JLabel _aseIfile_lbl = new JLabel("Name service");
    private JTextField _aseIfile_txt = new JTextField(AseConnectionFactory.getIFileName());
    private String _aseIfile_save = AseConnectionFactory.getIFileName();
    private JButton _aseIfile_but = new JButton("...");
    private JCheckBox _aseMonUrl_chk = new JCheckBox("Use URL", false);
    private JTextField _aseMonUrl_txt = new JTextField();
    private JCheckBox _aseOptionSavePwd_chk = new JCheckBox("Save password", true);
    private JCheckBox _aseOptionConnOnStart_chk = new JCheckBox("Connect to this server on startup", false);
    private JCheckBox _aseOptionReConnOnFailure_chk = new JCheckBox("Reconnect to server if connection is lost", true);
    private JCheckBox _aseHostMonitor_chk = new JCheckBox("Monitor the OS Host for IO and CPU...", false);
    private JCheckBox _aseOptionStore_chk = new JCheckBox("Save counter data in a Persistent Counter Storage...", false);
    private ImageIcon _hostmonLoginImageIcon = SwingUtils.readImageIcon(Version.class, "images/login_key.gif");
    private JLabel _hostmonLoginIcon = new JLabel(this._hostmonLoginImageIcon);
    private MultiLineLabel _hostmonLoginHelp = new MultiLineLabel("Identify yourself to the host Operating System with user name and password. A SSH (Secure Shell) connection will be used, so password and traffic will be encrypted over the network.");
    private JLabel _hostmonUser_lbl = new JLabel("User name");
    private JTextField _hostmonUser_txt = new JTextField();
    private JLabel _hostmonPasswd_lbl = new JLabel("Password");
    private JTextField _hostmonPasswd_txt = null;
    private ImageIcon _hostmonServerImageIcon = SwingUtils.readImageIcon(Version.class, "images/server_32.png");
    private JLabel _hostmonServerIcon = new JLabel(this._hostmonServerImageIcon);
    private MultiLineLabel _hostmonServerHelp = new MultiLineLabel("Specify host name to the machine where you want to do Operating System Monitoring. The connection will be using SSH (Secure Shell), which normally is listening on port 22. ");
    private JLabel _hostmonServerName_lbl = new JLabel();
    private JLabel _hostmonHost_lbl = new JLabel("Host Name");
    private JTextField _hostmonHost_txt = new JTextField();
    private JLabel _hostmonPort_lbl = new JLabel("Port Number");
    private JTextField _hostmonPort_txt = new JTextField("22");
    private JCheckBox _hostmonOptionSavePwd_chk = new JCheckBox("Save password", true);
    private JPanel _pcsPanel = null;
    private ImageIcon _pcsImageIcon = SwingUtils.readImageIcon(Version.class, "images/pcs_write_32.png");
    private JLabel _pcsIcon = new JLabel(this._pcsImageIcon);
    private MultiLineLabel _pcsHelp = new MultiLineLabel();
    private JLabel _pcsWriter_lbl = new JLabel("PCS Writer");
    private JComboBox _pcsWriter_cbx = new JComboBox();
    private JLabel _pcsJdbcDriver_lbl = new JLabel("JDBC Driver");
    private JComboBox _pcsJdbcDriver_cbx = new JComboBox();
    private JLabel _pcsJdbcUrl_lbl = new JLabel("JDBC Url");
    private JComboBox _pcsJdbcUrl_cbx = new JComboBox();
    private JButton _pcsJdbcUrl_but = new JButton("...");
    private JLabel _pcsJdbcUsername_lbl = new JLabel("Username");
    private JTextField _pcsJdbcUsername_txt = new JTextField("sa");
    private JLabel _pcsJdbcPassword_lbl = new JLabel("Password");
    private JTextField _pcsJdbcPassword_txt = new JPasswordField();
    private JLabel _pcsTestConn_lbl = new JLabel();
    private JButton _pcsTestConn_but = new JButton("Test Connection");
    private JXTable _pcsSessionTable = null;
    private JButton _pcsTabSelectAll_but = new JButton("Select All");
    private JButton _pcsTabDeSelectAll_but = new JButton("Deselect All");
    private JButton _pcsTabTemplate_but = new JButton("Set to Template");
    private boolean _useCmForPcsTable = true;
    private JCheckBox _pcsH2Option_startH2NetworkServer_chk = new JCheckBox("Start H2 Database as a Network Server", false);
    private JPanel _offlinePanel = null;
    private ImageIcon _offlineImageIcon = SwingUtils.readImageIcon(Version.class, "images/pcs_read_32.png");
    private JLabel _offlineIcon = new JLabel(this._offlineImageIcon);
    private MultiLineLabel _offlineHelp = new MultiLineLabel();
    private JLabel _offlineJdbcDriver_lbl = new JLabel("JDBC Driver");
    private JComboBox _offlineJdbcDriver_cbx = new JComboBox();
    private JLabel _offlineJdbcUrl_lbl = new JLabel("JDBC Url");
    private JComboBox _offlineJdbcUrl_cbx = new JComboBox();
    private JButton _offlineJdbcUrl_but = new JButton("...");
    private JLabel _offlineJdbcUsername_lbl = new JLabel("Username");
    private JTextField _offlineJdbcUsername_txt = new JTextField("sa");
    private JLabel _offlineJdbcPassword_lbl = new JLabel("Password");
    private JTextField _offlineJdbcPassword_txt = new JPasswordField();
    private JButton _offlineTestConn_but = new JButton("Test Connection");
    private JCheckBox _offlineCheckForNewSessions_chk = new JCheckBox("Check PCS database for new sample sessions", true);
    private JCheckBox _offlineH2Option_startH2NwSrv_chk = new JCheckBox("Start H2 Database as a Network Server", false);
    private JLabel _ok_lbl = new JLabel("");
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private boolean _checkAseCfg = true;
    private boolean _showAseTab = true;
    private boolean _showHostmonTab = true;
    private boolean _showPcsTab = true;
    private boolean _showOfflineTab = true;
    private boolean _showAseOptions = true;
    public static final String JDBC_URL_TOOLTIP = "<html>URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver<br><br>For H2 you can use the following variables: <code>${DATE}, ${SERVERNAME}, ${ASEHOSTNAME}, ${ASEMON_HOME}, ${ASEMON_SAVE_DIR}</code><br>Explanation of the above variables<br><ul>  <li><code>${DATE[:format=fmt[;roll=true|false]]}</code><br>    The DATE will be substituted with a timestamp, the format of the timestamp is specified by modifier 'format'.<br>    <br>    The DATE variable has modifiers, which means you can change the behaviour of the variable.<br>    <ul>      <li>modifier: <code>format=formatSpecification</code><br>          Is how the DATE string should be built.<br>          The specification is according to <code>java.text.SimpleDateFormat</code>.<br>          The default value is <code>yyyy-MM-dd</code>      </li>      <li>modifier: <code>roll=true|false</code><br>          This means: start/create a new database if we roll over into a new DATE string.<br>          With the format=<code>yyyy-MM-dd</code> a new DB will be created every midnight.<br>          With the format=<code>yyyy-MM-dd_HH</code> a new DB will be created every hour.<br>          The default value for <code>roll</code> is <code>false</code>.       </li>    </ul>    The default value for <code>format</code> can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2DateParseFormat=formatString</code> <br>    The default value for <code>roll</code>   can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2NewDbOnDateChange=true|false</code> <br>  </li>  <li><code>${SERVERNAME} </code> <br>    The SERVERNAME will be substituted with the content of the ASE global variable <code>@@servername</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEHOSTNAME}</code> <br>    The ASEHOSTNAME will be substituted with the output from ASE function <code>asehostname()</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEMON_HOME}</code> <br>    The ASEMON_HOME will be substituted with the installation path of AseMon.<br>  </li>  <li><code>${ASEMON_SAVE_DIR}</code> <br>    The ASEMON_SAVE_DIR will be substituted with ${ASEMON_HOME}/data or whatever the environment variable is set to.<br>  </li></ul>Example:<br><code>${ASEMON_SAVE_DIR}/xxx.${ASEHOSTNAME}.${DATE:format=yyyy-MM-dd.HH;roll=true}</code><br><br>The above example, does:<ul>  <li>H2 dbname would be '<i>asemonInstallDir</i>/data/xxx.host1.2011-05-31.21'. <br>      Every hour a new database will be created.  </li></ul></html>";
    private static final int PCS_TAB_POS_ICON = 0;
    private static final int PCS_TAB_POS_TAB_NAME = 1;
    private static final int PCS_TAB_POS_POSTPONE = 2;
    private static final int PCS_TAB_POS_STORE_PCS = 3;
    private static final int PCS_TAB_POS_STORE_ABS = 4;
    private static final int PCS_TAB_POS_STORE_DIFF = 5;
    private static final int PCS_TAB_POS_STORE_RATE = 6;
    private static final int PCS_TAB_POS_LONG_DESC = 7;
    private static final int PCS_TAB_POS_CM_NAME = 8;
    private static final int PCS_TAB_POS_MAX = 9;
    private static final Color PCS_TAB_PCS_COL_BG = new Color(240, 240, 240);

    public static Connection showAseOnlyConnectionDialog(Frame owner) {
        ConnectionDialog connDialog = new ConnectionDialog(null, false, true, false, false, false, false);
        connDialog.setVisible(true);
        connDialog.dispose();
        int connType = connDialog.getConnectionType();
        if (connType == 0) {
            return null;
        }
        if (connType == 1) {
            return connDialog.getAseConn();
        }
        return null;
    }

    public ConnectionDialog(Frame owner) {
        this(owner, true, true, true, true, true, true);
    }

    public ConnectionDialog(Frame owner, boolean checkAseCfg, boolean showAseTab, boolean showAseOptions, boolean showHostmonTab, boolean showPcsTab, boolean showOfflineTab) {
        super(owner, "Connect", true);
        this._owner = owner;
        if (owner == null) {
            this._useCmForPcsTable = false;
        }
        this._checkAseCfg = checkAseCfg;
        this._showAseTab = showAseTab;
        this._showAseOptions = showAseOptions;
        this._showHostmonTab = showHostmonTab;
        this._showPcsTab = showPcsTab;
        this._showOfflineTab = showOfflineTab;
        this.initComponents();
        this.pack();
        Dimension size = this.getPreferredSize();
        size.width = 480;
        this.setSize(size);
        this.toggleCounterStorageTab();
        this.toggleHostmonTab();
        this.setLocationRelativeTo(owner);
        this.getSavedWindowProps();
        this.setFocus();
    }

    public int getConnectionType() {
        return this._connectionType;
    }

    public Connection getAseConn() {
        return this._aseConn;
    }

    public SshConnection getSshConn() {
        return this._sshConn;
    }

    public Connection getOfflineConn() {
        return this._offlineConn;
    }

    public void setAseUsername(String username) {
        this._aseUser_txt.setText(username);
    }

    public void setAsePassword(String passwd) {
        this._asePasswd_txt.setText(passwd);
    }

    public void setAseServer(String server) throws Exception {
        if (server == null) {
            return;
        }
        if (server.indexOf(":") >= 0) {
            String[] sa = server.split(":");
            String host = sa[0];
            String port = sa[1];
            if (!AseConnectionFactory.isHostPortStrValid(server)) {
                throw new Exception("Problems the server name '" + server + "'. " + AseConnectionFactory.isHostPortStrValidReason(server));
            }
            this._aseHost_txt.setText(host);
            this._asePort_txt.setText(port);
        } else {
            String str = AseConnectionFactory.resolvInterfaceEntry(server);
            if (str == null) {
                throw new Exception("ASE Server name '" + server + "' was not part of the known ASE server's.");
            }
            this._aseServer_cbx.setSelectedItem(server);
        }
    }

    public String getAseUsername() {
        return this._aseUser_txt.getText();
    }

    public String getAsePassword() {
        return this._asePasswd_txt.getText();
    }

    public String getAseServer() {
        return (String)this._aseServer_cbx.getSelectedItem();
    }

    public void setSshUsername(String username) {
        this._hostmonUser_txt.setText(username);
    }

    public void setSshPassword(String password) {
        this._hostmonPasswd_txt.setText(password);
    }

    public void setSshHostname(String hostname) {
        this._hostmonHost_txt.setText(hostname);
    }

    public void setSshPort(String portStr) {
        this._hostmonPort_txt.setText(portStr);
    }

    public String getSshUsername() {
        return this._hostmonUser_txt.getText();
    }

    public String getSshPassword() {
        return this._hostmonPasswd_txt.getText();
    }

    public String getSshHostname() {
        return this._hostmonHost_txt.getText();
    }

    public String getSshPortStr() {
        return this._hostmonPort_txt.getText();
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, wrap 1", "", ""));
        String aseTabTip = "Connect to an ASE to monitor performance.";
        String hostmonTabTip = "Connect to Operating System host machine where ASE is hosted to monitor IO and or CPU performance.";
        String pcsTabTip = "In GUI mode save Data Counter to a Storage, which can be view later by the 'offline' mode.";
        String offlineTabTip = "<html>Connect to a 'offline' Counter Storage where AseMon has stored counter data.<br>AseMon will switch to 'offline' mode and just reads data from the Counter Storage.<br></html>";
        this._tab = new JTabbedPane();
        this._tab.addTab("ASE", null, this.createTabAse(), aseTabTip);
        this._tab.addTab("Host Monitor", null, this.createTabHostmon(), hostmonTabTip);
        this._tab.addTab("Counter Storage", null, this.createTabPcs(), pcsTabTip);
        this._tab.addTab("Offline Connect", null, this.createTabOffline(), offlineTabTip);
        if (!this._showAseTab) {
            this._tab.setEnabledAt(0, false);
        }
        if (!this._showHostmonTab) {
            this._tab.setEnabledAt(1, false);
        }
        if (!this._showPcsTab) {
            this._tab.setEnabledAt(2, false);
        }
        if (!this._showOfflineTab) {
            this._tab.setEnabledAt(3, false);
        }
        for (int t = 0; t < this._tab.getTabCount(); ++t) {
            if (!this._tab.isEnabledAt(t)) continue;
            this._tab.setSelectedIndex(t);
            break;
        }
        panel.add((Component)this._tab, "height 100%, grow, push, wrap");
        panel.add((Component)this.createOkCancelPanel(), "bottom, right");
        this._tab.addChangeListener(this);
        this.loadProps();
        this.setContentPane(panel);
    }

    private JPanel createTabAse() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("wrap 1", "grow", ""));
        panel.add((Component)this.createAseUserPasswdPanel(), "grow");
        panel.add((Component)this.createAseServerPanel(), "grow");
        if (this._showAseOptions) {
            panel.add((Component)this.createAseOptionsPanel(), "grow");
        }
        return panel;
    }

    private JPanel createTabHostmon() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("wrap 1", "grow", ""));
        panel.add((Component)this.createHostmonUserPasswdPanel(), "grow");
        panel.add((Component)this.createHostmonServerPanel(), "grow");
        panel.add((Component)this.createHostmonInfoPanel(), "grow");
        return panel;
    }

    private JPanel createTabPcs() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("wrap 1", "grow", ""));
        panel.add((Component)this.createPcsJdbcPanel(), "grow, hidemode 3");
        panel.add((Component)this.createPcsTablePanel(), "grow");
        return panel;
    }

    private JPanel createTabOffline() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("wrap 1", "grow", ""));
        panel.add((Component)this.createOfflineJdbcPanel(), "grow");
        return panel;
    }

    private JPanel createAseUserPasswdPanel() {
        JPanel panel = SwingUtils.createPanel("User information", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "", ""));
        this._asePasswd_txt = _logger.isDebugEnabled() ? new JTextField() : new JPasswordField();
        this._aseUser_lbl.setToolTipText("User name to use when logging in to the below ASE Server.");
        this._aseUser_txt.setToolTipText("User name to use when logging in to the below ASE Server.");
        this._asePasswd_lbl.setToolTipText("Password to use when logging in to the below ASE Server");
        this._asePasswd_txt.setToolTipText("Password to use when logging in to the below ASE Server");
        this._aseOptionSavePwd_chk.setToolTipText("Save the password in the configuration file, and yes it's encrypted");
        panel.add((Component)this._aseLoginIcon, "");
        panel.add((Component)this._aseLoginHelp, "wmin 100, push, grow");
        panel.add((Component)this._aseUser_lbl, "");
        panel.add((Component)this._aseUser_txt, "push, grow");
        panel.add((Component)this._asePasswd_lbl, "");
        panel.add((Component)this._asePasswd_txt, "push, grow");
        panel.add((Component)this._aseOptionSavePwd_chk, "skip");
        this._asePasswd_txt.addActionListener(this);
        return panel;
    }

    private JPanel createAseServerPanel() {
        JPanel panel = SwingUtils.createPanel("Specify the server to connect to", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "", ""));
        this.refreshServers();
        String urlExample = "URL Example: jdbc:sybase:Tds:host1:port1[,server2:port2,...,serverN:portN][/mydb][?&OPT1=1024&OPT2=true&OPT3=some str]";
        this._aseIfile_lbl.setToolTipText("Directory Service file (sql.ini or interfaces) to use for resolving ASE name into hostname and port number");
        this._aseIfile_txt.setToolTipText("Directory Service file (sql.ini or interfaces) to use for resolving ASE name into hostname and port number");
        this._aseIfile_but.setToolTipText("Open a File Dialog to locate a Directory Service file.");
        this._aseServer_lbl.setToolTipText("Name of the ASE you are connecting to");
        this._aseServer_cbx.setToolTipText("Name of the ASE you are connecting to");
        this._aseHost_lbl.setToolTipText("<html>Hostname or IP address of the ASE you are connecting to<br>Syntax: host1[,host2,...]</html>");
        this._aseHost_txt.setToolTipText("<html>Hostname or IP address of the ASE you are connecting to<br>Syntax: host1[,host2,...]</html>");
        this._asePort_lbl.setToolTipText("<html>Port number of the ASE you are connecting to<br>Syntax: port1[,port2,...]</html>");
        this._asePort_txt.setToolTipText("<html>Port number of the ASE you are connecting to<br>Syntax: port1[,port2,...]</html>");
        this._aseOptions_lbl.setToolTipText("<html>JConnect Options that can be set.<br>Syntax: OPT1=value[, OPT2=value]<br>Or press the '...' button to add enties.</html>");
        this._aseOptions_txt.setToolTipText("<html>JConnect Options that can be set.<br>Syntax: OPT1=value[, OPT2=value]<br>Or press the '...' button to add enties.</html>");
        this._aseOptions_but.setToolTipText("Open a Dialog where available options are presented.");
        this._aseMonUrl_chk.setToolTipText("<html>Actual URL used to connect the monitored server.<br>" + urlExample + "</html>");
        this._aseMonUrl_txt.setToolTipText("<html>Actual URL used to connect the monitored server.<br>" + urlExample + "</html>");
        panel.add((Component)this._aseServerIcon, "");
        panel.add((Component)this._aseServerHelp, "wmin 100, push, grow");
        panel.add((Component)this._aseIfile_lbl, "");
        panel.add((Component)this._aseIfile_txt, "push, grow, split");
        panel.add((Component)this._aseIfile_but, "wrap");
        panel.add((Component)this._aseServer_lbl, "");
        panel.add((Component)this._aseServer_cbx, "push, grow");
        panel.add((Component)this._aseHost_lbl, "");
        panel.add((Component)this._aseHost_txt, "push, grow");
        panel.add((Component)this._asePort_lbl, "");
        panel.add((Component)this._asePort_txt, "push, grow");
        panel.add((Component)this._aseOptions_lbl, "");
        panel.add((Component)this._aseOptions_txt, "push, grow, split");
        panel.add((Component)this._aseOptions_but, "wrap");
        panel.add((Component)this._aseMonUrl_chk, "");
        panel.add((Component)this._aseMonUrl_txt, "push, grow");
        this._aseMonUrl_txt.setEnabled(this._aseMonUrl_chk.isEnabled());
        this._aseServerName_lbl.setText(":");
        if (_logger.isDebugEnabled()) {
            panel.add((Component)this._aseServerName_lbl, "skip, push, grow");
        }
        AutoCompleteDecorator.decorate((JComboBox)this._aseServer_cbx);
        this._aseServer_cbx.addActionListener(this);
        this._aseOptions_txt.addActionListener(this);
        this._aseOptions_but.addActionListener(this);
        this._aseIfile_but.addActionListener(this);
        this._aseIfile_txt.addActionListener(this);
        this._aseMonUrl_chk.addActionListener(this);
        this._aseMonUrl_txt.addActionListener(this);
        this._aseHost_txt.addKeyListener(this);
        this._asePort_txt.addKeyListener(this);
        return panel;
    }

    private JPanel createAseOptionsPanel() {
        JPanel panel = SwingUtils.createPanel("Options", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 1, gap 0", "", ""));
        this._aseOptionConnOnStart_chk.setToolTipText("When AseMon starts use the above ASE and connect automatically (if the below 'Persisten Counter Storage' is enabled, it will also be used at startup)");
        this._aseOptionReConnOnFailure_chk.setToolTipText("If connection to the monitored server is lost in some way, try to reconnect to the server again automatically.");
        this._aseOptionStore_chk.setToolTipText("Store GUI Counter Data in a database (Persistent Counter Storage), which can be viewed later, connect to it from the 'offline' tab");
        this._aseHostMonitor_chk.setToolTipText("Connect to the Operating System host via SSH, to monitor IO statistics and/or CPU usage.");
        panel.add((Component)this._aseOptionConnOnStart_chk, "");
        panel.add((Component)this._aseOptionReConnOnFailure_chk, "");
        panel.add((Component)this._aseHostMonitor_chk, "");
        if (this._showPcsTab) {
            panel.add((Component)this._aseOptionStore_chk, "");
        }
        if (this._showHostmonTab) {
            panel.add((Component)this._aseHostMonitor_chk, "");
        }
        this._aseOptionStore_chk.addActionListener(this);
        this._aseHostMonitor_chk.addActionListener(this);
        return panel;
    }

    private JPanel createHostmonUserPasswdPanel() {
        JPanel panel = SwingUtils.createPanel("User information", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "", ""));
        this._hostmonPasswd_txt = _logger.isDebugEnabled() ? new JTextField() : new JPasswordField();
        this._hostmonUser_lbl.setToolTipText("User name to use when logging in to the below Operating System Host.");
        this._hostmonUser_txt.setToolTipText("User name to use when logging in to the below Operating System Host.");
        this._hostmonPasswd_lbl.setToolTipText("Password to use when logging in to the below Operating System Host");
        this._hostmonPasswd_txt.setToolTipText("Password to use when logging in to the below Operating System Host");
        this._hostmonOptionSavePwd_chk.setToolTipText("Save the password in the configuration file, and yes it's encrypted");
        panel.add((Component)this._hostmonLoginIcon, "");
        panel.add((Component)this._hostmonLoginHelp, "wmin 100, push, grow");
        panel.add((Component)this._hostmonUser_lbl, "");
        panel.add((Component)this._hostmonUser_txt, "push, grow");
        panel.add((Component)this._hostmonPasswd_lbl, "");
        panel.add((Component)this._hostmonPasswd_txt, "push, grow");
        panel.add((Component)this._hostmonOptionSavePwd_chk, "skip");
        this._hostmonUser_txt.addKeyListener(this);
        this._hostmonPasswd_txt.addKeyListener(this);
        this._hostmonOptionSavePwd_chk.addActionListener(this);
        return panel;
    }

    private JPanel createHostmonServerPanel() {
        JPanel panel = SwingUtils.createPanel("Specify the server to connect to", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "", ""));
        this._hostmonHost_lbl.setToolTipText("<html>Hostname or IP address of the OS Host you are connecting to</html>");
        this._hostmonHost_txt.setToolTipText("<html>Hostname or IP address of the OS Host you are connecting to</html>");
        this._hostmonPort_lbl.setToolTipText("<html>Port number of the SSH server you are connecting to</html>");
        this._hostmonPort_txt.setToolTipText("<html>Port number of the SSH server you are connecting to</html>");
        panel.add((Component)this._hostmonServerIcon, "");
        panel.add((Component)this._hostmonServerHelp, "wmin 100, push, grow");
        panel.add((Component)this._hostmonHost_lbl, "");
        panel.add((Component)this._hostmonHost_txt, "push, grow");
        panel.add((Component)this._hostmonPort_lbl, "");
        panel.add((Component)this._hostmonPort_txt, "push, grow");
        this._hostmonServerName_lbl.setText(":");
        if (_logger.isDebugEnabled()) {
            panel.add((Component)this._hostmonServerName_lbl, "skip, push, grow");
        }
        this._hostmonHost_txt.addKeyListener(this);
        this._hostmonPort_txt.addKeyListener(this);
        return panel;
    }

    private JPanel createHostmonInfoPanel() {
        String s;
        JPanel panel = SwingUtils.createPanel("Basic Host Monitoring Information", true);
        panel.setLayout((LayoutManager)new MigLayout("wrap 1, gap 0", "", ""));
        String t = s = "Hover over the different subsection and the ToolTip manager will display more information about the various topics.";
        MultiLineLabel txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        s = "<b>- What is this Basic Operating System Monitoring.</b>";
        t = "If you want to monitor the Operating System with some basic command, this is one way you can do it.<br>And also if you are storing the Performance Counters in a Persistent storage, the OS Monitoring is in sync with <br>the Performance Counters from the monitored ASE Server, which makes it easier to correlate the various metrics.";
        txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        s = "<b>- What OS Monitoring Commands are supported for the moment.</b>";
        t = "The basic command which for the moment is supported is:<ul>  <li> <code> iostat </code></li>  <li> <code> vmstat </code></li>  <li> <code> mpstat </code></li></ul>If you are using <b>Veritas</b> as the Disk IO subsystem and want to sample disk statistics with <b>vxstat</b> and not iostat.<br>Make sure <b>vxstat</b> is executable and in the <b>$PATH</b> off the user that you're connecting to the Operating System with.<br>Then it will execute <b>vxstat</b> instead of iostat and use that information.";
        txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        s = "<b>- But every Operating System work slightly different.</b>";
        t = "But all Operating Systems has different layouts for the various commands. <br>For Example 'iostat' does not produce the same output on Solaris as it does on Linux. <br><br>When a connection to the OS made, It will try to identify what OS were connecting to (by using uname -a) and then use OS specific parsers. <br>This implies that a \"parser\" is implement for every OS.<br>So if you are getting errors, faulty output or that your OS is not supported, please notify me and I will try to fix it.<br>Also if you want to change the parameters/flags to the OS Commands, to get better Performance Counters, kick me and I'll fix it!<br><br>The only thing that can change by ourself is the OS Commands sleep interval<br>This is done by adding the below information to the configuration file. (asemon.properties)<ul>  <li> for iostat: <code>MonitorIoSolaris.sleep=5</code></li>  <li> for mpstat: <code>MonitorVmstatAix.sleep=5</code></li>  <li> for vmstat: <code>MonitorMpstatLinux.sleep=5</code></li></ul>You can probably fill in the blanks... <code>[Monitor][Subsystem][Osname].sleep=[samplePeriodToTheCommand]</code><br><br>If you need to debug or check what the OS Command is sending, you can add the following to the Configuration file:<br><code>log4j.logger.asemon.hostmon.HostMonitor=DEBUG</code><br><br>Or you can use the 'log viewer' to change the 'log level' while AseMon is still running: <br>MainMenu->View->Open Log Window..., then Press 'Set log level'... locate asemon.hostmon.HostMonitor and change it.";
        txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        s = "<b>- The big picture of how it's implememted.</b>";
        t = "The way it's implemented:<br><ul>  <li> Start a background task that executes for instance 'iostat' every 2 seconds (iostat -xdz 2) or whatever sample period (see section above).</li>  <li> Parse the output from the OS Command and store it in a intermediate in-memory storage.</li>  <li> Then when AseMon think it's time to sample some Performance Counters (depends on AseMon's sample time)<br>       The subsystem does an <b>average</b> calculation on the intermediate stored values and then resets the intermidiate storage so that new samples from the OS Command can be sampled. <br>  <li> Now the Performance Counters or values are available to view in AseMon.</li></ul>For 'vmstat' I choose a slightly different approach, this since 'vmstat' is only delivering one row per vmstats-sample period. <br>So in this case I do <b>not</b> do a summary or average calculation.<br><br>Instead I simply displays <b>all</b> the sampled records I have received from the command with a 'timestamp' column to indicate when it was received.<br>If you instead want to have some kind of average or summary, please notify me and explain...";
        txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        s = "<b>- What to expect in upcomming releases of AseMon.</b>";
        t = "In current release there are limited support for User Defined OS Monitoring, which you can add to the Configuration file<br>In future release, the plan is to add a <b>Wizard</b> where you can add User Defined Host Monitor Counters and maybe support for diff/rate counters as well.<br><br>With a Used Defined OS Monitoring you could for example Monitor Outputs from <b>your</b> Application Server or in whatever way you think is's usable.<br><br>Below is an example of how a Used Defined Counter could look like, but you might find examples in the Configuration file...<br><pre>hostmon.udc.TestGoransLs.displayName                   = List of files in $HOME<BR>hostmon.udc.TestGoransLs.description                   = This would be the tooltip help on the Tab for: List of files in $HOME<BR>hostmon.udc.TestGoransLs.osCommand                     = ls -Fl | egrep -v '^d'<BR>hostmon.udc.TestGoransLs.osCommand.isStreaming         = false<BR>hostmon.udc.TestGoransLs.addStrColumn.umode            = {length=10, sqlColumnNumber=1,  parseColumnNumber=1,  isNullable=false, description=xxx}<BR>hostmon.udc.TestGoransLs.addIntColumn.files            = {           sqlColumnNumber=2,  parseColumnNumber=2,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addStrColumn.owner            = {length=10, sqlColumnNumber=3,  parseColumnNumber=3,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addStrColumn.group            = {length=10, sqlColumnNumber=4,  parseColumnNumber=4,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addIntColumn.sizeInBytes      = {           sqlColumnNumber=5,  parseColumnNumber=5,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addStrColumn.date             = {length=10, sqlColumnNumber=6,  parseColumnNumber=6,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addStrColumn.time             = {length=5,  sqlColumnNumber=7,  parseColumnNumber=7,  isNullable=true,  description=xxx}<BR>hostmon.udc.TestGoransLs.addStrColumn.filename         = {length=99, sqlColumnNumber=8,  parseColumnNumber=8,  isNullable=true,  description=xxx}<BR></pre>Some Graph properties can also be added, they are using the same notation as for 'SQL Used Defined Counters'.";
        txt = new MultiLineLabel("<html>" + s + "</html>");
        txt.setToolTipText("<html>" + t + "</html>");
        panel.add((Component)txt, "wmin 100, push, grow, wrap 10");
        return panel;
    }

    private JPanel createPcsJdbcPanel() {
        JPanel panel = SwingUtils.createPanel("Counter Storage", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._pcsPanel = panel;
        this._pcsHelp.setText("What Counter Data should be stored in the Persistent Counter Storage\nIf this is enabled counters that are sampled via the GUI would be stored in a database, this so we can view them later... One good thing about this is that we can view 'baseline' for different configurations or sample sessions\nYou can also create an offline session and start in no-gui mode instead.");
        this._pcsWriter_lbl.setToolTipText("Persistent Counter Storage Implementation(s) that is responsible for Storing the Counter Data.");
        this._pcsWriter_cbx.setToolTipText("Persistent Counter Storage Implementation(s) that is responsible for Storing the Counter Data.");
        this._pcsJdbcDriver_lbl.setToolTipText("JDBC drivername to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsJdbcDriver_cbx.setToolTipText("JDBC drivername to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsJdbcUrl_lbl.setToolTipText(JDBC_URL_TOOLTIP);
        this._pcsJdbcUrl_cbx.setToolTipText(JDBC_URL_TOOLTIP);
        this._pcsJdbcUrl_but.setToolTipText("Open a File chooser dialog to get a filename, for some templates values are replaced");
        this._pcsJdbcUsername_lbl.setToolTipText("User name to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsJdbcUsername_txt.setToolTipText("User name to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsJdbcPassword_lbl.setToolTipText("Password to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsJdbcPassword_txt.setToolTipText("Password to be used by the Persistent Counter Storage to save Counter Data");
        this._pcsTestConn_but.setToolTipText("Make a test connection to the above JDBC datastore");
        this._pcsH2Option_startH2NetworkServer_chk.setToolTipText("Start the H2 database engine in 'server' mode, so we can connect to the server while the PCS is storing information...");
        panel.add((Component)this._pcsIcon, "");
        panel.add((Component)this._pcsHelp, "wmin 100, push, grow, wrap 10");
        panel.add((Component)this._pcsWriter_lbl, "");
        panel.add((Component)this._pcsWriter_cbx, "push, grow, wrap");
        panel.add((Component)this._pcsJdbcDriver_lbl, "");
        panel.add((Component)this._pcsJdbcDriver_cbx, "push, grow, wrap");
        panel.add((Component)this._pcsJdbcUrl_lbl, "");
        panel.add((Component)this._pcsJdbcUrl_cbx, "push, grow, split");
        panel.add((Component)this._pcsJdbcUrl_but, "wrap");
        panel.add((Component)this._pcsJdbcUsername_lbl, "");
        panel.add((Component)this._pcsJdbcUsername_txt, "push, grow, wrap");
        panel.add((Component)this._pcsJdbcPassword_lbl, "");
        panel.add((Component)this._pcsJdbcPassword_txt, "push, grow, wrap");
        panel.add((Component)this._pcsH2Option_startH2NetworkServer_chk, "skip, hidemode 3, wrap");
        panel.add((Component)this._pcsTestConn_but, "skip, right, wrap");
        this._pcsWriter_cbx.setEditable(true);
        this._pcsJdbcDriver_cbx.setEditable(true);
        this._pcsJdbcUrl_cbx.setEditable(true);
        this._pcsWriter_cbx.addItem("asemon.pcs.PersistWriterJdbc");
        this._pcsJdbcDriver_cbx.addItem("org.h2.Driver");
        this._pcsJdbcDriver_cbx.addItem(AseConnectionFactory.getDriver());
        this._pcsJdbcUrl_cbx.addItem("jdbc:h2:file:[<path>]<dbname>");
        this._pcsJdbcUrl_cbx.addItem("jdbc:h2:file:${ASEMON_SAVE_DIR}/${ASEHOSTNAME}_${DATE}");
        this._pcsJdbcUrl_cbx.addItem("jdbc:h2:tcp://<host>[:<port>]/<dbname>");
        this._pcsJdbcUrl_cbx.addItem("jdbc:h2:ssl://<host>[:<port>]/<dbname>");
        this._pcsJdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>");
        this._pcsJdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>[/<dbname>]");
        this._pcsTestConn_but.addActionListener(this);
        this._pcsJdbcUrl_cbx.getEditor().getEditorComponent().addKeyListener(this);
        this._pcsJdbcUrl_cbx.addActionListener(this);
        this._pcsJdbcUrl_but.addActionListener(this);
        this._pcsJdbcDriver_cbx.addActionListener(this);
        return panel;
    }

    private JPanel createPcsTablePanel() {
        JPanel panel = SwingUtils.createPanel("What Counter Data should be Persisted", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._pcsSessionTable = new JXTable(){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (column >= 3 && column <= 6) {
                    c.setBackground(PCS_TAB_PCS_COL_BG);
                    if (column >= 4 && column <= 6 || row == 0) {
                        c.setEnabled(this.isCellEditable(row, column));
                    }
                }
                return c;
            }
        };
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(9);
        tabHead.set(2, "Postpone");
        tabHead.set(3, "Sample");
        tabHead.set(4, "Abs");
        tabHead.set(5, "Diff");
        tabHead.set(6, "Rate");
        tabHead.set(0, "Icon");
        tabHead.set(1, "Short Desc");
        tabHead.set(8, "CM Name");
        tabHead.set(7, "Long Description");
        Vector<Vector<Object>> tabData = this.populatePcsTable();
        DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 2) {
                    return Integer.class;
                }
                if (column == 3) {
                    return Boolean.class;
                }
                if (column == 4) {
                    return Boolean.class;
                }
                if (column == 5) {
                    return Boolean.class;
                }
                if (column == 6) {
                    return Boolean.class;
                }
                if (column == 0) {
                    return Icon.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (row == 0) {
                    return false;
                }
                if (col == 2) {
                    return true;
                }
                if (col == 3) {
                    return true;
                }
                if (col <= 6) {
                    boolean storePcs = (Boolean)this.getValueAt(row, 3);
                    String tabName = (String)this.getValueAt(row, 1);
                    CountersModel cm = GetCounters.getCmByDisplayName(tabName);
                    if (cm != null) {
                        if (col == 4) {
                            return storePcs && cm.isPersistCountersAbsEditable();
                        }
                        if (col == 5) {
                            return storePcs && cm.isPersistCountersDiffEditable();
                        }
                        if (col == 6) {
                            return storePcs && cm.isPersistCountersRateEditable();
                        }
                    }
                }
                return false;
            }
        };
        defaultTabModel.addTableModelListener(this);
        this._pcsSessionTable.setModel((TableModel)defaultTabModel);
        this._pcsSessionTable.setShowGrid(false);
        this._pcsSessionTable.setSortable(true);
        this._pcsSessionTable.setSelectionMode(0);
        this._pcsSessionTable.setAutoResizeMode(0);
        this._pcsSessionTable.packAll();
        this._pcsSessionTable.setSortable(true);
        this._pcsSessionTable.setColumnControlVisible(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._pcsSessionTable);
        panel.add((Component)jScrollPane, "push, grow, height 100%, wrap");
        panel.add((Component)this._pcsTabSelectAll_but, "split");
        panel.add((Component)this._pcsTabDeSelectAll_but, "split");
        panel.add((Component)this._pcsTabTemplate_but, "");
        this._pcsTabSelectAll_but.addActionListener(this);
        this._pcsTabDeSelectAll_but.addActionListener(this);
        this._pcsTabTemplate_but.addActionListener(this);
        this._pcsTabTemplate_but.setToolTipText("Use current setting of the tabs as a template.");
        return panel;
    }

    private JPanel createOfflineJdbcPanel() {
        JPanel panel = SwingUtils.createPanel("Counter Storage Read", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._offlinePanel = panel;
        this._offlineHelp.setText("Read Stored Counter Data from an offline storage\nThe Saved Counter Data can be stored in a database eather by the GUI or NO-GUI mode.\nOne tip is to store Counter Data for different configurations or test suites, this so we can view the 'baseline' for different configurations or sample sessions\n");
        this._offlineJdbcDriver_lbl.setToolTipText("JDBC drivername to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineJdbcDriver_cbx.setToolTipText("JDBC drivername to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineJdbcUrl_lbl.setToolTipText("URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver");
        this._offlineJdbcUrl_cbx.setToolTipText("URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver");
        this._offlineJdbcUrl_but.setToolTipText("Open a File chooser dialog to get a filename, for some templates values are replaced");
        this._offlineJdbcUsername_lbl.setToolTipText("User name to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineJdbcUsername_txt.setToolTipText("User name to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineJdbcPassword_lbl.setToolTipText("Password to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineJdbcPassword_txt.setToolTipText("Password to be used by the Persistent Counter Storage to READ Counter Data");
        this._offlineTestConn_but.setToolTipText("Make a test connection to the above JDBC datastore");
        this._offlineCheckForNewSessions_chk.setToolTipText("<html>If asemon still collects data into the offline database, go and check for new samples.<br>Using this option we can run asemon-nogui in offline mode while the GUI can read from the shared database.</html>");
        this._offlineH2Option_startH2NwSrv_chk.setToolTipText("<html>Start the H2 database engine in 'server' mode.<br>This enables other asemon client to be connected to the same database.<br>Or you can use any third party product database viewer to read the content at the same time.</html>");
        panel.add((Component)this._offlineIcon, "");
        panel.add((Component)this._offlineHelp, "wmin 100, push, grow, wrap 15");
        panel.add((Component)this._offlineJdbcDriver_lbl, "");
        panel.add((Component)this._offlineJdbcDriver_cbx, "push, grow, wrap");
        panel.add((Component)this._offlineJdbcUrl_lbl, "");
        panel.add((Component)this._offlineJdbcUrl_cbx, "push, grow, split");
        panel.add((Component)this._offlineJdbcUrl_but, "wrap");
        panel.add((Component)this._offlineJdbcUsername_lbl, "");
        panel.add((Component)this._offlineJdbcUsername_txt, "push, grow, wrap");
        panel.add((Component)this._offlineJdbcPassword_lbl, "");
        panel.add((Component)this._offlineJdbcPassword_txt, "push, grow, wrap");
        panel.add((Component)this._offlineCheckForNewSessions_chk, "skip, wrap");
        panel.add((Component)this._offlineH2Option_startH2NwSrv_chk, "skip, hidemode 3, wrap");
        panel.add((Component)this._offlineTestConn_but, "skip, right, wrap");
        this._offlineJdbcDriver_cbx.setEditable(true);
        this._offlineJdbcUrl_cbx.setEditable(true);
        this._offlineJdbcDriver_cbx.addItem("org.h2.Driver");
        this._offlineJdbcDriver_cbx.addItem(AseConnectionFactory.getDriver());
        this._offlineJdbcUrl_cbx.addItem("jdbc:h2:file:[<path>]<dbname>;IFEXISTS=TRUE");
        this._offlineJdbcUrl_cbx.addItem("jdbc:h2:zip:<zipFileName>!/<dbname>");
        this._offlineJdbcUrl_cbx.addItem("jdbc:h2:tcp://<host>[:<port>]/<dbname>");
        this._offlineJdbcUrl_cbx.addItem("jdbc:h2:ssl://<host>[:<port>]/<dbname>");
        this._offlineJdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>");
        this._offlineJdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>[/<dbname>]");
        this._offlineJdbcDriver_cbx.addActionListener(this);
        this._offlineTestConn_but.addActionListener(this);
        this._offlineJdbcUrl_cbx.getEditor().getEditorComponent().addKeyListener(this);
        this._offlineJdbcUrl_cbx.addActionListener(this);
        this._offlineJdbcUrl_but.addActionListener(this);
        return panel;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._ok_lbl.setForeground(Color.RED);
        this._ok_lbl.setFont(this._ok_lbl.getFont().deriveFont(1));
        this._ok_lbl.setText("");
        panel.add((Component)this._ok_lbl, "left");
        panel.add((Component)this._ok, "tag ok, right");
        panel.add((Component)this._cancel, "tag cancel");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        return panel;
    }

    private Vector<Vector<Object>> populatePcsTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        Vector<Object> row = new Vector<Object>();
        if (this._useCmForPcsTable) {
            for (CountersModel cm : GetCounters.getCmList()) {
                if (cm == null) continue;
                row = new Vector();
                row.setSize(9);
                row.set(2, new Integer(cm.getPostponeTime()));
                row.set(3, new Boolean(cm.isPersistCountersEnabled() || cm.isBackgroundDataPollingEnabled()));
                row.set(4, new Boolean(cm.isPersistCountersAbsEnabled()));
                row.set(5, new Boolean(cm.isPersistCountersDiffEnabled()));
                row.set(6, new Boolean(cm.isPersistCountersRateEnabled()));
                row.set(1, cm.getDisplayName());
                row.set(8, cm.getName());
                row.set(0, cm.getTabPanel() == null ? null : cm.getTabPanel().getIcon());
                row.set(7, cm.getDescription().replaceAll("\\<.*?\\>", ""));
                tab.add(row);
                if (!cm.getName().equals("CMsummary")) continue;
                row.set(0, SwingUtils.readImageIcon(Version.class, "images/summary_tab.png"));
            }
        } else {
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(1, "Summary");
            row.set(8, "cmSummary");
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_summary_activity.png"));
            row.set(7, "All the fields on the left hand side of the graphs.");
            tab.add(row);
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(1, "CPU Usage");
            row.set(8, "cmCpu");
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_engine_activity.png"));
            row.set(7, "bla bla bla... asfdha dkjfg askj gfakj gfkajgshd fagsakgdfakdfhs kjfhgoiqay edatfshjghv kfdsjhgaks dfajhdfskjdf glkash df.");
            tab.add(row);
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(1, "Device Usage");
            row.set(8, "cmDevice");
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_device_activity.png"));
            row.set(7, "wwwwwwwwwwwwwwww wwww ttttt uuuuuu bla bla bla... hhhhhhhhhhhhh  kkkkkkkkkkkk yyyyyyy ssssssssssssssssss ggggggggggggg w wwww aaaaa.");
            tab.add(row);
            for (int i = 0; i < 40; ++i) {
                row = new Vector();
                row.setSize(9);
                row.set(2, new Integer(0));
                row.set(3, new Boolean(true));
                row.set(4, new Boolean(true));
                row.set(5, new Boolean(true));
                row.set(6, new Boolean(true));
                row.set(1, "Dummy Tab " + i);
                row.set(8, "cmDummy" + i);
                row.set(0, SwingUtils.readImageIcon(Version.class, "images/ud_counter_activity.png"));
                row.set(7, UUID.randomUUID().toString() + " : " + UUID.randomUUID().toString());
                tab.add(row);
            }
        }
        return tab;
    }

    private void toggleCounterStorageTab() {
        if (this._showPcsTab) {
            if (this._aseOptionStore_chk.isSelected()) {
                this._tab.setEnabledAt(2, true);
            } else {
                this._tab.setEnabledAt(2, false);
            }
        }
    }

    private void toggleHostmonTab() {
        if (this._showHostmonTab) {
            if (this._aseHostMonitor_chk.isSelected()) {
                this._tab.setEnabledAt(1, true);
            } else {
                this._tab.setEnabledAt(1, false);
            }
        }
    }

    private void validateContents() {
        String problem = "";
        if (this._tab.getSelectedIndex() == 3) {
            String url = this._offlineJdbcUrl_cbx.getEditor().getItem().toString();
            if (url.matches(".*<.*>.*")) {
                problem = "Replace the <template> with something.";
            }
            if (url.matches(".*\\[.*\\].*")) {
                problem = "Replace the [template] with something or delete it.";
            }
        } else if (this._aseOptionStore_chk.isSelected()) {
            String url = this._pcsJdbcUrl_cbx.getEditor().getItem().toString();
            if (url.matches(".*<.*>.*")) {
                problem = "Replace the <template> with something.";
            }
            if (url.matches(".*\\[.*\\].*")) {
                problem = "Replace the [template] with something or delete it.";
            }
            int rows = 0;
            TableModel tm = this._pcsSessionTable.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 3)).booleanValue()) continue;
                ++rows;
            }
            if (rows == 0 && problem.equals("")) {
                problem = "Atleast one session needs to be checked.";
            }
        } else if (this._aseHostMonitor_chk.isSelected()) {
            String username = this._hostmonUser_txt.getText();
            String password = this._hostmonPasswd_txt.getText();
            String hostname = this._hostmonHost_txt.getText();
            String portStr = this._hostmonPort_txt.getText();
            try {
                Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                problem = "SSH Port number must be an integer";
            }
            if (username.trim().equals("")) {
                problem = "SSH username must be specified";
            }
            if (password.trim().equals("")) {
                problem = "SSH password must be specified";
            }
            if (hostname.trim().equals("")) {
                problem = "SSH hostname must be specified";
            }
        } else {
            String[] ports;
            String[] hosts = StringUtil.commaStrToArray(this._aseHost_txt.getText());
            if (hosts.length != (ports = StringUtil.commaStrToArray(this._asePort_txt.getText())).length) {
                problem = "Host has " + hosts.length + " entries, Port has " + ports.length + " entries. They must match";
            }
        }
        this._ok_lbl.setText(problem);
        this._pcsTestConn_lbl.setText(problem);
        this._tab.setForegroundAt(2, this._tab.getForegroundAt(0));
        this._tab.setForegroundAt(3, this._tab.getForegroundAt(0));
        if (problem.equals("")) {
            this._ok.setEnabled(true);
            this._offlineTestConn_but.setEnabled(true);
            this._pcsTestConn_but.setEnabled(true);
        } else {
            this._ok.setEnabled(false);
            this._offlineTestConn_but.setEnabled(false);
            this._pcsTestConn_but.setEnabled(false);
            if (this._tab.getSelectedIndex() == 3) {
                this._tab.setForegroundAt(3, Color.RED);
            } else {
                this._tab.setForegroundAt(2, Color.RED);
            }
        }
    }

    private void refreshServers() {
        this._aseServer_cbx.refresh();
        this._aseHost_txt.setText("");
        this._asePort_txt.setText("");
        this._aseOptions_txt.setText("");
    }

    private void loadNewInterfaces(String file) {
        if (file == null || file != null && file.trim().equals("")) {
            _logger.debug((Object)"loadNewInterfaces(): The passed interfaces file was null empty string.");
            return;
        }
        try {
            File f = new File(file);
            if (!f.exists()) {
                String interfacesFileName = "%SYBASE%\\ini\\sql.ini";
                if (PlatformUtils.getCurrentPlattform() != 0) {
                    interfacesFileName = "$SYBASE/interfaces";
                }
                SwingUtils.showWarnMessage(this, "Name Service file dosn't exists", "The Name Service file '" + file + "' doesn't exists.\n" + "\n" + "Name Service file is used to lookup a Sybase Server into a hostname and port number.\n" + "The Name Service file is normally named '" + interfacesFileName + "'.", null);
                return;
            }
            AseConnectionFactory.setInterfaces(file);
            this.refreshServers();
            this._aseIfile_save = file;
        }
        catch (Exception e) {
            SwingUtils.showErrorMessage(this, "Problems setting new Name Service file", "Problems setting the Name Service file '" + file + "'." + "\n\n" + e.getMessage(), e);
            this._aseIfile_txt.setText(this._aseIfile_save);
        }
    }

    private void setFocus() {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                if (ConnectionDialog.this._tab.getSelectedIndex() == 0) {
                    if (ConnectionDialog.this._aseUser_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._aseUser_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._asePasswd_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._asePasswd_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._aseHost_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._aseHost_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._asePort_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._asePort_txt.requestFocus();
                        return;
                    }
                } else if (ConnectionDialog.this._tab.getSelectedIndex() == 1) {
                    if (ConnectionDialog.this._hostmonUser_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._hostmonUser_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._hostmonPasswd_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._hostmonPasswd_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._hostmonHost_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._hostmonHost_txt.requestFocus();
                        return;
                    }
                    if (ConnectionDialog.this._hostmonPort_txt.getText().trim().equals("")) {
                        ConnectionDialog.this._hostmonPort_txt.requestFocus();
                        return;
                    }
                }
                ConnectionDialog.this._ok.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    public static boolean checkReconnectVersion(Connection conn) {
        if (MonTablesDictionary.hasInstance()) {
            MonTablesDictionary mtd = MonTablesDictionary.getInstance();
            int currentVersion = mtd.aseVersionNum;
            int newVersion = AseConnectionUtils.getAseVersionNumber(conn);
            if (currentVersion != newVersion) {
                String msg = "<html>Connecting to a different ASE Version, This is NOT supported now... (previousVersion='" + AseConnectionUtils.versionIntToStr(currentVersion) + "', connectToVersion='" + AseConnectionUtils.versionIntToStr(newVersion) + "'). <br>" + "To connect to another ASE Version, you need to restart the application." + "</html>";
                if (Asemon.hasGUI()) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, "asemon - connect check", 2);
                }
                _logger.warn((Object)msg);
                return false;
            }
            _logger.info((Object)("Re-connected to the same ASE Version as priviously. Version is '" + currentVersion + "'."));
            return true;
        }
        return true;
    }

    private boolean aseConnect() {
        Map<String, String> options;
        if (this._aseMonUrl_chk.isSelected()) {
            String username = this._aseUser_txt.getText();
            String password = this._asePasswd_txt.getText();
            String rawUrl = this._aseMonUrl_txt.getText();
            Properties props = new Properties();
            props.put("user", username);
            props.put("password", password);
            try {
                _logger.info((Object)("Connecting to ASE using RAW-URL username='" + username + "', URL='" + rawUrl + "'."));
                this._aseConn = ConnectionProgressDialog.connectWithProgressDialog(this, AseConnectionFactory.getDriver(), rawUrl, props, this._checkAseCfg, this._sshConn);
                return true;
            }
            catch (SQLException e) {
                String msg = AseConnectionUtils.showSqlExceptionMessage(this, "Problems Connecting", "Problems when connecting to the data server.", e);
                _logger.error((Object)("Problems when connecting to a ASE Server. " + msg));
                return false;
            }
            catch (Exception e) {
                SwingUtils.showErrorMessage(this, "Problems Connecting", "Problems when connecting to the data server.\n\n" + e.getMessage(), e);
                return false;
            }
        }
        String portStr = this._asePort_txt.getText();
        String[] sa = StringUtil.commaStrToArray(portStr);
        for (int i = 0; i < sa.length; ++i) {
            try {
                Integer.parseInt(sa[i]);
                continue;
            }
            catch (NumberFormatException e) {
                SwingUtils.showErrorMessage(this, "Problem with port number", "The port number '" + sa[i] + "' is not a number.", e);
                return false;
            }
        }
        if (sa == null || sa != null && sa.length == 0) {
            SwingUtils.showErrorMessage(this, "Problem with port number", "The port number '" + portStr + "' is either missing or is not a number.", null);
            return false;
        }
        _logger.debug((Object)("Setting connection info to AseConnectionFactory appname='" + Version.getAppName() + "', user='" + this._aseUser_txt.getText() + "', password='" + this._asePasswd_txt.getText() + "', host='" + this._aseHost_txt.getText() + "', port='" + this._asePort_txt.getText() + "'."));
        AseConnectionFactory.setAppName(Version.getAppName());
        AseConnectionFactory.setHostName(Version.getVersionStr());
        AseConnectionFactory.setUser(this._aseUser_txt.getText());
        AseConnectionFactory.setPassword(this._asePasswd_txt.getText());
        AseConnectionFactory.setHostPort(this._aseHost_txt.getText(), this._asePort_txt.getText());
        if (this._aseOptions_txt.getText().trim().equals("")) {
            options = null;
            AseConnectionFactory.setProperties(options);
        } else {
            options = StringUtil.parseCommaStrToMap(this._aseOptions_txt.getText());
            AseConnectionFactory.setProperties(options);
        }
        try {
            _logger.info((Object)("Connecting to ASE '" + AseConnectionFactory.getServer() + "'.  hostPortStr='" + AseConnectionFactory.getHostPortStr() + "', user='" + AseConnectionFactory.getUser() + "'."));
            String urlStr = "jdbc:sybase:Tds:" + AseConnectionFactory.getHostPortStr();
            this._aseConn = ConnectionProgressDialog.connectWithProgressDialog(this, urlStr, this._checkAseCfg, this._sshConn);
            return true;
        }
        catch (SQLException e) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(this, "Problems Connecting", "Problems when connecting to the data server.", e);
            _logger.error((Object)("Problems when connecting to a ASE Server. " + msg));
            return false;
        }
        catch (Exception e) {
            SwingUtils.showErrorMessage(this, "Problems Connecting", "Problems when connecting to the data server.\n\n" + e.getMessage(), e);
            return false;
        }
    }

    private boolean checkForMonitorOptions() {
        MainFrame.setStatus(4, "Checking for Monitor Options...");
        boolean b = AseConnectionUtils.checkForMonitorOptions(this._aseConn, this._aseUser_txt.getText(), true, this, "enable monitoring");
        MainFrame.setStatus(1);
        return b;
    }

    private SshConnection hostmonCreateConnectionObject() {
        String username = this._hostmonUser_txt.getText();
        String password = this._hostmonPasswd_txt.getText();
        String hostname = this._hostmonHost_txt.getText();
        String portStr = this._hostmonPort_txt.getText();
        int port = 22;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            SwingUtils.showErrorMessage(this, "Problem with port number", "The port number '" + portStr + "' is not a number.", e);
            return null;
        }
        _logger.info((Object)("Creating SSH Connection-Object to hostname='" + hostname + "'.  port='" + port + "', username='" + username + "'."));
        return new SshConnection(hostname, port, username, password);
    }

    private boolean pcsConnect() {
        PersistentCounterHandler pch = null;
        try {
            Configuration pcsProps = new Configuration();
            String pcsAll = this._pcsWriter_cbx.getEditor().getItem().toString();
            pcsProps.put("PersistentCounterHandler.WriterClass", pcsAll);
            String[] pcsa = pcsAll.split(",");
            for (int i = 0; i < pcsa.length; ++i) {
                String pcs = pcsa[i].trim();
                if (!pcs.equals("asemon.pcs.PersistWriterJdbc")) continue;
                pcsProps.put("PersistWriterJdbc.jdbcDriver", this._pcsJdbcDriver_cbx.getEditor().getItem().toString());
                pcsProps.put("PersistWriterJdbc.jdbcUrl", this._pcsJdbcUrl_cbx.getEditor().getItem().toString());
                pcsProps.put("PersistWriterJdbc.jdbcUser", this._pcsJdbcUsername_txt.getText());
                pcsProps.put("PersistWriterJdbc.jdbcPasswd", this._pcsJdbcPassword_txt.getText());
                pcsProps.put("PersistWriterJdbc.startH2NetworkServer", this._pcsH2Option_startH2NetworkServer_chk.isSelected() + "");
            }
            pch = new PersistentCounterHandler();
            pch.init(pcsProps);
            if (pch.hasWriters()) {
                PersistentCounterHandler.setInstance(pch);
                pch.start();
                return true;
            }
            _logger.error((Object)"No writers installed to the PersistentCounterHandler.");
            return false;
        }
        catch (Exception e) {
            _logger.error((Object)"Problems initializing PersistentCounterHandler", (Throwable)e);
            return false;
        }
    }

    private boolean offlineConnect() {
        String jdbcDriver = this._offlineJdbcDriver_cbx.getEditor().getItem().toString();
        String jdbcUrl = this._offlineJdbcUrl_cbx.getEditor().getItem().toString();
        String jdbcUser = this._offlineJdbcUsername_txt.getText();
        String jdbcPasswd = this._offlineJdbcPassword_txt.getText();
        boolean startH2NetworkServer = this._offlineH2Option_startH2NwSrv_chk.isSelected();
        String configStr = "jdbcDriver='" + jdbcDriver + "', jdbcUrl='" + jdbcUrl + "', jdbcUser='" + jdbcUser + "', jdbcPasswd='*hidden*'.";
        _logger.info((Object)("Configuration for PersistReader component named 'PersistReader': " + configStr));
        if (jdbcDriver.equals("org.h2.Driver") && startH2NetworkServer) {
            try {
                _logger.info((Object)"Starting a H2 TCP server.");
                String[] args = new String[]{"-tcpAllowOthers"};
                Server h2ServerTcp = Server.createTcpServer((String[])args);
                h2ServerTcp.start();
                _logger.info((Object)("H2 TCP server, url='" + h2ServerTcp.getURL() + "', service='" + h2ServerTcp.getService() + "'."));
                _logger.info((Object)"Starting a H2 WEB server.");
                String[] argsWeb = new String[]{"-trace"};
                Server h2ServerWeb = Server.createWebServer((String[])argsWeb);
                h2ServerWeb.start();
                _logger.info((Object)("H2 WEB server, url='" + h2ServerWeb.getURL() + "', service='" + h2ServerWeb.getService() + "'."));
            }
            catch (SQLException e) {
                _logger.warn((Object)"Problem starting H2 network service", (Throwable)e);
            }
        }
        this._offlineConn = this.jdbcConnect(Version.getAppName(), jdbcDriver, jdbcUrl, jdbcUser, jdbcPasswd);
        if (this._offlineConn == null) {
            return false;
        }
        boolean isOfflineDb = PersistReader.isOfflineDb(this._offlineConn);
        if (!isOfflineDb) {
            try {
                this._offlineConn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this._offlineConn = null;
            String msg = "This is NOT a valid offline database. No " + Version.getAppName() + " system table exists.";
            if (jdbcDriver.equals("org.h2.Driver") && jdbcUrl.indexOf("IFEXISTS=TRUE") == -1) {
                msg = msg + " Please append ';IFEXISTS=TRUE' to the URL, this stops H2 to create an empty database if it didn't exist.";
            }
            _logger.error((Object)msg);
            JOptionPane.showMessageDialog(this, msg, "asemon - offline db check", 0);
            return false;
        }
        return this._offlineConn != null;
    }

    private Connection jdbcConnect(String appname, String driver, String url, String user, String passwd) {
        try {
            Class.forName(driver).newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            _logger.debug((Object)("getConnection to driver='" + driver + "', url='" + url + "', user='" + user + "'."));
            Connection conn = DriverManager.getConnection(url, props);
            return conn;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + sb.toString(), "asemon - jdbc connect", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + e.toString(), "asemon - jdbc connect", 0);
        }
        return null;
    }

    private boolean testJdbcConnection(String appname, String driver, String url, String user, String passwd) {
        try {
            Class.forName(driver).newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            _logger.debug((Object)("Try getConnection to driver='" + driver + "', url='" + url + "', user='" + user + "'."));
            Connection conn = DriverManager.getConnection(url, props);
            conn.close();
            JOptionPane.showMessageDialog(this, "Connection succeeded.", "asemon - connect check", 1);
            return true;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + sb.toString(), "asemon - connect check", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + e.toString(), "asemon - connect check", 0);
        }
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.validateContents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        String newUrl;
        String newFile;
        String currentUrl;
        H2UrlHelper h2help;
        File baseDir;
        JFileChooser fc;
        int returnVal;
        TableModel tm;
        String jdbcDriver;
        Object source = e.getSource();
        String action = e.getActionCommand();
        if (this._aseServer_cbx.equals(source)) {
            _logger.debug((Object)("_server_cbx.actionPerformed(): getSelectedIndex()='" + this._aseServer_cbx.getSelectedIndex() + "', getSelectedItem()='" + this._aseServer_cbx.getSelectedItem() + "'."));
            if (this._aseServer_cbx.getSelectedIndex() > 0) {
                String server = (String)this._aseServer_cbx.getSelectedItem();
                String hosts = AseConnectionFactory.getIHosts(server, ", ");
                String ports = AseConnectionFactory.getIPorts(server, ", ");
                String hostPortStr = AseConnectionFactory.getIHostPortStr(server);
                this._aseHost_txt.setText(hosts);
                this._asePort_txt.setText(ports);
                this.loadPropsForServer(hostPortStr);
            }
        }
        if (this._aseIfile_but.equals(source)) {
            JFileChooser fc2;
            int returnVal2;
            String dir = System.getProperty("SYBASE");
            if (dir == null) {
                dir = System.getenv("SYBASE");
            }
            if (dir != null && PlatformUtils.getCurrentPlattform() == 0) {
                dir = dir + "\\ini";
            }
            if ((returnVal2 = (fc2 = new JFileChooser(dir)).showOpenDialog(this)) == 0) {
                this._aseIfile_txt.setText(fc2.getSelectedFile().getAbsolutePath());
                this.loadNewInterfaces(this._aseIfile_txt.getText());
            }
        }
        if (this._aseIfile_txt.equals(source)) {
            this.loadNewInterfaces(this._aseIfile_txt.getText());
        }
        if (this._aseOptions_but.equals(source)) {
            Map<String, String> sendOpt = StringUtil.parseCommaStrToMap(this._aseOptions_txt.getText());
            Map<String, String> outOpt = JdbcOptionsDialog.showDialog(this, AseConnectionFactory.getDriver(), AseConnectionFactory.getUrlTemplate(), sendOpt);
            if (outOpt != null) {
                this._aseOptions_txt.setText(StringUtil.toCommaStr(outOpt));
            }
        }
        if (this._asePasswd_txt.equals(source)) {
            if (this._aseUser_txt.getText().trim().equals("") || this._aseHost_txt.getText().trim().equals("") || this._asePort_txt.getText().trim().equals("")) {
                this.setFocus();
            } else {
                this._ok.doClick();
            }
        }
        if (this._aseOptionStore_chk.equals(source)) {
            this.toggleCounterStorageTab();
        }
        if (this._aseHostMonitor_chk.equals(source)) {
            this.toggleHostmonTab();
        }
        if (this._pcsJdbcDriver_cbx.equals(source)) {
            jdbcDriver = this._pcsJdbcDriver_cbx.getEditor().getItem().toString();
            if ("org.h2.Driver".equals(jdbcDriver)) {
                this._pcsH2Option_startH2NetworkServer_chk.setVisible(true);
            } else {
                this._pcsH2Option_startH2NetworkServer_chk.setVisible(false);
            }
        }
        if (this._pcsTestConn_but.equals(source)) {
            this.testJdbcConnection("testConnect", this._pcsJdbcDriver_cbx.getEditor().getItem().toString(), this._pcsJdbcUrl_cbx.getEditor().getItem().toString(), this._pcsJdbcUsername_txt.getText(), this._pcsJdbcPassword_txt.getText());
        }
        if (this._pcsTabSelectAll_but.equals(source)) {
            tm = this._pcsSessionTable.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                tm.setValueAt(new Boolean(true), r, 3);
            }
        }
        if (this._pcsTabDeSelectAll_but.equals(source)) {
            tm = this._pcsSessionTable.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                tm.setValueAt(new Boolean(false), r, 3);
                tm.setValueAt(new Integer(0), r, 2);
            }
        }
        if (this._pcsTabTemplate_but.equals(source)) {
            this.setToTemplate();
        }
        if (this._pcsJdbcUrl_but.equals(source) && (returnVal = (fc = new JFileChooser(baseDir = (h2help = new H2UrlHelper(currentUrl = this._pcsJdbcUrl_cbx.getEditor().getItem().toString())).getDir(System.getProperty("ASEMON_SAVE_DIR")))).showOpenDialog(this)) == 0) {
            newFile = fc.getSelectedFile().getAbsolutePath().replace('\\', '/');
            newUrl = h2help.getNewUrl(newFile);
            this._pcsJdbcUrl_cbx.getEditor().setItem(newUrl);
        }
        if (this._offlineJdbcDriver_cbx.equals(source)) {
            jdbcDriver = this._offlineJdbcDriver_cbx.getEditor().getItem().toString();
            if ("org.h2.Driver".equals(jdbcDriver)) {
                this._offlineH2Option_startH2NwSrv_chk.setVisible(true);
            } else {
                this._offlineH2Option_startH2NwSrv_chk.setVisible(false);
            }
        }
        if (this._offlineJdbcUrl_but.equals(source) && ((url = this._offlineJdbcUrl_cbx.getEditor().getItem().toString()).startsWith("jdbc:h2:file:") || url.startsWith("jdbc:h2:tcp:") || url.startsWith("jdbc:h2:zip:")) && (returnVal = (fc = new JFileChooser(baseDir = (h2help = new H2UrlHelper(url)).getDir(System.getProperty("ASEMON_SAVE_DIR")))).showOpenDialog(this)) == 0) {
            newFile = fc.getSelectedFile().getAbsolutePath().replace('\\', '/');
            newUrl = h2help.getNewUrl(newFile);
            this._offlineJdbcUrl_cbx.getEditor().setItem(newUrl);
        }
        if (this._offlineTestConn_but.equals(source)) {
            this.testJdbcConnection("testConnect", this._offlineJdbcDriver_cbx.getEditor().getItem().toString(), this._offlineJdbcUrl_cbx.getEditor().getItem().toString(), this._offlineJdbcUsername_txt.getText(), this._offlineJdbcPassword_txt.getText());
        }
        if (this._cancel.equals(source) || ACTION_CANCEL.equals(action)) {
            if (this._aseConn != null) {
                try {
                    this._aseConn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            if (PersistentCounterHandler.hasInstance()) {
                PersistentCounterHandler.getInstance().stop();
                PersistentCounterHandler.setInstance(null);
            }
            if (this._offlineConn != null) {
                try {
                    this._offlineConn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            this._connectionType = 0;
            this.setVisible(false);
        }
        if (this._ok.equals(source) || ACTION_OK.equals(action)) {
            if (this.isVisible()) {
                this.saveProps();
            }
            if (this._tab.getSelectedIndex() == 3) {
                if (this._offlineConn == null && !this.offlineConnect()) {
                    return;
                }
                this._connectionType = 2;
                this.setVisible(false);
            } else {
                if (this._aseOptionStore_chk.isSelected()) {
                    if (!this.pcsConnect()) {
                        return;
                    }
                    if (this._useCmForPcsTable) {
                        for (int r = 0; r < this._pcsSessionTable.getRowCount(); ++r) {
                            for (CountersModel cm : GetCounters.getCmList()) {
                                String rowName = (String)this._pcsSessionTable.getValueAt(r, 8);
                                Integer pcsPostpone = (Integer)this._pcsSessionTable.getValueAt(r, 2);
                                boolean pcsStore = (Boolean)this._pcsSessionTable.getValueAt(r, 3);
                                boolean pcsStoreAbs = (Boolean)this._pcsSessionTable.getValueAt(r, 4);
                                boolean pcsStoreDiff = (Boolean)this._pcsSessionTable.getValueAt(r, 5);
                                boolean pcsStoreRate = (Boolean)this._pcsSessionTable.getValueAt(r, 6);
                                String cmName = cm.getName();
                                if (!cmName.equals(rowName)) continue;
                                cm.setPersistCounters(pcsStore, true);
                                cm.setPersistCountersAbs(pcsStoreAbs, true);
                                cm.setPersistCountersDiff(pcsStoreDiff, true);
                                cm.setPersistCountersRate(pcsStoreRate, true);
                                cm.setPostponeTime(pcsPostpone, true);
                            }
                        }
                    } else {
                        for (int r = 0; r < this._pcsSessionTable.getRowCount(); ++r) {
                            String rowName = (String)this._pcsSessionTable.getValueAt(r, 8);
                            Integer pcsPostpone = (Integer)this._pcsSessionTable.getValueAt(r, 2);
                            boolean pcsStore = (Boolean)this._pcsSessionTable.getValueAt(r, 3);
                            boolean pcsStoreAbs = (Boolean)this._pcsSessionTable.getValueAt(r, 4);
                            boolean pcsStoreDiff = (Boolean)this._pcsSessionTable.getValueAt(r, 5);
                            boolean pcsStoreRate = (Boolean)this._pcsSessionTable.getValueAt(r, 6);
                            System.out.println("OK: name=" + StringUtil.left(rowName, 25) + ", store=" + pcsStore + ", abs=" + pcsStoreAbs + ", diff=" + pcsStoreDiff + ", rate=" + pcsStoreRate + ", postpone=" + pcsPostpone + ".");
                        }
                    }
                }
                if (this._aseHostMonitor_chk.isSelected()) {
                    this._sshConn = this.hostmonCreateConnectionObject();
                }
                if (this._aseConn == null) {
                    boolean ok = this.aseConnect();
                    if (this._sshConn != null && !this._sshConn.isConnected()) {
                        this._sshConn.close();
                        this._sshConn = null;
                    }
                    if (!ok) {
                        return;
                    }
                }
                this._connectionType = 1;
                this.setVisible(false);
            }
        }
        if (this._aseMonUrl_txt.equals(source)) {
            try {
                AseUrlHelper aseUrl = AseUrlHelper.parseUrl(this._aseMonUrl_txt.getText());
                this._aseHost_txt.setText(aseUrl.getHosts());
                this._asePort_txt.setText(aseUrl.getPorts());
                this._aseOptions_txt.setText(aseUrl.getOptions());
                String serverName = aseUrl.getServerName();
                if (serverName == null) {
                    this._aseServer_cbx.setSelectedIndex(0);
                    String host = this._aseHost_txt.getText();
                    String portStr = this._asePort_txt.getText();
                    this._aseServer_cbx.updateFirstEntry(host, portStr);
                } else {
                    this._aseServer_cbx.setSelectedItem(serverName);
                }
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        this.setUrlText();
        this.validateContents();
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
        char ch;
        if (keyevent.getSource().equals(this._asePort_txt) && !Character.isDigit(ch = keyevent.getKeyChar()) && ch != ',' && ch != ' ') {
            keyevent.consume();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
        if (keyevent.getSource().equals(this._aseHost_txt) || keyevent.getSource().equals(this._asePort_txt)) {
            String hosts = this._aseHost_txt.getText();
            String ports = this._asePort_txt.getText();
            this._aseServer_cbx.updateFirstEntry(hosts, ports);
        }
        this.validateContents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String oshost;
        if (this._aseHostMonitor_chk.isSelected() && (oshost = this._hostmonHost_txt.getText().trim()).equals("")) {
            String[] hosts;
            String oshostname = "";
            for (String host : hosts = StringUtil.commaStrToArray(this._aseHost_txt.getText())) {
                if (host.equals("localhost") || host.equals("127.0.0.1")) continue;
                oshostname = host;
                break;
            }
            this._hostmonHost_txt.setText(oshostname);
        }
        this.validateContents();
    }

    private void setToTemplate() {
        TableModel tm = this._pcsSessionTable.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String cmName = (String)tm.getValueAt(r, 8);
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm == null) continue;
            tm.setValueAt(new Integer(cm.getPostponeTime()), r, 2);
            tm.setValueAt(new Boolean(cm.isPersistCountersEnabled() || cm.isBackgroundDataPollingEnabled()), r, 3);
            tm.setValueAt(new Boolean(cm.isPersistCountersAbsEnabled()), r, 4);
            tm.setValueAt(new Boolean(cm.isPersistCountersDiffEnabled()), r, 5);
            tm.setValueAt(new Boolean(cm.isPersistCountersRateEnabled()), r, 6);
        }
    }

    private void setUrlText() {
        if (this._aseMonUrl_chk.isSelected()) {
            this._aseMonUrl_txt.setEnabled(true);
            this._aseServer_cbx.setEnabled(false);
            this._aseHost_txt.setEnabled(false);
            this._asePort_txt.setEnabled(false);
            this._aseOptions_txt.setEnabled(false);
            this._aseOptions_but.setEnabled(false);
            this._aseIfile_txt.setEnabled(false);
            this._aseIfile_but.setEnabled(false);
            return;
        }
        this._aseMonUrl_txt.setEnabled(false);
        this._aseServer_cbx.setEnabled(true);
        this._aseHost_txt.setEnabled(true);
        this._asePort_txt.setEnabled(true);
        this._aseOptions_txt.setEnabled(true);
        this._aseOptions_but.setEnabled(true);
        this._aseIfile_txt.setEnabled(true);
        this._aseIfile_but.setEnabled(true);
        String[] hosts = StringUtil.commaStrToArray(this._aseHost_txt.getText());
        String[] ports = StringUtil.commaStrToArray(this._asePort_txt.getText());
        if (hosts.length != ports.length) {
            return;
        }
        String hostPortStr = "";
        for (int i = 0; i < hosts.length; ++i) {
            hostPortStr = hostPortStr + hosts[i] + ":" + ports[i] + ",";
        }
        if (hostPortStr.endsWith(",")) {
            hostPortStr = hostPortStr.substring(0, hostPortStr.length() - 1);
        }
        Map<String, List<String>> hostPortMap = StringUtil.parseCommaStrToMultiMap(hostPortStr, ":", ",");
        Map<String, String> optionsMap = StringUtil.parseCommaStrToMap(this._aseOptions_txt.getText());
        String url = AseUrlHelper.buildUrlString(hostPortMap, null, optionsMap);
        this._aseMonUrl_txt.setText(url);
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        String hostPort = AseConnectionFactory.toHostPortStr(this._aseHost_txt.getText(), this._asePort_txt.getText());
        conf.setProperty("conn.interfaces", this._aseIfile_txt.getText());
        conf.setProperty("conn.serverName", this._aseServer_cbx.getSelectedItem().toString());
        conf.setProperty("conn.hostname", this._aseHost_txt.getText());
        conf.setProperty("conn.port", this._asePort_txt.getText());
        conf.setProperty("conn.username", this._aseUser_txt.getText());
        conf.setProperty("conn.username." + hostPort, this._aseUser_txt.getText());
        if (this._aseOptionSavePwd_chk.isSelected()) {
            conf.setEncrypedProperty("conn.password", this._asePasswd_txt.getText());
            conf.setEncrypedProperty("conn.password." + hostPort, this._asePasswd_txt.getText());
        } else {
            conf.remove("conn.password");
            conf.remove("conn.password." + hostPort);
        }
        conf.setProperty("conn.url.raw", this._aseMonUrl_txt.getText());
        conf.setProperty("conn.url.raw.checkbox", this._aseMonUrl_chk.isSelected());
        conf.setProperty("conn.url.options", this._aseOptions_txt.getText());
        conf.setProperty("conn.savePassword", this._aseOptionSavePwd_chk.isSelected());
        conf.setProperty(CONF_OPTION_CONNECT_ON_STARTUP, this._aseOptionConnOnStart_chk.isSelected());
        conf.setProperty(CONF_OPTION_RECONNECT_ON_FAILURE, this._aseOptionReConnOnFailure_chk.isSelected());
        conf.setProperty("conn.persistCounterStorage", this._aseOptionStore_chk.isSelected());
        conf.setProperty("conn.hostMonitoring", this._aseHostMonitor_chk.isSelected());
        if (this._aseHostMonitor_chk.isSelected()) {
            conf.setProperty("ssh.conn.hostname." + hostPort, this._hostmonHost_txt.getText());
            conf.setProperty("ssh.conn.port." + hostPort, this._hostmonPort_txt.getText());
            conf.setProperty("ssh.conn.username." + hostPort, this._hostmonUser_txt.getText());
            if (this._hostmonOptionSavePwd_chk.isSelected()) {
                conf.setEncrypedProperty("ssh.conn.password." + hostPort, this._hostmonPasswd_txt.getText());
            } else {
                conf.remove("ssh.conn.password." + hostPort);
            }
            conf.setProperty("ssh.conn.savePassword", this._hostmonOptionSavePwd_chk.isSelected());
        }
        if (this._aseOptionStore_chk.isSelected()) {
            conf.setProperty("pcs.write.writerClass", this._pcsWriter_cbx.getEditor().getItem().toString());
            conf.setProperty("pcs.write.jdbcDriver", this._pcsJdbcDriver_cbx.getEditor().getItem().toString());
            conf.setProperty("pcs.write.jdbcUrl", this._pcsJdbcUrl_cbx.getEditor().getItem().toString());
            conf.setProperty("pcs.write.jdbcUser", this._pcsJdbcUsername_txt.getText());
            conf.setEncrypedProperty("pcs.write.jdbcPasswd", this._pcsJdbcPassword_txt.getText());
            if (this._pcsH2Option_startH2NetworkServer_chk.isVisible()) {
                conf.setProperty("pcs.write.h2.startH2NetworkServer", this._pcsH2Option_startH2NetworkServer_chk.isSelected());
            } else {
                conf.setProperty("pcs.write.h2.startH2NetworkServer", false);
            }
        }
        conf.setProperty("pcs.read.jdbcDriver", this._offlineJdbcDriver_cbx.getEditor().getItem().toString());
        conf.setProperty("pcs.read.jdbcUrl", this._offlineJdbcUrl_cbx.getEditor().getItem().toString());
        conf.setProperty("pcs.read.jdbcUser", this._offlineJdbcUsername_txt.getText());
        conf.setEncrypedProperty("pcs.read.jdbcPasswd", this._offlineJdbcPassword_txt.getText());
        conf.setProperty("pcs.read.checkForNewSessions", this._offlineCheckForNewSessions_chk.isSelected());
        if (this._offlineH2Option_startH2NwSrv_chk.isVisible()) {
            conf.setProperty("pcs.read.h2.startH2NetworkServer", this._offlineH2Option_startH2NwSrv_chk.isSelected());
        } else {
            conf.setProperty("pcs.read.h2.startH2NetworkServer", false);
        }
        conf.setProperty("conn.dialog.window.width", this.getSize().width);
        conf.setProperty("conn.dialog.window.height", this.getSize().height);
        conf.setProperty("conn.dialog.window.pos.x", this.getLocationOnScreen().x);
        conf.setProperty("conn.dialog.window.pos.y", this.getLocationOnScreen().y);
        conf.save();
    }

    private void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        String str = null;
        boolean bol = false;
        str = conf.getProperty("conn.interfaces");
        if (str != null) {
            this.loadNewInterfaces(str);
        }
        if ((str = conf.getProperty("conn.serverName")) != null) {
            this._aseServer_cbx.setSelectedItem(str);
        }
        if ((str = conf.getProperty("conn.hostname")) != null) {
            this._aseHost_txt.setText(str);
        }
        if ((str = conf.getProperty("conn.port")) != null) {
            this._asePort_txt.setText(str);
        }
        if ((str = conf.getProperty("conn.url.options")) != null) {
            this._aseOptions_txt.setText(str);
        }
        if ((str = conf.getProperty("conn.url.raw")) != null) {
            this._aseMonUrl_txt.setText(str);
        }
        bol = conf.getBooleanProperty("conn.url.raw.checkbox", false);
        this._aseMonUrl_chk.setSelected(bol);
        if (this._aseMonUrl_chk.isSelected()) {
            try {
                AseUrlHelper aseUrl = AseUrlHelper.parseUrl(this._aseMonUrl_txt.getText());
                this._aseHost_txt.setText(aseUrl.getHosts());
                this._asePort_txt.setText(aseUrl.getPorts());
                this._aseOptions_txt.setText(aseUrl.getOptions());
                String serverName = aseUrl.getServerName();
                if (serverName == null) {
                    this._aseServer_cbx.setSelectedIndex(0);
                    String host = this._aseHost_txt.getText();
                    String portStr = this._asePort_txt.getText();
                    this._aseServer_cbx.updateFirstEntry(host, portStr);
                } else {
                    this._aseServer_cbx.setSelectedItem(serverName);
                }
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        String hostPort = AseConnectionFactory.toHostPortStr(this._aseHost_txt.getText(), this._asePort_txt.getText());
        this.loadPropsForServer(hostPort);
        bol = conf.getBooleanProperty("conn.savePassword", true);
        this._aseOptionSavePwd_chk.setSelected(bol);
        bol = conf.getBooleanProperty(CONF_OPTION_CONNECT_ON_STARTUP, false);
        this._aseOptionConnOnStart_chk.setSelected(bol);
        bol = conf.getBooleanProperty(CONF_OPTION_RECONNECT_ON_FAILURE, true);
        this._aseOptionReConnOnFailure_chk.setSelected(bol);
        bol = conf.getBooleanProperty("conn.persistCounterStorage", false);
        this._aseOptionStore_chk.setSelected(bol);
        bol = conf.getBooleanProperty("conn.hostMonitoring", false);
        this._aseHostMonitor_chk.setSelected(bol);
        bol = conf.getBooleanProperty("ssh.conn.savePassword", true);
        this._hostmonOptionSavePwd_chk.setSelected(bol);
        str = conf.getProperty("pcs.write.writerClass");
        if (str != null) {
            this._pcsWriter_cbx.setSelectedItem(str);
        }
        if ((str = conf.getProperty("pcs.write.jdbcDriver")) != null) {
            this._pcsJdbcDriver_cbx.setSelectedItem(str);
        }
        if ("org.h2.Driver".equals(str)) {
            this._pcsH2Option_startH2NetworkServer_chk.setVisible(true);
        }
        if ((str = conf.getPropertyRaw("pcs.write.jdbcUrl")) != null) {
            this._pcsJdbcUrl_cbx.setSelectedItem(str);
        }
        if ((str = conf.getProperty("pcs.write.jdbcUser")) != null) {
            this._pcsJdbcUsername_txt.setText(str);
        }
        if ((str = conf.getProperty("pcs.write.jdbcPasswd")) != null) {
            this._pcsJdbcPassword_txt.setText(str);
        }
        bol = conf.getBooleanProperty("pcs.write.h2.startH2NetworkServer", false);
        this._pcsH2Option_startH2NetworkServer_chk.setSelected(bol);
        str = conf.getProperty("pcs.read.jdbcDriver");
        if (str != null) {
            this._offlineJdbcDriver_cbx.setSelectedItem(str);
        }
        if ("org.h2.Driver".equals(str)) {
            this._offlineH2Option_startH2NwSrv_chk.setVisible(true);
        }
        if ((str = conf.getProperty("pcs.read.jdbcUrl")) != null) {
            this._offlineJdbcUrl_cbx.setSelectedItem(str);
        }
        if ((str = conf.getProperty("pcs.read.jdbcUser")) != null) {
            this._offlineJdbcUsername_txt.setText(str);
        }
        if ((str = conf.getProperty("pcs.read.jdbcPasswd")) != null) {
            this._offlineJdbcPassword_txt.setText(str);
        }
        bol = conf.getBooleanProperty("pcs.read.checkForNewSessions", true);
        this._offlineCheckForNewSessions_chk.setSelected(bol);
        bol = conf.getBooleanProperty("pcs.read.h2.startH2NetworkServer", false);
        this._offlineH2Option_startH2NwSrv_chk.setSelected(bol);
    }

    private void getSavedWindowProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        int width = conf.getIntProperty("conn.dialog.window.width", 510);
        int height = conf.getIntProperty("conn.dialog.window.height", 645);
        int x = conf.getIntProperty("conn.dialog.window.pos.x", -1);
        int y = conf.getIntProperty("conn.dialog.window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        }
    }

    private void loadPropsForServer(String hostPortStr) {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        String str = null;
        str = conf.getProperty("conn.username." + hostPortStr);
        if (str != null) {
            this._aseUser_txt.setText(str);
        } else {
            str = conf.getProperty("conn.username");
            if (str != null) {
                this._aseUser_txt.setText(str);
            }
        }
        str = conf.getProperty("conn.password." + hostPortStr);
        if (str != null) {
            this._asePasswd_txt.setText(str);
        } else {
            str = conf.getProperty("conn.password");
            if (str != null) {
                this._asePasswd_txt.setText(str);
            }
        }
        str = conf.getProperty("ssh.conn.username." + hostPortStr, "");
        this._hostmonUser_txt.setText(str);
        str = conf.getProperty("ssh.conn.password." + hostPortStr, "");
        this._hostmonPasswd_txt.setText(str);
        str = conf.getProperty("ssh.conn.hostname." + hostPortStr, "");
        this._hostmonHost_txt.setText(str);
        str = conf.getProperty("ssh.conn.port." + hostPortStr, "22");
        this._hostmonPort_txt.setText(str);
    }

    public Configuration getAseOptions() {
        Configuration conf = new Configuration();
        conf.setProperty(CONF_OPTION_CONNECT_ON_STARTUP, this._aseOptionConnOnStart_chk.isSelected());
        conf.setProperty(CONF_OPTION_RECONNECT_ON_FAILURE, this._aseOptionReConnOnFailure_chk.isSelected());
        return conf;
    }

    public static void main(String[] args) {
        String CONFIG_FILE_NAME = System.getProperty("CONFIG_FILE_NAME", "asemon.properties");
        String TMP_CONFIG_FILE_NAME = System.getProperty("TMP_CONFIG_FILE_NAME", "asemon.save.properties");
        String ASEMON_HOME = System.getProperty("ASEMON_HOME");
        String defaultPropsFile = ASEMON_HOME != null ? ASEMON_HOME + "/" + CONFIG_FILE_NAME : CONFIG_FILE_NAME;
        String defaultTmpPropsFile = Version.APP_STORE_DIR != null ? Version.APP_STORE_DIR + "/" + TMP_CONFIG_FILE_NAME : TMP_CONFIG_FILE_NAME;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf1 = new Configuration(defaultTmpPropsFile);
        Configuration.setInstance("USER_TEMP", conf1);
        Configuration conf2 = new Configuration(defaultPropsFile);
        Configuration.setInstance("SYSTEM_CONF", conf2);
        System.out.println("showAseOnlyConnectionDialog ...");
        Connection conn = ConnectionDialog.showAseOnlyConnectionDialog(null);
        System.out.println("showAseOnlyConnectionDialog, returned: conn=" + conn);
        ConnectionDialog connDialog = new ConnectionDialog(null, false, true, true, false, false, false);
        connDialog.setVisible(true);
        connDialog.dispose();
        int connType = connDialog.getConnectionType();
        if (connType == 0) {
            System.out.println("---CANCEL...");
        }
        if (connType == 1) {
            System.out.println("---ASE connection...");
            Connection aseConn = connDialog.getAseConn();
            PersistentCounterHandler pcsWriter = PersistentCounterHandler.getInstance();
            if (aseConn != null) {
                System.out.println("- has ASE connection");
            } else {
                System.out.println("- no  ASE connection");
            }
            if (pcsWriter != null) {
                System.out.println("- has PCS Handler");
            } else {
                System.out.println("- no  PCS Handler");
            }
            Configuration options = connDialog.getAseOptions();
            System.out.println("- OPTIONS: " + options);
        }
        if (connType == 2) {
            System.out.println("---OFFLINE connection...");
            Connection offlineConn = connDialog.getOfflineConn();
            if (offlineConn != null) {
                System.out.println("- has OFFLINE connection");
            } else {
                System.out.println("- no  OFFLINE connection");
            }
        }
    }

    protected class LocalSrvComboBox
    extends JComboBox {
        private static final long serialVersionUID = 7884363654457237606L;
        private static final String SERVER_FIRST_ENTRY = "-CHOOSE A SERVER-";
        private LocalSrvComboBoxModel _model = new LocalSrvComboBoxModel(new Vector<String>());

        protected LocalSrvComboBox() {
            this.setModel(this._model);
        }

        public void refresh() {
            this.removeAllItems();
            this.addItem(SERVER_FIRST_ENTRY);
            String[] servers = AseConnectionFactory.getIServerNames();
            if (servers != null) {
                for (int i = 0; i < servers.length; ++i) {
                    this.addItem(servers[i]);
                }
                this.setSelectedItem(SERVER_FIRST_ENTRY);
            }
        }

        public void updateFirstEntry(String hostStr, String portStr) {
            String hostAndPort = AseConnectionFactory.toHostPortStr(hostStr, portStr);
            if (hostAndPort.equals(":")) {
                this._model.set(0, SERVER_FIRST_ENTRY);
                this.setForeground(Color.BLACK);
                this.setSelectedIndex(0);
                return;
            }
            String server = AseConnectionFactory.getIServerName(hostAndPort);
            if (server == null || server != null && server.trim().equals("")) {
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("hostPort='" + hostAndPort + "' was NOT FOUND."));
                }
                this._model.set(0, hostAndPort);
                this.setSelectedIndex(0);
                this.setForeground(Color.BLUE);
            } else {
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("Found='" + server + "' for hostPort='" + hostAndPort + "'."));
                }
                if (!server.equals(this.getSelectedItem())) {
                    this._model.set(0, SERVER_FIRST_ENTRY);
                    this.setForeground(Color.BLACK);
                    this.setSelectedItem(server);
                }
            }
        }

        private class LocalSrvComboBoxModel
        extends DefaultComboBoxModel {
            private static final long serialVersionUID = -318689353529705207L;
            private Vector<String> _data;

            LocalSrvComboBoxModel(Vector<String> v) {
                super(v);
                this._data = v;
            }

            protected void set(int index, String str) {
                this._data.set(index, str);
                this.fireContentsChanged(str, index, index);
            }
        }
    }
}

