/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class ParameterDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6264488571520005143L;
    private Map<String, String> _inputMap = null;
    private Map<String, String> _outputMap = null;
    private Map<String, JTextField> _componentMap = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private boolean _showApply = true;
    private ActionListener _actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            ParameterDialog.this.checkForChanges();
        }
    };
    private KeyListener _keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyevent) {
        }

        @Override
        public void keyTyped(KeyEvent keyevent) {
        }

        @Override
        public void keyReleased(KeyEvent keyevent) {
            ParameterDialog.this.checkForChanges();
        }
    };

    private ParameterDialog(Frame owner, String title, LinkedHashMap<String, String> input, boolean showApply) {
        super(owner, title, true);
        this._showApply = showApply;
        this._inputMap = input;
        this.initComponents();
        this.pack();
    }

    public static Map<String, String> showParameterDialog(Frame owner, String title, LinkedHashMap<String, String> input, boolean showApply) {
        ParameterDialog params = new ParameterDialog(owner, title, input, showApply);
        params.setLocationRelativeTo(owner);
        params.setVisible(true);
        params.dispose();
        return params._outputMap;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 20 20", "[][grow]", ""));
        this._componentMap = new LinkedHashMap<String, JTextField>();
        for (Map.Entry<String, String> entry : this._inputMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            JLabel label = new JLabel(key);
            JTextField comp = new JTextField(value);
            comp.addActionListener(this._actionListener);
            comp.addKeyListener(this._keyListener);
            this._componentMap.put(key, comp);
            panel.add((Component)label, "");
            panel.add((Component)comp, "grow, wrap");
        }
        panel.add((Component)this._ok, "tag ok,     gap top 20, skip, split, bottom, right, push");
        panel.add((Component)this._cancel, "tag cancel,                   split, bottom");
        if (this._showApply) {
            panel.add((Component)this._apply, "tag apply,                    split, bottom");
        }
        this._apply.setEnabled(false);
        this.setContentPane(panel);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
    }

    private void apply() {
        this._apply.setEnabled(false);
        this._outputMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, JTextField> entry : this._componentMap.entrySet()) {
            String key = entry.getKey();
            JTextField value = entry.getValue();
            this._outputMap.put(key, value.getText());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._ok.equals(source)) {
            this.apply();
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.apply();
        }
    }

    private void checkForChanges() {
        boolean enabled = false;
        for (Map.Entry<String, JTextField> entry : this._componentMap.entrySet()) {
            String valueIn;
            String key = entry.getKey();
            String valueNow = entry.getValue().getText();
            if (valueNow.equals(valueIn = this._inputMap.get(key))) continue;
            enabled = true;
            break;
        }
        this._apply.setEnabled(enabled);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LinkedHashMap<String, String> in = new LinkedHashMap<String, String>();
        in.put("Input Fileld One", "123");
        in.put("Ke theis", "1");
        in.put("And thrre", "nisse");
        in.put("Yupp", "kalle");
        Map<String, String> results = ParameterDialog.showParameterDialog(null, "Test Parameters", in, true);
        if (results == null) {
            System.out.println("Cancel");
        } else {
            for (Map.Entry<String, String> entry : results.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                System.out.println("key='" + key + "', val='" + val + "'.");
            }
        }
    }
}

